globals [our-current-screen
         screencounter
         screenticker
         totaldirection?
         hearts
         octorokmoving?
         timer1
         keys
         whichkey?
         gotkeyone?
         gotkeytwo?
         gotkeythree?
         gotkeyfour?
         gotkeyfive?
         x
         y
         temp
         shape1
         score
         ]

turtles-own [identity]

to titlescreen
  ca
  import-drawing "title screen.png"
  wait 4
end
  
  


to start
  titlescreen
  ca
  reset-timer
  set hearts 3
  set keys 0
  set gotkeyone? "false"
  set gotkeytwo? "false"
  set gotkeythree? "false"
  set gotkeyfour? "false"
  set gotkeyfive? "false"
  set our-current-screen 1
  import-pcolors "screen1 world"
  fleshoutscreen
  createlink
  ask turtles with [identity = "hero"] [set shape "zelda forward"]
  
end

to createlink
  cro 1 [set identity "hero" set size 1.4 ]
end

to setup
  ask turtles with [shape = "octorok1" or shape = "octorok2"] [octorok]
  if hearts <= 0 [ca import-drawing "game over.png"]
  if keys = 5 [win]
end

to go
  ask turtles with [identity = "hero"] 
  [repeat 10 [fd .05 if any? other turtles in-cone 1 90 with 
    [shape = "water" 
      or shape = "octorok1" 
      or shape = "octorok2" 
      or shape = "treetex" 
      or shape = "littletreetex" 
      or shape = "rocktex" 
      or shape = "singlerock"
      or shape = "littledeadtreetex"
      or shape = "whitetreetex"
      or shape = "gravestone"
      or shape = "treestump"] [rt 180 fd .05 rt 180]] 
  if any? other turtles in-radius 1 with [shape = "octorok1" or shape = "octorok2"] [set hearts hearts - .5]
  if any? other turtles-here with [shape = "cave"][cave]
  if xcor >= 7.9 [set totaldirection? "right"]
  if xcor <= -7.9 [set totaldirection? "left"]
  if ycor >= 7.9 [set totaldirection? "up"]
  if ycor <= -7.9 [set totaldirection? "down"]]
end
 

to up
  if totaldirection? = "up" [totalup set totaldirection? "none"] 
  ask turtles with [identity = "hero"]
  [set heading 0
  set size 1.4
  set shape "zeldaup2"
  wait .07
  go
  set shape "zelda up"
  go if any? other turtles-here with [shape = "key"][getkey]
  setxy pxcor pycor; Thanks Mr. Brooks!
  ]
  
  
end


to down
  if totaldirection? = "down" [totaldown set totaldirection? "none"]
  ask turtles with [identity = "hero"]
  [set heading 180
    set size 1.4
    set shape "zelda forward"
    wait .07
    go
    set shape "zeldaforward2"
    go if any? other turtles-here with [shape = "key"][getkey]
    setxy pxcor pycor; Thanks Mr. Brooks!
    ]
end
  
  
to directionr

  if totaldirection? = "right" [totalright set totaldirection? "none"] 
  ask turtles with [identity = "hero"]
  [set heading 90
    set size 1
    set shape "zelda right"
    wait .07
    go
    set shape "zeldaright2"
    go if any? other turtles-here with [shape = "key"][getkey]
    setxy pxcor pycor; Thanks Mr. Brooks!
    ]
 

 
end 

to directionl
  if totaldirection? = "left" [totalleft set totaldirection? "none" stop] 
  ask turtles with [identity = "hero"]
  [set heading 270
    set size 1
    set shape "zelda left"
    wait .07
    go
    set shape "zeldaleft2"
    go if any? other turtles-here with [shape = "key"][getkey]
    setxy pxcor pycor; thanks Mr. Brooks
   ]
  
end
    
    
to movescreenright
  repeat 33 [if screenticker < 17 [
    ask turtles with [identity = "hero"] [if xcor <= -7.5 [set xcor -7]] 
    ask turtles with [identity = "hero"] [set xcor xcor - 1] 
    ask turtles with [hidden? = false and shape != "zelda right"] [if xcor <= -7.9 [die] set xcor xcor - 1]
    ask turtles with [hidden? = true and xcor = -8 + screenticker] [set xcor 8 show-turtle]
    set screenticker screenticker + 1
    set totaldirection? "none"
    wait .1
   ]]
  
end

to movescreenleft
 repeat 33 [if screenticker < 17 [
    ask turtles with [identity = "hero"] [if xcor >= 7.5 [set xcor 7]] 
    ask turtles with [identity = "hero"] [set xcor xcor + 1] 
    ask turtles with [hidden? = false and shape != "zelda left"] [if xcor >= 7.9 [die] set xcor xcor + 1 ]
    ask turtles with [hidden? = true and xcor = 8 - screenticker] [set xcor -8 show-turtle]
    set screenticker screenticker + 1
    set totaldirection? "none"
    wait .1
   ]]
end

to movescreenup
  repeat 33 [if screenticker < 17 [
    ask turtles with [identity = "hero"] [if ycor <= -7.5 [set ycor -7]] 
    ask turtles with [identity = "hero"] [set ycor ycor - 1] 
    ask turtles with [hidden? = false and shape != "zelda up"] [if ycor <= -7.9 [die] set ycor ycor - 1 ]
    ask turtles with [hidden? = true and ycor = -8 + screenticker] [set ycor 8 show-turtle]
    set screenticker screenticker + 1
    set totaldirection? "none"
    wait .1
   ]]
end

to movescreendown
  repeat 33 [if screenticker < 17 [
    ask turtles with [identity = "hero"] [if ycor >= 7.5 [set ycor 7]] 
    ask turtles with [identity = "hero"] [set ycor ycor + 1] 
    ask turtles with [hidden? = false and shape != "zelda forward"] [if ycor >= 7.9 [die] set ycor ycor + 1 ]
    ask turtles with [hidden? = true and ycor = 8 - screenticker] [set ycor -8 show-turtle]
    set screenticker screenticker + 1
    set totaldirection? "none"
    wait .1
   ]]
end

to cave
  ;
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ACTION

to swordattack
  ask turtles with [identity = "hero"] 
  [if shape = "zelda forward" or shape = "zeldaforward2" [
    set shape "forwardattack1"
    wait .03
    set shape "forwardattack2"
    ask patch xcor (ycor - 1) [sprout 1 [set shape "forwardattack2sword" wait .3 die] if any? other turtles in-radius .5 with [shape = "octorok1" or shape = "octorok2"] [set score score + 1 set hearts hearts + .5 ask other turtles in-radius .5 [die] ]]
    set shape "zelda forward"]
   if shape = "zelda up" or shape = "zeldaup2" [
     set shape "upattack1"
     wait .03
     set shape "upattack2"
     ask patch xcor (ycor + 1) [sprout 1 [set shape "upattack2sword" wait .3 die] if any? other turtles in-radius .5 with [shape = "octorok1" or shape = "octorok2"] [set score score + 1 set hearts hearts + .5 ask other turtles in-radius .5 [die] ]]
     set shape "zelda up"]
   if shape = "zelda right" or shape = "zeldaright2" [
     set shape "rightattack1"
     wait .03
     set shape "rightattack2"
     ask patch (xcor + 1) ycor [sprout 1 [set shape "rightattack2sword" wait .3 die] if any? other turtles in-radius .5 with [shape = "octorok1" or shape = "octorok2"] [set score score + 1 set hearts hearts + .5 ask other turtles in-radius .5 [die] ]]
     set shape "zelda right"]
   if shape = "zelda left" or shape = "zeldaleft2" [
     set shape "leftattack1"
     wait .03
     set shape "leftattack2"
     ask patch (xcor - 1) ycor [sprout 1 [set shape "leftattack2sword" wait .3 die] if any? other turtles in-radius .5 with [shape = "octorok1" or shape = "octorok2"] [set score score + 1 set hearts hearts + .5 ask other turtles in-radius .5 [die] ]]
     set shape "zelda left"
    ]
   
   
   ]
     
  end
    
    
to getkey ;key must be located in center of screen!!!
  set keys keys + 1 
  ask turtles with [shape = "key"][
    if whichkey? = "keyone" [set gotkeyone? "true"]
    if whichkey? = "keytwo" [set gotkeytwo? "true"]
    if whichkey? = "keythree" [set gotkeythree? "true"]
    if whichkey? = "keyfour" [set gotkeyfour? "true"]
    if whichkey? = "keyfive" [set gotkeyfive? "true"]
    die]
  ask turtles with [identity = "hero"][set shape "link gets key" ask patch 0 1 [sprout 1 [set shape "key"]]]
  wait 4
  ask turtles with [shape = "key"][die]
end
    
to win
 ask turtles [die]
 ask patches [set pcolor black]
 import-drawing "end.png"
end 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;INIMICOS

    
to octorok
set temp random 15000
ifelse temp = 1 [rt 90] [if temp = 0 [lt 90] 
if any? other turtles in-cone 1 90 or (abs pxcor = 15 or abs pycor = 15) [rt 180 fd .00055]
fd .00055 
 ]
end

to octorokfire
  ask-concurrent turtles with [shape = "octorok1" or shape = "octorok2" and (any? turtles in-cone 4 45 with [identity = "hero"] ) = true ]
        [if heading = 0 
         [ask patch xcor (ycor + 1) [sprout 1 [set shape "spitball" set heading 0 while [any? other turtles-here = false] [while [any? other turtles-here = false] [fd 1 wait .1]] die]]]
      if heading = 90 
         [ask patch (xcor + 1) ycor [sprout 1 [set shape "spitball" set heading 90 while [any? other turtles-here = false] [while [any? other turtles-here = false] [fd 1 wait .1]] die]]]
      if heading = 180
         [ask patch xcor (ycor - 1) [sprout 1 [set shape "spitball" set heading 180 while [any? other turtles-here = false] [while [any? other turtles-here = false] [fd 1 wait .1]] die]]]
      if heading = 270
         [ask patch (xcor - 1) ycor [sprout 1 [set shape "spitball" set heading 270 while [any? other turtles-here = false] [while [any? other turtles-here = false] [fd 1 wait .1]] die]]]
      ]
     
end
      
    
    
    
    
    

    
    
    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SCREENS/MAP & Screenmoving Mechanic
 
to fleshoutscreen
   ask patches [if pcolor = 55 [sprout 1 [set shape "treetex"]] 
               if pcolor = black [sprout 1 [set shape "cave"]]
               if pcolor = 25 [sprout 1 [set shape "littletreetex"]]
               if pcolor = 115 [sprout 1 [set shape "sidetreetex1"]] 
               if pcolor = 15 [sprout 1 [set shape "sidetreetex2"]]
               if pcolor = gray [sprout 1 [set shape "sidetreetex3"]]
               if pcolor = pink [sprout 1 [set shape "sidetreetex4"]]
               if pcolor = brown [sprout 1 [set shape "rocktex"]]
               if pcolor = 1 [sprout 1 [set shape "upslanteduprock"]]
               if pcolor = 2 [sprout 1 [set shape "upslanteddownrock"]]
               if pcolor = 3 [sprout 1 [set shape "downslanteduprock"]]
               if pcolor = 4 [sprout 1 [set shape "downslanteddownrock"]]
               if pcolor = yellow [sprout 1 [set shape "singlerock"]]
               if pcolor = 11 [sprout 1 [set shape "octorok1" let quarterchance random 4
                                                                    if quarterchance = 0 [set heading 0] 
                                                                    if quarterchance = 1 [set heading 90]
                                                                    if quarterchance = 2 [set heading 180]
                                                                    if quarterchance = 3 [set heading 270]]]
               if pcolor = blue [sprout 1 [set shape "water"]]
               if pcolor = 17 [sprout 1 [set shape "wateredgeright"]]
               if pcolor = 16 [sprout 1 [set shape "wateredgeleft"]]
               if pcolor = 13 [sprout 1 [set shape "wateredgetop"]]
               if pcolor = 14 [sprout 1 [set shape "wateredgebottom"]]
               if pcolor = 111 [sprout 1 [set shape "bridge"]]
               if pcolor = 112 [sprout 1 [set shape "stair"]]
               if pcolor = 113 [sprout 1 [set shape "littledeadtreetex"]]
               if pcolor = 114 [if gotkeyone? = "false" [sprout 1 [set shape "key" set whichkey? "keyone"]]]
               if pcolor = 119 [if gotkeytwo? = "false" [sprout 1 [set shape "key" set whichkey? "keytwo"]]]
               if pcolor = 116 [if gotkeythree? = "false" [sprout 1 [set shape "key" set whichkey? "keythree"]]]
               if pcolor = 117 [if gotkeyfour? = "false" [sprout 1 [set shape "key" set whichkey? "keyfour"]]]
               if pcolor = 118 [if gotkeyfive? = "false" [sprout 1 [set shape "key" set whichkey? "keyfive"]]]
               if pcolor = 122 [sprout 1 [set shape "whitetreetex"]]
               if pcolor = 123 [sprout 1 [set shape "gravestone"]]
               if pcolor = 124 [sprout 1 [set shape "treestump" set size 1.5]]
               set pcolor 28.6]
   
end

  

to currentscreen
  
  if our-current-screen = 1 [import-pcolors "screen1 world" set screencounter 1]
  if our-current-screen = 2 [import-pcolors "screen2 world" set screencounter 2]
  if our-current-screen = 3 [import-pcolors "screen3 world" set screencounter 3]
  if our-current-screen = 4 [import-pcolors "screen4 world" set screencounter 4]
  if our-current-screen = 5 [import-pcolors "screen5 world" set screencounter 5]
  if our-current-screen = 6 [import-pcolors "screen6 world" set screencounter 6]
  if our-current-screen = 7 [import-pcolors "screen7 world" set screencounter 7]
  if our-current-screen = 8 [import-pcolors "screen8 world" set screencounter 8]
  if our-current-screen = 9 [import-pcolors "screen9 world" set screencounter 9]
  if our-current-screen = 10 [import-pcolors "screen10 world" set screencounter 10]
  if our-current-screen = 11 [import-pcolors "screen11 world" set screencounter 11]
  if our-current-screen = 12 [import-pcolors "screen12 world" set screencounter 12]
  if our-current-screen = 13 [import-pcolors "screen13 world" set screencounter 13]
  if our-current-screen = 14 [import-pcolors "screen14 world" set screencounter 14]
  if our-current-screen = 15 [import-pcolors "screen15 world" set screencounter 15]
  if our-current-screen = 16 [import-pcolors "screen16 world" set screencounter 16]
  if our-current-screen = 17 [import-pcolors "screen17 world" set screencounter 17]
  if our-current-screen = 18 [import-pcolors "screen18 world" set screencounter 18]
  if our-current-screen = 19 [import-pcolors "screen19 world" set screencounter 19]
  if our-current-screen = 20 [import-pcolors "screen20 world" set screencounter 20]
  if our-current-screen = 21 [import-pcolors "screen21 world" set screencounter 21]
  if our-current-screen = 22 [import-pcolors "screen22 world" set screencounter 22]
  if our-current-screen = 23 [import-pcolors "screen23 world" set screencounter 23]
  if our-current-screen = 24 [import-pcolors "screen24 world" set screencounter 24]
  if our-current-screen = 25 [import-pcolors "screen25 world" set screencounter 25]
  if our-current-screen = 26 [import-pcolors "screen26 world" set screencounter 26]
  if our-current-screen = 27 [import-pcolors "screen27 world" set screencounter 27]
  if our-current-screen = 28 [import-pcolors "screen28 world" set screencounter 28]
  if our-current-screen = 29 [import-pcolors "screen29 world" set screencounter 29]
  if our-current-screen = 30 [import-pcolors "screen30 world" set screencounter 30]
  if our-current-screen = 31 [import-pcolors "screen31 world" set screencounter 31]
  if our-current-screen = 32 [import-pcolors "screen32 world" set screencounter 32]
  if our-current-screen = 33 [import-pcolors "screen33 world" set screencounter 33]
  if our-current-screen = 34 [import-pcolors "screen34 world" set screencounter 34]
  if our-current-screen = 35 [import-pcolors "screen35 world" set screencounter 35]
  if our-current-screen = 36 [import-pcolors "screen36 world" set screencounter 36]
  if our-current-screen = 37 [import-pcolors "screen37 world" set screencounter 37]
  if our-current-screen = 38 [import-pcolors "screen38 world" set screencounter 38]
  if our-current-screen = 39 [import-pcolors "screen39 world" set screencounter 39]
  if our-current-screen = 40 [import-pcolors "screen40 world" set screencounter 40]
  if our-current-screen = 41 [import-pcolors "screen41 world" set screencounter 41]
  if our-current-screen = 42 [import-pcolors "screen42 world" set screencounter 42]
  if our-current-screen = 43 [import-pcolors "screen43 world" set screencounter 43]
  if our-current-screen = 44 [import-pcolors "screen44 world" set screencounter 44]
  if our-current-screen = 45 [import-pcolors "screen45 world" set screencounter 45]
  if our-current-screen = 46 [import-pcolors "screen46 world" set screencounter 46]
  if our-current-screen = 47 [import-pcolors "screen47 world" set screencounter 47]
  if our-current-screen = 48 [import-pcolors "screen48 world" set screencounter 48]
  if our-current-screen = 49 [import-pcolors "screen49 world" set screencounter 49]
  if our-current-screen = 50 [import-pcolors "screen50 world" set screencounter 50]
  if our-current-screen = 51 [import-pcolors "screen51 world" set screencounter 51]
  if our-current-screen = 52 [import-pcolors "screen52 world" set screencounter 52]
  if our-current-screen = 53 [import-pcolors "screen53 world" set screencounter 53]
  if our-current-screen = 54 [import-pcolors "screen54 world" set screencounter 54]
  if our-current-screen = 55 [import-pcolors "screen55 world" set screencounter 55]
  if our-current-screen = 56 [import-pcolors "screen56 world" set screencounter 56]
  if our-current-screen = 57 [import-pcolors "screen57 world" set screencounter 57]
  if our-current-screen = 58 [import-pcolors "screen58 world" set screencounter 58]
  if our-current-screen = 59 [import-pcolors "screen59 world" set screencounter 59]
  if our-current-screen = 60 [import-pcolors "screen60 world" set screencounter 60]
  if our-current-screen = 61 [import-pcolors "screen61 world" set screencounter 61]
  if our-current-screen = 62 [import-pcolors "screen62 world" set screencounter 62]
  if our-current-screen = 63 [import-pcolors "screen63 world" set screencounter 63]
  if our-current-screen = 64 [import-pcolors "screen64 world" set screencounter 64]
  if our-current-screen = 65 [import-pcolors "screen65 world" set screencounter 65]
  if our-current-screen = 66 [import-pcolors "screen66 world" set screencounter 66]
  if our-current-screen = 67 [import-pcolors "screen67 world" set screencounter 67]
  if our-current-screen = 68 [import-pcolors "screen68 world" set screencounter 68]
  if our-current-screen = 69 [import-pcolors "screen69 world" set screencounter 69]
  if our-current-screen = 70 [import-pcolors "screen70 world" set screencounter 70]
  if our-current-screen = 71 [import-pcolors "screen71 world" set screencounter 71]
  if our-current-screen = 72 [import-pcolors "screen72 world" set screencounter 72]
  if our-current-screen = 73 [import-pcolors "screen73 world" set screencounter 73]
  if our-current-screen = 74 [import-pcolors "screen74 world" set screencounter 74]
  if our-current-screen = 75 [import-pcolors "screen75 world" set screencounter 75]
  if our-current-screen = 76 [import-pcolors "screen76 world" set screencounter 76]
  if our-current-screen = 77 [import-pcolors "screen77 world" set screencounter 77]
  if our-current-screen = 78 [import-pcolors "screen78 world" set screencounter 78]
  if our-current-screen = 79 [import-pcolors "screen79 world" set screencounter 79]
  if our-current-screen = 80 [import-pcolors "screen80 world" set screencounter 80]
  if our-current-screen = 81 [import-pcolors "screen81 world" set screencounter 81]
  if our-current-screen = 82 [import-pcolors "screen82 world" set screencounter 82]
  if our-current-screen = 83 [import-pcolors "screen83 world" set screencounter 83]
  if our-current-screen = 84 [import-pcolors "screen84 world" set screencounter 84]
  if our-current-screen = 85 [import-pcolors "screen85 world" set screencounter 85]
  if our-current-screen = 86 [import-pcolors "screen86 world" set screencounter 86]
  if our-current-screen = 87 [import-pcolors "screen87 world" set screencounter 87]
  if our-current-screen = 88 [import-pcolors "screen88 world" set screencounter 88]
  if our-current-screen = 89 [import-pcolors "screen89 world" set screencounter 89]
  if our-current-screen = 90 [import-pcolors "screen90 world" set screencounter 90]
  if our-current-screen = 91 [import-pcolors "screen91 world" set screencounter 91]
  if our-current-screen = 92 [import-pcolors "screen92 world" set screencounter 92]
  if our-current-screen = 93 [import-pcolors "screen93 world" set screencounter 23]
  if our-current-screen = 94 [import-pcolors "screen94 world" set screencounter 94]
  if our-current-screen = 95 [import-pcolors "screen95 world" set screencounter 95]
  if our-current-screen = 96 [import-pcolors "screen96 world" set screencounter 96]
  if our-current-screen = 97 [import-pcolors "screen97 world" set screencounter 97]
  if our-current-screen = 98 [import-pcolors "screen98 world" set screencounter 98]
  if our-current-screen = 99 [import-pcolors "screen99 world" set screencounter 99]
  if our-current-screen = 100 [import-pcolors "screen100 world" set screencounter 100]
  if our-current-screen = 101 [import-pcolors "screen101 world" set screencounter 101]
  if our-current-screen = 102 [import-pcolors "screen102 world" set screencounter 102]
  if our-current-screen = 103 [import-pcolors "screen103 world" set screencounter 103]
  if our-current-screen = 104 [import-pcolors "screen104 world" set screencounter 104]
  if our-current-screen = 105 [import-pcolors "screen105 world" set screencounter 105]
  if our-current-screen = 106 [import-pcolors "screen106 world" set screencounter 106]
  if our-current-screen = 107 [import-pcolors "screen107 world" set screencounter 107]
  if our-current-screen = 108 [import-pcolors "screen108 world" set screencounter 108]
  if our-current-screen = 109 [import-pcolors "screen109 world" set screencounter 109]
  if our-current-screen = 110 [import-pcolors "screen110 world" set screencounter 110]
  if our-current-screen = 111 [import-pcolors "screen111 world" set screencounter 111]
  if our-current-screen = 112 [import-pcolors "screen112 world" set screencounter 112]
  if our-current-screen = 113 [import-pcolors "screen113 world" set screencounter 113]
  if our-current-screen = 114 [import-pcolors "screen114 world" set screencounter 114]
  if our-current-screen = 115 [import-pcolors "screen115 world" set screencounter 115]
  if our-current-screen = 116 [import-pcolors "screen116 world" set screencounter 116]
  if our-current-screen = 117 [import-pcolors "screen117 world" set screencounter 117]
  if our-current-screen = 118 [import-pcolors "screen118 world" set screencounter 118]
  if our-current-screen = 119 [import-pcolors "screen119 world" set screencounter 119]
  if our-current-screen = 120 [import-pcolors "screen120 world" set screencounter 120]
  if our-current-screen = 121 [import-pcolors "screen121 world" set screencounter 121]
  if our-current-screen = 122 [import-pcolors "screen122 world" set screencounter 122]
  if our-current-screen = 123 [import-pcolors "screen123 world" set screencounter 123]
  if our-current-screen = 124 [import-pcolors "screen124 world" set screencounter 124]
  if our-current-screen = 125 [import-pcolors "screen125 world" set screencounter 125]
  if our-current-screen = 126 [import-pcolors "screen126 world" set screencounter 126]
  if our-current-screen = 127 [import-pcolors "screen127 world" set screencounter 127]
  if our-current-screen = 128 [import-pcolors "screen128 world" set screencounter 128]
  
  fleshoutscreen
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;RIGHT HEADED (used only when the screen is moving right)

to destinationscreen-going-right
  if our-current-screen = 1 [import-pcolors "screen2 world" set screencounter 2]
  if our-current-screen = 3 [import-pcolors "screen1 world" set screencounter 1]
  if our-current-screen = 2 [import-pcolors "screen24 world" set screencounter 24]
  if our-current-screen = 4 [import-pcolors "screen6 world" set screencounter 6]
  if our-current-screen = 5 [import-pcolors "screen4 world" set screencounter 4]
  if our-current-screen = 6 [import-pcolors "screen23 world" set screencounter 23]
  if our-current-screen = 7 [import-pcolors "screen3 world" set screencounter 3]
  if our-current-screen = 8 [import-pcolors "screen5 world" set screencounter 5]
  if our-current-screen = 9 [import-pcolors "screen10 world" set screencounter 10]
  if our-current-screen = 10 [import-pcolors "screen11 world" set screencounter 11]
  if our-current-screen = 11 [import-pcolors "screen12 world" set screencounter 12]
  if our-current-screen = 12 [import-pcolors "screen22 world" set screencounter 22]
  if our-current-screen = 14 [import-pcolors "screen8 world" set screencounter 8]
  if our-current-screen = 15 [import-pcolors "screen9 world" set screencounter 9]
  if our-current-screen = 17 [import-pcolors "screen18 world" set screencounter 18]
  if our-current-screen = 18 [import-pcolors "screen19 world" set screencounter 19]
  if our-current-screen = 19 [import-pcolors "screen20 world" set screencounter 20]
  if our-current-screen = 21 [import-pcolors "screen37 world" set screencounter 37]
  if our-current-screen = 22 [import-pcolors "screen38 world" set screencounter 38]
  if our-current-screen = 23 [import-pcolors "screen39 world" set screencounter 39]
  if our-current-screen = 24 [import-pcolors "screen40 world" set screencounter 40]
  if our-current-screen = 25 [import-pcolors "screen13 world" set screencounter 13]
  if our-current-screen = 26 [import-pcolors "screen14 world" set screencounter 14]
  if our-current-screen = 27 [import-pcolors "screen15 world" set screencounter 15]
  if our-current-screen = 30 [import-pcolors "screen31 world" set screencounter 31]
  if our-current-screen = 31 [import-pcolors "screen32 world" set screencounter 32]
  if our-current-screen = 33 [import-pcolors "screen34 world" set screencounter 34]
  if our-current-screen = 36 [import-pcolors "screen50 world" set screencounter 50]
  if our-current-screen = 37 [import-pcolors "screen57 world" set screencounter 57]
  if our-current-screen = 38 [import-pcolors "screen58 world" set screencounter 58]
  if our-current-screen = 39 [import-pcolors "screen59 world" set screencounter 59]
  if our-current-screen = 40 [import-pcolors "screen60 world" set screencounter 60]
  if our-current-screen = 41 [import-pcolors "screen25 world" set screencounter 25]
  if our-current-screen = 42 [import-pcolors "screen26 world" set screencounter 26]
  if our-current-screen = 43 [import-pcolors "screen27 world" set screencounter 27]
  if our-current-screen = 45 [import-pcolors "screen24 world" set screencounter 24]
  if our-current-screen = 47 [import-pcolors "screen48 world" set screencounter 48]
  if our-current-screen = 48 [import-pcolors "screen49 world" set screencounter 49]
  if our-current-screen = 50 [import-pcolors "screen51 world" set screencounter 51]
  if our-current-screen = 51 [import-pcolors "screen52 world" set screencounter 52]
  if our-current-screen = 52 [import-pcolors "screen53 world" set screencounter 53]
  if our-current-screen = 53 [import-pcolors "screen54 world" set screencounter 54]
  if our-current-screen = 54 [import-pcolors "screen55 world" set screencounter 55]
  if our-current-screen = 55 [import-pcolors "screen79 world" set screencounter 79]
  if our-current-screen = 58 [import-pcolors "screen82 world" set screencounter 82]
  if our-current-screen = 59 [import-pcolors "screen83 world" set screencounter 83]
  if our-current-screen = 60 [import-pcolors "screen84 world" set screencounter 84]
  if our-current-screen = 61 [import-pcolors "screen41 world" set screencounter 41]
  if our-current-screen = 62 [import-pcolors "screen42 world" set screencounter 42]
  if our-current-screen = 63 [import-pcolors "screen43 world" set screencounter 43]
  if our-current-screen = 65 [import-pcolors "screen45 world" set screencounter 45]
  if our-current-screen = 68 [import-pcolors "screen64 world" set screencounter 64]
  if our-current-screen = 69 [import-pcolors "screen70 world" set screencounter 70]
  if our-current-screen = 70 [import-pcolors "screen71 world" set screencounter 71]
  if our-current-screen = 71 [import-pcolors "screen72 world" set screencounter 72]
  if our-current-screen = 72 [import-pcolors "screen73 world" set screencounter 73]
  if our-current-screen = 73 [import-pcolors "screen74 world" set screencounter 74]
  if our-current-screen = 74 [import-pcolors "screen75 world" set screencounter 75]
  if our-current-screen = 75 [import-pcolors "screen76 world" set screencounter 76]
  if our-current-screen = 76 [import-pcolors "screen77 world" set screencounter 77]
  if our-current-screen = 77 [import-pcolors "screen78 world" set screencounter 78]
  if our-current-screen = 78 [import-pcolors "screen106 world" set screencounter 106]
  if our-current-screen = 79 [import-pcolors "screen107 world" set screencounter 107]
  if our-current-screen = 80 [import-pcolors "screen108 world" set screencounter 108]
  if our-current-screen = 81 [import-pcolors "screen109 world" set screencounter 109]
  if our-current-screen = 82 [import-pcolors "screen110 world" set screencounter 110]
  if our-current-screen = 83 [import-pcolors "screen111 world" set screencounter 111]
  if our-current-screen = 84 [import-pcolors "screen112 world" set screencounter 112]
  if our-current-screen = 85 [import-pcolors "screen61 world" set screencounter 61]
  if our-current-screen = 86 [import-pcolors "screen62 world" set screencounter 62]
  if our-current-screen = 88 [import-pcolors "screen64 world" set screencounter 64]
  if our-current-screen = 89 [import-pcolors "screen65 world" set screencounter 65]
  if our-current-screen = 90 [import-pcolors "screen66 world" set screencounter 66]
  if our-current-screen = 91 [import-pcolors "screen67 world" set screencounter 67]
  if our-current-screen = 92 [import-pcolors "screen93 world" set screencounter 93]
  if our-current-screen = 93 [import-pcolors "screen94 world" set screencounter 94]
  if our-current-screen = 94 [import-pcolors "screen95 world" set screencounter 95]
  if our-current-screen = 96 [import-pcolors "screen97 world" set screencounter 97]
  if our-current-screen = 97 [import-pcolors "screen98 world" set screencounter 98]
  if our-current-screen = 98 [import-pcolors "screen99 world" set screencounter 99]
  if our-current-screen = 99 [import-pcolors "screen100 world" set screencounter 100]
  if our-current-screen = 100 [import-pcolors "screen101 world" set screencounter 101]
  if our-current-screen = 104 [import-pcolors "screen105 world" set screencounter 105]
  if our-current-screen = 106 [import-pcolors "screen114 world" set screencounter 114]
  if our-current-screen = 107 [import-pcolors "screen115 world" set screencounter 115]
  if our-current-screen = 109 [import-pcolors "screen117 world" set screencounter 117]
  if our-current-screen = 110 [import-pcolors "screen118 world" set screencounter 118]
  if our-current-screen = 111 [import-pcolors "screen119 world" set screencounter 119]
  if our-current-screen = 112 [import-pcolors "screen120 world" set screencounter 120]
  if our-current-screen = 113 [import-pcolors "screen121 world" set screencounter 121]
  if our-current-screen = 114 [import-pcolors "screen122 world" set screencounter 122]
  if our-current-screen = 115 [import-pcolors "screen123 world" set screencounter 123]
  if our-current-screen = 116 [import-pcolors "screen124 world" set screencounter 124]
  if our-current-screen = 119 [import-pcolors "screen127 world" set screencounter 127]
  if our-current-screen = 120 [import-pcolors "screen128 world" set screencounter 128]
  

  fleshoutscreen
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;LEFT HEADED 

to destinationscreen-going-left
  if our-current-screen = 1 [import-pcolors "screen3 world" set screencounter 3]
  if our-current-screen = 2 [import-pcolors "screen1 world" set screencounter 1]
  if our-current-screen = 3 [import-pcolors "screen7 world" set screencounter 7]
  if our-current-screen = 4 [import-pcolors "screen5 world" set screencounter 5]
  if our-current-screen = 5 [import-pcolors "screen8 world" set screencounter 8]
  if our-current-screen = 6 [import-pcolors "screen4 world" set screencounter 4]
  if our-current-screen = 8 [import-pcolors "screen14 world" set screencounter 14]
  if our-current-screen = 9 [import-pcolors "screen15 world" set screencounter 15]
  if our-current-screen = 10 [import-pcolors "screen9 world" set screencounter 9]
  if our-current-screen = 11 [import-pcolors "screen10 world" set screencounter 10]
  if our-current-screen = 12 [import-pcolors "screen11 world" set screencounter 11]
  if our-current-screen = 13 [import-pcolors "screen25 world" set screencounter 25]
  if our-current-screen = 14 [import-pcolors "screen26 world" set screencounter 26]
  if our-current-screen = 15 [import-pcolors "screen27 world" set screencounter 27]
  if our-current-screen = 17 [import-pcolors "screen16 world" set screencounter 16]
  if our-current-screen = 18 [import-pcolors "screen17 world" set screencounter 17]
  if our-current-screen = 19 [import-pcolors "screen18 world" set screencounter 18]
  if our-current-screen = 20 [import-pcolors "screen19 world" set screencounter 19]
  if our-current-screen = 22 [import-pcolors "screen12 world" set screencounter 12]
  if our-current-screen = 23 [import-pcolors "screen6 world" set screencounter 6]
  if our-current-screen = 24 [import-pcolors "screen2 world" set screencounter 2]
  if our-current-screen = 25 [import-pcolors "screen41 world" set screencounter 41]
  if our-current-screen = 26 [import-pcolors "screen42 world" set screencounter 42]
  if our-current-screen = 27 [import-pcolors "screen43 world" set screencounter 43]
  if our-current-screen = 29 [import-pcolors "screen45 world" set screencounter 45]
  if our-current-screen = 31 [import-pcolors "screen30 world" set screencounter 30]
  if our-current-screen = 32 [import-pcolors "screen31 world" set screencounter 31]
  if our-current-screen = 34 [import-pcolors "screen33 world" set screencounter 33]
  if our-current-screen = 37 [import-pcolors "screen21 world" set screencounter 21]
  if our-current-screen = 38 [import-pcolors "screen22 world" set screencounter 22]
  if our-current-screen = 39 [import-pcolors "screen23 world" set screencounter 23]
  if our-current-screen = 40 [import-pcolors "screen24 world" set screencounter 24]
  if our-current-screen = 41 [import-pcolors "screen61 world" set screencounter 61]
  if our-current-screen = 42 [import-pcolors "screen62 world" set screencounter 62]
  if our-current-screen = 43 [import-pcolors "screen63 world" set screencounter 63]
  if our-current-screen = 45 [import-pcolors "screen65 world" set screencounter 64]
  if our-current-screen = 48 [import-pcolors "screen47 world" set screencounter 47]
  if our-current-screen = 49 [import-pcolors "screen48 world" set screencounter 48]
  if our-current-screen = 51 [import-pcolors "screen50 world" set screencounter 50]
  if our-current-screen = 52 [import-pcolors "screen51 world" set screencounter 51]
  if our-current-screen = 53 [import-pcolors "screen52 world" set screencounter 52]
  if our-current-screen = 54 [import-pcolors "screen53 world" set screencounter 53]
  if our-current-screen = 55 [import-pcolors "screen54 world" set screencounter 54]
  if our-current-screen = 56 [import-pcolors "screen36 world" set screencounter 36]
  if our-current-screen = 57 [import-pcolors "screen37 world" set screencounter 37]
  if our-current-screen = 58 [import-pcolors "screen38 world" set screencounter 38]
  if our-current-screen = 59 [import-pcolors "screen39 world" set screencounter 39]
  if our-current-screen = 60 [import-pcolors "screen40 world" set screencounter 40]
  if our-current-screen = 61 [import-pcolors "screen85 world" set screencounter 85]
  if our-current-screen = 62 [import-pcolors "screen86 world" set screencounter 86]
  if our-current-screen = 64 [import-pcolors "screen88 world" set screencounter 88]
  if our-current-screen = 65 [import-pcolors "screen89 world" set screencounter 89]
  if our-current-screen = 66 [import-pcolors "screen90 world" set screencounter 90]
  if our-current-screen = 67 [import-pcolors "screen91 world" set screencounter 91]
  if our-current-screen = 69 [import-pcolors "screen68 world" set screencounter 68]
  if our-current-screen = 70 [import-pcolors "screen69 world" set screencounter 69]
  if our-current-screen = 71 [import-pcolors "screen70 world" set screencounter 70]
  if our-current-screen = 72 [import-pcolors "screen71 world" set screencounter 71]
  if our-current-screen = 73 [import-pcolors "screen72 world" set screencounter 72]
  if our-current-screen = 74 [import-pcolors "screen73 world" set screencounter 73]
  if our-current-screen = 75 [import-pcolors "screen74 world" set screencounter 74]
  if our-current-screen = 76 [import-pcolors "screen75 world" set screencounter 75]
  if our-current-screen = 77 [import-pcolors "screen76 world" set screencounter 76]
  if our-current-screen = 78 [import-pcolors "screen77 world" set screencounter 77]
  if our-current-screen = 79 [import-pcolors "screen55 world" set screencounter 55]
  if our-current-screen = 80 [import-pcolors "screen56 world" set screencounter 56]
  if our-current-screen = 82 [import-pcolors "screen58 world" set screencounter 58]
  if our-current-screen = 83 [import-pcolors "screen59 world" set screencounter 59]
  if our-current-screen = 84 [import-pcolors "screen60 world" set screencounter 60]
  if our-current-screen = 93 [import-pcolors "screen92 world" set screencounter 92]
  if our-current-screen = 94 [import-pcolors "screen93 world" set screencounter 93]
  if our-current-screen = 95 [import-pcolors "screen94 world" set screencounter 94]
  if our-current-screen = 97 [import-pcolors "screen96 world" set screencounter 96]
  if our-current-screen = 98 [import-pcolors "screen97 world" set screencounter 97]
  if our-current-screen = 99 [import-pcolors "screen98 world" set screencounter 98]
  if our-current-screen = 100 [import-pcolors "screen99 world" set screencounter 99]
  if our-current-screen = 101 [import-pcolors "screen100 world" set screencounter 100]
  if our-current-screen = 105 [import-pcolors "screen104 world" set screencounter 104]
  if our-current-screen = 106 [import-pcolors "screen78 world" set screencounter 78]
  if our-current-screen = 107 [import-pcolors "screen79 world" set screencounter 79]
  if our-current-screen = 109 [import-pcolors "screen81 world" set screencounter 81]
  if our-current-screen = 110 [import-pcolors "screen82 world" set screencounter 82]
  if our-current-screen = 111 [import-pcolors "screen83 world" set screencounter 83]
  if our-current-screen = 112 [import-pcolors "screen84 world" set screencounter 84]
  if our-current-screen = 114 [import-pcolors "screen106 world" set screencounter 106]
  if our-current-screen = 115 [import-pcolors "screen107 world" set screencounter 107]
  if our-current-screen = 117 [import-pcolors "screen109 world" set screencounter 109]
  if our-current-screen = 118 [import-pcolors "screen110 world" set screencounter 110]
  if our-current-screen = 119 [import-pcolors "screen111 world" set screencounter 111]
  if our-current-screen = 120 [import-pcolors "screen112 world" set screencounter 112]
  if our-current-screen = 122 [import-pcolors "screen114 world" set screencounter 114]
  if our-current-screen = 123 [import-pcolors "screen115 world" set screencounter 115]
  if our-current-screen = 124 [import-pcolors "screen116 world" set screencounter 116]
  if our-current-screen = 127 [import-pcolors "screen119 world" set screencounter 119]
  if our-current-screen = 128 [import-pcolors "screen120 world" set screencounter 120]
  
  fleshoutscreen
end
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;UP HEADED

to destinationscreen-going-up;remove what we don't need
  if our-current-screen = 1 [import-pcolors "screen4 world" set screencounter 4]
  if our-current-screen = 2 [import-pcolors "screen6 world" set screencounter 6]
  if our-current-screen = 3 [import-pcolors "screen5 world" set screencounter 5]
  if our-current-screen = 4 [import-pcolors "screen105 world" set screencounter 105]
  if our-current-screen = 5 [import-pcolors "screen106 world" set screencounter 106]
  if our-current-screen = 6 [import-pcolors "screen12 world" set screencounter 12]
  if our-current-screen = 7 [import-pcolors "screen8 world" set screencounter 8]
  if our-current-screen = 8 [import-pcolors "screen9 world" set screencounter 9]
  if our-current-screen = 9 [import-pcolors "screen17 world" set screencounter 17]
  if our-current-screen = 10 [import-pcolors "screen18 world" set screencounter 18]
  if our-current-screen = 11 [import-pcolors "screen19 world" set screencounter 19]
  if our-current-screen = 12 [import-pcolors "screen20 world" set screencounter 20]
  if our-current-screen = 13 [import-pcolors "screen14 world" set screencounter 14]
  if our-current-screen = 14 [import-pcolors "screen15 world" set screencounter 15]
  if our-current-screen = 15 [import-pcolors "screen16 world" set screencounter 16]
  if our-current-screen = 16 [import-pcolors "screen30 world" set screencounter 30]
  if our-current-screen = 17 [import-pcolors "screen31 world" set screencounter 31]
  if our-current-screen = 18 [import-pcolors "screen32 world" set screencounter 32]
  if our-current-screen = 19 [import-pcolors "screen33 world" set screencounter 33]
  if our-current-screen = 20 [import-pcolors "screen34 world" set screencounter 34]
  if our-current-screen = 21 [import-pcolors "screen35 world" set screencounter 35]
  if our-current-screen = 22 [import-pcolors "screen21 world" set screencounter 21]
  if our-current-screen = 23 [import-pcolors "screen22 world" set screencounter 22]
  if our-current-screen = 24 [import-pcolors "screen23 world" set screencounter 23]
  if our-current-screen = 25 [import-pcolors "screen26 world" set screencounter 26]
  if our-current-screen = 26 [import-pcolors "screen27 world" set screencounter 27]
  if our-current-screen = 27 [import-pcolors "screen28 world" set screencounter 28]
  if our-current-screen = 28 [import-pcolors "screen29 world" set screencounter 29]
  if our-current-screen = 29 [import-pcolors "screen47 world" set screencounter 47]
  if our-current-screen = 30 [import-pcolors "screen48 world" set screencounter 48]
  if our-current-screen = 31 [import-pcolors "screen49 world" set screencounter 49]
  if our-current-screen = 32 [import-pcolors "screen50 world" set screencounter 50]
  if our-current-screen = 33 [import-pcolors "screen51 world" set screencounter 51]
  if our-current-screen = 34 [import-pcolors "screen52 world" set screencounter 52]
  if our-current-screen = 35 [import-pcolors "screen53 world" set screencounter 53]
  if our-current-screen = 36 [import-pcolors "screen54 world" set screencounter 54]
  if our-current-screen = 37 [import-pcolors "screen36 world" set screencounter 36]
  if our-current-screen = 38 [import-pcolors "screen37 world" set screencounter 37]
  if our-current-screen = 39 [import-pcolors "screen38 world" set screencounter 38]
  if our-current-screen = 40 [import-pcolors "screen39 world" set screencounter 39]
  if our-current-screen = 41 [import-pcolors "screen42 world" set screencounter 42]
  if our-current-screen = 42 [import-pcolors "screen43 world" set screencounter 43]
  if our-current-screen = 43 [import-pcolors "screen44 world" set screencounter 44]
  if our-current-screen = 44 [import-pcolors "screen45 world" set screencounter 45]
  if our-current-screen = 45 [import-pcolors "screen46 world" set screencounter 46]
  if our-current-screen = 46 [import-pcolors "screen68 world" set screencounter 48]
  if our-current-screen = 47 [import-pcolors "screen69 world" set screencounter 69]
  if our-current-screen = 48 [import-pcolors "screen70 world" set screencounter 70]
  if our-current-screen = 49 [import-pcolors "screen71 world" set screencounter 71]
  if our-current-screen = 50 [import-pcolors "screen72 world" set screencounter 72]
  if our-current-screen = 51 [import-pcolors "screen73 world" set screencounter 73]
  if our-current-screen = 52 [import-pcolors "screen74 world" set screencounter 74]
  if our-current-screen = 53 [import-pcolors "screen75 world" set screencounter 75]
  if our-current-screen = 54 [import-pcolors "screen76 world" set screencounter 76]
  if our-current-screen = 55 [import-pcolors "screen77 world" set screencounter 77]
  if our-current-screen = 56 [import-pcolors "screen55 world" set screencounter 55]
  if our-current-screen = 57 [import-pcolors "screen56 world" set screencounter 56]
  if our-current-screen = 58 [import-pcolors "screen57 world" set screencounter 57]
  if our-current-screen = 59 [import-pcolors "screen58 world" set screencounter 58]
  if our-current-screen = 60 [import-pcolors "screen59 world" set screencounter 59]
  if our-current-screen = 61 [import-pcolors "screen62 world" set screencounter 62]
  if our-current-screen = 62 [import-pcolors "screen63 world" set screencounter 63]
  if our-current-screen = 63 [import-pcolors "screen64 world" set screencounter 64]
  if our-current-screen = 64 [import-pcolors "screen65 world" set screencounter 65]
  if our-current-screen = 65 [import-pcolors "screen66 world" set screencounter 66]
  if our-current-screen = 66 [import-pcolors "screen67 world" set screencounter 67]
  if our-current-screen = 67 [import-pcolors "screen93 world" set screencounter 93]
  if our-current-screen = 68 [import-pcolors "screen94 world" set screencounter 94]
  if our-current-screen = 69 [import-pcolors "screen95 world" set screencounter 95]
  if our-current-screen = 70 [import-pcolors "screen96 world" set screencounter 96]
  if our-current-screen = 71 [import-pcolors "screen97 world" set screencounter 97]
  if our-current-screen = 72 [import-pcolors "screen98 world" set screencounter 98]
  if our-current-screen = 73 [import-pcolors "screen99 world" set screencounter 99]
  if our-current-screen = 74 [import-pcolors "screen100 world" set screencounter 100]
  if our-current-screen = 75 [import-pcolors "screen101 world" set screencounter 101]
  if our-current-screen = 76 [import-pcolors "screen102 world" set screencounter 102]
  if our-current-screen = 77 [import-pcolors "screen103 world" set screencounter 103]
  if our-current-screen = 78 [import-pcolors "screen104 world" set screencounter 104]
  if our-current-screen = 79 [import-pcolors "screen78 world" set screencounter 78]
  if our-current-screen = 80 [import-pcolors "screen79 world" set screencounter 79]
  if our-current-screen = 81 [import-pcolors "screen80 world" set screencounter 80]
  if our-current-screen = 82 [import-pcolors "screen81 world" set screencounter 81]
  if our-current-screen = 83 [import-pcolors "screen82 world" set screencounter 82]
  if our-current-screen = 84 [import-pcolors "screen83 world" set screencounter 83]
  if our-current-screen = 85 [import-pcolors "screen86 world" set screencounter 86]
  if our-current-screen = 86 [import-pcolors "screen87 world" set screencounter 87]
  if our-current-screen = 87 [import-pcolors "screen88 world" set screencounter 88]
  if our-current-screen = 88 [import-pcolors "screen89 world" set screencounter 89]
  if our-current-screen = 89 [import-pcolors "screen90 world" set screencounter 90]
  if our-current-screen = 90 [import-pcolors "screen91 world" set screencounter 91]
  if our-current-screen = 91 [import-pcolors "screen92 world" set screencounter 92]
  if our-current-screen = 106 [import-pcolors "screen105 world" set screencounter 105]
  if our-current-screen = 107 [import-pcolors "screen106 world" set screencounter 106]
  if our-current-screen = 108 [import-pcolors "screen107 world" set screencounter 107]
  if our-current-screen = 109 [import-pcolors "screen108 world" set screencounter 108]
  if our-current-screen = 110 [import-pcolors "screen109 world" set screencounter 109]
  if our-current-screen = 111 [import-pcolors "screen110 world" set screencounter 110]
  if our-current-screen = 112 [import-pcolors "screen111 world" set screencounter 111]
  if our-current-screen = 114 [import-pcolors "screen113 world" set screencounter 113]
  if our-current-screen = 115 [import-pcolors "screen114 world" set screencounter 114]
  if our-current-screen = 116 [import-pcolors "screen115 world" set screencounter 115]
  if our-current-screen = 117 [import-pcolors "screen116 world" set screencounter 116]
  if our-current-screen = 118 [import-pcolors "screen117 world" set screencounter 117]
  if our-current-screen = 119 [import-pcolors "screen118 world" set screencounter 118]
  if our-current-screen = 120 [import-pcolors "screen119 world" set screencounter 119]
  if our-current-screen = 122 [import-pcolors "screen121 world" set screencounter 121]
  if our-current-screen = 123 [import-pcolors "screen122 world" set screencounter 122]
  if our-current-screen = 124 [import-pcolors "screen123 world" set screencounter 123]
  if our-current-screen = 125 [import-pcolors "screen124 world" set screencounter 124]
  if our-current-screen = 126 [import-pcolors "screen125 world" set screencounter 125]
  if our-current-screen = 127 [import-pcolors "screen126 world" set screencounter 126]
  if our-current-screen = 128 [import-pcolors "screen127 world" set screencounter 127]
  
  fleshoutscreen
end
  

  
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DOWN HEADED

to destinationscreen-going-down; remove what we don't need
  if our-current-screen = 4 [import-pcolors "screen1 world" set screencounter 1]
  if our-current-screen = 5 [import-pcolors "screen3 world" set screencounter 3]
  if our-current-screen = 6 [import-pcolors "screen2 world" set screencounter 2]
  if our-current-screen = 8 [import-pcolors "screen7 world" set screencounter 7]
  if our-current-screen = 9 [import-pcolors "screen8 world" set screencounter 8]
  if our-current-screen = 10 [import-pcolors "screen5 world" set screencounter 5]
  if our-current-screen = 11 [import-pcolors "screen4 world" set screencounter 4]
  if our-current-screen = 12 [import-pcolors "screen6 world" set screencounter 6]
  if our-current-screen = 14 [import-pcolors "screen13 world" set screencounter 13]
  if our-current-screen = 15 [import-pcolors "screen14 world" set screencounter 14]
  if our-current-screen = 16 [import-pcolors "screen15 world" set screencounter 15]
  if our-current-screen = 17 [import-pcolors "screen9 world" set screencounter 9]
  if our-current-screen = 18 [import-pcolors "screen10 world" set screencounter 10]
  if our-current-screen = 19 [import-pcolors "screen11 world" set screencounter 11]
  if our-current-screen = 20 [import-pcolors "screen12 world" set screencounter 12]
  if our-current-screen = 21 [import-pcolors "screen22 world" set screencounter 22]
  if our-current-screen = 22 [import-pcolors "screen23 world" set screencounter 23]
  if our-current-screen = 23 [import-pcolors "screen24 world" set screencounter 24]
  if our-current-screen = 26 [import-pcolors "screen25 world" set screencounter 25]
  if our-current-screen = 27 [import-pcolors "screen26 world" set screencounter 26]
  if our-current-screen = 28 [import-pcolors "screen27 world" set screencounter 27]
  if our-current-screen = 29 [import-pcolors "screen28 world" set screencounter 28]
  if our-current-screen = 30 [import-pcolors "screen16 world" set screencounter 16]
  if our-current-screen = 31 [import-pcolors "screen17 world" set screencounter 17]
  if our-current-screen = 32 [import-pcolors "screen18 world" set screencounter 18]
  if our-current-screen = 33 [import-pcolors "screen19 world" set screencounter 19]
  if our-current-screen = 34 [import-pcolors "screen20 world" set screencounter 20]
  if our-current-screen = 35 [import-pcolors "screen21 world" set screencounter 21]
  if our-current-screen = 36 [import-pcolors "screen37 world" set screencounter 37]
  if our-current-screen = 37 [import-pcolors "screen38 world" set screencounter 38]
  if our-current-screen = 38 [import-pcolors "screen39 world" set screencounter 39]
  if our-current-screen = 39 [import-pcolors "screen40 world" set screencounter 40]
  if our-current-screen = 42 [import-pcolors "screen41 world" set screencounter 41]
  if our-current-screen = 43 [import-pcolors "screen42 world" set screencounter 42]
  if our-current-screen = 44 [import-pcolors "screen43 world" set screencounter 43]
  if our-current-screen = 45 [import-pcolors "screen44 world" set screencounter 44]
  if our-current-screen = 46 [import-pcolors "screen45 world" set screencounter 45]
  if our-current-screen = 47 [import-pcolors "screen29 world" set screencounter 29]
  if our-current-screen = 48 [import-pcolors "screen30 world" set screencounter 30]
  if our-current-screen = 49 [import-pcolors "screen31 world" set screencounter 31]
  if our-current-screen = 50 [import-pcolors "screen32 world" set screencounter 32]
  if our-current-screen = 51 [import-pcolors "screen33 world" set screencounter 33]
  if our-current-screen = 52 [import-pcolors "screen34 world" set screencounter 34]
  if our-current-screen = 53 [import-pcolors "screen35 world" set screencounter 35]
  if our-current-screen = 54 [import-pcolors "screen36 world" set screencounter 36]
  if our-current-screen = 55 [import-pcolors "screen56 world" set screencounter 56]
  if our-current-screen = 56 [import-pcolors "screen57 world" set screencounter 57]
  if our-current-screen = 57 [import-pcolors "screen58 world" set screencounter 58]
  if our-current-screen = 58 [import-pcolors "screen59 world" set screencounter 59]
  if our-current-screen = 59 [import-pcolors "screen60 world" set screencounter 60]
  if our-current-screen = 62 [import-pcolors "screen61 world" set screencounter 61]
  if our-current-screen = 63 [import-pcolors "screen62 world" set screencounter 62]
  if our-current-screen = 64 [import-pcolors "screen63 world" set screencounter 63]
  if our-current-screen = 65 [import-pcolors "screen64 world" set screencounter 64]
  if our-current-screen = 66 [import-pcolors "screen65 world" set screencounter 65]
  if our-current-screen = 67 [import-pcolors "screen66 world" set screencounter 66]
  if our-current-screen = 68 [import-pcolors "screen46 world" set screencounter 46]
  if our-current-screen = 69 [import-pcolors "screen47 world" set screencounter 47]
  if our-current-screen = 70 [import-pcolors "screen48 world" set screencounter 48]
  if our-current-screen = 71 [import-pcolors "screen49 world" set screencounter 49]
  if our-current-screen = 72 [import-pcolors "screen50 world" set screencounter 50]
  if our-current-screen = 73 [import-pcolors "screen51 world" set screencounter 51]
  if our-current-screen = 74 [import-pcolors "screen52 world" set screencounter 52]
  if our-current-screen = 75 [import-pcolors "screen53 world" set screencounter 53]
  if our-current-screen = 76 [import-pcolors "screen54 world" set screencounter 54]
  if our-current-screen = 77 [import-pcolors "screen55 world" set screencounter 55]
  if our-current-screen = 78 [import-pcolors "screen79 world" set screencounter 79]
  if our-current-screen = 79 [import-pcolors "screen80 world" set screencounter 80]
  if our-current-screen = 80 [import-pcolors "screen81 world" set screencounter 81]
  if our-current-screen = 81 [import-pcolors "screen82 world" set screencounter 82]
  if our-current-screen = 82 [import-pcolors "screen83 world" set screencounter 83]
  if our-current-screen = 83 [import-pcolors "screen84 world" set screencounter 84]
  if our-current-screen = 86 [import-pcolors "screen85 world" set screencounter 85]
  if our-current-screen = 87 [import-pcolors "screen86 world" set screencounter 86]
  if our-current-screen = 88 [import-pcolors "screen87 world" set screencounter 87]
  if our-current-screen = 89 [import-pcolors "screen88 world" set screencounter 88]
  if our-current-screen = 90 [import-pcolors "screen89 world" set screencounter 89]
  if our-current-screen = 91 [import-pcolors "screen90 world" set screencounter 90]
  if our-current-screen = 92 [import-pcolors "screen91 world" set screencounter 91]
  if our-current-screen = 93 [import-pcolors "screen67 world" set screencounter 67]
  if our-current-screen = 94 [import-pcolors "screen68 world" set screencounter 68]
  if our-current-screen = 95 [import-pcolors "screen69 world" set screencounter 69]
  if our-current-screen = 96 [import-pcolors "screen70 world" set screencounter 70]
  if our-current-screen = 97 [import-pcolors "screen71 world" set screencounter 71]
  if our-current-screen = 98 [import-pcolors "screen72 world" set screencounter 72]
  if our-current-screen = 99 [import-pcolors "screen73 world" set screencounter 73]
  if our-current-screen = 100 [import-pcolors "screen74 world" set screencounter 74]
  if our-current-screen = 101 [import-pcolors "screen75 world" set screencounter 75]
  if our-current-screen = 102 [import-pcolors "screen76 world" set screencounter 76]
  if our-current-screen = 103 [import-pcolors "screen77 world" set screencounter 77]
  if our-current-screen = 104 [import-pcolors "screen78 world" set screencounter 78]
  if our-current-screen = 105 [import-pcolors "screen106 world" set screencounter 106]
  if our-current-screen = 106 [import-pcolors "screen107 world" set screencounter 107]
  if our-current-screen = 107 [import-pcolors "screen108 world" set screencounter 108]
  if our-current-screen = 108 [import-pcolors "screen109 world" set screencounter 109]
  if our-current-screen = 109 [import-pcolors "screen110 world" set screencounter 110]
  if our-current-screen = 110 [import-pcolors "screen111 world" set screencounter 111]
  if our-current-screen = 111 [import-pcolors "screen112 world" set screencounter 112]
  if our-current-screen = 113 [import-pcolors "screen114 world" set screencounter 114]
  if our-current-screen = 114 [import-pcolors "screen115 world" set screencounter 115]
  if our-current-screen = 115 [import-pcolors "screen116 world" set screencounter 116]
  if our-current-screen = 116 [import-pcolors "screen117 world" set screencounter 117]
  if our-current-screen = 117 [import-pcolors "screen118 world" set screencounter 118]
  if our-current-screen = 118 [import-pcolors "screen119 world" set screencounter 119]
  if our-current-screen = 119 [import-pcolors "screen120 world" set screencounter 120]
  if our-current-screen = 121 [import-pcolors "screen122 world" set screencounter 122]
  if our-current-screen = 122 [import-pcolors "screen123 world" set screencounter 123]
  if our-current-screen = 123 [import-pcolors "screen124 world" set screencounter 124]
  if our-current-screen = 124 [import-pcolors "screen125 world" set screencounter 125]
  if our-current-screen = 125 [import-pcolors "screen126 world" set screencounter 126]
  if our-current-screen = 126 [import-pcolors "screen127 world" set screencounter 127]
  if our-current-screen = 127 [import-pcolors "screen128 world" set screencounter 128]
  
  
  fleshoutscreen
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to totalright
  ask turtles with [identity = "hero"] [set shape "zelda right"]
  ask turtles with [shape != "zelda right"] [die]
  destinationscreen-going-right
  ask turtles with [shape != "zelda right"] [hide-turtle]
  currentscreen
  ask turtles [movescreenright]
  set screenticker 0
  ask turtles with [shape != "zelda right"] [die]
  destinationscreen-going-right
  set our-current-screen screencounter
  ask turtles with [shape = "zelda up" 
                      or shape = "zeldaup2" 
                      or shape = "zelda forward" 
                      or shape = "zeldaforward2" 
                      or shape = "zelda right" 
                      or shape = "zeldaright2" 
                      or shape = "zelda left" 
                      or shape = "zeldaleft2"][set x xcor set y ycor set shape1 shape die]; bug fix; ups who? number of Link, enabling him to pass over bridges and ladders without using breeds. 
  ask patch x y [sprout 1 [set shape shape1 set identity "hero"]]
 
end


to totalleft
  ask turtles with [identity = "hero"] [set shape "zelda left"]
  ask turtles with [shape != "zelda left"] [die]
  destinationscreen-going-left
  ask turtles with [shape != "zelda left"] [hide-turtle]
  currentscreen
  ask turtles [movescreenleft]
  set screenticker 0
  ask turtles with [shape != "zelda left"] [die]
  destinationscreen-going-left
  set our-current-screen screencounter
  ask turtles with [shape = "zelda up" 
                      or shape = "zeldaup2" 
                      or shape = "zelda forward" 
                      or shape = "zeldaforward2" 
                      or shape = "zelda right" 
                      or shape = "zeldaright2" 
                      or shape = "zelda left" 
                      or shape = "zeldaleft2"][set x xcor set y ycor set shape1 shape die]
  ask patch x y [sprout 1 [set shape shape1 set identity "hero"]]

end

to totalup
  ask turtles with [identity = "hero"] [set shape "zelda up"]
  ask turtles with [shape != "zelda up"] [die]
  destinationscreen-going-up
  ask turtles with [shape != "zelda up"] [hide-turtle]
  currentscreen
  ask turtles [movescreenup]
  set screenticker 0
  ask turtles with [shape != "zelda up"] [die]
  destinationscreen-going-up
  set our-current-screen screencounter
  ask turtles with [shape = "zelda up" 
                      or shape = "zeldaup2" 
                      or shape = "zelda forward" 
                      or shape = "zeldaforward2" 
                      or shape = "zelda right" 
                      or shape = "zeldaright2" 
                      or shape = "zelda left" 
                      or shape = "zeldaleft2"][set x xcor set y ycor set shape1 shape die]
  ask patch x y [sprout 1 [set shape shape1 set identity "hero"]]

  
end

to totaldown
  ask turtles with [identity = "hero"] [set shape "zelda forward"]
  ask turtles with [shape != "zelda forward"] [die]
  destinationscreen-going-down
  ask turtles with [shape != "zelda forward"] [hide-turtle]
  currentscreen
  ask turtles [movescreendown]
  set screenticker 0
  ask turtles with [shape != "zelda forward"] [die]
  destinationscreen-going-down
  set our-current-screen screencounter
  ask turtles with [shape = "zelda up" 
                      or shape = "zeldaup2" 
                      or shape = "zelda forward" 
                      or shape = "zeldaforward2" 
                      or shape = "zelda right" 
                      or shape = "zeldaright2" 
                      or shape = "zelda left" 
                      or shape = "zeldaleft2"][set x xcor set y ycor set shape1 shape die]
  ask patch x y [sprout 1 [set shape shape1 set identity "hero"]]
  
  
end

    
    
  
@#$#@#$#@
GRAPHICS-WINDOW
439
10
877
469
8
8
25.2
1
10
1
1
1
0
1
1
1
-8
8
-8
8
0
0
1
ticks
30.0

BUTTON
197
313
263
346
Setup
start
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
35
284
90
317
Up
up
NIL
1
T
OBSERVER
NIL
W
NIL
NIL
1

BUTTON
33
350
88
383
Down
\ndown
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
62
317
117
350
Right
directionr
NIL
1
T
OBSERVER
NIL
D
NIL
NIL
1

BUTTON
7
317
62
350
Left
directionl
NIL
1
T
OBSERVER
NIL
A
NIL
NIL
1

BUTTON
319
297
401
361
A
swordattack\n
NIL
1
T
OBSERVER
NIL
K
NIL
NIL
1

BUTTON
126
39
195
72
Power
setup
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
444
36
517
81
Hearts
hearts
17
1
11

MONITOR
755
36
874
81
Keys (out of Five)
keys
17
1
11

TEXTBOX
204
44
354
72
Press to turn on Nintendo Entertainment System
11
0.0
1

MONITOR
445
419
496
464
Score
score
17
1
11

@#$#@#$#@
## WHAT IS IT?

This game is a partial reproduction of the original 1986 NES game, "The Legend of Zelda". This version uses the map of the orignal's "Overworld"; that is, all of the areas excluding the dungeons, caves, and other secret passageways. 

## RULES AND GAMEPLAY

To begin the game, FIRST press the "setup" button" , and then switch on the "Power" forever button. You are now ready to play!

The goal of my game is to collect five "keys", located in seperate locations across the overworld. Explore various regions whilst avoiding enemies (or killing them optionally to boost your score). Walk up to a key to collect it. Collecting all five keys will end the game. 

The character is born with three "hearts". Being touched by an enemy will result in the loss of half a heart. Losing all three hearts will result in a "game over". 

The controls are fairly straightforward: control your character by using the hotkeys W, S, A, and D, which move the hero up, down, left and right, respectively. The hotkey K is used to perform a sword attack, which kills enemies within a one-patch radius. Navigate the environment using the hotkeys. To move to an adjacent screen, simply move the character to the periphery. The screen will adjust. 



## BUGS AND MISSED FEATURES
   There are a few important bugs. Moving to the edge of the screen and then back to the center will still trigger the screen-move command; what this means is that if the player walks to the edge of the world, back to the center of the screen, and then turns left again, the screen will move. This is usually not a problem. Due to problems with 'wait', the enemy octoroks slow down as the hero walks, and slow more dramatically as the hero stabs with his sword. ALSO: The "power" button should be pressed only AFTER the setup button. While there is no real harm in pushing it first, you will recieve a "game over" message. Lastly, there is an error with the screen-moving code which sometimes allows a small "bar" to appear as the screen moves. The bar is corrected immediately after the screen has finished moving, however. 

The game features only one weapon useable by the player, that being the sword. Collecting five keys does not lead to a final boss confrontation; it is, in and of itself, the object of the game. 


## CREDITS AND REFERENCES

I worked with Munawar Rahman, a sophomore, on adding sound to the game, but this did not make it into the final version. My father, David Freeman, tested the game and as I worked on it. 

The original game was designed by Shigeru Miyamoto, Takashi Tezuka and Eiji Aonuma of Nintendo, and their map has been more or less copied
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

 
true
0
Polygon -6459832 true false 135 150 165 150 165 135 180 135 180 120 210 120 210 105 225 105 225 60 210 60 210 90 195 90 195 45 180 45 180 30 120 30 120 45 105 45 105 90 90 90 90 60 75 60 75 105 90 105 90 120 120 120 120 135 135 135 135 150

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bridge
false
0
Rectangle -955883 true false 0 0 120 270
Rectangle -16777216 true false 15 15 30 30
Rectangle -16777216 true false 75 15 90 30
Rectangle -16777216 true false 15 225 30 240
Rectangle -16777216 true false 75 225 90 240
Rectangle -16777216 true false 120 15 150 300
Rectangle -16777216 true false 15 270 120 300
Rectangle -13345367 true false 0 270 15 300
Rectangle -13345367 true false 135 270 150 285
Rectangle -16777216 true false 150 270 300 300
Rectangle -16777216 true false 135 285 150 300
Rectangle -955883 true false 150 0 285 270
Rectangle -16777216 true false 0 270 120 285
Rectangle -16777216 true false 150 270 300 285
Rectangle -16777216 true false 285 15 300 285
Rectangle -16777216 true false 285 0 300 15
Rectangle -16777216 true false 120 0 135 15
Rectangle -13345367 true false 270 0 300 15
Rectangle -13345367 true false 120 0 150 15
Rectangle -16777216 true false 165 15 180 30
Rectangle -16777216 true false 225 15 240 30
Rectangle -16777216 true false 165 225 180 240
Rectangle -16777216 true false 240 225 255 240

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

cave
false
0
Rectangle -16777216 true false 0 0 300 300

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

downslanteddownrock
false
0
Polygon -16777216 true false 0 0 30 0 30 15 60 15 60 30 90 30 105 45 120 45 135 75 150 90 150 150 195 165 195 195 240 225 255 240 255 255 300 255 300 300 270 300 270 270 255 270 240 255 240 240 210 210 210 270 225 300 195 300 195 270 195 210 180 195 180 165 135 150 135 90 105 60 75 45 60 45 45 45 45 30 15 30 15 15 0 15 0 0
Polygon -16777216 true false 60 45 60 195 75 195 75 45
Polygon -16777216 true false 30 210 30 195 60 195 60 210
Polygon -16777216 true false 15 30 15 75 30 75 30 30
Polygon -16777216 true false 30 90 30 75 45 75 45 120 30 120 30 150 45 150 45 240 30 240 30 150 15 150 15 120 30 120
Rectangle -1 true false 30 30 45 75
Rectangle -2674135 true false 75 45 90 90
Rectangle -1184463 true false 30 120 45 150
Rectangle -6459832 true false 45 60 60 210
Polygon -955883 true false 90 45 135 90 135 150 180 165 180 195 195 210 195 300 60 300 60 195 75 195 75 90 90 90
Polygon -1184463 true false 210 210 225 225 225 285 210 270 210 210
Polygon -1184463 true false 225 300 225 285 270 285 270 300
Polygon -955883 true false 225 225 240 240 240 255 255 270 270 270 270 285 225 285
Polygon -16777216 true false 0 210 15 210 15 255 30 255 30 270 15 270 15 285 30 285 45 285 45 300 0 300
Rectangle -16777216 true false 45 270 60 285
Rectangle -1 true false 45 285 60 300
Rectangle -1184463 true false 15 270 30 285
Rectangle -2674135 true false 90 270 105 285
Rectangle -2674135 true false 135 270 150 285
Rectangle -2674135 true false 180 270 195 285
Polygon -955883 true false 15 15 0 15 0 210 15 210 15 255 30 255 30 270 30 285 45 285 45 270 45 240 30 240 30 150 15 150 15 120 30 120 30 75 15 75 15 15
Rectangle -2674135 true false 45 210 60 270

downslanteduprock
false
0
Polygon -16777216 true false 300 300 270 300 270 285 240 285 240 270 210 270 195 255 180 255 165 225 150 210 150 150 105 135 105 105 60 75 45 60 45 45 0 45 0 0 30 0 30 30 45 30 60 45 60 60 90 90 90 30 75 0 105 0 105 30 105 90 120 105 120 135 165 150 165 210 195 240 225 255 240 255 255 255 255 270 285 270 285 285 300 285 300 300
Polygon -16777216 true false 240 255 240 105 225 105 225 255
Polygon -16777216 true false 270 90 270 105 240 105 240 90
Polygon -16777216 true false 285 270 285 225 270 225 270 270
Polygon -16777216 true false 270 210 270 225 255 225 255 180 270 180 270 150 255 150 255 60 270 60 270 150 285 150 285 180 270 180
Rectangle -1 true false 255 225 270 270
Rectangle -2674135 true false 210 210 225 255
Rectangle -1184463 true false 255 150 270 180
Rectangle -6459832 true false 240 90 255 240
Polygon -955883 true false 210 255 165 210 165 150 120 135 120 105 105 90 105 0 240 0 240 105 225 105 225 210 210 210
Polygon -1184463 true false 90 90 75 75 75 15 90 30 90 90
Polygon -1184463 true false 75 0 75 15 30 15 30 0
Polygon -955883 true false 75 75 60 60 60 45 45 30 30 30 30 15 75 15
Polygon -16777216 true false 300 90 285 90 285 45 270 45 270 30 285 30 285 15 270 15 255 15 255 0 300 0
Rectangle -16777216 true false 240 15 255 30
Rectangle -1 true false 240 0 255 15
Rectangle -1184463 true false 270 15 285 30
Rectangle -2674135 true false 195 15 210 30
Rectangle -2674135 true false 150 15 165 30
Rectangle -2674135 true false 105 15 120 30
Polygon -955883 true false 285 285 300 285 300 90 285 90 285 45 270 45 270 30 270 15 255 15 255 30 255 60 270 60 270 150 285 150 285 180 270 180 270 225 285 225 285 285
Rectangle -2674135 true false 240 30 255 90

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

forwardattack1
false
0
Polygon -10899396 true false 120 75 195 75 195 90 210 90 210 105 225 105 225 135 240 135 240 75 225 75 225 60 210 60 210 45 120 45 120 60 105 60 105 75 90 75 90 105 105 105 105 90 120 90
Polygon -955883 true false 105 90 105 105 195 105 195 120 210 120 210 135 225 135 225 105 210 105 210 90 195 90 195 75 120 75 120 90
Polygon -955883 true false 90 105 105 105 105 135 90 135
Rectangle -16777216 true false 120 120 135 135
Rectangle -16777216 true false 180 120 195 135
Rectangle -10899396 true false 120 105 135 120
Rectangle -10899396 true false 180 105 195 120
Polygon -6459832 true false 105 105 120 105 120 135 135 135 135 165 120 165 120 150 105 150
Polygon -6459832 true false 135 105 180 105 180 135 135 135
Polygon -6459832 true false 165 165 165 135 195 135 195 120 210 120 210 135 240 135 240 150 210 150 210 165 195 165 195 180 120 180 135 180 135 165
Polygon -6459832 true false 240 135 255 135 255 120 270 120 270 90 255 90 255 105 240 105
Polygon -16777216 true false 135 135 180 135 180 165 135 165
Polygon -16777216 true false 210 150 240 150 240 165 255 165 255 195 240 195 240 210 225 210 225 240 210 240 210 225 180 225 180 210 165 210 165 225 180 225 180 240 150 240 150 225 120 225 120 210 150 210 150 195 195 195 195 165 210 165 210 150
Rectangle -10899396 true false 165 210 180 225
Polygon -10899396 true false 240 195 255 195 255 240 240 240 240 255 210 255 210 240 225 240 225 210 240 210
Polygon -16777216 true false 255 225 270 225 270 240 285 240 285 270 225 270 225 255 240 255 240 240 255 240
Polygon -6459832 true false 180 225 210 225 210 270 165 270 165 240 180 240
Polygon -6459832 true false 90 135 75 135 75 120 60 120 60 90 75 90 75 45 90 45
Polygon -2674135 true false 90 75 105 75 105 30 75 30 75 45 60 45 60 75 45 75 45 90 30 90 30 120 45 120 45 135 60 135 60 150 75 150 75 165 90 165 90 135 75 135 75 120 60 120 60 90 75 90 75 45 90 45
Rectangle -7500403 true true 30 120 45 135
Rectangle -7500403 true true 45 135 60 150
Rectangle -7500403 true true 60 150 75 165
Polygon -10899396 true false 90 135 105 135 105 150 120 150 120 165 135 165 135 180 195 180 195 195 150 195 150 210 120 210 120 195 105 195 105 180 90 180
Rectangle -16777216 true false 105 195 120 210
Rectangle -16777216 true false 90 180 105 195
Polygon -10899396 true false 165 240 165 255 120 255 120 240 105 240 105 225 90 225 90 195 105 195 105 210 120 210 120 225 150 225 150 240
Polygon -16777216 true false 75 225 105 225 105 255 60 255 60 240 75 240

forwardattack2
false
13
Polygon -10899396 true false 120 75 195 75 195 90 210 90 210 105 225 105 225 135 240 135 240 75 225 75 225 60 210 60 210 45 120 45 120 60 105 60 105 75 90 75 90 105 105 105 105 90 120 90
Polygon -955883 true false 105 90 105 105 195 105 195 120 210 120 210 135 225 135 225 105 210 105 210 90 195 90 195 75 120 75 120 90
Polygon -955883 true false 90 105 105 105 105 135 90 135
Rectangle -16777216 true false 120 120 135 135
Rectangle -16777216 true false 180 120 195 135
Rectangle -10899396 true false 120 105 135 120
Rectangle -10899396 true false 180 105 195 120
Polygon -6459832 true false 105 105 120 105 120 135 135 135 135 165 120 165 120 150 105 150
Polygon -6459832 true false 135 105 180 105 180 135 135 135
Polygon -6459832 true false 165 165 165 135 195 135 195 120 210 120 210 135 240 135 240 150 210 150 210 165 195 165 195 180 120 180 135 180 135 165
Polygon -6459832 true false 240 135 255 135 255 120 270 120 270 90 255 90 255 105 240 105
Polygon -16777216 true false 135 135 180 135 180 165 135 165
Polygon -16777216 true false 210 150 240 150 240 165 255 165 255 195 240 195 240 210 225 210 225 240 210 240 210 225 180 225 180 210 165 210 165 225 180 225 180 240 150 240 150 225 120 225 120 210 150 210 150 195 195 195 195 165 210 165 210 150
Rectangle -10899396 true false 165 210 180 225
Polygon -10899396 true false 240 195 255 195 255 240 240 240 240 255 210 255 210 240 225 240 225 210 240 210
Polygon -16777216 true false 255 225 270 225 270 240 285 240 285 270 225 270 225 255 240 255 240 240 255 240
Polygon -6459832 true false 90 135 75 135 75 120 60 120 60 90 75 90 75 45 90 45
Polygon -2674135 true false 90 75 105 75 105 30 75 30 75 45 60 45 60 75 45 75 45 90 30 90 30 120 45 120 45 135 60 135 60 150 75 150 75 165 90 165 90 135 75 135 75 120 60 120 60 90 75 90 75 45 90 45
Rectangle -7500403 true false 30 120 45 135
Rectangle -7500403 true false 45 135 60 150
Rectangle -7500403 true false 60 150 75 165
Polygon -10899396 true false 90 135 105 135 105 150 120 150 120 165 135 165 135 180 195 180 195 195 150 195 150 210 120 210 120 195 105 195 105 180 90 180
Rectangle -16777216 true false 105 195 120 210
Rectangle -16777216 true false 90 180 105 195
Polygon -10899396 true false 165 240 165 255 120 255 120 240 105 240 105 225 90 225 90 195 105 195 105 210 120 210 120 225 150 225 150 240
Polygon -16777216 true false 75 225 105 225 105 255 60 255 60 240 75 240
Polygon -10899396 true false 210 255 225 255 225 285 105 285 105 255 120 255 120 270 210 270
Rectangle -7500403 true false 105 240 120 255
Rectangle -7500403 true false 120 255 150 270
Polygon -6459832 true false 150 270 210 270 210 225 180 225 180 240 165 240 165 255 150 255
Polygon -7500403 true false 150 285 150 300 195 300 195 285

forwardattack2sword
false
15
Rectangle -7500403 true false 150 0 195 135
Rectangle -7500403 true false 165 135 180 150

gravestone
false
0
Rectangle -16777216 true false 65 240 240 255
Rectangle -1 true false 66 210 240 240
Rectangle -13345367 true false 67 195 240 210
Rectangle -13345367 true false 67 150 75 208
Rectangle -13345367 true false 66 135 90 150
Rectangle -13345367 true false 225 135 240 195
Rectangle -13345367 true false 210 135 225 150
Rectangle -16777216 true false 75 150 90 195
Rectangle -16777216 true false 210 150 225 195
Rectangle -1 true false 90 90 210 195
Polygon -1 true false 90 91 105 91 105 76 120 76 120 61 135 61 135 46 165 46 165 61 180 61 180 76 195 76 195 91 210 91
Rectangle -13345367 true false 180 60 195 75
Rectangle -13345367 true false 195 75 210 90
Rectangle -13345367 true false 165 45 180 60
Rectangle -13345367 true false 210 90 225 135
Rectangle -16777216 true false 240 150 255 255
Rectangle -13345367 true false 132 81 154 173
Rectangle -13345367 true false 106 112 191 134
Rectangle -16777216 true false 106 135 131 146
Rectangle -16777216 true false 139 173 163 182
Rectangle -16777216 true false 155 138 160 139
Rectangle -16777216 true false 164 138 165 177
Rectangle -16777216 true false 169 134 195 146
Rectangle -16777216 true false 190 113 197 144
Rectangle -16777216 true false 154 134 168 182
Rectangle -16777216 true false 155 81 166 112

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

key
false
0
Rectangle -16777216 true false 120 180 135 255
Rectangle -16777216 true false 135 255 165 270
Rectangle -16777216 true false 165 240 195 255
Rectangle -16777216 true false 195 210 210 240
Rectangle -16777216 true false 165 195 195 210
Rectangle -16777216 true false 165 180 180 195
Rectangle -16777216 true false 180 165 210 180
Rectangle -16777216 true false 210 150 225 165
Rectangle -16777216 true false 225 120 240 150
Rectangle -16777216 true false 210 105 225 120
Rectangle -16777216 true false 225 90 240 105
Rectangle -16777216 true false 240 60 255 90
Rectangle -16777216 true false 225 45 240 60
Rectangle -16777216 true false 210 30 225 45
Rectangle -16777216 true false 195 45 210 60
Rectangle -16777216 true false 180 60 210 75
Rectangle -16777216 true false 120 45 180 60
Rectangle -16777216 true false 90 60 120 75
Rectangle -16777216 true false 90 45 105 60
Rectangle -16777216 true false 75 30 90 45
Rectangle -16777216 true false 60 45 75 60
Rectangle -16777216 true false 45 60 60 90
Rectangle -16777216 true false 60 90 75 105
Rectangle -16777216 true false 75 105 90 120
Rectangle -16777216 true false 60 120 75 150
Rectangle -16777216 true false 75 150 90 165
Rectangle -16777216 true false 90 165 120 180
Rectangle -6459832 true false 120 60 180 75
Rectangle -6459832 true false 225 60 240 90
Rectangle -6459832 true false 90 150 150 165
Rectangle -6459832 true false 120 165 180 180
Rectangle -6459832 true false 135 180 150 255
Rectangle -6459832 true false 165 225 195 240
Rectangle -1 true false 165 210 180 225
Rectangle -6459832 true false 60 60 75 90
Rectangle -6459832 true false 210 90 225 105
Rectangle -6459832 true false 210 120 225 150
Rectangle -6459832 true false 180 150 210 165
Rectangle -6459832 true false 75 120 90 150
Rectangle -6459832 true false 90 105 105 120
Rectangle -6459832 true false 90 75 120 90
Rectangle -6459832 true false 75 90 90 105
Rectangle -1184463 true false 75 45 90 90
Polygon -1184463 true false 90 90 90 105 105 105 105 120 90 120 90 150 150 150 150 165 180 165 180 150 210 150 210 90 225 90 225 45 210 45 210 75 120 75 120 90
Rectangle -1184463 true false 150 180 165 255
Rectangle -1184463 true false 180 210 195 225
Rectangle -1 true false 165 90 180 105
Polygon -16777216 true false 105 105 105 120 105 135 120 135 120 150 135 150 135 120 120 120 120 105
Polygon -16777216 true false 180 105 180 120 165 120 165 150 180 150 180 135 195 135 195 105

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leftattack1
false
15
Rectangle -10899396 true false 165 195 195 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 165 210 225 225
Rectangle -10899396 true false 210 180 240 210
Rectangle -16777216 true false 105 180 120 210
Rectangle -16777216 true false 120 195 165 210
Rectangle -10899396 true false 120 180 165 195
Rectangle -10899396 true false 105 150 150 180
Rectangle -10899396 true false 120 135 225 150
Rectangle -10899396 true false 195 150 210 165
Rectangle -10899396 true false 150 120 210 135
Rectangle -16777216 true false 210 165 225 180
Rectangle -16777216 true false 105 135 120 150
Rectangle -6459832 true false 75 135 90 165
Rectangle -6459832 true false 60 90 90 105
Rectangle -6459832 true false 90 75 150 135
Rectangle -6459832 true false 150 105 180 120
Rectangle -6459832 true false 165 75 195 105
Rectangle -6459832 true false 180 60 195 75
Rectangle -6459832 true false 195 45 210 90
Rectangle -955883 true false 150 45 165 105
Rectangle -955883 true false 165 60 180 75
Rectangle -955883 true false 90 30 150 75
Rectangle -955883 true false 75 45 90 60
Rectangle -955883 true false 105 75 120 105
Rectangle -16777216 true false 105 75 120 90
Rectangle -10899396 true false 135 15 195 30
Rectangle -10899396 true false 150 30 195 45
Rectangle -10899396 true false 165 45 195 60
Rectangle -10899396 true false 195 30 225 45
Rectangle -10899396 true false 210 45 240 90
Rectangle -955883 true false 195 90 225 120
Rectangle -955883 true false 180 105 195 120
Rectangle -10899396 true false 240 45 255 75
Rectangle -10899396 true false 255 60 270 75
Rectangle -10899396 true false 255 75 270 90
Rectangle -10899396 true false 90 195 105 210
Polygon -6459832 true false 135 225 135 240 105 240 90 240 90 225 75 225 75 210 105 210 105 225
Polygon -6459832 true false 195 225 195 240 240 240 240 225 255 225 255 210 225 210 225 225 195 225
Rectangle -6459832 true false 90 135 135 180
Rectangle -16777216 true false 180 150 210 195
Rectangle -10899396 true false 195 195 225 210
Rectangle -16777216 true false 165 150 180 165
Rectangle -16777216 true false 165 180 180 195
Polygon -10899396 true false 255 195 255 210 240 210 240 180 225 180 225 165 210 165 210 150 225 150 225 165 240 165 240 180 240 195 255 195
Polygon -16777216 true false 195 180 135 180 135 135 195 135
Polygon -6459832 true false 75 225 60 225 60 240 90 240 90 225
Polygon -6459832 true false 240 210 240 195 270 195 270 210
Polygon -1184463 true false 75 90 60 90 60 195 90 195 90 180 75 180

leftattack2
false
15
Rectangle -10899396 true false 165 195 195 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 165 210 225 225
Rectangle -10899396 true false 210 180 240 210
Rectangle -16777216 true false 105 180 120 210
Rectangle -16777216 true false 120 195 165 210
Rectangle -10899396 true false 120 180 165 195
Rectangle -10899396 true false 105 150 150 180
Rectangle -10899396 true false 120 135 225 150
Rectangle -10899396 true false 195 150 210 165
Rectangle -10899396 true false 150 120 210 135
Rectangle -16777216 true false 210 165 225 180
Rectangle -16777216 true false 105 135 120 150
Rectangle -6459832 true false 75 135 90 165
Rectangle -6459832 true false 60 90 90 105
Rectangle -6459832 true false 90 75 150 135
Rectangle -6459832 true false 150 105 180 120
Rectangle -6459832 true false 165 75 195 105
Rectangle -6459832 true false 180 60 195 75
Rectangle -6459832 true false 195 45 210 90
Rectangle -955883 true false 150 45 165 105
Rectangle -955883 true false 165 60 180 75
Rectangle -955883 true false 90 30 150 75
Rectangle -955883 true false 75 45 90 60
Rectangle -955883 true false 105 75 120 105
Rectangle -16777216 true false 105 75 120 90
Rectangle -10899396 true false 135 15 195 30
Rectangle -10899396 true false 150 30 195 45
Rectangle -10899396 true false 165 45 195 60
Rectangle -10899396 true false 195 30 225 45
Rectangle -10899396 true false 210 45 240 90
Rectangle -955883 true false 195 90 225 120
Rectangle -955883 true false 180 105 195 120
Rectangle -10899396 true false 240 45 255 75
Rectangle -10899396 true false 255 60 270 75
Rectangle -10899396 true false 255 75 270 90
Rectangle -10899396 true false 90 195 105 210
Polygon -6459832 true false 135 225 135 240 105 240 90 240 90 225 75 225 75 210 105 210 105 225
Polygon -6459832 true false 195 225 195 240 240 240 240 225 255 225 255 210 225 210 225 225 195 225
Rectangle -6459832 true false 90 135 135 180
Rectangle -16777216 true false 180 150 210 195
Rectangle -10899396 true false 195 195 225 210
Rectangle -16777216 true false 165 150 180 165
Rectangle -16777216 true false 165 180 180 195
Polygon -10899396 true false 255 195 255 210 240 210 240 180 225 180 225 165 210 165 210 150 225 150 225 165 240 165 240 180 240 195 255 195
Polygon -16777216 true false 195 180 135 180 135 135 195 135
Polygon -6459832 true false 75 225 60 225 60 240 90 240 90 225
Polygon -6459832 true false 240 210 240 195 270 195 270 210
Polygon -1184463 true false 75 90 60 90 60 195 90 195 90 180 75 180
Rectangle -7500403 true false 0 135 60 180

leftattack2sword
false
6
Rectangle -7500403 true false 225 135 300 180
Rectangle -7500403 true false 210 150 225 165

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0

link gets key
false
0
Rectangle -7500403 true true 90 240 135 270
Rectangle -6459832 true false 90 240 135 270
Rectangle -6459832 true false 165 240 210 270
Polygon -10899396 true false 75 210 75 240 225 240 225 210 180 210 180 225 120 225 120 210
Polygon -16777216 true false 75 195 75 210 120 210 120 225 180 225 180 210 225 210 225 195 180 195 180 180 120 180 120 195
Rectangle -10899396 true false 135 195 165 210
Polygon -10899396 true false 75 195 75 180 90 180 90 150 105 150 105 135 120 135 120 150 180 150 180 135 195 135 195 150 210 150 210 180 225 180 225 195 180 195 180 180 120 180 120 195
Polygon -16777216 true false 75 180 75 150 60 150 60 105 45 105 45 60 75 60 75 105 90 105 90 120 105 120 105 150 90 150 90 180
Polygon -16777216 true false 195 150 210 150 210 180 225 180 225 150 240 150 240 105 255 105 255 60 225 60 225 105 210 105 210 120 195 120 195 150 210 150
Polygon -6459832 true false 75 75 90 75 90 90 105 90 105 75 195 75 195 90 210 90 210 75 225 75 225 105 210 105 210 120 195 120 195 135 180 135 180 150 120 150 120 135 105 135 105 120 90 120 90 105 75 105
Rectangle -955883 true false 90 90 105 105
Rectangle -955883 true false 195 90 210 105
Rectangle -955883 true false 105 60 195 75
Rectangle -955883 true false 120 45 180 60
Rectangle -2674135 true false 90 60 105 75
Rectangle -10899396 true false 90 60 105 75
Rectangle -10899396 true false 105 45 120 60
Rectangle -10899396 true false 120 30 180 45
Rectangle -10899396 true false 180 45 195 60
Rectangle -10899396 true false 195 60 210 75
Rectangle -16777216 true false 90 75 105 90
Rectangle -16777216 true false 195 75 210 90
Rectangle -6459832 true false 45 30 75 60
Rectangle -6459832 true false 75 45 90 60
Rectangle -6459832 true false 225 30 255 60
Rectangle -6459832 true false 210 45 225 60
Rectangle -16777216 true false 135 120 165 150
Rectangle -16777216 true false 120 75 135 90
Rectangle -16777216 true false 165 75 180 90
Rectangle -955883 true false 120 90 135 105
Rectangle -955883 true false 165 90 180 105

littledeadtreetex
false
0
Polygon -6459832 true false 150 45 180 45 180 60 195 60 195 75 210 75 210 90 225 90 225 105 210 105 210 90 195 90 195 120 210 120 210 165 180 165 180 180 195 180 195 195 135 195 135 225 120 225 120 210 105 210 105 225 75 225 75 210 45 210 45 195 30 195 30 150 45 150 45 135 30 135 30 105 45 105 45 75 60 75 60 45 75 45 75 60 90 60 90 30 105 30 105 45 120 45 120 30 135 30 135 45 150 45
Polygon -16777216 true false 90 60 90 75 90 60 90 75 105 75 105 60 90 60
Polygon -16777216 true false 120 105 135 120
Polygon -16777216 true false 120 105 120 120 135 120 135 105
Polygon -16777216 true false 135 30 195 30 195 45 240 45 240 60 255 60 255 90 270 90 270 105 255 105 255 120 270 120 270 165 255 165 255 195 240 195 240 210 195 210 195 225 150 225 150 210 135 210 135 195 195 195 195 180 180 180 180 165 210 165 210 120 195 120 195 90 210 90 210 105 225 105 225 90 210 90 210 75 195 75 195 60 180 60 180 45 135 45
Polygon -13345367 true false 105 210 120 210 120 225 135 225 135 210 150 210 150 225 180 225 180 240 105 240 105 210 120 210 105 210
Rectangle -1 true false 180 210 195 225
Polygon -16777216 true false 180 225 285 225 285 240 255 240 255 255 75 255 75 240 90 240 90 225 105 225 105 240 180 240 180 225
Rectangle -16777216 true false 60 180 75 195
Rectangle -16777216 true false 90 150 105 165
Rectangle -16777216 true false 60 120 75 135

littletreetex
false
0
Polygon -10899396 true false 150 45 180 45 180 60 195 60 195 75 210 75 210 90 225 90 225 105 210 105 210 90 195 90 195 120 210 120 210 165 180 165 180 180 195 180 195 195 135 195 135 225 120 225 120 210 105 210 105 225 75 225 75 210 45 210 45 195 30 195 30 150 45 150 45 135 30 135 30 105 45 105 45 75 60 75 60 45 75 45 75 60 90 60 90 30 105 30 105 45 120 45 120 30 135 30 135 45 150 45
Polygon -16777216 true false 90 60 90 75 90 60 90 75 105 75 105 60 90 60
Polygon -16777216 true false 120 105 135 120
Polygon -16777216 true false 120 105 120 120 135 120 135 105
Polygon -16777216 true false 135 30 195 30 195 45 240 45 240 60 255 60 255 90 270 90 270 105 255 105 255 120 270 120 270 165 255 165 255 195 240 195 240 210 195 210 195 225 150 225 150 210 135 210 135 195 195 195 195 180 180 180 180 165 210 165 210 120 195 120 195 90 210 90 210 105 225 105 225 90 210 90 210 75 195 75 195 60 180 60 180 45 135 45
Polygon -13345367 true false 105 210 120 210 120 225 135 225 135 210 150 210 150 225 180 225 180 240 105 240 105 210 120 210 105 210
Rectangle -10899396 true false 180 210 195 225
Polygon -16777216 true false 180 225 285 225 285 240 255 240 255 255 75 255 75 240 90 240 90 225 105 225 105 240 180 240 180 225
Rectangle -16777216 true false 60 180 75 195
Rectangle -16777216 true false 90 150 105 165
Rectangle -16777216 true false 60 120 75 135

octorok1
true
0
Rectangle -2674135 true false 120 195 180 210
Rectangle -2674135 true false 105 210 195 225
Rectangle -955883 true false 90 210 105 225
Rectangle -2674135 true false 195 165 210 180
Rectangle -2674135 true false 90 225 120 240
Rectangle -2674135 true false 180 225 210 240
Rectangle -955883 true false 195 210 210 225
Rectangle -955883 true false 120 225 135 240
Rectangle -955883 true false 165 225 180 240
Rectangle -2674135 true false 135 225 165 240
Polygon -2674135 true false 90 210 90 195 75 195 75 165 90 165 90 135 120 135 120 150 105 150 105 195 120 195 120 180 135 180 135 135 120 135 120 120 180 120 180 135 165 135 165 180 180 180 180 195 195 195 195 150 180 150 180 135 210 135 210 165 225 165 225 195 210 195 210 210 255 210 255 195 240 195 240 180 255 180 255 165 270 165 270 150 225 150 225 120 255 120 255 105 210 105 210 120 180 120 180 105 195 105 195 90 210 90 210 75 225 75 225 60 75 60 75 75 90 75 90 90 105 90 105 105 120 105 120 120 90 120 90 105 45 105 45 120 75 120 75 150 30 150 30 165 45 165 45 180 60 180 60 195 45 195 45 210
Polygon -1 true false 90 210 120 210 120 195 105 195 105 150 120 150 120 135 90 135 90 165 75 165 75 195 90 195
Polygon -1 true false 120 195 120 180 135 180 135 135 120 135 120 120 180 120 180 135 165 135 165 180 180 180 180 195
Polygon -1 true false 180 150 180 135 210 135 210 165 225 165 225 195 210 195 210 210 180 210 180 195 195 195 195 150
Polygon -2674135 true false 255 210 270 210 270 225 225 225 225 240 240 240 240 255 255 255 255 270 225 270 225 255 210 255 210 270 180 270 180 285 150 285 120 285 120 270 90 270 90 255 75 255 75 270 45 270 45 255 60 255 60 240 75 240 75 225 30 225 30 210 90 210 90 240 210 240 210 210
Rectangle -955883 true false 90 240 105 255
Rectangle -955883 true false 195 240 210 255
Rectangle -955883 true false 135 270 165 285

octorok2
true
0
Rectangle -2674135 true false 120 195 180 210
Rectangle -2674135 true false 105 210 195 225
Rectangle -955883 true false 90 210 105 225
Rectangle -2674135 true false 195 165 210 180
Rectangle -2674135 true false 90 225 120 240
Rectangle -2674135 true false 180 225 210 240
Rectangle -955883 true false 195 210 210 225
Rectangle -955883 true false 120 225 135 240
Rectangle -955883 true false 165 225 180 240
Rectangle -2674135 true false 135 225 165 240
Polygon -2674135 true false 90 195 75 195 75 165 90 165 90 135 120 135 120 150 105 150 105 195 120 195 120 180 135 180 135 135 120 135 120 120 180 120 180 135 165 135 165 180 180 180 180 195 195 195 195 150 180 150 180 135 210 135 210 165 225 165 225 195 210 195 255 195 255 180 240 180 240 135 255 135 255 165 240 165 240 150 225 150 225 120 225 105 195 105 195 120 180 120 180 105 180 90 180 60 195 60 210 60 225 60 225 45 75 45 75 60 90 60 120 60 120 90 120 105 120 120 105 120 105 105 75 105 75 120 75 150 60 150 60 165 45 165 45 135 60 135 60 180 45 180 45 195
Polygon -1 true false 90 210 120 210 120 195 105 195 105 150 120 150 120 135 90 135 90 165 75 165 75 195 90 195
Polygon -1 true false 120 195 120 180 135 180 135 135 120 135 120 120 180 120 180 135 165 135 165 180 180 180 180 195
Polygon -1 true false 180 150 180 135 210 135 210 165 225 165 225 195 210 195 210 210 180 210 180 195 195 195 195 150
Polygon -2674135 true false 255 210 225 210 225 225 240 225 240 240 255 240 255 255 225 255 210 255 210 270 180 270 180 285 150 285 120 285 120 270 90 270 90 255 75 255 45 255 45 240 60 240 60 225 75 225 75 210 90 210 90 240 210 240 210 210
Rectangle -955883 true false 90 240 105 255
Rectangle -955883 true false 195 240 210 255
Rectangle -955883 true false 135 270 165 285
Rectangle -2674135 true false 30 195 90 210
Rectangle -2674135 true false 210 195 270 210

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rightattack1
false
15
Rectangle -10899396 true false 105 195 135 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 75 210 135 225
Rectangle -10899396 true false 60 180 90 210
Rectangle -16777216 true false 180 180 195 210
Rectangle -16777216 true false 135 195 180 210
Rectangle -10899396 true false 135 180 180 195
Rectangle -10899396 true false 150 150 195 180
Rectangle -10899396 true false 75 135 180 150
Rectangle -10899396 true false 90 150 105 165
Rectangle -10899396 true false 90 120 150 135
Rectangle -16777216 true false 75 165 90 180
Rectangle -16777216 true false 180 135 195 150
Rectangle -6459832 true false 210 135 225 165
Rectangle -6459832 true false 210 90 240 105
Rectangle -6459832 true false 150 75 210 135
Rectangle -6459832 true false 120 105 150 120
Rectangle -6459832 true false 105 75 135 105
Rectangle -6459832 true false 105 60 120 75
Rectangle -6459832 true false 90 45 105 90
Rectangle -955883 true false 135 45 150 105
Rectangle -955883 true false 120 60 135 75
Rectangle -955883 true false 150 30 210 75
Rectangle -955883 true false 210 45 225 60
Rectangle -955883 true false 180 75 195 105
Rectangle -16777216 true false 180 75 195 90
Rectangle -10899396 true false 105 15 165 30
Rectangle -10899396 true false 105 30 150 45
Rectangle -10899396 true false 105 45 135 60
Rectangle -10899396 true false 75 30 105 45
Rectangle -10899396 true false 60 45 90 90
Rectangle -955883 true false 75 90 105 120
Rectangle -955883 true false 105 105 120 120
Rectangle -10899396 true false 45 45 60 75
Rectangle -10899396 true false 30 60 45 75
Rectangle -10899396 true false 30 75 45 90
Rectangle -10899396 true false 195 195 210 210
Polygon -6459832 true false 165 225 165 240 195 240 210 240 210 225 225 225 225 210 195 210 195 225
Polygon -6459832 true false 105 225 105 240 60 240 60 225 45 225 45 210 75 210 75 225 105 225
Rectangle -6459832 true false 165 135 210 180
Rectangle -16777216 true false 90 150 120 195
Rectangle -10899396 true false 75 195 105 210
Rectangle -16777216 true false 120 150 135 165
Rectangle -16777216 true false 120 180 135 195
Polygon -10899396 true false 45 195 45 210 60 210 60 180 75 180 75 165 90 165 90 150 75 150 75 165 60 165 60 180 60 195 45 195
Polygon -16777216 true false 105 180 165 180 165 135 105 135
Polygon -6459832 true false 225 225 240 225 240 240 210 240 210 225
Polygon -6459832 true false 60 210 60 195 30 195 30 210
Polygon -1184463 true false 225 90 240 90 240 195 210 195 210 180 225 180

rightattack2
false
15
Rectangle -10899396 true false 105 195 135 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 75 210 135 225
Rectangle -10899396 true false 60 180 90 210
Rectangle -16777216 true false 180 180 195 210
Rectangle -16777216 true false 135 195 180 210
Rectangle -10899396 true false 135 180 180 195
Rectangle -10899396 true false 150 150 195 180
Rectangle -10899396 true false 75 135 180 150
Rectangle -10899396 true false 90 150 105 165
Rectangle -10899396 true false 90 120 150 135
Rectangle -16777216 true false 75 165 90 180
Rectangle -16777216 true false 180 135 195 150
Rectangle -6459832 true false 210 135 225 165
Rectangle -6459832 true false 210 90 240 105
Rectangle -6459832 true false 150 75 210 135
Rectangle -6459832 true false 120 105 150 120
Rectangle -6459832 true false 105 75 135 105
Rectangle -6459832 true false 105 60 120 75
Rectangle -6459832 true false 90 45 105 90
Rectangle -955883 true false 135 45 150 105
Rectangle -955883 true false 120 60 135 75
Rectangle -955883 true false 150 30 210 75
Rectangle -955883 true false 210 45 225 60
Rectangle -955883 true false 180 75 195 105
Rectangle -16777216 true false 180 75 195 90
Rectangle -10899396 true false 105 15 165 30
Rectangle -10899396 true false 105 30 150 45
Rectangle -10899396 true false 105 45 135 60
Rectangle -10899396 true false 75 30 105 45
Rectangle -10899396 true false 60 45 90 90
Rectangle -955883 true false 75 90 105 120
Rectangle -955883 true false 105 105 120 120
Rectangle -10899396 true false 45 45 60 75
Rectangle -10899396 true false 30 60 45 75
Rectangle -10899396 true false 30 75 45 90
Rectangle -10899396 true false 195 195 210 210
Polygon -6459832 true false 165 225 165 240 195 240 210 240 210 225 225 225 225 210 195 210 195 225
Polygon -6459832 true false 105 225 105 240 60 240 60 225 45 225 45 210 75 210 75 225 105 225
Rectangle -6459832 true false 165 135 210 180
Rectangle -16777216 true false 90 150 120 195
Rectangle -10899396 true false 75 195 105 210
Rectangle -16777216 true false 120 150 135 165
Rectangle -16777216 true false 120 180 135 195
Polygon -10899396 true false 45 195 45 210 60 210 60 180 75 180 75 165 90 165 90 150 75 150 75 165 60 165 60 180 60 195 45 195
Polygon -16777216 true false 105 180 165 180 165 135 105 135
Polygon -6459832 true false 225 225 240 225 240 240 210 240 210 225
Polygon -6459832 true false 60 210 60 195 30 195 30 210
Polygon -1184463 true false 225 90 240 90 240 195 210 195 210 180 225 180
Rectangle -7500403 true false 240 135 300 180

rightattack2sword
false
6
Rectangle -7500403 true false 0 135 75 180
Rectangle -7500403 true false 75 150 90 165

rocktex
false
6
Rectangle -16777216 true false 120 315 195 330
Rectangle -1184463 true false 105 150 120 150
Polygon -955883 true false 135 90 135 225 165 225 195 255 195 225 210 225 210 285 225 300 255 300 285 285 285 270 285 225 300 210 300 180 285 150 255 150 240 150 210 165 210 225 210 165 240 150 285 150 285 90 240 45 225 45 195 15 180 15 150 45 150 75 135 90
Rectangle -1184463 true false 135 90 150 255
Polygon -16777216 true false 150 225 165 225 195 255 150 255
Rectangle -1184463 true false 210 165 225 285
Rectangle -1184463 true false 225 150 285 165
Rectangle -2674135 true false 285 135 300 150
Line -14835848 false 150 90 150 225
Polygon -16777216 true false 300 120 315 150 315 120 300 120
Polygon -1 true false 225 285 225 300 210 285
Polygon -1184463 true false 210 165 225 165 225 150 210 165
Polygon -16777216 true false 285 135 300 135 300 30 270 0 285 45 240 45 285 90
Polygon -955883 true false 225 0 225 30 240 45 255 45 270 30 270 0 225 0 210 0
Polygon -955883 true false 225 30 210 0 225 0
Polygon -10899396 true false 225 30 225 15 240 30
Polygon -1184463 true false 225 15 225 30 240 45 255 45 270 30
Polygon -16777216 true false 255 45 270 30 270 0 285 0 285 45
Polygon -1 true false 135 90 150 90 150 75
Polygon -1 true false 150 75 165 60 165 45 195 15 180 15 150 45 150 75
Polygon -955883 true false 195 255 180 285 195 300 75 300 90 285 90 255 195 255
Polygon -16777216 true false 225 300 210 285 210 225 195 225 195 255 180 285 195 300
Polygon -16777216 true false 285 225 300 210 300 300 255 300 285 285
Polygon -1 true false 75 300 75 270 105 240 135 240 135 255 90 255 90 285
Polygon -1 true false 75 285 45 300 75 300
Polygon -1 true false 30 225 15 255 15 285 45 300 30 285 30 255 45 255 45 225
Polygon -16777216 true false 45 300 75 285 75 270 105 240 135 240 135 90 150 75 150 45 165 30 150 30 120 45 120 180 105 195 105 225 90 240 60 240 75 270 60 240
Polygon -16777216 true false 45 300 15 285 15 255 30 225 30 195 15 195 15 225 0 240 0 300
Polygon -955883 true false 45 300 30 285 30 255 45 255 45 225 30 225 30 150 45 150 45 90 30 90 30 45 75 30 75 45 120 60 120 180 105 195 105 225 90 240 60 240
Polygon -1184463 true false 30 90 45 105 45 135 30 150 15 150 15 105
Polygon -1184463 true false 30 90 45 105 45 90
Polygon -1184463 true false 30 150 45 150 45 135
Polygon -2674135 true false 15 150 0 150 15 165
Polygon -16777216 true false 15 195 30 195 30 150 15 150 0 165 0 195 15 210
Polygon -16777216 true false 0 195 15 225 0 240
Polygon -16777216 true false 15 225 0 195 15 210
Polygon -1 true false 33 -5 45 13 77 12 76 0
Polygon -1184463 true false 74 45 73 30 119 61
Polygon -955883 true false 77 0 90 15 120 46 149 31 160 34 203 -7
Polygon -16777216 true false 238 45 226 43 195 15 182 15 196 0 211 0 223 28
Polygon -16777216 true false 119 59 120 46 83 14 43 14 35 0 15 30 0 149 15 149 15 105 30 90 30 45 75 30 120 60
Polygon -16777216 true false 300 180 285 150 300 150

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

sidetreetex1
false
0
Polygon -16777216 true false 0 300 30 300 30 285 60 285 60 270 90 270 105 255 120 255 135 225 150 210 150 150 195 135 195 105 240 75 255 60 255 45 300 45 300 0 270 0 270 30 255 30 240 45 240 60 210 90 210 30 225 0 195 0 195 30 195 90 180 105 180 135 135 150 135 210 105 240 75 255 60 255 45 255 45 270 15 270 15 285 0 285 0 300
Polygon -16777216 true false 60 255 60 105 75 105 75 255
Polygon -16777216 true false 30 90 30 105 60 105 60 90
Polygon -16777216 true false 15 270 15 225 30 225 30 270
Polygon -16777216 true false 30 210 30 225 45 225 45 180 30 180 30 150 45 150 45 60 30 60 30 150 15 150 15 180 30 180
Rectangle -1 true false 30 225 45 270
Rectangle -1 true false 75 210 90 255
Rectangle -1184463 true false 30 150 45 180
Rectangle -10899396 true false 45 105 60 255
Polygon -10899396 true false 90 255 135 210 135 150 180 135 180 105 195 90 195 0 60 0 60 105 75 105 75 210 90 210
Polygon -1184463 true false 210 90 225 75 225 15 210 30 210 90
Polygon -1184463 true false 225 0 225 15 270 15 270 0
Polygon -10899396 true false 225 75 240 60 240 45 255 30 270 30 270 15 225 15
Polygon -16777216 true false 0 90 15 90 15 45 30 45 30 30 15 30 15 15 30 15 45 15 45 0 0 0
Rectangle -16777216 true false 45 15 60 30
Rectangle -1 true false 45 0 60 15
Rectangle -1184463 true false 15 15 30 30
Rectangle -1184463 true false 90 15 105 30
Rectangle -1184463 true false 135 15 150 30
Rectangle -1184463 true false 180 15 195 30
Polygon -10899396 true false 15 285 0 285 0 90 15 90 15 45 30 45 30 30 30 15 45 15 45 30 45 60 30 60 30 150 15 150 15 180 30 180 30 225 15 225 15 285

sidetreetex2
false
0
Polygon -16777216 true false 300 0 270 0 270 15 240 15 240 30 210 30 195 45 180 45 165 75 150 90 150 150 105 165 105 195 60 225 45 240 45 255 0 255 0 300 30 300 30 270 45 270 60 255 60 240 90 210 90 270 75 300 105 300 105 270 105 210 120 195 120 165 165 150 165 90 195 60 225 45 240 45 255 45 255 30 285 30 285 15 300 15 300 0
Polygon -16777216 true false 240 45 240 195 225 195 225 45
Polygon -16777216 true false 270 210 270 195 240 195 240 210
Polygon -16777216 true false 285 30 285 75 270 75 270 30
Polygon -16777216 true false 270 90 270 75 255 75 255 120 270 120 270 150 255 150 255 240 270 240 270 150 285 150 285 120 270 120
Rectangle -1 true false 255 30 270 75
Rectangle -1 true false 210 45 225 90
Rectangle -1184463 true false 255 120 270 150
Rectangle -1 true false 240 45 255 195
Polygon -10899396 true false 210 45 165 90 165 150 120 165 120 195 105 210 105 300 240 300 240 195 225 195 225 90 210 90
Polygon -1184463 true false 90 210 75 225 75 285 90 270 90 210
Polygon -1184463 true false 75 300 75 285 30 285 30 300
Polygon -10899396 true false 75 225 60 240 60 255 45 270 30 270 30 285 75 285
Polygon -16777216 true false 300 210 285 210 285 255 270 255 270 270 285 270 285 285 270 285 255 285 255 300 300 300
Rectangle -16777216 true false 240 270 255 285
Rectangle -1 true false 240 285 255 300
Rectangle -1184463 true false 270 270 285 285
Rectangle -1184463 true false 195 270 210 285
Rectangle -1184463 true false 150 270 165 285
Rectangle -1184463 true false 105 270 120 285
Polygon -10899396 true false 285 15 300 15 300 210 285 210 285 255 270 255 270 270 270 285 255 285 255 270 255 240 270 240 270 150 285 150 285 120 270 120 270 75 285 75 285 15

sidetreetex3
false
0
Polygon -16777216 true false 300 300 270 300 270 285 240 285 240 270 210 270 195 255 180 255 165 225 150 210 150 150 105 135 105 105 60 75 45 60 45 45 0 45 0 0 30 0 30 30 45 30 60 45 60 60 90 90 90 30 75 0 105 0 105 30 105 90 120 105 120 135 165 150 165 210 195 240 225 255 240 255 255 255 255 270 285 270 285 285 300 285 300 300
Polygon -16777216 true false 240 255 240 105 225 105 225 255
Polygon -16777216 true false 270 90 270 105 240 105 240 90
Polygon -16777216 true false 285 270 285 225 270 225 270 270
Polygon -16777216 true false 270 210 270 225 255 225 255 180 270 180 270 150 255 150 255 60 270 60 270 150 285 150 285 180 270 180
Rectangle -1 true false 255 225 270 270
Rectangle -1 true false 210 210 225 255
Rectangle -1184463 true false 255 150 270 180
Rectangle -1 true false 240 105 255 255
Polygon -10899396 true false 210 255 165 210 165 150 120 135 120 105 105 90 105 0 240 0 240 105 225 105 225 210 210 210
Polygon -1184463 true false 90 90 75 75 75 15 90 30 90 90
Polygon -1184463 true false 75 0 75 15 30 15 30 0
Polygon -10899396 true false 75 75 60 60 60 45 45 30 30 30 30 15 75 15
Polygon -16777216 true false 300 90 285 90 285 45 270 45 270 30 285 30 285 15 270 15 255 15 255 0 300 0
Rectangle -16777216 true false 240 15 255 30
Rectangle -1 true false 240 0 255 15
Rectangle -1184463 true false 270 15 285 30
Rectangle -1184463 true false 195 15 210 30
Rectangle -1184463 true false 150 15 165 30
Rectangle -1184463 true false 105 15 120 30
Polygon -10899396 true false 285 285 300 285 300 90 285 90 285 45 270 45 270 30 270 15 255 15 255 30 255 60 270 60 270 150 285 150 285 180 270 180 270 225 285 225 285 285

sidetreetex4
false
0
Polygon -16777216 true false 0 0 30 0 30 15 60 15 60 30 90 30 105 45 120 45 135 75 150 90 150 150 195 165 195 195 240 225 255 240 255 255 300 255 300 300 270 300 270 270 255 270 240 255 240 240 210 210 210 270 225 300 195 300 195 270 195 210 180 195 180 165 135 150 135 90 105 60 75 45 60 45 45 45 45 30 15 30 15 15 0 15 0 0
Polygon -16777216 true false 60 45 60 195 75 195 75 45
Polygon -16777216 true false 30 210 30 195 60 195 60 210
Polygon -16777216 true false 15 30 15 75 30 75 30 30
Polygon -16777216 true false 30 90 30 75 45 75 45 120 30 120 30 150 45 150 45 240 30 240 30 150 15 150 15 120 30 120
Rectangle -1 true false 30 30 45 75
Rectangle -1 true false 75 45 90 90
Rectangle -1184463 true false 30 120 45 150
Rectangle -1 true false 45 45 60 195
Polygon -10899396 true false 90 45 135 90 135 150 180 165 180 195 195 210 195 300 60 300 60 195 75 195 75 90 90 90
Polygon -1184463 true false 210 210 225 225 225 285 210 270 210 210
Polygon -1184463 true false 225 300 225 285 270 285 270 300
Polygon -10899396 true false 225 225 240 240 240 255 255 270 270 270 270 285 225 285
Polygon -16777216 true false 0 210 15 210 15 255 30 255 30 270 15 270 15 285 30 285 45 285 45 300 0 300
Rectangle -16777216 true false 45 270 60 285
Rectangle -1 true false 45 285 60 300
Rectangle -1184463 true false 15 270 30 285
Rectangle -1184463 true false 90 270 105 285
Rectangle -1184463 true false 135 270 150 285
Rectangle -1184463 true false 180 270 195 285
Polygon -10899396 true false 15 15 0 15 0 210 15 210 15 255 30 255 30 270 30 285 45 285 45 270 45 240 30 240 30 150 15 150 15 120 30 120 30 75 15 75 15 15

singlerock
false
0
Polygon -6459832 true false 135 105 165 105 165 225 135 225
Polygon -16777216 true false 135 225 150 225 150 240 195 240 195 225 180 225 180 210 210 210 210 225 285 225 285 240 240 240 240 255 60 255 60 240 135 240
Polygon -6459832 true false 165 195 165 225 150 225 150 240 195 240 195 225 180 225 180 210 210 210 210 135 240 135 240 105 195 105 195 195
Rectangle -6459832 true false 165 180 180 195
Polygon -6459832 true false 60 240 60 225 45 225 45 180 60 180 60 135 45 135 45 60 45 75 60 75 60 120 75 120 75 75 90 75 90 45 120 45 120 105 105 105 105 195 120 195 120 225 135 225 135 240
Polygon -16777216 true false 120 195 120 225 105 225 105 105 120 105
Rectangle -16777216 true false 120 45 135 105
Rectangle -16777216 true false 105 30 120 45
Rectangle -16777216 true false 135 60 150 75
Polygon -6459832 true false 150 60 150 105 165 105 165 165 180 165 195 165 195 105 225 105 225 75 195 75 195 60
Polygon -16777216 true false 180 195 180 180 165 180 165 120 180 120 180 165 195 165 195 195
Polygon -6459832 true false 225 210 225 225 255 225 255 195 240 195 240 210
Polygon -6459832 true false 60 75 75 75 75 60 90 60 90 45 105 45 105 30 75 30 75 45 60 45
Rectangle -6459832 true false 120 195 135 225
Rectangle -16777216 true false 195 60 225 75
Rectangle -16777216 true false 225 75 240 105
Rectangle -16777216 true false 240 90 255 195
Rectangle -16777216 true false 255 105 270 210
Polygon -16777216 true false 240 150 240 135 210 135 210 195 225 195 225 150 240 150
Rectangle -6459832 true false 225 150 240 180
Polygon -16777216 true false 210 210 210 225 225 225 225 210 240 210 240 180 225 180 225 195 210 195

spitball
true
0
Polygon -2674135 true false 135 90 165 90 165 105 180 105 180 120 195 120 210 135 210 150 210 165 210 180 195 195 195 210 180 210 165 225 135 225 120 210 105 210 90 195 90 180 75 165 75 150 75 135 90 135 90 120 105 120 105 105 120 105 135 90
Polygon -1184463 true false 135 90 135 120 105 120 105 150 90 165 90 180 120 210 150 210 150 180 120 165 120 150 150 165 180 165 180 135 150 135 150 105 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

stair
false
0
Rectangle -16777216 true false 15 0 30 300
Rectangle -13345367 true false 30 0 285 15
Rectangle -2674135 true false 45 15 285 30
Rectangle -13345367 true false 30 30 285 90
Rectangle -2674135 true false 45 90 285 105
Rectangle -13345367 true false 30 105 285 165
Rectangle -2674135 true false 45 165 285 180
Rectangle -13345367 true false 30 180 285 240
Rectangle -2674135 true false 45 240 285 255
Rectangle -13345367 true false 30 255 285 300

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

treestump
false
0
Polygon -6459832 true false 45 270 60 270 75 255 90 255 90 270 105 270 120 270 120 255 135 255 135 270 270 270 270 255 255 255 255 225 240 225 240 210 240 195 255 195 255 180 255 165 270 165 270 150 285 150 285 135 300 135 300 105 285 105 285 120 270 120 255 120 255 135 240 135 240 150 225 150 210 165 210 30 195 30 195 0 180 0 180 15 165 15 165 30 150 30 150 45 135 45 135 30 135 15 120 15 105 15 105 0 90 0 90 75 75 75 75 60 60 60 60 45 45 45 45 30 30 15 15 0 0 0 15 60 30 60 30 90 45 90 45 105 60 105 75 120 75 195 60 195 60 240 45 240 45 270
Polygon -16777216 true false 75 240 90 240 90 195 105 195 105 120 120 120 120 105 135 105 135 60 120 60 120 105 105 105 105 120 90 120 90 90 60 90 60 75 45 75 45 90 45 75 30 75 30 60 15 60 15 75 30 75 30 90 45 90 45 105 60 105 75 120 75 150 90 150 90 195 75 195
Rectangle -16777216 true false 90 225 105 255
Polygon -13345367 true false 90 135 60 135 45 135 45 150 30 150 30 165 60 165 60 180 90 180 90 165
Rectangle -16777216 true false 195 255 180 240
Rectangle -16777216 true false 150 75 165 105
Rectangle -16777216 true false 165 120 180 240
Rectangle -16777216 true false 180 180 195 225
Rectangle -16777216 true false 195 240 210 270
Rectangle -16777216 true false 195 120 210 180
Rectangle -16777216 true false 180 61 195 121
Rectangle -16777216 true false 195 30 210 60
Rectangle -16777216 true false 120 15 135 30
Rectangle -16777216 true false 150 45 195 75
Rectangle -16777216 true false 165 15 195 45
Rectangle -16777216 true false 180 0 195 15
Rectangle -16777216 true false 126 150 135 241
Rectangle -16777216 true false 248 142 248 143
Rectangle -16777216 true false 285 135 300 150
Rectangle -16777216 true false 270 150 285 165
Rectangle -16777216 true false 255 165 270 195
Rectangle -13345367 true false 270 165 300 180
Rectangle -13345367 true false 285 150 300 165
Rectangle -16777216 true false 135 15 165 30
Rectangle -16777216 true false 135 30 150 45
Rectangle -6459832 true false 150 45 165 60
Rectangle -13345367 true false 45 30 75 45

treetex
false
6
Rectangle -16777216 true false 120 315 195 330
Rectangle -1184463 true false 105 150 120 150
Polygon -10899396 true false 135 90 135 225 165 225 195 255 195 225 210 225 210 285 225 300 255 300 285 285 285 270 285 225 300 210 300 180 285 150 255 150 240 150 210 165 210 225 210 165 240 150 285 150 285 90 240 45 225 45 195 15 180 15 150 45 150 75 135 90
Rectangle -1184463 true false 135 90 150 255
Polygon -16777216 true false 150 225 165 225 195 255 150 255
Rectangle -1184463 true false 210 165 225 285
Rectangle -1184463 true false 225 150 285 165
Rectangle -1184463 true false 285 135 300 150
Line -14835848 false 150 90 150 225
Polygon -16777216 true false 300 120 315 150 315 120 300 120
Polygon -1 true false 225 285 225 300 210 285
Polygon -1184463 true false 210 165 225 165 225 150 210 165
Polygon -16777216 true false 285 135 300 135 300 0 285 0 285 45 240 45 285 90
Polygon -10899396 true false 225 0 225 30 240 45 255 45 270 30 270 0 225 0 210 0
Polygon -10899396 true false 225 30 210 0 225 0
Polygon -10899396 true false 225 30 225 15 240 30
Polygon -1184463 true false 225 15 225 30 240 45 255 45 270 30
Polygon -16777216 true false 255 45 270 30 270 0 285 0 285 45
Polygon -1 true false 135 90 150 90 150 75
Polygon -1 true false 150 75 165 60 165 45 195 15 180 15 150 45 150 75
Polygon -10899396 true false 195 255 180 285 195 300 75 300 90 285 90 255 195 255
Polygon -16777216 true false 225 300 210 285 210 225 195 225 195 255 180 285 195 300
Polygon -16777216 true false 285 225 300 210 300 300 255 300 285 285
Polygon -1 true false 75 300 75 270 105 240 135 240 135 255 90 255 90 285
Polygon -1 true false 75 285 45 300 75 300
Polygon -1 true false 30 225 15 255 15 285 45 300 30 285 30 255 45 255 45 225
Polygon -16777216 true false 45 300 75 285 75 270 105 240 135 240 135 90 150 75 150 45 165 30 150 30 120 45 120 180 105 195 105 225 90 240 60 240 75 270 60 240
Polygon -16777216 true false 45 300 15 285 15 255 30 225 30 195 15 195 15 225 0 240 0 300
Polygon -10899396 true false 45 300 30 285 30 255 45 255 45 225 30 225 30 150 45 150 45 90 30 90 30 45 75 30 75 45 120 60 120 180 105 195 105 225 90 240 60 240
Polygon -1184463 true false 30 90 45 105 45 135 30 150 15 150 15 105
Polygon -1184463 true false 30 90 45 105 45 90
Polygon -1184463 true false 30 150 45 150 45 135
Polygon -1184463 true false 15 150 0 150 15 165
Polygon -16777216 true false 15 195 30 195 30 150 15 150 0 165 0 195 15 210
Polygon -16777216 true false 0 195 15 225 0 240
Polygon -16777216 true false 15 225 0 195 15 210
Polygon -1 true false 33 -5 45 13 77 12 76 0
Polygon -1184463 true false 74 45 73 30 119 61
Polygon -10899396 true false 77 0 90 15 120 46 149 31 160 34 203 -7
Polygon -16777216 true false 238 45 226 43 195 15 182 15 196 0 211 0 223 28
Polygon -16777216 true false 119 59 120 46 83 14 43 14 35 0 2 2 0 149 15 149 15 105 30 90 30 45 75 30 120 60
Polygon -16777216 true false 300 180 285 150 300 150

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

upattack1
false
15
Rectangle -10899396 true false 90 120 120 180
Polygon -10899396 true false 120 135 195 135 195 120 195 195 105 195 105 180 105 105 105 135
Rectangle -16777216 true false 105 195 225 210
Rectangle -16777216 true false 105 180 120 195
Rectangle -10899396 true false 105 120 120 135
Polygon -2674135 true false 210 120 210 165 210 150 225 150 225 135 240 135 240 120
Rectangle -7500403 true false 210 180 225 195
Polygon -2674135 true false 240 135 240 180 240 195 240 210 225 210 225 195 195 195 195 180 210 180 210 165 225 165 225 150 240 150 240 135
Rectangle -7500403 true false 195 165 210 180
Rectangle -7500403 true false 210 150 225 165
Rectangle -7500403 true false 225 135 240 150
Rectangle -2674135 true false 195 120 210 135
Rectangle -2674135 true false 195 150 210 165
Rectangle -2674135 true false 195 135 210 150
Rectangle -7500403 true false 210 210 225 225
Polygon -10899396 true false 210 210 210 225 210 240 165 240 165 225 105 225 105 180 105 195 120 195 120 210
Polygon -16777216 true false 210 225 240 225 240 240 255 240 255 270 195 270 195 240 210 240
Polygon -16777216 true false 105 195 90 195 90 210 75 210 75 240 120 240 120 225 105 225
Polygon -6459832 true false 90 105 75 105 75 75 60 75 60 30 75 30 75 60 90 60 90 105
Rectangle -955883 true false 75 45 90 60
Polygon -10899396 true false 225 75 225 45 210 45 210 30 195 30 195 15 120 15 120 30 105 30 105 45 90 45 90 75 105 75 105 90 120 90 120 105 135 105 135 120 165 120 165 105 180 105 180 90 210 90 210 75
Polygon -6459832 true false 225 105 240 105 240 75 255 75 255 45 240 45 240 60 225 60
Polygon -955883 true false 90 75 105 75 105 90 120 90 120 105 135 105 135 120 165 120 165 105 180 105 180 90 210 90 210 75 225 75 225 105 210 105 210 120 195 120 195 135 120 135 120 120 105 120 105 105 90 105

upattack2
false
0
Polygon -10899396 true false 120 135 195 135 195 120 195 195 105 195 105 180 105 105 105 135
Rectangle -16777216 true false 105 195 225 210
Rectangle -16777216 true false 105 180 120 195
Rectangle -10899396 true false 105 120 120 135
Polygon -2674135 true false 210 120 210 165 210 150 225 150 225 135 240 135 240 120
Rectangle -7500403 true true 210 180 225 195
Polygon -2674135 true false 240 135 240 180 240 195 240 210 225 210 225 195 195 195 195 180 210 180 210 165 225 165 225 150 240 150 240 135
Rectangle -7500403 true true 195 165 210 180
Rectangle -7500403 true true 210 150 225 165
Rectangle -7500403 true true 225 135 240 150
Rectangle -2674135 true false 195 120 210 135
Rectangle -2674135 true false 195 150 210 165
Rectangle -2674135 true false 195 135 210 150
Rectangle -7500403 true true 210 210 225 225
Polygon -10899396 true false 210 210 210 225 210 240 165 240 165 225 105 225 105 180 105 195 120 195 120 210
Polygon -16777216 true false 210 225 240 225 240 240 255 240 255 270 195 270 195 240 210 240
Polygon -16777216 true false 105 195 90 195 90 210 75 210 75 240 120 240 120 225 105 225
Polygon -6459832 true false 90 105 75 105 75 75 60 75 60 30 75 30 75 60 90 60 90 105
Rectangle -955883 true false 75 45 90 60
Polygon -10899396 true false 225 75 225 45 210 45 210 30 195 30 195 15 120 15 120 30 105 30 105 45 90 45 90 75 105 75 105 90 120 90 120 105 135 105 135 120 165 120 165 105 180 105 180 90 210 90 210 75
Polygon -6459832 true false 225 105 240 105 240 75 255 75 255 45 240 45 240 60 225 60
Polygon -955883 true false 90 75 105 75 105 90 120 90 120 105 135 105 135 120 165 120 165 105 180 105 180 90 210 90 210 75 225 75 225 105 210 105 210 120 195 120 195 135 120 135 120 120 105 120 105 105 90 105
Rectangle -10899396 true false 120 0 195 15
Rectangle -955883 true false 120 15 135 30

upattack2sword
false
15
Rectangle -7500403 true false 120 165 165 300
Rectangle -7500403 true false 135 150 150 165

upslanteddownrock
false
0
Polygon -16777216 true false 300 0 270 0 270 15 240 15 240 30 210 30 195 45 180 45 165 75 150 90 150 150 105 165 105 195 60 225 45 240 45 255 0 255 0 300 30 300 30 270 45 270 60 255 60 240 90 210 90 270 75 300 105 300 105 270 105 210 120 195 120 165 165 150 165 90 195 60 225 45 240 45 255 45 255 30 285 30 285 15 300 15 300 0
Polygon -16777216 true false 240 45 240 195 225 195 225 45
Polygon -16777216 true false 270 210 270 195 240 195 240 210
Polygon -16777216 true false 285 30 285 75 270 75 270 30
Polygon -16777216 true false 270 90 270 75 255 75 255 120 270 120 270 150 255 150 255 240 270 240 270 150 285 150 285 120 270 120
Rectangle -1 true false 255 30 270 75
Rectangle -2674135 true false 210 45 225 90
Rectangle -1184463 true false 255 120 270 150
Rectangle -6459832 true false 240 60 255 210
Polygon -955883 true false 210 45 165 90 165 150 120 165 120 195 105 210 105 300 240 300 240 195 225 195 225 90 210 90
Polygon -1184463 true false 90 210 75 225 75 285 90 270 90 210
Polygon -1184463 true false 75 300 75 285 30 285 30 300
Polygon -955883 true false 75 225 60 240 60 255 45 270 30 270 30 285 75 285
Polygon -16777216 true false 300 210 285 210 285 255 270 255 270 270 285 270 285 285 270 285 255 285 255 300 300 300
Rectangle -16777216 true false 240 270 255 285
Rectangle -1 true false 240 285 255 300
Rectangle -1184463 true false 270 270 285 285
Rectangle -2674135 true false 195 270 210 285
Rectangle -2674135 true false 150 270 165 285
Rectangle -2674135 true false 105 270 120 285
Polygon -955883 true false 285 15 300 15 300 210 285 210 285 255 270 255 270 270 270 285 255 285 255 270 255 240 270 240 270 150 285 150 285 120 270 120 270 75 285 75 285 15
Rectangle -2674135 true false 240 210 255 270

upslanteduprock
false
0
Polygon -16777216 true false 0 300 30 300 30 285 60 285 60 270 90 270 105 255 120 255 135 225 150 210 150 150 195 135 195 105 240 75 255 60 255 45 300 45 300 0 270 0 270 30 255 30 240 45 240 60 210 90 210 30 225 0 195 0 195 30 195 90 180 105 180 135 135 150 135 210 105 240 75 255 60 255 45 255 45 270 15 270 15 285 0 285 0 300
Polygon -16777216 true false 60 255 60 105 75 105 75 255
Polygon -16777216 true false 30 90 30 105 60 105 60 90
Polygon -16777216 true false 15 270 15 225 30 225 30 270
Polygon -16777216 true false 30 210 30 225 45 225 45 180 30 180 30 150 45 150 45 60 30 60 30 150 15 150 15 180 30 180
Rectangle -1 true false 30 225 45 270
Rectangle -2674135 true false 75 210 90 255
Rectangle -1184463 true false 30 150 45 180
Rectangle -6459832 true false 45 90 60 240
Polygon -955883 true false 90 255 135 210 135 150 180 135 180 105 195 90 195 0 60 0 60 105 75 105 75 210 90 210
Polygon -1184463 true false 210 90 225 75 225 15 210 30 210 90
Polygon -1184463 true false 225 0 225 15 270 15 270 0
Polygon -955883 true false 225 75 240 60 240 45 255 30 270 30 270 15 225 15
Polygon -16777216 true false 0 90 15 90 15 45 30 45 30 30 15 30 15 15 30 15 45 15 45 0 0 0
Rectangle -16777216 true false 45 15 60 30
Rectangle -1 true false 45 0 60 15
Rectangle -1184463 true false 15 15 30 30
Rectangle -2674135 true false 90 15 105 30
Rectangle -2674135 true false 135 15 150 30
Rectangle -2674135 true false 180 15 195 30
Polygon -955883 true false 15 285 0 285 0 90 15 90 15 45 30 45 30 30 30 15 45 15 45 30 45 60 30 60 30 150 15 150 15 180 30 180 30 225 15 225 15 285
Rectangle -2674135 true false 45 30 60 90

water
false
0
Polygon -13791810 true false 0 300 0 0 300 0 300 300
Rectangle -13345367 true false 0 0 300 300
Rectangle -14835848 true false 90 60 105 75
Rectangle -14835848 true false 180 165 195 180
Rectangle -14835848 true false 30 195 45 210
Rectangle -13840069 true false 225 15 240 30
Rectangle -14835848 true false 225 15 240 30
Rectangle -14835848 true false 255 270 270 285
Rectangle -14835848 true false 60 285 75 300

wateredgebottom
false
0
Rectangle -13345367 true false 0 0 300 45
Rectangle -13345367 true false 30 45 60 60
Rectangle -13345367 true false 90 45 150 60
Rectangle -13345367 true false 195 45 210 60
Rectangle -13345367 true false 255 45 285 60

wateredgeleft
false
0
Rectangle -13345367 true false 255 0 300 300
Rectangle -13345367 true false 240 30 255 60
Rectangle -13345367 true false 240 90 255 150
Rectangle -13345367 true false 240 195 255 210
Rectangle -13345367 true false 240 255 255 285

wateredgeright
false
0
Rectangle -13345367 true false 0 0 45 300
Rectangle -13345367 true false 45 30 60 60
Rectangle -13345367 true false 45 90 60 150
Rectangle -13345367 true false 45 195 60 210
Rectangle -13345367 true false 45 255 60 285

wateredgetop
false
0
Rectangle -13345367 true false 0 255 300 300
Rectangle -13345367 true false 30 240 60 255
Rectangle -13345367 true false 90 240 150 255
Rectangle -13345367 true false 195 240 210 255
Rectangle -13345367 true false 255 240 285 255

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

whitesidetreetex1
false
0
Polygon -16777216 true false 0 300 30 300 30 285 60 285 60 270 90 270 105 255 120 255 135 225 150 210 150 150 195 135 195 105 240 75 255 60 255 45 300 45 300 0 270 0 270 30 255 30 240 45 240 60 210 90 210 30 225 0 195 0 195 30 195 90 180 105 180 135 135 150 135 210 105 240 75 255 60 255 45 255 45 270 15 270 15 285 0 285 0 300
Polygon -16777216 true false 60 255 60 105 75 105 75 255
Polygon -16777216 true false 30 90 30 105 60 105 60 90
Polygon -16777216 true false 15 270 15 225 30 225 30 270
Polygon -16777216 true false 30 210 30 225 45 225 45 180 30 180 30 150 45 150 45 60 30 60 30 150 15 150 15 180 30 180
Rectangle -1 true false 30 225 45 270
Rectangle -1 true false 75 210 90 255
Rectangle -7500403 true true 30 150 45 180
Rectangle -1 true false 45 105 60 255
Polygon -1 true false 90 255 135 210 135 150 180 135 180 105 195 90 195 0 60 0 60 105 75 105 75 210 90 210
Polygon -7500403 true true 210 90 225 75 225 15 210 30 210 90
Polygon -7500403 true true 225 0 225 15 270 15 270 0
Polygon -1 true false 225 75 240 60 240 45 255 30 270 30 270 15 225 15
Polygon -16777216 true false 0 90 15 90 15 45 30 45 30 30 15 30 15 15 30 15 45 15 45 0 0 0
Rectangle -16777216 true false 45 15 60 30
Rectangle -1 true false 45 0 60 15
Rectangle -7500403 true true 15 15 30 30
Rectangle -7500403 true true 90 15 105 30
Rectangle -7500403 true true 135 15 150 30
Rectangle -7500403 true true 180 15 195 30
Polygon -1 true false 15 285 0 285 0 90 15 90 15 45 30 45 30 30 30 15 45 15 45 30 45 60 30 60 30 150 15 150 15 180 30 180 30 225 15 225 15 285

whitesidetreetex2
false
0
Polygon -16777216 true false 300 0 270 0 270 15 240 15 240 30 210 30 195 45 180 45 165 75 150 90 150 150 105 165 105 195 60 225 45 240 45 255 0 255 0 300 30 300 30 270 45 270 60 255 60 240 90 210 90 270 75 300 105 300 105 270 105 210 120 195 120 165 165 150 165 90 195 60 225 45 240 45 255 45 255 30 285 30 285 15 300 15 300 0
Polygon -16777216 true false 240 45 240 195 225 195 225 45
Polygon -16777216 true false 270 210 270 195 240 195 240 210
Polygon -16777216 true false 285 30 285 75 270 75 270 30
Polygon -16777216 true false 270 90 270 75 255 75 255 120 270 120 270 150 255 150 255 240 270 240 270 150 285 150 285 120 270 120
Rectangle -1 true false 255 30 270 75
Rectangle -1 true false 210 45 225 90
Rectangle -7500403 true true 255 120 270 150
Rectangle -1 true false 240 45 255 195
Polygon -1 true false 210 45 165 90 165 150 120 165 120 195 105 210 105 300 240 300 240 195 225 195 225 90 210 90
Polygon -7500403 true true 90 210 75 225 75 285 90 270 90 210
Polygon -7500403 true true 75 300 75 285 30 285 30 300
Polygon -1 true false 75 225 60 240 60 255 45 270 30 270 30 285 75 285
Polygon -16777216 true false 300 210 285 210 285 255 270 255 270 270 285 270 285 285 270 285 255 285 255 300 300 300
Rectangle -16777216 true false 240 270 255 285
Rectangle -1 true false 240 285 255 300
Rectangle -7500403 true true 270 270 285 285
Rectangle -7500403 true true 195 270 210 285
Rectangle -7500403 true true 150 270 165 285
Rectangle -7500403 true true 105 270 120 285
Polygon -1 true false 285 15 300 15 300 210 285 210 285 255 270 255 270 270 270 285 255 285 255 270 255 240 270 240 270 150 285 150 285 120 270 120 270 75 285 75 285 15

whitesidetreetex3
false
0
Polygon -16777216 true false 300 300 270 300 270 285 240 285 240 270 210 270 195 255 180 255 165 225 150 210 150 150 105 135 105 105 60 75 45 60 45 45 0 45 0 0 30 0 30 30 45 30 60 45 60 60 90 90 90 30 75 0 105 0 105 30 105 90 120 105 120 135 165 150 165 210 195 240 225 255 240 255 255 255 255 270 285 270 285 285 300 285 300 300
Polygon -16777216 true false 240 255 240 105 225 105 225 255
Polygon -16777216 true false 270 90 270 105 240 105 240 90
Polygon -16777216 true false 285 270 285 225 270 225 270 270
Polygon -16777216 true false 270 210 270 225 255 225 255 180 270 180 270 150 255 150 255 60 270 60 270 150 285 150 285 180 270 180
Rectangle -1 true false 255 225 270 270
Rectangle -1 true false 210 210 225 255
Rectangle -7500403 true true 255 150 270 180
Rectangle -1 true false 240 105 255 255
Polygon -1 true false 210 255 165 210 165 150 120 135 120 105 105 90 105 0 240 0 240 105 225 105 225 210 210 210
Polygon -7500403 true true 90 90 75 75 75 15 90 30 90 90
Polygon -7500403 true true 75 0 75 15 30 15 30 0
Polygon -1 true false 75 75 60 60 60 45 45 30 30 30 30 15 75 15
Polygon -16777216 true false 300 90 285 90 285 45 270 45 270 30 285 30 285 15 270 15 255 15 255 0 300 0
Rectangle -16777216 true false 240 15 255 30
Rectangle -1 true false 240 0 255 15
Rectangle -7500403 true true 270 15 285 30
Rectangle -7500403 true true 195 15 210 30
Rectangle -7500403 true true 150 15 165 30
Rectangle -7500403 true true 105 15 120 30
Polygon -1 true false 285 285 300 285 300 90 285 90 285 45 270 45 270 30 270 15 255 15 255 30 255 60 270 60 270 150 285 150 285 180 270 180 270 225 285 225 285 285

whitesidetreetex4
false
0
Polygon -16777216 true false 0 0 30 0 30 15 60 15 60 30 90 30 105 45 120 45 135 75 150 90 150 150 195 165 195 195 240 225 255 240 255 255 300 255 300 300 270 300 270 270 255 270 240 255 240 240 210 210 210 270 225 300 195 300 195 270 195 210 180 195 180 165 135 150 135 90 105 60 75 45 60 45 45 45 45 30 15 30 15 15 0 15 0 0
Polygon -16777216 true false 60 45 60 195 75 195 75 45
Polygon -16777216 true false 30 210 30 195 60 195 60 210
Polygon -16777216 true false 15 30 15 75 30 75 30 30
Polygon -16777216 true false 30 90 30 75 45 75 45 120 30 120 30 150 45 150 45 240 30 240 30 150 15 150 15 120 30 120
Rectangle -1 true false 30 30 45 75
Rectangle -1 true false 75 45 90 90
Rectangle -7500403 true true 30 120 45 150
Rectangle -1 true false 45 45 60 195
Polygon -1 true false 90 45 135 90 135 150 180 165 180 195 195 210 195 300 60 300 60 195 75 195 75 90 90 90
Polygon -7500403 true true 210 210 225 225 225 285 210 270 210 210
Polygon -7500403 true true 225 300 225 285 270 285 270 300
Polygon -1 true false 225 225 240 240 240 255 255 270 270 270 270 285 225 285
Polygon -16777216 true false 0 210 15 210 15 255 30 255 30 270 15 270 15 285 30 285 45 285 45 300 0 300
Rectangle -16777216 true false 45 270 60 285
Rectangle -1 true false 45 285 60 300
Rectangle -7500403 true true 15 270 30 285
Rectangle -7500403 true true 90 270 105 285
Rectangle -7500403 true true 135 270 150 285
Rectangle -7500403 true true 180 270 195 285
Polygon -1 true false 15 15 0 15 0 210 15 210 15 255 30 255 30 270 30 285 45 285 45 270 45 240 30 240 30 150 15 150 15 120 30 120 30 75 15 75 15 15

whitetreetex
false
6
Rectangle -16777216 true false 120 315 195 330
Rectangle -1184463 true false 105 150 120 150
Polygon -1 true false 135 90 135 225 165 225 195 255 195 225 210 225 210 285 225 300 255 300 285 285 285 270 285 225 300 210 300 180 285 150 255 150 240 150 210 165 210 225 210 165 240 150 285 150 285 90 240 45 225 45 195 15 180 15 150 45 150 75 135 90
Rectangle -7500403 true false 135 90 150 255
Polygon -16777216 true false 150 225 165 225 195 255 150 255
Rectangle -7500403 true false 210 165 225 285
Rectangle -7500403 true false 225 150 285 165
Rectangle -7500403 true false 285 135 300 150
Line -7500403 false 150 90 150 225
Polygon -16777216 true false 300 120 315 150 315 120 300 120
Polygon -1 true false 225 285 225 300 210 285
Polygon -7500403 true false 210 165 225 165 225 150 210 165
Polygon -16777216 true false 285 135 300 135 300 0 285 0 285 45 240 45 285 90
Polygon -1 true false 225 0 225 30 240 45 255 45 270 30 270 0 225 0 210 0
Polygon -1 true false 225 30 210 0 225 0
Polygon -10899396 true false 225 30 225 15 240 30
Polygon -7500403 true false 225 15 225 30 240 45 255 45 270 30
Polygon -16777216 true false 255 45 270 30 270 0 285 0 285 45
Polygon -1 true false 135 90 150 90 150 75
Polygon -1 true false 150 75 165 60 165 45 195 15 180 15 150 45 150 75
Polygon -1 true false 195 255 180 285 195 300 75 300 90 285 90 255 195 255
Polygon -16777216 true false 225 300 210 285 210 225 195 225 195 255 180 285 195 300
Polygon -16777216 true false 285 225 300 210 300 300 255 300 285 285
Polygon -1 true false 75 300 75 270 105 240 135 240 135 255 90 255 90 285
Polygon -1 true false 75 285 45 300 75 300
Polygon -1 true false 30 225 15 255 15 285 45 300 30 285 30 255 45 255 45 225
Polygon -16777216 true false 45 300 75 285 75 270 105 240 135 240 135 90 150 75 150 45 165 30 150 30 120 45 120 180 105 195 105 225 90 240 60 240 75 270 60 240
Polygon -16777216 true false 45 300 15 285 15 255 30 225 30 195 15 195 15 225 0 240 0 300
Polygon -1 true false 45 300 30 285 30 255 45 255 45 225 30 225 30 150 45 150 45 90 30 90 30 45 75 30 75 45 120 60 120 180 105 195 105 225 90 240 60 240
Polygon -7500403 true false 30 90 45 105 45 135 30 150 15 150 15 105
Polygon -7500403 true false 30 90 45 105 45 90
Polygon -7500403 true false 30 150 45 150 45 135
Polygon -7500403 true false 15 150 0 150 15 165
Polygon -16777216 true false 15 195 30 195 30 150 15 150 0 165 0 195 15 210
Polygon -16777216 true false 0 195 15 225 0 240
Polygon -16777216 true false 15 225 0 195 15 210
Polygon -1 true false 33 -5 45 13 77 12 76 0
Polygon -7500403 true false 74 45 73 30 119 61
Polygon -1 true false 77 0 90 15 120 46 149 31 160 34 203 -7
Polygon -16777216 true false 238 45 226 43 195 15 182 15 196 0 211 0 223 28
Polygon -16777216 true false 119 59 120 46 83 14 43 14 35 0 2 2 0 149 15 149 15 105 30 90 30 45 75 30 120 60
Polygon -16777216 true false 300 180 285 150 300 150

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

zelda forward
false
10
Polygon -6459832 true false 135 152 165 152 165 137 180 137 180 122 210 122 210 107 225 107 225 62 210 62 210 92 195 92 195 47 180 47 180 32 120 32 120 47 105 47 105 92 90 92 90 62 75 62 75 107 90 107 90 122 120 122 120 137 135 137 135 152
Polygon -955883 true false 195 105 180 105 180 75 120 75 120 105 105 105 105 60 120 60 120 45 180 45 180 60 195 60 195 105
Polygon -10899396 true false 165 105 165 75 180 75 180 105 165 105
Polygon -10899396 true false 120 75 135 75 135 105 120 105 120 75
Rectangle -16777216 true false 120 90 135 105
Rectangle -16777216 true false 165 90 180 105
Rectangle -10899396 true false 105 45 120 60
Rectangle -10899396 true false 120 30 180 45
Rectangle -10899396 true false 180 45 195 60
Rectangle -10899396 true false 150 150 210 165
Rectangle -10899396 true false 180 120 195 150
Rectangle -10899396 true false 165 135 180 150
Rectangle -10899396 true false 195 135 210 150
Rectangle -10899396 true false 165 165 195 180
Rectangle -6459832 true false 210 135 225 165
Rectangle -16777216 true false 210 105 225 135
Rectangle -16777216 true false 195 120 210 135
Rectangle -16777216 true false 165 180 195 195
Rectangle -16777216 true false 195 165 210 180
Rectangle -10899396 true false 165 195 210 210
Rectangle -10899396 true false 195 180 210 195
Rectangle -10899396 true false 150 210 180 225
Rectangle -6459832 true false 165 225 195 255
Rectangle -6459832 true false 180 210 195 225
Rectangle -10899396 true false 135 180 150 195
Polygon -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 195 165 210
Rectangle -10899396 true false 105 120 120 135
Rectangle -2674135 true false 60 135 120 225
Rectangle -2674135 true false 120 135 135 165
Rectangle -10899396 true false 135 150 150 165
Rectangle -7500403 true false 120 165 135 225
Rectangle -7500403 true false 75 225 120 240
Rectangle -7500403 true false 75 150 90 210
Rectangle -7500403 true false 60 165 105 180

zelda left
false
0
Rectangle -6459832 true false 150 150 195 180
Rectangle -6459832 true false 165 180 195 195
Rectangle -10899396 true false 165 195 195 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 195 210 255 225
Rectangle -10899396 true false 225 195 240 210
Rectangle -6459832 true false 150 225 210 240
Rectangle -6459832 true false 135 240 210 255
Rectangle -16777216 true false 105 180 120 210
Rectangle -16777216 true false 120 195 165 210
Rectangle -10899396 true false 120 180 165 195
Rectangle -10899396 true false 105 150 150 180
Rectangle -10899396 true false 120 135 225 150
Rectangle -10899396 true false 195 150 210 165
Rectangle -10899396 true false 150 120 210 135
Rectangle -16777216 true false 195 165 225 210
Rectangle -16777216 true false 225 135 240 195
Rectangle -16777216 true false 240 150 255 195
Rectangle -16777216 true false 75 135 105 180
Rectangle -16777216 true false 105 135 120 150
Rectangle -6459832 true false 60 135 75 165
Rectangle -2674135 true false 45 60 60 240
Rectangle -2674135 true false 30 60 45 90
Rectangle -2674135 true false 30 210 45 240
Rectangle -7500403 true true 30 90 45 210
Rectangle -6459832 true false 60 90 90 105
Rectangle -6459832 true false 90 75 150 135
Rectangle -6459832 true false 150 105 180 120
Rectangle -6459832 true false 165 75 195 105
Rectangle -6459832 true false 180 60 195 75
Rectangle -6459832 true false 195 45 210 90
Rectangle -955883 true false 150 45 165 105
Rectangle -955883 true false 165 60 180 75
Rectangle -955883 true false 90 30 150 75
Rectangle -955883 true false 75 45 90 60
Rectangle -955883 true false 105 75 120 105
Rectangle -16777216 true false 105 75 120 90
Rectangle -10899396 true false 135 15 195 30
Rectangle -10899396 true false 150 30 195 45
Rectangle -10899396 true false 165 45 195 60
Rectangle -10899396 true false 195 30 225 45
Rectangle -10899396 true false 210 45 240 90
Rectangle -955883 true false 195 90 225 120
Rectangle -955883 true false 180 105 195 120
Rectangle -10899396 true false 240 45 255 75
Rectangle -10899396 true false 255 60 270 75
Rectangle -10899396 true false 255 75 270 90

zelda right
false
0
Rectangle -6459832 true false 105 150 150 180
Rectangle -6459832 true false 105 180 135 195
Rectangle -10899396 true false 105 195 135 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 45 210 105 225
Rectangle -10899396 true false 60 195 75 210
Rectangle -6459832 true false 90 225 150 240
Rectangle -6459832 true false 90 240 165 255
Rectangle -16777216 true false 180 180 195 210
Rectangle -16777216 true false 135 195 180 210
Rectangle -10899396 true false 135 180 180 195
Rectangle -10899396 true false 150 150 195 180
Rectangle -10899396 true false 75 135 180 150
Rectangle -10899396 true false 90 150 105 165
Rectangle -10899396 true false 90 120 150 135
Rectangle -16777216 true false 75 165 105 210
Rectangle -16777216 true false 60 135 75 195
Rectangle -16777216 true false 45 150 60 195
Rectangle -16777216 true false 195 135 225 180
Rectangle -16777216 true false 180 135 195 150
Rectangle -6459832 true false 225 135 240 165
Rectangle -2674135 true false 240 60 255 240
Rectangle -2674135 true false 255 60 270 90
Rectangle -2674135 true false 255 210 270 240
Rectangle -7500403 true true 255 90 270 210
Rectangle -6459832 true false 210 90 240 105
Rectangle -6459832 true false 150 75 210 135
Rectangle -6459832 true false 120 105 150 120
Rectangle -6459832 true false 105 75 135 105
Rectangle -6459832 true false 105 60 120 75
Rectangle -6459832 true false 90 45 105 90
Rectangle -955883 true false 135 45 150 105
Rectangle -955883 true false 120 60 135 75
Rectangle -955883 true false 150 30 210 75
Rectangle -955883 true false 210 45 225 60
Rectangle -955883 true false 180 75 195 105
Rectangle -16777216 true false 180 75 195 90
Rectangle -10899396 true false 105 15 165 30
Rectangle -10899396 true false 105 30 150 45
Rectangle -10899396 true false 105 45 135 60
Rectangle -10899396 true false 75 30 105 45
Rectangle -10899396 true false 60 45 90 90
Rectangle -955883 true false 75 90 105 120
Rectangle -955883 true false 105 105 120 120
Rectangle -10899396 true false 45 45 60 75
Rectangle -10899396 true false 30 60 45 75
Rectangle -10899396 true false 30 75 45 90

zelda up
false
0
Polygon -6459832 true false 135 152 165 152 165 137 180 137 180 122 210 122 210 107 225 107 225 62 210 62 210 92 195 92 195 47 180 47 180 32 120 32 120 47 105 47 105 92 90 92 90 62 75 62 75 107 90 107 90 122 120 122 120 137 135 137 135 152
Polygon -955883 true false 195 105 180 105 180 75 120 75 120 105 105 105 105 60 120 60 120 45 180 45 180 60 195 60 195 105
Polygon -10899396 true false 165 105 165 75 180 75 180 105 165 105
Polygon -10899396 true false 120 75 135 75 135 105 120 105 120 75
Rectangle -16777216 true false 120 90 135 105
Rectangle -16777216 true false 165 90 180 105
Rectangle -10899396 true false 105 45 120 60
Rectangle -10899396 true false 120 30 180 45
Rectangle -10899396 true false 180 45 195 60
Rectangle -10899396 true false 150 150 210 165
Rectangle -10899396 true false 180 120 195 150
Rectangle -10899396 true false 165 135 180 150
Rectangle -10899396 true false 195 135 210 150
Rectangle -10899396 true false 165 165 195 180
Rectangle -6459832 true false 210 135 225 165
Rectangle -16777216 true false 210 105 225 135
Rectangle -16777216 true false 195 120 210 135
Rectangle -16777216 true false 165 180 195 195
Rectangle -16777216 true false 195 165 210 180
Rectangle -10899396 true false 165 195 195 210
Rectangle -10899396 true false 195 180 195 195
Rectangle -10899396 true false 135 210 180 225
Rectangle -6459832 true false 165 225 195 240
Rectangle -6459832 true false 180 210 195 225
Rectangle -10899396 true false 135 180 150 195
Polygon -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 195 165 210
Rectangle -10899396 true false 105 120 120 135
Rectangle -10899396 true false 120 150 150 165
Rectangle -10899396 true false 120 45 180 60
Rectangle -10899396 true false 105 60 195 75
Rectangle -10899396 true false 135 75 165 90
Rectangle -10899396 true false 150 90 165 105
Rectangle -955883 true false 120 90 150 105
Rectangle -955883 true false 165 90 180 105
Rectangle -10899396 true false 120 135 165 150
Rectangle -955883 true false 120 105 180 120
Rectangle -2674135 true false 195 120 225 135
Rectangle -10899396 true false 120 165 210 210
Rectangle -16777216 true false 195 165 210 180
Rectangle -16777216 true false 120 180 195 195
Rectangle -10899396 true false 105 135 120 210
Rectangle -10899396 true false 105 165 120 180
Rectangle -16777216 true false 105 165 120 180
Rectangle -6459832 true false 105 210 135 255
Rectangle -6459832 true false 90 135 105 165

zeldaforward2
false
10
Polygon -6459832 true false 135 152 165 152 165 137 180 137 180 122 210 122 210 107 225 107 225 62 210 62 210 92 195 92 195 47 180 47 180 32 120 32 120 47 105 47 105 92 90 92 90 62 75 62 75 107 90 107 90 122 120 122 120 137 135 137 135 152
Polygon -955883 true false 195 105 180 105 180 75 120 75 120 105 105 105 105 60 120 60 120 45 180 45 180 60 195 60 195 105
Polygon -10899396 true false 165 105 165 75 180 75 180 105 165 105
Polygon -10899396 true false 120 75 135 75 135 105 120 105 120 75
Rectangle -16777216 true false 120 90 135 105
Rectangle -16777216 true false 165 90 180 105
Rectangle -10899396 true false 105 45 120 60
Rectangle -10899396 true false 120 30 180 45
Rectangle -10899396 true false 180 45 195 60
Rectangle -10899396 true false 150 150 210 165
Rectangle -10899396 true false 180 120 195 150
Rectangle -10899396 true false 165 135 180 150
Rectangle -10899396 true false 195 135 210 150
Rectangle -10899396 true false 165 165 195 180
Rectangle -6459832 true false 210 165 225 210
Rectangle -16777216 true false 210 105 225 135
Rectangle -16777216 true false 195 120 210 135
Rectangle -16777216 true false 165 180 195 195
Rectangle -16777216 true false 195 165 210 180
Rectangle -10899396 true false 165 195 210 210
Rectangle -10899396 true false 195 180 210 195
Rectangle -10899396 true false 135 210 195 225
Rectangle -6459832 true false 165 225 195 240
Rectangle -10899396 true false 135 180 150 195
Polygon -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 195 165 210
Rectangle -10899396 true false 90 120 120 135
Rectangle -2674135 true false 60 135 120 225
Rectangle -2674135 true false 120 135 135 165
Rectangle -10899396 true false 135 150 150 165
Rectangle -7500403 true false 120 165 135 225
Rectangle -7500403 true false 75 225 120 240
Rectangle -7500403 true false 75 150 90 210
Rectangle -7500403 true false 60 165 105 180
Rectangle -10899396 true false 195 120 210 135
Polygon -6459832 true false 210 150 225 150
Rectangle -6459832 true false 195 180 240 195
Rectangle -6459832 true false 180 165 210 180
Rectangle -6459832 true false 195 150 210 195
Polygon -16777216 true false 210 135 225 135 225 165 240 165 240 180 225 180 225 165 210 165 210 150 195 150 195 135
Polygon -6459832 true false 120 225 135 225 135 255 90 255 105 255 105 240 120 240

zeldaleft2
false
0
Rectangle -10899396 true false 165 195 195 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 165 210 225 225
Rectangle -10899396 true false 225 180 240 210
Rectangle -16777216 true false 105 180 120 210
Rectangle -16777216 true false 120 195 165 210
Rectangle -10899396 true false 120 180 165 195
Rectangle -10899396 true false 105 150 150 180
Rectangle -10899396 true false 120 135 225 150
Rectangle -10899396 true false 195 150 210 165
Rectangle -10899396 true false 150 120 210 135
Rectangle -16777216 true false 210 135 225 195
Rectangle -16777216 true false 225 150 255 180
Rectangle -16777216 true false 75 135 105 180
Rectangle -16777216 true false 105 135 120 150
Rectangle -6459832 true false 60 135 75 165
Rectangle -2674135 true false 60 60 75 240
Rectangle -2674135 true false 45 60 60 90
Rectangle -2674135 true false 45 210 60 240
Rectangle -7500403 true true 45 90 60 210
Rectangle -6459832 true false 60 90 90 105
Rectangle -6459832 true false 90 75 150 135
Rectangle -6459832 true false 150 105 180 120
Rectangle -6459832 true false 165 75 195 105
Rectangle -6459832 true false 180 60 195 75
Rectangle -6459832 true false 195 45 210 90
Rectangle -955883 true false 150 45 165 105
Rectangle -955883 true false 165 60 180 75
Rectangle -955883 true false 90 30 150 75
Rectangle -955883 true false 75 45 90 60
Rectangle -955883 true false 105 75 120 105
Rectangle -16777216 true false 105 75 120 90
Rectangle -10899396 true false 135 15 195 30
Rectangle -10899396 true false 150 30 195 45
Rectangle -10899396 true false 165 45 195 60
Rectangle -10899396 true false 195 30 225 45
Rectangle -10899396 true false 210 45 240 90
Rectangle -955883 true false 195 90 225 120
Rectangle -955883 true false 180 105 195 120
Rectangle -10899396 true false 240 45 255 75
Rectangle -10899396 true false 255 60 270 75
Rectangle -10899396 true false 255 75 270 90
Rectangle -10899396 true false 90 195 105 210
Polygon -6459832 true false 150 225 150 240 105 240 90 240 90 225 75 225 75 210 105 210 105 225
Polygon -6459832 true false 195 225 195 240 240 240 240 225 255 225 255 210 225 210 225 225 195 225
Rectangle -6459832 true false 120 135 165 165
Rectangle -6459832 true false 150 165 180 180
Rectangle -16777216 true false 180 150 210 195
Rectangle -10899396 true false 195 195 225 210

zeldaright2
false
0
Rectangle -10899396 true false 105 195 135 210
Rectangle -10899396 true false 105 210 195 225
Rectangle -10899396 true false 75 210 135 225
Rectangle -10899396 true false 60 180 75 210
Rectangle -16777216 true false 180 180 195 210
Rectangle -16777216 true false 135 195 180 210
Rectangle -10899396 true false 135 180 180 195
Rectangle -10899396 true false 150 150 195 180
Rectangle -10899396 true false 75 135 180 150
Rectangle -10899396 true false 90 150 105 165
Rectangle -10899396 true false 90 120 150 135
Rectangle -16777216 true false 75 135 90 195
Rectangle -16777216 true false 45 150 75 180
Rectangle -16777216 true false 195 135 225 180
Rectangle -16777216 true false 180 135 195 150
Rectangle -6459832 true false 225 135 240 165
Rectangle -2674135 true false 225 60 240 240
Rectangle -2674135 true false 240 60 255 90
Rectangle -2674135 true false 240 210 255 240
Rectangle -7500403 true true 240 90 255 210
Rectangle -6459832 true false 210 90 240 105
Rectangle -6459832 true false 150 75 210 135
Rectangle -6459832 true false 120 105 150 120
Rectangle -6459832 true false 105 75 135 105
Rectangle -6459832 true false 105 60 120 75
Rectangle -6459832 true false 90 45 105 90
Rectangle -955883 true false 135 45 150 105
Rectangle -955883 true false 120 60 135 75
Rectangle -955883 true false 150 30 210 75
Rectangle -955883 true false 210 45 225 60
Rectangle -955883 true false 180 75 195 105
Rectangle -16777216 true false 180 75 195 90
Rectangle -10899396 true false 105 15 165 30
Rectangle -10899396 true false 105 30 150 45
Rectangle -10899396 true false 105 45 135 60
Rectangle -10899396 true false 75 30 105 45
Rectangle -10899396 true false 60 45 90 90
Rectangle -955883 true false 75 90 105 120
Rectangle -955883 true false 105 105 120 120
Rectangle -10899396 true false 45 45 60 75
Rectangle -10899396 true false 30 60 45 75
Rectangle -10899396 true false 30 75 45 90
Rectangle -10899396 true false 195 195 210 210
Polygon -6459832 true false 150 225 150 240 195 240 210 240 210 225 225 225 225 210 195 210 195 225
Polygon -6459832 true false 105 225 105 240 60 240 60 225 45 225 45 210 75 210 75 225 105 225
Rectangle -6459832 true false 135 135 180 165
Rectangle -6459832 true false 120 165 150 180
Rectangle -16777216 true false 90 150 120 195
Rectangle -10899396 true false 75 195 105 210

zeldaup2
false
0
Polygon -6459832 true false 165 152 135 152 135 137 120 137 120 122 90 122 90 107 75 107 75 62 90 62 90 92 105 92 105 47 120 47 120 32 180 32 180 47 195 47 195 92 210 92 210 62 225 62 225 107 210 107 210 122 180 122 180 137 165 137 165 152
Polygon -955883 true false 105 105 120 105 120 75 180 75 180 105 195 105 195 60 180 60 180 45 120 45 120 60 105 60 105 105
Polygon -10899396 true false 135 105 135 75 120 75 120 105 135 105
Polygon -10899396 true false 180 75 165 75 165 105 180 105 180 75
Rectangle -16777216 true false 165 90 180 105
Rectangle -16777216 true false 120 90 135 105
Rectangle -10899396 true false 180 45 195 60
Rectangle -10899396 true false 120 30 180 45
Rectangle -10899396 true false 105 45 120 60
Rectangle -10899396 true false 90 150 150 165
Rectangle -10899396 true false 105 120 120 150
Rectangle -10899396 true false 120 135 135 150
Rectangle -10899396 true false 90 135 105 150
Rectangle -10899396 true false 105 165 135 180
Rectangle -6459832 true false 75 135 90 165
Rectangle -16777216 true false 210 105 225 135
Rectangle -16777216 true false 105 180 135 195
Rectangle -16777216 true false 90 165 105 180
Rectangle -10899396 true false 105 195 135 210
Rectangle -10899396 true false 105 180 105 195
Rectangle -10899396 true false 120 210 165 225
Rectangle -6459832 true false 105 225 135 240
Rectangle -6459832 true false 105 210 120 225
Rectangle -10899396 true false 150 180 165 195
Polygon -16777216 true false 165 165 135 180
Rectangle -16777216 true false 135 165 165 180
Rectangle -16777216 true false 135 195 165 210
Rectangle -10899396 true false 180 120 195 135
Rectangle -10899396 true false 150 150 180 165
Rectangle -10899396 true false 120 45 180 60
Rectangle -10899396 true false 105 60 195 75
Rectangle -10899396 true false 135 75 165 90
Rectangle -10899396 true false 135 90 150 105
Rectangle -955883 true false 150 90 180 105
Rectangle -955883 true false 120 90 135 105
Rectangle -10899396 true false 135 135 180 150
Rectangle -955883 true false 120 105 180 120
Rectangle -2674135 true false 195 120 225 135
Rectangle -10899396 true false 105 165 195 210
Rectangle -16777216 true false 90 165 105 180
Rectangle -16777216 true false 105 180 180 195
Rectangle -10899396 true false 180 135 195 210
Rectangle -10899396 true false 180 165 195 180
Rectangle -16777216 true false 180 165 195 180
Rectangle -6459832 true false 165 210 195 255
Rectangle -6459832 true false 195 135 210 165

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
