breed [walkers walker]
breed [arrows arrow]



walkers-own [
  flockmates         ;; agentset of nearby walkers
  nearest-neighbor   ;; closest one of our flockmates
]

arrows-own [
  flockmates         ;; agentset of nearby walkers
]

globals [
  max-align-turn
  max-cohere-turn
  max-separate-turn
  differance


  ]

to setup

  clear-all
  let a random 200
  random-seed a
  set max-align-turn max-allowed-turn
  set max-cohere-turn max-allowed-turn
  set max-separate-turn max-allowed-turn

  create-walkers population
  ask walkers
    [ifelse  who >= ( population * fix-walkers )
      [ set color yellow   ;; random shades look nice
        set size 0.5  ;; easier to see
        setxy random-xcor random-ycor
   ;     set firstrun  "true"
        set heading random 360
      ]
      [set color red   ;; random shades look nice
       set shape "arrow"
       set size 2  ;; easier to see
       setxy random-xcor random-ycor
       set heading 42
      ]
    ]
    reset-ticks

    create-arrows 1
       [set xcor -10
        set ycor -10
        set shape "thin_arrow"
        set color 43
        set heading mean [heading] of walkers with [color = yellow]
        set size 10
        set flockmates turtles with [color = yellow]
       ]
       create-arrows 1
       [set xcor -5
        set ycor -10
        set shape "thin_arrow"
        set color 13
        set heading mean [heading] of walkers with [color = red]
        set size 10
       ]
end

to go
  set max-align-turn max-allowed-turn
  set max-cohere-turn max-allowed-turn
  set max-separate-turn max-allowed-turn
  ask walkers with [color = yellow][ flock ]
  if Illuminati-change? [
    ask walkers with [color = red][
      ifelse Illuminaty-Random-Move? [
        ifelse (random-float 1 >= 0.5)
          [rt 0.05 * Illuminati-change-speed]
          [lt 0.05 * Illuminati-change-speed]]
      [rt 0.05 * Illuminati-change-speed]]
  ]

  repeat 5 [ask walkers [ fd 0.1 ]]

  ask arrow Population [
    set heading mean [heading] of walkers with [color = yellow]
    set size population / standard-deviation [heading] of walkers with [color = yellow]]

  ask arrow (Population + 1) [
    set heading mean [heading] of walkers with [color = red]]


  set differance abs(mean [heading] of walkers with [color = yellow] - mean [heading] of walkers with [color = red] )

  ifelse (hide_Illuminati? = true)
    [ask walkers with [color = red][set hidden? true]]
    [ask walkers with [color = red][set hidden? false]]
  if (differance < 5) [if stop-when-aligned? [stop]]
  tick
end

to flock  ;; walker procedure
  find-flockmates
  if any? flockmates
    [ find-nearest-neighbor
      ifelse distance nearest-neighbor < minimum-separation
        [ separate ]
        [ align
          cohere ] ]
end

to find-flockmates  ;; walker procedure
  set flockmates other walkers in-radius vision
end

to find-nearest-neighbor ;; walker procedure
  set nearest-neighbor min-one-of flockmates [distance myself]
end

;;; SEPARATE

to separate  ;; walker procedure
  turn-away ([heading] of nearest-neighbor) max-separate-turn
end

;;; ALIGN

to align  ;; walker procedure
  turn-towards average-flockmate-heading max-align-turn
end

to-report average-flockmate-heading  ;; walker procedure
  ;; We can't just average the heading variables here.
  ;; For example, the average of 1 and 359 should be 0,
  ;; not 180.  So we have to use trigonometry.
  let x-component sum [sin heading] of flockmates
  let y-component sum [cos heading] of flockmates
  ifelse x-component = 0 and y-component = 0
    [ report heading ]
    [ report atan x-component y-component ]
end


to-report degree-from-avg-herd-to-avg-enligtened  ;; observer walker procedure
  ;; We can't just average the heading variables here.
  ;; For example, the average of 1 and 359 should be 0,
  ;; not 180.  So we have to use trigonometry.
  let x-component sum [sin heading] of flockmates
  let y-component sum [cos heading] of flockmates
  ifelse x-component = 0 and y-component = 0
    [ report heading ]
    [ report atan x-component y-component ]
end
;;; COHERE

to cohere  ;; walker procedure
  turn-towards average-heading-towards-flockmates max-cohere-turn
end

to-report average-heading-towards-flockmates  ;; walker procedure
  ;; "towards myself" gives us the heading from the other walker
  ;; to me, but we want the heading from me to the other walker,
  ;; so we add 180
  let x-component mean [sin (towards myself + 180)] of flockmates
  let y-component mean [cos (towards myself + 180)] of flockmates
  ifelse x-component = 0 and y-component = 0
    [ report heading ]
    [ report atan x-component y-component ]
end

;;; HELPER PROCEDURES

to turn-towards [new-heading max-turn]  ;; walker procedure
  turn-at-most (subtract-headings new-heading heading) max-turn
;  ]
end

to turn-away [new-heading max-turn]  ;; walker procedure
  turn-at-most (subtract-headings heading new-heading) max-turn
end

;; turn right by "turn" degrees (or left if "turn" is negative),
;; but never turn more than "max-turn" degrees
to turn-at-most [turn max-turn]  ;; walker procedure
  ifelse abs turn > max-turn
    [ ifelse turn > 0
        [ rt max-turn ]
        [ lt max-turn ] ]
    [ rt turn ]
end


to-report shanon-entropy



end
@#$#@#$#@
GRAPHICS-WINDOW
248
44
825
642
40
40
7.0
1
10
1
1
1
0
1
1
1
-40
40
-40
40
1
1
1
ticks
30.0

BUTTON
39
105
116
138
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
122
105
203
138
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
17
43
240
76
Population
Population
1.0
3000
1000
1.0
1
NIL
HORIZONTAL

SLIDER
33
207
216
240
vision
vision
0.0
10.0
3
0.5
1
patches
HORIZONTAL

SLIDER
32
254
217
287
minimum-separation
minimum-separation
0.0
5.0
0.5
0.1
1
patches
HORIZONTAL

SLIDER
21
470
54
620
fix-walkers
fix-walkers
0
0.2
0.05
0.001
1
NIL
VERTICAL

MONITOR
1033
297
1168
342
Illuminati Mean Direction
mean [heading] of walkers with [color = red]
4
1
11

PLOT
859
378
1352
575
plot 1
Time
Angle
0.0
10.0
0.0
370.0
true
true
"" ""
PENS
"Direction of herd" 1.0 0 -7171555 true "" "plot mean [heading] of walkers with [color = yellow]"
"Direction of Illuminali" 1.0 0 -2674135 true "" "plot mean [heading] of walkers with [color = red]"

MONITOR
861
298
986
343
Herd Mean Direction
mean [heading] of walkers with [color = yellow]
1
1
11

SLIDER
33
300
217
333
max-allowed-turn
max-allowed-turn
0
90
15
1
1
NIL
HORIZONTAL

TEXTBOX
864
44
1378
284
1. The yellow arrow shows the mean direction of the herd.\n\n2. The red arrow only shows the direciton of the Illuminati. It starts at 42 degree direction (see \"The Hitchhiker's Guide to the Galaxy for 42\"), then if Orthodox-change? botton is On, changes slowly.\n   \nQuestion: \n1. On waht initial conditions would the herd converge?\n2. Does individualism vs collectivism; i.e. minimum separation levels, help or harm the control of the herd by the Illuminali?\n\n\n
16
70.0
0

MONITOR
857
593
993
650
differance
differance
2
1
14

SWITCH
65
474
236
507
hide_Illuminati?
hide_Illuminati?
0
1
-1000

SWITCH
65
512
237
545
Illuminati-change?
Illuminati-change?
1
1
-1000

SWITCH
37
141
201
174
stop-when-aligned?
stop-when-aligned?
1
1
-1000

SLIDER
64
549
235
582
Illuminati-change-speed
Illuminati-change-speed
0
10
3
1
1
NIL
HORIZONTAL

SWITCH
63
587
234
620
Illuminaty-Random-Move?
Illuminaty-Random-Move?
1
1
-1000

TEXTBOX
318
12
788
87
Minority of Conservatives Control of Larger Crowds
20
0.0
1

@#$#@#$#@
## WHAT IS IT?

This model is an attempt to understand the effect of a hidden leadership on a crowd.
Two groups of people interact:

The first, is a group of ultra liberal (non conservative) entities. They follow their peers and run after every new idea. They are illustrated by a Flocking dynamics (see Flocking Netlogo model Copyright 1998 Uri Wilensky).

The second is a group of ultra conservative - the Illuminati.
They only move in one direction with no change, OR move all together in a fully coordinated direction.

Two arrows show the mean direction of the regular people and that of the Illuminati.
The plot shows the difference between the two means.


## HOW IT WORKS
The Illuminati can either move to one singe direction or slowly change their move.
In both methods, they all move always in the same direction, and always together.
They can either be seen or hidden visually, but they are always not seen by the crowd, who observes them as a regular person.

The ultra liberal person (bird) follow three known rules: "alignment", "separation", and "cohesion". They do not know who are the Illuminati and who are the others. They just see their near neighbors as much as their vision permits.


For the regular group, simlar to the original flocking model, "Alignment" means that a each tends to turn so that it is moving in the same direction that nearby people .
"Separation" means that a person will turn to avoid another one which gets too close. "Cohesion" means that a person will move towards other nearby persons (unless another one is too close).
The "separation" rule overrides the other two, which are deactivated until the minimum separation is achieved. The three rules affect only the person's heading.  Each person always moves forward at the same constant speed.

## HOW TO USE IT
Determine the population.
Determine the fractiopn of ultra-aurthodox in the population (fix-awalkers).
Determine the flocking parameters (vision, min-separation, max-turn).


## THINGS TO NOTICE
What is the role of conservatism in society? How JUST BY NOT CHANGING one`s direction, a small fraction of the population can eventually change a substancially larger fractions than its own.
How fast the herd is being controled by the Illuminatti.
What is the required fraction of Illuminati to control the entire croud.


## THINGS TO TRY

What happen when personakl similarity (minimal distance) grows or reduced to 0.
Wht initial conditions make the croud easier to control by the Illuminati?

## EXTENDING THE MODEL


## NETLOGO FEATURES


## RELATED MODELS


Flocking

## CREDITS AND REFERENCES
This model is strongly constructed upon the model of flocking (Copyright 1998 Uri Wilensky. All rights reserved.).
While the changes are minor, their interpretation is interesting enought to show it on a model of itself.
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
The FLOCKING model is inspired by the Boids simulation invented by Craig Reynolds.  The algorithm we use here is roughly similar to the original Boids algorithm, but it is not the same.  The exact details of the algorithm tend not to matter very much -- as long as you have alignment, separation, and cohesion, you will usually get flocking behavior resembling that produced by Reynolds' original model.  Information on Boids is available at http://www.red3d.com/cwr/boids/.

## HOW TO CITE

## COPYRIGHT NOTICE

Flocking - Copyright 1998 Uri Wilensky. All rights reserved.

Permission to use, modify or redistribute this model is hereby granted, provided that both of the following requirements are followed:
a) this copyright notice is included.
b) this model will not be redistributed for profit without permission from Uri Wilensky. Contact Uri Wilensky for appropriate licenses for redistribution for profit.

This model was created as part of the project: CONNECTED MATHEMATICS: MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL MODELS (OBPML).  The project gratefully acknowledges the support of the National Science Foundation (Applications of Advanced Technologies Program) -- grant numbers RED #9552950 and REC #9632612.

This model was converted to NetLogo as part of the projects: PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT. The project gratefully acknowledges the support of the National Science Foundation (REPP & ROLE programs) -- grant numbers REC #9814682 and REC-0126227. Converted from StarLogoT to NetLogo, 2002.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

thin_arrow
true
0
Polygon -7500403 true true 150 0 105 150 135 150 135 285 165 285 165 150 195 150

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
set population 200
setup
repeat 200 [ go ]
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="Rigid_population14.4.15" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <final>let regular (mean[heading] of turtles with [color != red])
let enlightened ( mean[heading] of turtles with [color = red])
let differance (abs(regular - enlightened))
report differance</final>
    <exitCondition>tick = 100</exitCondition>
    <enumeratedValueSet variable="fix-turtles">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="1000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-allowed-turn">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="minimum-separation">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <metric>differance</metric>
    <enumeratedValueSet variable="fix-turtles">
      <value value="0.01"/>
      <value value="0.025"/>
      <value value="0.05"/>
      <value value="0.075"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="1000"/>
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="2"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-allowed-turn">
      <value value="1"/>
      <value value="2.5"/>
      <value value="5"/>
      <value value="7.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="minimum-separation">
      <value value="1"/>
      <value value="2.5"/>
      <value value="7.5"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="30.4.15" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>differance</metric>
    <enumeratedValueSet variable="population">
      <value value="1000"/>
      <value value="2500"/>
      <value value="5000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-allowed-turn">
      <value value="1"/>
      <value value="10"/>
      <value value="20"/>
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="minimum-separation">
      <value value="0.5"/>
      <value value="2.5"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fix-walkers">
      <value value="0.01"/>
      <value value="0.025"/>
      <value value="0.05"/>
      <value value="0.075"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
