globals [x y p1 p2 population-size f-x f-y fly-ID list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9]    ;p1=selected parent 1, p2=selected parent 2,
turtles-own [c1 c2 genotype phenotype gender eye-shape wing-shape body-color]

breed [sperms sperm]
breed [eggs egg]
breed [flies a-fly]
breed [crosses cross]

to setup
  ca
  set-gametes
  fertilization
  set-tray
  output-results
  reset-ticks

end

to set-gametes

set population-size 20 + random 16

(ifelse
  Cases = "Case 1" [              ;bar eyes.
  create-sperms population-size
  [gamete-trait
    set c1 item random 3 ["XEB" "XEb" "Y"]     ;given the three possoibilities, the gender ratio does not start with 1:1 at the beginning but brias to female
    set c2 "D"                               ;all flies are normal-winged
    set genotype word c1 c2                  ;form  genotype of gamete
    ]

  create-eggs population-size
  [gamete-trait
    set c1 item random 2 ["XEB" "XEb"]
    set c2 "D"
    set genotype word c1 c2
    ]
  ]

 Cases = "Case 2" [             ; dumpy wings
   create-sperms population-size
  [gamete-trait
    set c1 item random 2 ["XEb" "Y"]         ; Xb is normal eye trait
    set c2 item random 3 ["D" "d" "d"]        ; D and d are wing shape color alleles.
    set genotype word c1 c2
    ]

  create-eggs population-size
  [gamete-trait
    set c1 "XEb"
    set c2 item random 3 ["D" "d" "d"]
    set genotype word c1 c2
    ]
  ]



Cases = "Case 3" [             ;yellow body.
   create-sperms population-size
  [gamete-trait
    set c1 item random 3 ["XEb" "Xeb" "Y"]         ; XE is normal body color
    set c2 "D"                                   ; nomral wings
    set genotype word c1 c2
    ]

  create-eggs population-size
  [gamete-trait
    set c1 item random 2 ["XEb" "Xeb"]
    set c2 "D"
    set genotype word c1 c2
    ]
  ]
)



end

to gamete-trait
  set shape "dot"
    set size 0.1
    setxy random-xcor random-ycor
end

to express

  ;;Determine phenotypes based on the allele, then code the phenotypes
  ifelse member? "Y" genotype = true [set gender "male" set size 0.75 set phenotype "m-" ][set gender "female" set size 0.9 set phenotype "f-"]

  ifelse member? "D" genotype = true [set wing-shape "normal-winged" set phenotype word phenotype "lw-"][set wing-shape "dumpy-winged" set phenotype word phenotype "dw-"]

  ifelse member? "XE" genotype = true
  [(ifelse
    member? "B" genotype = true and member? "b" genotype = false
    [set eye-shape "bar eye" set phenotype word phenotype "b-"]

    member? "B" genotype = false and member? "b" genotype = true
    [set eye-shape "normal eye" set phenotype word phenotype "r-"]

     member? "B" genotype = true and member? "b" genotype = true
    [set eye-shape "kidney eye" set phenotype word phenotype "h-"])

    set body-color "normal body" set phenotype word phenotype "lb"]

  [(ifelse
    member? "B" genotype = true and member? "b" genotype = false
    [set eye-shape "bar eye" set phenotype word phenotype "b-"]

    member? "B" genotype = false and member? "b" genotype = true
    [set eye-shape "normal eye" set phenotype word phenotype "r-"]

     member? "B" genotype = true and member? "b" genotype = true
    [set eye-shape "kidney eye" set phenotype word phenotype "h-"])

    set body-color "yellow body" set phenotype word phenotype "yb"]





  ;;Determine the shape and color using phenotype codes
  if phenotype = "m-lw-r-lb" [set shape "fly-m-r-lw"]
  if phenotype = "m-lw-r-yb" [set shape "fly-m-r-lw" set color 48.5]  ;set yellow body color
  if phenotype = "m-dw-r-lb" [set shape "fly-m-r-dp"]
  ;if phenotype = "m-dw-r-yb" [set shape "fly-m-r-dp" set color 48.5]
  if phenotype = "m-lw-b-lb" [set shape "fly-m-b-lw"]
  ;if phenotype = "m-lw-b-yb" [set shape "fly-m-b-lw" set color 48.5]


  if phenotype = "f-lw-h-lb" [set shape "fly-f-h-lw"]
  if phenotype = "f-lw-r-lb" [set shape "fly-f-r-lw"]
  if phenotype = "f-lw-r-yb" [set shape "fly-f-r-lw" set color 48.5]
  if phenotype = "f-dw-r-lb" [set shape "fly-f-r-dp"]
 ; if phenotype = "f-dw-r-yb" [set shape "fly-f-r-dp" set color 48.5]
  if phenotype = "f-lw-b-lb" [set shape "fly-f-b-lw"]
  ;if phenotype = "f-lw-b-yb" [set shape "fly-f-b-lw" set color 48.5]


end

to fertilization

  ask eggs
  [let mate one-of sperms
    if mate != nobody
    [hatch-flies 1
     [set color 28             ;set light body color, some will be overwritten to a black body color in express
       set heading 0
       set genotype word genotype [genotype] of mate
       express
       set-position
      ]
      ask mate [die]
      die
  ]]

  ask sperms [die]
  ask eggs [die]
end

to set-tray
  ask patches [set pcolor 102 + random-float 0.5]
  ask patches with [pxcor >= max-pxcor - 1] [set pcolor 87]

  create-crosses 1
   [set shape "x"
    setxy max-pxcor - 0.5 max-pycor / 2
    set size 0.5
    set color 35]

  create-crosses 1 [
    set shape "female"
    set heading 45
    setxy max-pxcor + 0.25 5
    set size 0.75
    set color 0]

 create-crosses 1 [
    set shape "male"
    set heading 45
    setxy max-pxcor + 0.25 min-pycor + 0.25
    set size 0.75
    set color 0]
end

to set-position
  setxy random 10 random 7
  if any? other flies-here [set-position]
end

;====================================================================================

to go

  ifelse count flies != 2
[output-print ""
 output-print "Please first choose two parent flies."]
[
    gametogenesis
    fertilization
]

end

to pick

;clear-output
  if mouse-inside? [
    if mouse-down? [
      set x round mouse-xcor set y round mouse-ycor
      ask flies with [xcor = x and ycor = y]
        [ if gender = "male"
            [ifelse count flies with [gender = "male" and pxcor >  max-pxcor - 1] > 0
            [set p1 "Opse! You have chosen a male."]
            [set size 1.25 setxy max-pxcor - 0.5 1.5

            let dad flies with [pxcor >= max-pxcor - 1 and gender = "male"]
            set p2 [eye-shape] of dad
            set p2 word p2 " "
            set p2 word p2 [wing-shape] of dad
            set p2 word p2 " "
            set p2 word p2 [body-color] of dad
          ]]

          if gender = "female"
            [ifelse count flies with [pxcor > max-pxcor - 1 and gender = "female"] > 0
            [set p2 "Opse! You have chosen a female."]
            [set size 1.25 setxy max-pxcor - 0.5 4.5

             let mom flies with [pxcor >= max-pxcor - 1 and gender = "female"]
             set p1 [eye-shape] of mom
             set p1 word p1 " "
             set p1 word p1 [wing-shape] of mom
             set p1 word p1 " "
             set p1 word p1 [body-color] of mom
          ]]
  ]]]


 if count flies with [pxcor >= max-pxcor - 1] = 2 [
  ask flies with [pxcor < max-pxcor - 1 ] [die]
  ask eggs [die]
  ask sperms [die]
  stop
  ]

end

to gametogenesis

set population-size 4 * (14 + random 4)

  ;set eggs

  let mom one-of flies with [gender = "female"]

  (ifelse       ;set XEB gene
    member? "XEB" [genotype] of mom = true and member? "XEb" [genotype] of mom = false and member? "Xeb" [genotype] of mom = false   ;XEBXEB
     [create-eggs population-size [set genotype "XEB" gamete-trait ]]

    member? "XEB" [genotype] of mom = false and member? "XEb" [genotype] of mom = true and member? "Xeb" [genotype] of mom = false   ;XEbXEb
     [create-eggs population-size [set genotype "XEb" gamete-trait ]]

    member? "XEB" [genotype] of mom = false and member? "XEb" [genotype] of mom = false and member? "Xeb" [genotype] of mom = true   ;XebXeb
     [create-eggs population-size [set genotype "Xeb" gamete-trait ]]

    member? "XEB" [genotype] of mom = true and member? "XEb" [genotype] of mom = true and member? "Xeb" [genotype] of mom = false   ;XEBXEb
     [create-eggs 0.5 * population-size [set genotype "XEB" gamete-trait ]
      create-eggs 0.5 * population-size [set genotype "XEb" gamete-trait ]]

    member? "XEB" [genotype] of mom = true and member? "XEb" [genotype] of mom = false and member? "Xeb" [genotype] of mom = true   ;XEBXeb
     [create-eggs 0.5 * population-size [set genotype "XEB" gamete-trait ]
      create-eggs 0.5 * population-size [set genotype "Xeb" gamete-trait ]]

    member? "XEB" [genotype] of mom = false and member? "XEb" [genotype] of mom = true and member? "Xeb" [genotype] of mom = true   ;XEbXeb
     [create-eggs 0.5 * population-size [set genotype "XEb" gamete-trait ]
      create-eggs 0.5 * population-size [set genotype "Xeb" gamete-trait ]]

   )

  (ifelse        ;Set D gene
    member? "D" [genotype] of mom = true and member? "d" [genotype] of mom = false ;DD
    [ask eggs [set genotype word genotype "D"]]

    member? "D" [genotype] of mom = false and member? "d" [genotype] of mom = true ;dd
    [ask eggs [set genotype word genotype "d"]]

    member? "D" [genotype] of mom = true and member? "d" [genotype] of mom = true ;Dd
    [ask n-of (0.5 * count eggs with [genotype = "XEb"]) eggs with [genotype = "XEb"] [set genotype word genotype "D"]  ; XEbD  50%
      ask eggs with [genotype = "XEb"] [set genotype word genotype "d"]])                                                 ; XEbd 50%



   ; set sperms

   let dad one-of flies with [gender = "male"]

   (ifelse

      member? "XEB" [genotype] of dad = true and member? "XEb" [genotype] of dad = false and member? "Xeb" [genotype] of dad = false    ;XEBY
           [create-sperms 0.5 * population-size [set genotype "XEB" gamete-trait ] create-sperms 0.5 * population-size [set genotype "Y" gamete-trait ]]

      member? "XEb" [genotype] of dad = true and member? "XEB" [genotype] of dad = false and member? "Xeb" [genotype] of dad = false    ;XEbY
           [create-sperms 0.5 * population-size [set genotype "XEb" gamete-trait ] create-sperms 0.5 * population-size [set genotype "Y" gamete-trait ]]

      member? "XEb" [genotype] of dad = false and member? "XEB" [genotype] of dad = false and member? "Xeb" [genotype] of dad = true    ;XebY
           [create-sperms 0.5 * population-size [set genotype "Xeb" gamete-trait ] create-sperms 0.5 * population-size [set genotype "Y" gamete-trait ]])



  (ifelse        ;Set D gene

   member? "D" [genotype] of dad = true and member? "d" [genotype] of dad = false ;DD
    [ask sperms [set genotype word genotype "D"]]

   member? "d" [genotype] of dad = true and member? "D" [genotype] of dad = false ;dd
    [ask sperms [set genotype word genotype "d"]]

   member? "d" [genotype] of dad = true and member? "D" [genotype] of dad = true ;Dd
     [ask n-of (0.5 * count sperms with [genotype = "XEB"]) sperms with [genotype = "XEB"] [set genotype word genotype "D"]  ; XEBD  50%
      ask sperms with [genotype = "XEB"] [set genotype word genotype "d"]                                                    ; XEBd 50%

      ask n-of (0.5 * count sperms with [genotype = "XEb"]) sperms with [genotype = "XEb"] [set genotype word genotype "D"]  ; XEbD  50%
      ask sperms with [genotype = "XEb"] [set genotype word genotype "d"]                                                    ; XEbd 50%

      ask n-of (0.5 * count sperms with [genotype = "Xeb"]) sperms with [genotype = "Xeb"] [set genotype word genotype "D"]  ; XebD  50%
      ask sperms with [genotype = "Xeb"] [set genotype word genotype "d"]                                                    ; Xebd 50%

      ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "D"]  ; YD  50%
      ask sperms with [genotype = "Y"] [set genotype word genotype "d"]])                                               ; Yd 50%

  ask flies [die]

end

to output-results

  (ifelse

   Cases = "Case 1" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of the abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of the abdomen."
  output-print ""
  output-print "Guiding Questions:"
  output-print "   Are the eye shape traits inherited through incomplete dominance or multiple alleles?"
  output-print "   Are the eye shape traits sex-linked or autosomal?"
    ]

Cases = "Case 2" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of the abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of the abdomen."
  output-print ""
  output-print "Guiding Questions:"
  output-print "   Is the dumpy wing trait dominant or recessive?"
  output-print "   Is the dumpy wing trait sex-linked or autosomal?"
  ]

 Cases = "Case 3" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of the abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of the abdomen."
  output-print ""
  output-print "Guiding Questions:"
  output-print "   Is the yellow body trait dominant or recessive?"
  output-print "   Is the yellow body trait sex-linked or autosomal?"
  ]
    )

end

to set-lists


  if any? flies with [xcor <= 9][
         set list-1 [who] of flies with [phenotype = "m-lw-r-lb" and xcor < max-pxcor - 1]
         set list-2 [who] of flies with [phenotype = "m-lw-r-yb" and xcor < max-pxcor - 1]
         set list-1 sentence list-1 list-2

         set list-3 [who] of flies with [phenotype = "m-dw-r-lb" and xcor < max-pxcor - 1]
         set list-4 [who] of flies with [phenotype = "m-lw-b-lb" and xcor < max-pxcor - 1]
         set list-3 sentence list-3 list-4
         set list-1 sentence list-1 list-3

         set list-5 list-1



         set list-1 [who] of flies with [phenotype = "f-lw-r-lb" and xcor < max-pxcor - 1]
         set list-2 [who] of flies with [phenotype = "f-lw-r-yb" and xcor < max-pxcor - 1]
         set list-1 sentence list-1 list-2

         set list-3 [who] of flies with [phenotype = "f-dw-r-lb" and xcor < max-pxcor - 1]
         set list-4 [who] of flies with [phenotype = "f-lw-b-lb" and xcor < max-pxcor - 1]
         set list-3 sentence list-3 list-4
         set list-1 sentence list-1 list-3

         set list-6 [who] of flies with [phenotype = "f-lw-h-lb" and xcor < max-pxcor - 1]
         set list-1 sentence list-1 list-6

         set list-1 sentence list-1 list-5



    sorting
      ]
end

to sorting

   set f-x 0
        set f-y max-pycor
        set fly-ID 0

        repeat length list-1
        [ask flies with [who = item fly-ID list-1] [setxy f-x f-y]
          ifelse f-y > 0 [set f-y f-y - 1][set f-y max-pycor set f-x f-x + 1]
          set fly-ID fly-ID + 1 ]

end
@#$#@#$#@
GRAPHICS-WINDOW
0
104
776
561
-1
-1
64.0
1
10
1
1
1
0
1
1
1
0
11
0
6
0
0
1
ticks
5.0

BUTTON
818
178
940
211
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
818
221
1009
254
Press & Choose 2 parent flies
Pick
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
313
731
396
772
Normal body
count flies with [gender = \"male\" and eye-shape = \"bar eye\" and wing-shape = \"dumpy-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
225
638
305
679
Yellow body
count flies with [gender = \"female\" and eye-shape = \"normal eye\" and wing-shape = \"dumpy-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
313
688
396
729
Normal body
count flies with [gender = \"male\" and eye-shape = \"bar eye\" and wing-shape = \"normal-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
141
595
224
636
Normal body
count flies with [gender = \"female\" and eye-shape = \"normal eye\" and wing-shape = \"normal-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
667
792
808
841
Total offspring flies
count flies
17
1
12

BUTTON
818
267
911
300
Cross!
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
4
568
72
588
Progeny:
15
15.0
1

CHOOSER
783
127
912
172
Cases
Cases
"Case 1" "Case 2" "Case 3"
0

TEXTBOX
784
173
816
308
|\n|-->\n|\n|\n|-->\n|\n|\n|-->\n
11
0.0
1

MONITOR
397
688
477
729
Yellow body
count flies with [gender = \"male\" and eye-shape = \"bar eye\" and wing-shape = \"normal-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
141
638
224
679
Normal body
count flies with [gender = \"female\" and eye-shape = \"normal eye\" and wing-shape = \"dumpy-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
397
731
477
772
Yellow body
count flies with [gender = \"male\" and eye-shape = \"bar eye\" and wing-shape = \"dumpy-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
225
595
305
636
Yellow body
count flies with [gender = \"female\" and eye-shape = \"normal eye\" and wing-shape = \"normal-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
313
638
396
679
Normal body
count flies with [gender = \"female\" and eye-shape = \"bar eye\" and wing-shape = \"dumpy-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
397
638
477
679
Yellow body
count flies with [gender = \"female\" and eye-shape = \"bar eye\" and wing-shape = \"dumpy-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
313
595
396
636
Normal body
count flies with [gender = \"female\" and eye-shape = \"bar eye\" and wing-shape = \"normal-winged\" and body-color = \"normal body\"]
17
1
10

TEXTBOX
3
604
157
682
                |-Normal wings\n                |\nFemales-|\n                |\n                |-Dumpy wings
11
0.0
1

MONITOR
397
595
477
636
Yellow body
count flies with [gender = \"female\" and eye-shape = \"bar eye\" and wing-shape = \"normal-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
141
688
224
729
Normal body
count flies with [gender = \"male\" and eye-shape = \"normal eye\" and wing-shape = \"normal-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
225
688
305
729
Yellow body
count flies with [gender = \"male\" and eye-shape = \"normal eye\" and wing-shape = \"normal-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
141
731
224
772
Normal body
count flies with [gender = \"male\" and eye-shape = \"normal eye\" and wing-shape = \"dumpy-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
225
731
305
772
Yellow body
count flies with [gender = \"male\" and eye-shape = \"normal eye\" and wing-shape = \"dumpy-winged\" and body-color = \"yellow body\"]
17
1
10

OUTPUT
0
10
776
102
11

MONITOR
780
410
1018
451
Female
p1
17
1
10

MONITOR
780
472
1017
513
Male
p2
17
1
10

TEXTBOX
780
386
843
405
Parents:
15
15.0
1

TEXTBOX
894
455
915
473
X
14
0.0
1

MONITOR
172
791
280
832
Total normal eyes
count flies with [eye-shape = \"normal eye\"]
17
1
10

MONITOR
343
791
451
832
Total bar eyes
count flies with [eye-shape = \"bar eye\"]
17
1
10

MONITOR
764
637
896
678
Total normal wings
count flies with [wing-shape = \"normal-winged\"]
17
1
10

MONITOR
764
682
895
723
Total dumpy wings
count flies with [wing-shape = \"dumpy-winged\"]
17
1
10

MONITOR
664
705
759
746
Total males
count flies with [gender = \"male\"]
17
1
10

MONITOR
662
617
761
658
Total females
count flies with [gender = \"female\"]
17
1
10

MONITOR
257
836
371
877
Total normal body
count flies with [body-color = \"normal body\"]
17
1
10

MONITOR
427
835
538
876
Total yellow body
count flies with [body-color = \"yellow body\"]
17
1
10

TEXTBOX
3
773
950
791
--------------------------------------------------------------------------------------------------------------------------------
12
7.0
1

TEXTBOX
654
561
669
883
|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|
8
7.0
1

BUTTON
818
311
911
344
Sort Flies
set-lists
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
485
595
568
636
Normal body
count flies with [gender = \"female\" and eye-shape = \"kidney eye\" and wing-shape = \"normal-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
485
638
568
679
Normal body
count flies with [gender = \"female\" and eye-shape = \"kidney eye\" and wing-shape = \"dumpy-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
569
595
649
636
Yellow body
count flies with [gender = \"female\" and eye-shape = \"kidney eye\" and wing-shape = \"normal-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
569
638
649
679
Yellow body
count flies with [gender = \"female\" and eye-shape = \"kidney eye\" and wing-shape = \"dumpy-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
485
689
568
730
Normal body
count flies with [gender = \"male\" and eye-shape = \"kidney eye\" and wing-shape = \"normal-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
569
689
649
730
Yellow body
count flies with [gender = \"male\" and eye-shape = \"kidney eye\" and wing-shape = \"normal-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
485
732
568
773
Normal body
count flies with [gender = \"male\" and eye-shape = \"kidney eye\" and wing-shape = \"dumpy-winged\" and body-color = \"normal body\"]
17
1
10

MONITOR
569
732
649
773
Yellow body
count flies with [gender = \"male\" and eye-shape = \"kidney eye\" and wing-shape = \"dumpy-winged\" and body-color = \"yellow body\"]
17
1
10

MONITOR
508
791
619
832
Total kidney eyes
count flies with [eye-shape = \"kidney eye\"]
17
1
10

TEXTBOX
187
576
267
594
Normal eyes
12
0.0
1

TEXTBOX
369
576
428
594
Bar eyes
12
0.0
1

TEXTBOX
536
576
613
594
Kidney eyes
12
0.0
1

TEXTBOX
16
691
166
761
            |-Normal wings\n            |\nMales-|\n            |\n            |-Dumpy wings
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

This model allows students to explore the inheritance of bar eyes, yellow body color, and dumpy wings in fruit flies (_Drosophila melanogaster_). Students may gather data to infer whether these traits are dominant or recessive, sex-linked or autosomal. These traits are not often mentioned in the textbook, so teachers may use them to extend students' understanding after learning about the common examples (e.g., white-eyed).

## HOW TO USE

1. Select one of three cases.
2. Click the "Start/reset" button to start or start over.
3. Click the "Press and choose 2 parent flies" button. 
4. Choose a male and a female in the simulation window. The males are smaller and have a dark abdomen tip. 
5. Click the "cross!" button to conduct a test cross.
6. Examine offspring phenotypes in the simulation window and the "progeny" section.

## Related Models

Genetic Linkage  https://sites.google.com/view/genetic-linkage/model
 
Find more models at https://sites.google.com/view/3d-science-abm/home

## CREDITS AND REFERENCES

This model was made by Dr. Lin Xiang at the University of Kentucky.If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2023). Genetic Linkage Analysis in Drosophila. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

dot
false
0
Circle -7500403 true true 90 90 120

female
false
0
Circle -7500403 false true 120 75 58
Line -7500403 true 150 210 150 135
Line -7500403 true 180 165 150 165
Line -7500403 true 120 165 150 165

fly-abd-f
false
0
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fly-abd-m
false
0
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

fly-body
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16

fly-eye
false
0
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -7500403 true true 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -7500403 true true 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11

fly-f-b-lw
false
0
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -7500403 true true 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -2674135 true false 173 33 179 33 186 33 193 31 192 25 188 21 181 25 174 26 170 28
Polygon -2674135 true false 127 33 121 33 114 33 107 31 108 25 112 21 119 25 126 26 130 28

fly-f-h-lw
false
0
Polygon -7500403 true true 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -7500403 true true 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 118 27 125 21
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 182 27 175 21

fly-f-r-dp
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 123 87 122 59 100 117 74 177 54 244 75 267 110 244 136 249 167 244 168 204 162 172 149 142 129 107
Polygon -6459832 false false 177 87 178 59 200 117 226 177 246 244 225 267 190 244 164 249 133 244 132 204 138 172 151 142 171 107

fly-f-r-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fly-f-r-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 122 87 120 90 90 120 75 135 75 165 90 180 105 165 120 150 120 150 120 150 120 135 120 120 120 105
Polygon -6459832 false false 178 87 180 90 210 120 225 135 225 165 210 180 195 165 180 150 180 150 180 150 180 135 180 120 180 105

fly-f-w-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fly-f-w-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 122 87 120 90 90 120 75 135 75 165 90 180 105 165 120 150 120 150 120 150 120 135 120 120 120 105
Polygon -6459832 false false 178 87 180 90 210 120 225 135 225 165 210 180 195 165 180 150 180 150 180 150 180 135 180 120 180 105

fly-m-b-lw
false
0
Polygon -7500403 true true 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -7500403 true true 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 124 27 127 30 123 34 114 35 107 32 107 27 110 21 115 25 119 26
Polygon -2674135 true false 176 27 173 30 177 34 186 35 193 32 193 27 190 21 185 25 181 26

fly-m-r-dp
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 122 87 121 59 99 117 72 179 53 244 76 270 121 241 145 249 169 246 168 196 160 170 141 143 128 107
Polygon -6459832 false false 178 87 179 59 201 117 228 179 247 244 224 270 179 241 155 249 131 246 132 196 140 170 159 143 172 107

fly-m-r-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

fly-m-r-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 180 105 165 75 210 105 225 135 225 165 210 165 195 150 180 135 180 120 195 135 180 120 180 120 180 105
Polygon -6459832 false false 120 105 135 75 90 105 75 135 75 165 90 165 105 150 120 135 120 120 105 135 120 120 120 120 120 105

fly-m-w-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

fly-m-w-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 180 105 165 75 210 105 225 135 225 165 210 165 195 150 180 135 180 120 195 135 180 120 180 120 180 105
Polygon -6459832 false false 120 105 135 75 90 105 75 135 75 165 90 165 105 150 120 135 120 120 105 135 120 120 120 120 120 105

male
true
0
Circle -7500403 false true 120 150 58
Line -7500403 true 150 150 150 75
Line -7500403 true 150 75 135 90
Line -7500403 true 150 75 165 90

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
