globals [
  levels-dimension1
  levels-dimension2
  levels-dimension3
  a ; useful for iteration
  b
  c
  x
  dimension-dominant-next-child
  overall-importance-list
  overall-max-value
]

breed [Dimension1 Levels1]
breed [Dimension2 Levels2]
breed [Dimension3 Levels3]

turtles-own [
  active       ; whether this level of a given dimension is accurate for a given brain
  social-identification
  num-times-used
  current-salience
  comparative-fit
  normative-fit
  overall-importance
]

links-own [
  link-active        ; whether this link (between active levels) is active for a given brain
  link-num-times-used
  link-social-identification
  link-comparative-fit
  link-normative-fit
  link-overall-importance
  link-current-salience
]


to setup [
          levels-dimension1-fromparent
          levels-dimension2-fromparent
          levels-dimension3-fromparent]
  ca
  set-default-shape turtles "circle"

  set levels-dimension1 levels-dimension1-fromparent
  set levels-dimension2 levels-dimension2-fromparent
  set levels-dimension3 levels-dimension3-fromparent

  ; make all the possible identity nodes (i.e. all the levels for each dimension), using information from the parent model
  create-dim1
  create-dim2
  create-dim3

  ask turtles [
    set comparative-fit 0
    set normative-fit 0
    set num-times-used 0
    set social-identification 0
    set current-salience 0
    set size 1
    set color 3]
  ; create all possible links between turtles, and set them to inactive + grey

  link-all-levels
end


to create-dim1
  set a 1
  create-Dimension1 levels-dimension1
  ask Dimension1 [
      let y 32 / (levels-dimension1 + 2) * a - 15
      setxy -10 y
      set a a + 1]
end

to create-dim2
  set a 1
  create-Dimension2 levels-dimension2
  ask Dimension2 [
      let y 32 / (levels-dimension2 + 2) * a - 15
      setxy 0 y
      set a a + 1]
end

to create-dim3
  set a 1
  create-Dimension3 levels-dimension3
  ask Dimension3 [
      let y 32 / (levels-dimension3 + 2) * a - 15
      setxy 10 y
      set a a + 1]
end

to link-all-levels
  ask turtles [
    create-links-with other turtles]
  ask links [
    set color 3
    set link-active 0
    set link-social-identification 0
    set link-comparative-fit 0
    set link-normative-fit 0
    set link-overall-importance 0
    set link-current-salience 0]
end

to activate-levels [
           dim1_level
           dim2_level
           dim3_level
           dimension-dominant]
  ; first, select one level of each identity dimension to be active
  ask Levels1 (dim1_level - 1) [
    set active 1     ; this is the level of this identity that is active for this brain
    set color green]
  ask Levels2 (dim2_level + levels-dimension1 - 1) [
    set active 1
    set color green]
  ask Levels3 (dim3_level + levels-dimension1 + levels-dimension2 - 1) [
    set active 1
    set color green]

  ; now, have the links between the active nodes also be active
  ask links [if ([active] of end1 = 1) and ([active] of end2 = 1) [
    set link-active 1
    set color green]]

  ;now, assign one instance of enacting the identity to the "dimension-dominant" identity for this agent in the parent model
  if dimension-dominant = 1 [
    ask Dimension1 with [active = 1] [set num-times-used 1]]
  if dimension-dominant = 2 [
    ask Dimension2 with [active = 1] [set num-times-used 1]]
  if dimension-dominant = 3 [
    ask Dimension3 with [active = 1] [set num-times-used 1]]

  ; if intersectionality is a thing, assign dominance to the right link
  if dimension-dominant = 12 [
      ask links with [(link-active = 1 and (([breed] of [end1] of self = Dimension1 and [breed] of [end2] of self = Dimension2) or ([breed] of [end1] of self = Dimension2 and [breed] of [end2] of self = Dimension1)))] [
        set link-num-times-used 1]]
  if dimension-dominant = 23 [
      ask links with [(link-active = 1 and (([breed] of [end1] of self = Dimension2 and [breed] of [end2] of self = Dimension3) or ([breed] of [end1] of self = Dimension3 and [breed] of [end2] of self = Dimension2)))] [
        set link-num-times-used 1]]
  if dimension-dominant = 13 [
      ask links with [(link-active = 1 and (([breed] of [end1] of self = Dimension1 and [breed] of [end2] of self = Dimension3) or ([breed] of [end1] of self = Dimension3 and [breed] of [end2] of self = Dimension1)))] [
        set link-num-times-used 1]]
end

to gather-salience [
         dim1-salience-from-context
         dim2-salience-from-context
         dim3-salience-from-context
         intersectionality]
    ; these are standardized to be a # that is % of total salience
    ask Dimension1 [set current-salience item ([WHO] of self) dim1-salience-from-context]
    ask Dimension2 [set current-salience item ([WHO] of self - levels-dimension1) dim2-salience-from-context]
    ask Dimension3 [set current-salience item ([WHO] of self - levels-dimension1 - levels-dimension2) dim3-salience-from-context]
    if intersectionality = 1 [
      ask links [set link-current-salience (([[current-salience] of end1] of self + [[current-salience] of end2] of self) / 2)]
    ]
end

to define-comparative-fit [
          sharedlevel-distance-cat1
          sharedlevel-distance-cat2
          sharedlevel-distance-cat3
          notsharedlevel-distance-cat1
          notsharedlevel-distance-cat2
          notsharedlevel-distance-cat3
          sharedlevel-distance-intersection12
          sharedlevel-distance-intersection23
          sharedlevel-distance-intersection13
          notsharedlevel-distance-intersection12
          notsharedlevel-distance-intersection23
          notsharedlevel-distance-intersection13
          intersectionality]
  ; these are set to be numbers that are % of total possible comparative fit
  ask Dimension1 with [active = 1] [set comparative-fit round((notsharedlevel-distance-cat1 / sharedlevel-distance-cat1) * 10)]
  ask Dimension2 with [active = 1] [set comparative-fit round((notsharedlevel-distance-cat2 / sharedlevel-distance-cat2) * 10)]
  ask Dimension3 with [active = 1] [set comparative-fit round((notsharedlevel-distance-cat3 / sharedlevel-distance-cat3) * 10)]
  if intersectionality = 1 [
    ask activelink-intersection12 [set link-comparative-fit round((notsharedlevel-distance-intersection12 / sharedlevel-distance-intersection12) * 10)]
    ask activelink-intersection23 [set link-comparative-fit round((notsharedlevel-distance-intersection23 / sharedlevel-distance-intersection23) * 10)]
    ask activelink-intersection13 [set link-comparative-fit round((notsharedlevel-distance-intersection13 / sharedlevel-distance-intersection13) * 10)]]
end

to define-normative-fit [
           normative-fit-cat1
           normative-fit-cat2
           normative-fit-cat3
           normative-fit-intersection12
           normative-fit-intersection23
           normative-fit-intersection13
           intersectionality]
  ; these are set to be numbers that are a % of total possible normative fit
  ask Dimension1 with [active = 1] [set normative-fit normative-fit-cat1]
  ask Dimension2 with [active = 1] [set normative-fit normative-fit-cat2]
  ask Dimension3 with [active = 1] [set normative-fit normative-fit-cat3]
  if intersectionality = 1 [
    ask activelink-intersection12 [set link-normative-fit normative-fit-intersection12]
    ask activelink-intersection23 [set link-normative-fit normative-fit-intersection23]
    ask activelink-intersection13 [set link-normative-fit normative-fit-intersection13]
  ]
end

to determine-next-dimension [
             weight1
             weight2
             weight3
             weight4
             intersectionality
             dimension-dominant]
  ; have each active node determine how important it is, according to the weights of the four calculated measures
  ifelse (weight1 + weight2 + weight3 + weight4) != 0 [
    ask turtles with [active = 1] [
      set overall-importance ((normative-fit * weight1) + (comparative-fit * weight2) + (current-salience * weight3) + (social-identification * weight4))
      set size overall-importance / ( 25 * (weight1 + weight2 + weight3 + weight4))] ; scaling to make it pretty
    ifelse intersectionality = 1 [
      ask links with [link-active = 1][
        set link-overall-importance ((link-normative-fit * weight1) + (link-comparative-fit * weight2) + (link-current-salience * weight3) + (link-social-identification * weight4))
        set thickness (link-overall-importance / (weight1 + weight2 + weight3 + weight4)) / 200] ; scaling to make it pretty
      set overall-importance-list (list
        ([overall-importance] of Dimension1 with [active = 1])
        ([overall-importance] of Dimension2 with [active = 1])
        ([overall-importance] of Dimension3 with [active = 1])
        ([link-overall-importance] of activelink-intersection13)
        ([link-overall-importance] of activelink-intersection12)
        ([link-overall-importance] of activelink-intersection23))
      set overall-max-value max flatten-list overall-importance-list
      if position overall-max-value flatten-list overall-importance-list = 0 [
        set dimension-dominant-next-child 1]
      if position overall-max-value flatten-list overall-importance-list = 1 [
        set dimension-dominant-next-child 2]
      if position overall-max-value flatten-list overall-importance-list = 2 [
        set dimension-dominant-next-child 3]
      if position overall-max-value flatten-list overall-importance-list = 3 [
        set dimension-dominant-next-child 13]
      if position overall-max-value flatten-list overall-importance-list = 4 [
        set dimension-dominant-next-child 12]
      if position overall-max-value flatten-list overall-importance-list = 5 [
        set dimension-dominant-next-child 23]]
    [
      set overall-importance-list (list ([overall-importance] of Dimension1 with [active = 1]) ([overall-importance] of Dimension2 with [active = 1]) ([overall-importance] of Dimension3 with [active = 1]))
      set overall-max-value max flatten-list overall-importance-list
      if position overall-max-value flatten-list overall-importance-list = 0 [
        set dimension-dominant-next-child 1]
      if position overall-max-value flatten-list overall-importance-list = 1 [
        set dimension-dominant-next-child 2]
      if position overall-max-value flatten-list overall-importance-list = 2 [
        set dimension-dominant-next-child 3]]]
  [ set dimension-dominant-next-child dimension-dominant]
end

to set-social-identification [
            number-of-ticks
            dimension-dominant
            intersectionality]
  if dimension-dominant = 1 [
    ask Dimension1 with [active = 1] [
      set num-times-used num-times-used + 1]]
  if dimension-dominant = 2 [
    ask Dimension2 with [active = 1] [
      set num-times-used num-times-used + 1]]
  if dimension-dominant = 3 [
    ask Dimension3 with [active = 1] [
      set num-times-used num-times-used + 1]]
  ask turtles with [active = 1] [set social-identification round((num-times-used / (number-of-ticks + 1)) * 100) ] ; social identification is the % of the total ticks that this has been used
  if intersectionality = 1 [
    if dimension-dominant = 12 [
      ask activelink-intersection12 [set link-num-times-used link-num-times-used + 1]]
    if dimension-dominant = 23 [
      ask activelink-intersection23 [set link-num-times-used link-num-times-used + 1]]
    if dimension-dominant = 13 [
      ask activelink-intersection13 [set link-num-times-used link-num-times-used + 1]]
    ask links with [link-active = 1] [set link-social-identification round((link-num-times-used / (number-of-ticks + 1)) * 100) ]
  ]
end

to-report activelink-intersection12
  report links with [(link-active = 1) and (([breed] of end1 = Dimension1 and [breed] of end2 = Dimension2) or ([breed] of end1 = Dimension2 and [breed] of end2 = Dimension1))]
end

to-report activelink-intersection23
  report links with [(link-active = 1) and (([breed] of end1 = Dimension2 and [breed] of end2 = Dimension3) or ([breed] of end1 = Dimension3 and [breed] of end2 = Dimension2))]
end

to-report activelink-intersection13
  report links with [(link-active = 1) and (([breed] of end1 = Dimension1 and [breed] of end2 = Dimension3) or ([breed] of end1 = Dimension3 and [breed] of end2 = Dimension1))]
end

to-report flatten-list [ #lst ]
   ; flattens nested lists to a single list. Embellishes on "sentence" in that [[1 2] [3 4]] is
   ; flattened to [1 2 3 4] rather than being unaffected as sentence will do.
   ; if lst contains a list, flatten it and then call flatten-list again in case there were sublists.
   ; otherwise, just return lst.
   if (reduce [?1 or is-list? ?2] fput false #lst) [
     set #lst reduce [sentence ?1 ?2] #lst
     set #lst flatten-list #lst
   ]
   report #lst
 end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks
30.0

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 6.0-M6
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
