breed [saplings sapling]
breed [trees tree]
breed [elder_trees elder_tree]
breed [jacks jack]
breed [bears bear]

saplings-own [age]

trees-own [age lumber]

elder_trees-own [lumber]

globals [lumber_pieces maws!]

to setup
  ca
  create_trees ini_trees
  create_jacks ini_trees * 0.2
  create_bears ini_trees * 0.04

  set lumber_pieces 0
  set maws! 0
  import-drawing "grass3.png"
  reset-ticks
end

to go
  if (count trees + count elder_trees + count saplings) = 0 or ticks = 4800
  [
    stop
  ]

  if count jacks < 1
  [
    create_jacks 1
  ]

  activities_trees
  activities_animals

  tick

  if ticks mod 12 = 0
  [
    rh_jacks
    zoo
  ]

end

to activities_trees
  ask trees
  [
    spawn 1
    ages_tree
  ]

  ask elder_trees
  [
    spawn 2
  ]

  ask saplings
  [
    ages_sapling
  ]
end

to activities_animals
  ask jacks
  [
    move
    cut
  ]

  ask bears
  [
    move
    maw
  ]
end

to create_trees [number]
  create-trees number
  [
    move-to one-of patches with [not any? other turtles-here]
    setxy random-xcor random-ycor
    set color green
    set shape "tree_v2"
    set size 3
    set age 0
    set lumber 1
  ]
end

to create_jacks [number]
  create-jacks number
  [
    move-to one-of patches with [not any? other turtles-here]
    setxy random-pxcor random-pycor
    set color red + 3.5
    set shape "jack_v2"
    set size 3
  ]
end

to create_bears [number]
  create-bears number
  [
    move-to one-of patches with [not any? other turtles-here]
    setxy random-pxcor random-pycor
    set color brown - 1
    set shape "bear_v2"
    set size 3
  ]
end

to move
  rt random 50
  lt random 50
  fd 1
end

to spawn [number]
  let chance_to_spawn random 100
  if chance_to_spawn < number and count (neighbors with [not any? other turtles-here]) > 0
  [
    hatch-saplings 1
    [
      move-to one-of neighbors with [not any? other turtles-here]
      set color green
      set shape "sapling_v1"
      set size 4
      set age 0
    ]
  ]
end

to ages_tree
  set age age + 1
  if age = 120
  [
    hatch-elder_trees 1
    [
      set color green - 2
      set shape "tree_v2"
      set size 3
      set lumber 2
    ]
    die
  ]
end

to ages_sapling
  set age age + 1
  if age = 12
  [
    hatch-trees 1
    [
      set color green
      set shape "tree_v2"
      set size 3
      set age 0
      set lumber 1
    ]
    die
  ]
end

to cut

  let find one-of trees-here
  if find != nobody
  [
    ask find [ die ]
    set lumber_pieces lumber_pieces + 1

  ]

  set find one-of elder_trees-here
  if find != nobody
  [
    ask find [ die ]
    set lumber_pieces lumber_pieces + 2

  ]

end

to maw
  let find one-of jacks-here
  if find != nobody
  [
    ask find [ die ]
    set maws! maws! + 1
  ]
end

to rh_jacks
  ifelse lumber_pieces >= count jacks
  [
    let value int (lumber_pieces / count jacks)
    create_jacks value
  ]
  [
    ask one-of jacks [die]
  ]
  set lumber_pieces 0
end

to zoo
  ifelse maws! = 0
  [
    create_bears 1
  ]
  [
    ask one-of bears [die]
  ]
  set maws! 0
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
730
551
25
25
10.0
1
10
1
1
1
0
1
1
1
-25
25
-25
25
0
0
1
ticks
30.0

BUTTON
771
113
835
146
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
841
113
904
146
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
771
153
943
186
ini_trees
ini_trees
5
500
100
5
1
NIL
HORIZONTAL

PLOT
771
194
971
344
Agents
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Jacks" 1.0 0 -2674135 true "" "plot count jacks"
"Trees" 1.0 0 -14439633 true "" "plot count trees"
"Bears" 1.0 0 -7500403 true "" "plot count bears"
"Elder Trees" 1.0 0 -13210332 true "" "plot count elder_trees"
"Saplings" 1.0 0 -14454117 true "" "plot count saplings"

MONITOR
770
406
827
451
Jacks
count jacks
17
1
11

MONITOR
843
406
900
451
Bears
count bears
17
1
11

MONITOR
843
354
900
399
Trees
count trees
17
1
11

MONITOR
915
354
972
399
Elder
count elder_trees
17
1
11

MONITOR
770
354
827
399
Saplings
count saplings
17
1
11

MONITOR
770
459
827
504
Lumber
lumber_pieces
17
1
11

MONITOR
843
459
900
504
Maws!
maws!
17
1
11

@#$#@#$#@
## WHAT IS IT?

Forests are very complex eco-systems with lots of things happening. For this simulation was created a virtual forest and watch over simulated time the effects of a forest. We will see trees grow and be harvested. We will see the impact of industry upon the forest and watch as the wild life "fights" back.

For this simulated forest we will be dealing with 3 aspects:

    Trees which can be a Sapling, Tree or Elder Tree;
    Lumberjacks (He chops down down trees);
    Bears (He "maws" the lumberjacks).

## HOW IT WORKS

The simulation will simulate by months. Each "tick" represents a month. Every 12 "ticks" represents a year. Our forest will change and be in constant change.

###Forest:

The forest will be a two dimensional forest of size 50 x 50. At each location you can hold Trees, Bears or Lumberjacks. They can occupy the same spot but often events occur when they occupy the same spot.
The forest will be spawned randomly.

###Trees:

The initial number of trees is given by the slider "ini_trees" and other agents will be created based on this number.

Every month a Tree has a 1% chance to spawn a new "Sapling". In a random open space adjacent to a Tree you have a 1% chance to create a "Sapling". For example a Tree in the middle of the forest has 8 other spots around it. One of these if they do not have a type of Tree in it will create a "Sapling".

After 12 months of being in existence a "Sapling" will be upgrade to a "Tree". A "Sapling" cannot spawn other trees until it has matured into a "Tree".

Once a "Sapling" becomes a tree it can spawn other new "Saplings". At this point once a "Sapling" matures into a "Tree" it exists and matures. When a "Tree" has been around for 120 months (10 years) it will become an "Elder Tree".

Elder Trees have a 2% chance to spawn a new "Sapling" instead of 1%.

If there are no open adjacent spots to a Tree or Elder Tree it will not spawn any new Trees.

###Lumberjacks:

The Amounts of lumberjacks is given by 20% of the slider "ini_trees". They will move a randomly picked spot that is adjacent in any direction. So for example a Lumberjack in the middle of your grid has 8 spots to move to.

When the lumberjack moves if he encounters a Tree (not a sapling) he will then harvest the Tree for lumber. Remove the tree. Gain 1 piece of lumber.
Lumberjacks will not harvest "Sapling". They will harvest an Elder Tree. Elder Trees are worth 2 pieces of lumber.

Every 12 months the amount of lumber harvested is compared to the number of lumberjacks in the forest. If the lumber collected equals or exceeds the amount of lumberjacks in the forest a new lumberjack is hired and randomly spawned in the forest. Actually a math formula is used to determine if we hire 1 or many lumberjacks. We hire a number of new lumberjacks based on lumber gathered. Let us say you have 10 lumberjacks. If you harvest 10-19 pieces of lumber you would hire 1 lumberjack. But if you harvest 20-29 pieces of lumber you would hire 2 lumberjacks. If you harvest 30-39 you would gain 3 lumberjacks. And so forth.

However if after a 12 month span the amount of lumber collected is below the number of lumberjacks then 1 random lumberjack is removed from the forest.
However you will never reduce your Lumberjack labor force below 0.

###Bears:

They wander the forest much like a lumberjack and the amount of bears is given by 4% of the slider "ini_trees". If a bear comes across a Lumberjack he "maw" and hurt the lumberjack. The lumberjack will be removed from the forest.

We will track this as a "Maw" accident. During the course of 12 months if there 0 "Maw" accidents then the Bear population will increase by 1. If however there are any "Maw" accidents the Lumberjacks will hire a Zoo to trap and take a Bear away. Remove 1 random Bear. Note that if your Bear population reaches 0 bears then there will be no "Maw" accidents in the next year and so you will spawn 1 new Bear next year.

If there is only 1 lumberjack in the forest and he gets Maw'd. He will be sent home. But a new one will be hired immediately and respawned somewhere else in the forest. The lumberjack population will not drop below 1.

The simulation occurs for 4800 months (400 years). Or  until there 0 Trees left in the forest. So no Saplings, Trees or Elder Trees exist.

## HOW TO USE IT

The interface is very simple: A "Setup" to set the simulation and a "Go" button to start it.

There are some monitors that represetam the current value of the variable importates simulation and agents, which are also shown in the plot.

Finally, a slider for the variable "ini_tree" which governs the initial value of our agents.

## THINGS TO NOTICE

Besides the beautiful sprites specially developed for this simulation, it is interesting to note the graph variation that is the number of agents in the environment for different values of "ini_trees".

## THINGS TO TRY

The slider "ini_trees" can be changed to the observation of new behaviors.

Changes of some parameters in the code (chances for "spaw", for example) may also be of interest.

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bear_v1
false
0
Circle -7500403 true true 60 60 180
Circle -7500403 true true 60 45 60
Circle -7500403 true true 180 45 60
Circle -6459832 true false 105 150 90
Rectangle -16777216 true false 135 165 165 180
Line -16777216 false 180 210 165 210
Line -16777216 false 165 210 150 195
Line -16777216 false 135 210 150 195
Line -16777216 false 120 210 135 210
Line -16777216 false 150 195 150 165
Circle -16777216 true false 105 105 30
Circle -16777216 true false 165 105 30
Line -16777216 false 105 90 135 105
Line -16777216 false 105 90 135 105
Line -16777216 false 195 90 165 105
Line -16777216 false 195 90 165 105

bear_v2
false
0
Polygon -7500403 true true 150 255 45 165 90 60 120 60 180 60 210 60 255 165 150 255
Rectangle -6459832 true false 120 180 180 225
Circle -6459832 true false 120 150 58
Circle -7500403 true true 69 39 42
Circle -7500403 true true 189 39 42
Circle -6459832 true false 120 150 60
Circle -16777216 true false 105 105 30
Circle -16777216 true false 165 105 30
Rectangle -16777216 true false 135 165 165 180

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

jack_v1
false
0
Circle -955883 true false 92 57 118
Circle -955883 true false 89 131 122
Rectangle -7500403 true true 90 135 210 195
Rectangle -7500403 true true 136 202 167 212
Circle -7500403 true true 90 75 120
Circle -16777216 true false 163 147 18
Circle -16777216 true false 120 147 18
Rectangle -16777216 true false 154 132 189 140
Rectangle -16777216 true false 111 132 146 140
Circle -2674135 true false -105 7 59
Rectangle -955883 true false 114 74 188 114

jack_v2
false
0
Circle -16777216 false false 140 46 22
Circle -16777216 false false 84 59 134
Circle -2674135 true false 85 59 132
Rectangle -7500403 true true 90 120 210 195
Circle -955883 true false 90 135 120
Circle -7500403 true true 90 165 30
Rectangle -7500403 true true 90 107 210 182
Rectangle -7500403 true true 135 195 165 210
Circle -16777216 true false 161 130 20
Circle -16777216 true false 119 130 20
Rectangle -16777216 true false 159 120 189 124
Rectangle -16777216 true false 111 120 141 124
Rectangle -2674135 true false 89 103 212 114
Circle -2674135 true false 139 47 23
Circle -2674135 true false 86 101 20
Circle -2674135 true false 86 112 16
Circle -2674135 true false 85 122 10
Circle -2674135 true false 194 101 20
Circle -2674135 true false 200 112 16
Circle -2674135 true false 205 122 10
Circle -7500403 true true 180 165 30
Line -16777216 false 139 60 115 99
Line -16777216 false 150 61 150 99
Line -16777216 false 108 113 194 114
Line -16777216 false 193 114 210 135
Line -16777216 false 107 114 90 133
Line -16777216 false 210 135 210 153
Line -16777216 false 90 133 89 152
Line -16777216 false 160 60 151 61
Line -16777216 false 140 60 149 61
Line -16777216 false 90 123 96 105
Line -16777216 false 204 104 193 80
Line -16777216 false 192 79 182 67
Line -16777216 false 96 104 107 80
Line -16777216 false 108 79 118 67
Line -16777216 false 115 99 184 99
Line -16777216 false 115 99 92 120
Line -16777216 false 185 99 208 120
Line -16777216 false 208 119 216 136
Line -16777216 false 92 119 85 133
Line -16777216 false 161 60 185 99
Line -16777216 false 210 123 204 105

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -6459832 true false 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -6459832 true false 135 90 120 45 150 15 180 45 165 90

sapling_v1
false
0
Polygon -6459832 true false 150 120 135 270 165 270 150 120 150 135
Polygon -7500403 true true 125 181 140 241 142 212 125 181 140 226
Polygon -7500403 true true 131 122 146 182 148 153 131 122 146 167
Polygon -7500403 true true 173 154 158 214 156 185 173 154 158 199

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

tree_v2
false
0
Polygon -7500403 true true 150 15 60 225 240 225 150 15
Polygon -6459832 true false 150 120 135 270 165 270 150 120 150 135
Polygon -6459832 true false 150 210 105 180 150 195 150 210
Polygon -6459832 true false 150 165 180 135 150 195 150 165

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
