turtles-own [ genomeT energy error-rate generation match ]
patches-own [ genomeP food ]
globals [ temp fitness-valley ]


to setup ;;set up according to user defined variables in the interface
    ca
    create-turtles starting-population 
    ask turtles [
      set shape "line"
      set size 1.5
      set generation 1
      set energy 20 
      set error-rate original-error-rate
      setxy random-xcor random-ycor
      set genomeT (list (random-float 1) (random-float 1) (random-float 1) (random-float 1) (random-float 1)) ;;sets each turtle genome to be a list of 5, random, floating point numbers
    ]
    
    set temp (list (random 2) (random 2) (random 2) (random 2) (random 2))  ;;makes it so each patch will have the same genome
    
    ask patches [ 
      set food max-food
      set pcolor scale-color brown food 15 0 ;; color of patches indicates nutrients available
      set genomeP temp  ;;tell each patch to set genome 
    ]
    
    set fitness-valley (list (random-float 1) (random-float 1) (random-float 1) (random-float 1) (random-float 1)) ;;sets what genome values will punish turtles
    
end

to go
  if not any? turtles [ stop ] 
  update-plots
  ask turtles [
    move
    eat
    reproduce?
    die?
  ]
  ask patches [
    grow
  ]
  environment-change
  tick 
end



to die?
  if energy <= 0 [ ;; turtles die if they have 0 energy
    die ]
end

to eat
  set match 0
  (foreach genomeT genomeP [ set match ( match + abs(?1 - ?2))]) ;;each turtle compares its genome to the enivronment and calculates the difference
  set match ( 5 - match ) ;;the highest possible match would be 0, this simply inverts that number to calculate how much the turtle will eat
  (foreach genomeT fitness-valley [ ;;having calculated a match, turtles are then punished if their value of any gene is in a fitness valley
      if ?1 > (?2 - valley-breadth) [
        if ?1 < (?2 + valley-breadth) [
          set match ( match - abs(valley-depth - abs(?1 - ?2)))]]]) ;;subtract these punishing scores from the turtles match
  if match < 0 [ set match 0 ]      ;;no turtle can have match values greater than 5 or less than 0
  ifelse food >= (match) ;;turtles eat an amount of food directly related to their match, patches lose this amount
    [ set energy (energy + match) 
      set food (food - match)]
    [ set energy (energy + food) ;; if a patch does not contain enough energy, turtles will take as much as possible
      set food 0 ]
end

to environment-change
    if environmental-change? [ if random 1000 < frequency-of-changes [ ;;according to user parameters, the environmental genome will change stochastically
      ask patch 1 1 [ 
        repeat magnitude-of-changes [set temp (replace-item (random 5) genomeP (random 2))]]
      ask patches [
        set genomeP temp]]]
end

to grow
  ifelse food <= max-food - nutrient-regrowth ;;patches regrow food up to a defined maximum and recolor themselves accordingly
    [set food (food + nutrient-regrowth) ]
    [set food max-food]
  set pcolor scale-color brown food 15 0
end

to move
  lt random 45 ;; turtles move pseudo randomly with a bias in their current direction
  rt random 45
  fd 1
  set energy (energy - 2) ;; turtles lose energy at each time step 
end

to reproduce?
  if energy >= 100 [ 
    set energy 20 ;;reproduction costs a turtle 80 energy points
    hatch 1 ;;only one offspring at a time
    set generation (generation + 1) ;;offspring inherit parents generation plus 1
    set heading random 360 ;; offspring leave their parents 
    set error-rate (error-rate * (random-normal 1 error-rate)) ;; error rate is passed according to a random-normal distribution
    if error-rate >= 1 [set error-rate 1] ;;error rates have a maximum of 1 and a minimum of 0.1
    if error-rate <= 0.1 [ set error-rate 0.1]
    set genomeT (map [? * random-normal 1 error-rate] genomeT) ;; genome is passed according to a random-normal distribution
    set genomeT (map [min (list 1 ? )] genomeT) ;; genes have a max value of 1 and a minimum value of 0
    set genomeT (map [max (list 0 ? )] genomeT)    
    fd 1 ] 
end

to update-plots
  set-current-plot "Population"
  plot count turtles 
  
  set-current-plot "Generation"
  set-current-plot-pen "Max"
  plot max [Generation] of turtles
  set-current-plot-pen "Min"
  plot min [Generation] of turtles
  set-current-plot-pen "Average"
  plot mean [Generation] of turtles
  
  set-current-plot "Error-Rate"
  set-current-plot-pen "Max"
  plot max [error-rate] of turtles
  set-current-plot-pen "Min"
  plot min [error-rate] of turtles
  set-current-plot-pen "Average"
  plot mean [error-rate] of turtles
  
  set-current-plot "Match"
  set-current-plot-pen "Max"
  plot max [ match / 5 * 100 ] of turtles
  set-current-plot-pen "Min"
  plot min [ match / 5 * 100] of turtles
  set-current-plot-pen "Average"
  plot mean [ match / 5 * 100 ] of turtles

end


@#$#@#$#@
GRAPHICS-WINDOW
613
10
1036
454
30
30
6.7705
1
10
1
1
1
0
1
1
1
-30
30
-30
30
0
0
1
ticks

BUTTON
6
10
72
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
187
10
250
43
NIL
go\\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
5
85
177
118
nutrient-regrowth
nutrient-regrowth
0
3
1
0.5
1
NIL
HORIZONTAL

SLIDER
4
164
178
197
original-error-rate
original-error-rate
0
1
0.1
0.05
1
NIL
HORIZONTAL

BUTTON
256
10
337
43
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
5
265
205
415
Population
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

SLIDER
5
46
180
79
starting-population
starting-population
0
100
100
1
1
NIL
HORIZONTAL

PLOT
4
422
204
572
Error-Rate
NIL
NIL
0.0
10.0
0.0
1.0
true
true
PENS
"Max" 1.0 0 -2674135 true
"Min" 1.0 0 -11221820 true
"Average" 1.0 0 -16777216 true

PLOT
215
265
415
415
Generation
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"Max" 1.0 0 -2674135 true
"Min" 1.0 0 -11221820 true
"Average" 1.0 0 -16777216 true

PLOT
213
423
413
573
Match
NIL
NIL
0.0
10.0
0.0
1.0
true
true
PENS
"Max" 1.0 0 -2674135 true
"Min" 1.0 0 -11221820 true
"Average" 1.0 0 -16777216 true

SWITCH
185
46
426
79
environmental-change?
environmental-change?
0
1
-1000

SLIDER
6
125
178
158
max-food
max-food
0
10
10
1
1
NIL
HORIZONTAL

SLIDER
185
86
417
119
frequency-of-changes
frequency-of-changes
0
20
10
1
1
NIL
HORIZONTAL

SLIDER
183
126
380
159
magnitude-of-changes
magnitude-of-changes
0
5
2
1
1
NIL
HORIZONTAL

SLIDER
6
200
178
233
valley-depth
valley-depth
0
1
1
0.05
1
NIL
HORIZONTAL

SLIDER
184
200
356
233
valley-breadth
valley-breadth
0
0.2
0.2
0.05
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This model represents a 'petri-dish' type of experiment to investigate bacterial evolution and the generation of variation within a population. 


HOW IT WORKS
------------
Each bacterial organism eats, moves, reproduces and dies. Bacteria eat an amount from the environment that is determined by the degree of match between their 'genome' and the 'genome' of the environment. Upon reaching a certain level of energy, bacteria reproduce and give their offspring their traits with a certain error level that is specific to each bacteria and is also passed on with error. At each time step they also lose energy and if their rate of energy intake from the environment isnot sufficient such that an organisms energy drops to zero, they will die.

The environment regrows nutrients according to parameters and has a ceiling on how many nutrients that it can hold. According to a switch, the genome of the environment can change randomly and the frequency and magnitude of these changes are controllable by a slider. In addition, the fitness landscape can be made rugged by toggling the sliders representing the breadth and depth of fitness valleys which randomly set values for each gene that decrease nutrient uptake from the environment.   


HOW TO USE IT
-------------
Initialize the environment with a defined maximum food and nutrient regrowth rate. The combination of these two will influence the carrying capacity of the environment. Initialize with a defined error-rate, valley depth, and valley breadth. If environmental change is True, initialize the frequency and magnitude of environmental changes as these will drastically effect population dynamics.  


THINGS TO NOTICE
----------------
With environmental change present in the system, how do the population dynamics change compared to when there is no environmental change? What about the match of individuals to the environment and the average error-rate? What happens when the maximum match drops below 40%? Why is this?


THINGS TO TRY
-------------
Investigate different frequencies and magnitudes of environmental change, is there an optimum combination that produces high error-rates? Are there environmental changes that are too difficult for the population handle? Why might this be the case?

What if you introduce environmental changes mid-way through the model running, what happens to the population?


EXTENDING THE MODEL
-------------------
The current map between genome to environment is unrealistic since we know that genes are transcribed and translated into functional protein products which do the bulk of intracellular work. Inserting a parameter that does this with an error-rate endogenous to each bacteria could produce different results that may be more realistic. 


CREDITS AND REFERENCES
----------------------
This project was created and implemented by Adam Hockenberry for use in EECS 372/472, Spring 2011, at Northwestern University.
Last modified: 06/04/2011
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="fitness_landscape" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="10000"/>
    <exitCondition>not any? turtles</exitCondition>
    <metric>count turtles</metric>
    <metric>mean [ error-rate ] of turtles</metric>
    <metric>mean [ match ] of turtles</metric>
    <metric>max [generation] of turtles</metric>
    <metric>mean [generation] of turtles</metric>
    <metric>min [generation] of turtles</metric>
    <enumeratedValueSet variable="max-food">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="magnitude-of-changes">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="original-error-rate">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="valley-depth">
      <value value="0.5"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="frequency-of-changes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="starting-population">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="nutrient-regrowth">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="environmental-change?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="valley-breadth">
      <value value="0.1"/>
      <value value="0.2"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="envt-changes" repetitions="5" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="10000"/>
    <exitCondition>not any? turtles</exitCondition>
    <metric>count turtles</metric>
    <metric>mean [ error-rate ] of turtles</metric>
    <metric>mean [ match ] of turtles</metric>
    <metric>max [generation] of turtles</metric>
    <metric>mean [generation] of turtles</metric>
    <metric>min [generation] of turtles</metric>
    <enumeratedValueSet variable="valley-depth">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="valley-breadth">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="original-error-rate">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="environmental-change?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="magnitude-of-changes">
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="frequency-of-changes">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-food">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="starting-population">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="nutrient-regrowth">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
