extensions [ sound ]
turtles-own [note-value]
globals [chord-list]
breed [suggestions suggestion]
;-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;setup

to setup
  ca
  reset-ticks
;  create-keys
  white-keys
  black-keys
  ask turtles
    [if who >= 0 and who <= 36
      [hatch-suggestions 1
        [set ycor ycor + .9
         set shape "suggestion"
         set size 1.18
         set color red - 3.5]]]
  ask patches
  [set pcolor brown - 4
   if pycor > 0 and pycor < 5
     [set pcolor brown - 3.5]]
  ;  crt 1  ; create power button (unnecessary)
;    [set shape "dot"
;     set color red - 2
;     set label "Power"
;     setxy .5 6
;    ]
;  grid
end

;to grid ; used in process of creating interface
;  crt 1
;    [set heading 0
;     setxy .5 .5
;     set color 2
;     pd
;     repeat world-width
;       [fd world-height
;         set xcor xcor + 1]
;     rt 90
;     repeat world-height
;       [fd world-width
;         set ycor ycor + 1]
;     die]
;end

to white-keys
  crt 22
   [set shape "natural"
    set color 8
    setxy who 1.5
    set size 2
    if remainder (who + 1) 7 = 1 [set note-value "c"]
    if remainder (who + 1) 7 = 2 [set note-value "d"]
    if remainder (who + 1) 7 = 3 [set note-value "e"]
    if remainder (who + 1) 7 = 4 [set note-value "f"]
    if remainder (who + 1) 7 = 5 [set note-value "g"]
    if remainder (who + 1) 7 = 6 [set note-value "a"]
    if remainder (who + 1) 7 = 0 [set note-value "b"]]
end
to black-key-pattern [starting-x]
  crt 1
   [set shape "sharp"
    set size 2
    set color 3
    setxy starting-x 3.5
    set note-value "c#"]
  set starting-x starting-x + 1
  crt 1
   [set shape "sharp"
    set size 2
    set color 3
    setxy starting-x 3.5
    set note-value "d#"]
  set starting-x starting-x + 2
  crt 1
   [set shape "sharp"
    set size 2
    set color 3
    setxy starting-x 3.5
    set note-value "f#"]
  set starting-x starting-x + 1
  crt 1
   [set shape "sharp"
    set size 2
    set color 3
    setxy starting-x 3.5
    set note-value "g#"]
  set starting-x starting-x + 1
    crt 1
   [set shape "sharp"
    set size 2
    set color 3
    setxy starting-x 3.5
    set note-value "a#"]
  set starting-x starting-x + 2
end
to black-keys
  black-key-pattern .5
  black-key-pattern 7.5
  black-key-pattern 14.5
end

;------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;notes

to c2 [duration]
  sound:play-note "Acoustic Grand Piano" 48 64 duration
end
to c#2 [duration]
  sound:play-note "Acoustic Grand Piano" 49 64 duration
end
to d2 [duration]
  sound:play-note "Acoustic Grand Piano" 50 64 duration
end
to d#2 [duration]
  sound:play-note "Acoustic Grand Piano" 51 64 duration
end
to e2 [duration]
  sound:play-note "Acoustic Grand Piano" 52 64 duration
end
to f2 [duration]
  sound:play-note "Acoustic Grand Piano" 53 64 duration
end
to f#2 [duration]
  sound:play-note "Acoustic Grand Piano" 54 64 duration
end
to g2 [duration]
  sound:play-note "Acoustic Grand Piano" 55 64 duration
end
to g#2 [duration]
  sound:play-note "Acoustic Grand Piano" 56 64 duration
end
to a3 [duration]
  sound:play-note "Acoustic Grand Piano" 57 64 duration
end
to a#3 [duration]
  sound:play-note "Acoustic Grand Piano" 58 64 duration
end
to b3 [duration]
  sound:play-note "Acoustic Grand Piano" 59 64 duration
end
to c3 [duration]
  sound:play-note "Acoustic Grand Piano" 60 64 duration
end
to c#3 [duration]
  sound:play-note "Acoustic Grand Piano" 61 64 duration
end
to d3 [duration]
  sound:play-note "Acoustic Grand Piano" 62 64 duration
end
to d#3 [duration]
  sound:play-note "Acoustic Grand Piano" 63 64 duration
end
to e3 [duration]
  sound:play-note "Acoustic Grand Piano" 64 64 duration
end
to f3 [duration]
  sound:play-note "Acoustic Grand Piano" 65 64 duration
end
to f#3 [duration]
  sound:play-note "Acoustic Grand Piano" 66 64 duration
end
to g3 [duration]
  sound:play-note "Acoustic Grand Piano" 67 64 duration
end
to g#3 [duration]
  sound:play-note "Acoustic Grand Piano" 68 64 duration
end
to a4 [duration]
  sound:play-note "Acoustic Grand Piano" 69 64 duration
end
to a#4 [duration]
  sound:play-note "Acoustic Grand Piano" 70 64 duration
end
to b4 [duration]
  sound:play-note "Acoustic Grand Piano" 71 64 duration
end
to c4 [duration]
  sound:play-note "Acoustic Grand Piano" 72 64 duration
end
to c#4 [duration]
  sound:play-note "Acoustic Grand Piano" 73 64 duration
end
to d4 [duration]
  sound:play-note "Acoustic Grand Piano" 74 64 duration
end
to d#4 [duration]
  sound:play-note "Acoustic Grand Piano" 75 64 duration
end
to e4 [duration]
  sound:play-note "Acoustic Grand Piano" 76 64 duration
end
to f4 [duration]
  sound:play-note "Acoustic Grand Piano" 77 64 duration
end
to f#4 [duration]
  sound:play-note "Acoustic Grand Piano" 78 64 duration
end
to g4 [duration]
  sound:play-note "Acoustic Grand Piano" 79 64 duration
end
to g#4 [duration]
  sound:play-note "Acoustic Grand Piano" 80 64 duration
end
to a5 [duration]
  sound:play-note "Acoustic Grand Piano" 81 64 duration
end
to a#5 [duration]
  sound:play-note "Acoustic Grand Piano" 82 64 duration
end
to b5 [duration]
  sound:play-note "Acoustic Grand Piano" 83 64 duration
end
to c5 [duration]
  sound:play-note "Acoustic Grand Piano" 84 64 duration
end

;---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;playing notes

to playkeyboard ; user controlled playing
  if mouse-down?
  [every .15
;white keys
    [if patch mouse-xcor mouse-ycor = [patch-here] of turtle 0 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 0
      [c2 note-length
        ask turtle 0 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 1 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 1
      [d2 note-length
      ask turtle 1 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 2 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 2
      [e2 note-length
      ask turtle 2 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 3 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 3
      [f2 note-length
      ask turtle 3 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 4 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 4
      [g2 note-length
      ask turtle 4 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 5 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 5
      [a3 note-length
      ask turtle 5 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 6 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 6
      [b3 note-length
      ask turtle 6 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 7 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 7
      [c3 note-length
      ask turtle 7 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 8 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 8
      [d3 note-length
      ask turtle 8 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 9 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 9
      [e3 note-length
      ask turtle 9 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 10 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 10
      [f3 note-length
      ask turtle 10 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 11 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 11
      [g3 note-length
      ask turtle 11 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 12 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 12
      [a4 note-length
      ask turtle 12 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 13 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 13
      [b4 note-length
      ask turtle 13 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 14 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 14
      [c4 note-length
      ask turtle 14 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 15 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 15
      [d4 note-length
      ask turtle 15 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 16 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 16
      [e4 note-length
      ask turtle 16 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 17 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 17
      [f4 note-length
      ask turtle 17 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 18 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 18
      [g4 note-length
      ask turtle 18 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 19 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 19
      [a5 note-length
      ask turtle 19 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 20 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 20
      [b5 note-length
      ask turtle 20 [set color 4]]
    if patch mouse-xcor mouse-ycor = [patch-here] of turtle 21 or patch mouse-xcor (mouse-ycor + 1) = [patch-here] of turtle 21
      [c5 note-length
      ask turtle 21 [set color 4]]
;black keys
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 22 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 22
      [c#2 note-length
      ask turtle 22 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 23 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 23
      [d#2 note-length
      ask turtle 23 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 24 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 24
      [f#2 note-length
      ask turtle 24 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 25 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 25
      [g#2 note-length
      ask turtle 25 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 26 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 26
      [a#3 note-length
      ask turtle 26 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 27 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 27
      [c#3 note-length
      ask turtle 27 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 28 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 28
      [d#3 note-length
      ask turtle 28 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 29 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 29
      [f#3 note-length
      ask turtle 29 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 30 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 30
      [g#3 note-length
      ask turtle 30 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 31 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 31
      [a#4 note-length
      ask turtle 31 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 32 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 32
      [c#4 note-length
      ask turtle 32 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 33 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 33
      [d#4 note-length
      ask turtle 33 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 34 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 34
      [f#4 note-length
      ask turtle 34 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 35 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 35
      [g#4 note-length
      ask turtle 35 [set color 1]]
    if patch (mouse-xcor + .5) mouse-ycor = [patch-here] of turtle 36 or patch (mouse-xcor + .5) (mouse-ycor + 1) = [patch-here] of turtle 36
      [a#5 note-length
      ask turtle 36 [set color 1]]
    ]]
  every .15
    [ask turtles [if who <= 21 and who >= 0 [set color 8]]
      ask turtles [if who <= 36 and who >= 22 [set color 3]]]
end
;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;speed/time keeping

to-report pause ; the space between notes
  report 60 / bpm ;bpm = beats per minute
end

to metronome
  sound:play-drum "Hi wood block" 80
end

;---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;chords
;major chords
to C-major
  c2 chord-duration e2 chord-duration g2 chord-duration c3 chord-duration
  ask suggestions with [note-value = "c"] [set color red]
  ask suggestions with [note-value = "e"] [set color red]
  ask suggestions with [note-value = "g"] [set color red]
end
to C#-major
  c#2 chord-duration f2 chord-duration g#2 chord-duration c#3 chord-duration
  ask suggestions with [note-value = "c#"] [set color red]
  ask suggestions with [note-value = "e#"] [set color red]
  ask suggestions with [note-value = "g#"] [set color red]
end
to D-major
  d2 chord-duration f#2 chord-duration a3 chord-duration d3 chord-duration
  ask suggestions with [note-value = "d"] [set color red]
  ask suggestions with [note-value = "f#"] [set color red]
  ask suggestions with [note-value = "a"] [set color red]
end
to Eb-major
  d#2 chord-duration g2 chord-duration a#3 chord-duration d#3 chord-duration
  ask suggestions with [note-value = "d#"] [set color red]
  ask suggestions with [note-value = "g"] [set color red]
  ask suggestions with [note-value = "a#"] [set color red]
end
to E-major
  e2 chord-duration g#2 chord-duration b3 chord-duration e3 chord-duration
  ask suggestions with [note-value = "e"] [set color red]
  ask suggestions with [note-value = "g#"] [set color red]
  ask suggestions with [note-value = "b"] [set color red]
end
to F-major
  c2 chord-duration f2 chord-duration a3 chord-duration c3 chord-duration
  ask suggestions with [note-value = "c"] [set color red]
  ask suggestions with [note-value = "f"] [set color red]
  ask suggestions with [note-value = "a"] [set color red]
end
to F#-major
  c#2 chord-duration f#2 chord-duration a#3 chord-duration c#3 chord-duration
  ask suggestions with [note-value = "c#"] [set color red]
  ask suggestions with [note-value = "f#"] [set color red]
  ask suggestions with [note-value = "a#"] [set color red]
end
to G-major
  d2 chord-duration g2 chord-duration b3 chord-duration
  ask suggestions with [note-value = "d"] [set color red]
  ask suggestions with [note-value = "g"] [set color red]
  ask suggestions with [note-value = "b"] [set color red]
end
to Ab-major
  c2 chord-duration g#2 chord-duration d#2 chord-duration c3 chord-duration
  ask suggestions with [note-value = "c"] [set color red]
  ask suggestions with [note-value = "g#"] [set color red]
  ask suggestions with [note-value = "d#"] [set color red]
end
to A-major
  c#2 chord-duration e2 chord-duration a3 chord-duration
  ask suggestions with [note-value = "c#"] [set color red]
  ask suggestions with [note-value = "e"] [set color red]
  ask suggestions with [note-value = "a"] [set color red]
end
to Bb-major
  d2 chord-duration f2 chord-duration a#3 chord-duration
  ask suggestions with [note-value = "d"] [set color red]
  ask suggestions with [note-value = "f"] [set color red]
  ask suggestions with [note-value = "a#"] [set color red]
end
to B-major
  d#2 chord-duration f#2 chord-duration b3 chord-duration
  ask suggestions with [note-value = "d#"] [set color red]
  ask suggestions with [note-value = "f#"] [set color red]
  ask suggestions with [note-value = "b"] [set color red]
end
;minor chords
to C-minor
  c2 chord-duration d#2 chord-duration g2 chord-duration c3 chord-duration
  ask suggestions with [note-value = "c"] [set color red]
  ask suggestions with [note-value = "d#"] [set color red]
  ask suggestions with [note-value = "g"] [set color red]
end
to C#-minor
  c#2 chord-duration e2 chord-duration g#2 chord-duration c#3 chord-duration
  ask suggestions with [note-value = "c#"] [set color red]
  ask suggestions with [note-value = "e"] [set color red]
  ask suggestions with [note-value = "g#"] [set color red]
end
to D-minor
  d2 chord-duration f2 chord-duration a3 chord-duration d3 chord-duration
  ask suggestions with [note-value = "d"] [set color red]
  ask suggestions with [note-value = "f"] [set color red]
  ask suggestions with [note-value = "a"] [set color red]
end
to Eb-minor
  d#2 chord-duration f#2 chord-duration a#3 chord-duration d#3 chord-duration
  ask suggestions with [note-value = "d#"] [set color red]
  ask suggestions with [note-value = "f#"] [set color red]
  ask suggestions with [note-value = "a#"] [set color red]
end
to E-minor
  e2 chord-duration g2 chord-duration b3 chord-duration e3 chord-duration
  ask suggestions with [note-value = "e"] [set color red]
  ask suggestions with [note-value = "g"] [set color red]
  ask suggestions with [note-value = "b"] [set color red]
end
to F-minor
  c2 chord-duration f2 chord-duration g#3 chord-duration c3 chord-duration
  ask suggestions with [note-value = "c"] [set color red]
  ask suggestions with [note-value = "f"] [set color red]
  ask suggestions with [note-value = "g#"] [set color red]
end
to F#-minor
  c#2 chord-duration f#2 chord-duration a3 chord-duration c#3 chord-duration
  ask suggestions with [note-value = "c#"] [set color red]
  ask suggestions with [note-value = "f#"] [set color red]
  ask suggestions with [note-value = "a"] [set color red]
end
to G-minor
  d2 chord-duration g2 chord-duration a#3 chord-duration g3 chord-duration
  ask suggestions with [note-value = "d"] [set color red]
  ask suggestions with [note-value = "g"] [set color red]
  ask suggestions with [note-value = "a#"] [set color red]
end
to Ab-minor
   g#2 chord-duration d#2 chord-duration b3 chord-duration
  ask suggestions with [note-value = "g#"] [set color red]
  ask suggestions with [note-value = "d#"] [set color red]
  ask suggestions with [note-value = "b"] [set color red]
end
to A-minor
  c2 chord-duration e2 chord-duration a3 chord-duration
  ask suggestions with [note-value = "c"] [set color red]
  ask suggestions with [note-value = "e"] [set color red]
  ask suggestions with [note-value = "a"] [set color red]
end
to Bb-minor
  c#2 chord-duration f2 chord-duration a#3 chord-duration
  ask suggestions with [note-value = "c#"] [set color red]
  ask suggestions with [note-value = "f"] [set color red]
  ask suggestions with [note-value = "a#"] [set color red]
end
to B-minor
  d2 chord-duration f#2 chord-duration b3 chord-duration
  ask suggestions with [note-value = "d"] [set color red]
  ask suggestions with [note-value = "f#"] [set color red]
  ask suggestions with [note-value = "b"] [set color red]
end

;------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;function

to play-chords
  every pause
    [tick
      if play-metronome [metronome]]
  if chord-pattern = "2 chords pattern" [play-2-chord-pattern-a]
  if chord-pattern = "3 chords pattern" [play-3-chord-pattern-a]
  if chord-pattern = "4 chords pattern" [play-4-chord-pattern-a]
end

to play-2-chord-pattern-a
  every pause
  [
  if remainder ticks 8 = 1
    [ask suggestions [set color red - 3.5]
    if first-chord = "C" [c-major]
    if first-chord = "C#" [c#-major]
    if first-chord = "D" [d-major]
    if first-chord = "Eb" [Eb-major]
    if first-chord = "E" [E-major]
    if first-chord = "F" [F-major]
    if first-chord = "F#" [f#-major]
    if first-chord = "G" [g-major]
    if first-chord = "Ab" [ab-major]
    if first-chord = "A" [a-major]
    if first-chord = "Bb" [bb-major]
    if first-chord = "B" [b-major]
    if first-chord = "Cm" [c-minor]
    if first-chord = "C#m" [c#-minor]
    if first-chord = "Dm" [d-minor]
    if first-chord = "Ebm" [eb-minor]
    if first-chord = "Em" [e-minor]
    if first-chord = "Fm" [f-minor]
    if first-chord = "F#m" [f#-minor]
    if first-chord = "Gm" [g-minor]
    if first-chord = "Abm" [ab-minor]
    if first-chord = "Am" [a-minor]
    if first-chord = "Bbm" [Bb-minor]
    if first-chord = "Bm" [B-minor]
   ]
  if remainder ticks 8 = 5
   [ask suggestions [set color red - 3.5]
    if second-chord = "C" [c-major]
    if second-chord = "C#" [c#-major]
    if second-chord = "D" [d-major]
    if second-chord = "Eb" [Eb-major]
    if second-chord = "E" [E-major]
    if second-chord = "F" [F-major]
    if second-chord = "F#" [f#-major]
    if second-chord = "G" [g-major]
    if second-chord = "Ab" [ab-major]
    if second-chord = "A" [a-major]
    if second-chord = "Bb" [bb-major]
    if second-chord = "B" [b-major]
    if second-chord = "Cm" [c-minor]
    if second-chord = "C#m" [c#-minor]
    if second-chord = "Dm" [d-minor]
    if second-chord = "Ebm" [eb-minor]
    if second-chord = "Em" [e-minor]
    if second-chord = "Fm" [f-minor]
    if second-chord = "F#m" [f#-minor]
    if second-chord = "Gm" [g-minor]
    if second-chord = "Abm" [ab-minor]
    if second-chord = "Am" [a-minor]
    if second-chord = "Bbm" [Bb-minor]
    if second-chord = "Bm" [B-minor]
   ]
  ]
end

to play-3-chord-pattern-a
  every pause
  [
  if remainder ticks 12 = 1
   [ask suggestions [set color red - 3.5]
    if first-chord = "C" [c-major]
    if first-chord = "C#" [c#-major]
    if first-chord = "D" [d-major]
    if first-chord = "Eb" [Eb-major]
    if first-chord = "E" [E-major]
    if first-chord = "F" [F-major]
    if first-chord = "F#" [f#-major]
    if first-chord = "G" [g-major]
    if first-chord = "Ab" [ab-major]
    if first-chord = "A" [a-major]
    if first-chord = "Bb" [bb-major]
    if first-chord = "B" [b-major]
    if first-chord = "Cm" [c-minor]
    if first-chord = "C#m" [c#-minor]
    if first-chord = "Dm" [d-minor]
    if first-chord = "Ebm" [eb-minor]
    if first-chord = "Em" [e-minor]
    if first-chord = "Fm" [f-minor]
    if first-chord = "F#m" [f#-minor]
    if first-chord = "Gm" [g-minor]
    if first-chord = "Abm" [ab-minor]
    if first-chord = "Am" [a-minor]
    if first-chord = "Bbm" [Bb-minor]
    if first-chord = "Bm" [B-minor]
   ]
  if remainder ticks 12 = 5
   [ask suggestions [set color red - 3.5]
    if second-chord = "C" [c-major]
    if second-chord = "C#" [c#-major]
    if second-chord = "D" [d-major]
    if second-chord = "Eb" [Eb-major]
    if second-chord = "E" [E-major]
    if second-chord = "F" [F-major]
    if second-chord = "F#" [f#-major]
    if second-chord = "G" [g-major]
    if second-chord = "Ab" [ab-major]
    if second-chord = "A" [a-major]
    if second-chord = "Bb" [bb-major]
    if second-chord = "B" [b-major]
    if second-chord = "Cm" [c-minor]
    if second-chord = "C#m" [c#-minor]
    if second-chord = "Dm" [d-minor]
    if second-chord = "Ebm" [eb-minor]
    if second-chord = "Em" [e-minor]
    if second-chord = "Fm" [f-minor]
    if second-chord = "F#m" [f#-minor]
    if second-chord = "Gm" [g-minor]
    if second-chord = "Abm" [ab-minor]
    if second-chord = "Am" [a-minor]
    if second-chord = "Bbm" [Bb-minor]
    if second-chord = "Bm" [B-minor]
   ]
  if remainder ticks 12 = 9
   [ask suggestions [set color red - 3.5]
    if third-chord = "C" [c-major]
    if third-chord = "C#" [c#-major]
    if third-chord = "D" [d-major]
    if third-chord = "Eb" [Eb-major]
    if third-chord = "E" [E-major]
    if third-chord = "F" [F-major]
    if third-chord = "F#" [f#-major]
    if third-chord = "G" [g-major]
    if third-chord = "Ab" [ab-major]
    if third-chord = "A" [a-major]
    if third-chord = "Bb" [bb-major]
    if third-chord = "B" [b-major]
    if third-chord = "Cm" [c-minor]
    if third-chord = "C#m" [c#-minor]
    if third-chord = "Dm" [d-minor]
    if third-chord = "Ebm" [eb-minor]
    if third-chord = "Em" [e-minor]
    if third-chord = "Fm" [f-minor]
    if third-chord = "F#m" [f#-minor]
    if third-chord = "Gm" [g-minor]
    if third-chord = "Abm" [ab-minor]
    if third-chord = "Am" [a-minor]
    if third-chord = "Bbm" [Bb-minor]
    if third-chord = "Bm" [B-minor]
   ]
  ]
end

to play-4-chord-pattern-a
  every pause
  [
  if remainder ticks 16 = 1
   [ask suggestions [set color red - 3.5]
    if first-chord = "C" [c-major]
    if first-chord = "C#" [c#-major]
    if first-chord = "D" [d-major]
    if first-chord = "Eb" [Eb-major]
    if first-chord = "E" [E-major]
    if first-chord = "F" [F-major]
    if first-chord = "F#" [f#-major]
    if first-chord = "G" [g-major]
    if first-chord = "Ab" [ab-major]
    if first-chord = "A" [a-major]
    if first-chord = "Bb" [bb-major]
    if first-chord = "B" [b-major]
    if first-chord = "Cm" [c-minor]
    if first-chord = "C#m" [c#-minor]
    if first-chord = "Dm" [d-minor]
    if first-chord = "Ebm" [eb-minor]
    if first-chord = "Em" [e-minor]
    if first-chord = "Fm" [f-minor]
    if first-chord = "F#m" [f#-minor]
    if first-chord = "Gm" [g-minor]
    if first-chord = "Abm" [ab-minor]
    if first-chord = "Am" [a-minor]
    if first-chord = "Bbm" [Bb-minor]
    if first-chord = "Bm" [B-minor]
   ]
  if remainder ticks 16 = 5
   [ask suggestions [set color red - 3.5]
    if second-chord = "C" [c-major]
    if second-chord = "C#" [c#-major]
    if second-chord = "D" [d-major]
    if second-chord = "Eb" [Eb-major]
    if second-chord = "E" [E-major]
    if second-chord = "F" [F-major]
    if second-chord = "F#" [f#-major]
    if second-chord = "G" [g-major]
    if second-chord = "Ab" [ab-major]
    if second-chord = "A" [a-major]
    if second-chord = "Bb" [bb-major]
    if second-chord = "B" [b-major]
    if second-chord = "Cm" [c-minor]
    if second-chord = "C#m" [c#-minor]
    if second-chord = "Dm" [d-minor]
    if second-chord = "Ebm" [eb-minor]
    if second-chord = "Em" [e-minor]
    if second-chord = "Fm" [f-minor]
    if second-chord = "F#m" [f#-minor]
    if second-chord = "Gm" [g-minor]
    if second-chord = "Abm" [ab-minor]
    if second-chord = "Am" [a-minor]
    if second-chord = "Bbm" [Bb-minor]
    if second-chord = "Bm" [B-minor]
   ]
  if remainder ticks 16 = 9
   [ask suggestions [set color red - 3.5]
    if third-chord = "C" [c-major]
    if third-chord = "C#" [c#-major]
    if third-chord = "D" [d-major]
    if third-chord = "Eb" [Eb-major]
    if third-chord = "E" [E-major]
    if third-chord = "F" [F-major]
    if third-chord = "F#" [f#-major]
    if third-chord = "G" [g-major]
    if third-chord = "Ab" [ab-major]
    if third-chord = "A" [a-major]
    if third-chord = "Bb" [bb-major]
    if third-chord = "B" [b-major]
    if third-chord = "Cm" [c-minor]
    if third-chord = "C#m" [c#-minor]
    if third-chord = "Dm" [d-minor]
    if third-chord = "Ebm" [eb-minor]
    if third-chord = "Em" [e-minor]
    if third-chord = "Fm" [f-minor]
    if third-chord = "F#m" [f#-minor]
    if third-chord = "Gm" [g-minor]
    if third-chord = "Abm" [ab-minor]
    if third-chord = "Am" [a-minor]
    if third-chord = "Bbm" [Bb-minor]
    if third-chord = "Bm" [B-minor]
   ]
  if remainder ticks 16 = 13
   [ask suggestions [set color red - 3.5]
    if fourth-chord = "C" [c-major]
    if fourth-chord = "C#" [c#-major]
    if fourth-chord = "D" [d-major]
    if fourth-chord = "Eb" [Eb-major]
    if fourth-chord = "E" [E-major]
    if fourth-chord = "F" [F-major]
    if fourth-chord = "F#" [f#-major]
    if fourth-chord = "G" [g-major]
    if fourth-chord = "Ab" [ab-major]
    if fourth-chord = "A" [a-major]
    if fourth-chord = "Bb" [bb-major]
    if fourth-chord = "B" [b-major]
    if fourth-chord = "Cm" [c-minor]
    if fourth-chord = "C#m" [c#-minor]
    if fourth-chord = "Dm" [d-minor]
    if fourth-chord = "Ebm" [eb-minor]
    if fourth-chord = "Em" [e-minor]
    if fourth-chord = "Fm" [f-minor]
    if fourth-chord = "F#m" [f#-minor]
    if fourth-chord = "Gm" [g-minor]
    if fourth-chord = "Abm" [ab-minor]
    if fourth-chord = "Am" [a-minor]
    if fourth-chord = "Bbm" [Bb-minor]
    if fourth-chord = "Bm" [B-minor]
   ]

  ]
end

;to set-chords  ; used in initial chord idea using lists
;  set chord-list []
;  set chord-list lput first-chord chord-list
;  if second-chord != "no chord"
;    [set chord-list lput second-chord chord-list]
;  if third-chord != "no chord"
;    [set chord-list lput third-chord chord-list]
;  if fourth-chord != "no chord"
;    [set chord-list lput fourth-chord chord-list]
;end
@#$#@#$#@
GRAPHICS-WINDOW
304
16
1412
375
-1
-1
50.0
1
10
1
1
1
0
1
1
1
0
21
0
6
0
0
1
ticks
30.0

BUTTON
77
56
140
89
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
77
90
206
123
NIL
playkeyboard
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
77
125
206
158
note-length
note-length
.5
3
0.75
.25
1
NIL
HORIZONTAL

SLIDER
78
477
209
510
chord-duration
chord-duration
1
5
2.0
1
1
NIL
HORIZONTAL

CHOOSER
78
431
219
476
chord-pattern
chord-pattern
"2 chords pattern" "3 chords pattern" "4 chords pattern"
2

SLIDER
77
189
250
222
bpm
bpm
60
240
144.0
1
1
NIL
HORIZONTAL

SWITCH
77
223
250
256
play-metronome
play-metronome
1
1
-1000

BUTTON
254
488
350
521
NIL
play-chords
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
78
384
216
429
First-chord
First-chord
"C" "C#" "D" "Eb" "E" "F" "F#" "G" "Ab" "A" "Bb" "B" "Cm" "C#m" "Dm" "Ebm" "Em" "Fm" "F#m" "Gm" "Abm" "Am" "Bbm" "Bm"
0

CHOOSER
217
384
355
429
second-chord
second-chord
"no chord" "C" "C#" "D" "Eb" "E" "F" "F#" "G" "Ab" "A" "Bb" "B" "Cm" "C#m" "Dm" "Ebm" "Em" "Fm" "F#m" "Gm" "Abm" "Am" "Bbm" "Bm"
8

CHOOSER
356
384
494
429
Third-chord
Third-chord
"no chord" "C" "C#" "D" "Eb" "E" "F" "F#" "G" "Ab" "A" "Bb" "B" "Cm" "C#m" "Dm" "Ebm" "Em" "Fm" "F#m" "Gm" "Abm" "Am" "Bbm" "Bm"
22

CHOOSER
495
384
633
429
fourth-chord
fourth-chord
"no chord" "C" "C#" "D" "Eb" "E" "F" "F#" "G" "Ab" "A" "Bb" "B" "Cm" "C#m" "Dm" "Ebm" "Em" "Fm" "F#m" "Gm" "Abm" "Am" "Bbm" "Bm"
6

@#$#@#$#@
## WHAT IS IT?

A self-playing piano whihc will follow the chords decided by the user. The user can then play keys over the repeating pattern of chords

## HOW IT WORKS

First, different notes are defined as "sound:playnote x 64 duration" where x is the numeric value of the note (e.g. a C3 has the value 60), 64 is the velocity of the note (i.e. the velocity of the strike, or the volume) and duration is defined by the slider note-length and determines how long each played note lasts.

The user-controlled playing command playkeyboard associates each piano-key-shaped turtle on the screen. When the mouse is down and shares the x-coordinate and y-coordinate of a certain key, the corresponding note is played. a key press also changes the color of the turtle, creating the appearance of a pressed note.

Chords are defined as three or four note commands called at once, with the slider chord-length determining the duration  of the notes. Chord commands also change the color of the "suggestion" turtles, the red boxes outlining each note. The suggestions will highlight the notes that are used in the chord.

The pause between each tick, equal to a quarter note, is defined by the equation 60/BPM.
The metronome plays a ticking sound every quarter note.

The chord patterns are simple, but new, more complex ones can be written very easily, The patterns work by calling a chord every four quarter notes, and repeats until the user tells the command to stop. the user can choose which chords they want to use, if they want a space (no chord) in the pattern, and how many chords they wish to use in the pattern.

## HOW TO USE IT

Press Setup to create the keyboard

To play chords, choose the pattern you wish to use as well as the chords you want to play in the pattern. Select the BPM of the song you want to play. This can all be changed mid-song.

To begin playing chords, press play-chords.

To allow for user-controlled playing, select the note-length you desire and press playkeyboard. The keys are played by clicking over them in the Netlogo world.

When playing the keyboard, the piano will suggest keys for you to play by outlining the keys in the chord. These are merely suggestions for the player and can be ignored.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

natural
false
0
Rectangle -1 true false 105 30 195 285
Polygon -7500403 false true 90 135 90 120
Polygon -7500403 false true 0 90
Polygon -7500403 true true 105 30 90 15 90 300 105 285 105 15
Polygon -7500403 false true 105 15
Polygon -7500403 true true 90 15 210 15 195 30 105 30 90 15
Polygon -1 false false 90 15 105 30 195 30 210 15 90 15
Polygon -1 false false 105 30 90 15 90 300 105 285 105 30
Polygon -7500403 true true 210 15 210 300 195 285 195 30 210 15
Polygon -1 false false 210 30
Polygon -1 false false 210 15 195 30 195 285 210 300 210 15
Polygon -7500403 true true 90 300 105 285 195 285 210 300 90 300 105 285
Polygon -1 false false 90 300 105 285 195 285 210 300 90 300

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sharp
false
10
Rectangle -16777216 true false 105 30 195 285
Polygon -7500403 false false 90 135 90 120
Polygon -7500403 false false 0 90
Polygon -13345367 true true 105 30 90 15 90 300 105 285 105 15
Polygon -7500403 false false 105 15
Polygon -13345367 true true 90 15 210 15 195 30 105 30 90 15
Polygon -7500403 false false 90 15 105 30 195 30 210 15 90 15
Polygon -7500403 false false 105 30 90 15 90 300 105 285 105 30
Polygon -13345367 true true 210 15 210 300 195 285 195 30 210 15
Polygon -1 false false 210 30
Polygon -7500403 false false 210 15 195 30 195 285 210 300 210 15
Polygon -13345367 true true 90 300 105 285 195 285 210 300 90 300 105 285
Polygon -7500403 false false 90 300 105 285 195 285 210 300 90 300

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

suggestion
false
0
Polygon -7500403 true true 30 135 30 660 270 660 270 135 150 135

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
