extensions [gogo]

breed [carbons carbon]
breed [airs air]

to setup
  gogo:open "/dev/tty.usbmodemfa141"
  clear-all
  set-default-shape turtles "circle"
  draw-walls
  ask patch -5 0
  [sprout-airs 20 [set color one-of [15 16 17 25 26 27 35 36 37]]]                  ;; create some turtles
  ask patch 5 0
  [sprout-carbons 20 [set color  one-of [55 56 57 65 66 67 75 76 77]]]                   ;; create some turtles
  reset-ticks
end

; draws the boundaries (walls) of the "billiard table"
to draw-walls
  ; draw left and right walls
  ask patches with [abs pxcor = max-pxcor]
    [ set pcolor blue ]
  ; draw top and bottom walls
  ask patches with [abs pycor = max-pycor]
    [ set pcolor blue ]
  ask patches with [pxcor = 0]
    [ set pcolor blue]
end

to go
  ifelse (gogo:sensor 1 > 0) and (gogo:sensor 1 < 400)  ;;hot
  [ask airs [fd 1.0 bounce]]
     [ifelse (gogo:sensor 1 > 400) and (gogo:sensor 1 < 450)  ;;warm
     [ask airs [fd 0.8 
     bounce]]
        [ifelse (gogo:sensor 1 > 450) and (gogo:sensor 1 < 500)  ;;warm
        [ask airs [fd 0.6 
        bounce]]
           [ifelse (gogo:sensor 1 > 500) and (gogo:sensor 1 < 550)  ;;room temp
           [ask airs [fd 0.4 
           bounce]]
              [ifelse (gogo:sensor 1 > 550) and (gogo:sensor 1 < 600)  ;;room temp
              [ask airs [fd 0.2 
              bounce]]
                 [ask airs [fd 0.1 
                 bounce]]]]]]
  ifelse (gogo:sensor 2 > 0) and (gogo:sensor 2 < 400)  ;;hot
  [ask carbons [fd 1.0 bounce]]
     [ifelse (gogo:sensor 2 > 400) and (gogo:sensor 2 < 450)  ;;warm
     [ask carbons [fd 0.8 
     bounce]]
        [ifelse (gogo:sensor 2 > 450) and (gogo:sensor 2 < 500)  ;;warm
        [ask carbons [fd 0.6 
        bounce]]
           [ifelse (gogo:sensor 2 > 500) and (gogo:sensor 2 < 550)  ;;room temp
           [ask carbons [fd 0.4 
           bounce]]
              [ifelse (gogo:sensor 2 > 550) and (gogo:sensor 2 < 600)  ;;room temp
              [ask carbons [fd 0.2 
              bounce]]
                 [ask carbons [fd 0.1 
                 bounce]]]]]]
  tick
end

to heatmove 
  ;;ask carbons [fd gogo:sensor 1]
  ask carbons [fd 1]
  ;;ask airs [fd gogo:sensor 2]
end

;; this procedure checks the coordinates and makes the turtles
;; reflect according to the law that the angle of reflection is
;; equal to the angle of incidence
to bounce  ;; turtle procedure
  ; check: hitting left or right wall?
  ;if abs [pxcor] of patch-ahead 0.1 = max-pxcor
    ; if so, reflect heading around x axis
    ;[ set heading (- heading) ]
  ; check: hitting top or bottom wall?
  if abs [pycor] of patch-ahead 0.1 = max-pycor
    ; if so, reflect heading around y axis
    [ set heading (180 - heading) ]
  ; check: hitting middle? 
  ;if [pxcor] of patch-ahead 0.1 = 0
  if [pcolor] of patch-ahead 0.1 = blue
    [ set heading (- heading) ]
end


; Public Domain:
; To the extent possible under law, Uri Wilensky has waived all
; copyright and related or neighboring rights to this model.
@#$#@#$#@
GRAPHICS-WINDOW
349
10
788
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
15
24
107
83
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
2
178
170
243
Air Temperature
gogo:sensor 1
17
1
16

MONITOR
173
178
346
243
CO2 Temperature
gogo:sensor 2
17
1
16

PLOT
2
269
346
470
Temperature
Time
Temperature
0.0
100.0
0.0
1023.0
true
false
"" ""
PENS
"Air" 1.0 0 -13345367 true "" "plot (gogo:sensor 1)"
"CO2" 1.0 0 -2674135 true "" "plot (gogo:sensor 2)"

BUTTON
124
24
209
83
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
438
483
498
520
Air
30
15.0
1

TEXTBOX
561
482
793
525
Carbon Dioxide
30
65.0
1

@#$#@#$#@
## WHAT IS IT?

This model is designed to demonstrate the heat trapping capability of carbon dioxide as compared to standard air.  Greenhouse gases such as carbon dioxide can trap heat in the Earth's atmosphere more effectively than standard air (mostly nitrogen and oxygen).  This model demonstrates that phenomenon by applying equal heating to two different gas mixtures - air and carbon dioxide.  The carbon dioxide, when heated, will rise in temperature more rapidly than the air, and will retain its higher temperature more effectively than air.  This is shown in the plot to the left.

With higher temperature, gas molecules move more rapidly, due to the higher energy in the system.  The model window to the right shows the increase in energy of each flask's system through increased speed of molecule movement.  The molecules in the left box reflect the molecules in the air flask; the molecules in the right box reflect the molecules in the carbon dioxide flask.

This model was inspired in part by the GasLab series of models designed by Dr. Uri Wilensky.

## HOW IT WORKS

The model creates two breeds of turtles, airs and carbons, which populate two separate spaces in the model window.  Airs are seen in warm-colored shades; carbons are seen in cool-colored shades.  Each breed obeys rules determined by temperature feedback from a sensor.  As temperature rises, the breeds move around their windows at faster rates, modeling the way that molecules move faster when they are warmer.

## HOW TO USE IT

You will need:
- 2 Erlenmeyer flasks
- 2 stoppers with holes in them
- something to seal the stopper holes - gum, wax
- 1 heat lamp with stand
- 1 Gogo Board
- 2 Thermistors for Gogo Board
- Baking Soda
- Vinegar

To use the model, arrange two Erlenmeyer flasks with stoppers under a heat lamp (make sure that the lamp will be able to heat them equally).  Attach two thermistors to the Gogo Board's sensor inputs 1 and 2.  Insert the first (sensor 1) thermistor into the stopper of the leftmost Erlenmeyer flask and seal.  Insert the second (sensor 2) thermistor into the stopper of the rightmost Erlenmeyer flask. Do not seal yet.

To fill the rightmost Erlenmeyer flask with carbon dioxide, you will react baking soda and vinegar to create carbon dioxide.  The carbon dioxide will remain in your flask because it is denser than standard air.  Pour enough baking soda in your Erlenmeyer flask to cover the majority of its bottom surface.  Add enough vinegar to cover all baking soda thoroughly (about twice as much) and swirl around until reaction (evidenced by bubbling) is complete.  Seal this flask.

Start model by clicking the "setup" button, followed by the "go" button, and turn on the heat lamp.

## THINGS TO NOTICE

Once the heat lamp is turned on, note the relation of the temperatures in each bottle, plotted on the left.  Compare that to the speed of the molecules in each window.  Do you see a relationship?

## THINGS TO TRY

Turn the heat lamp on and observe the effects for several minutes.  Then, turn off the heat lamp.  What do you notice about the temperatures in the two bottles?  Are the dropping?  If so, are they dropping at the same rates?  What can you infer from this?

## EXTENDING THE MODEL

Different gases - the model can be expanded or altered by using different "atmospheres" in the Erlenmeyer flasks.  Try it with different percentages of carbon dioxide (use more and less baking soda), etc.

Collision - allowing the molecules to bounce off of each other as well as the walls would improve the model's accuracy.

Better readouts and plotting - the sensors could be calibrated to Fahrenheit or Celsius scales, and the plot function could be made to scale the data better.

## CREDITS AND REFERENCES

- Wilensky, U. (1997). NetLogo GasLab Gas in a Box model. http://ccl.northwestern.edu/netlogo/models/GasLabGasinaBox. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
- Wilensky, U. (1997). NetLogo GasLab Single Collision model. http://ccl.northwestern.edu/netlogo/models/GasLabSingleCollision. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
- Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC7
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
