breed [foragers forager]
breed [leaders leader]

patches-own
[ nest?
  nest-scent
  nest-x nest-y
  food-source-center-x
  food-source-center-y
  food
  chemical
]

to setup
  clear-all
  set-default-shape turtles "bug"
  create-foragers 10
  [set color yellow
    set size 2.25
    setxy 36 16]
  setup-patches
  reset-ticks
end

to setup-patches
ask patches
  [setup-nest
  setup-food
  setup-food-quality]
end

to setup-nest
    ;; set nest? variable to true inside the nest, false elsewhere
  set nest? (distancexy 36 16) < 2
  ;; spread a nest-scent over the whole world -- stronger near the nest
  set nest-scent 200 - distancexy 36 16
  set nest-x 36
  set nest-y 16
  if nest?
  [set pcolor brown]
end

to setup-food
  if (distancexy (0.8 * min-pxcor) (0.8 * min-pycor)) < 5
  [set food one-of [1 2]
    if food > 0
    [set pcolor cyan]]
  set food-source-center-x -36
  set food-source-center-y -20
end

to setup-food-quality  ;; patch procedure
  if food > 0
  [set food-quality one-of [0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]] ;; controllable with slider
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go
  ask foragers
    [wiggle
    fd 1
    look-for-food
    if color = orange + 1
        [uphill-nest-scent
            set chemical chemical + 50]
        if nest?
        [set color yellow
              look-for-food]]
ask leaders
[group-recruit]
  diffuse chemical (diffusion-rate / 100)
  ask patches
  [ set chemical chemical * (100 - evaporation-rate) / 100  ;; slowly evaporate chemical
    recolor-patch ]

  tick
  if sum [food] of patches with [pcolor = cyan] = 0 and ticks > 0
  [stop]
end

to look-for-food
    if food > 0
      [set food food - 1
      set color orange + 1]
  let potential-leaders foragers-on (patch-set patch -38 -16 patch -37 -16 patch -36 -16 patch -35 -16 patch -34 -16 patch -39 -17 patch -38 -17 patch -37 -17 patch -36 -17 patch -35 -17 patch -34 -17 patch -33 -17 patch -40 -18 patch -39 -18 patch -38 -18 patch -37 -18 patch -36 -18 patch -35 -18 patch -34 -18 patch -33 -18 patch -32 -18 patch -40 -19 patch -39 -19 patch -38 -19 patch -37 -19 patch -36 -19 patch -35 -19 patch -34 -19 patch -33 -19 patch -32 -19 patch -40 -20 patch -39 -20 patch -38 -20 patch -37 -20 patch -36 -20 patch -35 -20 patch -34 -20 patch -33 -20 patch -32 -20 patch -40 -21 patch -39 -21 patch -38 -21 patch -37 -21 patch -36 -21 patch -35 -21 patch -34 -21 patch -33 -21 patch -32 -21 patch -40 -22 patch -39 -22 patch -38 -22 patch -37 -22 patch -36 -22 patch -35 -22 patch -34 -22 patch -33 -22 patch -32 -22 patch -39 -23 patch -38 -23 patch -37 -23 patch -36 -23 patch -35 -23 patch -34 -23 patch -33 -23 patch -38 -24 patch -37 -24 patch -36 -24 patch -35 -24 patch -34 -24)
  if any? potential-leaders and not any? leaders and food > 0 and count foragers <= 10 and food-quality > 0  ;; checks if any leaders exist and if object = true food
  [ ask one-of potential-leaders
    [ set breed leaders
    set color lime]]  ;; transforms first forager to find food into the leader
end

to group-recruit
  if color = lime
    [fd 2
      uphill-nest-scent
      if nest?
      [set color white]]
  if color = white
      [wiggle
        fd 1
        facexy food-source-center-x food-source-center-y
        if food > 0
        [set color lime
          if not can-move? 1 [rt 180]]]
end


to recolor-patch  ;; patch procedure
  ;; give color to nest and food sources
  ifelse nest?                          ;; nest? true --> color brown
  [ set pcolor brown ]
  [ ifelse food > 0                     ;; not nest, but has food
    [  set pcolor cyan ]
    ;; scale color to show chemical concentration
    [ set pcolor scale-color green chemical 0.1 5 ] ]  ;; non-nest, non-food
end

to wiggle
  rt random 45
  lt random 45
  if not can-move? 1 [ rt 180 ]
end

to uphill-nest-scent  ;; turtle procedure
  let scent-ahead nest-scent-at-angle   0
  let scent-right nest-scent-at-angle  45
  let scent-left  nest-scent-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

to-report nest-scent-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [nest-scent] of p
end
@#$#@#$#@
GRAPHICS-WINDOW
308
10
1406
629
-1
-1
11.98
1
10
1
1
1
0
0
0
1
-45
45
-25
25
0
0
1
ticks
30.0

BUTTON
5
10
71
43
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
80
11
143
44
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
10
93
167
126
diffusion-rate
diffusion-rate
0
150
88.0
1
1
NIL
HORIZONTAL

SLIDER
10
133
168
166
evaporation-rate
evaporation-rate
0
100
4.0
1
1
NIL
HORIZONTAL

SLIDER
9
174
171
207
food-quality
food-quality
0
1
0.4
.1
1
NIL
HORIZONTAL

SLIDER
9
52
164
85
population
population
0
150
100.0
1
1
NIL
HORIZONTAL

PLOT
8
215
208
365
food vs time
time
food
0.0
100.0
0.0
200.0
true
false
"" ""
PENS
"food" 1.0 0 -5825686 true "" "plotxy ticks sum [food] of patches with [pcolor = cyan]"

MONITOR
217
217
286
262
Foragers
count foragers
17
1
11

MONITOR
216
273
295
318
Food-level
sum [food] of patches with [pcolor = cyan]
1
1
11

PLOT
7
376
220
531
Food + Foragers vs Time
ticks
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Foragers" 1.0 0 -5298144 true "" "plotxy ticks count foragers "
"Food" 1.0 0 -14439633 true "" "plotxy ticks sum [food] of patches with [pcolor = cyan]"

MONITOR
8
592
140
637
T1 Group Recruitment
group-recruitment-initiation
17
1
11

MONITOR
149
592
275
637
T1 Mass Recruitment
mass-recruitment-initiation
17
1
11

MONITOR
8
539
137
584
T1 Food Reduction
sum-change-tick
17
1
11

MONITOR
149
540
242
585
max-chemical
MAX [ CHEMICAL ] OF PATCHES
2
1
11

@#$#@#$#@
## WHAT IS IT?

A model of T. immigrans (pavement ant) recruitment to a food source, beginning with group-recruitment and transitioning to mass-recruitment. 

## HOW IT WORKS

The foragers randomly explore the world while scenting for food. The first forager to reach the food becomes a leader, returning to the nest and rapidly bringing back a follower ant with it. The follower ants then release high amounts of chemical, which the foragers follow to the food. Each ant that reaches the food reduces the food by some amount, causing the yellow foragers to become orange, and the brown followers to become purple. Followers respond to leader pheromone.

(what rules the agents use to create the overall behavior of the model) 

## HOW TO USE IT

The population slider controls the number of ants, while the diffusion-rate and evaporation-rate control the length of time chemical remains in the world. The food-quality slider controls how ants respond to the food, depending on whether it is low quality (below 0.6) or high-quality (above 0.6). 

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

How do the ants respond to the white leader vs the purple followers? 
(suggested things for the user to notice while running the model)

## THINGS TO TRY

Try modifying the evaporation-rate and diffusion-rate. Do the ants still respond effectively when chemical evaporates quickly? (suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL
Monitor the food level and plot food-level vs time. (suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

Different breeds - types of ants (by default in Netlogo, turtles)

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

The Ants model by Uri Wilensky and Ant Lines model by Uri Wilensky. (models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

Wilensky, U. (1997). NetLogo Ants model. http://ccl.northwestern.edu/netlogo/models/Ants. Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.
Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.

Thanks to Jen B of StackOverflow for help with various aspects of the code, especially the leader breed transformation, and Wade Schuette of the Netlogo Users Group, for help with the reporter for the tick corresponding to the first food reduction. Also thanks to Aaron Brandes, a CCL software developer from the Netlogo Users Group, for help with the reporter for the group-recruitment-initiation reporter. Most of all, thanks to Dr. Michael Greene of UC Denver, who directed this project.

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="2" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="6000"/>
    <metric>count foragers</metric>
    <metric>sum [food] of patches with [pcolor = cyan]</metric>
    <enumeratedValueSet variable="evaporation-rate">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="food-quality">
      <value value="0.6"/>
      <value value="0.8"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="101"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="diffusion-rate">
      <value value="85"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment1" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="8000"/>
    <metric>count foragers</metric>
    <metric>sum [food] of patches with [pcolor = cyan]</metric>
    <enumeratedValueSet variable="evaporation-rate">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="food-quality">
      <value value="0.6"/>
      <value value="0.8"/>
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="population" first="15" step="10" last="105"/>
    <steppedValueSet variable="diffusion-rate" first="85" step="5" last="95"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
