breed [ squares square ]
breed [ outlines outline ]
breed [ points point ]

squares-own [ my-size
              half-size
              my-rotation-angle
              reflection-matrix
              scale-matrix
              xadjustment
              yadjustment ]

globals [ function-list ]

;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Functions ;;;
;;;;;;;;;;;;;;;;;;;;;;;

to setup
  ca
  set-default-shape squares "square 4"
  set-default-shape outlines "square 3"
  set function-list []
  create-outlines 1 [
    setxy .5 .5
    set size 1.44
    set heading 0
    set color black
  ]
  create-points 100 [ setxy 0 0 set size .010001 ]
  ask patches [ set pcolor white ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Building Functions ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

to create-square
  create-squares 1 [
    set size ( square-size * 1.44 )
    set heading 0
    set my-size square-size
    set half-size ( my-size / 2 )
    set scale-matrix ( list my-size 0 0 my-size )
    set reflection-matrix ( list 1 0 0 1 0 0 ) ;; no reflection yet
    setxy .5 .5
  ]
end

to move-squares
  if mouse-down? [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [ set color red ]
      while [mouse-down?] [
        ;; If we don't force the display to update, the user won't
        ;; be able to see the turtle moving around.
        display
        ;; The SUBJECT primitive reports the turtle being watched.
        ask candidate [ setxy mouse-xcor mouse-ycor ]
      ]
      ;ask candidate [ set color black ]
      ask candidate [ check-bounds ]
      stop
    ]
  ]
end

to check-bounds ;; square procedure
  if( ( xcor - half-size ) < 0 ) [ set xcor half-size ]
  if( ( xcor + half-size ) > 1 ) [ set xcor 1 - half-size ]
  if( ( ycor - half-size ) < 0 ) [ set ycor half-size ]
  if( ( ycor + half-size ) > 1 ) [ set ycor 1 - half-size ]
end

to delete-squares
  if( mouse-down? and any?( squares ) ) [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [ die ]
      stop
    ]
  ]
end

to reflect-square

  ;; (x, y) = (-x, -y), axis \\
  if( mouse-down? and reflection-axis = "\\\\" ) [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [
        set reflection-matrix (list -1 0 0 -1 1 1 )
        set shape "reflected\\\\"
      ]
    ]
    stop
  ]
  ;; (x, y) = (-x, y), axis |
  if( mouse-down? and reflection-axis = "|" ) [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [
        set reflection-matrix (list -1 0 0 1 1 0 )
        set shape "reflected|"
      ]
    ]
    stop
  ]
  ;; (x, y) = (x, -y), axis -
  if( mouse-down? and reflection-axis = "-" ) [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [
        set reflection-matrix ( list 1 0 0 -1 0 1 )
        set shape "reflected-"
      ]
    ]
    stop
  ]
  ;; (x, y) = (y,x)
  if( mouse-down? and reflection-axis = "/" ) [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [
        set reflection-matrix (list 0 1 1 0 0 0 )
        set shape "reflected/"
      ]
    ]
    stop
  ]
end

to rotate-square
  if mouse-down? [
    let candidate min-one-of squares [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ask candidate [
        rt rotation-angle
      ]
    ]
    stop
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Fractal Drawing Functions ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to create-fractal ;; point procedure
  if( function-list = [] ) [
    set function-list ifs-list
  ]
  let random-function random-float 1
  let counter 0
  let right-function []
  while [ counter < length function-list ] [
    if( random-function < item 0 ( item counter function-list ) ) [
      set right-function item counter function-list
    ]
    set counter counter + 1
  ]
  reflect-point ( item 1 right-function )
  rotate-point  ( item 2 right-function )
  scale-point ( item 3 right-function )

  set xcor xcor + item 4 right-function
  set ycor ycor + item 5 right-function
end

;; generates the list of functions from the squares
;; manipulated by the user
to-report ifs-list
  let iterated-function-list [] ;; list of lists
  let total-area-of-squares ( sum [ my-size ] of squares )
  let prob-counter 1
  ask squares [
    set iterated-function-list lput ( list ( prob-counter ) reflection-matrix heading scale-matrix ( xcor - half-size ) ( ycor - half-size ) ) iterated-function-list
    ;;item 0 : prob counter
    ;;item 1 : reflection matrix
    ;;item 2 : rotation matrix
    ;;item 3 : scale matrix
    ;;item 4 : xcor of bottom left corner
    ;;item 5 : ycor of bottom left corner
    set prob-counter ( prob-counter - ( my-size / total-area-of-squares ) )
  ]
  report iterated-function-list
end

to draw
  ifelse( any? squares ) [
    ask squares [ ht ]
    ask points [
      create-fractal
      stamp
    ]
  ] [ stop ]
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Point Functions ;;;
;;;;;;;;;;;;;;;;;;;;;;;

to reflect-point [ my-reflection-matrix ] ;; this reflects and resets inside original square
  set xcor ( item 0 my-reflection-matrix * xcor ) + ( item 1 my-reflection-matrix * ycor ) + item 4 my-reflection-matrix
  set ycor ( item 2 my-reflection-matrix * xcor ) + ( item 3 my-reflection-matrix * ycor ) + item 5 my-reflection-matrix
end

;; rotate the point
to rotate-point [ angle ]
  facexy .5 .5 ;; face the center
  let dist distancexy .5 .5 ;; store how far I am
  fd dist
  rt angle + 180
  fd dist
end

;; scale the point
to scale-point [ my-scale-matrix ] ;; scales down original square area
  set xcor ( item 0 my-scale-matrix * xcor ) + ( item 1 my-scale-matrix * ycor )
  set ycor ( item 2 my-scale-matrix * xcor ) + ( item 3 my-scale-matrix * ycor )
end
@#$#@#$#@
GRAPHICS-WINDOW
265
10
875
641
-1
-1
300.0
1
10
1
1
1
0
0
0
1
0
1
0
1
0
0
1
ticks

BUTTON
10
10
260
51
Setup! (Click this first)
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
10
100
135
133
square-size
square-size
.1
1
0.5
.01
1
NIL
HORIZONTAL

BUTTON
140
100
260
133
Create Square
create-square
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
10
220
135
253
Move Square
move-squares
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
140
220
260
253
Delete Square
delete-squares
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
10
415
260
455
Draw My Fractal!
draw
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
140
260
260
293
Rotate Square
rotate-square
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
10
260
135
293
rotation-angle
rotation-angle
0
360
45
5
1
NIL
HORIZONTAL

BUTTON
140
305
260
340
Reflect Square
reflect-square
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
10
460
260
493
Show/Hide Squares
ask squares [\\n  ifelse( hidden? ) [ st ] [ ht ]\\n]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
15
355
257
406
Once you're satisfied with your maps, use the buttons below to draw your fractal!
14
113.0
0

TEXTBOX
15
60
255
90
Create a function (defined by a square created on the screen):
12
0.0
1

TEXTBOX
15
145
260
205
To manipulate squares (and thus change the functions they define), click on a button and then click or drag the desired square in the view to the right.
12
0.0
1

CHOOSER
10
300
135
345
reflection-axis
reflection-axis
"\\\\" "|" "-" "/"
2

@#$#@#$#@
VERSION
-------
$Id: IFS Fractal Toolkit.nlogo 43156 2009-03-05 16:58:08Z tisue $


WHAT IS IT?
-----------
An Iterated Function System is a collection of functions that are applied to a set of points repeatedly. The functions move that set of points to smaller and smaller regions, so that the resulting image includes patterns repeated within themselves. This model enables users to create their own fractal images by manipulating squares to define Iterated Function Systems.


HOW IT WORKS
------------
The user first defines an Iterated Function System by scaling, placing, rotating, and reflecting squares inside of the unit square. When they are satisfied with their design, they can press the DRAW MY FRACTAL! button to see the resulting figure. This figure is created by first generating 100 points randomly distributed within the unit square. Then at each tick, each point follows the following rules:

1) Assign an existing mapping function. The mapping function that the point is assigned to at each tick is random, but proportional to the size of each function, so that larger squares (that is, functions that map to larger regions) are more likely to be chosen than smaller squares.
2) Apply that function to the point. For example, if the point is in the lower left corner of the unit square, applying a given function will move that point to the lower left of that function's respective square.
3) Stamp, so that the point's location is recorded visually.

For more information on Iterated Function Systems, see http://en.wikipedia.org/wiki/Iterated_function_systems.


HOW TO USE IT
-------------
To create a fractal, first press SETUP.

Then, select the size of the square you would like to add with the SQUARE-SIZE slider and press CREATE SQUARE. This square, and the ways you manipulate it, represent one mapping function in your Iterated Function System. It defines the translation, scaling, rotation and reflection that a point will undergo under that mapping function:

MOVE SQUARE lets you move the square to your desired location by dragging it with your mouse in the view.
DELETE SQUARE lets you click on a square in the view to remove it.
Change the ROTATION-ANGLE to define the number of degrees you would like to rotate a square, and then select ROTATE SQUARE to choose the square you would like to rotate in the view.
Choose a REFLECTION-AXIS and press REFLECT SQUARE to choose the square you would like to reflect in the view.

When you have included all of the squares that you want, press DRAW MY FRACTAL! to see the results.

After the fractal is drawn, you can see where you placed your squares by pressing SHOW/HIDE SQUARES.


THINGS TO NOTICE
----------------
During the first few ticks of the model, some points stamp in a place that other points do not end up. Why does this happen?

What happens if you only put one square (and thus only one function) in the system? Does that make sense? Why or why not?


THINGS TO TRY
-------------
When you find an arrangement of squares that creates a fractal you like, try exploring what will happen if you only change one square a little bit, by reflecting or rotating it. Is it what you would expect?

Try finding a gallery of IFS fractals online, like the one here: http://library.thinkquest.org/26242/full/gallery/ifs.html. Can you come up with a strategy for recreating them? Can you create any fractal using IFS?


EXTENDING THE MODEL
-------------------
Try to see more of the systematic patterns in fractals by using transparency or color as a "heat map" to show where points are most likely to land after the system has run for a while. Are these locations different from what you expected? Why or why not?

Can you think of other ways that you can transform or manipulate points that would lead to interesting fractals? How would you build them into the toolkit? Try it!


NETLOGO FEATURES
----------------


RELATED MODELS
--------------
See Chaos Fractal Toolkit with Circularization for an extension of this model. Chaos Game produces fractals using a different way to express IFS. For other methods for producing fractals, check out the Fractals folder in the Mathematics section of the Models Library.


CREDITS AND REFERENCES
----------------------
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

reflected-
true
0
Line -7500403 true 45 255 45 45
Line -7500403 true 255 45 45 45
Line -7500403 true 255 255 255 45
Line -7500403 true 45 255 255 255
Line -7500403 true 120 270 120 240
Line -7500403 true 105 270 135 270
Circle -7500403 false true 135 240 30
Line -7500403 true 180 270 180 240
Rectangle -7500403 false true 180 255 195 270

reflected/
true
0
Line -7500403 true 255 255 45 255
Line -7500403 true 45 45 45 255
Line -7500403 true 255 45 45 45
Line -7500403 true 255 255 255 45
Line -7500403 true 270 180 240 180
Line -7500403 true 270 195 270 165
Circle -7500403 false true 240 135 30
Line -7500403 true 270 120 240 120
Rectangle -7500403 false true 255 105 270 120

reflected\\
true
0
Line -7500403 true 45 45 255 45
Line -7500403 true 255 255 255 45
Line -7500403 true 45 255 255 255
Line -7500403 true 45 45 45 255
Line -7500403 true 30 120 60 120
Line -7500403 true 30 105 30 135
Circle -7500403 false true 30 135 30
Line -7500403 true 30 180 60 180
Rectangle -7500403 false true 30 180 45 195

reflected|
true
0
Line -7500403 true 255 45 255 255
Line -7500403 true 45 255 255 255
Line -7500403 true 45 45 45 255
Line -7500403 true 255 45 45 45
Line -7500403 true 180 30 180 60
Line -7500403 true 195 30 165 30
Circle -7500403 false true 135 30 30
Line -7500403 true 120 30 120 60
Rectangle -7500403 false true 105 30 120 45

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

square 3
true
0
Line -7500403 true 45 45 45 255
Line -7500403 true 255 255 45 255
Line -7500403 true 255 45 255 255
Line -7500403 true 45 45 255 45

square 4
true
0
Line -7500403 true 45 45 45 255
Line -7500403 true 255 255 45 255
Line -7500403 true 255 45 255 255
Line -7500403 true 45 45 255 45
Line -7500403 true 120 30 120 60
Line -7500403 true 105 30 135 30
Circle -7500403 false true 135 30 30
Line -7500403 true 180 30 180 60
Rectangle -7500403 false true 180 30 195 45

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1pre7
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
