extensions [table csv]
globals [V K W-vec index rspec speciation specia spec Wvec speciesi meta-speciesi JM meta-sp meta-time meta-a0  meta-j2 meta-a meta-set2 extinct-species number-of-meta-trees a initial-meta-richness dlocx dlocy random-number2 number time num j x-cor y-cor N richness a0 n-speciation local-set local-di-set local-off-set set-species-who-di set-species-who-off sp hist-frq rel-hist-frq s local-set0 remove-set richness-counts species-who-di di-locx di-locy species-who-off set1-species-who-off meta-set effective-meta-cmmunity-size number-of-local-trees item-x meta-set-new meta-sp-count sp-count j1 i1 k1 j2 i2 k2 meta-richness-counts meta-richness local-richness-counts local-richness hist-frq-meta rel-hist-frq-meta hist-frq-local rel-hist-frq-local t]
breed [meta-trees meta-tree]
breed [trees tree]
meta-trees-own [species meta-species n-speciation-no]
trees-own [species h]
circles-own []
breed [circles a-circle]
patches-own[elevation]


to setup3
  clear-all
  set local-richness-counts map count table:values table:group-agents trees [species]
  set local-richness length local-richness-counts
  set sp 0
  set meta-sp 0
  set speciation 0
  set specia []
  set spec []
  set Wvec []
  set J (w1 + 1) * (w1 + 1)
  resize-world 0 w1 0 w1
  set JM 0
  set K J
  set t 0
  species-gen1
  set hist-frq-local sort-by > map count table:values table:group-agents trees [ species ]
  set rel-hist-frq-local map [ i -> i / count trees ] hist-frq-local
  set richness-counts map count table:values table:group-agents turtles [ species ]
  set richness length richness-counts
  set hist-frq-meta sort-by > map [ i -> i] Wvec
  update-plots
  reset-ticks
end

to species-gen1
  set k1 -1
  while [k1 < w1 ] [
    set k1 k1 + 1
    set i1 -1
    while [i1 < w1 ] [
      set i1 i1 + 1
      create-trees 1 [
        setxy k1 i1
        set shape "circle"
        set size 1
        set num random-float 1
        set j1 j1 + 1
        set species (sp + 1)
        set sp sp + 1
        set color random-float -50
        set spec fput sp spec
      ]
    ]
  ]
  set local-richness sp
end

to go3
  while [K > 0] [
    let r1 random-float 1
    if (length spec = 0 )[stop]
    set rspec one-of spec
    if-else (r1 <= (m * (J - 1) / (m * (J - 1) + (1 - m) * (K - 1))))[
      set speciation speciation + 1
      set specia fput rspec specia
      set spec remove rspec spec
      let Wvec1 count trees with [species = rspec]
      set Wvec fput Wvec1 Wvec
      set sp sp + 1
      let color0 60 + random-float -50
      ask trees with [species = rspec] [
        set species sp
        set color color0
        ;set shape "arrow"
      ]
    ]
    [
      if (length spec = 0 )[stop]
      set spec remove rspec spec
      let color01 [color] of one-of trees with [species = rspec]
      ask trees with [species = rspec] [
        if (length spec = 0 )[stop]
        set rspec one-of spec
        set species rspec
        set color color01
      ]
    ]
    set K K - 1
    set richness-counts map count table:values table:group-agents turtles [ species ]
    set richness length richness-counts
    set hist-frq-local sort-by > map count table:values table:group-agents turtles [ species ]
    set rel-hist-frq-local map [ i -> i / count turtles ] hist-frq-local
    set hist-frq-meta sort-by > map [ i -> i ] Wvec
    update-plots
    tick
  ]
  If (K = 0) [go]
end

to go
  set K J
  while [K > 0] [
    let r1 random-float 1
    if (length spec = 0 )[stop]
    set rspec one-of spec
    if-else (K > 1) [set t t - (ln (r1) / (K * (K - 1 )))]
    [set t 100000]
    if-else (tau >  t) [
      set spec remove rspec spec
      ask trees with [species = rspec] [
        set rspec one-of spec
        set species rspec
        set color [color] of one-of trees with [species = rspec]
      ]
      set K K - 1
      set t 0
      set richness-counts map count table:values table:group-agents turtles [ species ]
      set richness length richness-counts
      set hist-frq-local sort-by > map count table:values table:group-agents turtles [ species ]
      set rel-hist-frq-local map [ i -> i / count turtles ] hist-frq-local
      set hist-frq-meta sort-by > map [ i -> i ] Wvec
      update-plots
      tick
    ]
    [
      if (length spec = 0 )[stop]
      if-else (r1 <= theta / (theta + K - 1)) [
        set speciation speciation + 1
        set specia fput rspec specia
        set spec remove rspec spec
        let Wvec1 count trees with [species = rspec]
        set Wvec fput Wvec1 Wvec
        set sp sp + 1
        let color0 60 + random-float -50
        ask trees with [species = rspec] [
          set species sp
          set color color0
          ;set shape "arrow"
        ]
        set K K - 1
        set richness-counts map count table:values table:group-agents turtles [ species ]
        set richness length richness-counts
        set hist-frq-local sort-by > map count table:values table:group-agents turtles [ species ]
        set rel-hist-frq-local map [ i -> i / count turtles ] hist-frq-local
        set hist-frq-meta sort-by > map [ i -> i ] Wvec
        update-plots
        tick
      ]
      [
        if (length spec = 0 )[stop]
        set spec remove rspec spec
        let color01 [color] of one-of trees with [species = rspec]
        ask trees with [species = rspec] [
          set rspec one-of spec
          set species rspec
          set color color01
        ]
        set K K - 1
        set richness-counts map count table:values table:group-agents turtles [ species ]
        set richness length richness-counts
        set hist-frq-local sort-by > map count table:values table:group-agents turtles [ species ]
        set rel-hist-frq-local map [ i -> i / count turtles ] hist-frq-local
        set hist-frq-meta sort-by > map [ i -> i ] Wvec
        update-plots
        tick
      ]
    ]
  ]
end


; Copyright 2023i Ruwan Punchi-Manage.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
210
10
985
786
-1
-1
13.0
1
10
1
1
1
0
1
1
1
0
58
0
58
0
0
1
ticks
30.0

SLIDER
20
58
192
91
w1
w1
0
100
58.0
1
1
NIL
HORIZONTAL

SLIDER
20
97
192
130
theta
theta
0
1000
1.0
1
1
NIL
HORIZONTAL

BUTTON
23
10
89
43
NIL
setup3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
108
11
171
44
NIL
go3
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
19
138
191
171
tau
tau
0
1
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
19
186
191
219
m
m
0
1
0.07
0.01
1
NIL
HORIZONTAL

PLOT
1535
614
1921
900
Abundance of Local Trees
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" "plot-pen-reset\nforeach (reverse sort hist-frq-local) plot"
PENS
"default" 1.0 0 -16777216 true "" ""

PLOT
1010
19
1424
278
Number of speciations
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot speciation"

PLOT
1009
303
1422
583
Abuandance of Species in the Meta-Community Sample at t = 0
NIL
NIL
0.0
10.0
0.0
0.01
true
false
"" "plot-pen-reset\nforeach (hist-frq-meta) plot"
PENS
"default" 1.0 1 -16777216 true "" ""

PLOT
1445
20
1848
277
Relative abuandance of Species in the Meta-Community
NIL
NIL
0.0
10.0
0.0
1.0E-5
true
false
"" "plot-pen-reset\nforeach (reverse sort rel-hist-frq-local) plot"
PENS
"default" 1.0 1 -16777216 true "" ""

@#$#@#$#@
## WHAT IS IT?

### Dispersal-limited local community case:The Rosindell _et al_. (2010) algorithm-3. 

He had a census of a dispersal limited local community of size _J_. To obtain the species abundances for these _J_ individuals, they again used coalescence. they traced the ancestry of _K_ lineages as before, where initially _K_ = _J_. With each time step there is a probability _K_/_J_ (initially 1) that he picked one of the lineages, which might then immigrate with probability _m_ or coalesce with probability (1 − _m_) . _K_ − 1 / _J_ − 1 . The calculations are analogous to the metacommunity case except that instead of a speciation-initiation rate _μ_ they now have an immigration rate _m_. Lineages that immigrate are then passed to the metacommunity algorithm which accounts for them being drawn from a metacommunity species pool.

## HOW IT WORKS

### Algorithm 3. Local community dispersal limited sample from a metacommunity with protracted speciation.

This algorithm presents below is published by Rosindell, et al., (2010) in Ecology Letter supporting information section (see ELE_1463_sm_appendix.pdf). 

1. Input _θ_ and _J_, _τ_ and _m_.

2. Define a vector _S_ of length _J_ with _S_<sub>_i_</sub> = 1 for _i_ = 1, 2, . . . _J_ and define _K_ = _J_, the number of lineages in the vector.

3. Define an empty vector _V_ which will contain a list of groups of individuals descending from each immigration from the metacommunity species pool.

4. Pick a random number 0 ≤ _r_ ≤ 1 (to choose if coalescence or immigration will happen).

5. Pick a random entry _S_<sub>i</sub> from the vector _S_ (to choose which lineage this will happen to).

6. If r1 <= (m . (J - 1) / [m . (J - 1) + (1 - m) . (K - 1)]) speciation happens: remove _S_<sub>i</sub> from the vector _S_ and append it to vector _V_ (then go to 8.).

7.  If r1 > (m . (J - 1) / [m . (J - 1) + (1 - m) . (K - 1)]) coalescence happens: pick a random entry _S_<sub>j</sub> from vector _S_ (where _j_ = _i_) and set _S_<sub>i</sub> = _S_<sub>i</sub> + _S_<sub>j</sub>. Then remove _S_<sub>j</sub> from the vector _S_ ( then go to 8.)

8. Set _K_ = _K_ − 1; now the vector S should have one less element.

9. If (_K_ > 0), we are not finished so go to 4.

10. If (K ≤ 0), define _t_ = 0 the total number of units of coalescence time that have passed.

11. Pick a random number 0 ≤ _r_ ≤ 1 (to choose how many generations until the next coalescence event).

12. Set t = t − ( ln(r) / [K(K−1)] ).

13. If _τ_ > t, pick two random entries _V_<sub>i</sub> and _V_<sub>j</sub>  from the vector _V_ (where _j_ not equal to _i_), set _K_ = _K_ - 1 and _V_<sub>_i_</sub> = _V_<sub>_i_</sub> + _V_<sub>_j_</sub>. Then remove _V_<sub>_j_</sub> from the vector _V_ (then go to 3).

14. If _τ_ _≤ t_, define an empty vector _W_ which will contains a list of species abundances when the algorithm terminates.

15. Pick a random number 0 ≤ _r_ ≤ 1 (to choose if coalescence or speciation will happen).

16. Pick a random entry _V_<sub>i</sub> from the vector _V_ (to choose which lineage this will happen to).

17. If _r_ ≤ _θ_ / [_θ_+_K_− 1] , speciation happens: remove _V_<sub>i</sub> from the vector _V_ and append it to vector _W_ (then go to 12).

18. If _r_ > _θ_ / [_θ_ + _K_ − 1]  , coalescence happens: pick a random entry V<sub>j</sub> from vector _V_ (where _j_ not equal to _i_) and set _V_<sub>_i_</sub> = _V_<sub>_i_</sub> + _V_<sub>_j_</sub> then remove _V_<sub>_j_</sub> from the vector _V_.

19. Set _K_ = _K_ − 1; now the vector _V_ should have one less element.

20. If (_K_ > 0), we are not finished so go to 8.

21. If (_K_ ≤ 0), the algorithm is complete and _W_ contains the abundances of all species.



## HOW TO USE IT

Set the meta-community size, _K_ = (_w1 + 1_)<sup>2</sup>.

Decide the fundamental biodiversity number, _θ_

Decide the _τ_.

## THINGS TO NOTICE


Number of speciations happened in the meta-community is represents by arrow heads.

## THINGS TO TRY

Increase the _θ_ and see the number of speciations presents in the given _θ_ and meta-community size.

Increase the meta-community size, _K_ = (_w1 + 1_)<sup>2</sup> and see the number of speciations presents in the meta-community for given _θ_ and _τ_.

Increase the _τ_ and see the number of speciations presents in the given _θ_ and meta-community size. 

## EXTENDING THE MODEL


## NETLOGO FEATURES



## RELATED MODELS

Rosindell, J., Cornell, S. J., Hubbell, S. P., & Etienne, R. S. (2010). Protracted speciation revitalizes the neutral theory of biodiversity: Protracted speciation and neutral theory. _Ecology Letters_, **13**(6), 716–727. 


## CREDITS AND REFERENCES

* Punchi-Manage, R. (2023i).  NetLogo Rosindell _et al_. (2010)-Algorithm-3.
http://netlogo/models/NetLogo-Rosindell-et-al-2010-Algorithm-3.

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 18                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         