patches-own [work-to-do priority]

globals [skills effort planned-effort etc billable-work-done efficiency context-switch scenario-descr]
to setup
  clear-all
 reset-ticks
 setup-project
 setup-resources 
;; if ams-tickets [gen-ams-tickets]  
 set planned-effort sum [work-to-do] of patches with [member? pcolor skills]
 describe
end

to describe
   if scenario = 1
   [ set scenario-descr "Scenario 1:  simple word: one skill type repetitive activity"]
   if scenario = 2   
   [ set scenario-descr (word "Scenario 2:  in this scenario we have three \n" 
                         "parallel projects  \n" 
                         "TRY: change the number of resources that optimizes efficiency  \n" 
                         "" 
                         "")]
    
    
    clear-output
     output-print scenario-descr  
end


to setup-project
  if scenario = 2
  [set skills  [red  blue  orange ]
      if not override-scenario [set estimate-deviation 0]
 draw-proj  [[blue 0.2][ red 0.3 ][orange 0.5]] 100 -25 10  10 10   
   draw-proj  [[blue 0.3][ red 0.5 ][orange 0.2]] 200 -25 0  10 7   
  draw-proj  [[blue 0.5][ red 0.4 ][orange 0.1]] 100 -25 -10  10 7
  if not override-scenario [set blue-resources   20   set red-resources 10   set orange-resources 15  set AMS-Tickets false]
  ]
  
  
  if scenario = 1[
    set skills  [ blue  ]
     if not override-scenario [set blue-resources   2    set red-resources 0    set orange-resources 0 set yellow-resources 0  
                 set overhead 0 set estimate-deviation 0] ]
   draw-proj  [[blue 0.2]] 100 -25 10  10 10
   

  if scenario = 3
  [set skills  [red  blue  orange]
    if not override-scenario [set estimate-deviation 10]
  draw-proj  [[blue 0.2][ red 0.3 ][orange 0.5]] 100 -25 10  10 10   
   draw-proj  [[blue 0.3][ red 0.5 ][orange 0.2]] 200 -25 0  10 7   
  draw-proj  [[blue 0.5][ red 0.4 ][orange 0.1]] 100 -25 -10  10 7
  if not override-scenario [set blue-resources   13   set red-resources 17   set orange-resources 10  set AMS-Tickets false]
  ]
      

  if scenario = 4
  [set skills  [red  blue  orange yellow]
    if not override-scenario [set estimate-deviation 10]

  draw-proj  [[blue 0.2][ red 0.3 ][orange 0.5]] 100 -25 10  30 10   
   draw-proj  [[blue 0.3][ red 0.5 ][orange 0.2]] 200 -25 0  30 7   
  draw-proj  [[blue 0.5][ red 0.4 ][orange 0.1]] 100 -25 -10  30 7
  if not override-scenario [set blue-resources   12   set red-resources 16  set yellow-resources 10 set ticket-density 11
                            set orange-resources 9  set overhead 0.20 set AMS-Tickets true set dedicated-AMS false]
  ]
  
  if scenario = 5 ;; ams only
  [set skills  [red  blue  orange yellow]
    gen-ams-tickets
  if not override-scenario [set blue-resources   13 set yellow-resources   15   
                             set red-resources 17   set orange-resources 10
                             set estimate-deviation 10 set AMS-Tickets true set overhead 0.25]
  ]
    
    
  ;;ask patches [if (pycor < 18) and (pycor > -2) and (pxcor < -12) and (pxcor > -18)[set pcolor one-of skills   set work-to-do 1 + random 9 set priority random 10]]

  ;; ask patches [if (pycor < 17) and (pycor > 4) and (pxcor < 18) and (pxcor > 4)[set pcolor one-of skills  set work-to-do 1 + random 9  set priority random 10] ]
  ask patches [if (pycor < -17) [ set pcolor green ] ]
  end

to setup-resources

  
  create-turtles orange-resources[ setxy random-xcor random-ycor
    set color  orange
     set shape "persona" ]
  
   create-turtles red-resources [ setxy random-xcor random-ycor
    set color  red
     set shape "persona" ]
   
   create-turtles blue-resources [ setxy random-xcor random-ycor
    set color  blue
     set shape "persona" ]
     
     create-turtles yellow-resources [ setxy random-xcor random-ycor
    set color  yellow
     set shape "persona" ]
  
  
  
  ask turtles [ let pool one-of patches with  [ pcolor = green  and not any? turtles-here]
  if pool != nobody [
     set xcor [pxcor] of pool 
     set ycor [pycor] of pool]]
end



to find-activity ;; turtle preocedure
  let skill  color
  let new-activity one-of (patch-set
                           patches with [pcolor = skill and not any? turtles-here ] (patch-set patch-here) with [pcolor = skill]) 
                   with-min [prio-dist myself] 
                          
  if new-activity != nobody [
     ;; [pcolor] of patch-here != black mease thatt only when you interrupt an activity due to higer prio is considered context switc context switch
     if new-activity != patch-here  and [pcolor] of patch-here != green   [      ;;project startup is not considere context switch
       ask new-activity [set work-to-do work-to-do + (distance myself * overhead)];; overhead due to context switc
       set context-switch context-switch + 1
      
       ] ;; count context switc. If 
     set xcor [pxcor] of new-activity  ;; move turtle to new activity
     set ycor [pycor] of new-activity]
end




to go
 if count  patches with [member? pcolor skills] = 0 [stop]
 if ticks >= 365 [stop]
  
 if ams-tickets [gen-ams-tickets]  
 
       
 ;; ask all resources to find and activity to do based on priority and distance
 ask  turtles [find-activity] 
 ;; in this case a resource finishes the asssigned activity before lookin for new activity
 
  
  ;; work on prject activity i tick
  ask patches with [member? pcolor  skills and any? turtles-here] [
      set work-to-do work-to-do - 1
      if work-to-do <= 0 [set pcolor black]
      ]      
   set effort effort + count turtles
   set etc sum [work-to-do] of patches with [member? pcolor skills]

   set billable-work-done (planned-effort - etc)
   set efficiency billable-work-done / effort
   
   
 ;; resources that have finished work go back to pool
  ;;ask  turtles-on patches with [ (pcolor = black)] [back-to-pool]
  
  tick
end

to-report prio-distance [ x y x1 y1]  ;; nmeric reporterre
 report sqrt((x - x1)^ 2 + (y - y1)^ 2)
end 

to-report prio-dist   [tur]
    ;; patch procedure
    let result sqrt ( (priority   * priority-weigth ) ^ 2 + (distance tur) ^ 2)
 
 report result
end 




to back-to-pool ;; turtle preocedure
  let pool one-of patches with  [ pcolor = green  and not any? turtles-here]
  if pool != nobody [
     set xcor [pxcor] of pool 
     set ycor [pycor] of pool]
end

to gen-ams-tickets-old
  let sk skills
  if dedicated-ams [set sk [yellow]]
  ask patches with [pcolor = black and random (100 / ticket-density) = 0]
     [set pcolor  one-of sk set work-to-do 1 + random 9
       set priority 1 ]
  
end

to gen-ams-tickets
let sk skills
  if dedicated-ams [set sk [yellow]]
ask patches with [pcolor = black and random (10000 / ticket-density) = 0]
     [set pcolor  one-of sk set work-to-do 1 + random 9
       set planned-effort  planned-effort + work-to-do
       set priority 1 ]
  
end  

to  gen-task-force
  ask patches [if (pycor < -10) and (pycor > -15) and (pxcor < 25) and (pxcor > 10)[
      set pcolor one-of skills   
      set work-to-do 1 + random 9 
      set priority  1
      set planned-effort  planned-effort + work-to-do]
  ]

end



to draw-proj [skill-list  proj-size x y  wrk prio]
     
     let h 3  ; means the bar is thick k2 patches
     let yy y
     foreach skill-list [
       let pair ?
       set yy yy + 2
       let c item 0 pair
       let p item 1 pair
       let b (proj-size * p) / 2 + 1 
       ask patches [if (pycor > yy) and (pxcor > x) and (pycor < yy + h)and (pxcor < x + b) 
        [ set pcolor c set work-to-do  realistic-work wrk set priority  prio] 
           
        ] 
      ] 
     
end

to-report realistic-work [ work] ;; returns work plus or minus 10%
   let w     work + ( random  estimate-deviation - random estimate-deviation) * work / 100
  ;; print w 
   report w 
   
end
@#$#@#$#@
GRAPHICS-WINDOW
139
10
820
492
30
20
11.0
1
10
1
1
1
0
0
0
1
-30
30
-20
20
1
1
1
ticks
30.0

BUTTON
-2
429
61
462
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
71
427
134
460
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
2
18
137
51
red-resources
red-resources
0
50
0
1
1
NIL
HORIZONTAL

SLIDER
1
54
134
87
orange-resources
orange-resources
0
50
0
1
1
NIL
HORIZONTAL

SLIDER
1
91
132
124
blue-resources
blue-resources
0
50
2
1
1
NIL
HORIZONTAL

SLIDER
-1
296
136
329
ticket-density
ticket-density
1
100
10
1
1
NIL
HORIZONTAL

PLOT
824
107
988
227
Efficiency
NIL
NIL
0.0
100.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot efficiency"

MONITOR
915
10
985
55
Actual Effort
effort
17
1
11

MONITOR
824
11
901
56
planned effort
planned-effort
0
1
11

MONITOR
914
58
985
103
NIL
context-switch
17
1
11

BUTTON
71
503
126
536
Tick
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
-2
189
136
222
priority-weigth
priority-weigth
0
50
24
1
1
NIL
HORIZONTAL

SWITCH
-2
259
133
292
AMS-tickets
AMS-tickets
1
1
-1000

SLIDER
-2
223
133
256
overhead
overhead
0
1
0
0.01
1
NIL
HORIZONTAL

BUTTON
822
329
935
362
NIL
gen-task-force
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
5
381
97
426
scenario
scenario
1 2 3 4 5
0

BUTTON
4
503
59
536
NIL
describe
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
898
228
970
273
NIL
efficiency
2
1
11

MONITOR
1007
10
1064
55
TIME
ticks
17
1
11

SWITCH
1
469
134
502
override-scenario
override-scenario
1
1
-1000

SLIDER
826
291
953
324
estimate-deviation
estimate-deviation
0
20
0
1
1
NIL
HORIZONTAL

SWITCH
-1
333
138
366
dedicated-AMS
dedicated-AMS
1
1
-1000

SLIDER
1
129
131
162
yellow-resources
yellow-resources
0
50
0
1
1
NIL
HORIZONTAL

PLOT
827
368
987
491
 etc
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen-1" 1.0 0 -12345184 true "" "plot etc"

MONITOR
1017
61
1067
106
NIL
etc
17
1
11

MONITOR
825
60
902
105
NIL
billable-work-done
0
1
11

@#$#@#$#@
## WHAT IS IT?

this model simulates project work in an organization where multiple paralllel project and task forces distrace resource from completed te assigned tasks

## HOW IT WORKS

Rseources(workers) are modeled as Turtles. Activities or work items are modeled as patches. each work item has a priorty and a quantity of work-to-do .For example if work-to-to is equal to 10 a resource will take 10 days (ticks) to complete this work. Skills are modeled with colors. A blue resource can only do blue activities. The rule for a resource is simple: find the closest work-itme for your skill (your color). At each tick (= one working day) decrease the work to to for this work item patch. A work item with work to do = or less than zero becomes black.
The algorithm to find the closest work item to work on depends on Distance AND priority.
The importance of priority is driven by the parameter priority-weigth. If this parameter is set to zero a resource chooses always the closest work item (which is normally the same activtiy he is stting on). With this setting resources tend to stay on the same activity ntil it is completed. If priority-weitgh is high resources tend to jump around to the higher priority activities. Jumping from one activity to a onther one that is far away simulate a context switch.  FOr example means moving from on client project to another. This context switch is assocated with an overhead. The overhead due to context switch creates additional work which is "not planned and therefore not paid". THe impact of overhead can be controlled with a slider. When overhead is set to zero there is no cost associated with jumping from one activity to another.
Projects are represented with contiguous rectangles. In absence of dynamically changing priorities resources will tend to work on the same project until finished ,because of the lowset distance rule for selecting the next activity.
MAintenance is represented by random single activities with high priority. Those activtes are generated daily (at each tick) according to the Ticket-Density parameter. This simulates the fact that maintenance ticket occurr randomly, are not predictable, and normalyy have high proiority because they are production incidents. When priority-weigth is not zero, resources will tend to temporarily abandon projects to go anf fix maintenance tickets. 
There is a switch called Dedicated-AMS meaning that maintenance ticket will be all of the same color (yellow). As a consequence the yellow resources become a team which is dedicated to work on maintencance tickets. See Scenario 4 in order to experiment the effect of a dedicated maintenance team on efficiency



## HOW TO USE IT
There are some monitors and controls:
- planned-effort: is the sum of the effort of all the activty items. When tickets appear, the planned effort is increased accordingly.

- actual-effort is the actual work done by resources. THis is simply the number of resources multiplied by the number of ticks. THis means that idle resources will anyway increase the effort. This represents tht facts that resources sitting without an activities has to be payed anyway.
  
- etc : estimate to completion: this is the remaining work to do at a given point of time.

- billable-work-done  is the work done by resources that will be paid because it was plnanned. Work done as a consequence of overhead will not be paid by the project, causing an ineffciency

- efficiency: is the ratio between billable-work-done and actual-effort done. This is the most important KPI to be optimised, because is directly linked to the profitability of the team. In an ideal world with no overhead efficiency can reach level 1 with exact resources planning

-Ticket-Density :controls the probability of occurring of tickets every day

-





## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY
Scenario 1: this is the simplest word. One tzpe of activity. No Overhead due to context switch. Work siye is fullz predictable.  Given the number of resources we can exactlz predict how long the project will take. This model works well in manufacturing where and zou can have efficiencz equal to 1.  If we want to to the work in half the time can simply double the resources.  In this scenario try setting the random work switch to ON. In this case efficiency decreases because you can not predict exactly howl long a tas kwill last and you risk to have idle resources.
Scenario 1 is the happy and predicable world of Accountants,CFOs,  PMO ,and unfortunately also some Manager and Project Manager. From the maths point of view you can model it simply with rules like: Time = Total Work / Number of resources. The biggest mistake is to act and plan complex reality assuming that the laws of Scenario 1 will be still valid.

Scenario 2: This Scenario is a bit more complex that scenario 1. We have three parallel projects, each of them requires different resources. Each color represent a different skill. A red resource can only do red activities. Even f it seems more complex you can still model it with simple math. Now you have to consider a matrix of activities versus resources. Still you will be able to predict quite correctly time and costs. An excel spreadsheet will do the job. In many organizations this excel model will be the only instrument to try to model any situation. As we will see in the next scenarios this way of modeling the reality is intrinsically faulty and not adequate to have the situation under control. Wath to ty in scenario 2: initially you will see that the efficiency is low. You can notice that the blue resources finish their work very early and then tey are idle. But they are still on your payroll... try reducing the blue resourcs. Again the world is quite predictable. Once you have found a efficient sourcing mix, you can half the project duration by doubling the resources per each skill ,without loosing too much efficiency. (there is a magic combination of resources that gives efficiency = 1!!) try to find it... (solution is 10 13 17 by I will not tell which colors).  You can make up your budget beginning of the year and plan exaclty how the revenues will be.

Scenario 3: As said this approach works well in manifacturing, where a resource will do exactly the same sequence of actions throughout the year. Reality of IT project is less predictable. You may estimate that programming a feature will cost exactly 2 days but in reality this is only an approximation. Bugs, errors, compilation problems, unit testing can only partially be predicted. For this reason we introduce a random component (estimates-deviation) in the work estimates. This makes more difficult to exactly know how many resources we need. It is still teoretically possible to reach efficency = 1, but normally when we do high level plan we do not plan activities of 10.2 or 9.7 man days, we will plan for 10. In scenario 3 the estimates-deviation is set to 10%



3 parallel project with scarsity of blue resources. Effect: delay in completion of projects and cost overrun due to idle resources

Scenario 4: AMS Tickets are generated along the zear. Trz using the "Dedicated AMS team" swithc. In one case  resources for fixing tickets are taken out from projects. In the other case there is a dedicated team all tickets are Zellow). Depending on the level of overhead due to context switch te Dedicated AMS team approach looks more efficient



## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Circle -1 false false 108 3 85
Line -1 false 105 90 60 150
Line -1 false 75 180 60 150
Line -1 false 75 180 105 135
Line -1 false 105 135 120 195
Line -1 false 120 195 90 285
Line -1 false 90 285 105 300
Line -1 false 135 300 105 300
Line -1 false 150 225 135 300
Line -1 false 150 225 165 300
Line -1 false 210 285 195 300
Line -1 false 210 285 180 195
Line -1 false 195 135 180 195
Line -1 false 195 135 225 180
Line -1 false 225 180 240 150
Line -1 false 240 150 195 90
Line -1 false 195 90 165 90
Line -1 false 105 90 135 90

persona
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Circle -1 false false 108 3 85
Line -1 false 105 90 60 150
Line -1 false 75 180 60 150
Line -1 false 75 180 105 135
Line -1 false 105 135 120 195
Line -1 false 120 195 90 285
Line -1 false 90 285 105 300
Line -1 false 135 300 105 300
Line -1 false 150 225 135 300
Line -1 false 150 225 165 300
Line -1 false 210 285 195 300
Line -1 false 210 285 180 195
Line -1 false 195 135 180 195
Line -1 false 195 135 225 180
Line -1 false 225 180 240 150
Line -1 false 240 150 195 90
Line -1 false 195 90 165 90
Line -1 false 105 90 135 90

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
