breed [drone a-drone]
globals [numpts errlist toterr relerr]
turtles-own [errval]
to update
  ca
  set numpts Number_of_points
  crt 10 [set shape "target" set color green set size point-size set pen-size point-size]
  crt 10 [set shape "target" set color orange set size point-size set pen-size point-size]
  ask turtles with [who mod 10 >= numpts] [set hidden? true]
  ask turtle 0 [setxyz 0 0 0 pendown set xcor x0 set ycor y0 set zcor z0 penup set label "C0" set shape "circle 2"]
  ask turtle 1 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x1 set ycor y1 set zcor z1 penup set label "C1" ]
  ask turtle 2 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x2 set ycor y2 set zcor z2 penup set label "C2" ]
  ask turtle 3 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x3 set ycor y3 set zcor z3 penup set label "C3" ]
  ask turtle 4 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x4 set ycor y4 set zcor z4 penup set label "C4" ]
  ask turtle 5 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x5 set ycor y5 set zcor z5 penup set label "C5" ]
  ask turtle 6 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x6 set ycor y6 set zcor z6 penup set label "C6" ]
  ask turtle 7 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x7 set ycor y7 set zcor z7 penup set label "C7" ]
  ask turtle 8 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x8 set ycor y8 set zcor z8 penup set label "C8" ]
  ask turtle 9 [setxyz 0 0 0 if (not hidden?) [pendown] set xcor x9 set ycor y9 set zcor z9 penup set label "C9" ]

  ask turtle 10 [set heading az0 set pitch el0 pendown fd r0 penup set label "S0" set errval distance turtle 0 set shape "circle 2"]
  ask turtle 11 [set heading az1 set pitch el1 if (not hidden?) [pendown] fd r1 penup set label "S1" set errval distance turtle 1]
  ask turtle 12 [set heading az2 set pitch el2 if (not hidden?) [pendown] fd r2 penup set label "S2" set errval distance turtle 2]
  ask turtle 13 [set heading az3 set pitch el3 if (not hidden?) [pendown] fd r3 penup set label "S3" set errval distance turtle 3]
  ask turtle 14 [set heading az4 set pitch el4 if (not hidden?) [pendown] fd r4 penup set label "S4" set errval distance turtle 4]
  ask turtle 15 [set heading az5 set pitch el5 if (not hidden?) [pendown] fd r5 penup set label "S5" set errval distance turtle 5]
  ask turtle 16 [set heading az6 set pitch el6 if (not hidden?) [pendown] fd r6 penup set label "S6" set errval distance turtle 6]
  ask turtle 17 [set heading az7 set pitch el7 if (not hidden?) [pendown] fd r7 penup set label "S7" set errval distance turtle 7]
  ask turtle 18 [set heading az8 set pitch el8 if (not hidden?) [pendown] fd r8 penup set label "S8" set errval distance turtle 8]
  ask turtle 19 [set heading az9 set pitch el9 if (not hidden?) [pendown] fd r9 penup set label "S9" set errval distance turtle 9]

  set toterr sum [errval] of turtles with [not hidden? and who >= 10 and who < 20]
  let denom min list (sum [distancexyz 0 0 0] of turtles with [not hidden? and who >= 10 and who < 20]) (sum [distancexyz 0 0 0] of turtles with [not hidden? and who >= 0 and who < 10])
  set relerr ifelse-value (denom = 0) [0] [100 * toterr / denom]
  if relerr < 5 [output-print "Target measurement error for your tools should be around 5%. \nSignificantly less means you likely calculated, rather than measured, \none of your sets of values"]

  create-drone 1 [set color violet setxyz x0 y0 z0 set size point-size + 3
  set heading 0 set pitch 0]
  crt 1 [set color blue
         setxyz 0 0 0 pendown set heading 0 set pitch 0 forward max-pycor penup
         setxyz 0 0 0 pendown set heading 90 set pitch 0 forward max-pxcor penup
         setxyz 0 0 0 pendown set heading 0 set pitch 90 forward max-pzcor penup
         die]
end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
616
637
-1
-1
6.0
1
10
1
1
1
0
1
1
1
-50
50
-50
50
-50
50
1
1
1
ticks
30.0

BUTTON
22
647
79
680
NIL
update
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
23
39
74
99
x0
0.0
1
0
Number

INPUTBOX
23
99
73
159
x1
-3.5
1
0
Number

INPUTBOX
23
158
73
218
x2
-5.0
1
0
Number

INPUTBOX
23
218
73
278
x3
-5.7
1
0
Number

INPUTBOX
23
278
73
338
x4
2.0
1
0
Number

INPUTBOX
23
337
73
397
x5
12.0
1
0
Number

INPUTBOX
23
397
73
457
x6
6.8
1
0
Number

INPUTBOX
23
457
73
517
x7
4.3
1
0
Number

INPUTBOX
23
517
73
577
x8
0.0
1
0
Number

INPUTBOX
23
577
73
637
x9
0.0
1
0
Number

INPUTBOX
74
39
124
99
y0
0.0
1
0
Number

INPUTBOX
73
99
123
159
y1
3.0
1
0
Number

INPUTBOX
72
159
122
219
y2
5.5
1
0
Number

INPUTBOX
72
219
122
279
y3
11.5
1
0
Number

INPUTBOX
72
279
122
339
y4
12.0
1
0
Number

INPUTBOX
72
338
122
398
y5
2.5
1
0
Number

INPUTBOX
72
398
122
458
y6
5.8
1
0
Number

INPUTBOX
72
458
122
518
y7
0.0
1
0
Number

INPUTBOX
72
517
122
577
y8
0.0
1
0
Number

INPUTBOX
72
577
122
637
y9
0.0
1
0
Number

INPUTBOX
123
99
173
159
z1
2.5
1
0
Number

INPUTBOX
123
159
173
219
z2
8.0
1
0
Number

INPUTBOX
123
220
173
280
z3
7.3
1
0
Number

INPUTBOX
122
280
172
340
z4
5.8
1
0
Number

INPUTBOX
122
340
172
400
z5
2.3
1
0
Number

INPUTBOX
122
398
172
458
z6
8.2
1
0
Number

INPUTBOX
122
458
172
518
z7
4.4
1
0
Number

INPUTBOX
122
518
172
578
z8
0.0
1
0
Number

INPUTBOX
122
577
172
637
z9
0.0
1
0
Number

INPUTBOX
123
39
173
99
z0
0.0
1
0
Number

SLIDER
101
645
193
678
point-size
point-size
0
10
5.0
1
1
NIL
HORIZONTAL

INPUTBOX
206
41
256
101
az0
0.0
1
0
Number

INPUTBOX
206
101
256
161
az1
310.6
1
0
Number

INPUTBOX
206
161
256
221
az2
317.73
1
0
Number

INPUTBOX
206
221
256
281
az3
333.63
1
0
Number

INPUTBOX
206
281
256
341
az4
9.46
1
0
Number

INPUTBOX
206
340
256
400
az5
11.77
1
0
Number

INPUTBOX
206
400
256
460
az6
49.54
1
0
Number

INPUTBOX
206
459
256
519
az7
90.0
1
0
Number

INPUTBOX
206
519
256
579
az8
0.0
1
0
Number

INPUTBOX
206
578
256
638
az9
0.0
1
0
Number

INPUTBOX
256
41
306
101
el0
0.0
1
0
Number

INPUTBOX
255
101
305
161
el1
61.53
1
0
Number

INPUTBOX
255
161
305
221
el2
42.9
1
0
Number

INPUTBOX
255
221
305
281
el3
60.37
1
0
Number

INPUTBOX
254
282
304
342
el4
64.51
1
0
Number

INPUTBOX
254
340
304
400
el5
79.37
1
0
Number

INPUTBOX
255
400
305
460
el6
47.46
1
0
Number

INPUTBOX
255
460
305
520
el7
44.34
1
0
Number

INPUTBOX
254
519
304
579
el8
0.0
1
0
Number

INPUTBOX
254
578
304
638
el9
0.0
1
0
Number

INPUTBOX
306
41
356
101
r0
0.0
1
0
Number

INPUTBOX
305
101
355
161
r1
5.24
1
0
Number

INPUTBOX
305
162
355
222
r2
10.92
1
0
Number

INPUTBOX
305
222
355
282
r3
14.77
1
0
Number

INPUTBOX
304
282
354
342
r4
13.58
1
0
Number

INPUTBOX
304
343
354
403
r5
12.47
1
0
Number

INPUTBOX
304
401
354
461
r6
12.13
1
0
Number

INPUTBOX
304
460
354
520
r7
6.15
1
0
Number

INPUTBOX
304
518
354
578
r8
0.0
1
0
Number

INPUTBOX
303
578
353
638
r9
0.0
1
0
Number

MONITOR
356
593
445
638
Total Error
toterr
3
1
11

TEXTBOX
13
18
210
46
Absolute Cartesian Coordinates
11
0.0
1

TEXTBOX
204
18
387
46
Absolute Spherical Coordinates
11
0.0
1

INPUTBOX
369
76
531
136
length_units
My Foot/Footsteps
1
0
String

MONITOR
448
593
556
638
Relative error %
relerr
4
1
11

SLIDER
368
42
531
75
Number_of_points
Number_of_points
1
10
7.0
1
1
NIL
HORIZONTAL

OUTPUT
201
642
648
713
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 3D 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
