breed [teachers teacher]
breed [students student]

students-own [
  times-taught
  student-learning
  score-for-color]

teachers-own [teacher-value]

to setup
  ca
  setup-teacher
  setup-students
end

to reset
  ca
  set number-teachers 10
  set number-students 100
end

to setup-teacher
  set-default-shape teachers "person" 
  create-teachers number-teachers
  ask teachers [
    set color blue
    setxy random-xcor random-ycor
    set teacher-value ((random years-of-service + random teacher-quality) / 40)
  ]
end

to setup-students ;; students
  set-default-shape students "square"
  create-students number-students
  ask students [
    set color white
    setxy random-xcor random-ycor
    set times-taught 0
    set student-learning 0
  ]
end

to start-model
  if all? students [times-taught = 12] [stop]
  move
  teach
  do-total-plots
end

to move
  ask turtles [
    right random 360
    forward 1
  ]
end

to teach
  ask students [
    teach-student
    color-change
  ]
end

to teach-student;; asked to the student
    let current-teacher one-of teachers-here ;; student "grabs" random teacher
    if current-teacher != nobody;; did we get one?  if so,
    [
      ifelse times-taught > 11 [stop] [set times-taught (times-taught + 1)];; we only want the students
      ;; to be taught up to 12 times
      set student-learning (student-learning + [teacher-value] of current-teacher)
      ;; shows the learning of the students due to the instruction of the teacher
      if times-taught > 1 [
        set score-for-color (student-learning / times-taught)
   
        ;; considers the average student-learning accounting over the course of their education
      ]
    ]
end
  
to color-change
  if (score-for-color < 1) [set color red];; basic
  if (score-for-color > 1) and (score-for-color < 2) [set color yellow];; proficient
  if (score-for-color > 2) and (score-for-color <= 3) [set color green];; advanced
end

to do-total-plots
  set-current-plot "Totals"
  set-current-plot-pen "advanced"
  plot count students with [color = green]
  set-current-plot-pen "proficient"
  plot count students with [color = yellow]
  set-current-plot-pen "basic"
  plot count students with [color = red]
end
@#$#@#$#@
GRAPHICS-WINDOW
416
10
699
314
10
10
13.0
1
10
1
1
1
0
1
1
1
-10
10
-10
10
0
0
1
ticks

SLIDER
17
18
189
51
years-of-service
years-of-service
0
20
20
1
1
NIL
HORIZONTAL

SLIDER
17
68
189
101
teacher-quality
teacher-quality
0
100
100
1
1
NIL
HORIZONTAL

BUTTON
98
109
161
142
go
start-model
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
17
109
83
142
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
15
152
72
197
# basic
count students with [color = red]
17
1
11

MONITOR
82
151
167
196
# proficient
count students with [color = yellow]
17
1
11

MONITOR
180
150
263
195
# advanced
count students with [color = green]
17
1
11

PLOT
10
264
406
509
Totals
time
# of students
0.0
10.0
0.0
10.0
true
true
PENS
"advanced" 1.0 0 -10899396 true
"proficient" 1.0 0 -1184463 true
"basic" 1.0 0 -2674135 true

SLIDER
220
19
392
52
number-teachers
number-teachers
0
100
10
1
1
NIL
HORIZONTAL

SLIDER
221
67
393
100
number-students
number-students
0
500
100
10
1
NIL
HORIZONTAL

BUTTON
177
108
240
141
reset
reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
14
206
71
251
% basic
((count students with [color = red]) / number-students) * 100
17
1
11

MONITOR
84
206
169
251
% proficient
((count students with [color = yellow]) / number-students) * 100
17
1
11

MONITOR
178
206
261
251
% advanced
((count students with [color = green]) / number-students) * 100
17
1
11

@#$#@#$#@
WHAT IS IT?
-----------
This model represents a hypothetical school.  With a faculty with variable teacher quality and years of service, the model shows the impact of these two variables on their student learning.  This student learning uses the three categories from standardized tests: advanced, proficient, and basic.

Each student will encounter 1 random teacher, and this contact represents a single academic year.  This cycle will repeat for 12 cycles until each student has been taught 12 times.  The model stops after each student has been taught 12 times.


HOW TO USE IT
-------------
Use the sliders to change the number of teachers/students and the maximum number of years of service and teacher quality.  This model can help administrator_ evaluate whether it is better to have a staff of experienced teachers or whether it is better to pursue teacher_ who are known to be effective or the combination of the two variables.

Press "setup".  The model starts with the students, who are represented at the beginning as white squares, and ten random teachers randomly spread throughout the "school".

Press "go".  Upon contact with a teacher, the students are immediately impacted turning one of three colors: red (basic), yellow (proficient), and green (advanced) based upon their perceived learning.  Each subsequent contact with a teacher continues to impact the student either raising or diminishing their learning outcome.

The monitor and graphs show the numbers and percentages of students who meet the basic, proficient, or advanced criteria given the variables selected by the user.

Press "reset" to clear the school and return the default number of students and teachers.

HOW IT WORKS
------------
At the beginning of the model, the user defines the maximum value for the entire faculty's number of years of service and their teacher quality, which is measured on a scale of 0-100.  Each teacher is then assigned a random value within those ranges.  The teacher then has a variable called "teacher-value", which is a composite of their years of service and teacher-quality.  This "teacher-value" factor is converted to a 0-3 scale.

Students have two variables "student-learning" and "times-taught".  Students will randomly be placed in the school and encounter a random teacher.  When they encounter a teacher, the teacher's "teacher value" will be added to the student's "student-learning" score, which is a very coarse measure of the student's ability to learn from that particular teacher.  If the student has been taught more than once, the teacher's "teacher-value" score will be added to the student's current "student-learning" score.

Each time the student has been taught, the "times-taught" variable will increase by 1 and the student's color will change accordingly.  To create a color scale, the "student-learning" score, which is a cumulative measure, is divided by the number of times that the student is taught to create a "score-by-color" variable that is on a scale between 0-3.

Score by Color    Meaning         Color
0 < 1             basic           red
1 < x < 2         proficient      yellow
2 < x < 3         advanced        green

The simulation will stop after each student in the model has been taught 12 times.

The monitors and graph show the number of advanced, proficient, and basic over time.

The number of teachers and students can be changed using the sliders.  In this current version of the model, we have not accounted for a relationship between achievement and the teacher-student ratio.


THINGS TO NOTICE
----------------
By playing with the variables, can you make the number of advanced students increase?  Can you make this happen on a regular basis? Does this model help you make sense of the real world? Do you get a consistently larger affect when you increase the YEARS-OF-SERVICE or when you increase the TEACHER-QUALITY?  How do you explain this?  Do you think this is accurate?  Why?

THINGS TO TRY
-------------
In this model there are two variables that can affect the overall outcome of student learning: the YEARS-OF-SERVICE, and TEACHER-QUALITY. Look for patterns in how these variables affect the student graduation outcomes.  Which variable has the greatest effect?  Do the patterns make sense?  

Set YEARS-OF-SERVICE to zero.  What happens to the student outcomes?  Next investigate what happens when you increase YEARS-OF-SERVICE while the model runs.  Does it ever affect the number of proficient graduates?  How can you get more advanced graduates?  Now investigate what happens when you hold YEARS-OF-SERVICE steady but change the teacher quality; is there more of an effect on the number of proficient and advanced learners?

How might increasing the number of teachers and students affect the range of basic, proficient, and advanced students?  Why?  Is this effect similar to what we expect in real-life?

EXTENDING THE MODEL
-------------------
In this model, we only chose to look at two measures.  What variables other than TEACHER-QUALITY and YEARS-OF-SERVICE affect students' success in school?  Can you incorporate one of them?

We had originally wanted the patches to represent the students to allow a greater number of students to be represented.  Can you figure out a way to make this work to more fairly represent the relative numbers of teachers and students in a school?

Each student encounters a random teacher a long the way.  Can you find a way to ensure that each teacher only teaches a particular student once?

Can you find a way to factor in the realistic effect of class size and the faculty-student ratio?


NETLOGO FEATURES
----------------
Breeds of teachers and students are turtles and used the "teachers-own" and "students-own" to represent breed-specific variables that could be changed upon interaction.


RELATED MODELS
--------------
Another simple model similar to this model is the El Farol model.  To get ideas on how to extend this model and make it more realistic see the AIDS model.


CREDITS AND REFERENCES
----------------------
Abe Lo and Barbara Labuhn
Northwestern University
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
