globals [avail-resources env-responsiveness distraction efficacy-level-list task-counter zero-se one-se starting-x starting-y edited-student
  edit-flag student-list-num student-num-counter helper-num-counter]
breed [students student]
breed [helpers helper]
breed [tasks task]
breed [outcomes outcome]
students-own [attribute-string init-self-efficacy-level self-efficacy-level other-efficacy-level efficacy-accuracy perf-attainment
  init-effort-expend effort-expend persev perc-task-diff prep-effort perc-avail-resource
  attrib-type attrib-strength attrib-source age perc-outcome student-perf-outcome goal-level
  goal-committ task-interest perc-control emotion 
  eff-process-type init-ability-level ability-level TOI task-significance task-experience outcome-history student-num
  helper-feedback-strength helper-modeling-strength has-helper? my-name]
helpers-own [persuasion modeling evaluation perf-outcome
  competitor? self-efficacy-level other-efficacy-level feedback-strength feedb-type helper-num who-helping?]
tasks-own [difficulty complexity num-components uncertainty-level perf-outcome
  pos-incent-level pos-incent-type predictive-validity stability resource-dependence ability-req resource-req effort-req]

to clear
  clear-all
  setup
end

to setup
  set starting-x 25
  set starting-y 45
  set student-num-counter 0
  set student-name word "Student " student-num-counter
end

to save-student-list
  if file-exists? (word "studentlist" student-list-num ".txt")
  [set student-list-num student-list-num + 1
    save-student-list]
  file-open (word "studentlist" student-list-num ".txt")
  file-write count students
  write-student-data
  file-close
  user-message (word "Your student list has been saved to the file studentlist" student-list-num ".txt.")
  set student-list-num student-list-num + 1
end

to-report linked?
  report who != (count turtles - 1) AND out-link-neighbor? turtle (who + 1)
end

to write-student-data
  ask students [
   file-write (list who student-num self-efficacy-level ability-level effort-expend
      perc-task-diff TOI perc-avail-resource task-significance task-experience has-helper?
      helper-feedback-strength helper-modeling-strength my-name)]
end

to write-helper-data
  ask helpers [
    file-write (list "helper" who helper-num who-helping? modeling feedback-strength)]
end

;attribute-list order
;0: who OR "helper"
;1: student-num OR who
;2: self-efficacy-level OR helper-num
;3: ability-level OR who-helping?
;4: effort-expend OR modeling
;5: perc-task-diff OR feedback-strength
;6: TOI
;7: perc-avail-resource
;8: task-significance
;9: task-experience
;10: has-helper?
;11: helper-feedback-strength
;12: helper-modeling-strength
;13: my-name

to create-student
  ifelse count students = 10 [user-message "You may only create 10 students for one setup."]
  [create-students 1 [set shape "person student" set size 10 set outcome-history [] set heading 180
      set student-num student-num-counter
      set self-efficacy-level starting-self-efficacy
      set ability-level starting-ability-level
      set effort-expend starting-effort-expenditure
      set perc-task-diff perceived-task-difficulty
      set TOI theory-of-intelligence
      set perc-avail-resource 0
      set task-significance 0
      set task-experience experience-on-task
      set my-name student-name
    set color starting-self-efficacy - 5 set heading 0 
    setxy starting-x starting-y
  set starting-y starting-y - 10
  set has-helper? helper-present?
  set helper-feedback-strength feedback-valence
  set helper-modeling-strength modeling-effectiveness
  make-helper
  set label (word my-name " - Self-Efficacy: "
      self-efficacy-level " Ability: " ability-level " Starting Effort: " effort-expend)]]
  set student-num-counter student-num-counter + 1
  set student-name word "Student " student-num-counter
end



to make-helper
 if helper-present? = true
  [hatch-helpers 1 [set shape "person graduate" set size 10 set heading 180 create-link-from myself [tie]
      set modeling modeling-effectiveness set feedback-strength feedback-valence set who-helping? student-num-counter
      set helper-num helper-num-counter
      setxy ([xcor] of myself + 5) [ycor] of myself set label ""]
  set helper-num-counter helper-num-counter + 1]
end
  
to select-student
   while [edit-flag = 0]
   [if mouse-down? [
    let candidate min-one-of students [distancexy mouse-xcor mouse-ycor]
    if [distancexy mouse-xcor mouse-ycor] of candidate < 1
    [set starting-self-efficacy [self-efficacy-level] of candidate
      set starting-ability-level [ability-level] of candidate
      set starting-effort-expenditure [effort-expend] of candidate
      set edited-student candidate]]]
end

to edit-student
  set edit-flag 1
  ask edited-student
  [set self-efficacy-level starting-self-efficacy
   set ability-level starting-ability-level
   set effort-expend starting-effort-expenditure
   set color starting-self-efficacy - 5
   set heading 0 
  set label (word "Student " student-num " - Self-Efficacy: "
      self-efficacy-level " Ability: " ability-level " Starting Effort: " effort-expend)]
  set edit-flag 0
end

to startpos
  ask students [setxy (init-self-efficacy-level - 50) (student-num * 10)]
end

to hack-setup
  set task-counter 0
  create-students 2 [set shape "person student" set size 10 set outcome-history []]
  ask student 0 [set init-self-efficacy-level 40 set self-efficacy-level 40
    set init-effort-expend 40 set effort-expend 40
    set init-ability-level 40 set ability-level 40]
  ask student 1 [set init-self-efficacy-level 60 set self-efficacy-level 60
    set init-effort-expend 60 set effort-expend 60
    set init-ability-level 60 set ability-level 60]
  ask students [set color self-efficacy-level - 5]
  ask students [set heading 0]
  startpos
  ask students [set label word "student " student-num]
end

to reset
  ask students [set self-efficacy-level init-self-efficacy-level
    set color self-efficacy-level - 5]
  ask students [set effort-expend init-effort-expend]
  ask students [set ability-level init-ability-level]
  clear-all-plots
  set task-counter 0
  startpos
end
@#$#@#$#@
GRAPHICS-WINDOW
553
16
1026
510
55
55
4.1712
1
10
1
1
1
0
0
0
1
-55
55
-55
55
0
0
1
ticks

BUTTON
15
10
141
43
Create-Student
Create-Student
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

INPUTBOX
15
150
170
210
Starting-Self-Efficacy
30
1
0
Number

INPUTBOX
15
215
169
275
Starting-Effort-Expenditure
50
1
0
Number

INPUTBOX
15
280
170
340
Starting-Ability-Level
30
1
0
Number

BUTTON
485
52
549
85
Clear
Clear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
19
128
169
146
Model 1
12
0.0
1

TEXTBOX
205
130
355
148
Model 2
12
0.0
1

INPUTBOX
205
150
360
210
Perceived-Task-Difficulty
40
1
0
Number

CHOOSER
205
213
370
258
Theory-of-Intelligence
Theory-of-Intelligence
"Entity" "INcremental" "n/a"
0

INPUTBOX
15
345
170
405
Experience-on-Task
60
1
0
Number

BUTTON
484
17
550
50
Setup
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
416
89
551
122
Save Student List
save-student-list
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
404
133
554
163
Model 5 (Helper Creation)
12
0.0
1

INPUTBOX
400
215
535
275
Modeling-Effectiveness
50
1
0
Number

INPUTBOX
400
281
536
341
Feedback-Valence
50
1
0
Number

SWITCH
400
170
534
203
Helper-Present?
Helper-Present?
1
1
-1000

INPUTBOX
149
10
374
70
Student-Name
Student 5
1
0
String (reporter)

@#$#@#$#@
WHAT IS IT?
-----------

This first _odel_allows the user to create up to 10 students with differing attribute levels that can then be imported into the other SEM models. 



HOW IT WORKS
------------

The attributes present in the student setup consist of some traits that will change once the models are run and others that will not. It is important to note how the values of the variables work. On any attribute, a value of 50 is _verage_or _eutral__any value above 50 is considered to be _igh_or _ositive,_and any value below 50 is considered to be _ow_or _egative._The rules that govern how attributes change are considered in terms of lowness and highness, with the strength of the effect impacted by the degree of intensity, or distance from a value of 50 (note that the strength of these effects are also mediated by _orld attributes_that can be modified within each model).

Below are descriptions of the modifiable attributes for the students:

_	Starting self-efficacy (all models) _This attribute represents a student_ initial conception of how well the student thinks he can do on the given task. This value directly affects the student_ effort expenditure, and is directly affected by many variables, including performance outcomes, helper effectiveness, perceived difficulty, and distraction level.

_	Starting effort-expenditure (all models) _This attribute represents the initial amount of effort the student spends on the given task. This value directly affects performance outcome and is directly affected by student self-efficacy.

_	Starting ability level (all models) _This attribute represents how well a student can perform on a task, all things being equal. This value directly affects performance outcome and is directly affected by performance outcome and the interaction between perceived task difficulty and self-efficacy level.

_	Experience on task (all models) _This attribute represents how familiar the student is with the task initially. This attribute will increase with performance of the task, and directly affects how likely it is that the students will change their efficacy in response to performance outcomes, helper effectiveness, and attributional processes.

_	Perceived task difficulty (models 2-5) _This attribute represents how easy or difficulty the student perceives the current task to be. This attribute is closely related to actual task difficulty but does have some differential effects when task difficulty and perceived task difficulty are different. In conjunction with other variables, this attribute affects self-efficacy level, effort expenditure, and ability level.

_	Theory of intelligence (models 2-5) _This attribute represents the conception that a student holds about how intelligence works. Students with an _ntity_theory view intelligence as a fixed trait that cannot be changed, whereas students with an _ncremental_theory view intelligence as a malleable trait that can be increased over time through effort. This attribute directly affects self-efficacy (and indirectly affects effort expenditure). The user can opt to ignore this value during a trial by updating a student_ theory of intelligence to _/a._
_	Helper-present? (model 5) _This attribute represents whether or not the student has another figure (such as a teacher or role model) present to model behavior and provide feedback to the student. The helper has two variable of its own that can be set by the user.

_	Modeling effectiveness (model 5) _This attribute represents how well the helper can model successful behavior for the student. This attribute directly affects the student_ self-efficacy.

_	Feedback valence (model 5) _This attribute represents how influential the feedback that the helper provides the student is. The type of feedback that students can receive is introduced in model 4; in model 5, the presence of a model and its feedback strength can affect the impact that feedback has on self-efficacy levels.


HOW TO USE IT
-------------

The user should begin by clicking the _etup_button to calibrate all of the settings. The attributes are grouped together according to the model that will incorporate them. Once the user has edited the variable levels for a student, the user can name the student in the _tudent-Name_box and click the _reate-Student_button. A student will then appear in the visualization screen with its attribute levels listed beneath itself. The user can then change the variable levels around and create another student that may contrast with the previous students along any number of dimensions.

Once the user is satisfied with the students create, he can click the _ave Student List_button; the user will be informed of a file name where the list is stored and 

If the user is not satisfied with the current students created or would like to redo the current list, the user can click the _lear_button to reset the screen.

If the user creates a helper for a student, the helper will appear adjoined to the student in any model but will only effect behavior in model 5.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
Give names to the students based on their student _rofile," eg. _nderachiever,__ifted student,__igh effort, low ability_
Create a set of students that differ minimally from each other so that you can accurately explain observed differences by individual traits

Consider creating two identical students in a set to observe how _andom_outcomes can differentially affect the same student type


EXTENDING THE MODEL
-------------------


NETLOGO FEATURES
----------------

RELATED MODELS
--------------

SelfEfficacyModel_1.nlogo
SelfEfficacyModel_2.nlogo
SelfEfficacyModel_3.nlogo
SelfEfficacyModel_4.nlogo
SelfEfficacyModel_5.nlogo


CREDITS AND REFERENCES
----------------------
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person graduate
false
0
Circle -16777216 false false 39 183 20
Polygon -1 true false 50 203 85 213 118 227 119 207 89 204 52 185
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -8630108 true false 90 19 150 37 210 19 195 4 105 4
Polygon -8630108 true false 120 90 105 90 60 195 90 210 120 165 90 285 105 300 195 300 210 285 180 165 210 210 240 195 195 90
Polygon -1184463 true false 135 90 120 90 150 135 180 90 165 90 150 105
Line -2674135 false 195 90 150 135
Line -2674135 false 105 90 150 135
Polygon -1 true false 135 90 150 105 165 90
Circle -1 true false 104 205 20
Circle -1 true false 41 184 20
Circle -16777216 false false 106 206 18
Line -2674135 false 208 22 208 57

person student
false
0
Polygon -13791810 true false 135 90 150 105 135 165 150 180 165 165 150 105 165 90
Polygon -7500403 true true 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 100 210 130 225 145 165 85 135 63 189
Polygon -13791810 true false 90 210 120 225 135 165 67 130 53 189
Polygon -1 true false 120 224 131 225 124 210
Line -16777216 false 139 168 126 225
Line -16777216 false 140 167 76 136
Polygon -7500403 true true 105 90 60 195 90 210 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
