globals [avail-resources env-responsiveness distraction efficacy-level-list task-counter zero-se one-se variable-list feedback-counter
  next-color student-num student-num-counter helper-num-counter temp-list]
breed [students student]
breed [helpers helper]
students-own [init-self-efficacy-level self-efficacy-level
  init-effort-expend effort-expend persev perc-task-diff perc-avail-resource
  perc-outcome student-perf-outcome init-ability-level ability-level TOI task-significance init-task-experience task-experience
  outcome-history outcome-totals temp-resource-bonus effort-attrib ability-attrib luck-attrib effort-feedback? ability-feedback? helper-num
  who-helping? my-name]
helpers-own [persuasion modeling evaluation perf-outcome
  competitor? self-efficacy-level other-efficacy-level feedback-strength feedb-type]

to clear
  clear-all
end

to show-traits
  ask student student-number
  [show (list word "Self Efficacy Level: " self-efficacy-level word "Effort Expenditure: " effort-expend
      word "Ability Level: " ability-level word "Perceived Task Difficulty: " perc-task-diff
      word "Theory of Intelligence: " TOI word "Perceived Resources Available: " perc-avail-resource
      word "Task Significance: " task-significance word "Task Experience: " task-experience
      word "Effort Attribution: " effort-attrib word "Ability Attribution: " ability-attrib
      word "Luck Attribution: " luck-attrib word " Successes: " first bf outcome-totals
      word "Failures: " first outcome-totals
      )]
end

to import-students
  file-open user-file
  create-students file-read [set shape "person student" set size 10 set outcome-history [] set heading 180]
;  create-helpers file-read [set shape "person graduate" set size 10 set heading 180]
  while [NOT file-at-end?]
  [give-attributes]
  file-close
  startpos
  make-student-pens
end

to give-attributes
  let current-attributes file-read
  ask student item 1 current-attributes
  [set init-self-efficacy-level item 2 current-attributes set self-efficacy-level item 2 current-attributes
    set init-ability-level item 3 current-attributes set ability-level item 3 current-attributes
    set init-effort-expend item 4 current-attributes set effort-expend item 4 current-attributes
    set perc-task-diff item 5 current-attributes
    set TOI item 6 current-attributes
    set perc-avail-resource item 7 current-attributes
    set task-significance item 8 current-attributes
    set init-task-experience item 9 current-attributes
    set my-name item 13 current-attributes
    set color who * 20 + 5
    set label my-name
    set outcome-history []
    set temp-resource-bonus 0
    set ability-attrib 0
    set effort-attrib 0
    set luck-attrib 0
    set outcome-totals [0 0]
    if item 10 current-attributes
    [hatch-helpers 1 [set shape "person graduate" set size 10 set heading 180 create-link-from myself [tie]
      set modeling item 12 current-attributes set feedback-strength item 11 current-attributes
      setxy ([xcor] of myself + 5) [ycor] of myself set label ""]]]
end

;attribute-list order
;0: who OR "helper"
;1: student-num OR who
;2: self-efficacy-level OR helper-num
;3: ability-level OR who-helping?
;4: effort-expend OR modeling
;5: perc-task-diff OR feedback-strength
;6: TOI
;7: perc-avail-resource
;8: task-significance
;9: task-experience
;10: has-helper?
;11: helper-feedback-strength
;12: helper-modeling-strength
;13: my-name

to experience-update
  set task-experience task-experience + 1
  if task-experience > 100 [set task-experience 100]
end

;to-report has-helper?
;  report any? out-link-neighbors
;end
;
;to-report my-helper?
;  if has-helper?
;  [report one-of out-link-neighbors]
;end
;
;to receive-feedback 
;  ifelse feedback-counter = feedback-frequency
;  [if effort-feedback? = true
;    [set effort-attrib effort-attrib + 1
;      set luck-attrib luck-attrib - .5]
;  if ability-feedback? = true
;    [set ability-attrib ability-attrib + 1
;      set luck-attrib luck-attrib - .5]
;    if who + 1 = count students
;    [set feedback-counter 1]] 
;  [set feedback-counter feedback-counter + (1 / count students)]
;  min-max-attrib-correct
;end

to-report chance50?
  report random 10 > 4
end

to-report deep-process-chance
  report random 101 > task-experience
end

to-report automatic-process-chance
  report random 101 < task-experience + 50
end

;to helper-impact
;  if has-helper? AND chance50?
;  [let helper-modeling [modeling] of my-helper?
;  if helper-modeling < 50
;  [set self-efficacy-level self-efficacy-level + ((helper-effect * (helper-modeling - 50)) / 16)]
;  if helper-modeling > 50
;  [set self-efficacy-level self-efficacy-level + ((helper-effect * (helper-modeling - 50)) / 16)]]
;end

to min-max-attrib-correct
  if luck-attrib < 0 [set luck-attrib 0]
  if luck-attrib > 100 [set luck-attrib 100]
  if effort-attrib < 0 [set effort-attrib 0]
  if effort-attrib > 100 [set effort-attrib 100]
  if ability-attrib < 0 [set ability-attrib 0]
  if ability-attrib > 100 [set ability-attrib 100]
end

to effort-update
  if perc-task-diff - 50 > 0 AND self-efficacy-level - 50 > 0
  [set effort-expend effort-expend + perceived-difficulty-effect]
  if perc-task-diff - 50 < 0 AND self-efficacy-level - 50 < 0 
  [set effort-expend effort-expend - perceived-difficulty-effect]
  set effort-expend effort-expend + ((efficacy-bonus * (self-efficacy-level - 50) / 8))
  if effort-expend < 0
  [set effort-expend 0]
  if effort-expend > 100
  [set effort-expend 100]
end

;to make-attributions ;; incorporate effect size for task difficulty? reduce efficacy by 50 - task difficulty * effect?
;  ifelse ability-attrib >= effort-attrib
;    [ifelse first outcome-history = 1 [increase-eff-level 1]
;      [decrease-eff-level 1]] ;ending of actions when attribution = ability
;    [ifelse first outcome-history = 1 [increase-eff-level 1] 
;      [set effort-expend effort-expend + (effort-attrib * attribution-effect)] 
;      if (has-helper? AND [feedback-strength] of my-helper? > 50) AND perc-task-diff < 50
;      [set self-efficacy-level self-efficacy-level - 
;        helper-effect * ((([feedback-strength] of my-helper? - 50) + (50 - perc-task-diff)) / 4)]
;     ] ;should this be proportional to difficulty of task? put back in actual task-difficulty?
;  if self-efficacy-level > 50 AND first outcome-history = 0 AND random 10 > 4 [set luck-attrib luck-attrib + 1]
;  min-max-attrib-correct
;end

to ability-update
  if perc-task-diff - 50 > 0 AND self-efficacy-level - 50 > 0
  [set ability-level ability-level + perceived-difficulty-effect]
  if perc-task-diff - 50 < 0 AND self-efficacy-level - 50 < 0
  [set ability-level ability-level - perceived-difficulty-effect]
  if student-perf-outcome = 1
    [set ability-level ability-level + learning-bonus]
    if ability-level > 100 [set ability-level 100]
    if ability-level < 0 [set ability-level 0]
end

;to distraction-impact
;  set self-efficacy-level self-efficacy-level - (distraction-level * distraction-effect)
;  if self-efficacy-level < 0 [set self-efficacy-level 0]
;end

;to resource-impact
;  set temp-resource-bonus temp-resource-bonus + (resource-effect * (resources-available - resources-required))
;end

to perform-task ;; button that simulates trial at a task, yielding outcome and efficacy update
  ask students [
    ;distraction-impact resource-impact
    effort-update
    outcome-formula p-color-change
 ;   receive-feedback
 ;   if deep-process-chance [make-attributions]
 ;   if deep-process-chance [helper-impact]
    if automatic-process-chance [change-eff-level]
    ability-update
    experience-update]
  set task-counter task-counter + 1
end

to change-eff-level
  ifelse student-perf-outcome = 0
  [decrease-eff-level 1]
  [increase-eff-level 1]
end

to increase-eff-level [num]
  if NOT (self-efficacy-level = 100)
  [set self-efficacy-level self-efficacy-level + num
  if self-efficacy-level > 100 [set self-efficacy-level 100]
  if self-efficacy-level < 0 [set self-efficacy-level 0]
    set xcor self-efficacy-level - 50]
end

to decrease-eff-level [num]
  if NOT (self-efficacy-level = 0)
  [set self-efficacy-level self-efficacy-level - num
    if TOI = "Entity"
    [set self-efficacy-level self-efficacy-level - toi-strength]
    if self-efficacy-level < 0 [set self-efficacy-level 0]
    if self-efficacy-level > 100 [set self-efficacy-level 100]
    set xcor self-efficacy-level - 50]
end

to p-color-change
  ifelse [pcolor] of patch-here != 0
  [ifelse first outcome-history = 1 [ask patch-here [set pcolor pcolor + 1 ask neighbors [set pcolor pcolor + 1]]]
      [ask patch-here [set pcolor pcolor - 1 ask neighbors [set pcolor pcolor - 1]]]]
  [ifelse first outcome-history = 1 [ask patch-here [set pcolor 65 ask neighbors [set pcolor 65]]]
      [ask patch-here [set pcolor 15 ask neighbors [set pcolor 15]]]]
end

to change-outcome-totals
  ifelse first outcome-history = 1
  [set outcome-totals replace-item 1 outcome-totals (first bf outcome-totals + 1)]
  [set outcome-totals replace-item 0 outcome-totals (first outcome-totals + 1)]
end

to-report outcome-agg
  report (first bf outcome-totals) - (first outcome-totals)
end

to outcome-formula
  ifelse randomness = true
  [ifelse task-difficulty > (random ability-level + random effort-expend + temp-resource-bonus)
  [set student-perf-outcome 0]
  [set student-perf-outcome 1]
  set temp-resource-bonus 0]
  [ifelse task-difficulty > (ability-level + effort-expend + temp-resource-bonus)
  [set student-perf-outcome 0]
  [set student-perf-outcome 1]
  set temp-resource-bonus 0]
  set outcome-history fput student-perf-outcome outcome-history
  change-outcome-totals
end

to go
  perform-task
  efficacy-plot
  effort-plot
  outcomes-plot
  ability-plot
end

to go-100
  repeat 100 [go wait .05]
end

to startpos
  ask students [setxy (self-efficacy-level - 50) (who * 10 - 5)]
end

to make-student-pens
  ask students [set-current-plot "Effort Expenditure" create-temporary-plot-pen my-name set-plot-pen-color (who * 20 + 5)]
  ask students [set-current-plot "Outcomes" create-temporary-plot-pen my-name set-plot-pen-color (who * 20 + 5)]
  ask students [set-current-plot "Self-Efficacy" create-temporary-plot-pen my-name set-plot-pen-color (who * 20 + 5)]
  ask students [set-current-plot "Ability Level" create-temporary-plot-pen my-name set-plot-pen-color (who * 20 + 5)]
end

to reset
  ask students [set self-efficacy-level init-self-efficacy-level
    set effort-expend init-effort-expend
    set ability-level init-ability-level
    set outcome-history []
    set temp-resource-bonus 0
    set ability-attrib 0
    set effort-attrib 0
    set luck-attrib 0
    set outcome-totals [0 0]
    set task-experience init-task-experience]
  clear-all-plots
  set task-counter 0
  set feedback-counter 1
  ask patches [set pcolor 0]
  startpos
  make-student-pens
  set next-color 5
end

to min-max-correct
;  if feedback-valence > 100 [set feedback-valence 100] if feedback-valence < 0 [set feedback-valence 0]
;  if modeling-effectiveness > 100 [set modeling-effectiveness 100] if modeling-effectiveness < 0 [set modeling-effectiveness 0]
  if student-ability > 100 [set student-ability 100] if student-ability < 0 [set student-ability 0]
  if starting-efficacy > 100 [set starting-efficacy 100] if starting-efficacy < 0 [set starting-efficacy 0]
;  if perceived-resources-avail > 100 [set perceived-resources-avail 100] if perceived-resources-avail < 0 [set perceived-resources-avail 0]
  if effort-expenditure > 100 [set effort-expenditure 100] if effort-expenditure < 0 [set effort-expenditure 0]
  if perceived-task-difficulty > 100 [set perceived-task-difficulty 100] if perceived-task-difficulty < 0 [set perceived-task-difficulty 0]
;  if significance-of-task > 100 [set significance-of-task 100] if significance-of-task < 0 [set significance-of-task 0]
;  if experience-on-task > 100 [set experience-on-task 100] if experience-on-task < 0 [set experience-on-task 0]
;  if ability-attribution-feedback > 100 [set ability-attribution-feedback 100] if ability-attribution-feedback < 0 [set ability-attribution-feedback 0]
;  if effort-attribution-feedback > 100 [set effort-attribution-feedback 100] if effort-attribution-feedback < 0 [set effort-attribution-feedback 0]
end

to update-student
;  min-max-correct
  ask student student-number [
    set init-self-efficacy-level starting-efficacy
    set init-effort-expend effort-expenditure
    set init-ability-level student-ability
    set self-efficacy-level starting-efficacy
    set effort-expend effort-expenditure
    set ability-level student-ability
    set TOI theory-of-intelligence
    set perc-task-diff perceived-task-difficulty
;    set effort-feedback? effort-feedback
;    set ability-feedback? ability-feedback
    set outcome-history []
    set temp-resource-bonus 0
    set ability-attrib 0
    set effort-attrib 0
    set luck-attrib 0
    set outcome-totals [0 0]
    set heading 180]
;;  reset
end

;to update-helper
;  ask turtle student-number [let helper? out-link-neighbor? turtle (student-number + 2)
;    ifelse helper? = false
;  [user-message "Sorry, that student does not have a helper to update."]
;  [min-max-correct
;  ask helper (student-number + 2)
;  [set modeling modeling-effectiveness
;    set feedback-strength feedback-valence]]]
;end

to effort-plot
  set-current-plot "effort expenditure"
  ask students [set-current-plot-pen my-name
    plot effort-expend]
end 

to efficacy-plot
  set-current-plot "self-efficacy"
  ask students [set-current-plot-pen my-name
    plot self-efficacy-level]
end

to outcomes-plot
  set-current-plot "outcomes"
  ask students [set-current-plot-pen my-name
    plot outcome-agg]
end 

to ability-plot
  set-current-plot "ability level"
  ask students [set-current-plot-pen my-name
    plot ability-level]
end 
@#$#@#$#@
GRAPHICS-WINDOW
685
10
1139
485
55
55
4.0
1
10
1
1
1
0
0
1
1
-55
55
-55
55
0
0
1
ticks

TEXTBOX
225
170
375
188
Student Attributes
12
0.0
1

TEXTBOX
500
45
650
63
Task Attributes
12
0.0
1

SLIDER
500
65
672
98
Task-Difficulty
Task-Difficulty
0
100
60
1
1
NIL
HORIZONTAL

BUTTON
510
380
680
413
Peform Task/Update Efficacy
Go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
550
450
610
483
NIL
Clear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
10
165
210
315
Self-Efficacy
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"default" 1.0 0 -13345367 false

PLOT
10
10
210
160
Effort Expenditure
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"default" 1.0 0 -16777216 false

PLOT
10
320
210
470
Outcomes
NIL
Success or Failure
0.0
10.0
-1.0
2.0
true
true
PENS
"default" 1.0 0 -13345367 false

BUTTON
613
450
678
483
Reset
Reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
690
35
782
80
task-counter
task-counter
17
1
11

BUTTON
550
415
680
448
Perform/Update x100
Go-100
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
497
160
677
193
Efficacy-Bonus
Efficacy-Bonus
0
1
0.6
.1
1
NIL
HORIZONTAL

SLIDER
497
195
677
228
Learning-bonus
Learning-bonus
0
1
0.6
.1
1
NIL
HORIZONTAL

PLOT
215
10
415
160
Ability Level
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"default" 1.0 0 -16777216 false

INPUTBOX
230
310
335
370
Student-Ability
50
1
0
Number

INPUTBOX
230
245
335
305
Effort-Expenditure
50
1
0
Number

INPUTBOX
340
375
485
435
Perceived-Task-Difficulty
60
1
0
Number

INPUTBOX
230
375
335
435
Starting-Efficacy
60
1
0
Number

BUTTON
340
195
462
228
Update Student
update-student
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
505
140
655
158
World Attributes
12
0.0
1

CHOOSER
340
325
485
370
Theory-of-Intelligence
Theory-of-Intelligence
"Entity" "Incremental" "n/a"
1

SLIDER
495
230
675
263
TOI-strength
TOI-strength
0
1
0.5
.1
1
NIL
HORIZONTAL

SWITCH
545
305
677
338
Randomness
Randomness
0
1
-1000

SLIDER
495
265
675
298
Perceived-difficulty-effect
Perceived-difficulty-effect
0
1
0
.1
1
NIL
HORIZONTAL

BUTTON
530
345
680
378
Import Student List
import-students
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

CHOOSER
230
195
335
240
Student-Number
Student-Number
0 1 2 3 4 5 6 7 8 9
0

TEXTBOX
725
445
1160
496
 <---- Low Self Efficacy         High Self Efficacy ---->
14
9.9
1

BUTTON
340
235
475
268
See Student Attributes
ask student student-number [show-traits]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
WHAT IS IT?
-----------
	The Self-Efficacy Model is an interactive model in a program to teach educational leaders about self-efficacy that allows users to simulate task performance and self-efficacy updates by constructing individual students with modifiable trait levels and manipulating student and environmental variables. The program is designed to introduce users to increasing complex models of self-efficacy that progressively incorporate more and more input factors that contribute to the development of self-appraisals. Each model consists of a visualization screen that represents students as individual agents (accompanied in some cases by an adult _elper_, as well as a set of sliders that allow the user to change environmental or agent-based variables to modify the observed behavior. The students will dynamically move horizontally across the screen as their self-efficacy values shift. Leaders who use engage with the SEMP program should be empowered to identify factors in their own environments that can be either detrimental or advantageous to improving their students_self-efficacy judgments, improving the lives of young children and the people around them.

	This model is the second of five models. Model 2 introduces more student attributes that represent further information that the student must process when making judgments (theory of intelligence and perceived task difficulty).

HOW IT WORKS
------------

Steps/Rules in "Perform Task/Update Efficacy" - When the user click the "perform task/update efficacy" or "perform/update x100" button, these are the processes that take place and the rules and factors that govern them.

1)	Effort Update _This process modifies the students_effort expenditure level according to their self-efficacy level.

	a.	If the student has a high perception of task difficulty AND a high level of self-efficacy, the student receives a boost in effort expenditure based on the world attribute value of _erceived Difficulty Effect._If the student has a low perception of task difficulty AND a low level of self-efficacy, the student receives a reduction in effort expenditure (Bandura, 1982).

	b.	This effect is also multiplied by the world attribute _fficacy Bonus;_this variable can be changed to a value between 0 and 1 through the slider present in the interface. This allows the user to modify the impact that efficacy has on effort based on their own conceptions of how those factors interact.

2)	Outcome determination _This process results in either a success or a failure for the student on a single trial, dependent on whether the task difficulty value is greater than a randomly-generated value bounded by effort expenditure plus a randomly-generated value bounded by ability level.

	a.	_ask difficulty_is a task attribute that can modified through a slider present in the interface. This attribute can be changed after a single task performance or during a run and will dynamically affect the environment.

	b.	The formula for determining the outcome is a simplistic view on performance. It views effort and ability as the main factors contributing to actual performance success, as it relates to the level of difficulty a student is encountering. The element of randomness is added because every trial on a task is not necessarily equal, but there is a probability that the outcome will be the same given the value of the factors.

	c.	After each task performance, the patch on which the student is standing will change color: green to represent a success, or red to represent a failure. Because students will _erform_over the same patches many times, the color of the patch will subsequently lighten for successes or darken for failures if the patch has already been _erformed_on.

	d.	The randomness of task performance can be turned off through the _andomness_switch present in the interface.

3)	Determine chance of automatic processing / Change efficacy level _This step is where the students update their efficacy levels according to the outcome on their last performance: increase efficacy after a success or decrease efficacy after a failure. This efficacy change is dependent on chance of automatic processing: the more experience the student has on the task, the more likely the student is to make _utomatic_judgments about efficacy based on past performance (Gist & Mitchell, 1992). If the student is new to the task, there is a higher chance that the student will incorporate other factors to make judgments about efficacy.

	a.	If a student has failed on a task AND holds an _ntity_view of intelligence, his self-efficacy value is additionally reduced by the value set on the _OI-strength_slider present on the interface (Dweck & Leggett, 1988; Wood & Bandura, 1989).

4)	Ability update _This process increases the student_ ability on the task if the student successfully performed the task.

	a.	The level of ability increase is determined by the world attribute _earning Bonus;_this variable can be changed to a value between 0 and 1 through the slider present in the interface. This allows the user to modify the impact that success has on ability based on their own conceptions of how those factors interact.

	b.	If the student has a high perception of task difficulty AND a high level of self-efficacy, the student receives a boost in ability based on the world attribute value of _erceived Difficulty Effect._If the student has a low perception of task difficulty AND a low level of self-efficacy, the student receives a reduction in ability (Bandura, 1982).

5)	Experience update _This process increases the students_experience value after having performed on the task

6)	[Plotting] _After all of the values have been updated after a performance, the values will be plotted for each student on the Self-Efficacy, Ability-Level, Effort-Expenditure, and Outcomes plots.

	a.	The Self-Efficacy, Ability-Level, and Effort-Expenditure plots represent the students_values (0 to 100) on the y-axis and time (in performances) on the x-axis

	b.	The Outcomes plot charts the aggregate difference between successes and failures on the y-axis and time (in performances) on the x-axis. That is, a value of 30 represents the student has 30 more successes than failures, whereas a value of -30 represents the student has 30 more failures than successes.


HOW TO USE IT
-------------

Import Student List

This button allows the user to select a student list created using the Student Setup tool. Once a list is selected, all of the students, helpers, and their values will be imported for use in the present model.

Perform task/update efficacy button

This button simulates a single task trial for all students.

Perform/update x100

This button simulates 100 subsequent trials of performance for all students.

Update Student/Helper

	These buttons allow the user to pick a student (represented by a number mapping to the order in which the student was created) and change the students' (or helpers') initial values for the current model only. This update WILL NOT change the students_values that are coded in the student list file. The user has the option to modify starting self-efficacy, starting effort expenditure, or starting ability level.

See Student Attributes

	Clicking this button will provide a list of attribute values for the student currently selected in the Student Number box. This list will appear in the command prompt, and represents the most recent values for that student; these values will likely change after a single performance. This button can be extremely helpful to see what level students start at, or to get a better idea of some of the attribute values that are not represented in the plots.

Reset/Clear

	The _eset_button will reset all student values back to the values present in the student list file (or to the values modified through the update student button), including task experience and outcome totals. The _lear_button will remove all students from the screen and allow the user an opportunity to import a different student list.


THINGS TO NOTICE
----------------
What is the effect of changing the theory of intelligence that the student holds? What other variables become more or less sensitive to change given the theory of intelligence?

If a student has a high level of self-efficacy and also views the task as being difficult, what do you think will happen to the student_ effort expenditure? Think about how a _mart_student acts leading up to a difficult exam to frame your answer.


THINGS TO TRY
-------------

EXTENDING THE MODEL
-------------------


NETLOGO FEATURES
----------------


RELATED MODELS
--------------
StudentSetup.nlogo
SelfEfficacyModel_1.nlogo
SelfEfficacyModel_3.nlogo
SelfEfficacyModel_4.nlogo
SelfEfficacyModel_5.nlogo

CREDITS AND REFERENCES
----------------------

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person graduate
false
0
Circle -16777216 false false 39 183 20
Polygon -1 true false 50 203 85 213 118 227 119 207 89 204 52 185
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -8630108 true false 90 19 150 37 210 19 195 4 105 4
Polygon -8630108 true false 120 90 105 90 60 195 90 210 120 165 90 285 105 300 195 300 210 285 180 165 210 210 240 195 195 90
Polygon -1184463 true false 135 90 120 90 150 135 180 90 165 90 150 105
Line -2674135 false 195 90 150 135
Line -2674135 false 105 90 150 135
Polygon -1 true false 135 90 150 105 165 90
Circle -1 true false 104 205 20
Circle -1 true false 41 184 20
Circle -16777216 false false 106 206 18
Line -2674135 false 208 22 208 57

person student
false
0
Polygon -13791810 true false 135 90 150 105 135 165 150 180 165 165 150 105 165 90
Polygon -7500403 true true 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 100 210 130 225 145 165 85 135 63 189
Polygon -13791810 true false 90 210 120 225 135 165 67 130 53 189
Polygon -1 true false 120 224 131 225 124 210
Line -16777216 false 139 168 126 225
Line -16777216 false 140 167 76 136
Polygon -7500403 true true 105 90 60 195 90 210 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="100" runMetricsEveryStep="true">
    <setup>reset
hack-setup</setup>
    <go>go-100</go>
    <exitCondition>task-counter = 200</exitCondition>
    <metric>[self-efficacy-level] of student 0</metric>
    <metric>[self-efficacy-level] of student 1</metric>
    <enumeratedValueSet variable="Task-Difficulty">
      <value value="50"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
