breed [rats rat]
breed [hawks hawk]

rats-own [energy
  age-of-maturity
  age
  body-size
  fecundity            
  energy-to-reproduce
  time-to-reproduce
  number-of-litters
  energy-loss-per-tick
  energy-gain-from-food
  time-since-last-birth
  max-energy
  offspring-age-of-maturity
  offspring-time-to-reproduce
  offspring-fecundity
  offspring-energy-to-reproduce]


patches-own [pcounter
  grass]

globals [  
  mean-bodysize-list
  mean-fecundity-list
  mean-ageofmaturity-list
  mean-energytoreproduce-list
  mean-timetoreproduce-list]

to setup
  clear-all
  set-default-shape rats "mouse side"
  set-default-shape hawks "hawk"
  create-rats number-of-rats [
    set color yellow
    setxy random-xcor random-ycor
    set-values-initial
   ]
  
  create-hawks number-of-hawks [
    set color red
    setxy random-xcor random-ycor
    set size 2 ]

   ask patches [set pcolor green
     set pcounter random regrowth-time]       
  


  set mean-bodysize-list []
  set mean-fecundity-list []
  set mean-ageofmaturity-list [] 
  set mean-energytoreproduce-list []
  set mean-timetoreproduce-list []
end

to set-values-initial
  set age-of-maturity initial-age-of-maturity
  set fecundity  initial-fecundity 
  set time-to-reproduce initial-time-to-reproduce
  set energy-to-reproduce initial-energy-to-reproduce
    
  set age random age-of-maturity
  set body-size 1
  set size  (body-size ^ .334)    ;;body-size is representative of weight, while "size" is closer to length. They scale with a .334 power
  set number-of-litters 0 
  set energy 10.35 * body-size ^ 0.92 ;;integral of energy-gain - energy-loss from 0 to body-size

end

;--------------------

to go
  mature                               ;grow
  ask rats [
    eat                                ;then eat (gain E)
    move-rats                          ;then move (lose E)
    set age age + 1]
  reproduce                            ;then reproduce (maybe)
  check-hawks
  ask hawks [
    move-hawks
    eat-rats]
  ask patches [

  set pcounter pcounter + 1]
  ask patches with [ (pcolor = brown) and ( pcounter > regrowth-time)] [
    set pcolor green]
  if not any? rats [stop]
  ask links [die]
  tick


  update-means
  update-plots
end


;----------------------
; rat procedures




to eat
  set energy-gain-from-food (10 * ((body-size)) ^ .67)
  if [pcolor] of patch-here = green [
    set energy energy + energy-gain-from-food
    ask patch-here [set pcolor brown
      set pcounter 0]]

end


to move-rats
  ask rats with [color = yellow] [set energy-loss-per-tick (6 * ((body-size)) ^ .72)]
  rt random 45
  lt random 45
  fd body-size ^ .24           ;;after Calder 1983
  set energy energy - energy-loss-per-tick
  ask rats with [energy < 0] [die]                    ;;this is where, if energy < 0, rats die
end


to mature
  ask rats with [color = yellow] [
    set body-size body-size + .42 * (body-size) ^ .75         ;;Hill and Haruto
    set size  (body-size ^ .334) 
    
  
    if age > age-of-maturity [
      set color white
      set energy-loss-per-tick (6 * ((body-size)) ^ .67)
      set time-since-last-birth time-to-reproduce
      set number-of-litters 0
      set max-energy 10.35 * body-size ^ 0.92]]  ;;integral of dE/dW from 0 to size of rat

end




to reproduce
  ask rats with [color = white ] [set time-since-last-birth time-since-last-birth + 1]               
  ask rats with [ (color = white) and (time-since-last-birth > time-to-reproduce) ][
    set color 26]
  ask rats with [color = 26][
      if energy > max-energy [set energy max-energy]
      ifelse energy-to-reproduce > energy [ set energy 0
        set time-since-last-birth 0
        set color white]
      
      [if any? other rats with [color != yellow] in-radius size [
        create-link-to one-of other rats with [color != yellow] in-radius size
        
        set offspring-age-of-maturity ([age-of-maturity] of self + first [age-of-maturity] of out-link-neighbors) / 2
        set offspring-time-to-reproduce ([time-to-reproduce] of self + first [time-to-reproduce] of out-link-neighbors) / 2
        set offspring-fecundity ([fecundity] of self + first [fecundity] of out-link-neighbors) / 2
        set offspring-energy-to-reproduce ([energy-to-reproduce] of self + first [energy-to-reproduce] of out-link-neighbors) / 2
      
        set time-since-last-birth 0
        set number-of-litters number-of-litters + 1
      hatch fecundity [
        set color yellow
        set-values-offspring
        set heading random 360
        fd 1
        ]
       set color white
      set energy energy - energy-to-reproduce
      ]]]
      
      
end

to set-values-offspring
  set age 0

                                                                               
  set energy (energy-to-reproduce / (fecundity) )     ;;parental investment, where we estimate that Emet covers the Emet of offspring too
  
  set body-size 0.08 * energy ^ 1.09
  

  set age-of-maturity random-normal offspring-age-of-maturity 2
  set energy-to-reproduce random-normal offspring-energy-to-reproduce 2
  set time-to-reproduce random-normal offspring-time-to-reproduce 2
  set fecundity random-normal offspring-fecundity 1
  
  if peg-aom? [set age-of-maturity initial-age-of-maturity]
  if peg-fec? [set fecundity initial-fecundity]
  if peg-ttr? [set time-to-reproduce initial-time-to-reproduce]
  if peg-etr? [set energy-to-reproduce initial-energy-to-reproduce]
  
  set size (body-size ^ .334)

end






;--------------------------
; hawk procedures


to move-hawks
  rt random 45
  lt random 45
  fd 1
end

to eat-rats
  
  ifelse eat-only-adults? [
    set eat-only-kids? false
    if any? rats-here with [color != yellow] [
      ask one-of rats-here with [color != yellow] [die]]]
  [
  ifelse eat-only-kids? [
    if any? rats-here with [color = yellow] [
      ask one-of rats-here with [color = yellow] [die]]]
  [if any? rats-here [
    ask one-of rats-here [die]]
  ]]
end
   

to check-hawks                               ;;adjusts hawk number mid-run
  if count hawks != number-of-hawks [
    ifelse count hawks > number-of-hawks [
      ask n-of (count hawks - number-of-hawks) hawks [die]]
    [create-hawks (number-of-hawks - count hawks) [
            set color red
            setxy random-xcor random-ycor
            set size 2]]]
end 




;---------------------------------
;grass procedures



to regrow
  set pcounter pcounter + 1
  ask patches with [ pcounter > regrowth-time] [
    set pcolor green]
end

;-----------------------------
;other procedures

to update-plots
  if any? rats with [color != yellow] [

  set-current-plot "body-size"
    plot mean mean-bodysize-list
    
  set-current-plot "energy-to-reproduce"
    plot mean mean-energytoreproduce-list
    
  set-current-plot "fecundity"
    plot mean mean-fecundity-list
  
  set-current-plot "age-of-maturity"
    plot mean mean-ageofmaturity-list
  
  set-current-plot "time-to-reproduce"
    plot mean mean-timetoreproduce-list
    
    ]
  
  
  set-current-plot "population"
  set-current-plot-pen "total"
  plot count rats
  set-current-plot-pen "adult"
  plot count rats with [color != yellow]
  set-current-plot-pen "juvenile"
  plot count rats with [color = yellow]
  
end


to update-means
  if any? rats with [color != yellow ] [
    
    set mean-bodysize-list lput (mean [body-size] of rats with [color != yellow]) mean-bodysize-list
    if (length mean-bodysize-list > 100) [set mean-bodysize-list but-first mean-bodysize-list]
    
    set mean-fecundity-list lput (mean [fecundity] of rats with [color != yellow]) mean-fecundity-list
    if (length mean-fecundity-list > 100) [set mean-fecundity-list but-first mean-fecundity-list]
    
    set mean-ageofmaturity-list lput (mean [age-of-maturity] of rats with [color != yellow]) mean-ageofmaturity-list
    if (length mean-ageofmaturity-list > 100) [set mean-ageofmaturity-list but-first mean-ageofmaturity-list]
    
    set mean-energytoreproduce-list lput (mean [energy-to-reproduce] of rats with [color != yellow]) mean-energytoreproduce-list
    if (length mean-energytoreproduce-list > 100) [set mean-energytoreproduce-list but-first mean-energytoreproduce-list]
    
    set mean-timetoreproduce-list lput (mean [time-to-reproduce] of rats with [color != yellow]) mean-timetoreproduce-list
    if (length mean-timetoreproduce-list > 100) [set mean-timetoreproduce-list but-first mean-timetoreproduce-list]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
198
10
646
479
36
36
6.0
1
10
1
1
1
0
1
1
1
-36
36
-36
36
1
1
1
ticks

BUTTON
15
10
78
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
80
10
143
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
16
47
188
80
number-of-rats
number-of-rats
0
100
31
1
1
NIL
HORIZONTAL

SLIDER
15
385
187
418
number-of-hawks
number-of-hawks
0
50
0
1
1
NIL
HORIZONTAL

SLIDER
15
90
187
123
initial-age-of-maturity
initial-age-of-maturity
0
100
36
1
1
NIL
HORIZONTAL

SLIDER
15
160
187
193
initial-fecundity
initial-fecundity
0
15
2
1
1
NIL
HORIZONTAL

SLIDER
15
230
187
263
initial-time-to-reproduce
initial-time-to-reproduce
0
100
22
1
1
NIL
HORIZONTAL

SLIDER
15
300
187
333
initial-energy-to-reproduce
initial-energy-to-reproduce
0
100
23
1
1
NIL
HORIZONTAL

SWITCH
15
420
145
453
eat-only-kids?
eat-only-kids?
1
1
-1000

PLOT
660
310
1015
460
population
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"total" 1.0 0 -16777216 true
"adult" 1.0 0 -7500403 true
"juvenile" 1.0 0 -1184463 true

SWITCH
15
455
145
488
eat-only-adults?
eat-only-adults?
1
1
-1000

SLIDER
15
505
187
538
regrowth-time
regrowth-time
0
100
67
1
1
NIL
HORIZONTAL

TEXTBOX
660
470
1120
526
all plots except population are of moving averages (100 ticks)for adult (reproducing) rats 
11
0.0
1

SWITCH
15
125
125
158
peg-aom?
peg-aom?
1
1
-1000

SWITCH
15
195
119
228
peg-fec?
peg-fec?
1
1
-1000

SWITCH
15
265
118
298
peg-ttr?
peg-ttr?
1
1
-1000

SWITCH
15
335
118
368
peg-etr?
peg-etr?
1
1
-1000

PLOT
660
10
920
160
fecundity
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -2674135 true

PLOT
920
10
1180
160
time-to-reproduce
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -955883 true

PLOT
660
160
920
310
body-size
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -13345367 true

PLOT
920
160
1180
310
age-of-maturity
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -8630108 true

PLOT
1015
310
1180
460
energy-to-reproduce
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

@#$#@#$#@
WHAT IS IT?
-----------
The Evolving Life Histories model that explores how traits related to the life-cycle of animals evolve under different conditions.


HOW IT WORKS
------------
The evolving agents in this model are rats. Rats can eat, grow, mature, reproduce, and die by starvation or as hawk prey. Depending on the environmental conditions, rats will evolve to have different life history variables.

The evolving variables that belong to each rat are:

-AGE-OF-MATURITY: the age at which the juvenile (yellow) stage ends, growth stops, and reproduction begins. After AGE-OF-MATURITY, the rats are adults and turn white.
-FECUNDITY: the number of juvenile rats created each time an adult rat reproduces.
-ENERGY-T0-REPRODUCE: the minimum ammount of energy needed to reproduce.
-TIME-TO-REPRODUCE: the time that must elapse before an adult rat can reproduce again. When it passes, a rat turns orange and looks for another adult rat nearby to mate with. 

When a rat finds a mate, it produces juveniles with new variable values. These four variables are set by a normal distribution around the mean of the two parental values. This allows the variables to "mutate", which is necessary for evolutionary change.

Rats are also given a certain ammount of energy at birth, proportional to the mother's ENERGY-TO-REPRODUCE / FECUNDITY. They are also given a BODY-SIZE, proportional to the ammount of energy they have.

As a juveile rat grow, its BODY-SIZE increases by 0.42*BODY-SIZE^.75 each tick. 

The ENERGY value of a rat is controlled by the available food and the metabolic rate. The amount of energy a rat can eat each tick scales to body-size at 10*BODY-SIZE^0.67. For adults, the metabolic rate scales to body-size at 6*BODY-SIZE^0.67. In juveniles, who have extra energy costs for growth, metabolic rate scales to 6*BODY-SIZE^0.72. A rat can only gain ENERGY if the patch they are standing on is green; if they eat the patch, the patch turns brown and will not turn green again until REGROWTH-TIME. The rats lose ENERGY every single tick.

At reproduction, a rat also loses ENERGY-TO-REPRODUCE. If ENERGY < 0, the rat dies.

Hawk populations never change unless changed by the user. Hawks will eat one rat if there is a rat below them.


HOW TO USE IT
-------------
You can adjust the initial number of rats and hawks on the left.

Adjust the initial values for evolving variables with the sliders on the left. If you want to make it so the rats all have the same value throughout the run, turn the coresponding PEG-<variable>? switch ON after you chose the initial value. This variable will not evolve.

If you want to make the hawks eat only adults or only juveniles, adjust the EAT-ONLY-ADUTLS? and EAT-ONLY-JUVENILES? switches on the left. If both are off, the hawks will eat all rats.

Adjust the REGROWTH-TIME of the patches with the slider on the left.

The graphs on the left show the moving averages (for the last 100 ticks) of the evolvable variables and body size. 

THINGS TO NOTICE
----------------
If you introduce a sudden change in environmental variables (NUMBER-OF-HAWKS or REGROWTH-TIME), the population will often grow quickly, or drop rapidly followed by a rapid regrowth period. Watch the variables when this happens. How do they change?


THINGS TO TRY
-------------
Peg one of the variables at high or low values and let the others evolve. See how changing the pegged variable causes changes in the other variables. Which variables seem more important?

Increase the number of hawks slowly over time. Do you see any trends in the evolvable variables?

EXTENDING THE MODEL
-------------------
Right now, all rats give birth and can mate with any other adult rat. Try adding males into the model. Add in sexual dimorphism. What changes about the model?

Rats move around the view randomly, and cannot seek out food if they are starving. What happens if you give them the ability to head towards green patches preferentially?

Natural populations often experience cyclical changes in climate and predation. Do these changes affect life history traits in any way?

Drift and population size can significantly effect how populations evolve. Try putting the evolvability of the variables (the size of the standard deviation) on a slider, or adjusting the number of patches to support larger populatoins. How does the evolution of these life history traits change?


CREDITS AND REFERENCES
----------------------
Model created by Vince FitzPatrick for EECS 372: DESIGNING AND CONSTRUCTING MODELS WITH MULTI-AGENT LANGUAGES. Special thanks to Uri Wilensky, Forrest Stonedahl, Aleata Hubbard and Winston Chang.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

hawk
true
0
Polygon -7500403 true true 151 170 136 170 123 229 143 244 156 244 179 229 166 170
Polygon -16777216 true false 152 154 137 154 125 213 140 229 159 229 179 214 167 154
Polygon -7500403 true true 151 140 136 140 126 202 139 214 159 214 176 200 166 140
Polygon -16777216 true false 151 125 134 124 128 188 140 198 161 197 174 188 166 125
Polygon -7500403 true true 152 86 227 72 286 97 272 101 294 117 276 118 287 131 270 131 278 141 264 138 267 145 228 150 153 147
Polygon -7500403 true true 160 74 159 61 149 54 130 53 139 62 133 81 127 113 129 149 134 177 150 206 168 179 172 147 169 111
Circle -16777216 true false 144 55 7
Polygon -16777216 true false 129 53 135 58 139 54
Polygon -7500403 true true 148 86 73 72 14 97 28 101 6 117 24 118 13 131 30 131 22 141 36 138 33 145 72 150 147 147

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

mouse side
false
0
Polygon -7500403 true true 38 162 24 165 19 174 22 192 47 213 90 225 135 230 161 240 178 262 150 246 117 238 73 232 36 220 11 196 7 171 15 153 37 146 46 145
Polygon -7500403 true true 289 142 271 165 237 164 217 185 235 192 254 192 259 199 245 200 248 203 226 199 200 194 155 195 122 185 84 187 91 195 82 192 83 201 72 190 67 199 62 185 46 183 36 165 40 134 57 115 74 106 60 109 90 97 112 94 92 93 130 86 154 88 134 81 183 90 197 94 183 86 212 95 211 88 224 83 235 88 248 97 246 90 257 107 255 97 270 120
Polygon -16777216 true false 234 100 220 96 210 100 214 111 228 116 239 115
Circle -16777216 true false 246 117 20
Line -7500403 true 270 153 282 174
Line -7500403 true 272 153 255 173
Line -7500403 true 269 156 268 177

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment3" repetitions="3" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="25000"/>
    <exitCondition>count rats = 0</exitCondition>
    <metric>count turtles</metric>
    <metric>mean mean-bodysize-list</metric>
    <metric>mean mean-fecundity-list</metric>
    <metric>mean mean-ageofmaturity-list</metric>
    <metric>mean mean-timetoreproduce-list</metric>
    <metric>mean mean-energytoreproduce-list</metric>
    <enumeratedValueSet variable="peg-aom?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-time-to-reproduce">
      <value value="22"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-rats">
      <value value="35"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-age-of-maturity">
      <value value="31"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-fec?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-etr?">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="initial-fecundity" first="1" step="1" last="8"/>
    <enumeratedValueSet variable="number-of-hawks">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate">
      <value value="1.048"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-ttr?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eat-only-adults?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eat-only-kids?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-energy-to-reproduce">
      <value value="23"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="regrowth-time">
      <value value="67"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment4" repetitions="3" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="25000"/>
    <exitCondition>count rats = 0</exitCondition>
    <metric>count turtles</metric>
    <metric>mean mean-bodysize-list</metric>
    <metric>mean mean-fecundity-list</metric>
    <metric>mean mean-ageofmaturity-list</metric>
    <metric>mean mean-timetoreproduce-list</metric>
    <metric>mean mean-energytoreproduce-list</metric>
    <enumeratedValueSet variable="peg-aom?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-hawks">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-ttr?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-age-of-maturity">
      <value value="31"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-fec?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate">
      <value value="1.048"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eat-only-kids?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-etr?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-energy-to-reproduce">
      <value value="23"/>
    </enumeratedValueSet>
    <steppedValueSet variable="initial-time-to-reproduce" first="1" step="5" last="50"/>
    <enumeratedValueSet variable="number-of-rats">
      <value value="31"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="regrowth-time">
      <value value="67"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-fecundity">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eat-only-adults?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment1" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="25000"/>
    <exitCondition>count rats = 0</exitCondition>
    <metric>count turtles</metric>
    <metric>mean mean-bodysize-list</metric>
    <metric>mean mean-fecundity-list</metric>
    <metric>mean mean-ageofmaturity-list</metric>
    <metric>mean mean-timetoreproduce-list</metric>
    <metric>mean mean-energytoreproduce-list</metric>
    <enumeratedValueSet variable="peg-aom?">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="number-of-hawks" first="0" step="1" last="50"/>
    <enumeratedValueSet variable="peg-ttr?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-age-of-maturity">
      <value value="31"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-fec?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate">
      <value value="1.048"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eat-only-kids?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="peg-etr?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-energy-to-reproduce">
      <value value="23"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-time-to-reproduce">
      <value value="22"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-of-rats">
      <value value="31"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="regrowth-time">
      <value value="67"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-fecundity">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="eat-only-adults?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
