breed [alfa_cestice alfa_cestica]

breed [vektori_brzine vektor_brzine]


alfa_cestice-own
[dV_x dV_z d_x d_z dt k Q_1 m F_z F_x  r V_x V_z]


globals
[Q_2 F brzina_x brzina_z brzina_V_x brzina_V_z]

to setup
  clear-all
  setup-pozadina
  setup-cestica
  reset-ticks
end

to setup-cestica
  create-alfa_cestice broj_alfa_cestica
  ask alfa_cestice
  [
    set V_z brzina_alfa_cestica
    set shape "circle" 
    set size 0.5
    set color red
  
    ifelse (broj_alfa_cestica = 1)
    [
    set xcor pocetni_polozaj
    set ycor 0
    set zcor -30
    ]
    
    [
      set xcor (- broj_alfa_cestica  + who - 1)
      set ycor 0
      set zcor -30
    ]
    
  ]
end

to setup-pozadina
  create-turtles 4
  ask turtle 0
  [
    setxyz 0 0 0 
    set shape "circle" 
    set size 1
    set color yellow
  ]
  
  ask turtle 1
  [
    setxyz 0 0 0
    set shape "strelica x-os"
    set color white
    set size 15
    set heading 90
    set roll 90
  ]
  ask turtle 2
  [
    setxyz 0 0 0
    set shape "strelica y-os"
    set color white
    set size 15
    set heading 0
  ]
  ask turtle 3
  [
    setxyz 0 0 0
    set shape "strelica z-os"
    set color white
    set size 15
    set heading 0
    set pitch 90
  ]
  
end

to go
  ask alfa_cestice
  [
    unos
    izracun
    if (abs(zcor) > 30) or (abs(xcor) > 29)
    [
    die
    ]
  ]
  
  ifelse (broj_alfa_cestica = 1)
    [
      if (pokazi_vektor_brzine?)
      [
        vektor-brzine
      ]
      if (pokazi_putanju?)
      [
        ask alfa_cestice
         [
          pen-down
         ]
      ]
    ]
    [
     if (pokazi_putanju?)
          [
            ask alfa_cestice
            [
            pen-down 
            set color (2 * who + 1) * 5
            ] 
          ]
      
    ]
        
    tick
end

to unos
  set dt 0.001
  set k (8.99)
  set Q_1 (2 * 1.6)
  set Q_2 (broj_protona * 1.6)
  set m (6.64)
end


to izracun
  set d_z (V_z * dt)
  set zcor (zcor + d_z)
  set r (sqrt(xcor ^ 2 + zcor ^ 2)) 
  set F (((k * Q_1 * Q_2) / r ^ 2))
  set F_x (F * (xcor / r))
  set F_z (F * (zcor / r))
  set dV_x ((F_x * dt) / m)
  set dV_z ((F_z * dt) / m)
  set V_x (V_x + dV_x)
  set V_z (V_z + dV_z)
  set d_x (V_x * dt)
  set d_z (V_z * dt)
  set xcor (xcor + d_x)
  set zcor (zcor + d_z)
  set brzina_x xcor
  set brzina_z zcor
  set brzina_V_x V_x
  set brzina_V_z V_z
end

to vektor-brzine
  create-vektori_brzine 3
      ask vektori_brzine  
      [
        ifelse (abs(brzina_z) > 30) or (abs(brzina_x) > 29)
        [
          die
        ]
        
        [
          
        ask vektor_brzine 5
        [
        set xcor brzina_x
        set zcor brzina_z
        set shape "strelica V" 
        set color gray
        set size (sqrt(brzina_V_x ^ 2 + brzina_V_z ^ 2)) / 5
        set heading 90
        set pitch (atan (brzina_V_z) (brzina_V_x))
        set roll 90
        ]
        
        ask vektor_brzine 6
        [
          set xcor brzina_x
          set zcor brzina_z
          set shape "strelica V_x"
          set color blue
          set size brzina_V_x / 5
          set heading 90
          set roll 90
        ]
        
        ask vektor_brzine 7
        [
          set xcor brzina_x
          set zcor brzina_z
          set shape "strelica V_z"
          set color green
          set size brzina_V_z / 5
          set heading 0
          set pitch 90
        ]
        ]
      ]
end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
245
91
30
30
1.0
1
10
1
1
1
0
1
1
1
-30
30
-30
30
-30
30
1
1
1
ticks
30.0

BUTTON
13
46
76
79
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
109
46
172
79
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
13
106
185
139
broj_alfa_cestica
broj_alfa_cestica
1
50
1
1
1
NIL
HORIZONTAL

SLIDER
11
209
183
242
brzina_alfa_cestica
brzina_alfa_cestica
10
100
30
1
1
NIL
HORIZONTAL

SLIDER
10
260
182
293
broj_protona
broj_protona
79
150
79
1
1
NIL
HORIZONTAL

SLIDER
12
163
184
196
pocetni_polozaj
pocetni_polozaj
-10
10
1.2
0.1
1
NIL
HORIZONTAL

SWITCH
206
105
385
138
pokazi_vektor_brzine?
pokazi_vektor_brzine?
0
1
-1000

MONITOR
350
360
443
405
kut rasprsenja
(atan (brzina_V_z) (brzina_V_x)) - 90
3
1
11

MONITOR
367
229
424
274
brzina V
sqrt(brzina_V_x ^ 2 + brzina_V_z ^ 2)
3
1
11

MONITOR
366
164
423
209
sila
F
3
1
11

MONITOR
243
276
366
321
komponenta brzine V_x
brzina_V_x
3
1
11

SWITCH
404
105
550
138
pokazi_putanju?
pokazi_putanju?
0
1
-1000

MONITOR
425
276
548
321
komponenta brzine V_z
brzina_V_z
3
1
11

@#$#@#$#@
## WHAT IS IT?

Ovo je trodimenzionalni model koji simulira raspr_enje jezgre atoma helija (alfa _estica) na jezgri atoma zlata. Ovaj primjer raspr_enja naziva se Rutherfordovo raspr_enje po engleskom kemi_aru i fizi_aru Ernestu Rutherfordu _iji je eksperiment otkrio postojanje pozitivno nabijene jezgre atoma i doveo do razvoja planetarnog modela, a kasnije i do Bohrovog modela atoma.

## HOW IT WORKS

Pokretni agent (breed 'alfa_cestice') predstavlja jezgru atoma helija i prikazan je kao kugla crvene boje koja se u xyz koordinatnom sustavu giba u xz ravnini u pozitivnom smjeru osi z. Alfa _estica ima zadanu po_etnu brzinu V_z, masu m i naboj Q1. Agent koji miruje (turtle) predstavlja jezgru atoma zlata i prikazan je kao kugla _ute boje s polo_ajem (0, 0, 0) u xyz koordinatnom sustavu. Jezgra atoma zlata ima zadan ukupan naboj Q2 koji se mo_e mijenjati ovisno o broju protona u jezgri. 
Alfa _estica giba se jednoliko pravocrtno po_etnom brzinom V koja je po iznosu i smjeru jednaka komponenti brzine V_z sve dok na nju ne djeluje odbojna elektri_na sila jezgre atoma zlata. Jednad_ba koju ovdje koristimo naziva se Coulombov zakon i glasi: F = (k * Q1 * Q2) / r2 Kao _to vidimo iz jednad_be sila F zavisi obrnuto proporcionalno o kvadratu udaljenosti r izme_u alfa _estice i jezgre atoma zlata. _to je je alfa _estica bli_e jezgri zlata sila je sve ve_a. Sila F je radijalna i djeluje na alfa _esticu tako da joj mijenja smjer gibanja, odnosno mijenja iznos V_z i V_x komponente brzine. Promjenu smjera gibanja bilje_imo kao kut raspr_enja _ koji je u stvari kut izme_u smjera gibanja alfa _estice i pozitivnog smjera z osi. 

## HOW TO USE IT

Pomo_u kliza_a 'broj_alfa_cestica' odre_ujemo broj alfa _estica koje se gibaju prema jezgri atoma zlata. Ako postavimo kliza_ na 1, tada imamo dodatnu mogu_nost odre_ivanja po_etnog polo_aja alfa _estice putem kliza_a 'pocetni_polozaj'. Uz to, koriste_i prekida_ 'pokazi_vektor-brzine?', mo_emo promatrati V_x i V_z vektorske komponente brzine kao i rezultantni vektor brzine V.
Pomo_u kliza_a 'brzina_alfa_cestice' odre_ujemo po_etnu brzinu alfa cestice/a.
Kliza_ 'broj_protona' omogu_ava nam promjenu broja protona u jezgri atoma zlata _to direktno utje_e na ukupan naboj jezgre Q2, a samim tim i na silu F izme_u alfa _estice i jezgre atoma zlata.
Pomo_u prekida_a 'pokazi_putanju?' biramo da li _e putanja gibanja alfa _estice/a biti vidljiva ili ne. 
Pritiskom na tipku 'setup' stvorit _e se alfa _estica (crvena kugla) i jezgra atoma helija (_uta kugla).
Pritiskom na tipku 'go' simulacija se pokre_e i alfa _estica se po_inje gibati prema jezgri atoma zlata.

## THINGS TO NOTICE

Korisni_ko su_elje sadr_i nekoliko monitora. 
Monitor 'sila' omogu_ava korisniku da uo_i kako se mijenja iznos sile ovisno o udaljenosti alfa _estice i jezgre atoma zlata.
Monitor 'brzina V' prikazuje iznos rezultantne brzine alfa _estice dok monitori 'brzina V_x' i 'brzina V_z' prikazuju iznose komponenenata V_x i V_z. 
Monitor 'kut raprsenja' prikazuje iznos kuta za koji se alfa _estica otklonila od po_etnog smjera gibanja.

## THINGS TO TRY

Pomo_u navedenih kliza_a, korisnik mo_e mijenati po_etni polo_aj, po_etnu brzinu i broj broj protona u jezgri atoma zlata i promatrati kako pojedine promjene utje_u na iznos sile F i kut raspr_enja _.

## EXTENDING THE MODEL

Model se mo_e nadograditi tako da dodamo grafi_ki prikaz vektora sile F i njenih komponenenata F_x i F_z. Osim toga mo_e se dodati i graf kineti_ke, potencijalne i ukupne energije alfa _estice. 

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 -150 90 -30 135 -30 135 150 165 150 165 -30 210 -30

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

strelica v
true
0
Line -7500403 true 150 -30 150 150
Line -7500403 true 150 -30 135 15
Line -7500403 true 150 -30 165 15
Line -7500403 true 105 30 135 45
Line -7500403 true 135 45 105 60

strelica v_x
true
0
Line -7500403 true 150 -30 150 150
Line -7500403 true 150 -30 135 15
Line -7500403 true 150 -30 165 15
Line -7500403 true 165 60 195 75
Line -7500403 true 195 45 165 60
Line -7500403 true 180 30 165 45
Line -7500403 true 165 30 180 45

strelica v_z
true
0
Line -7500403 true 150 -15 150 150
Line -7500403 true 150 -30 135 15
Line -7500403 true 150 -30 165 15
Line -7500403 true 105 45 135 60
Line -7500403 true 135 60 105 75
Line -7500403 true 120 75 120 90
Line -7500403 true 120 90 135 75
Line -7500403 true 135 75 135 90

strelica x-os
true
0
Line -7500403 true 150 -30 150 150
Line -7500403 true 150 -30 135 15
Line -7500403 true 150 -30 165 15
Line -7500403 true 135 30 105 60
Line -7500403 true 105 30 135 60

strelica y-os
true
0
Line -7500403 true 150 -30 165 15
Line -7500403 true 150 -30 150 150
Line -7500403 true 150 -30 135 15
Line -7500403 true 135 45 120 60
Line -7500403 true 105 45 120 60
Line -7500403 true 120 75 120 60

strelica z-os
true
0
Line -7500403 true 150 -30 150 150
Line -7500403 true 150 -30 135 15
Line -7500403 true 150 -30 165 15
Line -7500403 true 105 45 105 75
Line -7500403 true 105 75 135 45
Line -7500403 true 135 75 135 45

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 3D 5.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
