globals 
[ humorcheck
  angercheck
  infocheck
  sadcheck
  roundcheck
  numberwatch
  randomcount
]
turtles-own
[
  shared?         ;; if true, the turtle has shared the content
  watched?          ;; if true, the turtle has seen the content and has/has not shared it yet
  contcheck   ;; number of times content has been viewed
  funny
  anger
  sad             ;; evoking the primal emtions to what degree -- could maybe be one attribute : emotion 
  savvy           ;; How connected are you? will you "get" the content in a sense           ;; slightly linked to arousal but also intrinsic to the person- how enthusiastically are you going to share this video?
  arousal         ;; a culmination of emotions, visibility and other factors --> to share or not to share
]

to setup
  clear-all
  
 
  setup-nodes
  setup-spatially-clustered-network
  
  ask turtles [set shared? false]
  ask turtles [set watched? false]
  ask turtles [set anger random 100 / 100]
  ask turtles [set sad random 100 / 100]
  ask turtles [set funny random 100 / 100]      ;; I want arousal to almost be a 6-point scale that determines sharing- one person's enthusiasm ashould also perhaps directly feed another's more directly? endorsement vs. just passive sharing effect
  
  ask turtles [if funny < 0.5 [ set funny funny + 0.4]];  ;; humor is a pretty universal attribute -even people who don't find most things funny respond to humor more than other emotions. 
 ;; ask turtles [if anger < 0.5 [ set anger anger + 0.3]]       ;; trying to make homophily more relevant means the gradient in people's emotions probably needs to be higher. 
 ;; ask turtles [if sad < 0.5 [ set sad sad + 0.1]]
  
  
  ask turtles [set contcheck 0]
  
  if homophily? [
  
  ask turtles [ask link-neighbors [ if abs ([funny] of myself - funny) > 0.3 [set funny (funny + [funny] of myself) / 2 ] ] ]     ;;homophily? - people tend to be surrounded/friends with people similar to them- minimzing variances in their personality types- homophily?
  
  ask turtles [ask link-neighbors [ if abs ([anger] of myself - anger) > 0.3 [set anger (anger + [anger] of myself) / 2]]]
      
  ask turtles [ask link-neighbors [ if abs ([sad] of myself - sad) > 0.3 [set sad (sad + [sad] of myself) / 2]]]
          
  ]
  ifelse target?
   [ask n-of campaignlevel turtles [seecontent]][ask n-of campaignlevel turtles with [funny > 0.7 and anger > 0.7][seecontent]]               ;; This is effectively releasing the content across the internet  
  
  ;;ask links [ set color white ]                              ;; Do I care about the color of the links? Probably not, unless I'm doing re-transmission ie re-sharing..unlikely.
  reset-ticks
end 



to setup-nodes     
                                             ;; ALL OF THIS IS FROM VIRUSES
  set-default-shape turtles "circle"
  crt number-of-nodes                                         ;; NEED A SCALED DOWN VERSION OF THE WORLD. I might just make it a number that scales well based on say- the population of NA since most of my literature and research is definitely limited by that in a sense. 
  [
    ; for visual reasons, we don't put any nodes *too* close to the edges
    setxy (random-xcor * 0.95) (random-ycor * 0.95)
  ]
  ask turtles [set color white]              ;; No exposure to any content. Will be handled in  "go" 
  
  if supernode? [ask one-of turtles [set color blue set size 2 setxy (random-xcor * 0.5) (random-ycor * 0.5)]]   ;; someone at the center of the universe kind of like a celebrity - Jimmy Kimmel sent something viral all by himself - Gizmodo sends videos viral all the time - similar phenomena
  
end 




to setup-spatially-clustered-network
  
  let num-links (average-node-degree * number-of-nodes) / 2       
  while [count links < num-links ]                                ;; Note: While the links are created based on proximity in the code, it is not meant to be interpreted as such. It is just meant to serve as "internet proximity" 
  [                                                               ;; Can't tell if that would be an issue, but I'm guessing not at this point.    
    ask one-of turtles
    [
      let choice (min-one-of (other turtles with [not link-neighbor? myself])
                   [distance myself])
      if choice != nobody [ create-link-with choice ]
    ]
  ]
  ; make the network look a little prettier                     ;; I'll probably keep this since it does help with making the network look pretty. 
  repeat 30
  [
    layout-spring turtles links 0.3 (world-width / (sqrt number-of-nodes)) 1
  ]

end



to seecontent                                               ;; turtle procedure
  
  set watched? true
  
  set contcheck contcheck + 1   
  
  if contcheck = 1 [set color yellow]
  
  if contcheck > 1 and not shared? [set color 43] 
end 




to go 
  
  set randomcount randomcount + 1 
  while [roundcheck < rounds] [ifelse target? [ask n-of campaignlevel turtles with [funny > 0.5 and anger > 0.5][seecontent set roundcheck roundcheck + 1]][ask n-of campaignlevel turtles [seecontent set roundcheck roundcheck + 1 ]]]     
  
  ask turtles [if watched?[shareornot] ]     ;; once turtles see content, they can decide whether or not to share the content.      
  
  ifelse  vanger + vfunny - vsad + vutil > 20 [tick-advance 5] [ tick-advance 7]
  
  ask turtles [if shared? [set color red] ]
  
  set numberwatch count turtles with [watched?]
  
  if supernode? [ask turtles with [size = 2 and shared?] [share]] 
  
 if randomsparks? [if randomcount < 1000 [ if random 100 < 40 [ask one-of turtles [seecontent]]]]
  
  if hold? [ ask turtles [set color white set arousal 0 set shared? false set watched? false set contcheck 0 set roundcheck 0]]
  
  ask turtles [if hold? and size = 2 [set color blue]]
    
  tick
end 





to shareornot    ;; setting up a parameter that determines sharing, how fast sharing takes place

  ifelse vfunny > 5  [set humorcheck (vfunny - 4) * funny][set humorcheck 1 * funny ]
  ifelse vsad > 5 [set sadcheck (vsad - 4) * sad][set sadcheck 1 * sad ]
  ifelse vanger > 5 [set angercheck (vanger - 4) * sad]  [set angercheck 1 * anger]            ;; Getting the agent to decide if he will share or not. How important each attribute is to the agent vs. how much that's reflected in the content
 
  if contcheck > 1 and arousal > 1.5 [set arousal (arousal + (2 * arousal / (1 + contcheck) + arousal / (1 + contcheck) ^ 2))]     ;;The more often you see something will decide how much you value it as well. However this value will probably diminish slightly each time
  
  if contcheck = 1 [set arousal (0.42 * humorcheck - 0.3 * sadcheck + 0.35 * angercheck + 0.2 * vutil + 0.1 * repfreq)] ;;including how useful the content is as a parameter; also if it's second interaction with content, arousal levels add, but by smaller factors each time
   
  if arousal > 2.4 [share]   ;; Max. value possible 1.4. Just set a reasonable threshold?. will go from there based on results.            
end 




to share
  
  ifelse size < 2 [ask (link-neighbors) [seecontent]] [ask turtles in-radius 10 [seecontent]]
  
  set shared? true
  
 ;; set color red
end 
@#$#@#$#@
GRAPHICS-WINDOW
418
10
927
540
20
20
12.171
1
10
1
1
1
0
0
0
1
-20
20
-20
20
1
1
1
ticks
30.0

BUTTON
14
441
109
481
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
125
442
220
482
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
25
15
230
48
number-of-nodes
number-of-nodes
300
800
500
100
1
NIL
HORIZONTAL

SLIDER
25
85
230
118
campaignlevel
campaignlevel
1
round (number-of-nodes / 50)
2
1
1
NIL
HORIZONTAL

SLIDER
25
50
230
83
average-node-degree
average-node-degree
1
8
6
1
1
NIL
HORIZONTAL

SLIDER
21
341
193
374
vfunny
vfunny
0
10
7
1
1
NIL
HORIZONTAL

SLIDER
23
182
195
215
vsad
vsad
0
10
0
1
1
NIL
HORIZONTAL

SLIDER
23
231
195
264
vutil
vutil
0
10
5
1
1
NIL
HORIZONTAL

SLIDER
37
129
209
162
rounds
rounds
0
10
6
1
1
NIL
HORIZONTAL

SLIDER
23
288
195
321
vanger
vanger
0
10
1
1
1
NIL
HORIZONTAL

PLOT
944
34
1340
251
% watched over time
time
% of total watched
0.0
200.0
0.0
100.0
true
true
"" ""
PENS
"Number Watched" 1.0 0 -16777216 true "" "plot (count turtles with [watched?]) / (count turtles) * 100"
"Number shared" 1.0 0 -955883 true "" "plot (count turtles with [shared?]) / (count turtles) * 100"

SLIDER
22
397
194
430
repfreq
repfreq
0
10
1
1
1
NIL
HORIZONTAL

SWITCH
262
390
379
423
homophily?
homophily?
0
1
-1000

SWITCH
133
499
244
532
target?
target?
0
1
-1000

SWITCH
249
129
369
162
supernode?
supernode?
0
1
-1000

SWITCH
259
497
398
530
randomsparks?
randomsparks?
0
1
-1000

SWITCH
12
499
115
532
hold?
hold?
1
1
-1000

PLOT
972
300
1299
505
Spike
time
Number
0.0
10.0
0.0
200.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot (count turtles with [watched?])"

@#$#@#$#@
WHAT IS IT?
--------

This model, "Going Viral" attempts to explain the phenomenon of content going viral on the internet using ABM. How does each factor affect the agent's decisions? How does the setup of a network, homophily as well as marketing efficacy factor into this? 

HOW IT WORKS
------------

Rules: 

1) Agents are shown as nodes that form part of the network (internet) and content is introduced into this network.

2) Agents evaluate the content, which has attributes set by the user, against their own pre-determined emotional responses. They turn yellow once they view the video. 

3) The degree of emotional response determines if they will "Share" the video with others and how quickly they do so. They turn red upon sharing

4) Multiple interactions with the same video lead to a higher likeliohood of sharing since agents start to feel that the video is relevant to other people and perhaps acquired taste as a result of multiple views. 

HOW TO USE IT
-------------

PRE-SETUP

1) Set number-of-nodes, ie. how many people in network - I've been using 500 - it's clean and works pretty well. Higher or lower doesn't impact things too much.

2) Average-node-degree should be set. Higher numbers just make it more likely that the video will have a better chance at going viral --> more people to share with --> more shares etc. I set it at 6 for most of runs. I'd say 5-8 is a pretty good approx.

3) campaignlevel is the level at which the video is being advertised- how many people of your population get to watch the video when it is first released. The equivalent of an ad campaign

4) rounds - number of times the advertising campaign is run by the company or entity or person is sharing it on different websites, forums etc

5) Video parameters - vanger, vsad, vfunny are the basic emotions. 

vutil: level at which content inspires awe, a feeling of having learned something or utility added

repfreq: How much of a recurring daily life theme does the content have? for example: Rebecca Black's Friday is '10' on this scale since it happens every week.


6) homophily? : Turning this on makes nodes connect to others with similar emotional attributes

7) Supernode?: Do you want to account for celebrities or "supernodes" of sharing in this model? Since the network is small, I have only allowed for one such node (max.2  if you raise population high enough, I believe. 

POST-SETUP

8) Hold? : This is slightly confusing so I'll do my best to explain. Since my network changes with every setup and every agent is randomly assigned attributes, it makes it difficult to compare different types of content and the effects of things like homophily and random-sparks. 

Hence, I allow for a reset of the attributes built up since "go" was pressed, so that changes can be made to the content being introduced and "target", "random-sparks" and then can be run again.

To do this - setup --> go --> run till steady state --> Hold on (with go still on) --> turn go off --> hold off --> change any parameters of the content and the two other variables --> go on -- > observe changes caused 

There might be a better way to code this in, but I was pressed for time.

9) Target?: The video is shown to people with sensitivity to the sharing positive emotions - funny, anger when advertising is done via "rounds" at "campaignlevel".
This can be manipulated post setup using "hold" as well. 


10) randomsparks: People are likely to view content randomly as well, especially if they hear about it in passing or come across it (most viewed on Youtube or suggested links on Facebook etc) and this is a randomized event that happens every so often if the content is doing well enough, fast enough.  


THINGS TO NOTICE
----------------

1) The creation of a critical mass of people who have viewed the content before there is an explosion or "the content going viral" 

2) Nodes turn dark yellow when content is viewed or seen more than once. 

3) A combination of homophily, random sparks and targeted marketing definitely produce the best results with videos going viral really easily.

4) Taking randomsparks out of the equation seriously affects the results of the model

5) Leaving a supernode in also gives very good results. 



THINGS TO TRY
-------------

1) Run it on a lower speed than normal generally. Otherwise things happen too fast to really take it in. 


2) Set a high value of funny and put all switches on except for hold?. Works really well. 

3) Something not to do with the model is to set all the parameters very high. The model is not designed to deal with that. It makes sense that it doesn't work either because it is rare that content is at that scale of these conflicting emotions all at once. usually at that point it doesn't go viral as much as just explodes. (which can be seen)



EXTENDING THE MODEL
-------------------

1) Not everyone who gets the content shared with them should necessarily watch it. I meant to implement that as an enthusiasm factor in the sharing, kind of like a strength of recommendation, but spent too much time tuning other parameters. 

2) More degrees (more smoothness) of emotion in the user would probably allow for better curves being plotted.

3) A better world. is there a good way to take the internet and condense it into a smaller network? I'm not sure how..

4) Understanding the decision making itself better. I know what factors affect decision making, but there's no clarity on the actual decision made by agent. I just chose parameters and kept tuning till the model gave me answers that made sense (as long as parameters were also reasonable)



RELATED MODELS
--------------
"Virus on a Network"

Used some background from "Fire" as well. 


CREDITS AND REFERENCES
----------------------

Version as of 6/10/2013
This section should contain credits and/or references to source materia
I have used the virus model in some capacity for my setup, though the rest of my model is vastly different.

* Stonedahl, F. and Wilensky, U. (2008).  NetLogo Virus on a Network model.  http://ccl.northwestern.edu/netlogo/models/VirusonaNetwork.  Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.
* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 2008 Uri Wilensky.

![CC BY-NC-SA 3.0](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
