
globals[result]

turtles-own[
  high
  medium
  low
  
  prob-high
  prob-medium
  prob-low
  
  in-link-list
]

to compute-prob[n]
  let num-neighbors length ([in-link-list] of turtle n)
  
  let first-n "-"
  let second-n "-"
  let third-n "-"
  
  carefully[set first-n (item 0 ([in-link-list] of turtle n))][]
  carefully[set second-n (item 1 ([in-link-list] of turtle n))][]
  carefully[set third-n (item 2 ([in-link-list] of turtle n))][]
    
  ask turtle n[
    ifelse(num-neighbors = 1)[
      
      let high-index 0
      foreach["H" "M" "L"][
        let first-t ?
        set prob-high (prob-high + ((retrieve-prob first-n first-t) * (item high-index high)))
        set high-index (high-index + 1)
      ]
      
      let medium-index 0
      foreach["H" "M" "L"][
        let first-t ?
        set prob-medium (prob-medium + ((retrieve-prob first-n first-t) * (item medium-index medium)))
        set medium-index (medium-index + 1)
      ]
      
      let low-index 0
      foreach["H" "M" "L"][
        let first-t ?
        set prob-low (prob-low + ((retrieve-prob first-n first-t) * (item low-index low)))
        set low-index (low-index + 1)
      ]
      
      ;; for precision purposes
      set prob-high (precision prob-high 2)
      set prob-medium (precision prob-medium 2)
      set prob-low (precision prob-low 2)
    ]
    [
      ifelse(num-neighbors = 2)[
        
        ;; num-neighbors = 2
        let high-index 0
        foreach["H" "M" "L"][
          let first-t ?
          foreach["H" "M" "L"][
            let second-t ?
            set prob-high (prob-high + ((retrieve-prob first-n first-t) * (retrieve-prob second-n second-t) * (item high-index high)))
            set high-index (high-index + 1)
          ]
        ]
        
        let medium-index 0
        foreach["H" "M" "L"][
          let first-t ?
          foreach["H" "M" "L"][
            let second-t ?
            set prob-medium (prob-medium + ((retrieve-prob first-n first-t) * (retrieve-prob second-n second-t) * (item medium-index medium)))
            set medium-index (medium-index + 1)
          ]
        ]
        
        let low-index 0
        foreach["H" "M" "L"][
          let first-t ?
          foreach["H" "M" "L"][
            let second-t ?
            set prob-low (prob-low + ((retrieve-prob first-n first-t) * (retrieve-prob second-n second-t) * (item low-index low)))
            set low-index (low-index + 1)
          ]
        ]
        
        ;; for precision purposes
        set prob-high (precision prob-high 2)
        set prob-medium (precision prob-medium 2)
        set prob-low (precision prob-low 2)
      ]
      [
        
        ;; num-neighbors = 3
        
        let high-index 0
        foreach["H" "M" "L"][
          let first-t ?
          foreach["H" "M" "L"][
            let second-t ?
            foreach["H" "M" "L"][
              let third-t ?
              set prob-high (prob-high + ((retrieve-prob first-n first-t) * (retrieve-prob second-n second-t) * (retrieve-prob third-n third-t) * (item high-index high)))
              set high-index (high-index + 1)
            ]
          ]
        ]
        
        let medium-index 0
        foreach["H" "M" "L"][
          let first-t ?
          foreach["H" "M" "L"][
            let second-t ?
            foreach["H" "M" "L"][
              let third-t ?
              set prob-medium (prob-medium + ((retrieve-prob first-n first-t) * (retrieve-prob second-n second-t) * (retrieve-prob third-n third-t) * (item medium-index medium)))
              set medium-index (medium-index + 1)
            ]
          ]
        ]
        
        let low-index 0
        foreach["H" "M" "L"][
          let first-t ?
          foreach["H" "M" "L"][
            let second-t ?
            foreach["H" "M" "L"][
              let third-t ?
              set prob-low (prob-low + ((retrieve-prob first-n first-t) * (retrieve-prob second-n second-t) * (retrieve-prob third-n third-t) * (item low-index low)))
              set low-index (low-index + 1)
            ]
          ]
        ]
        
        ;; for precision purposes
        set prob-high (precision prob-high 2)
        set prob-medium (precision prob-medium 2)
        set prob-low (precision prob-low 2)
        
      ]
      
    ]
  ]
  
end

to-report retrieve-prob [node traf]
  if(traf = "H")[
    report ([prob-high] of turtle node)
  ]
  if(traf = "M")[
    report ([prob-medium] of turtle node)
  ]
  if(traf = "L")[
    report ([prob-low] of turtle node)
  ]
  report 0
end

to setup
  ca
  reset-ticks
  ask patches[set pcolor 69]
  
  setup-nodes
  setup-links
  setup-cpt
  setup-prob
end

to setup-nodes
  crt 1[setxy 3 13 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 1 10 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 3 10 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 5 10 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 2 7 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 4 7 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 1 4 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 3 4 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 5 4 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 3 1 set shape "rounded-rectangle" set color blue set label who set label-color black]
end

to setup-links
  crt-links 0 1
  crt-links 0 3
  crt-links 1 2
  crt-links 1 4
  crt-links 2 4
  crt-links 2 5
  crt-links 3 2
  crt-links 3 5
  crt-links 3 8
  crt-links 4 5
  crt-links 4 6
  crt-links 4 8
  crt-links 4 9
  crt-links 5 6
  crt-links 5 7
  crt-links 6 9
  crt-links 7 9
  crt-links 8 7
end

;; for setting up the conditional probability table (CPT)
to setup-cpt
  
  ask turtles[
    ifelse((count in-link-neighbors) != 0)[
      
      set in-link-list sort ([who] of in-link-neighbors)
      
      set high n-values (3 ^ (count in-link-neighbors)) [random 100]
      set medium n-values (3 ^ (count in-link-neighbors)) [random 100]
      set low n-values (3 ^ (count in-link-neighbors)) [random 100]
      
      foreach (n-values (3 ^ (count in-link-neighbors)) [?])[
        let sum-item ((item ? high) + (item ? medium) + (item ? low))
        
        set high (replace-item ? high (precision ((item ? high) / sum-item) 2))
        set medium (replace-item ? medium (precision ((item ? medium) / sum-item) 2))
        set low (replace-item ? low (precision ((item ? low) / sum-item) 2))
        
        set prob-high 0
        set prob-medium 0
        set prob-low 0
      ]
    ][
      
      set in-link-list 0
      
      set high random 100
      set medium random 100
      set low random 100
      
      let sum-item (high + medium + low)
      
      set high (precision (high / sum-item) 2)
      set medium (precision (medium / sum-item) 2)
      set low (precision (low / sum-item) 2)
      
      set prob-high high
      set prob-medium medium
      set prob-low low
    ]
  ]
  
end

to crt-links[from-turtle to-turtle]
  ask turtle from-turtle[create-link-to turtle to-turtle]
end

to setup-prob
  compute-prob 1
  compute-prob 3
  compute-prob 2
  compute-prob 4
  compute-prob 5
  compute-prob 6
  compute-prob 8
  compute-prob 7
  compute-prob 9
end
@#$#@#$#@
GRAPHICS-WINDOW
17
22
307
653
-1
-1
40.0
1
10
1
1
1
0
1
1
1
0
6
0
14
0
0
1
ticks
30.0

BUTTON
329
48
414
81
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
502
283
626
328
0=low (prob & CPT)
[low] of turtle 0
17
1
11

MONITOR
503
456
658
501
1=low (prob & CPT)
word ([prob-low] of turtle 1) \" : \" ([low] of turtle 1)
17
1
11

MONITOR
503
631
817
676
2=low (prob & CPT)
word ([prob-low] of turtle 2) \" : \" ([low] of turtle 2)
17
1
11

MONITOR
503
808
648
853
3=low (prob & CPT)
word ([prob-low] of turtle 3) \" : \" ([low] of turtle 3)
17
1
11

MONITOR
501
982
815
1027
4=low (prob & CPT)
word ([prob-low] of turtle 4) \" : \" ([low] of turtle 4)
17
1
11

MONITOR
1013
280
1759
325
5=low (prob & CPT)
word ([prob-low] of turtle 5) \" : \" ([low] of turtle 5)
17
1
11

MONITOR
1015
451
1316
496
6=low (prob & CPT)
word ([prob-low] of turtle 6) \" : \" ([low] of turtle 6)
17
1
11

MONITOR
1014
627
1317
672
7=low (prob & CPT)
word ([prob-low] of turtle 7) \" : \" ([low] of turtle 7)
17
1
11

MONITOR
1013
803
1317
848
8=low (prob & CPT)
word ([prob-low] of turtle 8) \" : \" ([low] of turtle 8)
17
1
11

MONITOR
1011
977
1751
1022
9=low (prob & CPT)
word ([prob-low] of turtle 9) \" : \" ([low] of turtle 9)
17
1
11

MONITOR
502
239
626
284
0=medium (prob & CPT)
[medium] of turtle 0
17
1
11

MONITOR
503
411
659
456
1=medium (prob & CPT)
word ([prob-medium] of turtle 1) \" : \" ([medium] of turtle 1)
17
1
11

MONITOR
503
586
817
631
2=medium (prob & CPT)
word ([prob-medium] of turtle 2) \" : \" ([medium] of turtle 2)
17
1
11

MONITOR
503
764
649
809
3=medium (prob & CPT)
word ([prob-medium] of turtle 3) \" : \" ([medium] of turtle 3)
17
1
11

MONITOR
501
938
815
983
4=medium (prob & CPT)
word ([prob-medium] of turtle 4) \" : \" ([medium] of turtle 4)
17
1
11

MONITOR
1012
235
1759
280
5=medium (prob & CPT)
word ([prob-medium] of turtle 5) \" : \" ([medium] of turtle 5)
17
1
11

MONITOR
1015
407
1316
452
6=medium (prob & CPT)
word ([prob-medium] of turtle 6) \" : \" ([medium] of turtle 6)
17
1
11

MONITOR
1015
581
1316
626
7=medium (prob & CPT)
word ([prob-medium] of turtle 7) \" : \" ([medium] of turtle 7)
17
1
11

MONITOR
1013
758
1317
803
8=medium (prob & CPT)
word ([prob-medium] of turtle 8) \" : \" ([medium] of turtle 8)
17
1
11

MONITOR
1011
933
1752
978
9=medium (prob & CPT)
word ([prob-medium] of turtle 9) \" : \" ([medium] of turtle 9)
17
1
11

MONITOR
502
194
626
239
0=high (prob & CPT)
[high] of turtle 0
17
1
11

MONITOR
503
366
659
411
1=high (prob & CPT)
word ([prob-high] of turtle 1) \" : \" ([high] of turtle 1)
17
1
11

MONITOR
503
541
817
586
2=high (prob & CPT)
word ([prob-high] of turtle 2) \" : \" ([high] of turtle 2)
17
1
11

MONITOR
503
720
650
765
3=high (prob & CPT)
word ([prob-high] of turtle 3) \" : \" ([high] of turtle 3)
17
1
11

MONITOR
501
893
815
938
4=high (prob & CPT)
word ([prob-high] of turtle 4) \" : \" ([high] of turtle 4)
17
1
11

MONITOR
1012
190
1760
235
5=high (prob & CPT)
word ([prob-high] of turtle 5) \" : \" ([high] of turtle 5)
17
1
11

MONITOR
1014
362
1315
407
6=high (prob & CPT)
word ([prob-high] of turtle 6) \" : \" ([high] of turtle 6)
17
1
11

MONITOR
1015
535
1317
580
7=high (prob & CPT)
word ([prob-high] of turtle 7) \" : \" ([high] of turtle 7)
17
1
11

MONITOR
1012
713
1315
758
8=high (prob & CPT)
word ([prob-high] of turtle 8) \" : \" ([high] of turtle 8)
17
1
11

MONITOR
1010
888
1751
933
9=high (prob & CPT)
word ([prob-high] of turtle 9) \" : \" ([high] of turtle 9)
17
1
11

TEXTBOX
327
338
1463
356
============================================================================================================================================
11
0.0
1

TEXTBOX
327
512
1463
530
============================================================================================================================================
11
0.0
1

TEXTBOX
328
691
1467
709
============================================================================================================================================
11
0.0
1

TEXTBOX
326
865
1458
883
============================================================================================================================================
11
0.0
1

MONITOR
347
239
479
284
NIL
[in-link-list] of turtle 0
17
1
11

MONITOR
350
411
482
456
NIL
[in-link-list] of turtle 1
17
1
11

MONITOR
352
587
484
632
NIL
[in-link-list] of turtle 2
17
1
11

MONITOR
348
764
480
809
NIL
[in-link-list] of turtle 3
17
1
11

MONITOR
347
940
479
985
NIL
[in-link-list] of turtle 4
17
1
11

TEXTBOX
827
172
845
340
||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||
11
0.0
1

TEXTBOX
828
349
851
517
||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||
11
0.0
1

TEXTBOX
829
523
979
691
||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||
11
0.0
1

TEXTBOX
830
703
980
871
||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||
11
0.0
1

TEXTBOX
831
875
981
1043
||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||
11
0.0
1

MONITOR
863
236
995
281
NIL
[in-link-list] of turtle 5
17
1
11

MONITOR
873
402
1005
447
NIL
[in-link-list] of turtle 6
17
1
11

MONITOR
866
580
998
625
NIL
[in-link-list] of turtle 7
17
1
11

MONITOR
863
760
995
805
NIL
[in-link-list] of turtle 8
17
1
11

MONITOR
862
936
994
981
NIL
[in-link-list] of turtle 9
17
1
11

TEXTBOX
21
673
304
848
[in-link-list] = 1 object\n[H M L]\n==================================\n[in-link-list] = 2 object : each item in list [1st][2nd]\n[HH HM HL MH MM ML LH LM LL]\n==================================\n[in-link-list] = 3 object : each item in list [1st][2nd][3rd]\n[HHH HHM HHL HMH HMM HML HLH HLM HLL MHH MHM MHL MMH MMM MML MLH MLM MLL LHH LHM LHL LMH LMM LML LLH LLM LLL]
11
0.0
1

TEXTBOX
330
157
1466
175
============================================================================================================================================
11
0.0
1

TEXTBOX
675
365
836
441
** For all prob P(Y) : calculated from randomly generated CPT of Y
15
15.0
1

@#$#@#$#@
## WHAT IS IT?

Traffic Predictor

## CREDITS AND REFERENCES

This model is the work of Larry LIN Jun Jie
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rounded-rectangle
false
0
Circle -7500403 true true 0 75 150
Circle -7500403 true true 150 75 150
Rectangle -7500403 true true 75 75 225 225

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
