breed [fundamentals fundamental]
breed [feedbacks feedback]
breed [opportunists opportunist]
breed [randomnists randomnist]
breed [learners learner]

fundamentals-own [

  ]

feedbacks-own [
  
  ]

opportunists-own [
  
  ]

learners-own [
 groupie 
 
  ]

turtles-own
[
  donottakeintoaccountinvaluationself
  pricepaid
  pricereceived
  profit
  valuation
  stock
  
  ;new in this model
  bidprice
  askprice
  
  bidyet
  askyet
  option
  traded?
  counttraded
  correctedforilliquidity?
  money 
  valueself


]

globals
[ runtime
  pricet
  pricetmedian
  pricet-1
  pricet-2
  pricet-3
  dividendpaid
  NumberOfTradersWhoTradedThisTurn
  NumberOfStocksTradedThisTurn
  tradesthisperiod
  tradeslastperiod
  numberofturnsnotrade
  fundamentalvalue
  dividendlist
  dividend
  dividendlastperiod
  sumdividends
  chanceofopportunism
  testvariablereducingopportunism
  LastTradesLessOpportunism
  sdevinpricespaid
]


to setup
  clear-all
  
  
  set-default-shape fundamentals "house"
  set-default-shape feedbacks "person"
  set-default-shape opportunists "pentagon"
  set-default-shape randomnists "arrow"
  set-default-shape opportunists "x"
  
  create-ordered-fundamentals Numberoffundamentals
  [setxy random-ycor random-xcor
    set color white]
  create-ordered-randomnists Numberofrandomnists
  [setxy random-ycor random-xcor
    set color white]
  create-ordered-feedbacks Numberoffeedbacks 
  [setxy random-ycor random-xcor
    set color white]
  create-ordered-opportunists Numberofopportunists
  [setxy random-ycor random-xcor
    set color white]
  create-ordered-learners Numberoflearners
  [setxy random-ycor random-xcor
    set color white]
  
  setup1
  set runtime 0
  set tradesthisperiod 1
  
  set NumberOfTradersWhoTradedThisTurn 0
  set  NumberOfStocksTradedThisTurn 0
   ask turtles [set valuation 360
    set stock noStocksperTrader]
   
  if record? = 1 [
  let file user-new-file
    if is-string? file
  [
    ;; If the file already exists, we begin by deleting it, otherwise
    ;; new data would be appended to the old contents.
    if file-exists? file
      [ file-delete file ]
    file-open file
    file-type trendvalue
     file-type "," 
    file-type numberoffundamentals 
     file-type "," 
    file-type numberoffeedbacks
     file-type "," 
       file-type numberofopportunists
     file-type ","
     file-type numberofrandomnists
     file-type ","
      file-type numberoflearners
     file-type ","
    file-type changeinfundamentalvalue
     file-type "," 
    file-type dividendfunction
     file-type "," 
     file-type bidspread
     file-type "," 
    file-type noStockspertrader
     file-type ","  
     file-type Dividendpayout
     file-type "," 
    file-type timePeriods
    file-type  "," 
    file-print  "-"
    file-print " " 
    ;; record the initial turtle data
   
  ]]

end
  
to setup1
  reset-ticks
  set sumdividends 0
  set runtime runtime + 1
  set pricet 360 ; changed in v10
  set pricet-1 360; changed in v10
  set pricet-2 360
  set pricet-3 360
  ask turtles
  [set donottakeintoaccountinvaluationself 0]
  ask learners
  [set donottakeintoaccountinvaluationself 1]
  set fundamentalvalue 360
  set numberofturnsnotrade 0
  ask turtles [set correctedforilliquidity? 0]
  ask turtles [set valuation 360
    set stock noStocksperTrader
    set money 10000
    set valueself money
    ]
  set dividendpaid 1
 
  ask turtles [set profit 0
    ]
  set dividendlist [36 4 -16 -24
    ]
  
  if dividendpayout = 1 [set dividendpaid dividendpaid * -1]
  if dividendpayout = 2 [set dividendpaid 0]
  ifelse dividendpaid = 1 
  [set dividend one-of dividendlist]
  [set dividend 0]

   setup-plots ; changed in v10
  update-plots ; changed in v10
     end

to go 
  
  if ticks >= timePeriods and runtime >= 999 [stop]
  if ticks >= timePeriods [setup1]
  ask turtles [set correctedforilliquidity? 0
    set pricepaid 0
    ]
  ask learners [set groupie 0]
  set sdevinpricespaid 0
  ifelse tradesthisperiod = 0 [set numberofturnsnotrade numberofturnsnotrade + 1][set numberofturnsnotrade 0]
  set tradesthisperiod 0
  set tradeslastperiod tradesthisperiod
  set tradesthisperiod 0
  ask turtles [set  traded? 0
    set counttraded 0]
  set NumberOfTradersWhoTradedThisTurn 0
  set NumberOfStocksTradedThisTurn 0 
  set dividendlastperiod dividend
  timedevelopprices
  
  
  if ticks > 0 [set sumdividends sumdividends + dividend]
  set fundamentalvalue fundamentalvalue + changeinfundamentalvalue
  ask fundamentals [valuatefundamental]
  ask feedbacks [valuatefeedback]
  ask randomnists [valuaterandomnists]
  ask opportunists [valuateopportunist]
  ask learners [valuatelearners]
  ask turtles[if tradeslastperiod = 0 [correctvaluationforliquidity]]
  ask turtles [recolor]
  if dividendpayout = 1 [set dividendpaid dividendpaid * -1]
  ifelse dividendpaid = 1 
  [set dividend one-of dividendlist]
  [set dividend 0]
  
  ;new in this model
  ask turtles [set bidyet 0
    set askyet 0]
  remove-links
  
  ask-concurrent turtles [if valuation > pricet-1 [without-interruption [bidp]]]
  ask-concurrent turtles [if valuation < pricet-1 and stock > 0 [without-interruption [askp]]]
 ; ask-concurrent turtles [if valuation = pricet-1
  ;  [ifelse random-float 1 <= 0.5 [without-interruption[bidp]][if stock > 0 [without-interruption[askp]]]]]
  
  ;foreach sort-by [[valuation] of ?1 > [size] of ?2] turtles with [bidyet = 1]
  ;
  without-interruption [ask-concurrent turtles [ without-interruption 
  [trade] ] ] ; giving the initiative to those who want to buy, with the highest valuation first


  if tradesthisperiod > 1 [set sdevinpricespaid standard-deviation [pricepaid] of turtles with [pricepaid != 0]]
  ask turtles [if ticks > 0 [set profit profit + dividend * stock]]
  remove-links
  setprice
  ask turtles [determinevalue]
  
   if record? = 1 [ record

 ]
  
  tick
  end



to timedevelopprices  
  set pricet-3 pricet-2
  set pricet-2 pricet-1
  set pricet-1 pricet
end

to valuateopportunist
 Chancify
   ifelse 
   pricet-1 - pricet-2 > 0
   and pricet-1 > fundamentalvalue
  [ifelse
   random-float 1 < ChanceOfOpportunism
   [set valuation pricet-1 + random-normal 50 20]
   [set valuation fundamentalvalue + random-normal 0 SDEV]]
  [set valuation fundamentalvalue + random-normal 0 SDEV]
  
  if NoOpportunists? = 1 [set valuation fundamentalvalue + random-normal 0 SDEV]
  end

to valuaterandomnists
  set valuation pricet-1 + random-normal 0 2 * SDEV
  if NoRandomnists? = 1 [set valuation fundamentalvalue + random-normal 0 SDEV]
end

to valuatelearners
  
  if [valueself] of max-one-of opportunists [valueself] = max [valueself] of turtles with [donottakeintoaccountinvaluationself = 0]
    [valuateopportunist
    set groupie 1
    set shape "pentagon"
    ]
  if [valueself] of max-one-of randomnists [valueself] = max [valueself] of turtles with [donottakeintoaccountinvaluationself = 0]
  [valuaterandomnists
    set groupie 2
    set shape "arrow"
    ]
  if [valueself] of max-one-of feedbacks [valueself] = max [valueself] of turtles with [donottakeintoaccountinvaluationself = 0]
  [valuatefeedback
    set groupie 3
    set shape "person"
  ]
    
  if [valueself] of max-one-of fundamentals [valueself] = max [valueself] of turtles with [donottakeintoaccountinvaluationself = 0]
  [valuatefundamental
    set groupie 4  
    set shape "house"]
 if NoLearners? = 1 [set valuation fundamentalvalue + random-normal 0 SDEV]
end
  
to Chancify 
   if ticks > 10 [set testvariablereducingopportunism testvariablereducingopportunism + 1]
   set LastTradesLessOpportunism 1 - 0.25 * testvariablereducingopportunism 
   let profitfromcapitalgains (pricet-1 - pricet-3)
   let profitfromdividends dividend + dividendlastperiod
   
   if profitfromdividends > profitfromcapitalgains [set ChanceOfOpportunism 0 * LastTradesLessOpportunism]
   
   ifelse profitfromdividends != 0 
   [if profitfromdividends <= profitfromcapitalgains [set ChanceOfOpportunism (profitfromcapitalgains / profitfromdividends - 1) * LastTradesLessOpportunism]]
   [set ChanceOfOpportunism 0]
   
   if ChanceOfOpportunism > 0.8 [set ChanceOfOpportunism 0.8 * LastTradesLessOpportunism]
   

end

to valuatefundamental
    set valuation  fundamentalvalue  + dividend * dividendfunction + random-normal 0 SDEV
    if NoFundamentals? = 1 [set valuation fundamentalvalue + random-normal 0 SDEV]
end

to valuatefeedback
  set valuation trendvalue * (pricet-1 - pricet-2) + pricet-1 + random-normal 0 SDEV
  if NoFeedbacks? = 1 [set valuation fundamentalvalue + random-normal 0 SDEV]
  end


to remove-links
  ask-concurrent links [die]
end

to bidp
  set bidprice bidspread * (valuation - pricet-1) + pricet-1
  set bidyet 1
  set pricepaid 0
end

to askp
  set askprice bidspread * (valuation - pricet-1) + pricet-1
  set askyet 1
  set pricepaid 0
end

to trade
  
  set option random 2
  let valuationself valuation
  if option = 1 
  [if traded? = 0[
    if any? turtles with [askyet  = 1 and askprice < valuationself and stock > 0 and self != myself]
  [buyfromasker
  exchangewithasker
  determinepricewithasker
  removeask]]
  ]
  
  
  if option = 1
  [  if traded? = 0
   [ 
     if any? turtles with [bidyet  = 1 and bidprice > valuationself and stock > 0 and self != myself]
  [selltobidder
  exchangewithbidder
  determinepricewithbidder
  removebid]]
  ]
 
  if option = 0
  [if traded? = 0
   [
      if any? turtles with [bidyet  = 1 and bidprice > valuationself and stock > 0 and self != myself]
  [selltobidder
  exchangewithbidder
  determinepricewithbidder
  removebid]]
   ]
   
   if option = 0
  [if traded? = 0
  [if any? turtles with [askyet  = 1  and askprice < valuationself and stock > 0 and self != myself]
  [buyfromasker
  exchangewithasker
  determinepricewithasker
  removeask]]
  ]
  
 
 ; create-links
  ;if not notlinked? [exchange-stocks]
  ;if notlinked? [set pricepaid 0]
  ;remove-links
end 

to buyfromasker
  let valuationself valuation
  create-link-with one-of turtles with [askyet  = 1 and askprice < valuationself and stock > 0 and self != myself]
 
end

to selltobidder
  let valuationself valuation
  create-link-with one-of turtles with [bidyet  = 1 and bidprice > valuationself and self != myself]

end
  
to create-links
  without-interruption [ask turtles with [bidyet = 1 and notlinked?] 
 [if any? turtles with [askyet = 1 and notlinked?]
 [create-link-with one-of turtles with [askyet = 1 and notlinked?]]]]
end

to exchangewithasker
  set stock stock + 1
  set tradesthisperiod tradesthisperiod + 1
  ask link-neighbors [set stock stock - 1
    set counttraded 1]
  set traded? 1
  set counttraded 1
  set NumberOfTradersWhoTradedThisTurn NumberOfTradersWhoTradedThisTurn + 2
  set NumberOfStocksTradedThisTurn NumberOfStocksTradedThisTurn + 1

end

to exchangewithbidder
  set stock stock - 1
  set tradesthisperiod tradesthisperiod + 1
  ask link-neighbors [set stock stock + 1
    set counttraded 1]
  set traded? 1
  set counttraded 1
  set NumberOfTradersWhoTradedThisTurn NumberOfTradersWhoTradedThisTurn + 2
  set NumberOfStocksTradedThisTurn NumberOfStocksTradedThisTurn + 1

end


to determinepricewithasker
 let pricedeterminant [askprice] of one-of link-neighbors with [self != myself];one-of link-neighbors
 set pricepaid pricedeterminant
 set money money - pricepaid
 ask one-of link-neighbors with [self != myself] [set money money + askprice]
 calculate-profits

 
end

to determinepricewithbidder
let pricedeterminant [bidprice] of one-of link-neighbors with [self != myself];one-of link-neighbors
 set pricepaid pricedeterminant 
 set money money + pricepaid
 ask one-of link-neighbors with [self != myself] [set money money - bidprice]
 calculate-profits 

end

to removeask
  ask one-of link-neighbors [set askyet 0]
  ask one-of links [die]
end

to removebid
  ask one-of link-neighbors [set bidyet 0]
  ask one-of links [die]
end

to calculate-profits
  set profit profit + 360 - pricepaid
  ask one-of link-neighbors with [self != myself] [set profit profit + [pricepaid] of one-of link-neighbors with [self != myself] - 360]
end

to-report notlinked?
   report (count link-neighbors < 1) 
end

to setprice
  ifelse tradesthisperiod != 0 [set pricet mean [pricepaid] of turtles with [traded? = 1]][set pricet mean [valuation] of turtles with [stock > 0]]  ; check this ifelse command!
  ifelse tradesthisperiod != 0 [set pricetmedian median [pricepaid] of turtles with [traded? = 1]][set pricetmedian median [valuation] of turtles with [stock > 0]]
end

to correctvaluationforliquidity
 
  if stock > 0 [set valuation
    0.2 * numberofturnsnotrade * fundamentalvalue + (1 - (numberofturnsnotrade * 0.2)) * valuation
    set correctedforilliquidity? 1]
end
  
to determinevalue
  if ticks > 0 [set money money + stock * dividend]
  set valueself money + pricet * stock
end
  
  
  
  to recolor
    if valuation > pricet-1
    [set color blue]
    if valuation < pricet-1
    [set color red]
     if valuation = pricet-1
    [set color white]
    
  end
  
  to record
     file-type ticks 
 file-type "," 
 file-type pricet
 file-type ","
 file-type mean [valuation] of fundamentals
 file-type "," 
 file-type mean [valuation] of feedbacks
 file-type "," 
 file-type mean [valuation] of opportunists
  file-type "," 
 file-type mean [valuation] of learners
  file-type "," 
 file-type mean [valuation] of randomnists
 file-type "," 
 file-type dividend
 file-type "," 
  file-type  numberofturnsnotrade
  file-type "," 
  file-type  NumberOfTradersWhoTradedThisTurn
  file-type "," 
  file-type  NumberOfStocksTradedThisTurn
  file-type "," 
  file-type sum [valueself] of fundamentals
  file-type "," 
  file-type sum [valueself] of feedbacks
  file-type "," 
  file-type sum [valueself] of opportunists
  file-type "," 
  file-type sum [valueself] of learners
  file-type ","
  file-type sum [valueself] of randomnists
  file-type ","
  file-type mean [groupie] of learners
  file-type ","
   file-type count turtles with [counttraded = 1] 
  file-type ","
  file-type count turtles with [bidyet = 1]
  file-type "," 
  file-type count turtles with [askyet = 1]
  file-type ","
  file-type fundamentalvalue
  file-type ","  
  file-type sdevinpricespaid
  file-type ","  
   file-type pricetmedian
  file-type ","
  file-print SDEV
  end

  
@#$#@#$#@
GRAPHICS-WINDOW
923
92
1228
418
16
16
8.94
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
817
276
880
309
NIL
setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
819
360
882
393
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
214
17
881
236
Prices, valuations and fundamentalvalue
NIL
NIL
1.0
16.0
250.0
750.0
false
true
"" ""
PENS
"Pricet" 1.0 0 -5298144 true "" "plot pricet"
"Fundamentalvalue" 1.0 0 -16449023 true "" "plot fundamentalvalue"
"Valuation Dividend Traders" 1.0 0 -7500403 true "" "plot mean [valuation] of fundamentals"
"Valuation Feedback Traders" 1.0 0 -2674135 true "" "plot mean [valuation] of feedbacks"
"Valuation Random Traders" 1.0 0 -955883 true "" "plot mean [valuation] of randomnists"
"Valuation Learning Traders" 1.0 0 -6459832 true "" "plot mean [valuation] of learners"
"Valuation Opportunistic traders" 1.0 0 -1184463 true "" "plot mean [valuation] of opportunists"

SLIDER
401
271
589
304
changeInFundamentalvalue
changeInFundamentalvalue
-20
20
0
1
1
NIL
HORIZONTAL

SLIDER
6
428
177
461
numberoffundamentals
numberoffundamentals
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
5
348
177
381
Numberoffeedbacks
Numberoffeedbacks
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
221
349
393
382
noStocksperTrader
noStocksperTrader
0
10
1
1
1
NIL
HORIZONTAL

SLIDER
221
310
393
343
Dividendfunction
Dividendfunction
0
10
4
1
1
NIL
HORIZONTAL

SLIDER
221
388
393
421
timePeriods
timePeriods
0
1000
15
15
1
NIL
HORIZONTAL

BUTTON
819
319
882
353
NIL
file-close
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
221
272
393
305
trendvalue
trendvalue
0
2
1
0.05
1
NIL
HORIZONTAL

SLIDER
400
388
590
421
record?
record?
0
1
0
1
1
NIL
HORIZONTAL

SLIDER
6
389
177
422
NumberofOpportunists
NumberofOpportunists
0
10
2
1
1
NIL
HORIZONTAL

PLOT
638
244
798
364
sum stocks
NIL
NIL
1.0
16.0
0.0
10.0
false
true
"" ""
PENS
"fundamentals" 1.0 0 -16777216 true "" "plot sum [stock] of fundamentals"
"Feedbacks" 1.0 0 -14439633 true "" "plot sum [stock] of feedbacks"
"opportunists" 1.0 0 -2674135 true "" "plot sum [stock] of opportunists"
"randomnists" 1.0 0 -7500403 true "" "plot sum [stock] of randomnists"
"learners" 1.0 0 -955883 true "" "plot sum [stock] of learners"

SLIDER
222
426
395
459
Dividendpayout
Dividendpayout
0
2
0
1
1
NIL
HORIZONTAL

SLIDER
5
269
177
302
numberofrandomnists
numberofrandomnists
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
5
308
177
341
numberoflearners
numberoflearners
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
402
310
589
343
bidspread
bidspread
0
1
1
0.05
1
NIL
HORIZONTAL

SLIDER
401
349
590
382
SDEV
SDEV
0
100
35
1
1
NIL
HORIZONTAL

SLIDER
4
25
176
58
NoLearners?
NoLearners?
0
1
0
1
1
NIL
HORIZONTAL

SLIDER
4
70
176
103
NoOpportunists?
NoOpportunists?
0
1
0
1
1
NIL
HORIZONTAL

SLIDER
4
113
176
146
NoRandomnists?
NoRandomnists?
0
1
0
1
1
NIL
HORIZONTAL

SLIDER
4
156
176
189
NoFundamentals?
NoFundamentals?
0
1
0
1
1
NIL
HORIZONTAL

SLIDER
5
198
177
231
NoFeedbacks?
NoFeedbacks?
0
1
0
1
1
NIL
HORIZONTAL

PLOT
1269
10
1563
289
Tradertype Learners
NIL
NIL
0.0
16.0
0.0
4.0
false
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot [tradergroup] of min-one-of learners [who]"

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
