breed [sites site]
breed [androids android]
breed [students student]

globals [
  color-list 
  histogram-list 
  site-list 
  best-site 
  best-discovered? 
  best-chosen? 
  dist-among-sites 
  total-steps 
  stop? 
  quality-list 
  bees
  ]

sites-own [ 
  quality 
  dist-to-center 
  true-color
  ]

students-own [ 
  dancing-time
  dances-made
  user-id 
  target 
  target-quality 
  dist-to-hive
  interest 
  beetimer
  dancing? 
  re-visiting? 
  returning?
  recovering?
  myhome
  ]

androids-own [
  recovering? 
  myhome 
  target 
  target-quality 
  interest 
  dist-to-hive 
  beetimer
  dancing? 
  re-visiting? 
  returning?
  ]
patches-own [pdist-to-center ptype]

to startup
  hubnet-reset
    set-default-shape students "bee"
  set-default-shape androids "bug"
end

to setup
  clear-patches
  clear-drawing
  clear-output
  clear-all-plots
  ask androids [die]
  set stop? false
  set best-discovered? false
  set best-chosen? false
  set color-list [97.9 94.5 57.5 63.8 17.6 14.9 27.5 25.1 117.9 114.4] 
  set quality-list [95 55 35 5 85 75 65 45 15 25]
  setup-patches
  if any? sites [ ask sites [die]] setup-sites
  if any? androids [ask androids [die] make-androids]
  ask students [
    reset-students
    send-info-to-clients
    ]
  make-androids
  set histogram-list []
  make-bee-list
  reset-ticks
end

to make-bee-list
  let student-list students
  let android-list androids
  let bee-list sentence student-list android-list
  set bees turtle-set bee-list 
end

to make-androids
  create-androids 100 [
    set color gray
    set target nobody
    set dancing? false
    set re-visiting? false
    set returning? false
    set recovering? false
    fd random-float 4
    ]
end

to android-move
  if not re-visiting?  [
  ifelse [pcolor] of patch-here > 35 [facexy 0 0 fd 0.1][ if not dancing? [rt random 30 - 15 fd random-float 0.1]]
  ]
end

to android-follow
  if not recovering? [
  if any? bees with [dancing?] in-cone 1 30 [
    let bee-watched one-of bees with [dancing?] in-cone 1 30
    if random 100 < [interest] of bee-watched [ ; interest declines over time, but target quality don't 
      set label "?"
      set target [target] of bee-watched
      set color [color] of target
      set myhome one-of patches with [ptype = "dance-floor"]
      set re-visiting? true
      ]
    ]
  ]
end

to go
  if stop? [stop]
  listen-clients
  make-bee-list
  ask students [
    explore
    revisit
  ] 
  ask-concurrent bees [if dancing? [ifelse breed = students [dance][android-dance]]] 
  ask sites [count-bees]
  ask androids [if not dancing? [
      android-move
        android-follow
        revisit
        recover
      ]
  ]
  calculate-histogram-list
  plot-histogram
  plot-linegram
  tick
end

to recover
  if recovering? [
  ifelse beetimer > 0 [
    set beetimer beetimer - 1
    ][
    set recovering? false
    ]]
end

to calculate-histogram-list
  set histogram-list []
let offset [who] of min-one-of sites [who]
let site-quality-list sort [quality] of sites
  ask bees [
    if target != nobody and color != white [
    set histogram-list fput position target-quality site-quality-list histogram-list 
    ]
  ]
end

to count-bees; site procedure
    if count students > 0 and count students in-radius 3 = count students [
      if self = best-site[
        set best-chosen? true
      ]
    ]
    
end

to revisit
  if re-visiting? [
    ifelse returning? [
      ifelse distance myhome > 2 [
        face myhome fd 1
        ][
        set returning? false set re-visiting? false if breed = androids [set dancing? true]
        ]
    ][
    ifelse distance target < 1 [ 
      set target-quality [quality] of target          
      set interest round ([quality] of target / 10) ^ 2 
      set beetimer interest
      set color ([color] of target)
      set label "!"
      set returning? true
    ][
    fd 1                                       
    face target
    ]
    ]
  ]
end

to explore; bee procedure
  ifelse any? sites in-cone 3 120 [
    ifelse color = gray or color = white [
    set target one-of sites in-cone 3 120 
    ask target [set color true-color]
    if target = best-site [set best-discovered? true]
    set target-quality [quality] of target ;;;;;;;;why do you need this?
    set interest round ([quality] of target / 10) ^ 2 
    set beetimer interest
    set dist-to-hive [dist-to-center] of target
    set label "!"
    set color [color] of target
    hubnet-send user-id "target-quality" target-quality
  ][
  hubnet-send user-id "Message" "Dance before you can discover another site"]
  ][hubnet-send user-id "Message" ""]
end

to setup-patches
  ask patches [
    set pdist-to-center 4 * distancexy 0 0
    ifelse distancexy 0 0 < 4 [set pcolor scale-color brown pdist-to-center 0 30][set pcolor scale-color green pdist-to-center 0 100]
    if distancexy 0 0 < 3 [set ptype "dance-floor"]]
end

to reset-students
  hubnet-send-follow user-id self radius 
    setxy random-float 5 random-float 5
    set dancing? false 
    set target nobody
    set re-visiting? false
    set returning? false
    set recovering? false
    set label ""
    set beetimer -1
    set dances-made 0
    set dancing-time 0
    set target-quality 0
    set color gray
    set myhome one-of patches with [ptype = "dance-floor"]
end
  
to setup-sites
  create-sites number-of-sites [
    set color gray 
    set shape "box" 
    set size 2 
  ]
    set site-list sort sites 
    set dist-among-sites []
    let i [who] of min-one-of sites [who]  
    repeat count sites [
      ask site i [
        let mycolor one-of color-list
        set true-color mycolor 
        set color-list remove mycolor color-list
        set quality first quality-list + (random 10 - 4)
        set quality-list butfirst quality-list
      ]
      set-current-plot "support-overtime"  
      create-temporary-plot-pen word "site" i
      set-plot-pen-color [true-color] of site i 
      set i i + 1
    ]
    place-sites 
    set best-site max-one-of sites [quality]
    ask sites [set dist-to-center distancexy 0 0]
end

to place-sites
  ask sites [ set-sitexy ]
  check-site-distance site-list
  let first-item first sort dist-among-sites
  if first-item < 10 [
    set dist-among-sites [] 
    place-sites
  ] 
end

to set-sitexy
  ifelse random 2 = 0 [
    set xcor random-xcor
    ifelse random 2 = 0 [set ycor max-pycor - 1][set ycor min-pycor + 1]
  ][
  set ycor random-pycor
  ifelse random 2 = 0 [set xcor min-pxcor + 1][set xcor max-pxcor - 1]
  ]
end
 
to check-site-distance [a-site-list]
  if length a-site-list > 1 [
    let i 1
    repeat length a-site-list - 1 [
    ask first a-site-list [set dist-among-sites fput distance item i a-site-list dist-among-sites] 
    set i i + 1
    ]
  set a-site-list butfirst a-site-list
  check-site-distance a-site-list
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;HubNet Procedures;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to listen-clients
  while [hubnet-message-waiting?]
  [
    hubnet-fetch-message
    ifelse hubnet-enter-message?
    [ create-new-student ]
    [
      ifelse hubnet-exit-message?
      [ remove-student ]
      [ ask students with [user-id = hubnet-message-source]
        [ execute-command hubnet-message-tag ]
      ]
    ]
  ]
end

to create-new-student
  create-students 1
  [
    set user-id hubnet-message-source
    hubnet-send-follow user-id self radius 
    set target one-of sites
    set dancing? false
    set re-visiting? false
    set returning? false
    set recovering? false
    set color gray
    set myhome one-of patches with [ptype = "dance-floor"]
  ]
end

to remove-student
  ask students with [user-id = hubnet-message-source]
  [ die ]
end

to execute-command [command]
    
    if not dancing? [
  if command = "View"
  [
      let close-enough? false
      let choice min-one-of bees [distancexy item 0 hubnet-message item 1 hubnet-message]
      ask choice [if distancexy item 0 hubnet-message item 1 hubnet-message < 0.5 [set close-enough? true]]
      if close-enough? [
        if [dancing?] of choice [        
        set target [target] of choice
        set re-visiting? true 
        set label "?"
        set color ([color] of choice) ]
      ]
    ]
      if command = "dance" 
      [
        ifelse distancexy 0 0 < 4 [
          ifelse color = white [hubnet-send user-id "Message" "Visit or revisit a site to dance for it"][set dancing? true]
          ][
          hubnet-send user-id "Message" "I can only dance in the swarm."
          ]
        ]
      
    if color = white [
    if command = "revisit"
    [set re-visiting? true
      set color [color] of target]
  ]
  if not re-visiting? [
  if command = "up"
  [ execute-move 0 stop ]
  if command = "down"
  [ execute-move 180 stop ]
  if command = "right"
  [ execute-move 90 stop ]
  if command = "left"
  [ execute-move 270 stop ]
  ]
    ]
end

to execute-move [new-heading]
  set heading new-heading
  fd 1
end

to send-info-to-clients ;; turtle procedure
  hubnet-send user-id "target-quality" target-quality
  hubnet-send user-id "total-dances-made" dances-made
  hubnet-send user-id "total-dancing-time" dancing-time
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;DANCE;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to android-dance
    ifelse beetimer > 0 [
    face target
    rt interest
    wait 0.1
    lt interest
    wait 0.1
    lt interest
    wait 0.1
    rt interest
    wait 0.1
    set beetimer beetimer - 1
        ][
    set dancing? false
    set label ""
    set beetimer 20
    set color white 
    set recovering? true
    ]
end

to dance 
  ifelse beetimer >= 0 [
    face target
    rt interest
    wait 0.1
    lt interest
    wait 0.1
    lt interest
    wait 0.1
    rt interest
    wait 0.1
    hubnet-send user-id "interest-in-target" beetimer
    set beetimer beetimer - 1
    set dancing-time dancing-time + 1
    hubnet-send user-id "total-dancing-time" dancing-time
    ][
  if beetimer < 0 [
    set dancing? false
    set dances-made dances-made + 1    
    hubnet-send user-id "total-dances-made" dances-made
    set label ""
    set color white
    ]
  ]
end

to plot-histogram
  set-current-plot "support-count"
  create-temporary-plot-pen "pen"
  set-plot-pen-color green
  set-plot-pen-mode 1
  set-plot-x-range 0 count sites
  set-plot-y-range 0 number-of-sites
  set-histogram-num-bars count sites
  histogram histogram-list
end

to plot-linegram
  set-current-plot "support-overtime"
  let i [who] of min-one-of sites [who]
  repeat count sites [
    set-current-plot-pen word "site" i
    plot count bees with [target = site i and color != white]
    set i i + 1
    ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
701
522
18
18
13.0
1
10
1
1
1
0
0
0
1
-18
18
-18
18
0
0
1
ticks
30.0

BUTTON
14
10
94
58
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
114
10
195
58
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
14
114
200
147
radius
radius
1
10
1
1
1
NIL
HORIZONTAL

SLIDER
14
74
199
107
number-of-sites
number-of-sites
2
10
5
1
1
NIL
HORIZONTAL

MONITOR
3
163
106
208
NIL
best-discovered?
17
1
11

MONITOR
117
164
201
209
NIL
best-chosen?
17
1
11

PLOT
4
371
204
521
support-count
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS

PLOT
3
214
203
364
support-overtime
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS

@#$#@#$#@
## WHAT IS IT?

BeeSmart HubNet model is part of the BeeSmart Curricular Unit and the HubNet version of the BeeSmart Hive Finding model in NetLogo Model's library. For detailed description of the phenomenon modeled, please refer to the info tab of the BeeSmart Hive Finding model.

BeeSmart HubNet model focuses on the interaction among bees as they dance in the swarm. The interaction is usually misunderstood because people tend to think bees watch and compare multiple dances in order to find the best one to follow. BeeSmart HubNet model allows students to act as scout bees and see the world from bees' perspective, which helps the students understand the limitations of the bees both physically and cognitively. 

## HOW IT WORKS

At each tick, androids move around randomly by turning a random angle between [-15 15] and forward a random-float number that is less than 0.1. It also sees if there is any dancing agents within one step and is in its 30 degree cone of vision. If there is, the android may follow the dance based on a probability that is calculated according to the interest of the dancer. If the android decides to follow the dance, it sets its target as the target of the dancer, and fly out to evaluate the hive site that the dance is advocating by facing the target and forward one step at each tick.
When the site is within 3 steps and 120 degree of the android's cone of vision, the android sets its interest as the quality of the hive and fly back to the swarm to dance for it.  

Students basically follow the same set of rules as androids, except for a few decisions that the clients can make: when the model starts, students needs to "fly" out of the swarm in order to discover new potential hive sites. Students can control where their bees go by using the directional buttons on the clients. When stumbled upon a site, students can go back to the swarm and press the dance button to perform dances in order to promote the hive they discovered. As a bee dances, her interest declines. when the interest reaches zero, the bee stops dancing. At this point, students can choose if they want to fly out and explore another hive or to stay in the swarm and follow other bees dances. They can follow other dances by clicking other dancing bees. Once a dance is selected, the bee automatically flies out to the site the dance was advocating, investigates the site, and flies back to the swarm. Then the student can decide whether to dance for the site or to follow another dance.  

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)
When the model is launched, ask clients to join, preferably before clicking the setup button, so that you don't give away the hive site locations. After clients have joined the model, set the number-of-sites and radius BEFORE clicking the setup button. Then click Go
Setup initialize the model, adding hive sites into the view. 
Go starts the model. Only after Go is clicked can clients see the bees that they control. 
number-of-sites determines how may hive sites to put in the view.
radius determines how far the clients can see from their perspective.

## THINGS TO NOTICE

As the model runs, notice the change in the histogram. The leftmost bar represents the dances that support of the lowest quality site, while the rightmost bar represents the dances for the highest. Sites are discovered in random orders, so the bars starts out with random heights. However, as the process continues, supports gradually converge to the highest. 
The Support-Overtime plot shows this dynamic overtime. 

## THINGS TO TRY

Play this simulation with at least 3 people. A group of 10 would be ideal because is provides enough diversity to imitate the scout bees in a beehive. Try to start with a small number of hives (around 4 to 5) but a larger vision radius (5 to 7). Talk to your partners as you play. After you are familiar with this model, reduce the vision radius and play again. You can also increase the number of hives to increase the difficulty. Finally, use a vision radius of 1 and play the model without talking to any of your partners. This way, you can experience bees' physical and cognitive limitations. After each round of play, look at the plots on the server and debrief what you and your partners did, and what happened. 


## EXTENDING THE MODEL

The waggle dances in this model is represented by agents wiggling left and right. One possibility of extending the model is to use the actual waggle dance pattern that is found in the BeeSmart Hive Finding model to make the dances more realistic and informative. 

## NETLOGO FEATURES

This model uses the HubNet Architecture, especially the perspective reset feature (hubnet-send-follow). Notice that the layers of agents are determined by the order when they were declared. The later declared agents are on top of earlier declared ones. 

## RELATED MODELS

Guo, Y. and Wilensky, U. (2014). NetLogo BeeSmart - Hive Finding model. http://ccl.northwestern.edu/netlogo/models/BeeSmart-HiveFinding. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## CREDITS AND REFERENCES

Guo, Y. and Wilensky, U. (2014). NetLogo BeeSmart - Hive Finding model. http://ccl.northwestern.edu/netlogo/models/BeeSmart-HiveFinding. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

Seeley, T. D. (2010). Honeybee democracy. Princeton, NJ: Princeton University Press.

Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University. Evanston, IL.

Wilensky, U. & Stroup, W., 1999. HubNet.http://ccl.northwestern.edu/netlogo/hubnet.html. Center for Connected Learning and Computer-Based Modeling, Northwestern University. Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bee
true
0
Polygon -1184463 true false 152 149 77 163 67 195 67 211 74 234 85 252 100 264 116 276 134 286 151 300 167 285 182 278 206 260 220 242 226 218 226 195 222 166
Polygon -16777216 true false 150 149 128 151 114 151 98 145 80 122 80 103 81 83 95 67 117 58 141 54 151 53 177 55 195 66 207 82 211 94 211 116 204 139 189 149 171 152
Polygon -7500403 true true 151 54 119 59 96 60 81 50 78 39 87 25 103 18 115 23 121 13 150 1 180 14 189 23 197 17 210 19 222 30 222 44 212 57 192 58
Polygon -16777216 true false 70 185 74 171 223 172 224 186
Polygon -16777216 true false 67 211 71 226 224 226 225 211 67 211
Polygon -16777216 true false 91 257 106 269 195 269 211 255
Line -1 false 144 100 70 87
Line -1 false 70 87 45 87
Line -1 false 45 86 26 97
Line -1 false 26 96 22 115
Line -1 false 22 115 25 130
Line -1 false 26 131 37 141
Line -1 false 37 141 55 144
Line -1 false 55 143 143 101
Line -1 false 141 100 227 138
Line -1 false 227 138 241 137
Line -1 false 241 137 249 129
Line -1 false 249 129 254 110
Line -1 false 253 108 248 97
Line -1 false 249 95 235 82
Line -1 false 235 82 144 100

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
VIEW
270
26
699
455
0
0
0
1
1
1
1
1
0
1
1
1
-18
18
-18
18

BUTTON
93
104
175
146
up
NIL
NIL
1
T
OBSERVER
NIL
W

BUTTON
93
151
177
193
down
NIL
NIL
1
T
OBSERVER
NIL
S

BUTTON
10
151
88
194
left
NIL
NIL
1
T
OBSERVER
NIL
A

BUTTON
181
151
258
193
right
NIL
NIL
1
T
OBSERVER
NIL
D

BUTTON
8
228
121
273
dance
NIL
NIL
1
T
OBSERVER
NIL
Q

BUTTON
144
227
259
272
revisit
NIL
NIL
1
T
OBSERVER
NIL
R

MONITOR
10
372
129
421
total-dances-made
NIL
3
1

MONITOR
139
372
259
421
total-dancing-time
NIL
3
1

MONITOR
9
297
128
346
target-quality
NIL
3
1

MONITOR
8
26
260
75
Message
NIL
3
1

MONITOR
138
296
259
345
interest-in-target
NIL
3
1

@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
