turtles-own [greek? antigreek? year bias just-changed]  
;; greek? and antigreek? holds a 1 or a 0 indicating whether a turtle is greek or antigreek
;; year holds a turtle's year
;; bias holds the bias, or inclination of a turtle towards or against Greek life
;; just-changed is used to determine if a turtle's year was recently update in the update-year procedures
;; just-changed is used to prevent from having turtles updated all the way through all 4 years when the model
;; executes the update-year procedure

globals[rush? new-year? neg-tick-counter pos-tick-counter rush-tick-counter]
;; rush? holds a 1 or a 0 indicating if there's a rush period taking place
;; new-year? holds a 1 or 0 indicating if a new year has started
;; neg-tick-counter is the counter that counts the ticks that pass
;; it is used to determine when to set off a negative event-tick-marker
;; pos-tick-counter is the counter that counts the ticks that pass
;; it is used to determine when to set off a positive event-tick-marker
;; rush-tick-counter is used to determine when a rush period starts

;; this setup should be used in a 50 max x-cor by 50 max y-cor world space 
to setup-default ;; default setup has 5 buildings with the greek house in the bottom left corner
  ca
  set rush? 0 ;; rush is initiated to 0 since rush doesn't immediately start at the beginning of the year
  set new-year? 1 ;; a new year starts when the model first runs so this variable is set to 1
  set neg-tick-counter 0  ;; the counters for rush, negative events, and positive events is set to 0
  set pos-tick-counter 0
  set rush-tick-counter 0
  set-default-shape turtles "person" ;; turtle shape is defined
  crt population  [ ;; slider with variable POPULATION determines how many turtles are made
    setxy random-xcor random-ycor ;; turtles are placed randomly in the world
    set just-changed 0 ;; no turtle's year has been updated so this is set to 0
    if random 100 < percent-greek  ;; slider used to determine what percentage of the population is Greek
    [set greek? 1 ;; set the appropriate variables to 1 and 0 if a turtle is Greek
     set antigreek? 0
      ]
    if random 100 < probability-of-antigreek and greek? != 1 ;; if a turtle isn't Greek, use a probability to assign turtles as antiGreek
    [ set antigreek? 1
      set greek? 0
      ]
    set year one-of [1 2 3 4] ;; give turtles their year
    set size 2 ;; size is 2 so that they can be seen better
    ]
  
  ask turtles [
    if greek? = 1 [set bias 10] ;; if a turtle is greek, set it's bias to 10
    if antigreek? = 1 [set bias -10] ;; if it's antigreek, set it to -10
     if (greek? != 1 and antigreek? != 1) [set bias 0] ;; if it's neither, set it to 0
    color-year ;; go to this procedure to give turtles their color based on their year
    color-greeks ;; go to this procedure to give turtles their color if they're greek or antigreek
    ]        ;; this color takes presedence over their year color
 
  ask patches[
                   ;;; draws the buildings for this setup
    ;; top left building
    if pxcor > -45 and pxcor < -18 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor > -45 and pxcor < -42 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor > -19 and pxcor < -16 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor > -45 and pxcor < -32 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > -28 and pxcor < -16 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; top right buiding
    if pxcor < 45 and pxcor > 18 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor < 45 and pxcor > 42 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor < 19 and pxcor > 16 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor < 45 and pxcor > 32 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor < 28 and pxcor > 16 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; bottom right building
    if pxcor < 45 and pxcor > 18 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor < 45 and pxcor > 42 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor < 19 and pxcor > 16 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor < 45 and pxcor > 32 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor < 28 and pxcor > 16 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; bottom left building (greek house)
    if pxcor > -45 and pxcor < -35 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > -29 and pxcor < -18 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > -45 and pxcor < -42 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor > -19 and pxcor < -16 and pycor < -17 and pycor > -30[set pcolor yellow]
    if pxcor > -19 and pxcor < -16 and pycor > -47 and pycor < -35[set pcolor yellow]
    if pxcor > -45 and pxcor < -32 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor > -28 and pxcor < -16 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; middle building    
    if pxcor < 13 and pxcor > 2 and pycor < 13 and pycor > 10[set pcolor yellow]
    if pxcor > -15 and pxcor < -2 and pycor < 13 and pycor > 10[set pcolor yellow]
    if pxcor < 15 and pxcor > 12 and pycor < 13 and pycor > 3[set pcolor yellow]
    if pxcor < 15 and pxcor > 12 and pycor > -13 and pycor < -3[set pcolor yellow]
    if pxcor > -15 and pxcor < -2 and pycor > -13 and pycor < -10[set pcolor yellow]
    if pxcor < 15 and pxcor > 2 and pycor > -13 and pycor < -10[set pcolor yellow]
    if pxcor > -15 and pxcor < -12 and pycor < 13  and pycor > 3[set pcolor yellow]
    if pxcor > -15 and pxcor < -12 and pycor < -3  and pycor > -13[set pcolor yellow]
    if pxcor < 13 and pxcor > 2 and pycor < 13 and pycor > 10[set pcolor yellow]
    
    ;; color patches that define greek house (bottom left)
    if pxcor > -43 and pxcor < -18 and pycor < -17 and pycor > -45[set pcolor 97]
    ]
  
  reset-ticks
end

;; this setup should be used in a 50 max x-cor by 50 max y-cor world space 
to setup-greek-house-middle 
  ca
  set rush? 0 ;; rush is initiated to 0 since rush doesn't immediately start at the beginning of the year
  set new-year? 1 ;; a new year starts when the model first runs so this variable is set to 1
  set neg-tick-counter 0  ;; the counters for rush, negative events, and positive events is set to 0
  set pos-tick-counter 0
  set rush-tick-counter 0
  set-default-shape turtles "person" ;; turtle shape is defined
  crt population  [ ;; slider with variable POPULATION determines how many turtles are made
    setxy random-xcor random-ycor ;; turtles are placed randomly in the world
    set just-changed 0 ;; no turtle's year has been updated so this is set to 0
    if random 100 < percent-greek  ;; slider used to determine what percentage of the population is Greek
    [set greek? 1 ;; set the appropriate variables to 1 and 0 if a turtle is Greek
     set antigreek? 0
      ]
    if random 100 < probability-of-antigreek and greek? != 1 ;; if a turtle isn't Greek, use a probability to assign turtles as antiGreek
    [ set antigreek? 1
      set greek? 0
      ]
    set year one-of [1 2 3 4] ;; give turtles their year
    set size 2 ;; size is 2 so that they can be seen better
    ]
  
  ask turtles [
    if greek? = 1 [set bias 10] ;; if a turtle is greek, set it's bias to 10
    if antigreek? = 1 [set bias -10] ;; if it's antigreek, set it to -10
     if (greek? != 1 and antigreek? != 1) [set bias 0] ;; if it's neither, set it to 0
    color-year ;; go to this procedure to give turtles their color based on their year
    color-greeks ;; go to this procedure to give turtles their color if they're greek or antigreek
    ]        ;; this color takes presedence over their year color
 
  ask patches[
    ;;; draws the buildings for this setup
    ;; top left building
    if pxcor > -45 and pxcor < -18 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor > -45 and pxcor < -42 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor > -19 and pxcor < -16 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor > -45 and pxcor < -32 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > -28 and pxcor < -16 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; top right buiding
    if pxcor < 45 and pxcor > 18 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor < 45 and pxcor > 42 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor < 19 and pxcor > 16 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor < 45 and pxcor > 32 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor < 28 and pxcor > 16 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; bottom right building
    if pxcor < 45 and pxcor > 18 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor < 45 and pxcor > 42 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor < 19 and pxcor > 16 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor < 45 and pxcor > 32 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor < 28 and pxcor > 16 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; bottom left building (greek house)
    if pxcor > -45 and pxcor < -35 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > -29 and pxcor < -18 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > -45 and pxcor < -42 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor > -19 and pxcor < -16 and pycor < -17 and pycor > -30[set pcolor yellow]
    if pxcor > -19 and pxcor < -16 and pycor > -47 and pycor < -35[set pcolor yellow]
    if pxcor > -45 and pxcor < -32 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor > -28 and pxcor < -16 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; middle building    
    if pxcor < 13 and pxcor > 2 and pycor < 13 and pycor > 10[set pcolor yellow]
    if pxcor > -15 and pxcor < -2 and pycor < 13 and pycor > 10[set pcolor yellow]
    if pxcor < 15 and pxcor > 12 and pycor < 13 and pycor > 3[set pcolor yellow]
    if pxcor < 15 and pxcor > 12 and pycor > -13 and pycor < -3[set pcolor yellow]
    if pxcor > -15 and pxcor < -2 and pycor > -13 and pycor < -10[set pcolor yellow]
    if pxcor < 15 and pxcor > 2 and pycor > -13 and pycor < -10[set pcolor yellow]
    if pxcor > -15 and pxcor < -12 and pycor < 13  and pycor > 3[set pcolor yellow]
    if pxcor > -15 and pxcor < -12 and pycor < -3  and pycor > -13[set pcolor yellow]
    if pxcor < 13 and pxcor > 2 and pycor < 13 and pycor > 10[set pcolor yellow]
    
    ;; color patches that define greek house (middle)
    if pxcor < 13 and pxcor > -13 and pycor < 11 and pycor > -11[set pcolor 97]
    ]
  
  reset-ticks
end

;; this setup should be used in a 100 max x-cor by 50 max y-cor world space 
to setup-mock-nu 
    ca
  set rush? 0 ;; rush is initiated to 0 since rush doesn't immediately start at the beginning of the year
  set new-year? 1 ;; a new year starts when the model first runs so this variable is set to 1
  set neg-tick-counter 0  ;; the counters for rush, negative events, and positive events is set to 0
  set pos-tick-counter 0
  set rush-tick-counter 0
  set-default-shape turtles "person" ;; turtle shape is defined
  crt population  [ ;; slider with variable POPULATION determines how many turtles are made
    setxy random-xcor random-ycor ;; turtles are placed randomly in the world
    set just-changed 0 ;; no turtle's year has been updated so this is set to 0
    if random 100 < percent-greek  ;; slider used to determine what percentage of the population is Greek
    [set greek? 1 ;; set the appropriate variables to 1 and 0 if a turtle is Greek
     set antigreek? 0
      ]
    if random 100 < probability-of-antigreek and greek? != 1 ;; if a turtle isn't Greek, use a probability to assign turtles as antiGreek
    [ set antigreek? 1
      set greek? 0
      ]
    set year one-of [1 2 3 4] ;; give turtles their year
    set size 2 ;; size is 2 so that they can be seen better
    ]
  
  ask turtles [
    if greek? = 1 [set bias 10] ;; if a turtle is greek, set it's bias to 10
    if antigreek? = 1 [set bias -10 ];; if it's antigreek, set it to -10
     if (greek? != 1 and antigreek? != 1) [set bias 0] ;; if it's neither, set it to 0
    color-year ;; go to this procedure to give turtles their color based on their year
    color-greeks ;; go to this procedure to give turtles their color if they're greek or antigreek
    ]        ;; this color takes presedence over their year color
  
  ask patches[
    ;;; draws the buildings for this setup
    ;; top right-most building
    if pxcor < 98 and pxcor > 64 and pycor < 49 and pycor > 46[set pcolor yellow]
    if pxcor < 98 and pxcor > 95 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor < 67 and pxcor > 64 and pycor < 47 and pycor > 38[set pcolor yellow]
    if pxcor < 67 and pxcor > 64 and pycor < 30 and pycor > 17[set pcolor yellow]
    if pxcor > 64 and pxcor < 77 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor < 98 and pxcor > 85 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; top 1st from right-most buiding
    if pxcor > 23 and pxcor < 56 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor > 23 and pxcor < 26 and pycor < 47 and pycor > 28[set pcolor yellow]
    if pxcor > 23 and pxcor < 26 and pycor < 22 and pycor > 17[set pcolor yellow]
    if pxcor > 53 and pxcor < 56 and pycor < 47 and pycor > 36[set pcolor yellow]
    if pxcor > 53 and pxcor < 56 and pycor < 29 and pycor > 17[set pcolor yellow]
    if pxcor > 23 and pxcor < 37 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > 44 and pxcor < 56 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; top 2nd from the right-most building
    if pxcor > -17 and pxcor < 17 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor > -17 and pxcor < -14 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor > 14 and pxcor < 17 and pycor < 47 and pycor > 17[set pcolor yellow]
    if pxcor >  -17 and pxcor < -4 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > 4 and pxcor < 17 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; top 3rd from right-most buiding
    if pxcor < -20 and pxcor > -56 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor < -20 and pxcor > -23 and pycor < 47 and pycor > 28[set pcolor yellow]
    if pxcor < -20 and pxcor > -23 and pycor < 22 and pycor > 17[set pcolor yellow]
    if pxcor < -55 and pxcor > -58 and pycor < 47 and pycor > 36[set pcolor yellow]
    if pxcor < -55 and pxcor > -58 and pycor < 29 and pycor > 17[set pcolor yellow]
    if pxcor < -20 and pxcor > -37 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor < -45 and pxcor > -58 and pycor < 18 and pycor > 15[set pcolor yellow]
    
    ;; top left-most building (a greek building)
    if pxcor > -97 and pxcor < -64 and pycor < 47 and pycor > 44[set pcolor yellow]
    if pxcor > -67 and pxcor < -64 and pycor < 47 and pycor > 32[set pcolor yellow]
    if pxcor > -67 and pxcor < -64 and pycor < 25 and pycor > 17[set pcolor yellow]
    if pxcor > -97 and pxcor < -94 and pycor < 47 and pycor > 15[set pcolor yellow]
    if pxcor > -76 and pxcor < -64 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > -97 and pxcor < -84 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > -97 and pxcor < -84 and pycor < 18 and pycor > 15[set pcolor yellow]
    if pxcor > -95 and pxcor < -66 and pycor < 45 and pycor > 17[set pcolor 97] 
    
    ;; bottom right-most building (a greek building)
    if pxcor < 97 and pxcor > 64 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor < 67 and pxcor > 64 and pycor > -47 and pycor < -32[set pcolor yellow]
    if pxcor < 67 and pxcor > 64 and pycor > -25 and pycor < -17[set pcolor yellow]
    if pxcor < 97 and pxcor > 94 and pycor > -47 and pycor < -15[set pcolor yellow]
    if pxcor < 76 and pxcor > 64 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor < 97 and pxcor > 84 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor < 97 and pxcor > 84 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor < 95 and pxcor > 66 and pycor > -45 and pycor < -17[set pcolor 97]    
    
    ;; bottom 1st from the right-most building
    if pxcor > 23 and pxcor < 59 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > 23 and pxcor < 26 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor > 56 and pxcor < 59 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor > 23 and pxcor < 37 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor > 46 and pxcor < 59 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; botom 2nd from right-most buiding
    if pxcor > -17 and pxcor < 17 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > -17 and pxcor < -14 and pycor > -47 and pycor < -28[set pcolor yellow]
    if pxcor > -17 and pxcor < -14 and pycor > -22 and pycor < -17[set pcolor yellow]
    if pxcor > 14 and pxcor < 17 and pycor > -47 and pycor < -36[set pcolor yellow]
    if pxcor > 14 and pxcor < 17 and pycor > -29 and pycor < -17[set pcolor yellow]
    if pxcor > 3 and pxcor < 17 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor > -17 and pxcor < -4 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; bottom 3rd from the right-most building
    if pxcor < -20 and pxcor > -56 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor < -20 and pxcor > -23 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor < -55 and pxcor > -58 and pycor > -47 and pycor < -17[set pcolor yellow]
    if pxcor < -20 and pxcor > -37 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor < -45 and pxcor > -58 and pycor > -18 and pycor < -15[set pcolor yellow]
    
    ;; bottom left-most building
    if pxcor > -97 and pxcor < -64 and pycor > -47 and pycor < -44[set pcolor yellow]
    if pxcor > -67 and pxcor < -64 and pycor > -47 and pycor < -28[set pcolor yellow]
    if pxcor > -67 and pxcor < -64 and pycor > -22 and pycor < -17[set pcolor yellow]
    if pxcor > -97 and pxcor < -94 and pycor > -47 and pycor < -36[set pcolor yellow]
    if pxcor > -97 and pxcor < -94 and pycor > -29 and pycor < -17[set pcolor yellow]
    if pxcor > -97 and pxcor < -94 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor > -97 and pxcor < -81 and pycor > -18 and pycor < -15[set pcolor yellow]
    if pxcor > -74 and pxcor < -64 and pycor > -18 and pycor < -15[set pcolor yellow] 
   ]
  
  reset-ticks
end

to go
  set rush-tick-counter ticks mod 400 + 1   ;; keeps track of rush period
  set pos-tick-counter ticks mod pos-event-tick-marker + 1 ;; keeps track of positive tick counter
  set neg-tick-counter ticks mod neg-event-tick-marker + 1 ;; keeps track of negative tick counter
  ask turtles [    
    if new-year? = 1[ ;; if it's a new year,  jump into this procedure
      if rush-tick-counter = 100 ;; if the rush tick counter = 100, start the rush period; set rush? to 1
       [set rush? 1
         check-bias] ;; check turtle biases 
       
      if rush? = 1 and rush-tick-counter <= 175[ ;; if it's rush period and the rush tick counter is less than
        greeks-to-house                          ;; 175, if i'm a greek turtle i'm moving to a greek building
        ]
      if rush-tick-counter > 175[ ;; if the counter is over 175, set new-year? to 0 and rush? to 0 indicating that the rush period is over. 
        set new-year? 0
        set rush? 0
        ]
      ]
    if (neg-tick-counter = neg-event-tick-marker and negative?) ;; if negative events are being using and the negative tick counter = the slider tick marker
    [                                                           ;; jump into the negative event an then reset the negative tick counter
      neg-external-influences
      set neg-tick-counter 0
      ]
     
    if (pos-tick-counter = pos-event-tick-marker and positive?) ;; if positive events are being using and the positive tick counter = the slider tick marker
    [                                                           ;; jump into the positive event an then reset the psoitive tick counter
      pos-external-influences
      set pos-tick-counter 0
      ]
    patch-bias ;; jump into this procedure to determine if i'm over a greek patch (and thus in greek building)
    move ;; move turtle
    interact ;; interact with other turtles
    if ticks mod 400 = 0 and ticks != 0[ ;; if ticks = 400, start a new year
      update-year ;; update the turtles' year variable
      reset-just-changed ;; reset just-changed after updating turtes' year
      set new-year? 1 ;; reset new-year?
    ]
    check-bias ;; check bias again 
  ]
  tick
end

to color-year ;; colors the turtles based on their years
  if year = 1 [set color orange]
  if year = 2 [set color green]
  if year = 3 [set color white]
  if year = 4 [set color brown]
end


;; go procedures

to color-greeks ;; colors greeks and antigreeks
  if antigreek? = 1 [set color 135]
  if greek? = 1 [set color 95]
end

to move ;; moves a turtle
  ifelse [pcolor] of patch-ahead 1 = yellow 
    [
      lt random-float 360 ;; if the patch ahead is yellow, turn randomly
    ]
    [ 
      rt random 90 ;; otherwise turn left and right randomly and then move forward 1
      lt random 90
      fd 1   
    ]
end

to interact ;; procedure that interacts with other turtles
  let int-with one-of turtles in-radius 3 ;; set one of the turles in radius 3 as the turtle to interact with
  let counter 0 ;; counter for while loop
  while [counter != 5][ ;; loop that allows for interaction to happen for a set amount of time
    move-to int-with ;; move to target turtle
    ask int-with[
      let int-with-bias bias ;; get their bias and year
      let int-with-year year
      if greek? = 1 [
        ask myself [
          ifelse greek? = 1 ;; if they're greek and i'm greek
          [set bias bias + (.0025 * int-with-bias)] ;; use this calculation for my bias
          [ifelse (int-with-year - year > 0 and year <= 2) ;; if i'm not greek and they're
            [set bias bias + (.0015 * int-with-bias)] ;; older, use this calculation
            [set bias bias + (.0001 * int-with-bias)] ;; younger, use this calculation
          ]
        ]
      ]
      if antigreek? = 1 [
        ask myself [
          ifelse antigreek? = 1 ;; if they're anti-greek and i'm anti-greek
          [set bias bias + (.0025 * int-with-bias)] ;; use this calculation for my bias
          [ifelse (int-with-year - year > 0 and year <= 2) ;; if i'm not anti-greek and they're
            [set bias bias + (.0015 * int-with-bias)] ;; older, use this calculation
            [set bias bias + (.0001 * int-with-bias)] ;; younger, use this calculation
          ] 
        ]   
      ]
    ]
      set counter counter + 1 ; increase counter
    ]
  
  move
end

to patch-bias
    ask patch-here [
      if pcolor = 97 [
        ask myself [ ;; if i'm on a greek patch, increase my bias
          set bias bias + (house-bias * house-influence)]
      ]
    ]
end

to check-bias
  if bias > 20[ ;; if bias is over 20, turn greek
    set greek? 1
    set antigreek? 0
    set color 95
    ]
  if bias < -20[ ;; if bias is under -20, turn anti-greek
    set greek? 0
    set antigreek? 1
    set color 135
    ] 
end

to neg-external-influences
    set bias bias + (media-negative * negative-influence-%) ;; if using negative media coverage, change bias accordingly
    if school? [set bias bias + (school-influence-% * school-bias)] ;; if school bias is being used, adjust bias as well
end

to pos-external-influences
    set bias bias + (media-positive * positive-influence-%) ;; if using positive media coverage, change bias accordingly
    if school? [set bias bias + (school-influence-% * school-bias)] ;; if school bias is being used, adjust bias as well
end



to update-year ;; updates turtles year
  if year = 1 [ ;; if a turle has year 1, isn't greek or anti-greek, and they didn't just spawn
    if (color != 135 and color != 95 and just-changed != 1)[ ;; update year and color
      set color green
      set year 2
      set just-changed 1 ;; prevents this turtle from changing again in the next if statement
    ]
    if (just-changed != 1)[  ;; if they're greek or anti-greek, just update the year
      set year 2
      set just-changed 1]
  ]
  
  if year = 2[ ;the same procedure is followed if they have year 2 or 3
   if (color != 135 and color != 95 and just-changed != 1)[
     set color white
     set year 3
     set just-changed 1
   ]
   if (just-changed != 1)[ 
     set year 3 
     set just-changed 1
   ]
  ]
  
  if year = 3[
    if (color != 135 and color != 95 and just-changed != 1)[
      set color brown
      set year 4 
      set just-changed 1
    ]
    if (just-changed != 1)[ 
      set year 4
      set just-changed 1
    ]
  ]
        
  if (year = 4 and just-changed != 1) [ ;; hatch a new turtle with year 1 and then die
    hatch 1 [
      set color orange
      set year 1
      set greek? 0
      set antigreek? 0
      set bias 0
      set size 2
      set shape "person"
      set just-changed 1
    ]
    die
  ]
end

to reset-just-changed
   set just-changed 0 ;; reset just-changed to 0 after updating the turtles
end

to greeks-to-house ;; if i'm greek i face a patch that is greek and move towards it
  if color = 95[
    face one-of patches with [pcolor = 97]
    fd 1
  ]

end
@#$#@#$#@
GRAPHICS-WINDOW
546
18
1132
625
50
50
5.703
1
10
1
1
1
0
1
1
1
-50
50
-50
50
0
0
1
ticks
30.0

BUTTON
5
10
111
43
NIL
setup-default
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
93
205
126
percent-greek
percent-greek
0
100
15
1
1
NIL
HORIZONTAL

BUTTON
115
10
209
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
7
53
204
86
population
population
1
400
400
1
1
NIL
HORIZONTAL

SLIDER
5
174
203
207
media-negative
media-negative
-100
-1
-50
1
1
NIL
HORIZONTAL

SLIDER
4
132
205
165
probability-of-antigreek
probability-of-antigreek
0
100
25
1
1
NIL
HORIZONTAL

SLIDER
3
249
204
282
school-bias
school-bias
-100
100
50
1
1
NIL
HORIZONTAL

PLOT
235
331
518
526
number of each
NIL
NIL
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"neither" 1.0 0 -16777216 true "" "plot count turtles with [color != 95 and color != 135]"
"greek" 1.0 0 -7500403 true "" "plot count turtles with [color = 95]"
"anti" 1.0 0 -2674135 true "" "plot count turtles with [color = 135]"

MONITOR
4
519
136
564
NIL
mean [bias] of turtles
17
1
11

SLIDER
2
288
204
321
pos-event-tick-marker
pos-event-tick-marker
0
400
50
1
1
NIL
HORIZONTAL

PLOT
4
331
228
515
bias
NIL
NIL
0.0
10.0
0.0
5.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [bias] of turtles"

SLIDER
3
212
204
245
media-positive
media-positive
0
100
50
1
1
NIL
HORIZONTAL

SWITCH
211
175
321
208
negative?
negative?
0
1
-1000

SWITCH
212
214
322
247
positive?
positive?
0
1
-1000

SLIDER
329
176
503
209
negative-influence-%
negative-influence-%
0
1
0.25
.01
1
NIL
HORIZONTAL

SLIDER
328
214
500
247
positive-influence-%
positive-influence-%
0
1
0.25
.01
1
NIL
HORIZONTAL

SLIDER
328
250
499
283
school-influence-%
school-influence-%
0
1
0.25
.01
1
NIL
HORIZONTAL

SLIDER
209
290
414
323
neg-event-tick-marker
neg-event-tick-marker
0
400
50
1
1
NIL
HORIZONTAL

SWITCH
211
250
321
283
school?
school?
0
1
-1000

BUTTON
214
11
328
45
NIL
setup-mock-nu
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
209
93
381
126
house-bias
house-bias
0
10
10
1
1
NIL
HORIZONTAL

SLIDER
209
132
381
165
house-influence
house-influence
0
.01
0.01
.0001
1
NIL
HORIZONTAL

BUTTON
334
11
517
45
NIL
setup-greek-house-middle\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="negative only - default" repetitions="4" runMetricsEveryStep="true">
    <setup>setup-default</setup>
    <go>go</go>
    <timeLimit steps="800"/>
    <exitCondition>count turtles with [color != 135 and color != 95] = 0</exitCondition>
    <metric>count turtles with [color = 95]</metric>
    <metric>count turtles with [color = 135]</metric>
    <metric>count turtles with [color != 135 and color != 95]</metric>
    <metric>mean [bias] of turtles</metric>
    <enumeratedValueSet variable="pos-event-tick-marker">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-bias">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="400"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="probability-of-antigreek">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-bias">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <steppedValueSet variable="neg-event-tick-marker" first="20" step="20" last="400"/>
    <enumeratedValueSet variable="school?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-greek">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-positive">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-negative">
      <value value="-50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-influence">
      <value value="0.01"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="positive only - default" repetitions="4" runMetricsEveryStep="true">
    <setup>setup-default</setup>
    <go>go</go>
    <timeLimit steps="800"/>
    <exitCondition>count turtles with [color != 135 and color != 95] = 0</exitCondition>
    <metric>count turtles with [color = 95]</metric>
    <metric>count turtles with [color = 135]</metric>
    <metric>count turtles with [color != 135 and color != 95]</metric>
    <metric>mean [bias] of turtles</metric>
    <steppedValueSet variable="pos-event-tick-marker" first="20" step="20" last="400"/>
    <enumeratedValueSet variable="house-bias">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="400"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="probability-of-antigreek">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-bias">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="neg-event-tick-marker">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-greek">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-positive">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-negative">
      <value value="-50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-influence">
      <value value="0.01"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="both - default - negative more frequent (2x) school positive" repetitions="10" runMetricsEveryStep="true">
    <setup>setup-default</setup>
    <go>go</go>
    <timeLimit steps="800"/>
    <exitCondition>count turtles with [color != 135 and color != 95] = 0</exitCondition>
    <metric>count turtles with [color = 95]</metric>
    <metric>count turtles with [color = 135]</metric>
    <metric>count turtles with [color != 135 and color != 95]</metric>
    <metric>mean [bias] of turtles</metric>
    <enumeratedValueSet variable="pos-event-tick-marker">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-bias">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="400"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="probability-of-antigreek">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-bias">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="neg-event-tick-marker">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-greek">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-positive">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-negative">
      <value value="-50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-influence">
      <value value="0.01"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="both - default - positive more frequent (2x) school positive" repetitions="10" runMetricsEveryStep="true">
    <setup>setup-default</setup>
    <go>go</go>
    <timeLimit steps="800"/>
    <exitCondition>count turtles with [color != 135 and color != 95] = 0</exitCondition>
    <metric>count turtles with [color = 95]</metric>
    <metric>count turtles with [color = 135]</metric>
    <metric>count turtles with [color != 135 and color != 95]</metric>
    <metric>mean [bias] of turtles</metric>
    <enumeratedValueSet variable="pos-event-tick-marker">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-bias">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="400"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="probability-of-antigreek">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-bias">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="neg-event-tick-marker">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-greek">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-positive">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-negative">
      <value value="-50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-influence">
      <value value="0.01"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="positive negative school (positive)" repetitions="10" runMetricsEveryStep="true">
    <setup>setup-default</setup>
    <go>go</go>
    <timeLimit steps="800"/>
    <exitCondition>count turtles with [color != 95 or color != 135] = 0</exitCondition>
    <metric>count turtles with [color = 95]</metric>
    <metric>count turtles with [color = 135]</metric>
    <metric>count turtles with [color != 95 and color != 135]</metric>
    <metric>mean [bias] of turtles</metric>
    <enumeratedValueSet variable="pos-event-tick-marker">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-bias">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="400"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="probability-of-antigreek">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="negative-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-bias">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="positive-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="neg-event-tick-marker">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-greek">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-positive">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="media-negative">
      <value value="-50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="school-influence-%">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="house-influence">
      <value value="0.01"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
