breed [oxygens oxygen]
breed [monoxides monoxide]
breed [hemoglobins hemoglobin]
breed [hbo1-complexes hbo1-complex]
breed [hbo2-complexes hbo2-complex]
breed [hbcm1-complexes hbcm1-complex]
breed [hbo1cm1-complexes hbo1cm1-complex]
breed [hbcm2-complexes hbcm2-complex]


to setup
  clear-all
  draw-walls
  create-oxygens Initial_Oxygen
  create-monoxides Initial_Carbon_Monoxide
  create-hemoglobins Initial_Hemoglobin
  ask oxygens [be-oxygen]
  ask monoxides [be-monoxide]
  ask hemoglobins [be-hemoglobin]
  ask turtles [randomize-location]
  reset-ticks
end

; draws the boundaries (walls) of the "billiard table"
to draw-walls
  ; draw left and right walls
  ask patches with [abs pxcor = max-pxcor]
    [ set pcolor gray - 4 ]
  ; draw top and bottom walls
  ask patches with [abs pycor = max-pycor]
    [ set pcolor gray - 4 ]
end

; set random location
to randomize-location
  setxy random-xcor random-ycor
  if pcolor > 0  
    [ randomize-location ]           ; ...try again                  
end

to go
  ask turtles [
    left (random 80) - 40
    bounce
    fd 0.05
    react
  ]
  ask monoxides [
;    if ycor > 19.5 [die]
    if abs ycor < 19 [set ycor ycor + 0.03 * cos (ticks / 10 ) ]
    ]
  tick
end

;; this procedure checks the coordinates and makes the turtles
;; reflect according to the law that the angle of reflection is
;; equal to the angle of incidence
to bounce  ;; turtle procedure
  ; check: hitting left or right wall?
  if abs [pxcor] of patch-ahead 0.01 = max-pxcor
    ; if so, reflect heading around x axis
    [ set heading (- heading) ]
  ; check: hitting top or bottom wall?
  if abs [pycor] of patch-ahead 0.01 = max-pycor
    ; if so, reflect heading around y axis
    [ set heading (180 - heading) ]
  if abs xcor > 19.5 [set xcor int (xcor)]
  if abs ycor > 19.5 [set ycor int (ycor)]
end

to react
  ask hemoglobins
  [
    if (count oxygens-here > 0) and ( random (10 ^ scale-factor) < k1 )
    [
      hatch-hbo1-complexes 1 [be-hbo1-complex]
      ask one-of oxygens-here [die]
      die
    ]
    if (count monoxides-here > 0) and ( random (10 ^ scale-factor) < k4 )
    [
      hatch-hbcm1-complexes 1 [be-hbcm1-complex]
      ask one-of monoxides-here [die]
      die
    ]
  ]

  ask hbo1-complexes
  [
    if random (10 ^ scale-factor) < k1'
    [
      hatch-hemoglobins 1 [be-hemoglobin]
      hatch-oxygens 1 [be-oxygen]
      die
    ]
    if (count oxygens-here > 0) and ( random (10 ^ scale-factor) < k2 )
    [
      hatch-hbo2-complexes 1 [be-hbo2-complex]
      ask one-of oxygens-here [die]
      die
    ]
    if (count monoxides-here > 0) and ( random (10 ^ scale-factor) < k5 )
    [
      hatch-hbo1cm1-complexes 1 [be-hbo1cm1-complex]
      ask one-of monoxides-here [die]
      die
    ]
  ]
  
  ask hbo2-complexes
  [
    if random (10 ^ scale-factor) < k2'
    [
      hatch-hbo1-complexes 1 [be-hbo1-complex]
      hatch-oxygens 1 [be-oxygen]
      die
    ]
  ]
  
  ask hbcm1-complexes
  [
    if random (10 ^ scale-factor) < k4'
    [
      hatch-hemoglobins 1 [be-hemoglobin]
      hatch-monoxides 1 [be-monoxide]
      die
    ]
    if (count oxygens-here > 0) and ( random (10 ^ scale-factor) < k3 )
    [
      hatch-hbo1cm1-complexes 1 [be-hbo1cm1-complex]
      ask one-of oxygens-here [die]
      die
    ]
    if (count monoxides-here > 0) and ( random (10 ^ scale-factor) < k6 )
    [
      hatch-hbcm2-complexes 1 [be-hbcm2-complex]
      ask one-of monoxides-here [die]
      die
    ]
  ]
  
  ask hbo1cm1-complexes
  [
    if random (10 ^ scale-factor) < k5'
    [
      hatch-hbo1-complexes 1 [be-hbo1-complex]
      hatch-monoxides 1 [be-monoxide]
      die
    ]
    if random (10 ^ scale-factor) < k3'
    [
      hatch-hbcm1-complexes 1 [be-hbcm1-complex]
      hatch-oxygens 1 [be-oxygen]
      die
    ]
  ]
  
  ask hbcm2-complexes
  [
    if random (10 ^ scale-factor) < k6'
    [
      hatch-hbcm1-complexes 1 [be-hbcm1-complex]
      hatch-monoxides 1 [be-monoxide]
      die
    ]
  ]
  
end

to be-hemoglobin
  set shape "enzyme act all"
  set color blue
  set size 1
end

to be-oxygen
  set shape "square"
  set color red
  set size 0.3
end

to be-monoxide
  set shape "square"
  set color yellow + 3
  set size 0.3
end

to be-hbo1-complex
  set shape "complex actx allr"
  set color violet
  set size 1
end

to be-hbo2-complex
  set shape "complex actr allr"
  set color magenta
  set size 1
end

to be-hbcm1-complex
  set shape "complex actx ally"
  set color blue
  set size 1
end

to be-hbo1cm1-complex
  set shape "complex actr ally"
  set color violet
  set size 1
end

to be-hbcm2-complex
  set shape "complex acty ally"
  set color blue
  set size 1
end
@#$#@#$#@
GRAPHICS-WINDOW
374
10
1017
674
20
20
15.44
1
10
1
1
1
0
0
0
1
-20
20
-20
20
1
1
1
ticks
30.0

BUTTON
9
10
67
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
80
10
135
43
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
5
411
368
673
Oxygen Saturation
Time
% saturation
0.0
10.0
0.0
100.0
true
false
"" ""
PENS
"saturation" 1.0 0 -5298144 true "" "plot ( 100 * (count hbo2-complexes + (count hbo1-complexes + count hbo1cm1-complexes) / 2) / Initial_Hemoglobin )"

SLIDER
7
180
179
213
k1
k1
0
100
1
1
1
NIL
HORIZONTAL

SLIDER
7
95
179
128
Initial_Hemoglobin
Initial_Hemoglobin
0
30
30
1
1
NIL
HORIZONTAL

SLIDER
7
131
179
164
Initial_Oxygen
Initial_Oxygen
0
1000
1000
1
1
NIL
HORIZONTAL

SLIDER
7
215
179
248
k1'
k1'
0
1
1
0.01
1
NIL
HORIZONTAL

SLIDER
7
250
179
283
k2
k2
0
1000
300
10
1
NIL
HORIZONTAL

SLIDER
7
285
179
318
k2'
k2'
0
1
1
0.01
1
NIL
HORIZONTAL

SLIDER
184
10
361
43
scale-factor
scale-factor
0
10
6
1
1
NIL
HORIZONTAL

SLIDER
187
132
360
165
Initial_Carbon_Monoxide
Initial_Carbon_Monoxide
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
7
320
179
353
k3
k3
0
10000
10000
100
1
NIL
HORIZONTAL

SLIDER
7
356
179
389
k3'
k3'
0
1
1
0.01
1
NIL
HORIZONTAL

SLIDER
186
181
358
214
k4
k4
0
1000
250
10
1
NIL
HORIZONTAL

SLIDER
186
216
358
249
k4'
k4'
0
1
0.05
0.01
1
NIL
HORIZONTAL

SLIDER
186
251
358
284
k5
k5
0
10000
10000
100
1
NIL
HORIZONTAL

SLIDER
186
286
358
319
k5'
k5'
0
1
0.05
0.01
1
NIL
HORIZONTAL

SLIDER
186
321
358
354
k6
k6
0
10000
10000
100
1
NIL
HORIZONTAL

SLIDER
186
356
358
389
k6'
k6'
0
1
0.05
0.01
1
NIL
HORIZONTAL

BUTTON
28
48
120
81
CO-pulse
create-monoxides 20\n [\n   be-monoxide\n   randomize-location\n   ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?


General reaction nomenclature:

                      ---(k1)-->                     ---(k2)-->           
    Hb + 2 O2 + 2 CO               HbO2 + O2 + 2 CO               Hb(O2)2 + 2 CO       
                      <--(k1')---                    <--(k2')---            
       ^     |                          ^     |
       |     |                          |     |
       |     |                          |     |
     (k4')  (k4)                      (k5')  (k5)
       |     |                          |     |
       |     |                          |     |
       |     v                          |     v
                       ---(k3)-->                             
    Hb(CO) + 2 O2 + CO             Hb(O2)(CO) + O2 + CO                
                       <--(k3')---                             
       ^     |
       |     |
       |     |
     (k6')  (k6)
       |     |
       |     |
       |     v
     Hb(CO)2 + 2 O2          
                                                 

Hemoglobin exhibits _**cooperative binding**_ for oxygen.  A single hemoglobin molecule consists of four subunits, each with its own oxygen binding site.  When one of these sites binds oxygen, the other sites' affinity for oxygen is increased.

For simplicity, this model includes only two binding sites per hemoglobin molecule.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

complex actb
false
0
Circle -7500403 true true 0 0 300
Rectangle -13791810 true false 105 0 195 75

complex actg
false
0
Circle -7500403 true true 0 0 300
Rectangle -13840069 true false 105 0 195 75

complex actr
false
0
Circle -7500403 true true 0 0 300
Rectangle -2674135 true false 105 0 195 75

complex actr allr
false
0
Circle -7500403 true true 0 0 300
Rectangle -2674135 true false 105 0 195 75
Rectangle -2674135 true false 105 225 195 300

complex actr ally
false
0
Circle -7500403 true true 0 0 300
Rectangle -2674135 true false 105 0 195 75
Rectangle -1184463 true false 105 225 195 300

complex actr ally cofg
false
0
Circle -7500403 true true 0 0 300
Rectangle -2674135 true false 105 0 195 75
Polygon -13840069 true false 195 -15 195 75 255 30 195 0
Rectangle -1184463 true false 105 225 195 300

complex actw
false
0
Circle -7500403 true true 0 0 300
Rectangle -1 true false 105 0 195 75

complex actx allr
false
0
Circle -7500403 true true 0 0 300
Rectangle -16777216 true false 105 0 195 75
Rectangle -2674135 true false 105 225 195 300

complex actx ally
false
0
Circle -7500403 true true 0 0 300
Rectangle -16777216 true false 105 0 195 75
Rectangle -1184463 true false 105 225 195 300

complex acty
false
0
Circle -7500403 true true 0 0 300
Rectangle -1184463 true false 105 0 195 75

complex acty ally
false
0
Circle -7500403 true true 0 0 300
Rectangle -1184463 true false 105 0 195 75
Rectangle -1184463 true false 105 225 195 300

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dinucleotide
false
0
Polygon -7500403 true true 150 15 90 60 120 120 180 120 210 60
Polygon -7500403 true true 150 180 90 225 120 285 180 285 210 225
Line -7500403 true 90 60 60 60
Line -7500403 true 60 60 60 225
Line -7500403 true 60 225 90 225

dot
false
0
Circle -7500403 true true 90 90 120

enzyme act
false
0
Circle -7500403 true true 0 0 300
Rectangle -16777216 true false 105 0 195 75

enzyme act all
false
0
Circle -7500403 true true 0 0 300
Rectangle -16777216 true false 105 0 195 75
Rectangle -16777216 true false 105 225 195 300

enzyme act all cof
false
0
Circle -7500403 true true 0 0 300
Rectangle -16777216 true false 105 0 195 75
Polygon -16777216 true false 195 -15 195 75 255 30 195 0
Rectangle -16777216 true false 105 225 195 300

enzyme act cof
false
0
Circle -7500403 true true 0 0 300
Rectangle -16777216 true false 105 0 195 75
Polygon -16777216 true false 195 -15 195 75 255 30 195 0

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 270 15 45 285 45

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.1
@#$#@#$#@
setup
set leave-trace? true
go
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
