turtles-own
[
 pmin-water-content ; min water content of patch its on in order to live
 pmax-water-content ; max water content of patch its on in order to live
 cur-water-content ; current water content of turtle
]

patches-own
[
 pwater-content ; patche's water content
]

globals
[
  avg-cur-water-content ;avg water content of patches
  total-water-used-in-irrgn ;total water used in irrigation
  total-killed-from-excess-water ;number of plants killed from excess water
  total-killed-from-less-water ;number of plants killed from less water
  total-water-used-by-crops ; total water used by crop
  total-water-on-farm ; total water content of farm
  time ; time in the simulation. = number of ticks
  abs-rate
  abs-success
  efficiency ; outout measure
  crop-lifespan ; lifespan of current crop
]

to setup
  clear-all
  ;;maize
  if crop-type = "maize" [ ; if maize crop set maize properties
    create-turtles num-plants [
      set shape "plant"
      setxy random-xcor random-ycor
      set crop-lifespan 1300
      set pmin-water-content 100 + random 10
      set pmax-water-content 700 + random 100
      set cur-water-content 300 + random 50
      set color green
    ]
  ]

  ;;peppers
  if crop-type = "peppers" [ ; if pepper crop set pepper properties
    create-turtles num-plants [
      set shape "plant"
      setxy random-xcor random-ycor
      set crop-lifespan 1500
      set pmin-water-content 100 + random 10
      set pmax-water-content 600 + random 100
      set cur-water-content 300 + random 100
      set color blue
    ]
  ]

  ;; rice
  if crop-type = "rice" [ ;set rice properties
    create-turtles num-plants [
      set shape "plant"
      setxy random-xcor random-ycor
      set crop-lifespan 1200
      set pmin-water-content 150 + random 15
      set pmax-water-content 800 + random 100
      set cur-water-content 400 + random 100
      set color red
    ]
  ]
  set total-water-on-farm 0
  ask patches [ ;get total water on farm
    set pwater-content 180 + random 40
    set total-water-on-farm total-water-on-farm + pwater-content
    set pcolor (39.9 - pwater-content / 100 )
  ]
  get-avg-cur-water-content
  set abs-rate 3
  set abs-success 0
  set total-water-used-in-irrgn (sum [pwater-content] of patches)
  set total-killed-from-excess-water 0
  set total-killed-from-less-water 0
  set total-water-used-by-crops 0
  set time 0
  set efficiency 0 ;getter defined below
  set-arrangement
  reset-ticks
end


;; set arrangment or formation of crops based on input
to set-arrangement
  if arrangement = "rows" [setup-rows]
  if arrangement = "evenspread" [setup-es]
end

;; setup equally spaced rows
to setup-rows
  let num-rows 9 ; number of rows to create
  let total-turtles count turtles
  let x-spacing (max-pxcor - min-pxcor) / num-rows ;space between the rows

  ask turtles [
    foreach [0 1 2 3 4 5 6 7]
    [
      if who >= (? * total-turtles / (num-rows - 1)) and who < ((? + 1) * total-turtles / (num-rows - 1))[
        set xcor min-pxcor + x-spacing * (? + 1)
      ]

    ]
    set ycor (min-pycor + ((who mod (total-turtles / (num-rows - 1))) / (total-turtles / (num-rows - 1))) * max-pycor * 2)
  ]
end

;; set up turtles equally spead out equispread arrangment
to setup-es
  let num-rows 24
  let total-turtles count turtles
  let x-spacing (max-pxcor - min-pxcor) / num-rows

  ask turtles [

    foreach [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22]
    [

      if who >= (? * total-turtles / (num-rows - 1)) and who < ((? + 1) * total-turtles / (num-rows - 1))[
        set xcor min-pxcor + x-spacing * (? + 1)
      ]

    ]
    set ycor (min-pycor + ((who mod (total-turtles / (num-rows - 1))) / (total-turtles / (num-rows - 1))) * max-pycor * 2)
  ]
end


to go

  if count turtles <= 1 [ stop ] ; if all plants dead
  if time >= crop-lifespan [ stop ] ;life cycle of crop finished

  diffuse pwater-content 0.1
  check-water
  irrigate
  absorb-water
  use-water
  patches-lose-water
  evaporation
  recolor-patches
  get-avg-cur-water-content
  get-eff
  get-total-water-on-farm
  set time time + 1
  tick
end

; patches lose water to earth
to patches-lose-water ;; patch procedure
  if soil-type = "sand" [
    ask patches [
      set pwater-content pwater-content - 0.3
    ]
  ]
  if soil-type = "loam" [
    ask patches [
      set pwater-content pwater-content - 0.2
    ]
  ]
  if soil-type = "clay" [
    ask patches [
      set pwater-content pwater-content - 0.1
    ]
  ]
  recolor-patches
end

; check water at turtles patch. die accordingly
to check-water ;; turtle procedure
  ;; check if there is too much water on the turtle's patch
  ask turtles [
    let flag 0
    let y pmax-water-content
    ask patch-here [
      if pwater-content > y [
        set flag 1
      ]
    ]
    if flag = 1[
      set total-killed-from-excess-water total-killed-from-excess-water + 1

      die
    ]

  ]

  ;; check if too little water for turtle
  ask turtles [
    let flag 0
    let x pmin-water-content
    ask patch-here [
      if pwater-content < x [
        set flag 1
      ]
    ]
    if flag = 1[
      set total-killed-from-less-water total-killed-from-less-water + 1
      die
    ]
  ]
end

; turtles use the water they absorb
to use-water ;; turtle procedure
  ask turtles [
    set cur-water-content cur-water-content - abs-rate
  ]
end


; absorb water from soil
to absorb-water ;; turtle procedure
  ask turtles[
    set abs-success 0
    let abss 0
    ask patch-here[
      if pwater-content > abs-rate [

        set pwater-content pwater-content - abs-rate

        set abss 1
        ]
      set abs-success 1
      ]
    if abss = 1 [

      set cur-water-content cur-water-content + abs-rate
      set total-water-used-by-crops total-water-used-by-crops + abs-rate
    ]
    set abs-success 0
    set abss 0

  ]
end

to evaporation ;; patch procedure
  ask patches [
    ifelse pwater-content >= evaporation-rate [
      set pwater-content pwater-content - evaporation-rate
    ]
    [
      set pwater-content 0
    ]
  ]
end


to irrigate
  if periodic [
    ;;; repeat the irrigation
    if ticks mod period = 0 [
      if irrigation-type = "drip" [drip-irrigation]
      if irrigation-type = "surface" [surf-irrigation]
      if irrigation-type = "channel" [channel-irrigation]
    ]
  ]
end

;; surface irrigation. add water to every patch
to surf-irrigation ;; patch procedure
  ;;; add water to every patch
  ask patches [
    set pwater-content pwater-content + irrigation-per-patch
    set total-water-used-in-irrgn total-water-used-in-irrgn + irrigation-per-patch
  ]
  recolor-patches
end

;; add water to those patches with turtles on them
to drip-irrigation ;; patch procedure
  ask patches [
    if count turtles-here > 0 [
      set pwater-content pwater-content + irrigation-per-patch
      set total-water-used-in-irrgn total-water-used-in-irrgn + irrigation-per-patch
    ]
  ]
   recolor-patches
end

;; add water in vertical lines
to channel-irrigation ;; patch procedure

  ask patches [
    let x-spacing (max-pxcor - min-pxcor) / 7 ;;9 channels

    if member? pxcor [0 4 7 11 14 -4 -7 -11 -14]
    [
      set pwater-content pwater-content + irrigation-per-patch
      set total-water-used-in-irrgn total-water-used-in-irrgn + irrigation-per-patch
    ]
  ]
   recolor-patches
end

; calcualtes the irrigation efficiency
to get-eff
  set efficiency (total-water-used-by-crops / total-water-used-in-irrgn) * 100
end

;total water on farm is sum of pwaterc-content of patches
to get-total-water-on-farm
  set total-water-on-farm (sum [pwater-content] of patches)
end

;; scale the patch colors from light to dark brown based on water content
to recolor-patches ;; patch procedure
  ask patches [
    set pcolor (39.9 - pwater-content / 100 )
  ]
end

;getter function
to get-avg-cur-water-content
  if count turtles > 0 [
    set avg-cur-water-content (mean [cur-water-content] of turtles)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
10
415
105
448
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
113
415
198
448
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
10
10
200
43
num-plants
num-plants
0
600
500
1
1
NIL
HORIZONTAL

SLIDER
10
50
200
83
evaporation-rate
evaporation-rate
0
10
0.3
0.1
1
mm
HORIZONTAL

SLIDER
10
90
200
123
irrigation-per-patch
irrigation-per-patch
0
100
33
1
1
mm
HORIZONTAL

PLOT
875
310
1057
454
Number of Plants
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles"

MONITOR
655
465
764
510
Total Irrigation
total-water-used-in-irrgn
2
1
11

MONITOR
655
415
870
460
Total Water on Farm
round total-water-on-farm
2
1
11

PLOT
655
10
855
160
avg water content of plants
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot avg-cur-water-content"

SWITCH
10
375
200
408
periodic
periodic
0
1
-1000

SLIDER
10
130
200
163
period
period
1
100
7
1
1
NIL
HORIZONTAL

CHOOSER
10
170
200
215
irrigation-type
irrigation-type
"drip" "surface" "channel"
1

MONITOR
655
315
870
360
Number killed from excess water
total-killed-from-excess-water
17
1
11

MONITOR
655
365
870
410
Number killed from less water
total-killed-from-less-water
17
1
11

PLOT
655
160
855
310
efficiency
NIL
NIL
0.0
10.0
0.0
100.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot efficiency"

CHOOSER
10
270
200
315
soil-type
soil-type
"sand" "loam" "clay"
2

CHOOSER
10
320
200
365
crop-type
crop-type
"maize" "peppers" "rice"
2

MONITOR
770
465
848
510
crop-yield
round 100 * count turtles / num-plants
2
1
11

CHOOSER
10
220
200
265
arrangement
arrangement
"rows" "evenspread"
1

PLOT
855
10
1055
160
avg patch water content
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [pwater-content] of patches"

PLOT
855
160
1055
310
total water on farm
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot total-water-on-farm"

@#$#@#$#@
## WHAT IS IT?

This model simulates a farm during the life cycle of a crop. The user acts like a farmer who chooses how to grow the crop. The user selects the type of crop, soil and irrigation method. The frequency and amount of crop irrigation is chosen so as to maximize the crop yield and make the most efficient use of water. The model runs for the life cycle of the crop. Each plant absorbs and uses the water from the soil. Water is also lost through evaporation and drains into the earth. Crops can die from an excess or lack of water. This model lets the user adjust the parameters in order to see what optimizes their objective.

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

Plants absorb water from the soil. The user irrigates the farm periodically.
Soil patches diffuse 10% of their water content to their neighbors at every tick. Soil loses some amount of water directly to the atmosphere via evaporation. More water is lost down to the earth due to drainage. This depends on the type of soil chosen: sand, clay or loam.
If the soil has too much or too little water then the plant on that patch of soil dies. Individual plants are not identical. Plants of the same crop have slightly differing optimium water content values that very by about 10% between each other. This adds a level of heterogeneity in the crop. This is more realistic as no two peppers are exactly the same.
Based on the parameter values irrigation water is applied to the field every period number of ticks. The color of the patches indicates how much water is present. Dark brown means lots of water, light brown means less water. When the crop starts dying one by one plants die and disappear from the model.


(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

Using the respective sliders set the number of plants, evaporation rate, period and irrigation-amount-per-patch.
Period is the number of ticks in between two successive irrigation actions.
If periodic is turned on then irrigaion will continue automatically once every period. If not on then irrigation will be one time.
Using the respective choosers choose the crop to be grown, the irrigation method to be used, the kind of soil and the arrangement of the crops on the field.
Then hit setup to initialize the model and then hit go.
The model will stop once all turtles are dead or the lifecycle of the crop is over.

The irrigation efficiency is shown in a plot. The number of plants killed from an excess and lack of water are monitored too. The average water content of the plants and the average patch water content is monitored in the top two plots. The crop yield, which is the percentage of initial crops that are still alive, is shown in a monitor window as well. The number of plants is also plotted as a function of time.

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

There are 5 output plots. Notice how the average patch water content zig-zags up and down, but usually have a net rise or fall over the lifespan of the model.
The efficiency plot measurs the percentage of water irrigated that is used by the plants. The plot usually tends to follow a shifted logarithmic curve.
When running the model sometimes you will see that initially a lot of plants die but then the model reaches a somewhat steady number and the population tends to plateau till the end. However in some cases the population suddenly dies out if the conditions are not suitable.


(suggested things for the user to notice while running the model)

## THINGS TO TRY

Try growing rice with sand, clay and loam soils with a 80% yield rate.  Which of the three is the most water efficient?

By changing the number of plants in the slider, you can notice the spacing between the plants changes as well. The more plants there are the closer together they will be. Try drip irrigation on peppers but change the spacing everytime you try. You will see that the efficiency of irrigation is affected by the proximity of neighbouring plants.

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

A button could be added for rain, to introduce a new factor into the model. As of now the model assumes that all water is from artificial irrigation.

Another feature to add would be fertilizers which containt nutrients and chemicals. This could effect the soil content aiding or harming the growth rate of the crops.

This model is a 1 crop farm model. If maybe 2 or 3 types of crops were grown together on the farm that might have interesting effects on the water usage. Alernate croppping is practiced in the real world so to have an extension on that would be useful.


(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

The model has 3 BehaviorSpace experiments. They vary the period and irrigation per patch parameters for the three different crops - rice, maize and peppers - to find the optimal combination that maximizes yield and efficiency. Behavior Space allows the developer to test the model with a very wide range of parameters automatically. This feature is very useful because you can get insights and findings from combinations that you might not have tried manually.

Another feature that is really interesting is the the colors. The patches change shades of brown based on their water content. Netlogo's brown shades range from 30 to 39. I was able to use this window to vary the colors gradually. I find this feature particularly useful as it is different from the hex rbg color code systems.

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

Percolation Model fromt the Netlogo Model Library

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

Brouwer, C. J. _Irrigation Water Management: Irrigation Methods_. Rome: Food and Agriculture Organization of the United Nations, 1985. _www.fao.org_. Food and Agricultural Organization of the United Nations. Web. 2 June 2016.

This model would have not been possible without the guidance of Uri Wilensky, Artur Hjorth, Bryan Head and Elhem Beheshti.

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 6.0-M5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="RiceClaySurfaceSpread_1" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>efficiency</metric>
    <metric>100 * count turtles / num-plants</metric>
    <metric>total-water-used-in-irrgn</metric>
    <metric>total-killed-from-excess-water</metric>
    <metric>total-killed-from-less-water</metric>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="num-plants">
      <value value="500"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="arrangement">
      <value value="&quot;evenspread&quot;"/>
    </enumeratedValueSet>
    <steppedValueSet variable="period" first="1" step="1" last="100"/>
    <enumeratedValueSet variable="irrigation-type">
      <value value="&quot;surface&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evaporation-rate">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="crop-type">
      <value value="&quot;rice&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="soil-type">
      <value value="&quot;clay&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="periodic">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="irrigation-per-patch" first="1" step="1" last="100"/>
  </experiment>
  <experiment name="MaizeLoamChannelRows_1" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>efficiency</metric>
    <metric>100 * count turtles / num-plants</metric>
    <metric>total-water-used-in-irrgn</metric>
    <metric>total-killed-from-excess-water</metric>
    <metric>total-killed-from-less-water</metric>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="num-plants">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="arrangement">
      <value value="&quot;rows&quot;"/>
    </enumeratedValueSet>
    <steppedValueSet variable="period" first="1" step="1" last="100"/>
    <enumeratedValueSet variable="irrigation-type">
      <value value="&quot;channel&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evaporation-rate">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="crop-type">
      <value value="&quot;maize&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="soil-type">
      <value value="&quot;loam&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="periodic">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="irrigation-per-patch" first="1" step="1" last="100"/>
  </experiment>
  <experiment name="PeppersSandDripRows_1" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>efficiency</metric>
    <metric>100 * count turtles / num-plants</metric>
    <metric>total-water-used-in-irrgn</metric>
    <metric>total-killed-from-excess-water</metric>
    <metric>total-killed-from-less-water</metric>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="num-plants">
      <value value="197"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="arrangement">
      <value value="&quot;rows&quot;"/>
    </enumeratedValueSet>
    <steppedValueSet variable="period" first="1" step="1" last="100"/>
    <enumeratedValueSet variable="irrigation-type">
      <value value="&quot;drip&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="evaporation-rate">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="crop-type">
      <value value="&quot;peppers&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="soil-type">
      <value value="&quot;sand&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="periodic">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="irrigation-per-patch" first="1" step="1" last="100"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
