globals [ hutan non-hutan deforestasi max-petani max-industri max-kayu]
breed [petani a-petani]
breed [baja a-baja]
breed [industri a-industri]
breed [kayu a-kayu]
breed [KLHK a-klhk]

turtles-own [energy]
patches-own [countdown]

to setup
  clear-all
  set hutan count patches with [pcolor = green]
  set non-hutan count patches with [pcolor = yellow]
  set non-hutan count patches with [pcolor = red]
  reset-ticks
  lahan
  petani-hr
  jual-kayu
  industri-kayu
  populasi-kayu
  kayu-hr
pemerintah
end

to go
  move
  if  hutan < 0 [stop]
 if Wood_market? [
    ask petani [
      konversi-lahan
      bangun-hutan
      dampak-baja
      populasi-kayu
      perbaikan-lev
      kartel
    ]
                        ]
     ask industri [
      tumbuh-industri
          ]

if Base_price_policy? [
    ask KLHK [
      mengendalikan-harga-kayu
    bangun-hutan
    ]
    if Wood-price < Forest-cost [
      ask klhk [
        set Wood-price Wood-price > Forest-cost - 1 / Forest_growth_time ]
    ]
     ]
  set hutan count patches with [pcolor = green]
  set non-hutan count patches with [pcolor = yellow ]
  set deforestasi count patches with [pcolor = red]
  tick
  end

to lahan
  ask patches [
      set pcolor one-of [ green yellow ]
      if-else pcolor = green
        [ set countdown Forest_growth_time ]
        [ set countdown random Forest_growth_time ]
          ]
end

to petani-hr
   set max-petani 100
  set-default-shape petani "person"
  create-petani Number_initial_farmers
  [
    set color 10 + 2
    set size 1.5  ; easier to see
    set label-color red - 2
    setxy random-xcor random-ycor
  ]
end

to industri-kayu
   set max-industri 50
  set-default-shape industri "building store"
  create-industri Number_initial_industry
  [
    set color 100 + 2
    set size 1.5  ; easier to see
    set label-color red - 2
    setxy random-xcor random-ycor
  ]
end

to move
  ask petani [
    right random 180
    forward 1
  set energy energy - 2]
end

to jual-kayu
  if Wood_market? [
    set Wood-price Wood-price + 0.001
    set Wood-price Wood-price - 0.01]

end
to konversi-lahan
  if Wood-price < Forest-cost [
    if pcolor = green [
      set pcolor red]
   ]
end

to bangun-hutan
  if Wood-price > Forest-cost [
    if pcolor = red [
      set pcolor green]]
end

to dampak-baja
  if Light_steel_market? [
    set Wood-price Wood-price - 0.0000001]
end
to kayu-hr
  ask kayu [
    set max-kayu wood-population ]
end

to populasi-kayu
  if Forest-cost > Wood-price [
    set wood-population wood-population + 0.01
    set wood-population wood-population - 0.01
  ]
end

to tumbuh-industri
  if Wood_market? [
  ask industri [
    hatch 0.1 [ rt random-float 360 fd 1 ]
     set energy energy + 2
     ]
  ]
end

to tumbuh-petani
  if Wood_market? [
    if Wood-price > Forest-cost [
      ask petani [
        hatch 0.1 [ rt random-float 360 fd 1 ]
      ]

    ]
  ]
  end

to mengendalikan-harga-kayu
  if Wood-price <  Forest-cost [
    set Wood-price 0.7
  ]
end

to perbaikan-LEV
  if Base_price_policy? [
    set Forest-cost Forest-cost + ( 1 / ((1000000 * Forest_growth_time ) + Number_initial_industry ))
    if Wood-price < Forest-cost [
      set Forest-cost Forest-cost - ( 1 / ((1000000 * Forest_growth_time ) + Number_initial_industry ))

  ]
  ]
end


to pemerintah
   set-default-shape KLHK "person police"
  create-klhk 1
  [
    set color 93 + 2
    set size 3  ; easier to see
    set label-color green - 2
    setxy random-xcor -2
  ]
end

to kartel
  if  Trade_cartel? [
    set Wood-price Wood-price + (Forest-cost - Wood-price) + 0.01
    create-links-to other petani
    ask out-link-neighbors [ set color white ]
    create-links-to other industri
    ask out-link-neighbors [ set color blue ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
886
10
1323
448
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

SLIDER
239
155
445
188
Forest_growth_time
Forest_growth_time
5
25
5.0
1
1
Year
HORIZONTAL

BUTTON
20
115
143
148
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
20
152
144
185
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
239
191
446
224
Number_initial_farmers
Number_initial_farmers
1
100
25.0
1
1
Person
HORIZONTAL

SWITCH
21
226
194
259
Wood_market?
Wood_market?
0
1
-1000

PLOT
454
11
880
431
Resources
Time
Resource
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"Hutan" 1.0 0 -14439633 true "plot count patches with [pcolor = green]" "plot hutan"
"Non-Hutan" 1.0 0 -1184463 true "" "plot non-hutan"
"Deforestasi" 1.0 0 -2674135 true "" "plot deforestasi"
"Petani" 1.0 0 -13791810 true "plot count petani" "plot count petani"
"Industri-kayu" 1.0 0 -5825686 true "plot count industri" "plot count industri"
"Kayu" 1.0 0 -955883 true "plot count kayu" "plot count kayu"

SLIDER
20
308
442
341
Wood-price
Wood-price
0
1
0.7083945636153329
0.01
1
Juta Rp/tree
HORIZONTAL

SLIDER
19
346
442
379
Forest-cost
Forest-cost
0
1
0.7163945636153329
0.01
1
Juta Rp/Tree
HORIZONTAL

SWITCH
240
264
445
297
Light_steel_market?
Light_steel_market?
1
1
-1000

SLIDER
240
227
445
260
Number_initial_industry
Number_initial_industry
0
50
5.0
1
1
Unit
HORIZONTAL

SLIDER
19
381
441
414
Wood-population
Wood-population
1
400
400.0
1
1
NIL
HORIZONTAL

SWITCH
20
189
194
222
Base_price_policy?
Base_price_policy?
1
1
-1000

SWITCH
22
263
194
296
Trade_cartel?
Trade_cartel?
1
1
-1000

TEXTBOX
23
17
453
113
PRIVATE FOREST PERFORMANCE AS RESULT OF ACTORS INTERACTION IN BUILDING RAW MATERIALS TRADING
18
130.0
1

@#$#@#$#@
## Masalah Model?

Pembangunan hutan rakyat bertujuan untuk memenuhi permintaan kayu domestik maupun regional. Setiap lahan yang dibangun membutuhkan biaya dan oleh karena itu, ada harapan keuntungan atas biaya yang dikorbankan. Semakin tinggi harga kayu terhadap nilai harapan maka pembangunan hutan rakyat akan terus berlangsung. dan sebaliknya. Pasar kayu ditentukan oleh banyak agen industri pengolahan kayu. Harga jual kayu akan terkoreksi bila ada kompetitot pasar seperti baja ringan. 
Tingginya permintaan pasar baja ringan mengakibatkan harga kayu merosot dan berada dibawah nilai harapan keuntungan. Akibatnya petani hutan rakyat tidak ingin menggunakan lahannya untuk pohon dan mengonversi untuk peruntukan lain seperti permukiman, kebun dan bahkan menelantarkan lahan tersebut.
Bila pemerintah tidak mengambil tindakan maka harapan partisipasi akan semakin menurun. Untuk itu, pemerintah harus mengendalikan harga kayu di atas nilai harapan

## Bagaimana model ini bekerja

-. Petani akan menanam pohon di lahan yang peruntukkannya untuk hutan, dengan biaya tertentu sehingga memiliki nilai harapan atas keuntungan tersebut. keinginan untuk menanam akan menurun bila harga kayu turun di bawah ambang batas harapan. petani akan mengonversi lahan untuk peruntukkan lain.

-. Industri akan membeli kayu rakyat. Bila ketersediaan hutan rakyat makin menurun maka bisnis kayu rakyat akan melemah. Hal ini disebabkan oleh kompetitor hasil industri kayu yang lebih awet, murah dan mudah untuk diperoleh serta diterima konsumen.

-. Agen pedagang baja ringan. Memainkan pasar dengan produk dan harga yang relatif murah.

-. Pemerintah bertanggung jawab untuk mengendalikan mekanisme pasar sehingga harga kayu tidak terjun bebas.

## Bagaimana menjalankan model ini?

-. Setting jumlah petani dan industri, serta switch-off pasar-baja dan pasar kayu. 
-. Seting harga kayu > LE kayu. Klik setup dan kemudian klik GO
-. Switch-on pasar kayu dan go
-. Switch-off pasar baja. Go
-. Bila harga kayu < lev maka deforestasi.
-. Swotchon kebijakan? agar ada peran pemerintah. Klik Go


## Hal yang harus dicatat

harga kayu dan lEV. Perhatikan koreksi harga kayu yang terjadi

## THINGS TO TRY

Ubahlah harga kayu, LEV dan swith kebijakan serta pasar baja

## Perluasan model

Ubahlah konstanta pengurangan harga kayu akibat pasar baja ringan

## CREDITS AND REFERENCES
Prey and preador dari Uri Wilensky
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

building store
false
0
Rectangle -7500403 true true 30 45 45 240
Rectangle -16777216 false false 30 45 45 165
Rectangle -7500403 true true 15 165 285 255
Rectangle -16777216 true false 120 195 180 255
Line -7500403 true 150 195 150 255
Rectangle -16777216 true false 30 180 105 240
Rectangle -16777216 true false 195 180 270 240
Line -16777216 false 0 165 300 165
Polygon -7500403 true true 0 165 45 135 60 90 240 90 255 135 300 165
Rectangle -7500403 true true 0 0 75 45
Rectangle -16777216 false false 0 0 75 45

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person police
false
0
Polygon -1 true false 124 91 150 165 178 91
Polygon -13345367 true false 134 91 149 106 134 181 149 196 164 181 149 106 164 91
Polygon -13345367 true false 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -13345367 true false 120 90 105 90 60 195 90 210 116 158 120 195 180 195 184 158 210 210 240 195 195 90 180 90 165 105 150 165 135 105 120 90
Rectangle -7500403 true true 123 76 176 92
Circle -7500403 true true 110 5 80
Polygon -13345367 true false 150 26 110 41 97 29 137 -1 158 6 185 0 201 6 196 23 204 34 180 33
Line -13345367 false 121 90 194 90
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Rectangle -16777216 true false 109 183 124 227
Rectangle -16777216 true false 176 183 195 205
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Polygon -1184463 true false 172 112 191 112 185 133 179 133
Polygon -1184463 true false 175 6 194 6 189 21 180 21
Line -1184463 false 149 24 197 24
Rectangle -16777216 true false 101 177 122 187
Rectangle -16777216 true false 179 164 183 186

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
