breed [ particles particle ]  ;; the things that are affected by the field
breed [ vectors vector ]    ;; the vectors that affect the particles
breed [ seacows seacow ]
breed [ seaelefants seaelefant ]


globals
[
  max-modulus  ;; the maximum modulus of all the vectors
  step-size    ;; the amount a particle moves forward
  zufall-head
  zufall-border
  zufall-himmelsrichtung
  FULL
  OK
  count-caught
  money
  seacow-number
  plastic-total
  A
  caught
]

seacows-own [volume volume-status]
vectors-own [modulus]  ;; the length of the vector
particles-own [weight]
seaelefants-own [elefant-volume]

; ##################### SETUP ########################

to setup
  clear-all
  setup-vectors
  add-initial-plastic
  add-seacow
  add-seaelefants
  add-marks
  set plastic-total 73400000
  set caught 0
  reset-ticks
end


; ##################### GO ########################

to go
  ;if ticks >= 30000 [ stop ]
  let stop? false

  add-river-plastic
  add-plastic-flow
  move-particles

  seacow-volume-check

  ask seacows [
    if volume-status = "OK"
    [move-seacows
      collect-plastic
    ]
    if volume-status = "FULL"
    [go-seaelefant]
  ]

  ask seacows [ fd 4 / 10 ]

  move-seaelefants
  ask seaelefants [ fd elefant-speed / 10 ]

  tick
  ;; if one of the particles was going to wrap around the world, stop.
  if stop?
  [ stop ]
end

; ##################### SEACOWS ########################

to add-seacow
  create-seacows seacows-number
  [
    setxy -117 -117
    set size 5
    set heading 0
    set color white
    set volume 0
    set seacow-number seacow-number + 1
  ]
end


to move-seacows

  if search-algo = "random"
    [
      search-random
  ]

  if search-algo = "circuit seaelefant"
  [
    ifelse distance one-of seaelefants > max-distance-seacow and 2000 >= volume
    [face one-of seaelefants]
    [rt random 10
      lt random 10
    ]
  ]
end

to search-random
  ifelse distancexy 0 0 > max-distance-seacow and volume-status = "OK"
  [facexy 0 0]
  [rt random 10
    lt random 10]
end

to with-the-flow
  if zufall-head > 1
    [ set heading (atan force-x force-y) ]
  if patch-ahead 1 != nobody
    [ forward stroemung / 20 ]
end


to seacow-volume-check
  ask seacows [
    if volume < 2000
      [set volume-status "OK"]
    if volume >= 2000
      [set volume-status "FULL"
        set label-color red ]

    set label precision volume 2
  ]
end


to collect-plastic
  ask seacows
  [
    let parthere particles-here
    let total-weight-collected 0
    ask parthere
    [
      let weight-loss (weight * 0.0004)
      set weight weight - weight-loss
      if weight < 10 [die]

      set total-weight-collected total-weight-collected  + weight-loss

    ]
    set volume volume + total-weight-collected
  ]
end


to go-seaelefant
  ask seacows with [volume >= 2000]
  [face one-of seaelefants ]
  if distance one-of seaelefants < 1
    [ set caught caught + volume
      set plastic-total plastic-total - volume
      set volume-status "OK"
      set volume 0
      set label-color white
      facexy 0 0
      output-show one-of ["fuckin' plastic" "ahoi!" "plastic kills!" "love ya all" "anybody out there?" "attention. some big waves comin in" "save the planet!" "I am so lonely out here" "Arrrrgh!!!" "May day, whiskey bottle empty" "Plastic-free zone"]
  ]
end


; #################### SEAELEFANT ######################

to add-seaelefants
  create-seaelefants 1
  [
    setxy 40 0
    set size 5
    set heading 0
    set label elefant-volume
    set color yellow
    set elefant-volume 0
  ]

end


to move-seaelefants
  ask seaelefants
    [
      ifelse distancexy 0 0 > max-dist-center-elefant
      [facexy 0 0]
        [rt random 10
        lt random 10]
  ]

  ;set A max-distance-to-center-or-seaelefant * max-distance-to-center-or-seaelefant * 3.14
  ;ifelse (count particles with [distance one-of seacows < max-distance-to-center-or-seaelefant ] < min-conc-before-chance / A)
  ;[move-to patch-left-and-ahead 45 1]
  ;[facexy 0 100]
  ; [set heading (atan force-x force-y)

end


; ##################### ADD PLASTIC ########################


to add-initial-plastic

  create-particles amount-classI
  [
    let xpos random-normal 0 world-width * 0.12
    let ypos random-normal 0 world-height * 0.12

    set xpos max list (min list xpos max-pxcor) min-pxcor
    set ypos max list (min list ypos max-pycor) min-pycor

    setxy xpos ypos
    set size 0.1
    set color 125
    set weight 310                                                             ;kg pro Agent
  ]

  create-particles amount-classII
  [
    let xpos random-normal 0 world-width * 0.12
    let ypos random-normal 0 world-height * 0.12

    set xpos max list (min list xpos max-pxcor) min-pxcor
    set ypos max list (min list ypos max-pycor) min-pycor

    setxy xpos ypos
    set size 0.3
    set color 115
    set weight 860
  ]


  create-particles amount-classIII
  [
    let xpos random-normal 0 world-width * 0.12
    let ypos random-normal 0 world-height * 0.12

    set xpos max list (min list xpos max-pxcor) min-pxcor
    set ypos max list (min list ypos max-pycor) min-pycor

    setxy xpos ypos
    set size 0.8
    set color 105
    set weight 8250
  ]

  create-particles amount-classIV
  [

    let xpos random-normal 0 world-width * 0.12
    let ypos random-normal 0 world-height * 0.12

    set xpos max list (min list xpos max-pxcor) min-pxcor
    set ypos max list (min list ypos max-pycor) min-pycor

    setxy xpos ypos
    set size 1.2
    set color 95
    set weight 1060
  ]
end


to add-plastic-flow
  create-particles plastic-flow-random
  [
    set zufall-himmelsrichtung random 4
    if zufall-himmelsrichtung = 0
    [setxy 200 0]
    if zufall-himmelsrichtung = 1
    [setxy -200 -0]
    if zufall-himmelsrichtung = 2
    [setxy -0 200]
    if zufall-himmelsrichtung = 3
    [setxy 0 -200]
    set size 1
    set heading 0
    set color yellow
  ]
end


to add-river-plastic
  create-particles plastic-flow-river
  [
    setxy -200 0
    set size 1
    set heading 0
    set color yellow
  ]
end


to move-particles
  ask particles
  [
    set zufall-head random 100

    if zufall-head < pull-effect
      [ face patch 0 0
        forward stroemung / 3 ]

    if zufall-head < move-randomness
      [set heading random 360
        forward stroemung / 10 ]

    set heading (atan force-x force-y)
    forward stroemung / 10
  ]
end


; ##################### WORLD ########################

;; report true if we will wrap around if we move forward by step-size
to-report going-to-wrap?  ;; turtle procedure
  let next-patch patch-ahead step-size
  report next-patch = nobody
end

to add-marks
  ask patches at-points [ [50 0] [50 1] [50 2] [50 -1] [50 -2] [100 0] [100 1] [100 2] [100 -1] [100 -2] ]
  [set pcolor white]
  ask patches at-points [ [0 0] [0 1] [0 2] [0 -1] [0 -2] [1 0] [2 0] [-1 0] [-2 0] ]
  [set pcolor white]
  ask patches at-points [ [-119 -119] [-119 -118] [-119 -117] [-118 -118] [-117 -119] [-117 -118] [-117 -117]]
  [set pcolor white]
end

; ##################### CREATE VECTOR FIELD ########################

;; create vectors at regular intervals to see the effect of the force
;; at a particular place.
to setup-vectors
  ask patches
  [
    if (pxcor mod 13 = 0) and (pycor mod 13 = 0)
    [
      sprout-vectors 1
      [ setup-vector ]
    ]
  ]
  set max-modulus (max [modulus] of vectors)                ;; draw vector field
  ask vectors [ show-vector ]
end

;; calculate the horizontal force where the turtle is located
to-report force-x  ;; turtle procedure
  report ycor
end

;; calculate the vertical force where the turtle is located
to-report force-y  ;; turtle procedure
  report (- xcor)
end

;; draw the vector using a turtle to display strength and direction of field
to show-vector  ;; turtle procedure
  set modulus (10 * modulus / max-modulus)
  forward modulus
  set color yellow
end

;; make the turtle become a vector and initialize the vector's variables
to setup-vector  ;; turtle procedure
  set color blue
  pen-down
  if (force-x != 0) or (force-y != 0)
    [ set heading atan force-x force-y ]
  set modulus distancexy 0 0
end

; Copyright 2017 Dominik Huter
@#$#@#$#@
GRAPHICS-WINDOW
318
13
1128
824
-1
-1
2.0
1
10
1
1
1
0
0
0
1
-200
200
-200
200
1
1
1
ticks
30.0

BUTTON
29
33
143
66
setup-field
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
171
33
285
66
go
go \n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
9
312
308
462
Plastic [kg]
ticks
particles
0.0
1000.0
0.0
1000.0
true
true
"" ""
PENS
"free" 1.0 0 -2674135 true "plot count particles" "plot plastic-total"
"caught" 1.0 0 -13345367 true "" "plot caught"

MONITOR
10
477
65
522
particles
count particles
17
1
11

BUTTON
122
699
217
758
buy seacows
add-seacow
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
17
639
160
684
search-algo
search-algo
"random" "circuit seaelefant"
0

SLIDER
18
590
156
623
elefant-speed
elefant-speed
0
5
2.0
0.2
1
NIL
HORIZONTAL

SLIDER
9
216
150
249
plastic-flow-random
plastic-flow-random
0
3
0.0
1
1
NIL
HORIZONTAL

SLIDER
168
216
310
249
plastic-flow-river
plastic-flow-river
0
3
0.0
1
1
NIL
HORIZONTAL

SLIDER
16
131
156
164
pull-effect
pull-effect
0
3
0.0
1
1
NIL
HORIZONTAL

SLIDER
162
131
302
164
move-randomness
move-randomness
0
90
50.0
1
1
NIL
HORIZONTAL

SLIDER
49
170
266
203
stroemung
stroemung
0
2
0.4
0.1
1
NIL
HORIZONTAL

MONITOR
72
478
171
523
caught plastic [kg]
caught
0
1
11

INPUTBOX
17
698
110
758
seacows-number
160.0
1
0
Number

OUTPUT
16
767
308
848
8

PLOT
1147
14
1347
164
distribution
ticks
count particles
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"0 - 200 km" 1.0 0 -2674135 true "" "plot count particles with [distancexy 0 0 < 20]"
"200 - 400 km" 1.0 0 -955883 true "" "plot count particles with [distancexy 0 0 > 20 and distancexy 0 0 < 40]"
"400 - 600 km" 1.0 0 -14835848 true "" "plot count particles with [distancexy 0 0 > 40 and distancexy 0 0 < 60]"
"600 - 800 km" 1.0 0 -13791810 true "" "plot count particles with [distancexy 0 0 > 60 and distancexy 0 0 < 80]"
"800 - 100 km" 1.0 0 -5825686 true "" "plot count particles with [distancexy 0 0 > 80 and distancexy 0 0 < 100]"

MONITOR
1150
292
1297
337
concentration (250-500 km)
(count particles with [distancexy 0 0 > 25 and distancexy 0 0 < 50]) / ((500 * 500 - 250 * 250) * 3.14) * 100000000
0
1
11

MONITOR
1150
340
1297
385
concentration (500-750 km)
(count particles with [distancexy 0 0 > 50 and distancexy 0 0 < 75]) / ((750 * 750 - 500 * 500) * 3.14) * 100000000
0
1
11

MONITOR
1150
388
1323
433
concentration (750-1000 km)
(count particles with [distancexy 0 0 > 75 and distancexy 0 0 < 100]) / ((1000 * 1000 - 750 * 750) * 3.14) * 100000000
0
1
11

MONITOR
1150
244
1297
289
concentration (0-250 km)
(count particles with [distancexy 0 0 < 25] / (250 * 250 * 3.14) * 100000000)
0
1
11

INPUTBOX
1162
608
1248
668
amount-classII
0.0
1
0
Number

INPUTBOX
1162
667
1248
727
amount-classIII
660.0
1
0
Number

INPUTBOX
1162
726
1248
786
amount-classIV
300.0
1
0
Number

TEXTBOX
1166
795
1485
851
plastic particles: reality scale-up: 10^8\nleft: initial value (input)\nright: monitors
11
0.0
1

MONITOR
178
479
308
524
kg plastic remaining [%]
plastic-total
4
1
11

TEXTBOX
1364
344
1455
434
concentrations per square kilometer (in dependence of distance in km from center)
11
0.0
1

TEXTBOX
1375
33
1525
103
this graph shows the development of the particle distribution to guarantee / follow the stability of the \"plastic swirl\" 
11
0.0
1

MONITOR
1335
245
1478
290
concentration (0-1100 km)
(count particles with [distancexy 0 0 < 110 ]) / ((1100 * 1100) * 3.14) * 100000000
0
1
11

INPUTBOX
1162
548
1248
608
amount-classI
0.0
1
0
Number

MONITOR
1335
295
1559
340
particles inside accumulation zone [%]
(count particles with [distancexy 0 0 < 110 ]) / count particles * 100
2
1
11

SLIDER
169
639
311
672
max-distance-seacow
max-distance-seacow
0
150
100.0
10
1
NIL
HORIZONTAL

SLIDER
169
591
312
624
max-dist-center-elefant
max-dist-center-elefant
0
100
60.0
1
1
NIL
HORIZONTAL

MONITOR
1269
728
1364
773
amount-classIV
count particles with [size = 1.2]
17
1
11

MONITOR
1269
669
1364
714
amount-classIII
count particles with [size = 0.8]
0
1
11

MONITOR
1269
612
1364
657
NIL
amount-classII
17
1
11

MONITOR
1269
550
1364
595
amount-classI
count particles with [size = 0.1]
17
1
11

TEXTBOX
1320
435
1470
453
choose a net mesh size
11
0.0
1

TEXTBOX
1390
565
1540
583
0.33-1.00 mm
11
0.0
1

TEXTBOX
1392
626
1542
644
1.00-4.75 mm\n
11
0.0
1

TEXTBOX
1393
684
1543
702
4.75-200 mm
11
0.0
1

TEXTBOX
1394
742
1544
760
> 200 mm
11
0.0
1

TEXTBOX
1392
515
1542
533
particles sizes
11
0.0
1

TEXTBOX
20
557
271
591
Inputs Seacows & Seaelefant
16
0.0
1

TEXTBOX
17
279
167
299
Progress Monitors
16
0.0
1

TEXTBOX
20
97
305
126
Current Parameters & Plastic Income
16
0.0
1

TEXTBOX
1153
208
1438
226
Particle Concentration Monitors
16
0.0
1

TEXTBOX
1163
511
1313
531
Particle Quantity
16
0.0
1

@#$#@#$#@
## WHAT IS IT?

This is a mathematical model that demonstrates abstract vector fields and integral curves.

Generally speaking, a field is a "region in which a body experiences a force as the result of the presence of some other body or bodies.  A field is thus a method of representing the way in which bodies are able to influence each other.  For example, a body that has mass is surrounded by a region in which another body that has mass experiences a force tending to draw the two bodies together.... The strength of any field can be described as the ratio of the force experienced by a small appropriate specimen to the relevant property of that specimen, e.g. force/mass for the gravitational field"  (Oxford Minidictionary of Physics).

By 'abstract vector fields' we mean that this model is not committed to any specific type of force, such as gravity or magnetism.  Rather, it simulates a general field, in which some focal property of influence affects a "small appropriate specimen", or particle, placed in the field.

Normally, if you look at a field with bare eyes, you will not necessarily see the forces.  For instance, if you drop an apple it falls down, even though you cannot see the gravitational force.  The apple is an object in the gravitational field.  You saw how it behaved so you could guess that there is some force that made it go down.  Humans do not perceive (visually) forces of gravitation or electro-magnetic forces.  However, in a model, we can use little arrows (vectors) to show where, how forceful, and in which direction there are forces in this field.

## HOW IT WORKS

In this model, the field is plotted using vector graphics: green streaks are individual vectors with yellow turtles serving as arrowheads.  The length of each vector is roughly proportional to the magnitude of the vector field at each point.  In this model, it is just the distance from the origin: The further away from the origin, the larger the vector.  Also, all vectors are aimed clockwise along tangents to circles centered on the origin.

The vectors show you in what direction and how forcefully an appropriate specimen -- here, a 'particle' -- will be "knocked about" once it is placed the field.  Once the particle is "knocked" to a new location, it will be knocked yet again by the force there (represented by the vector).  Actually, it being "knocked about" continuously, but in this simulation, the "knock" occurs at discrete points in the field.  Since the particle does not use up the forces, it will keep being knocked about.  The path the particle takes is called its 'trajectory.'  You will be able to track this trajectory because the particle will leave a red trail behind it as it moves along its trajectory.  Trajectories in vector fields are called 'integral curves.'

Even though behavior of particles can be interesting and possibly unanticipated, owing to forces not being distributed uniformly in the field, or some other factor, we have chosen, for clarity, a vector field with a logical and consistent relation between location in space and size/orientation of the force.  The vector field chosen for this particular model is

```text
- y d/dx  +  x d/dy
```

Ideally, in the particular force field modeled here, the particle trajectories should be concentric circles (that is, the particle should go round and round along the same circular trajectory).

## HOW TO USE IT

SETUP: Clears the world and computes the vector field.
PLACE-PARTICLES: Puts the program into the mode in which you can position red test-particles by clicking anywhere in the View.
GO: Runs the simulation continuously to show the integral curves.

## THINGS TO NOTICE

Notice that the vectors grow in length as you move away from the origin.  What effect do short vectors have on a particle?  Long vectors?

The way this model is programmed, each particle moves some finite amount before calculating its new heading.  Therefore, the particles do not turn as much as they would if their headings were continuously recalculated.  This causes their trajectories to spiral slowly outward.  (You have to let the model run for a while before this becomes apparent.)  We tried to minimize this by having the particles move forward only a very small amount at each time step (the variable `step-size`).  We couldn't make this amount too small since the model would then run too slowly.  If you want the particles to spiral less, or you want the model to run faster, change this value.

## THINGS TO TRY

Place particles in different parts of the world.  Does the particle's position have any effect on the trajectory?

## EXTENDING THE MODEL

Try a different vector field by changing it in the `setup-vector`, `force-x`, and `force-y` procedures.  For instance, if you choose

```text
x d/dx - y d/dy
```

the integral curves will be hyperbolas.

## HOW TO CITE

If you mention this model or the NetLogo software in a publication, we ask that you include the citations below.

For the model itself:

* Wilensky, U. (1998).  NetLogo Vector Fields model.  http://ccl.northwestern.edu/netlogo/models/VectorFields.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 1998 Uri Wilensky.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

This model was created as part of the project: CONNECTED MATHEMATICS: MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL MODELS (OBPML).  The project gratefully acknowledges the support of the National Science Foundation (Applications of Advanced Technologies Program) -- grant numbers RED #9552950 and REC #9632612.

This model was converted to NetLogo as part of the projects: PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT. The project gratefully acknowledges the support of the National Science Foundation (REPP & ROLE programs) -- grant numbers REC #9814682 and REC-0126227. Converted from StarLogoT to NetLogo, 2002.

<!-- 1998 2002 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

boat3
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 37 172 45 188 59 202 79 217 109 220 130 218 147 204 156 158 156 161 142 170 123 170 102 169 88 165 62
Polygon -7500403 true true 149 66 142 78 139 96 141 111 146 139 148 147 110 147 113 131 118 106 126 71

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
setup
place-particle 0 max-pycor - 3
repeat 50000 [ go ]
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" sequentialRunOrder="false" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="15000"/>
    <metric>caught</metric>
    <enumeratedValueSet variable="search-algo">
      <value value="&quot;circuit seaelefant&quot;"/>
      <value value="&quot;random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="elefant-speed">
      <value value="1"/>
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="move-randomness">
      <value value="0"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seacows-number">
      <value value="20"/>
      <value value="40"/>
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-distance-seacow">
      <value value="15"/>
      <value value="30"/>
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-dist-center-elefant">
      <value value="30"/>
      <value value="60"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" sequentialRunOrder="false" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="15000"/>
    <metric>count turtles</metric>
    <metric>caught</metric>
    <metric>plastic-total</metric>
    <enumeratedValueSet variable="search-algo">
      <value value="&quot;random&quot;"/>
      <value value="&quot;circuit elefant&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="elefant-speed">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plastic-flow-river">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="move-randomness">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seacows-number">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-dist-center-elefant">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-distance-seacow">
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" sequentialRunOrder="false" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="15000"/>
    <metric>count turtles</metric>
    <metric>caught</metric>
    <enumeratedValueSet variable="search-algo">
      <value value="&quot;random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="elefant-speed">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="move-randomness">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="seacows-number">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-dist-center-elefant">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-distance-seacow">
      <value value="30"/>
      <value value="60"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="15000"/>
    <metric>caught</metric>
    <enumeratedValueSet variable="seacows-number">
      <value value="20"/>
      <value value="40"/>
      <value value="80"/>
      <value value="160"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-dist-center-elefant">
      <value value="50"/>
      <value value="60"/>
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-distance-seacow">
      <value value="60"/>
      <value value="80"/>
      <value value="100"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
