globals
[
  tick-delta                        ;; how much we advance the tick counter this time through
  max-tick-delta                    ;; the largest tick-delta is allowed to be
  init-avg-speed init-avg-energy    ;; initial averages
  avg-speed avg-energy              ;; current average
  avg-energy-green
  avg-energy-orange
  avg-energy-purple
  photon-size
  toggle-red-state
  toggle-green-state
  min-photon-energy
  max-photon-energy
  photons-to-add
  clear-drawing-flag
  new-objects?
  old-switch-state
  first-source-selected
  photon-model
  count-detector-1
  count-detector-2
]

breed [ photons photon ]
breed [ detectors detector ]
breed [ walls wall ]
breed [ transparent-solids transparent-solid ]
breed [ sources source ]
breed [ flashes flash ]
breed [ erasers eraser ]

breed [ arrowheads arrowhead ]

photons-own
[
  energy          ;; photons info
  last-collision
  color-type
  last-patch
  bounces
]

walls-own [gate? outside-system?]
detectors-own [id]

patches-own [ red-absorbed green-absorbed blue-absorbed]

sources-own [selected?]

to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  clear-all
  set count-detector-1 0
  set count-detector-2 0
  set photon-size 1.0
  set max-tick-delta 0.02
  set new-objects? false
  set photons-to-add 2
  set clear-drawing-flag false
  set photon-model "wavefront-of-rays"
  set-default-shape flashes "square"
  set-default-shape walls "wall"
  set-default-shape erasers "eraser"
  set-default-shape arrowheads "default"

  set min-photon-energy 0
  set max-photon-energy 10000  ;;(.5 ) * ( max-dist-in-tick-delta  / max-tick-delta ) ^ 2

  create-erasers 1 [set hidden? true set size 3 set color gray - 1]
  setup-scenarios
  set old-switch-state light-A
  make-box
  make-light-sources
  create-detectors 1 [set color orange set shape "circle" set size 1 setxy 20 34 set id 1]
  create-detectors 1 [set color violet set shape "circle" set size 1 setxy 40 40 set id 2]

  set init-avg-speed avg-speed
  set init-avg-energy avg-energy

  check-detectors
  reset-ticks
end

to check-detectors

  ask detectors [
    if id = 1 [set count-detector-1 count photons-here]
    if id = 2 [set count-detector-2 count photons-here]
  ]
end



to go
  ifelse mouse-down? [mouse-action]
  [

    check-for-new-toys
   ;; activate-light-switch
    ask photons  [move interact-with-wall

    ]
    ask erasers [set hidden? true]
  ]
  if count photons = 0 [recolor]
  tick
  check-detectors
end

to interact-with-wall
  ;;if random 100 >  %-of-scattering [absorb-into-wall die]
  if bounces > 1 [die]
  scatter
end



to emit-light-from-light-source
 ask patches [reset ]
  if photon-model = "random-rays" [
    ifelse light-A [
      if count photons < rays-per-light-source [
      repeat random 4 [ask sources [make-photons]]
      ]
    ]
    [clear-drawing
     ask photons [die]
    ]
  ]
    if photon-model = "wavefront-of-rays" [
    ask sources  [make-photon-batch]
    ;;  ifelse light-A = true and (old-switch-state = false or count photons = 0) [
   ;;     set old-switch-state true
        ;;ask sources [make-photon-batch]
   ;;   ]
   ;;   [set old-switch-state light-A]
    ]
end


to check-for-new-toys
  if new-objects? [
     ask photons [die]
    ;;   clear-drawing
    set new-objects? false
  ]
end


to absorb-into-wall
   ask walls-here [
     set red-absorbed red-absorbed + (10 / rays-per-light-source)
     set green-absorbed green-absorbed + (10  / rays-per-light-source)
     set blue-absorbed blue-absorbed + (10  / rays-per-light-source)
   ]
end





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;WALL AND PATCH INTERACTION;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to add-lighting-to-patch
    let color-of-light color

  ;;  show color-of-light
    ask patch-here [

   ;; if color-of-light = 9.9 [
     set red-absorbed red-absorbed + (light-source-intensity-A * 90 / rays-per-light-source)
     set green-absorbed green-absorbed + (light-source-intensity-A * 90  / rays-per-light-source)
     set blue-absorbed blue-absorbed + (light-source-intensity-A * 90  / rays-per-light-source)
  ;  ]
    ;;if color-of-light = 15 [
   ;; set red-absorbed red-absorbed + (light-source-intensity-A * 900 / rays-per-light-source)
   ;;  ]
   ;;      if color-of-light = 55 [
   ;; set green-absorbed green-absorbed + (light-source-intensity-A * 900  / rays-per-light-source)
   ;;  ]
   ;;      if color-of-light = 105 [
   ;;  set blue-absorbed blue-absorbed + (light-source-intensity-A * 900  / rays-per-light-source)
   ;;  ]
     ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;LIGHT photon MOVEMENT;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to bounce  ;; photons procedure
  ;; get the coordinates of the patch we'll be on if we go forward 1
  let bounce-patch nobody
  let bounce-patches nobody
  let hit-angle 0
  let this-patch patch-here
  let new-px 0
  let new-py 0
  let visible-wall nobody

  set bounce-patch  min-one-of walls in-cone ((sqrt (2)) / 2) 180 with [myself != this-patch] [distance myself ]

  if bounce-patch != nobody [

    set new-px [pxcor] of bounce-patch
    set new-py [pycor] of bounce-patch
    set visible-wall walls-on bounce-patch

  if any? visible-wall with [not hidden?]  [
     set hit-angle towards bounce-patch
     ifelse (hit-angle <= 135 and hit-angle >= 45) or (hit-angle <= 315 and hit-angle >= 225)
       [set heading (- heading) ]
      [set heading (180 - heading) ]

    ]]
end



to scatter  ;; turtle procedure
  let this-patch patch-here
  let bounce-patch  min-one-of walls in-cone ((sqrt (2)) / 2) 180 with [myself != this-patch] [distance myself ]

  if bounce-patch != nobody [

    let new-px [pxcor] of bounce-patch
    let new-py [pycor] of bounce-patch
    let visible-wall walls-on bounce-patch

  if any? visible-wall with [not hidden?]  [
     let hit-angle towards bounce-patch
     set bounces bounces + 1
     if light&matter = "absorb some / scatter some" [set heading random 360 fd .2]
     if light&matter = "absorb all" [die]
     ifelse (hit-angle <= 135 and hit-angle >= 45) or (hit-angle <= 315 and hit-angle >= 225)
       [
         if light&matter = "reflect all" [ set heading (- heading) fd .2  ]
         if light&matter = "absorb 50% / reflect 50%" [
            ifelse random 2 = 0
               [set heading (- heading) fd .2 ]
               [die]
         ]
       ]
       [
         if light&matter = "reflect all" [ set heading (180 - heading) fd .2  ]
         if light&matter = "absorb 50% / reflect 50%" [
            ifelse random 2 = 0
               [set heading (180 - heading) fd .2  ]
               [die]
         ]

       ]
  ]
  ]
    if any? walls-here or bounces > 1 [die]
  end







to move  ;; photons procedure
  let old-patch last-patch
  if not any? transparent-solids-here [fd .2]
  if  any? transparent-solids-here [fd (.2 * speed-of-light-through-solid)]
  add-lighting-to-patch
    set last-patch patch-here
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  mouse interaction procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to mouse-action
   let snap-xcor 0
   let snap-ycor 0
   let orig-xcor 0
   let orig-ycor 0
   let eraser-window-walls nobody
   let eraser-window-photons nobody
   let eraser-light-sources nobody
   let selected-eraser-light-source nobody

   ifelse mouse-down? [
      set orig-xcor mouse-xcor
      set orig-ycor mouse-ycor
      set snap-xcor round orig-xcor
      set snap-ycor round orig-ycor
      clear-drawing

      if mouse-setting = "move light source" and any? sources with [selected?]
      [ask sources with [selected?] [setxy mouse-xcor mouse-ycor]]

    ask patches with [pxcor = snap-xcor and pycor = snap-ycor] [
      set eraser-window-walls walls-on neighbors
      set eraser-window-walls eraser-window-walls
      set eraser-window-photons photons with [distance myself  < 2]
      set eraser-light-sources sources with [distance myself  < 2]

      if mouse-setting = "draw container wall" [
          draw-container-wall
      ]
      if mouse-setting = "draw transparent solid" [
          draw-transparent-solid
      ]


      if mouse-setting = "big eraser" [
        set new-objects? true
        ask erasers [
          set hidden? false
          set shape "eraser"
          setxy orig-xcor orig-ycor
        ]
        ask eraser-window-walls [die]
        ask eraser-window-photons [die]
      ]

     if selected-eraser-light-source = nobody and any? eraser-light-sources [
       set selected-eraser-light-source one-of eraser-light-sources
       if mouse-setting = "move light source" [
         set new-objects? true
         ask selected-eraser-light-source [setxy mouse-xcor mouse-ycor set selected? true]
         set clear-drawing-flag true
         ask photons [die]
       ]
     ]
    ]
   ]
   ;; 2nd part of ifelse block
  [
     ask erasers [set hidden? true]
     set selected-eraser-light-source nobody
     ask sources [set selected? false]
  ]


end




to draw-container-wall
        set new-objects? true
        ask walls-here [die]
        ask transparent-solids-here [die]
        sprout 1 [ set breed walls set color white set gate? false  ]
end


to draw-transparent-solid
        set new-objects? true
        ask walls-here [die]
        ask transparent-solids-here [die]
        sprout 1 [ set breed transparent-solids set color [255 255 255 50] set size 1 set shape "solid"]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; photon speed and flash visualization procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to recolor

   ;;if any? walls-here with [not absorb?]  []
  ifelse show-light-intensity-in-space?
   [ask patches [set pcolor rgb  red-absorbed green-absorbed blue-absorbed ]]
   [ask patches [set pcolor black ]]

end

to reset
     set red-absorbed 0
     set green-absorbed 0
     set blue-absorbed 0
     set pcolor black
end


to color-photon-and-link
  let this-link my-out-links
  let this-color-type color-type
  set color this-color-type
  ask this-link [set color this-color-type]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  initialization procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to make-box
  ask patches with [(pycor = min-pycor or pycor = max-pycor or pxcor = min-pxcor or pxcor = max-pxcor) ]
    [ sprout 1 [set breed walls set gate? false set color gray - 1 ] ]
end





to make-light-sources
 create-sources 1
 [
   initialize-bulb
   setxy 5 30
   set label "A"
   ifelse light-A
    [set hidden? false]
    [set hidden? true]
 ]
  create-sources 1
 [
  initialize-bulb
  setxy 25 25
  set label "B"
  ifelse light-B
   [set hidden? false]
   [set hidden? true]
 ]
 create-sources 1
 [
  initialize-bulb
  setxy 30 30
  set label "C"
  ifelse light-C
   [set hidden? false]
   [set hidden? true]
 ]

 end

 to initialize-bulb
    set selected? false
    set heading 0
    set shape "bulb"
   set size 2
   set color white
 end

to make-photons

  hatch 1
  [
    set energy 100
    rt random 360
    setup-photons
    ;;setxy ([xcor] of parent-bulb) ( [ycor] of parent-bulb)

  ]
end


to make-photon-batch
  let parent-source self
  let angle-counter 0
  let source-A false
  let source-B false
  let source-C False

  if (label = "A" and light-A) [set source-A true]
  if (label = "B" and light-B) [set source-B true]
  if (label = "C" and light-C) [set source-C true]
  if (source-A or source-B or source-C) [
  hatch rays-per-light-source
    [
    if ((source-A and light-A-color = "white") or (source-B and light-B-color = "white") or (source-C and light-C-color = "white")) [set color white]
    if ((source-A and light-A-color = "red") or (source-B and light-B-color = "red") or (source-C and light-C-color = "red")) [set color red]
    if ((source-A and light-A-color = "green") or (source-B and light-B-color = "green") or (source-C and light-C-color = "green")) [set color green]
    if ((source-A and light-A-color = "blue") or (source-B and light-B-color = "blue") or (source-C and light-C-color = "blue")) [set color blue]

    set label ""
    rt angle-counter
    set angle-counter angle-counter + (360 / rays-per-light-source)
    setup-photons
    setxy ([xcor] of parent-source) ( [ycor] of parent-source)

    ]
  ]
end

to setup-photons  ;; photons procedure
  set breed photons
  set shape "arrow head"
  set size photon-size
  set last-patch patch-here
  set color [255 255 255 50]
  set bounces 0
  ifelse show-rays?
      [pendown]
      [penup]

end


to setup-scenarios
    if scenario = "light rays forming a simple shadow"  [
      set light-A true
      set light-B false
      set light-C false
      set show-rays? true
      set show-light-intensity-in-space? false

      set rays-per-light-source 180
      ask patches with [pxcor = 14 and abs pycor < 5] []
    ]
    if scenario = "shadow from single light"  [
      set light-A true
      set light-B false
      set light-C false
      set show-rays? false
      set show-light-intensity-in-space? true
      set rays-per-light-source 720
      ask patches with [pxcor = 14 and  pycor < 5 and pycor > -10] []
    ]

        if scenario = "shadows from 3 lights"  [
      set light-A true
      set light-B true
      set light-C true
      set show-rays? false
      set show-light-intensity-in-space? true
      set rays-per-light-source 720
      ask patches with [abs pxcor = 14 and  pycor < 5 and pycor > -10] []
            ask patches with [abs pxcor <= 1 and  pycor < 15 and pycor > 5] []

    ]
end

to clear-background
  clear-drawing
  ask patches [
    if not any? walls-here [set pcolor black]
    ]
  display
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;REPORTERS;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



to-report limited-photon-energy
  let limited-energy energy
  if limited-energy > max-photon-energy [set limited-energy max-photon-energy]
  if limited-energy < min-photon-energy [set limited-energy min-photon-energy]
  report limited-energy
end
@#$#@#$#@
GRAPHICS-WINDOW
434
10
901
478
-1
-1
9.0
1
10
1
1
1
0
0
0
1
0
50
0
50
1
1
1
ticks
30.0

BUTTON
82
12
159
45
go/stop
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
10
12
79
45
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
6
147
189
180
rays-per-light-source
rays-per-light-source
1
1800
461.0
2
1
NIL
HORIZONTAL

CHOOSER
10
62
198
107
mouse-setting
mouse-setting
"draw container wall" "draw absorbing wall" "draw scattering wall" "draw transparent solid" "big eraser" "move light source"
3

SWITCH
8
230
98
263
light-A
light-A
0
1
-1000

SWITCH
8
107
127
140
show-rays?
show-rays?
1
1
-1000

SLIDER
100
231
254
264
light-source-intensity-A
light-source-intensity-A
0
3
1.0
1
1
NIL
HORIZONTAL

SWITCH
8
272
98
305
light-B
light-B
1
1
-1000

SWITCH
8
318
98
351
light-C
light-C
1
1
-1000

SLIDER
101
275
255
308
light-source-intensity-B
light-source-intensity-B
0
3
1.0
1
1
NIL
HORIZONTAL

SLIDER
100
319
254
352
light-source-intensity-C
light-source-intensity-C
0
3
0.0
1
1
NIL
HORIZONTAL

SWITCH
128
105
348
138
show-light-intensity-in-space?
show-light-intensity-in-space?
1
1
-1000

SLIDER
211
147
385
180
max-#-of-scatterings
max-#-of-scatterings
0
4
0.0
1
1
NIL
HORIZONTAL

CHOOSER
256
231
348
276
light-A-color
light-A-color
"white" "red" "green" "blue"
0

CHOOSER
256
277
348
322
light-B-color
light-B-color
"white" "red" "green" "blue"
1

CHOOSER
255
322
348
367
light-C-color
light-C-color
"white" "red" "green" "blue"
3

CHOOSER
48
437
301
482
scenario
scenario
"draw my own scenario" "light rays forming a simple shadow" "shadow from single light" "shadows from 3 lights" "3 colored flashlights on a screen" "light rays from one light source off a mirror"
0

TEXTBOX
12
191
405
216
-----------------------------------------------------------------
11
107.0
1

SLIDER
248
370
420
403
%-of-scattering
%-of-scattering
0
100
0.0
10
1
NIL
HORIZONTAL

BUTTON
95
373
238
406
clear light shadow
ask patches [set pcolor black]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
168
10
391
55
light&matter
light&matter
"reflect all" "absorb all" "absorb 50% / reflect 50%" "absorb some / scatter some"
1

BUTTON
38
418
251
451
NIL
emit-light-from-light-source
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
312
452
436
485
auto-emit?
auto-emit?
1
1
-1000

SLIDER
202
62
427
95
speed-of-light-through-solid
speed-of-light-through-solid
0.1
1
0.5
.1
1
c
HORIZONTAL

PLOT
38
494
408
644
number of photons at detector
tinme
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"orange" 1.0 0 -3844592 true "" "plot count-detector-1"
"purple" 1.0 0 -8630108 true "" "plot count-detector-2"

@#$#@#$#@
## WHAT IS IT?

This model supports a drawing style interface for "sketching" up representations of  the interaction of light and matter.  In particular, the user can explore phenomena related to light rays, shadows, mirrors, light intensity, color mixing.

In this model, the user can adjust various light sources (up to 3), by moving their location, turning them on or off, adjusting the intensity of light and the color of the light source.  Each light source generates "light particles" that travel away from the light source and interact with different types of matter.  The user can add (by sketching with the mosue) new sections of "rough" walls, which can either scatters or absorb the light that hits it or the user can add "smooth" mirrored surfaces which reflect the light that hits it.

This model enables students to either explore various pre-defined scenarios (e.g. a single light source and a wall that creates a shadwo), or draw a new model of a real world system and then test that model.  A wide range of real world systems can be modeled with this simple interface (e.g. two flashlights and a single object creating various shadows, how distance of a light source to an object affects the size of the shadow, or how colors of light additively mix).

## HOW IT WORKS

The light rays are modeled as particles that trace out their path as they move.

The exact way light particles move is as follows:  
1. A light particle moves in a straight line without changing its speed, unless it hits a wall.  
2. Reflective surfaces (mirrors) cause the light particle to bounce off in a symmetrical "V" shaped path

The exact way light intensity is determined at a patch is as follows:  
1. Each time a light particle is in a patch it adds its light value (red, green, blue, or all) to the patch.  
2. When light has passed through all patches the patch renders the intensity and color of the light at that location by using the rgb primative on these accumulated light values at the patch.



## HOW TO USE IT

Buttons:  
SETUP - sets up the initial conditions set on the sliders.  
GO/STOP - runs and stops the model.

Sliders:  
RAYS-PER-LIGHT-SOURCE - sets the number of light particles emiited from each light source.  
REFLECTIONS-PER-PARTICLE (non functional as of now)

Switches:

Choosers:  
SCENARIO - explore some precreated scenarios by chaging this setting or set to "create my own scenario" to use the mouse to employ different actions (through drawing with the mouse cursor) in the WORLD & VIEW  
MOUSE SETTING - describes what action the mouse will perform when the mouse button is pressed down when the cursor is in the WORLD & VIEW.



## THINGS TO NOTICE

The mouse interaction can be used while the model is running as well as when it is stopped.

## THINGS TO TRY

Create a model of howan overhead projector uses a mirror to project onto a screen.

Create a model of how 3 light sources: red, green, and blue light can combine to make white light.

Create a model of how an eclipse creates a penumbra (use multiple light sources to simulate the larger size of the sun).

## RELATED MODELS

## CREDITS AND REFERENCES
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

arrow head
true
0
Polygon -7500403 true true 150 105 15 210 45 255 150 180 255 255 285 210

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

bulb
true
15
Circle -1 false true 8 8 284
Circle -1 true true 129 129 42
Circle -16777216 false false 44 44 212

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

carbon
true
0
Circle -1184463 true false 68 83 134

carbon-activated
true
0
Circle -1184463 true false 68 83 134
Line -2674135 false 135 90 135 210

carbon2
true
0
Circle -955883 true false 30 45 210

circle
false
1
Circle -2674135 true true 30 30 240

circle 2
false
0
Circle -7500403 true true 16 16 270
Circle -16777216 true false 46 46 210

clock
true
0
Circle -7500403 true true 30 30 240
Polygon -16777216 true false 150 31 128 75 143 75 143 150 158 150 158 75 173 75
Circle -16777216 true false 135 135 30

co2
true
0
Circle -13791810 true false 83 165 134
Circle -13791810 true false 83 0 134
Circle -1184463 true false 83 83 134

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

eraser
false
15
Circle -1 false true 0 0 300
Line -1 true 300 150 270 150
Line -1 true 150 0 150 30
Line -1 true 150 300 150 270
Line -1 true 0 150 30 150

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

heater-a
false
0
Rectangle -7500403 true true 0 0 300 300
Rectangle -16777216 true false 90 90 210 210

heater-b
false
0
Rectangle -7500403 true true 0 0 300 300
Rectangle -16777216 true false 30 30 135 135
Rectangle -16777216 true false 165 165 270 270

hex
false
0
Polygon -7500403 true true 0 150 75 30 225 30 300 150 225 270 75 270

hex-valve
false
0
Rectangle -7500403 false true 0 0 300 300
Polygon -7500403 false true 105 60 45 150 105 240 195 240 255 150 195 60

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

nitrogen
true
0
Circle -10899396 true false 83 135 134
Circle -10899396 true false 83 45 134

oxygen
true
0
Circle -13791810 true false 83 135 134
Circle -13791810 true false 83 45 134

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

scattering-wall
false
0
Polygon -7500403 false true 45 0 0 45 0 255 45 300 255 300 300 270 300 45 255 0 45 0

solid
false
0
Rectangle -7500403 true true 0 0 300 300

spray paint
false
0
Rectangle -7500403 false true 0 0 300 300
Circle -7500403 false true 75 75 150

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

valve-1
false
0
Rectangle -7500403 false true 0 0 300 300
Rectangle -7500403 false true 120 120 180 180

valve-2
false
0
Rectangle -7500403 false true 0 0 300 300
Rectangle -7500403 false true 60 120 120 180
Rectangle -7500403 false true 165 120 225 180

valve-hex
false
0
Rectangle -7500403 false true 0 0 300 300
Polygon -7500403 false true 105 60 45 150 105 240 195 240 255 150 195 60

valve-triangle
false
0
Rectangle -7500403 true true 0 0 300 300
Polygon -16777216 true false 150 45 30 240 270 240

valves
false
0
Rectangle -7500403 false true 0 0 300 300

wall
false
0
Rectangle -7500403 false true 0 0 300 300

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
