globals [
  war-count
  world-casualties
  cas-count-list
]

breed [ capitols capitol ]

breed [ paths path ]

undirected-link-breed [ truces truce ]

directed-link-breed [ combat-links combat-link ]

paths-own [
  f-resource
  path-capital
]

links-own[
  victory-ratio
  casualty-count
]

truces-own[
  truce-timer
]

patches-own [
  capital
  state
  resource-total
  resource-N
  resource-split
  neighbors-list
  neighbors-set
  target
  aggresors
  combat-patches
  combat-paths
  cmbt-link
  Local-aggressors
  excl?
  Enclosed-State
  predator
  x
  cost
  target-local
]

to setup
  clear-all
  let s random 2147483647 * 2
  set s s - 2147483647
  show s
  random-seed s
  set-default-shape capitols "star"
  set war-count 0
  set cas-count-list []
  ask patches
  [
    set predator false
    set capital nobody
    set neighbors-list []
    set neighbors-set nobody
  ]
  ask n-of (states) patches [
    sprout-capitols 1 [
      set size 0.5  ;; easier to see
      let black? true
      set pcolor (sentence (random 256) (random 256) random (256))
      if max pcolor <= 80 [ set black? false ]
      if-else black? [ set color black ] [ set color white ]
      set capital self
    ]
  ]
  ask n-of ( states * predators / 100 ) patches [ set predator true ]
  grow-nations
  ask patches with [ capitols-here != no-turtles ]
  [
    update-state
    set resource-n random-normal 50 10
    if resource-n < 0 [ set resource-n 0 ]
    set resource-total resource-n
  ]
  ask patches
  [
    set target nobody
    set target-local nobody
    set state nobody
    set local-aggressors no-patches
    set combat-patches no-patches
    set combat-paths no-turtles
    set x 2
    set cost x * ( cost-lb + random-float ( cost-ub - cost-lb ) )
  ]
  reset-ticks
end

to grow-nations
  loop [
    let empty patches with [capital = nobody]
    if not any? empty [ stop ]
    ask empty
      [ set capital [capital] of one-of neighbors4
        if capital != nobody [ set pcolor [pcolor] of capital ] ]
  ]
end

to get-resources
 foreach ( [ patch-here ] of capitols )
  [
    [ capital-patch ] -> ask capital-patch
    [
      let i 0
      let z 0
      ask state
      [
        set i random-normal 2 5
        set z z + i
      ]
      set resource-N resource-n + z + sum [ f-resource ] of paths with [ path-capital = [ capital ] of capital-patch ]
      if resource-n < 0 [ set resource-n 0 ]
      ask paths with [ path-capital = [ capital ] of capital-patch ] [ set f-resource 0 ]
      set resource-total resource-N
    ]
  ]
end

to go
  if count capitols = 1 [ stop ]
  if any? patches with [ capital = nobody ] = true
  [
    write "C-N: " show [ list pxcor pycor ] of patches with [ capital = nobody ]
  ]
  ask patches with [ capitols-here != no-turtles ] [ update-neighbors ]
  ep-model
  get-resources
  set cas-count-list remove-duplicates cas-count-list
  tick
end

to EP-Model
  if-else bargaining? [ epm-decision-phase-barg ] [ epm-decision-phase ]
  epm-interaction-phase
  epm-structural-change-phase
  check-exclave
end

;----------------- EPM DECISION COMPONENTS

to EPM-decision-phase
  let caps patches with [ capitols-here != no-turtles ]
  ask caps [ update-neighbors ]
  ask caps with [ predator ] [ epm-pick-target ]
  ask caps [ epm-allocate-resources ]
end

to EPM-Pick-Target
  let capital-patch self
  if ( target = nobody ) and ( not any? neighbors-set with [ target = [ capital ] of capital-patch ] )
  [
    if any? neighbors-set with [ resource-total = 0 or ( [ resource-total ] of capital-patch / [ resource-total ] of patch-here ) >= superiority-ratio ]
    [
      set target min-one-of neighbors-set [ [ resource-total ] of patch-here ]
    ]
  ]
  epm-pick-local-target
end

to EPM-Pick-Local-Target
  let capital-patch self
  ;------- SELECT COMBAT PATH IN NEW ATTACK -----
  if target != nobody and combat-patches = no-patches and any? state with [ any? neighbors4 with [ capital = [ target ] of capital-patch ] ]
  [
    ask one-of state with [ any? neighbors4 with [ capital = [ target ] of capital-patch ] ]
    [
      let local-attacker self
      let local-target one-of neighbors4 with [ capital = [ target ] of capital-patch ]
      ask capital-patch [ set combat-patches ( patch-set local-attacker local-target ) ]
    ]
    epm-create-combat-path
  ]
end

to EPM-Create-Combat-Path
  let capital-patch self
  ask combat-patches
  [
    sprout-paths 1
    [
      let z self
      set shape "circle"
      set color red
      set size 0.5
      set f-resource 0
      set path-capital [ capital ] of patch-here
      ask capital-patch [ set combat-paths ( turtle-set combat-paths z ) ]
    ]
  ]
  ask combat-paths with [ path-capital = [ capital ] of capital-patch ]
  [
    create-combat-link-to one-of other [ combat-paths ] of capital-patch
    [
      set victory-ratio 0
      set casualty-count 0
      set thickness 0.08
      set color black
      let l self
      ask capital-patch [ set cmbt-link l ]
    ]
  ]
  set war-count war-count + 1
end

to EPM-Allocate-Resources
  let capital-patch self
  let cpr one-of patch-set [ patch-here ] of ( turtle-set [ capital ] of ( combat-patches with [ not member? self ( [ state ] of capital-patch ) ] ) )
  update-neighbors
  set resource-split resource-N / ( count neighbors-set )
  ask paths with [ path-capital = [ capital ] of capital-patch ]
  [
    set f-resource [ resource-split ] of capital-patch
    ask capital-patch [ set resource-n resource-n - resource-split ]
  ]
  if resource-n > -1 and resource-n < 0 [ set resource-n 0]
end

;----------------- EPM INTERACTION COMPONENTS

to EPM-Interaction-phase
  epm-front-conquest
end

to EPM-Front-Conquest
  ask patches with [ capitols-here != no-turtles and target != nobody ]
  [
    let capital-patch self
    let cpr one-of patch-set [ patch-here ] of ( turtle-set [ capital ] of ( combat-patches with [ not member? self ( [ state ] of capital-patch ) ] ) )
    let z one-of [f-resource] of combat-paths with [ path-capital != [capital] of capital-patch ]
    let i combat-paths
    let g combat-patches
    ask i with [ path-capital = [ capital ] of capital-patch ]
    [
      let f f-resource
      ask other ( [ i ] of capital-patch )
      [
        if-else ( f-resource - f * k ) > 0
        [
          set f-resource ( z - f * k)
          ask capital-patch [ ask cmbt-link [ set casualty-count casualty-count + f * k ] ]
          set world-casualties world-casualties + f * k
        ]
        [
          ask capital-patch [ ask cmbt-link [ set casualty-count casualty-count + z ] ]
          set world-casualties world-casualties + f-resource
          set f-resource 0
        ]
      ]
    ]
    ask i with [ path-capital != [ capital ] of capital-patch ]
    [
      if-else member? ( one-of other ( [ g ] of capital-patch ) )  local-aggressors
      [
        ask other ( [ i ] of capital-patch )
        [
          if-else ( f-resource - z * k ) > 0
          [
            set f-resource ( f-resource - z * k)
            ask capital-patch [ ask cmbt-link [ set casualty-count casualty-count + z * k ] ]
            set world-casualties world-casualties + z * k
          ]
          [
            let h f-resource
            ask capital-patch [ ask cmbt-link [ set casualty-count casualty-count + h  ] ]
            set world-casualties world-casualties + f-resource
            set f-resource 0
          ]
        ]
      ]
      [
        set local-aggressors ( patch-set local-aggressors ( g with [ member? self [ state ] of capital-patch ] ) )
      ]
    ]
    ask cmbt-link
    [
      if-else one-of [ f-resource ] of i with [ path-capital != [ capital ] of capital-patch ]  = 0
      [
        if one-of [ f-resource ] of i with [ path-capital = [ capital ] of capital-patch ] != 0 [ set victory-ratio -1 ]
      ]
      [
      set victory-ratio ( one-of [ f-resource ] of i with [ path-capital = [ capital ] of capital-patch ] ) / ( one-of [ f-resource ] of i with [ path-capital != [ capital ] of capital-patch ] )
      ]
    ]
  ]
end

;----------------- EPM STRUCTURAL CHANGE COMPONENTS

to EPM-Structural-Change-Phase
  ask patches with [ capitols-here != no-turtles ]
  [
    if target != nobody
    [
      let capital-patch self
      let cpr one-of patch-set [ patch-here ] of ( turtle-set [ capital ] of ( combat-patches with [ not member? self ( [ state ] of capital-patch ) ] ) )
      if-else [ victory-ratio ] of cmbt-link = -1
      [
        ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ]
        conquer-province
      ]
      [
        if-else [ victory-ratio ] of cmbt-link > v-ratio
        [
          ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ]
          conquer-province
        ]
        [
          if [ victory-ratio ] of cmbt-link < 1 / v-ratio
          [
            ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list]
            surrender-no-capitulation
          ]
        ]
      ]
    ]
    update-neighbors
  ]
end

to conquer-province

  let capital-patch self
  let cpr one-of patch-set [ patch-here ] of ( turtle-set [ capital ] of ( combat-patches with [ not member? self ( [ state ] of capital-patch ) ] ) )
  let i combat-patches
  let g combat-paths

  set resource-n ( resource-n + sum [ f-resource ] of g with [ capital = [capital] of capital-patch  ] )
  ask cpr
  [
    set resource-n ( resource-n + sum [ f-resource ] of g with [ path-capital = [ capital ] of cpr ] )
    if target != nobody
    [
      if one-of i with [ not member? self ( [ state ] of capital-patch ) ] = cpr  [ ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ] ]
      if one-of i with [ not member? self ( [ state ] of capital-patch ) ]  = one-of combat-patches with [  member? self ( [ state ] of cpr ) ] [ ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ] ]
    ]
    ask g [ die ]
    ask capital-patch [ set combat-patches no-patches ]
    set resource-n resource-n + sum [ f-resource ] of paths with [ patch-here = one-of i with [ capital = [ capital ] of cpr ] ]
    ask patches with [ member? (one-of i with [ member? self [ state ] of cpr ] ) combat-patches ]
    [
      let z self
      let y combat-patches
      let q combat-paths
      set resource-n resource-n + sum [ f-resource ] of q with [ path-capital = [ capital ] of z ]
      ask cpr [ set resource-n resource-n + sum [ f-resource ] of q with [ path-capital = [ capital ] of cpr ] ]
      ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ]
      ask q [ die ]
      set combat-patches no-patches
      set target nobody
      set target-local nobody
      ask i with [ member? self [ state ] of cpr ] [ set local-aggressors patch-set ( remove ( [ self ] of one-of other y ) ( [ self ] of local-aggressors ) ) ]
    ]
  ]
  if one-of i with [ not member? self ( [ state ] of capital-patch ) ] = cpr
  [
    ask cpr
    [
      set resource-n resource-n + sum [ f-resource ] of paths with [ path-capital = [ capital ] of cpr ]
      ask patches with [ target = [ capital ] of cpr ]
      [
        let z self
        set resource-n resource-n + sum [ f-resource ] of combat-paths with [ path-capital = [ capital ] of z ]
        ask combat-paths [ die ]
        set combat-patches no-patches
        set target nobody
      ]
      if combat-paths != no-turtles
      [
        ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ]
        ask combat-paths [ die ]
      ]
      let n resource-n / count state
      if other state != no-patches
      [
        ask other state
        [
          set resource-n n
          set resource-total n
          spawn-new-state
        ]
        ask other state [ update-neighbors ]
      ]
      ask capital-patch [ set resource-n resource-n + ( random-float 1 ) * n ]
      set resource-n 0
      set resource-split 0
      set combat-patches no-patches
      set target nobody
      set target-local nobody
      set neighbors-list []
      set neighbors-set no-turtles
      set resource-total 0
      set local-aggressors no-patches
      ask capital [ die ]
      set capital nobody
      set predator false
      set state no-patches
    ]
  ]

  ask i
  [
    set pcolor [ pcolor ] of capital-patch
    set capital [ capital ] of capital-patch
  ]

  if [ capital ] of cpr != [ capital ] of capital-patch [ ask cpr [ update-state update-neighbors ] ]
  set target nobody
  set target-local nobody
  set combat-patches no-patches
  update-state
  update-neighbors
end

to surrender-no-capitulation
  let capital-patch self
  let cpr one-of patch-set [ patch-here ] of ( turtle-set [ capital ] of ( combat-patches with [ not member? self ( [ state ] of capital-patch ) ] ) )
  let i combat-paths
  let g combat-patches
  ask cpr [ set resource-n resource-n + sum [ f-resource ] of i with [ path-capital = [ capital ] of cpr ] ]
  set resource-n resource-n + sum [ f-resource ] of i with [ path-capital = [ capital ] of capital-patch ]
  ask i with [ member? self [ state ] of cpr ] [ set local-aggressors patch-set ( remove ( [ self ] of one-of other i ) ( [ self ] of local-aggressors ) ) ]
  ask combat-paths [ die ]
  set combat-patches no-patches
  set target nobody
  set target-local nobody
end

to surrender-capitulation
  let capital-patch self
  let cpr one-of patch-set [ patch-here ] of ( turtle-set [ capital ] of ( combat-patches with [ not member? self ( [ state ] of capital-patch ) ] ) )
  let i combat-patches
  let g combat-paths

  set resource-n ( resource-n + sum [ f-resource ] of g with [ capital = [capital] of cpr  ] )
  ask capital-patch
  [
    set resource-n ( resource-n + sum [ f-resource ] of g with [ path-capital = [ capital ] of capital-patch ] )
    ask g [ die ]
    set combat-patches no-patches
    set resource-n resource-n + sum [ f-resource ] of paths with [ patch-here = one-of i with [ capital = [ capital ] of capital-patch ] ]
    ask patches with [ member? (one-of i with [ member? self [ state ] of capital-patch ] ) combat-patches ]
    [
      let z self
      let y combat-patches
      let q combat-paths
      set resource-n resource-n + sum [ f-resource ] of q with [ path-capital = [ capital ] of z ]
      ask capital-patch [ set resource-n resource-n + sum [ f-resource ] of q with [ path-capital = [ capital ] of capital-patch ] ]
      ask q [ die ]
      set combat-patches no-patches
      set target nobody
      set target-local nobody
      ask i with [ member? self [ state ] of capital-patch ] [ set local-aggressors patch-set ( remove ( [ self ] of one-of other y ) ( [ self ] of local-aggressors ) ) ]
    ]
  ]
  if one-of i with [ member? self ( [ state ] of capital-patch ) ] = capital-patch
  [
    ask capital-patch
    [
      set resource-n resource-n + sum [ f-resource ] of paths with [ path-capital = [ capital ] of capital-patch ]
      ask patches with [ target = [ capital ] of capital-patch ]
      [
        let z self
        set resource-n resource-n + sum [ f-resource ] of combat-paths with [ path-capital = [ capital ] of z ]
        ask combat-paths [ die ]
        set combat-patches no-patches
        set target nobody
      ]
      if combat-paths != no-turtles [ ask combat-paths [ die ] ]
      let n resource-n / count state
      if other state != no-patches
      [
        ask other state
        [
          set resource-n n
          set resource-total n
          spawn-new-state
        ]
        ask other state [ update-neighbors ]
      ]
      ask cpr [ set resource-n resource-n + ( random-float 1 ) * n ]
      set resource-n 0
      set resource-split 0
      set combat-patches no-patches
      set target nobody
      set target-local nobody
      set neighbors-list []
      set neighbors-set no-turtles
      set resource-total 0
      set local-aggressors no-patches
      ask capital [ die ]
      set capital nobody
      set predator false
      set state no-patches
    ]
  ]

  ask i
  [
    set pcolor [ pcolor ] of cpr
    set capital [ capital ] of cpr
  ]

  if [ capital ] of cpr != [ capital ] of capital-patch [ ask cpr [ update-state update-neighbors ] ]
  set target nobody
  set target-local nobody
  set combat-patches no-patches
  update-state
  update-neighbors
end

to update-neighbors  ;------- CREATES AGENTSET OF CAPITALS OF NEIGHBORING STATES -----
  let capital-patch self
  update-state
  set neighbors-list []
  ask state with [ any? neighbors4 with [ capital != [ capital ] of capital-patch ] ]
  [
    ask neighbors4 with [ capital != [ capital ] of myself ]
    [
      let F-C capital
      ask capital-patch [ set neighbors-list lput F-C neighbors-list ]
    ]
  ]
  set neighbors-list remove-duplicates neighbors-list
  set neighbors-set turtle-set neighbors-list
end

to update-state
  set state patch-set ( patches with [ capital = [ capital ] of myself ] )
end

to spawn-new-state
  let q self
   sprout-capitols 1
  [
    set size 0.5  ;; easier to see
    let black? true
    set pcolor (sentence (random 256) (random 256) random (256))
    if max pcolor <= 80 [ set black? false ]
    if-else black? [ set color black ] [ set color white ]
    set capital self
  ]
  set cost x * ( cost-lb + random-float ( cost-ub - cost-lb ) )
  set state patch-set self
  set target nobody
  set target-local nobody
  ask patches with [ member? q combat-patches ]
  [
    set target nobody
    set target-local nobody
    ask combat-paths [ die ]
    set combat-patches no-patches
  ]
  set local-aggressors no-patches
  update-neighbors
end

to check-exclave
  ask patches with [ capitols-here != no-turtles ]
  [
    let capital-patch self
    set enclosed-state ( patch-set self neighbors4 with [ capital = [ capital ] of myself ] )
    set excl? true
    while [ excl? ]
    [
      ask enclosed-state
      [
        let nbrs neighbors4 with [ capital = [ capital ] of myself and not member? self [ enclosed-state ] of capital-patch ]
        ask capital-patch [ set enclosed-state ( patch-set enclosed-state nbrs ) ]
      ]
      if (patch-set [ neighbors4 with [ capital = [ capital ] of myself and not member? self [ enclosed-state ] of capital-patch ] ] of enclosed-state) =  no-patches
      [
        set excl? false
        ask state with [ not member? self [ enclosed-state ] of capital-patch ]
        [
          if paths-here != no-turtles
          [
            let y sum [ f-resource ] of paths-here
            ask capital-patch
            [
              set resource-n resource-n + y
            ]
          ]
          ask patches with [ member? myself combat-patches ]
          [
            set resource-n resource-n + sum [ f-resource ] of combat-paths with [ path-capital = [ capital ] of myself ]
            ask cmbt-link [ set cas-count-list lput casualty-count cas-count-list ]
            ask combat-paths [ die ]
            set combat-patches no-patches
            set target nobody
          ]
        ]
        let z resource-n / count state
        ask state with [ not member? self [ enclosed-state ] of capital-patch ]
        [
          spawn-new-state
          set resource-n z
          set resource-total resource-n
          ask capital-patch [ set resource-n resource-n * ( ( count state - 1 ) / count state ) ]
        ]
        update-state
      ]
    ]
  ]
end

;------------------- Bargaining Procedures ------------------------------


to EPM-decision-phase-Barg
  ask patches with [ capitols-here != no-turtles and predator ] [ epm-pick-target-barg ]
  if count capitols = 1 [ stop ]
  ask patches with [ capitols-here != no-turtles ] [ epm-allocate-resources ]
end

to EPM-Pick-Target-Barg
  let capital-patch self
  if capitols-here != no-turtles and target = nobody and ( not any? neighbors-set with [ target = [ capital ] of capital-patch ] )
  [
    let PPL []
    ask state [ set PPL lput ( max-one-of ( neighbors4 with [ capital != [ capital ] of capital-patch ] ) [ x ] ) PPL ]
    set PPL remove-duplicates PPL
    set PPL patch-set PPL
    set target-local min-one-of PPL [ ( [ resource-total ] of ( [patch-here] of capital ) ) / x ]
    set target [ capital ] of target-local
  ]
  ;------- SELECT COMBAT PATH IN NEW ATTACK -----
  if target != nobody and combat-patches = no-patches and any? state with [ any? neighbors4 with [ capital = [ target ] of capital-patch ] ]
  [
    let cpr [ patch-here ] of target
    let p ( resource-total / ( resource-total + [ resource-total ] of cpr ) )
    ask one-of state with [ any? neighbors4 with [ self = [ target-local ] of capital-patch ] ]
    [
      let local-attacker self
      ask capital-patch [ set combat-patches ( patch-set local-attacker target-local ) ]
    ]
    let g combat-patches
    if-else cost / ( sum [ x ] of combat-patches with [ capital != [ capital ] of capital-patch ] ) > ( 1 - p ) and capitols-on target-local = 0 ; believes defender will capitulate
    ; \/ attacker beleives that defender will capitulate
    [
      ask cpr
      [
        if-else cost / ( sum [ x ] of g with [ capital != [ capital ] of capital-patch ] ) < ( 1 - p ) ; defender will not capitulate
        [
          ask capital-patch [ epm-create-combat-path ]
        ]
        [
          ask capital-patch [ conquer-province ]
        ]
      ]
    ]
    ; \/ attacker believes that defender will resist
    [
      if-else cost / ( sum [ x ] of combat-patches with [ capital != [ capital ] of capital-patch ] ) < p ; war is worth it
      ; \/ attacker still believes the risk of war is worth the threat
      [
        let t target-local
        ask cpr
        [
          if-else cost / ( sum [ x ] of g with [ capital != [ capital ] of capital-patch ] ) < ( 1 - p ) or t = self ; go to war
          [
            ask capital-patch [ epm-create-combat-path ]
          ]
          [
            ask capital-patch [ conquer-province ]
          ]
        ]
      ]
      ; \/ attacker sees war as not worth it and doesn't attack
      [
        surrender-no-capitulation
      ]
    ]
  ]
end

; setup: if any? patches with [ capitols-here != no-turtles and [ who ] of capitols-here != (sentence [ who ] of capital) ] [ show [ self ] of patches with [ capitols-here != no-turtles and [ who ] of capitols-here != (sentence [ who ] of capital) ]  ]
@#$#@#$#@
GRAPHICS-WINDOW
220
10
928
719
-1
-1
70.0
1
10
1
1
1
0
0
0
1
0
9
0
9
1
1
1
ticks
30.0

BUTTON
20
55
83
88
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
20
95
83
128
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
20
170
192
203
States
States
2
count(patches)
100.0
1
1
NIL
HORIZONTAL

SLIDER
20
210
192
243
Superiority-Ratio
Superiority-Ratio
0
5
2.0
.1
1
NIL
HORIZONTAL

BUTTON
20
133
83
166
go
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
20
250
192
283
k
k
0
1
0.05
.01
1
NIL
HORIZONTAL

PLOT
965
15
1400
310
States
Ticks
States
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plotxy ticks ( count capitols )"

SLIDER
20
290
192
323
predators
predators
1
100
50.0
1
1
%
HORIZONTAL

SWITCH
90
55
207
88
Bargaining?
Bargaining?
0
1
-1000

SLIDER
20
330
192
363
Cost-LB
Cost-LB
0
.99
0.01
0.01
1
NIL
HORIZONTAL

SLIDER
20
370
192
403
Cost-UB
Cost-UB
.01
1
1.0
.01
1
NIL
HORIZONTAL

MONITOR
1405
15
1462
76
States
count capitols
0
1
15

SLIDER
20
405
192
438
V-Ratio
V-Ratio
1
5
3.0
.1
1
NIL
HORIZONTAL

PLOT
965
315
1400
575
War Count
Time
Total Wars
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plotxy ticks war-count"

PLOT
965
580
1400
845
Casualties
Time
Casualties
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plotxy ticks world-casualties"

@#$#@#$#@
## WHAT IS IT?

This was an undergraduate project I did to fufil my honors capstone requirement. The goal was to replicate Lars-Erik Cederman's Emergent Polarity Model from "Emergent Actors in World Politics" (1997). On top of that I implemented the bargaining model of war as a new decision process for states and looked to determine how that affected the power law distribution of casualties.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
setup
find-clusters
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="O-Dom NB" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="0"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="40"/>
      <value value="60"/>
      <value value="80"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="D-Dom" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="0"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="40"/>
      <value value="60"/>
      <value value="80"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Bargain" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="0"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="40"/>
      <value value="60"/>
      <value value="80"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="OD-Bargain" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="0"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="40"/>
      <value value="60"/>
      <value value="80"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="DD-Bargain" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="0"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="40"/>
      <value value="60"/>
      <value value="80"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="WarCount" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>war-count</metric>
    <metric>world-casualties</metric>
    <metric>n-world-casualties</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="WarCount-AltLB" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>war-count</metric>
    <metric>world-casualties</metric>
    <metric>n-world-casualties</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
      <value value="0.2"/>
      <value value="0.4"/>
      <value value="0.6"/>
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="WarCount-AltUB" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>war-count</metric>
    <metric>world-casualties</metric>
    <metric>n-world-casualties</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="0.2"/>
      <value value="0.4"/>
      <value value="0.6"/>
      <value value="0.8"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="ZMT" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>length cas-count-list</metric>
    <metric>sum cas-count-list</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="ZMTO" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>length cas-count-list</metric>
    <metric>sum cas-count-list</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="ZMTD" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>length cas-count-list</metric>
    <metric>sum cas-count-list</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="ZMTBD" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>war-count</metric>
    <metric>world-casualties</metric>
    <metric>length cas-count-list</metric>
    <metric>sum cas-count-list</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="ZMTBO" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count capitols</metric>
    <metric>war-count</metric>
    <metric>world-casualties</metric>
    <metric>cas-count-list</metric>
    <enumeratedValueSet variable="Superiority-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="States">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-UB">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="k">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="V-Ratio">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predators">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Cost-LB">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bargaining?">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
