
globals                    [
                           seed-used
                           ]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;     DEFINE AGENTS IN THE MODEL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

breed                      [firms firm]
breed                      [workers worker]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;     AGENT'S ASSETS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;     FIRM'S ASSETS

firms-own                  [
                           f-production
                           technology
                           f-employees
                           f-capital
                           f-vacancy
                           f-wage-offer
                           f-init-tech
                           alpha
                           intensity
                           f-labor-cost
                           f-capital-cost
                           f-total-cost
                           f-unit-cost
                           f-unit-price
                           markup
                           f-inventory
                           f-revenue
                           f-profit
                           x-position
                           y-position
                           min-wage-inc
                           ]

workers-own                [
                           employed
                           w-pot-firms
                           w-firm
                           w-wage
                           income
                           mpc
                           w-savings
                           w-stores
                           w-stores-l
                           gini
                           wealth
                           ]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;     SETUP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to                         setup
                           clear-all
                           start-firms           number-of-firms
                           start-workers         number-of-workers
                           initialize-variables
                           firms-produce
                           labor-market-opens

                           reset-ticks

end

to                         initialize-variables

                           ask firms
                           [
                           set f-production      1
                           set technology        1
                           set f-employees       no-turtles
                           set alpha             random-float 1
                           set intensity         2 * ((alpha / (1 - alpha)) ^ 2)
                           set f-init-tech       1 + random-float 1
                           set markup            1 + random-float 1
                           set f-capital         100
                           set f-vacancy         0
                           set f-wage-offer      min-wage
                           set f-labor-cost      0
                           set f-capital-cost    0
                           set f-inventory       0
                           set f-revenue         0
                           set f-profit          0
                           set min-wage-inc      0
                           ]

                           ask workers
                           [
                           set employed          false
                           set w-pot-firms       no-turtles
                           set w-firm            nobody
                           set mpc               0
                           set income            0
                           set w-savings         0
                           set gini              0
                           set w-stores          no-turtles
                           set w-stores-l        no-turtles
                           set wealth            0
                           ]
end

to                         go
                           if (ticks >= 500
                           )
                           [stop]

                           goods-market
                           labor-market

                           ask firms
                           [
                           set technology        (f-init-tech) * ( (1 + tech-progress) ^ (ln (1 + ticks) ) )
                           if (ticks >= 100) [set min-wage-inc min-wage-increase]
                           ]
                           tick


end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;     MARKET'S ACTIONS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to                         labor-market
                           labor-market-opens
end

to                         goods-market
                           firms-produce
                           workers-income
                           firms-revenue
                           firing-steps
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;     AGENT'S ACTIONS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;     LABOR MARKET


to                         labor-market-opens

                           ask firms
                           [
                           set f-vacancy         12
                           ]

                           let pot-firms         firms with [f-vacancy > 0]

                           ask workers           with [not employed]
                           [
                           ifelse (not empty?    [w-firm] of w-pot-firms)
                           [set w-pot-firms      (turtle-set w-firm n-of (3 - 1 ) pot-firms)]
                           [set w-pot-firms      n-of (min (list 3 count pot-firms)) pot-firms]
                           ]

                           hiring-step 2

                           ask workers           with [not employed][
                           set w-wage            0
                           rt random             360
                           fd (random 4) + 1
                           ]


                           ask firms
                           [
                           set label count       f-employees
                           ]

end


;;;;;;;;;;;;;;;;;;;;;;     HIRING

to                         hiring-step [trials]

                           while [trials > 0]
                           [
                           ask workers          with [not employed and any? w-pot-firms]
                           [
                           move-to              max-one-of w-pot-firms [f-wage-offer]
                           ]
                           ask firms            with [f-vacancy > 0 ]
                           [
                           let pot-workers      workers-here with [not employed]
                           let quantity         count pot-workers
                           let workers-hired    n-of (min list quantity f-vacancy) pot-workers
                           let wage-employees   f-wage-offer
                           set f-employees      (turtle-set f-employees workers-hired)
                           set f-vacancy        f-vacancy - (count workers-hired)



                           ask f-employees      with [not employed]
                           [
                           set color            white
                           set employed         true
                           set w-wage           wage-employees
                           set w-firm           firms-here
                           set w-pot-firms      no-turtles
                           ]
                           ]
                           set trials trials - 1
                           ask workers with [not employed and any? w-pot-firms][
                           set w-pot-firms min-n-of min (list trials count w-pot-firms) w-pot-firms [f-wage-offer]
                           ]
                           ]

end



;;;;;;;;;;;;;;;;;;;;;;     FIRM'S PRODUCTION

to                         firms-produce

                           ask firms
                           [

                           set f-production technology  * ((count f-employees) ^ (1 - alpha)) * (f-capital ^ (alpha))
                           set f-capital-cost f-capital * 1
                           set f-total-cost f-labor-cost + f-capital-cost

                           set f-wage-offer      min-wage + min-wage-inc + intensity
                           set f-labor-cost     (count f-employees) * f-wage-offer
                           if f-production > 0 [
                           set f-unit-cost  f-total-cost / f-production
                           ]
                           if f-production = 0 [
                           set f-unit-cost 0
                           ]

                           set f-unit-price f-unit-cost * markup

                           ]
end

to                         workers-income
                           ask firms
                           [
                           let wage-stipend f-wage-offer
                           ask f-employees
                           [
                           set w-wage wage-stipend
                           ]
                           ]
                           ask workers[

                           ifelse w-wage >= (mean [w-wage] of workers)
                                  [set mpc (mean [w-wage] of workers) / w-wage]
                                  [set mpc (w-wage / (mean [w-wage] of workers))]
                           set income w-wage
                           let income-for-cons mpc * income

                           set w-savings income - income-for-cons


                           ifelse (any? turtle-set w-stores-l)
                           [
                           let id-store [who] of w-stores-l
                           set w-stores (turtle-set w-stores-l n-of ( min list (x2 - 1) count firms with [who != id-store] ) firms with [who != id-store])
                           ]
                           [
                           set w-stores n-of ( min list x2 count firms ) firms
                           ]
                           set w-stores-l max-one-of w-stores [f-production]
                           if (count w-stores != x2) [show (word "Number of my stores " count w-stores " who " who)]
                           buying-steps x2 income-for-cons
                           ]
                           ask workers
                           [
                           set wealth w-savings
                           ]
end



to                         buying-steps [trials money]

                           while [trials > 0 and money > 0]
                           [
                           let cheapest-store min-one-of w-stores [f-unit-price]
                           let possible-goods-to-buy min list money [f-inventory] of cheapest-store
                           set money money - possible-goods-to-buy
                           ask cheapest-store [
                           set f-inventory f-inventory - possible-goods-to-buy
                           ]
                           ask [patch-here] of cheapest-store [
                           set pcolor blue
                           ]
                           set trials trials - 1
                           set w-stores max-n-of trials w-stores [f-unit-price]
                           ]

end

to                         firms-revenue

                           ask firms [
                           set f-revenue f-unit-price * (f-production - f-inventory)
                           set f-profit f-revenue - f-total-cost
                           ]
end



to                         firing-steps
                           ask firms with [f-profit <= 0] [

                           ask f-employees [
                           set employed false
                           ]

                           set f-production 0
                           set f-inventory 0
                           ]
                           ask firms with [f-profit <= 0 ] [die]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;     VISUALIZATION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



to                         start-firms [#firms]
                           create-firms #firms [
                           set x-position random-pxcor * 0.8
                           set y-position random-pycor * 0.8
                           setxy x-position y-position
                           set color blue
                           set size 2
                           set shape "flag"
                           ]
end

to                         start-workers [#workers]
                           create-workers #workers [
                           setxy random-pxcor random-pycor
                           set color yellow
                           set size 0.5
                           set shape "person"
  ]
end


to-report                  all-workers-savings
                           report [w-savings] of workers
end
@#$#@#$#@
GRAPHICS-WINDOW
862
13
1269
519
-1
-1
9.75
1
10
1
1
1
0
1
1
1
-20
20
-25
25
1
1
1
ticks
30.0

SLIDER
0
13
132
46
number-of-firms
number-of-firms
0
100
60.0
1
1
NIL
HORIZONTAL

BUTTON
0
228
134
262
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
0
268
134
302
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
0
183
133
216
tech-progress
tech-progress
0
1
0.2
0.1
1
NIL
HORIZONTAL

PLOT
154
13
388
187
Firms' Production
Time
Production
0.0
500.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-production] of firms"
"pen-1" 1.0 0 -13345367 true "" "plot min [f-production] of firms"
"pen-2" 1.0 0 -2674135 true "" "plot max [f-production] of firms"

SLIDER
0
55
131
88
number-of-workers
number-of-workers
0
1000
600.0
50
1
NIL
HORIZONTAL

PLOT
155
193
387
347
Firm's Technology
NIL
NIL
0.0
500.0
0.0
10.0
true
false
"" ""
PENS
"mean" 1.0 0 -16777216 true "" "plot mean [technology] of firms"
"max" 1.0 0 -5298144 true "" "plot max [technology] of firms"
"min" 1.0 0 -13345367 true "" "plot min [technology] of firms"

PLOT
157
353
387
515
Firm's wage offer
NIL
NIL
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-wage-offer] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [f-wage-offer] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [f-wage-offer] of firms"

SLIDER
0
99
132
132
min-wage
min-wage
0
1000
400.0
100
1
NIL
HORIZONTAL

PLOT
157
525
387
685
Unit Cost of Product
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-unit-cost] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [f-unit-cost] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [f-unit-cost] of firms"

PLOT
394
13
620
187
alpha
NIL
NIL
0.0
1000.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [alpha] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [alpha] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [alpha] of firms"

PLOT
398
525
622
685
Unit Price of Product
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-unit-price] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [f-unit-price] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [f-unit-price] of firms"

PLOT
394
353
622
513
Wage of Worker
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [w-wage] of workers"
"pen-1" 1.0 0 -2674135 true "" "plot max [w-wage] of workers"
"pen-2" 1.0 0 -13345367 true "" "plot min [w-wage] of workers"

BUTTON
0
310
133
344
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
394
193
621
348
Marginal Propensity to Consume
NIL
NIL
0.0
500.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [mpc] of workers"
"pen-1" 1.0 0 -2674135 true "" "plot max [mpc] of workers"
"pen-2" 1.0 0 -13345367 true "" "plot min [mpc] of workers"

SLIDER
1774
800
1867
833
x2
x2
0
10
10.0
1
1
NIL
HORIZONTAL

PLOT
627
14
845
187
Firm's Revenue
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-revenue] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [f-revenue] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [f-revenue] of firms"

PLOT
629
194
844
347
Firm's Total Cost
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-total-cost] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [f-total-cost] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [f-total-cost] of firms"

PLOT
629
354
844
514
Firm's Profit
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [f-profit] of firms"
"pen-1" 1.0 0 -2674135 true "" "plot max [f-profit] of firms"
"pen-2" 1.0 0 -13345367 true "" "plot min [f-profit] of firms"

PLOT
632
525
847
685
GDP
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [f-production] of firms"

PLOT
862
526
1070
684
Wealth
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [wealth] of workers"
"pen-1" 1.0 0 -2674135 true "" "plot max [wealth] of workers"
"pen-2" 1.0 0 -13345367 true "" "plot min [wealth] of workers"

SLIDER
0
140
132
173
min-wage-increase
min-wage-increase
0
1000
600.0
100
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
