extensions [table]

breed [aggressors aggressor]
breed [rationals rational]
breed [honors honor]
breed [institutionals intitutional]

turtles-own [strength reputation status challenged-by challenged-to mytype visitedlocations mobilitystate currentdestination dxcor dycor]

globals [stagg sthon stins strat died counter Tsi]

patches-own [blockname]


to setup
  ca
  reset-ticks
  set died 0
  set counter 0
  let mx max-pxcor
  let my max-pycor
  let possible-agents mx * my
  let perc population / 100 * possible-agents / 4
  create-aggressors perc [set color red set mytype "aggressor"]
  create-rationals perc [set color green set mytype "rational"]
  create-honors perc [set color yellow set mytype "honor"]
  create-institutionals perc [set color blue set mytype "institutional"]

  ask patches [set pcolor black]

  ;ask patches [set plabel-color black] set plabel word pxcor word "," pycor]

  ask aggressors [
    move-to one-of patches with [not any? turtles-here ]
  ]

   ask rationals [
    move-to one-of patches with [not any? turtles-here]
  ]

   ask honors [
    move-to one-of patches with [not any? turtles-here]
  ]

   ask institutionals [
    move-to one-of patches with [not any? turtles-here]
  ]


   initializations
   network-formation

  ;segregate
   set died table:make
   ;export-view word ticks ".png"
  create-blocks
end

to initializations
  ask turtles[
    set strength random-float 0.50 + 0.4
    set reputation strength
    set status "normal"
    set challenged-by -1
    set challenged-to -1
    set mobilitystate "reached" set visitedlocations table:make
  ]
end

to network-formation ;; needs to be half
  ask turtles [
   network-formation-single
  ]
end

to network-formation-single
  let distantneighbors n-of links-count turtles with [distance myself > radius]
  if (count distantneighbors > 0) [create-links-to distantneighbors]
  ask links [set color black]
end

to aggressors-challenge
  let x 20 / 100 * count aggressors
  let few-agg n-of x aggressors
  ask few-agg [set status "need-to-fight" ]
  ;ask aggressors [set status "need-to-fight"  ]
end

to go
  if ticks = 2000 [stop]
  aggressors-challenge
  set-status
  set-status
  update-values
  proceed
  if mobility-model = "randomwalk" [random-walk]
  draw
  measure-segregation
  tick
  ;export-view word ticks ".png"
end

to set-status
  ask turtles[
  if breed = aggressors [
      if status = "need-to-fight" [
        let id who
        set status "fight"

        challenge id
      ]

      if status = "need-to-respond" [
        set status "fight"

      ]
    ]

    if breed = honors [
      if status = "need-to-respond" [
        set status "fight"

      ]
    ]

    if breed = institutionals [
      if status = "need-to-respond" [
          set status "call"


      ]
    ]

    if breed = rationals [
      if status = "need-to-respond" [
        let x turtle challenged-by
        let rep [reputation] of x
        ifelse (rep >= strength) [set status "giveup" ] [set status "fight" ]
      ]
    ]
  ]
end


to update-values
  ask turtles [
    if status = "fight" and challenged-to != -1 [
      let opponent turtle challenged-to
      let oppstatus [status] of opponent
      if oppstatus = "fight"
      [
        let oppstr [strength] of opponent
        let opprep [reputation] of opponent
        ifelse (strength / oppstr >= 1) [
          set reputation reputation + 0.005
          set strength strength - 0.02
        ]
        [
          set strength strength - 0.03
          set reputation reputation - 0.02
        ]
      ]

      if oppstatus = "giveup"
      [
        ;strenght remains same he wins
        set reputation reputation + 0.01
      ]
    ]

    if status = "fight" and challenged-by != -1 [
      let opponent turtle challenged-by
      let oppstatus [status] of opponent
      if oppstatus = "fight"
      [
        let oppstr [strength] of opponent
        let opprep [reputation] of opponent
        ifelse (strength / oppstr >= 1) [
          set reputation reputation + 0.03
          set strength strength - 0.02
        ]
        [
          set strength strength - 0.03
          set reputation reputation + 0.02
        ]
      ]
    ]


    if status = "giveup" [
      set reputation reputation - 0.01
      set strength strength - 0.005
    ]

    if status = "call" [
      set reputation reputation - 0.02
      let opponent turtle challenged-by

      if random-float 1.00 < effectiveness / 100
      [update-challenger opponent]
    ]
  ]
end



to update-challenger [c]
  ask c [
    set strength strength - 0.04
    set reputation reputation - 0.03
  ]
end

to challenge [id]
  let tempd [link-neighbors] of self
  let tempn turtles in-radius radius
  let tempt (turtle-set tempn tempd)
  let temp nobody
  ifelse (inclusive?)[set temp one-of other tempt ][set temp one-of other tempt with [mytype != "aggressor"]]


  if temp != nobody [
    ask temp [
      set status "need-to-respond"
      set challenged-by id

    ]
    set challenged-to [who] of temp
  ]
end

to proceed
  table:clear died
  set counter 0
  ask turtles [
    if (strength < 1) [set strength strength + 0.0005]
    if (strength < toughness / 100) [
      set counter counter + 1
      let tempd [link-neighbors] of self
      let tempn turtles in-radius radius
      let tempt (turtle-set tempn tempd)
      let a count tempt with [breed = aggressors]
      let r count tempt with [breed = rationals]
      let h count tempt with [breed = honors]
      let i count tempt with [breed = institutionals]
      let b mytype
      set b word b word " " counter
      if (a >= r and a >= h and a >= i) [table:put died b "aggressors" ]
      if (r >= a and r >= h and r >= i) [table:put died b "rationals"  ]
      if (h >= a and h >= r and h >= i) [table:put died b "honors"  ]
      if (i >= r and i >= h and i >= a) [table:put died b "institutionals"   ]

      die
    ]
  ]
  create-news died
  ask turtles[
    refresh-agent

  ]
end

to refresh-agent
  set status "normal"
    set challenged-by -1
    set challenged-to -1
end

to create-news [d]
  foreach table:keys d
  [ [?] ->

     let b table:get d ? ; mytype dieing type

     let c substring ? 0 (position " " ?)
     set c word c "s"; majority type
    ifelse (evolve?) [ ifelse (random-float 1.00 < 0.25) [ create-new c][ create-new b]   ] [ create-new c]
  ]
end

to create-new [t]

  if (t = "aggressors") [create-aggressors 1 [set color red set mytype "aggressor" move-to one-of patches with [not any? turtles-here] set strength random-float 0.50 + 0.4
    set reputation strength network-formation-single set mobilitystate "reached" set visitedlocations table:make]]
  if (t = "rationals") [create-rationals 1 [set color green set mytype "rational" move-to one-of patches with [not any? turtles-here] set strength random-float 0.50 + 0.4
    set reputation strength network-formation-single set mobilitystate "reached" set visitedlocations table:make]]
  if (t = "honors") [create-honors 1 [set color yellow set mytype "honor" move-to one-of patches with [not any? turtles-here] set strength random-float 0.50 + 0.4
    set reputation strength network-formation-single set mobilitystate "reached" set visitedlocations table:make]]
  if (t = "institutionals") [create-institutionals 1 [set color blue set mytype "institutional" move-to one-of patches with [not any? turtles-here] set strength random-float 0.50 + 0.4
    set reputation strength network-formation-single set mobilitystate "reached" set visitedlocations table:make]]
end

to draw
  set stagg 0
  set stins 0
  set sthon 0
  set strat 0

  ask aggressors [
    set stagg stagg + strength
  ]

  ask institutionals [
    set stins stins + strength
  ]

  ask honors [
    set sthon sthon + strength
  ]

  ask rationals [
    set strat strat + strength
  ]
end

to random-walk
  ask turtles [
    do-random-walk 1
  ]
end

to profile-based-walk
  ask turtles[
    ifelse table:length visitedlocations <= 4 [
      if ticks mod 20 = 0 [
      let loc word pxcor word "-" pycor
      table:put visitedlocations loc ticks
      ]
      do-random-walk 1
    ]
    [
      if mobilitystate = "reached" [
        let lst table:keys visitedlocations
        let r random 4
        let dest item r lst
        set currentdestination dest
        let pos position "-" currentdestination
        set dxcor read-from-string (substring currentdestination 0 pos)
        set dycor read-from-string (substring currentdestination (pos + 1) length(currentdestination))
        set mobilitystate "moving"
      ]

      if mobilitystate = "moving" [
        ifelse pxcor = dxcor and pycor = dycor [set mobilitystate "reached"]
        [
          set heading towardsxy dxcor dycor
          forward 1
        ]
      ]
    ]
  ]
end

to do-random-walk [jumplength]
  rt random 360               ; set random heading
  forward jumplength          ; advance one step
end

to segregate
  ask turtles [
    let w who
    let own mytype
    if (not is-happy? w own) [
      move-to one-of patches with [not any? turtles-here]
    ]
  ]
end

to-report is-happy? [w own]
  let n 0
  let nown 0
  ask turtle w [set n sum [count turtles-here] of neighbors in-radius radius]
  ask turtle w [set nown sum [count turtles-here with [mytype = own]] of neighbors in-radius radius]

  let perown 1
  if (n != 0) [set perown nown / n]
  ifelse (perown >= 0.75) [report true] [report false]
end


to create-blocks
  let x 0
  let l 0
  let c 0
  let blocksize 6
  while [l < max-pycor] [
    let k 0
    while [k < max-pxcor] [
      let i 0
      set x x + 1
      while [i < blocksize]
      [
        let j 0
        while [j < blocksize] [
          let mp patch (k + i) (l + j)
          ask mp [ifelse c = 0 [set blockname x] [set blockname x]]
          set j j + 1
        ]
        set i i + 1
      ]
      ifelse c = 0 [set c 1] [set c 0]
      set k k + blocksize
    ]
    ifelse c = 0 [set c 1] [set c 0]
    set l l + blocksize
  ]
end

to measure-segregation
  let i 1
  let blocksize 3
  ;let b count patches / blocksize ; blovk size 3*3
  set Tsi 0

  let A count aggressors
  let B count honors
  let C count institutionals
  let D count rationals
  while [i < 50] [
    let bpatches patch-set patches with [blockname = i]
    let aa sum [count aggressors-here ] of bpatches
    let bb sum [count honors-here ] of bpatches
    let cc sum [count institutionals-here] of bpatches
    let dd sum [count rationals-here] of bpatches

    let si abs((aa / A) - (bb / B) - (cc / C) - (dd / D))
    ;let si abs((bb / B) - (gg / G) )
    set Tsi Tsi + si
    set i i + 1
  ]
  set Tsi Tsi / 4


end
@#$#@#$#@
GRAPHICS-WINDOW
919
10
1337
429
-1
-1
10.0
1
10
1
1
1
0
1
1
1
0
40
0
40
0
0
1
ticks
30.0

SLIDER
85
12
257
45
population
population
0
99
99.0
1
1
NIL
HORIZONTAL

BUTTON
10
12
73
45
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
11
53
74
86
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
264
12
436
45
radius
radius
1
3
2.0
1
1
NIL
HORIZONTAL

CHOOSER
446
10
584
55
links-count
links-count
0 1 2 4 8 16
2

PLOT
0
118
443
324
Types of agents 
time (iterations)
# of agents
0.0
2000.0
0.0
10.0
true
true
"" ""
PENS
"aggressors" 1.0 2 -2674135 true "" "plot count aggressors"
"institutionals" 1.0 2 -13791810 true "" "plot count institutionals"
"rationals" 1.0 2 -13840069 true "" "plot count rationals"
"honors" 1.0 2 -1184463 true "" "plot count honors"

SLIDER
84
79
256
112
effectiveness
effectiveness
0
100
100.0
1
1
NIL
HORIZONTAL

SLIDER
266
79
438
112
toughness
toughness
5
60
60.0
1
1
NIL
HORIZONTAL

CHOOSER
448
74
586
119
mobility-model
mobility-model
"stationary" "randomwalk"
0

SWITCH
598
85
706
118
inclusive?
inclusive?
0
1
-1000

PLOT
458
121
915
322
Average Strength and Segregation Index
time (iterations)
[0-1]
0.0
2000.0
0.0
1.0
true
true
"" ""
PENS
"aggrressor" 1.0 2 -2674135 true "" "plot stagg / count aggressors"
"institutional" 1.0 2 -13791810 true "" "plot stins / count institutionals"
"rational" 1.0 2 -13840069 true "" "plot strat / count rationals"
"honor" 1.0 2 -1184463 true "" "plot sthon / count honors"
"segregation" 1.0 2 -16777216 true "" "plot Tsi"

SWITCH
712
84
815
117
evolve?
evolve?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <metric>count aggressors</metric>
    <metric>count institutionals</metric>
    <metric>count rationals</metric>
    <metric>count honors</metric>
    <metric>stagg / count aggressors</metric>
    <metric>stins / count institutionals</metric>
    <metric>strat / count rationals</metric>
    <metric>sthon / count honors</metric>
    <metric>Tsi</metric>
    <enumeratedValueSet variable="effectiveness">
      <value value="0"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
      <value value="20"/>
      <value value="25"/>
      <value value="30"/>
      <value value="35"/>
      <value value="40"/>
      <value value="45"/>
      <value value="50"/>
      <value value="55"/>
      <value value="60"/>
      <value value="65"/>
      <value value="70"/>
      <value value="75"/>
      <value value="80"/>
      <value value="85"/>
      <value value="90"/>
      <value value="95"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="toughness">
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
      <value value="20"/>
      <value value="25"/>
      <value value="30"/>
      <value value="35"/>
      <value value="40"/>
      <value value="45"/>
      <value value="50"/>
      <value value="55"/>
      <value value="60"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
