breed [buyers buyer]
breed [sellers seller]
breed [farmers farmer]
breed [speculators speculator]
breed [firms firm]
;breed [happiest happy] ; to take out fulfilled buyers out of the market
;breed [no-stocks no-stock]
;breed [unhappiest_buyers unhappy_buyer]
;breed [unhappiest_sellers unhappy_seller]

Globals [b-price s-price bid_schedule ask_schedule last_price round_price number_of_buyers_left highest_bid lowest_ask number_of_sellers_left rounds periods]

buyers-own [bid stock_demanded Own_ID Money_Holdings]
sellers-own [ask_offer inventory Own_ID Money_Holdings]
farmers-own [ask_offer inventory Own_ID Money_Holdings]
speculators-own [bid stock_demanded ask_offer inventory Own_ID Money_Holdings]
firms-own [bid stock_demanded Own_ID Money_Holdings]


to Setup
  clear-all
  create-firms Number-of-Firms [
    set Own_ID 0
    set color blue
    ask firms [find_patch]
    set bid random bid-variation
    set stock_demanded random demand-variation
    set Money_Holdings 500
  ]                                                   ; create a sort-of demand curve, placeholder, will be more 'adaptive' in the future where bids are endogenously generated instead of exogenously determined
  create-farmers Number-of-Farmers [
    set Own_ID 1
    set color red
    ask farmers [find_patch]
    set ask_offer random ask-variation
    set inventory random inventory-variation
    set Money_Holdings 500
  ]                                                    ; create a sort-of supply curve
  create-speculators Number-of-Speculators [
    set Own_ID 2
    set color green
    ask speculators [find_patch]
    set bid 0
    set ask_offer 0
    set inventory 0
    set Money_Holdings 500
  ]

  set s-price []
  set bid_schedule []
  set ask_schedule []
  set last_price 0
  set number_of_buyers_left 0
  set number_of_sellers_left 0
  set rounds 1
  set periods 1
  reset-ticks
end

;;;; setup stuff ;;;;;;;
to find_patch
  setxy random-xcor random-ycor
  while [any? other turtles-here] [find_patch]
end
;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;; To go ;;;;;;;;;;;
to go
  ;;if round = 1 [
    ;; do accounting, this is a new period afterall. Determine performance in the last period. This is where period-to-period readjustment will happen
    ;; farmer harvest and decide how much to plant based on past. After this they decide on initial bid
    ;; speculators see how much is planted, and decide whether to bid, or ask, and at what price and quantity
    ;; firm determines bid based on whether current income can afford it]
  create_buyers
  create_sellers
  create_bid_schedule
  create_ask_schedule
;;  print last first ask_schedule - when want to know the lowest asking price
;;  print last first bid_schedule - when want to know the highest bid price
;;  print last first bid_schedule
;; print first first bid_schedule  - when want to know who is the higest bidder
  auction_round
  readjustment  ; need to readjust based on rounds in the future
  if all? buyers [stock_demanded = 0][
    stop]
  if all? sellers [inventory = 0][
    stop]
  plot_stuff    ; we do plot stuff first because of we are monitoring the more 'general breeds'
  return_to_original_breed
  round_accounting
  tick
end


to create_sellers
  ask farmers [
    set breed sellers]
;  ask speculators [           This is to let speculators become sellers under certain condition, yet to be introduced
;    if .... [
;      set breed sellers]
end

to create_buyers
  ask firms [
    set breed buyers]
;  ask speculators [           This is to let speculators become buyers under certain condition, yet to be introduced
;    if .... [
;      set breed buyers]
end


to create_bid_schedule
  let d []
  set d sort ([who] of buyers)
  foreach d [ ID ->
    let temp2 []
    set temp2 lput ID temp2
    set temp2 lput ([bid] of buyer ID) temp2
    set bid_schedule lput temp2 bid_schedule]
  set bid_schedule sort-by [ [x y] ->  last x > last y] bid_schedule ; ordering the schedule from the highest bidder to the lowest bidder
;  print bid_schedule
end

to create_ask_schedule
  let d []
  set d sort ([who] of sellers)
  foreach d [ ID ->
    let temp2 []
    set temp2 lput ID temp2
    set temp2 lput ([ask_offer] of seller ID) temp2
    set ask_schedule lput temp2 ask_schedule]
  set ask_schedule sort-by [ [x y] ->  last x < last y] ask_schedule ; ordering the schedule from the lowest ask offer to the highest
;    print ask_schedule
end

to auction_round
  if empty? bid_schedule [stop] ; highly unlikely
  while [(last first bid_schedule) >= (last first ask_schedule)] [
    ask buyer (first first bid_schedule) [   ; the highest bidder has the right to buy first, she will of course buy from the lowest asker
      let bid_price []
      let Q_bid []
      let ask_price []
      let Q_ask []
      set bid_price bid
      set Q_bid stock_demanded
      ask seller (first first ask_schedule) [ ; gathering info from the seller we face

        set ask_price ask_offer
        set Q_ask inventory
      ]

      ;;;; Auction starts for real ;;;;;;;;

      ifelse stock_demanded = 0 [  ; if buyer already exit the market, still has nothing to buy, she will leave the market again. This is admitedly a convoluted way of eliminating bidders who exit from previous rounds
        set bid_schedule remove-item 0 bid_schedule
      ]
      [;;;;;;; if bidder really has something to buy
      ifelse Q_bid <= Q_ask [ ; when quantity needed is more than quantity offered by seller
        set stock_demanded stock_demanded - Q_bid
        set Money_Holdings Money_Holdings - ((bid_price + ask_price) / 2) * Q_bid ; buyers have to pay, which takes away her money holdings
        ask seller (first first ask_schedule) [
          set Money_Holdings Money_Holdings + ((bid_price + ask_price) / 2) * Q_bid ; sellers got paid, it's money holdings are increased
          set inventory inventory - Q_bid
          if inventory = 0 [set ask_schedule remove-item 0 ask_schedule]   ; sellers only exit when they run out of inventory
        ]
        set bid_schedule remove-item 0 bid_schedule                        ; if bid is fulfilled, then they exit the auction
        set last_price ((bid_price + ask_price) / 2)
        ]
        ;;;;;;;;  when initial bid cannot be fulfilled by initial ask. This is the case where  Q_bid > Q_ask
        [
        ifelse Q_ask = 0 [                                     ; eliminate sellers that already have nothing to sell
          set ask_schedule remove-item 0 ask_schedule]
        [
        set stock_demanded stock_demanded - Q_ask
        set Money_Holdings Money_Holdings - ((bid_price + ask_price) / 2) * Q_ask
        ask seller (first first ask_schedule) [
          set Money_Holdings Money_Holdings + ((bid_price + ask_price) / 2) * Q_ask
          set inventory 0
        ]
        set ask_schedule remove-item 0 ask_schedule             ; eliminate sellers that already have nothing to sell, won't eliminate buyer yet as full ordernot yet fufilled
        set last_price ((bid_price + ask_price) / 2)
      ]]  ; in usual times, this just makes sure buyers gets their orders fulfilled. If askers already left, this just eliminates them from the ask schedule until bidder can deal with asker with something to sell
  ]]
    if empty? bid_schedule [stop]   ; after all current demand and supply orders are filled , which would result in the end of this procedure, and move on to 'readjustment'
    if empty? ask_schedule [stop]]
end

to readjustment   ; A placeholder for now, should be more complicated in the future
  foreach (bid_schedule) [Buyer_ID ->
    ask buyer first Buyer_ID[                            ; change the bid, and remove them from the list so a new list can be generated in the future
      set bid bid + random U_readjustment_rate
    ]
    set bid_schedule remove-item 0 bid_schedule
  ]
  foreach (ask_schedule) [Seller_ID ->
    ask seller first Seller_ID [
      set ask_offer ask_offer - random D_readjustment_rate
    ]
    set ask_schedule remove-item 0 ask_schedule
  ]
end

to plot_stuff
  set number_of_buyers_left count buyers with [stock_demanded > 0]
  set number_of_sellers_left count sellers with [inventory > 0]
  set highest_bid max [bid] of buyers with [stock_demanded > 0]
  set lowest_ask min [ask_offer] of sellers with [inventory > 0]
end

to return_to_original_breed
  ask turtles [
    if Own_ID = 0 [
      set breed firms]
    if Own_ID = 1 [
      set breed farmers]
    if Own_ID = 2 [
      set breed speculators]
  ]
end

to  round_accounting
  ifelse rounds < 12 [
    set rounds rounds + 1]
   [set rounds 1            ; when current round is already 12
    set periods periods + 1]
end
@#$#@#$#@
GRAPHICS-WINDOW
918
56
1111
250
-1
-1
5.61
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

SLIDER
28
113
200
146
Number-of-Farmers
Number-of-Farmers
1
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
28
146
200
179
bid-variation
bid-variation
1
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
28
178
200
211
demand-variation
demand-variation
1
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
221
110
393
143
Number-of-Firms
Number-of-Firms
1
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
221
143
393
176
ask-variation
ask-variation
1
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
221
176
393
209
inventory-variation
inventory-variation
1
100
50.0
1
1
NIL
HORIZONTAL

BUTTON
64
62
128
95
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
145
61
208
94
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
323
256
389
301
NIL
last_price
2
1
11

SLIDER
28
211
200
244
U_readjustment_rate
U_readjustment_rate
1
5
3.0
1
1
NIL
HORIZONTAL

SLIDER
220
209
392
242
D_readjustment_rate
D_readjustment_rate
1
5
3.0
1
1
NIL
HORIZONTAL

PLOT
405
61
885
488
Price evolution
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Last price " 1.0 0 -16777216 true "" "plot last_price"
"highest bid" 1.0 0 -13345367 true "" "plot highest_bid"
"lowest ask" 1.0 0 -2674135 true "" "plot lowest_ask"

BUTTON
219
61
337
94
go without stop
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
275
305
391
350
Number of buyers left
number_of_buyers_left
2
1
11

MONITOR
275
355
391
400
Number of sellers left
number_of_sellers_left
2
1
11

SLIDER
86
356
264
389
Number-of-Speculators
Number-of-Speculators
1
100
50.0
1
1
NIL
HORIZONTAL

MONITOR
331
407
388
452
round
rounds
17
1
11

MONITOR
332
460
389
505
period
periods
17
1
11

PLOT
919
267
1251
479
Income monitor
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Mean farmer income" 1.0 0 -16777216 true "" "plot mean [Money_Holdings] of farmers"
"Mean firm income" 1.0 0 -7500403 true "" "plot mean [Money_Holdings] of firms"
"Mean Speculator income" 1.0 0 -2674135 true "" "plot mean [Money_Holdings] of speculators"

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
