;;;
;;; Define Variables          (declaration)
;;;

breed [ customers customer ]      ;; customers the main target of Microfinance.
breed [mfis mfi]                      ;; Microfinance institution, which give a loan to the customer.
breed [ partners partner ]        ;; partners who evaluate the loan amount according to the purpose of the loan.
breed [donors donor]      ;; donors who finance MFI.


globals [ 
  periods                          ;; the time span we consider. number represents the year after the starting time.
  ;custom_solvab?
  fund
  credit_amount                       ;; the limit of each microcredit
  interestrate                    ;; interest rate for the microcredit charged by the MFI.  
  wealth_mfi                      ;; profits of the mfi
  amount_purposeloan? 
  efficiency 
  profitability 
  productivity 
  credit_risk 
  average_loan_balance_per_borrower 
  nb_customers
  performance_achieved?    ;; if true, the IMF achieved social and financial performance
  funds_Offer?             ;; the donors offer funds to mfi
  profit_loss_amount       ;; the amount of the profit or the loss of the activity
  financing_cost
  wealth_funds
]                         

patches-own [
]

customers-own [
  wealth_cust                    ;; each individual's wealth level
  sex                            ;; each individual sex, either male or female8
  marital_status     ;; Married, single, divorced or widow
  customer_activity     ;; the activity of the customer, either agriculture, trade or cruft
  level_education     ;; the level of education of the customer: bad, medium or high level of education
  insured_customer     ;; the customer is insured or not
  customer_residence     ;; Rural or Urban area
  purpose_loan             ;; Creation or Devlopment of the activity
  customer_type       ;; Old or new customer
  nb_loan       ;; the number of loan contracted by the customer
  cross_indebteness     ;; if the customer has another loan with other institutions
  unpaid_amount       ;; the unpaid amout of the loan
  nb_paid_installments           ;; the number of paid installments
  nb_installments       ;; the number of installments
  borrowingdate                  ;; the date when one of poors get a loan from mfi
  ;wealth_sufficient?    ;; if true, customer can reimburse his loan.
  repay_amount?      ;; if true, customer reimubrse his loan.
  borrower-mfi?                  ;; if true, the turtle has got a microcredit from mfi.
  customer_score
]                              



;;;
;;; SETUP PROCEDURES          (initialisation)
;;;


to-report VARY [#low #high]   ;; reports a random integer in given range, inclusive 
   report #low + random(#high - #low + 1) 
end 


 

to SETUP
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  clear-all
  reset-ticks
  setup-patches
  setup-customers
  set periods time-span-years  ;; the slider of time-span-years stands for the periods (years).
  reset-ticks
end

to setup-patches
  ask patches [ set pcolor black ]  ;; set patche's color black. 
  mfi-setup
  partners-setup
 end

to mfi-setup
  ask patches [
     ask patch 0 0 [set  pcolor  red]          ;; the color for the patch of MFI is yellow.
    sprout-mfis 1 [                              ;; for visual impact, the mfi has the shape of yellow house.
      set size 3
      set shape "house"
      set color red   
      setxy 0 0
      set fund microcredit-available      ;; microcredits available from mfi is set using the slider of microcredit-available.
      set credit_amount vary 1 20 ;; the loan limit from the MFI is set using the slider -> need to make credit-limit slider
      set wealth_mfi fund  
      set performance_achieved?  random 2
      set funds_Offer? random 2
      set wealth_funds wealth-funds

    ]
 ] 
end

to partners-setup
  ask patches [
    
     ask patch 0 10 [set  pcolor  grey]                      ;; the suppliers of raw materials are on the grey patch
    ask patch 0 -10 [set  pcolor  grey]
    ask patch 10 0 [set  pcolor  grey]                   
   ask patch -10 0 [set  pcolor  grey]
    sprout-partners 1 [                  ;; for visual impact, the raw material suppliers have the shapes of grey trucks.
      set size 2
      set shape "circle"
      set color grey    
      setxy 0 10 
      set amount_purposeloan? true    ;; if true, the amount applied by customer is accepted.
    ]
    sprout-partners 1 [
      set size 2
      set shape "circle"
      set color grey    
      setxy 0 -10
      set amount_purposeloan? true    ;; if true, the amount applied by customer is accepted.
    ]
    sprout-partners 1 [
      set size 2
      set shape "circle"
      set color grey    
      setxy 10 0
      set amount_purposeloan? true   ;; if true, the amount applied by customer is accepted.
    ]
    sprout-partners 1 [
      set size 2
      set shape "circle"
      set color grey    
      setxy -10 0
      set amount_purposeloan? true   ;; if true, the amount applied by customer is accepted.
    ]
  ]
  
end





to setup-customers
  create-customers customers-number           ;; uses the value of the customers-number slider to set the number of customers.
  
  ask customers [ set shape  "person"
    set color green     ;; the color for the customer is green.
    setxy random-xcor random-ycor  
    set wealth_cust random-normal 50 15        ;; wealth level each custumers start with come from N(50, 15) 
    set sex random 2                      ;; sex for each custumers is either o (female) or 1 (male)
    set customer_type random 2            ;; statut for each custumer is either old (0)  or new (1).      
    set marital_status random 2      ;; either Married (0) or single (1).
    set customer_activity random 4    ;; either agriculture or cruft (0), trade (1), industry (2) or others (3)
    set level_education  random 3           ;; either bad (0), medium (1) or high (2) level of education
    set insured_customer random 2         ;; the customer is insured (1) or not (0)
    set customer_residence random 2        ;; Rural (1) or Urban area (0)
    set purpose_loan random 2             ;; Creation (0) or Devlopment (1) of the activity        
    ;set custom_solvab? FALSE     ;; if true, customer is accepted.
    ;set wealth_sufficient? false    
    set borrower-mfi? random 2                ;; if true, the turtle has got a microcredit from mfi.
    set repay_amount? random 2
    set nb_loan 0
    set cross_indebteness 0
    set unpaid_amount 0
    set nb_paid_installments 0
    set nb_installments 0
    set customer_score vary -5.0 5.0
    set profit_loss_amount profit-loss-amount
    set financing_cost financ-cost
  ]
end


 

;;;
;;; GO PROCEDURES
;;;

to go    if ticks >= 365 * periods  [ stop ] ;; the time span is restricted to periods (year). *
   ask customers [
    move-customers           ;; this procedure makes customers move.  
    microcredit_application  ;; this procedure makes customer ask for a microcredit. 
    reimburse-mfi            ;; this procedure makes customers reimburse their loans towards mfi.
    ;donors_mfi               ;; this procedure makes mfi get funds from donors.
       ]

 tick                     ;; one tick stands for one day. 
    update-plot              
  
end  

  
  

to move-customers  
  right random 360
  forward random 4        
  set wealth_cust ( wealth_cust - 0.05 )
end  

;;;
;;; granting microcredit from mfi
;;;
    
    
   to-report custom_solvab?
  ifelse  (customer_type = 0 and customer_score > -0.58) or (customer_type = 1 and customer_score > 1.8)
   [ report true ]
    [ report false ]
   end
    

  to-report mfi_performance
 report ((efficiency + profitability + productivity + credit_risk + average_loan_balance_per_borrower + nb_customers) / 6  )
end 

      

to microcredit_application
    
  if (fund >= credit_amount) and wealth_cust < 20 and wealth_cust > 5 [     ;; microcredit is possible only when the MFI have money enough to loan and customers is located in the same patch as MFI, which reflects 
 ;if (wealth_mfi >= credit_amount)  [     ;; microcredit is possible only when the MFI have money enough to loan and customers is located in the same patch as MFI, which reflects  
   ; ask customers with [ (credit_amount <= 20 and  amount_purposeloan? = true) or (amount_purposeloan? = false or credit_amount > 20) ]  [  ;; the amout of loan applied by customer.  
     ;;  ifelse ((customer_type = 0 and customer_score > -0.58) or (customer_type = 1 and customer_score > 1.8))   
       ;; [set custom_solvab? true][set custom_solvab? false]

   ask customers with  [custom_solvab? = true ] [ 
      set wealth_cust  (wealth_cust +  credit_amount )        
      set color yellow        ;; those with microcredit turn yellow.
      set wealth_mfi  (fund - credit_amount) ;; available fund to loan will decreases as the loan increases.
      ;;set custom_Solvab? true 
      set borrower-mfi? 1             ;; if true, the turtle has got a microcredit from mfi.
      set borrowingdate ticks ] 
  ; ]
     ask customers with  [custom_solvab? = false] [
        set wealth_cust ( wealth_cust)        
        set color orange        ;; those with microcredit turn orange.
          ;;set custom_Solvab? false
          set borrower-mfi? 0  ;; if true, the turtle has got a microcredit from mfi
          set wealth_mfi (wealth_mfi)       ;; available fund .
         
     ]
  ]
  
end
  
  to-report wealth_sufficient?
 
;; ifelse ( wealth_cust >= ((credit_amount * interestrate / 100 / 365) / (1 - (1 + interestrate / 100 / 365)^(ticks - borrowingdate )) * ( ticks - borrowingdate )))
 ;; ifelse ( wealth_cust >= ((credit_amount * interestrate / 100 / 365) / (1 - (1 + interestrate / 100 / 365)^(loan_duration * -30 )) * loan_duration * 30))
 ifelse ( (wealth_cust + profit_loss_amount ) >= ( 1 + financing_cost) * credit_amount)
   [ report true ]
   [ report false ]
    
   
 end


to reimburse-mfi
if ( borrower-mfi? = 1 and color = yellow and  wealth_sufficient? = true) [  ;; customers can repay their debts only if he has contracted loan from mfi.
;if (color = yellow and wealth_sufficient? = true ) [  ;; customers can repay their debts only if he has contracted loan from mfi.
   ask customers with [ repay_amount? = 1 ][
          set wealth_cust ((wealth_cust + profit_loss_amount ) - (( 1 + financing_cost / 100 / 365 * ( ticks - borrowingdate ) ) * credit_amount)) ;; the amount of repayment is the summation of pricipal and interest (annual interest rate -> daily interest rate)
          set color violet ;; after repay, the color turn into violet
          set wealth_mfi ( wealth_mfi + (( 1 + financing_cost / 100 / 365 * ( ticks - borrowingdate) ) * credit_amount) - 20 ) ;; interest rate is rate for one year.
          if ticks - borrowingdate <= 365 [ set nb_paid_installments ( nb_paid_installments + 1 ) ]   ;;maturity for the loan is assumed to be one year.
   ]
        ask customers with [ repay_amount? = 0][
          set wealth_cust (wealth_cust +  profit_loss_amount) ;; the amount of repayment is the summation of pricipal and interest (annual interest rate -> daily interest rate)
          set color pink ;; after repay, the color turn into pink
          if ( wealth_funds + wealth_mfi >= (1 + financing_cost)* credit_amount)
          [set wealth_mfi ( wealth_mfi + (( 1 + financing_cost / 100 / 365 * ( ticks - borrowingdate) ) * credit_amount) - 20 ) ;; interest rate is rate for one year.
          set unpaid_amount (unpaid_amount + ((1 + financing_cost / 100 / 365 * ( ticks - borrowingdate) ) * credit_amount))
          if ticks - borrowingdate <= 365 [ set nb_paid_installments ( nb_paid_installments) ]  
          SET wealth_funds wealth_funds - (( 1 + financing_cost / 100 / 365 * ( ticks - borrowingdate) ) * credit_amount)
        ]]
]
  
end

      



;to donors_mfi
   ;ask customers with [(( efficiency + profitability + productivity + credit_risk + average_loan_balance_per_borrower + nb_customers) / 6 >= 3) and  count customers with [custom_Solvab? = true] >= 0.7 * customers-number] [
         ;  set wealth_mfi (wealth_mfi + 100 + 50)
          ; set performance_achieved? 1
          ; set funds_Offer? 1
           
       ; ]
   
;end



;;;
;;; reports
;;;


to-report average-wealth-customer
  report ( sum [ wealth_cust ] of customers / count customers )
end

to-report sum-wealth-mfi
  report ( sum [ wealth_mfi] of mfis)
end

to-report customer-solvability
  report ( count customers with [ custom_Solvab? = true] )
end


To-report customer-reimburse-loan
  report ( count customers with [ repay_amount? = 1 and custom_solvab? = true ] )
end


to-report solvability-ratio
  report (count customers with [ custom_Solvab? = true] / count customers )
    
end
 
 to-report PAR30
   report ( sum [ credit_amount ] of customers with [ ticks - borrowingdate >= 30 ] /  sum [ credit_amount ] of customers )
 end
  to-report PAR90
   report ( sum [ credit_amount ] of customers with [ ticks - borrowingdate >= 90 ] /  sum [ credit_amount ] of customers )
 end
   to-report PAR180
   report ( sum [ credit_amount ] of customers with [ ticks - borrowingdate >= 180 ] /  sum [ credit_amount ] of customers )
 end

;;;
;;; PLOTS 
;;;
  
to update-plot
  set-current-plot "Average Wealth-customer"
  set-current-plot-pen "customers"
  plot sum [ wealth_cust ] of customers / count customers


  set-current-plot "Wealth-mfi"
  set-current-plot-pen "mfi"
  plot sum [ wealth_mfi ] of mfis

  
  set-current-plot "Average Loan"
  set-current-plot-pen "customers"
  plot sum [ credit_amount ] of customers / count customers 
  
  set-current-plot "Number of Payment"
  set-current-plot-pen "customers"
  plot sum [ nb_paid_installments ] of customers
 
 

  
end
@#$#@#$#@
GRAPHICS-WINDOW
195
30
553
409
16
16
10.55
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
15
35
82
68
NIL
SETUP
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
90
35
153
68
NIL
GO
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
115
187
148
customers-number
customers-number
0
1500
140
10
1
NIL
HORIZONTAL

SLIDER
5
160
190
193
time-span-years
time-span-years
0
5
2
1
1
NIL
HORIZONTAL

SLIDER
5
205
190
238
microcredit-available
microcredit-available
0
2000
2000
100
1
NIL
HORIZONTAL

MONITOR
565
180
765
233
NIL
average-wealth-customer
4
1
13

MONITOR
775
180
975
233
NIL
sum-wealth-mfi
4
1
13

PLOT
565
30
765
180
Average Wealth-customer
time
level
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"customers" 1.0 0 -16777216 true "" ""

PLOT
775
30
975
180
Wealth-mfi
time
level
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"mfi" 1.0 0 -16777216 true "" ""

PLOT
560
240
760
390
Average Loan
time
level
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"customers" 1.0 0 -16777216 true "" ""

MONITOR
715
400
840
453
NIL
customer-solvability
17
1
13

MONITOR
560
455
672
508
NIL
solvability-ratio
4
1
13

MONITOR
560
400
715
453
NIL
customer-reimburse-loan
17
1
13

PLOT
770
240
970
390
Number of Payment
time
level
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"customers" 1.0 0 -16777216 true "" ""

MONITOR
845
400
970
453
NIL
mfi_performance
17
1
13

BUTTON
90
70
153
103
NIL
GO
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
5
255
190
288
profit-loss-amount
profit-loss-amount
-5
5
5
1
1
NIL
HORIZONTAL

SLIDER
5
300
190
333
financ-cost
financ-cost
0
20
15
1
1
NIL
HORIZONTAL

SLIDER
5
345
190
378
wealth-funds
wealth-funds
0
10000
10000
1
1
NIL
HORIZONTAL

@#$#@#$#@
## Netlogo version
The model is executed using Netlogo 5.1.0
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
