breed [households household]
breed [banks bank]

banks-own [assets liabilities LoansCreated networth deposits reserves Total-Loans-Outstanding deposit-to-asset loans-to-reserve]
households-own [MPC ExpenditureLag Gestation origin
  deposits ;; by this we meant ready deposits
  RM ;; currency
  FixedDeposits ;; real savings kind of situation
  ExpenditurePlans ;; schedule for expenditure, list of list have 3 things (amount to be spent, how much to spend this time, and how many tick left to be spent)
  orders]
globals [
  transactions
  output
  New-Output
  New-Transactions
]

to setup
  clear-all
  create-households No.Households
  ask households [
    set color white
    set shape "person"
    setxy random-xcor random-ycor
    set MPC ConsumptionPropensity  ;; How much to spend given income
    set ExpenditureLag LagDenom   ;;A denominator on how to chop up planned expenditure
    set Gestation lagOutput   ;;Time taken for output to be produced
    set origin 0
    set deposits endowment     ; change this soon. Give endowment
    set RM 0
    set FixedDeposits 0
    set ExpenditurePlans []
    set orders []
  ]
  create-banks 1
  ask banks [
    set color green
    set shape "house"
    set reserves Initial-Reserves
    set assets reserves
    set deposits endowment * No.Households
    set liabilities deposits


    set deposit-to-asset (deposits + 0.001) / (assets + 0.001)
    set Total-Loans-Outstanding deposits
    set loans-to-reserve Total-Loans-Outstanding / reserves
  ]
  set transactions 0
  set output 0
  set New-Transactions 0
  set New-Output 0
  UpdateNetworth
  reset-ticks
end

to step
  if CreateLoan?  [
  CreateTheLoan ;; banks create loans and same amount of deposit is created
  ]
  OrganiseSavings  ;; Decide how much of income to save in FD (determined by MPC), convert deposits to currency
  Expend  ;; spend money, get recievers to process orders
  ProcessOrder
  UpdateNetworth
  tick
end

to CreateTheLoan
  ask banks [
    if reserves > 0 [
    if (liabilities + 0.01) / assets < liability-to-asset-ratio  [
      if reserves < 0 [ print "negative!"]
      set LoansCreated loan-creation
      set Total-Loans-Outstanding Total-Loans-Outstanding + LoansCreated
      set deposits deposits + loan-creation
      let random-household one-of households
      send-loan-to random-household LoansCreated]
    ]

  ]
end

to send-loan-to [recipient transfer]
  ask recipient [
    set deposits deposits + transfer
    set color red
    set origin 1
  ]
end


to OrganiseSavings
  ask households [
    ifelse origin = 0 [
      let SavingsRate 1 - ConsumptionPropensity
      let current-household who
      ifelse deposits * (1 - SavingsRate) > MinimumSpending [        ;; if your deposit (after savings) is already higher than minimum spending
        PlanExpendProcess current-household SavingsRate LagDenom
        ][         ;; if existing deposits alone can't cover it all
          set color yellow
          set SavingsRate 0
          ifelse FixedDeposits + deposits >= MinimumSpending [    ; if still have money in FD, just don't have enough existing deposits
              let ExistingDeposit deposits
              let shortfall (MinimumSpending - ExistingDeposit)
              AltPlanExpendProcess current-household shortfall LagDenom
              ] [   ; if don't even have enough savings
                  set color pink
                  set SavingsRate 0
                  ifelse FixedDeposits > 0 [     ; gather crumbs
                  let leftover FixedDeposits
                  AltPlanExpendProcess current-household leftover LagDenom
                    ] [
                        PlanExpendProcess current-household SavingsRate LagDenom
                    ]
                ]
        ]
      ]
    [
      let SavingsRate 0
      if deposits > 0 [
        let current-household who
        PlanExpendProcess current-household SavingsRate LagDenom

        set origin 0   ;; return back as normal spender
      ]
    ]
  ]
end

to AltPlanExpendProcess [OwnHousehold FDWithdrawal OwnLagDenom]
  ask household OwnHousehold [

        set FixedDeposits FixedDeposits - FDwithdrawal  ;; Keep this in bank as permanent savings
        let SpendingAcc deposits + FDwithdrawal

        BankWithdrawal SpendingAcc  ;; Update bankside (reduce reserve and deposit)
        set deposits 0  ;; Update deposit depletion
        set RM RM + SpendingAcc   ;; Update currency accumulation
        let chunks OwnLagDenom
        let amount SpendingAcc ;; new amount planned to be spent
        let delay ownLagDenom
        PlanExpenditure OwnHousehold amount chunks delay
  ]
end


to PlanExpendProcess [OwnHousehold OwnSavingsRate OwnLagDenom]
  ask household OwnHousehold [
        let savings deposits * OwnSavingsRate   ;; determine how much to save
        set FixedDeposits FixedDeposits + savings ;; Keep this in bank as permanent savings
        let SpendingAcc deposits - savings
        set savings 0
        let withdrawal SpendingAcc ;; Intend to withdraw this much from bank
        BankWithdrawal SpendingAcc  ;; Update bankside (reduce reserve and deposit)
        set deposits 0  ;; Update deposit depletion
        set RM RM + withdrawal   ;; Update currency accumulation
        let chunks OwnLagDenom
        let amount SpendingAcc ;; new amount planned to be spent
        let delay ownLagDenom
        PlanExpenditure OwnHousehold amount chunks delay
  ]
end


to Expend
  ask households [
    let pending-chunks []
    foreach ExpenditurePlans [
      [x] ->
      set pending-chunks filter [y -> item 1 y <= ticks] ExpenditurePlans ;;go through EP to find list with tick <= current tick
    ]
    foreach pending-chunks[
      [z] ->
      let chunk-size item 0 z  ;;get the amount to be spent in this ExpenditurePlans list
      let target-household one-of other households
      if target-household != nobody [
        send-money chunk-size target-household   ;;send money to this household
        place-order chunk-size target-household  ;;place orders towards the targeted household
      ]
      UpdateTransactions chunk-size
      set RM RM - chunk-size  ;; once money is sent, deducted from own account
      banktransaction chunk-size ;; hard currency returns back to bank, and so does deposit
    ]
    foreach pending-chunks [
      [sub] ->
      set ExpenditurePlans remove sub ExpenditurePlans
    ]
  ]
end

to ProcessOrder
  ask households [
    let pending-order []
    foreach orders [
      [x] ->
      set pending-order filter [y -> item 1 y <= ticks] orders
    ]
    foreach pending-order [
      [z] ->
      let EconActivity item 0 z
      UpdateGDP EconActivity

      ]
    foreach pending-order [
      [sub] ->
      set orders remove sub orders
    ]
  ]
end


to UpdateGDP [amount]
  set output output + amount
  set New-Output amount
end

to UpdateTransactions [amount]
  set transactions transactions + amount
  set New-Transactions amount
end


to send-money [amount target]
  ask target [
    set deposits deposits + amount
    set color blue
  ]
end

to banktransaction [amount]
  ask banks [
    set reserves reserves + amount
    set deposits deposits + amount
  ]
end

to place-order [amount target]
  ask target [
    let current-tick ticks
    let scheduled-tick current-tick + Gestation
    let NewOrder (list amount scheduled-tick)
    set orders fput NewOrder orders
  ]
end

to PlanExpenditure [current-household amount chunks delay]   ;;; determine your expenditure chunks
  let ExpendChunk amount / chunks   ;; calculate the size of chunks
  let current-tick ticks
  let ExpendDelay 1
  ask household current-household [
    repeat chunks [
      let scheduled-tick current-tick + ExpendDelay
      let new-chunk (list ExpendChunk scheduled-tick)
      set ExpenditurePlans fput new-chunk ExpenditurePlans
      if ExpendDelay != Delay [
        set ExpendDelay ExpendDelay + 1
      ]
      if ExpendDelay > Delay [
        print "error!"
      ]
    ]
  ]
end

to FDPlacement [placement]   ;; Cement savings decision
  ask banks [
    set deposits deposits + placement
    set reserves reserves + placement
  ]
end

to BankWithdrawal [withdrawal]  ;; Update bankside
  ask banks [
    set reserves reserves - withdrawal
    set deposits deposits - withdrawal
  ]
end

to UpdateNetworth  ;;Update bank networth
  ask banks [
    set assets Total-Loans-Outstanding + reserves
    set liabilities deposits
    set networth assets - liabilities
    set deposit-to-asset liabilities / assets
    set loans-to-reserve Total-Loans-Outstanding / (reserves + 0.001)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
1106
10
1359
264
-1
-1
7.424242424242424
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
31
10
94
43
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
93
10
156
43
NIL
Step\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
153
10
216
43
NIL
Step
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
277
42
449
75
loan-creation
loan-creation
0
5000
750.0
50
1
NIL
HORIZONTAL

SLIDER
276
76
448
109
No.Households
No.Households
2
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
276
106
448
139
ConsumptionPropensity
ConsumptionPropensity
0
1
0.85
0.05
1
NIL
HORIZONTAL

PLOT
855
276
1252
596
cumulative output and transaction
ticks
GDP
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"GDP" 1.0 0 -2674135 true "" "plot output"
"Transactions " 1.0 0 -13840069 true "" "plot transactions"

SLIDER
276
140
448
173
LagDenom
LagDenom
1
10
2.0
1
1
NIL
HORIZONTAL

SLIDER
275
168
447
201
LagOutput
LagOutput
0
5
1.0
1
1
NIL
HORIZONTAL

PLOT
463
115
655
281
Bank Reserves
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [reserves] of banks"

PLOT
462
278
856
595
Investment and Household Savings 
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Savings" 1.0 0 -16777216 true "" "plot sum [FixedDeposits] of households"
"Currency held" 1.0 0 -14835848 true "" "plot sum [RM] of households"
"Investment" 1.0 0 -13345367 true "" "plot sum [Total-Loans-Outstanding] of banks"

PLOT
655
113
857
278
Bank deposits
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [deposits] of banks "

PLOT
0
264
463
594
New Output and Transactions
NIL
NIL
0.0
10.0
0.0
50.0
true
true
"" ""
PENS
"Output (new)" 1.0 0 -2674135 true "" "plot New-Output"

MONITOR
879
90
961
135
NIL
New-Output
0
1
11

SLIDER
277
10
449
43
Initial-Reserves
Initial-Reserves
0
50000
25000.0
1000
1
NIL
HORIZONTAL

MONITOR
133
128
248
173
Bank Networth
sum [networth] of banks
0
1
11

MONITOR
11
128
134
173
LoansOutstanding
sum [Total-Loans-Outstanding] of banks
0
1
11

MONITOR
878
45
1000
90
FD
sum [FixedDeposits] of households
0
1
11

MONITOR
133
172
248
217
Bank deposits
sum [deposits] of banks
0
1
11

MONITOR
130
217
238
262
deposits to total assets
sum [deposit-to-asset] of banks
1
1
11

PLOT
1252
273
1488
423
deposit to assets of banks
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [deposit-to-asset ] of banks"

SLIDER
463
40
635
73
liability-to-asset-ratio
liability-to-asset-ratio
0
1
0.8
0.05
1
NIL
HORIZONTAL

PLOT
1251
421
1489
593
Loans to reserve ratio
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [loans-to-reserve] of banks"

MONITOR
13
172
134
217
Bank reserves
sum [reserves] of banks
0
1
11

MONITOR
21
219
127
264
Loan to Reserves
sum [loans-to-reserve] of banks
1
1
11

MONITOR
12
81
126
126
Bank Assets
sum [assets] of banks
1
1
11

SLIDER
463
71
635
104
endowment
endowment
0
500
0.0
50
1
NIL
HORIZONTAL

SLIDER
671
63
843
96
MinimumSpending
MinimumSpending
0
500
0.0
50
1
NIL
HORIZONTAL

MONITOR
878
142
936
187
Residual
sum [FixedDeposits] of households + sum [RM] of households -  sum [Total-Loans-Outstanding] of banks
1
1
11

SWITCH
277
208
396
241
CreateLoan?
CreateLoan?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

This simulation represents a monetary economy based on the monetary circuit framework. While it simplifies the involvement of key players like central banks, governments, and distinguishes less between households and firms, the model effectively illustrates how money circulates within an economy. It focuses on the interactions between economic agents, combining households and firms into one entity, to observe the impact of credit creation on money supply, investments, savings, and bank balance sheets.

## HOW IT WORKS

1. Money is assumed to be created during credit creation, influenced by a simplified bank lending rule based on deposits to total assets (reserves + loans). Loans are provided to households.

2. Households receive loans to produce investment goods, spending them through transactions with other households. The model treats consumption and capital goods spending similarly, recognizing that the distinction depends on the mindset of capitalists.

3. Households, upon receiving income, check if it covers their minimum spending rule (assuming households can be immortal). If it does, they save some income as deposits in banks and withdraw the rest in hard currency (bank reserves). The savings rate is determined by the marginal propensity to consume. If income doesn't cover the minimum spending, the savings rate is set to 0, and savings are withdrawn from the bank to cover the deficit.


## HOW TO USE IT

liability-to-deposit-ratio influences the amount of loans and deposits created by banks.

CreateLoans? determines whether banks lend according to the bank lending rule.

endowment determines the starting deposits household has.

ConsumptionPropensity determines how much is used for savings given a unit of new income.

MinimumSpending determines how much households need to spend in a single tick.



## THINGS TO NOTICE

In a closed economy, investments equal savings in economics. Observe household savings and loan creation levels to understand their interaction within the monetary circuit framework. If MinimumSpending is 0, loans created eventually equal new deposits after all savings are done.

Note: if minimum spending is above 0, savings actually is smaller than investment, but this is due to how the code works as the residual is made up for in currency held by households. In theory, investment should still equal savings, but the sequence of the model doesn't really allow for that - yet.

## THINGS TO TRY

Try turning on CreateLoans in the middle of the model running (let MinimumSpending > 0). This simulates a lending boom of sorts and GDP shoots up and eventually comes down.


## EXTENDING THE MODEL

I'll extend the model by adding in new agentsets - governments, central banks and firms.

Furthermore, new features such as interest and principal payment on loans would be the next obvious step. It's exclusion is due to the fact that outstandingloans rarely every go down in any significant strech of time for most economies (through paying the loans off). 

Also, the agents in this model faces no restriction in output production and places a fixed price for its work (1 unit of money = 1 unit of output). This is clearly unrealistic and ignores supply constraints and inflationary effects. Future model can improve on this.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
