patches-own 
[
 PhiRed_t-1 PhiRed_t
 PhiGreen_t-1 PhiGreen_t
 PhiBlue_t-1 PhiBlue_t
 M0 M1 M2 h
 c2-red ; |c-red|^2 corresponds to the expected number of red quanta in the register
 c2-green ; |c-green|^2 corresponds to the expected number of green quanta in the register
 c2-blue ; |c-blue|^2 corresponds to the expected number of blue quanta in the register
 indicator
]

globals [ m-red m-green m-blue ]


to setup
  ca
  ask patches 
  [
    set PhiRed_t random-float 1.000
    set PhiGreen_t random-float 1.000
    set PhiBlue_t random-float 1.000
  ]
  ask one-of patches [ set indicator 1 ]
end


to go
  no-display
  tick
  ask patches [ previous-state-phase ]
  ask patches [ n-map ]
  ask patches [ update-quantum-phases ]
  ask patches [ set-color ]
  set m-red mean[c2-red] of patches
  set m-green mean [c2-green] of patches
  set m-blue mean [c2-blue] of patches
  if ticks >= no-plot-transient [ do-plot ]
  display
end


to previous-state-phase
  set PhiRed_t-1 PhiRed_t
  set PhiGreen_t-1 PhiGreen_t
  set PhiBlue_t-1 PhiBlue_t
end


to n-map
  set M0 PhiRed_t-1 * b * (1 - PhiRed_t-1)
  set M1 PhiGreen_t-1 * b * (1 - PhiGreen_t-1)
  set M2 PhiBlue_t-1 * b * (1 - PhiBlue_t-1)
  set h ( M0 + M1 + M2 ) / 3
end


to update-quantum-phases
  
  set PhiRed_t (1 - epsilon - delta) * M0 + epsilon * mean [ M0 ] of patches in-radius r + delta * mean [ h ] of patches in-radius r
  set PhiGreen_t (1 - epsilon - delta) * M1 + epsilon * mean [ M1 ] of patches in-radius r + delta * mean [ h ] of patches in-radius r
  set PhiBlue_t (1 - epsilon - delta) * M2 + epsilon * mean [ M2 ] of patches in-radius r + delta * mean [ h ] of patches in-radius r
end



to set-color
  set c2-red int (PhiRed_t * 255)
  set c2-green int (PhiGreen_t * 255)
  set c2-blue int (PhiBlue_t * 255)
  set pcolor (list c2-red c2-green c2-blue )
end


to do-plot
  set-current-plot "Mean Red"
  plot m-red
  set-current-plot "Mean Green"
  plot m-green
  set-current-plot "Mean Blue"
  plot m-blue
end
@#$#@#$#@
GRAPHICS-WINDOW
202
10
499
328
20
20
7.0
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks

SLIDER
28
21
120
54
r
r
0
100
6
1
1
NIL
HORIZONTAL

SLIDER
31
70
123
103
b
b
0
4
4
0.01
1
NIL
HORIZONTAL

SLIDER
32
127
124
160
epsilon
epsilon
0
1
0.2
0.01
1
NIL
HORIZONTAL

BUTTON
35
264
98
297
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
117
263
180
296
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
30
212
163
245
no-plot-transient
no-plot-transient
0
100
100
1
1
NIL
HORIZONTAL

PLOT
540
10
852
160
Mean Red
NIL
NIL
0.0
10.0
160.0
170.0
true
false
PENS
"default" 1.0 2 -2674135 true

PLOT
540
173
857
323
Mean Green
NIL
NIL
0.0
10.0
160.0
170.0
true
false
PENS
"default" 1.0 2 -10899396 true

PLOT
545
350
848
500
Mean Blue
NIL
NIL
0.0
10.0
160.0
170.0
true
false
PENS
"default" 1.0 2 -13345367 true

SLIDER
30
170
122
203
delta
delta
0
1
0.2
0.01
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This is a model of quantum dissipative structures' emergence in a quantum chaotic medium. The model is part of the quantum complex systems science and risk mathematics research project, under development by the author at ISCSP - Technical University of Lisbon.

The model combines quantum statistical mechanics and chaos theory, and it leads to the emergence of a fluctuating complex millieu. After a few steps of the simulation, there emerge organized structures akin to unicellular organisms that have a pulsating body (pulsating either in dark grey and light grey RGB scheme (see the description below for the details), a colored nucleous, and a border (usually pulsating inversely to the body in the RGB scheme), these structures survive for a while feeding upon the environment and assimilating other organisms whenever their borders touch.

Complex quantum structures' individuation takes place in this model with a struggle for growth territory, for survival against dissolution and against assimilation from other structures.

This life-like quantum game emergence is not preprogrammed in the model, we did not pre-program the large cellular structures, they just happen to emerge.

The model has been used both for research in risk science as well as an example used in the author's MsC Classes on Decision Making Techniques, for a basic understanding of the problem of risk in complex systems science.

The model implements an example of a computational structure resulting from the article: 

- Gon_ves (2012) "Quantum Chaos and Quantum Computing Structures" arXiv:1208.2610v1 [nlin.CD], http://arxiv.org/abs/1208.2610


Each patch contains a three-entry quantum register machine, each entry is assigned a color, and each entry is in a coherent state. The quantum computation implements a local unitary transition at each patch from coherent state to coherent state (by the general scheme explained in arXiv:1208.2610v1 [nlin.CD])) according to a nonlinear map rule. 

The coherent state sequence is such that each coherent state leads to an occupation number quantum average that coincides with a definite energy eigenstate (even though the quantum state is NOT in a definite energy state, but in a superposition of energy eigenstates as per the coherent state notion).

Each patch is colored in accordance with an RGB scheme represenation of its mean quantum energy.




THE MODEL (FORMAL EXPLANATION):
-------------------------------


Each patch contains a bosonic quantum register machine, with three entries corresponding to three colors Red, Green and Blue, in a coherent state for each color:

| |psi(j,t)> = |CRed(j,t),CGreen(j,t),CBlue(j,t)>

At each round, a local quantum logical gate of the product coherent state category Coh^3 (see the article for details) is implemented such that a coherent state transition takes place:

| psi(j,t-1)> -> |psi(j,t)>

The relation between the coherent states is such that:

| |CRed(j,t),CGreen(j,t),CBlue(j,t)> = |F(CRed(j,t-1)),F(CGreen(j,t-1)), F(CBlue(j,t-1))>


Where F is a complex-valued nonlinear map that transforms the phase of each coherent state (in the polar coordinate representation of a complex number) as follows:

| PhiRed(j,t) = (1 - epsilon - delta) * Mred(j,t-1) + epsilon * mean-field(PhiRed) + mean-field(h)

| PhiGreen(j,t) = (1 - epsilon - delta) * Mred(j,t-1) + epsilon * mean-field(PhiRed) + mean-field(h)

| PhiBlue(j,t) = (1 - epsilon - delta) * Mred(j,t-1) + epsilon * mean-field(PhiRed) + mean-field(h)

With the updates:

| Mred(j,t) = b * PhiRed(j,t-1) * (1 - PhiRed(j,t-1))

| Mgreen(j,t) = b * PhiGreen(j,t-1) * (1 - PhiGreen(j,t-1))

| Mblue(j,t) = b * PhiBlue(j,t-1) * (1 - PhiBlue(j,t-1))

| h(j,t) = [Mred(j,t) + Mgreen(j,t) + Mblue(j,t)] / 3

and where the mean-field(PhiColor) is the mean of the coherent state phases of the patches in radius r of the j'th patch for the corresponding "Color", the same holding for mean-field(h).

In turn, the amplitude of each coherent state for a patch is transformed by the complex-valued nonlinear map as:

| AmplitudeRed(j,t) = sqrt{int(PhiRed(j,t) * 255)}

| AmplitudeGreen(j,t) = sqrt{int(PhiGreen(j,t) * 255)}

| AmplitudeBlue(j,t) = sqrt{int(PhiBlue(j,t) * 255)}


Thus, the expected energy for each register at each patch is given by:

| <HamiltonianRed(j,t)> = (int(PhiRed(j,t) * 255) + 1 / 2) * h-bar * omega

| <HamiltonianBlue(j,t)> = (int(PhiGreen(j,t) * 255) + 1 / 2) * h-bar * omega

| <HamiltonianGreen(j,t)> = (int(PhiBlue(j,t) * 255) + 1 / 2) * h-bar * omega


Each patch is colored in RGB scheme by the occupation numbers, therefore each patch Red, Green Blue color in the model is in proportion to the combination of the expected energy eigenstates for each quantum register.



HOW TO USE IT
-------------
The user can control the logistic map's parameters, as well as the couplings (epsilon and delta) and the radius r for the local mean field coupling.

The slider no-plot-transient allows the user to control a the moment upon which the mean color value for the entire system of patches is plotted.



THINGS TO NOTICE
----------------

One should address the model in terms of the spatial and temporal patterns that emerge, the different behaviors of the model for different couplings, try to look and identify emerging individuated structures and look at how they interact with the environment and with each other.

You can also watch the video below which shows several examples of relevant points to notice in the model.

http://www.youtube.com/watch?v=zc61oy5R9hQ



CREDITS AND REFERENCES
----------------------

- Gon_ves, (2012) "Quantum Chaos and Quantum Computing Structures" arXiv:1208.2610v1 [nlin.CD], http://arxiv.org/abs/1208.2610

- Gon_ves, (2012) "Risk Governance - A Framework for Risk Science-Based Decision Support Systems" http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2085482
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
