breed [pretzels pretzel]
pretzels-own [
  owner-id
]

breed [water-stands water-stand]
water-stands-own [
  id
  thirsties-on-tap
]

breed [toilets toilet]
toilets-own [
  id
  is-occupied?
]

breed [puddles puddle]
breed [corpses corpse]
corpses-own [
  is-dead?
]

breed [people person]
people-own [
  id
  pretzel-count
  thirsties
  hungries
  tinkles
  money
  ticks-hungry
  ticks-thirsty
  ticks-wanting-bathroom
  occupied-toilet-id
  bex-count
  did-buy-pretzel-this-tick?
  is-drinking?
  is-dead?
  specialty-type
]

breed [lasers laser]
lasers-own [
  target-hunted
]

breed [coyotes coyote]
coyotes-own [
  target-id
  exit-dir
]

breed [pick-up-anims pick-up-anim]
pick-up-anims-own [
  ticks-alive
  j-dist
]

breed [from-bag-anims from-bag-anim]
from-bag-anims-own [
  ticks-alive
  j-dist
]

breed [drink-anims drink-anim]
drink-anims-own [
  ticks-alive
  j-dist
]

breed [eat-anims eat-anim]
eat-anims-own [
  ticks-alive
  j-dist
]

breed [money-plus-anims money-plus-anim]
money-plus-anims-own [
  ticks-alive
  j-dist
]

breed [money-minus-anims money-minus-anim]
money-minus-anims-own [
  ticks-alive
  j-dist
]

breed [bex-anims bex-anim]
bex-anims-own [
  ticks-alive
  j-dist
]

breed [tinkle-anims tinkle-anim]
tinkle-anims-own [
  ticks-alive
  j-dist
]

breed [death-anims death-anim]
death-anims-own [
  ticks-alive
  j-dist
]

globals [
    
    is-won?
    
    color-list
    player-count
    specialty-types
    toilet-troll-str
    pretzel-prot-str
    water-waster-str
    coyote-jump-dist
    coyote-laser-range
    laser-velocity
    
    anim-lifespan
    anims-list
    anim-float-rate
    ghost-float-rate
    rocket-float-rate
    anim-placement-above
    dollar-size
    default-anim-size

]

to setup
  clear-all
  initialize
  make-turtles
  reset-ticks
end

to initialize
  
  set is-won? false
  
  set color-list [violet green red orange pink gray blue yellow brown white]
  set player-count 5
  set toilet-troll-str "toilet-troll"
  set pretzel-prot-str "pretzel-protector"
  set water-waster-str "water-waster"
  set specialty-types (list toilet-troll-str pretzel-prot-str water-waster-str)
  set coyote-jump-dist 3
  set coyote-laser-range 12
  set laser-velocity 7
  
  set anim-lifespan 5
  set anims-list (list eat-anims money-plus-anims money-minus-anims drink-anims from-bag-anims pick-up-anims bex-anims tinkle-anims death-anims)
  set anim-float-rate .5
  set ghost-float-rate 1
  set rocket-float-rate 2
  set anim-placement-above 2
  set default-anim-size 2
  
end

to go
  
  handle-anims
  handle-spoilers
  handle-water-level
  
  if ((count people = 1) and not is-won?) [
    print (word (id-to-color-name ([id] of (one-of people))) " has won!")
    set is-won? true
    stop
  ]
  
  amplify-desires
  assess-desires
  
  spawn-new-pretzels
  spawn-new-coyotes
  direct-coyotes
  direct-lasers
  
  act-on-desires
  
  tick
  
end

to handle-anims
  foreach anims-list [
    ask ? [
      set ticks-alive (ticks-alive + 1)
      ifelse ((ticks-alive >= anim-lifespan) or ((max-pycor - ycor) <= j-dist)) [die] [jump j-dist]
    ]
  ]
end

to handle-spoilers
  
  ifelse (spoilers) [
    ask people with [ specialty-type = water-waster-str ] [ ifelse (water-waster) [ set shape "water-waster" ] [ set shape "person" ] ]
    ask people with [ specialty-type = toilet-troll-str ] [ ifelse (toilet-troll) [ set shape "toilet-troll" ] [ set shape "person" ] ]
    ask people with [ specialty-type = pretzel-prot-str ] [ ifelse (pretzel-protector) [ set shape "pretzel-protector" ] [ set shape "person" ] ]
  ]
  [ ask people with [ specialty-type != -1 ] [ set shape "person" ] ]
  
end

to handle-water-level
  ask water-stands [
    replenish-water    
    determine-water-stand-shape
  ]
end


to replenish-water
  let inc water-replenishment-rate
  let thirsties-until-full (water-level-max - thirsties-on-tap)
  if (water-replenishment-rate > thirsties-until-full) [ set inc thirsties-until-full ]
  set thirsties-on-tap (thirsties-on-tap + inc)
end

; For use by water-stands only
to determine-water-stand-shape
  let percentage ((thirsties-on-tap / water-level-max) * 100)
  ifelse (percentage < 25) [ set shape "water0" ] [
    ifelse (percentage < 50) [ set shape "water25" ] [
      ifelse (percentage < 75) [ set shape "water50" ] [
        ifelse (percentage < 100) [ set shape "water75" ] [ set shape "water100" ]
      ]
    ] 
  ]
end

to spawn-new-pretzels
  let x (random (max-new-pretzels-per-tick - min-new-pretzels-per-tick))
  let new-pretzel-count (x + min-new-pretzels-per-tick)
  create-pretzels new-pretzel-count [initialize-pretzel]
end

to spawn-new-coyotes
  
  if (bladder-explosion-threshold > 0) [
    ask people with [ (bex-count >= bladder-explosion-threshold) and (not any? coyotes with [[id] of myself = target-id]) ] [
      
      hatch-coyotes 1 [
        
        let x -1
        let y -1
        let exit-on "null"
        let vertical (random 3)
        
        ifelse (vertical = 0) [ ; Baseline
          set x ((random (max-pxcor + (abs min-pxcor))) - (abs min-pxcor))
          set y min-pycor
          set exit-on "top"
        ]
        [
          ifelse (vertical = 1) [ ; Topline
            set x ((random (max-pxcor + (abs min-pxcor))) - (abs min-pxcor))
            set y max-pycor
            set exit-on "bottom"
          ]
          [
            let horizon (random 2)
            ifelse (horizon = 1) [
              set x max-pycor
              set y ((random (max-pycor + (abs min-pycor))) - (abs min-pycor))
              set exit-on "left"
            ]
            [
              set x min-pycor
              set y ((random (max-pycor + (abs min-pycor))) - (abs min-pycor))
              set exit-on "right"
            ]
          ]
        ]

        set target-id ([id] of myself)
        set exit-dir exit-on
        set size 4
        setxy x y
        face myself
        
      ]
        
    ]
  ]
    
end

to direct-coyotes
  ask coyotes [
    let hunteds (people with [id = [target-id] of myself])
    ifelse (any? hunteds) [
      let hunted (one-of hunteds)
      move-towards hunted
      if ((distance hunted) <= coyote-laser-range) [
        hatch-lasers 1 [
          face hunted
          set size 2.5
          set target-hunted hunted
        ]
      ]
    ]
    [
      let should-die false
      ifelse (exit-dir = "right") [
        set heading 90
        set should-die (coyote-jump-dist >= (max-pxcor - xcor))
      ]
      [
        ifelse (exit-dir = "left") [
          set heading 270
          set should-die (coyote-jump-dist >= (abs (xcor - min-pxcor)))
        ]
        [
          ifelse (exit-dir = "top") [
            set heading 0
            set should-die (coyote-jump-dist >= (max-pycor - ycor))
          ]
          [
            if (exit-dir = "bottom") [
              set heading 180
              set should-die (coyote-jump-dist >= (abs (ycor - min-pycor)))
            ]
          ]
        ]
      ]
      if (should-die) [die]
      jump coyote-jump-dist
    ]
  ]
end

to direct-lasers
  
  ask lasers [
    
    if ([is-dead?] of target-hunted) [die]
    
    let base-looks 3
    let looks base-looks
    
    while [(looks > 0) and (target-hunted != nobody)] [
      jump (laser-velocity / base-looks)
      if ((distance target-hunted) < 2) [
        ask target-hunted [
          print (word (id-to-color-name id) " died of LASERED!")
          hatch-death-anims 1 [ initialize-ghost myself ]
          set breed corpses
          set is-dead? true
        ]
        die
      ]
      set looks (looks - 1)
    ]    
  ]
  
end

to place-bladder-explosion
  hatch-puddles 1 [
    set color yellow
    set ycor (ycor - 1.5)
  ]
end

to-report id-to-color-name [thing-id]
  let color-num (item (thing-id - 1) color-list)
  if color-num = 9.9 [ report "white" ]
  report item (color-num mod 10) base-colors
end

to amplify-desires
  ask people [
    set thirsties (thirsties + thirst-rate)
    set hungries (hungries + hunger-rate)
  ]
end

to assess-desires
  ask people [
    
    if (hungries >= hunger-activation-threshold) [ set ticks-hungry (ticks-hungry + 1) ]
    if (thirsties >= thirst-activation-threshold) [ set ticks-thirsty (ticks-thirsty + 1) ]
    if (tinkles >= tinkle-activation-threshold) [ set ticks-wanting-bathroom (ticks-wanting-bathroom + 1) ]
    
    if (ticks-hungry >= ticks-hungry-before-death) [
      print (word (id-to-color-name id) " died of hunger")
      hatch-death-anims 1 [ initialize-ghost myself ]
      set breed corpses
      set is-dead? true
      stop
    ]
    
    if (ticks-thirsty >= ticks-thirsty-before-death) [
      print (word (id-to-color-name id) " died of thirst")
      hatch-death-anims 1 [ initialize-ghost myself ]
      set breed corpses
      set is-dead? true
      stop
    ]
    
    if (ticks-wanting-bathroom >= ticks-before-bladder-explosion) [
      place-bladder-explosion
      set bex-count (bex-count + 1)
      hatch-bex-anims 1 [ initialize-anim myself ]
      set money (money - fine-for-bladder-explosion)
      set ticks-wanting-bathroom 0
      set tinkles 0
    ]
    
  ]
end

to act-on-desires
  ask people [
    ifelse (is-drinking?) [ do-thirst ]
    [
      ifelse (did-buy-pretzel-this-tick?) [ set did-buy-pretzel-this-tick? false ]
      [
        ifelse (occupied-toilet-id != -1) [do-use-toilet]
        [
          ifelse (hungries >= hunger-activation-threshold) [
            ifelse (thirsties >= thirst-activation-threshold) [
              ; If closer to dying of hunger than of thirst
              ifelse ((ticks-hungry-before-death - ticks-hungry) < (ticks-thirsty-before-death - ticks-thirsty)) [do-hunger] [do-thirst]
            ]
            [do-hunger]
          ]
          [
            ifelse (thirsties >= thirst-activation-threshold) [do-thirst]
            [
              ifelse ((tinkles >= tinkle-activation-threshold) and not is-water-wasting?) [do-find-toilet]
              [
                ifelse (is-toilet-trolling?) [do-find-toilet]
                [
                  ifelse (is-water-wasting?) [do-thirst]
                  [
                    ifelse (is-pretzel-protecting?) [do-scavenge-pretzels]
                    [
                      let pretzel-needer (find-nearest-pretzel-needer-with-money pretzel-selling-price)
                      ifelse ((pretzel-count > 0) and (pretzel-needer != nobody) and (is-reachable? pretzel-needer)) [ do-sell-pretzel pretzel-needer ] [do-scavenge-pretzels]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ]
end

; For use by people only
to-report find-nearest [targets]
  report min-one-of targets [distance myself]
end

to-report find-nearest-pretzel-needer-with-money [price]
  let needers (people with [(pretzel-count < 1) and (money >= price) and (myself != self)])
  ifelse (any? needers) [ report find-nearest needers ] [ report nobody ]
end

; For use by people only
to-report is-reachable? [target]
  let dist ([distance target] of self)
  report (dist <= distance-travelable-per-tick)
end

; For use by people only
to move-towards [target]
  move-towards-dist target distance-travelable-per-tick
end

; For use by people only
to move-towards-dist [target dist]
  face target
  jump dist
end

; For use by people only
to move-randomly
  set heading (random 360)
  jump distance-travelable-per-tick
end

; For use by people only
to move-next-to [target]
  let dist-minus 2
  let dist-to-target distance target
  let moving-dist (dist-to-target - dist-minus)
  if (0 > moving-dist) [move-towards-dist target moving-dist]
end

; For use by people only
to-report already-next-to? [target]
  report distance target <= 2
end

; For use by people only
to consume-pretzel
  
  let bottomed-hungries 0
  let unbottomed-hungries (hungries - pretzel-hunger-reduction)
  if (unbottomed-hungries > 0) [ set bottomed-hungries unbottomed-hungries ]
  
  set pretzel-count (pretzel-count - 1)
  set hungries bottomed-hungries
  set thirsties (thirsties + thirst-incurred-by-pretzels)
  if (hungries < hunger-activation-threshold) [ set ticks-hungry 0 ]

end

; For use by people only
to consume-water [nearest-water]
  
  let topped-on-tap water-thirst-reduction
  if (([thirsties-on-tap] of nearest-water) < water-thirst-reduction) [ set topped-on-tap ([thirsties-on-tap] of nearest-water)]
  show [thirsties-on-tap] of nearest-water
  
  let bottomed-thirsties 0
  let unbottomed-thirsties (thirsties - topped-on-tap)
  if (unbottomed-thirsties > 0) [ set bottomed-thirsties unbottomed-thirsties ]
  let water-taken (topped-on-tap - bottomed-thirsties)
  if (water-taken < 0) [ set water-taken 0 ]
  
  ask nearest-water [ set thirsties-on-tap (thirsties-on-tap - water-taken) ]
  set thirsties bottomed-thirsties
  set tinkles (tinkles + tinkles-incurred-by-water)
  
  hatch-drink-anims 1 [ initialize-anim myself ]
  
  if (thirsties < thirst-activation-threshold) [ set ticks-thirsty 0 ]
  
end

; For use by people only
to do-use-toilet
  
  set tinkles (tinkles - tinkles-lost-per-tick-in-bathroom)
  hatch-tinkle-anims 1 [ initialize-rocket myself ]
  
  if (tinkles <= 0) [
    set tinkles 0
    ask toilets with [ id = [occupied-toilet-id] of myself ] [ set is-occupied? false ]
    set occupied-toilet-id -1
  ]
  
end

; For use by people only
to do-hunger
  ifelse (pretzel-count > 0) [
    consume-pretzel
    hatch-from-bag-anims 1 [ initialize-anim myself ]
  ]
  [
    let nearest-pretzel (find-nearest pretzels)
    ifelse (nearest-pretzel != nobody) [
      ifelse (is-reachable? nearest-pretzel) [
        move-to nearest-pretzel
        ask nearest-pretzel [die]
        set pretzel-count (pretzel-count + 1)
        consume-pretzel
        hatch-eat-anims 1 [ initialize-anim myself ]
      ]
      [move-towards nearest-pretzel]
    ]
    [do-find-pretzel-seller]
  ]
end

; For use by people only
; Does not accomodate for setups without water
to do-thirst
  let nearest-water (find-nearest water-stands)
  ifelse (is-reachable? nearest-water) [
    if (not already-next-to? nearest-water) [ move-next-to nearest-water ]
    consume-water nearest-water
    if (thirsties = 0) [ set is-drinking? false ]
  ]
  [ move-towards nearest-water ]
end

; For use by people only
to do-find-toilet
  let nearest-toilet (find-nearest toilets)
  ifelse (is-reachable? nearest-toilet) [
    ifelse (not ([is-occupied?] of nearest-toilet)) [ do-occupy-toilet nearest-toilet ] [ move-next-to nearest-toilet ]
  ]
  [ move-towards nearest-toilet ]
end

; For use by people only
to do-sell-pretzel [buyer]
  
  print (word (id-to-color-name id) " sold a pretzel to " (id-to-color-name ([id] of buyer)))
  move-next-to buyer
  set pretzel-count (pretzel-count - 1)
  set money (money + pretzel-selling-price)
  hatch-money-plus-anims 1 [ initialize-anim myself ]
  
  ask buyer [
    set pretzel-count (pretzel-count + 1)
    consume-pretzel
    hatch-money-minus-anims 1 [ initialize-anim myself ]
    set money (money - pretzel-selling-price)
  ]
  
end

; For use by people only
to do-scavenge-pretzels
  let nearest-pretzel (find-nearest pretzels)
  ifelse (nearest-pretzel != nobody) [
    ifelse (is-reachable? nearest-pretzel) [
      move-to nearest-pretzel
      set pretzel-count (pretzel-count + 1)
      ask nearest-pretzel [die]
      hatch-pick-up-anims 1 [ initialize-anim myself ]
    ]
    [ move-towards nearest-pretzel ]
  ]
  [move-randomly]
end

; For use by people only
to do-occupy-toilet [toilet]
  move-to toilet
  setxy (xcor - 0.4) (ycor + 0.6)
  set occupied-toilet-id ([id] of toilet)

  ask toilet [ set is-occupied? true ]
  do-use-toilet
  
end

; For use by people only
to do-find-pretzel-seller
  let nearest-seller (min-one-of people with [pretzel-count > 0] [distance self])
  ifelse (nearest-seller != nobody) [
    ifelse (is-reachable? nearest-seller) [ move-next-to nearest-seller ] [ move-towards nearest-seller ]
  ]
  [ move-randomly ]
end
  
; For use by people only
to-report is-toilet-trolling?
  report ((specialty-type = toilet-troll-str) and toilet-troll)
end

; For use by people only
to-report is-pretzel-protecting?
  report ((specialty-type = pretzel-prot-str) and pretzel-protector)
end

; For use by people only
to-report is-water-wasting?
  report ((specialty-type = water-waster-str) and water-waster)
end
  
; Setup stuff
to make-turtles

  let color-tuple-list (zip-with-index (take color-list player-count))
  let toilet-count 1
  let water-stand-count 1
  let invalid-id -1
  
  set-default-shape people "person"
  set-default-shape pretzels "pretzel"
  set-default-shape toilets "toilet"
  set-default-shape water-stands "drop"
  set-default-shape puddles "drop"
  set-default-shape corpses "flower"
  set-default-shape coyotes "coyote"
  set-default-shape lasers "lazor"
  
  set-default-shape eat-anims "pacman"
  set-default-shape money-plus-anims "green-dollar"
  set-default-shape money-minus-anims "red-dollar"
  set-default-shape drink-anims "bottle"
  set-default-shape from-bag-anims "opened-gift"
  set-default-shape pick-up-anims "gift"
  set-default-shape bex-anims "red-dollar"
  set-default-shape tinkle-anims "red-rocket"
  set-default-shape death-anims "ghost"

  create-pretzels (3 * player-count) [
    initialize-pretzel
  ]
  
  create-toilets 1 [
    set size 5
    set heading 90
    set id -1
    set is-occupied? false
    jump 14
  ]
  
  while [toilet-count > 0] [
    ask one-of toilets with [ id = -1 ] [ set id toilet-count ]
    set toilet-count (toilet-count - 1)
  ]
  
  create-water-stands 1 [
    set color blue
    set size 4
    set heading 270
    set thirsties-on-tap starting-water-level
    set id -1
    jump 14
    determine-water-stand-shape
  ]
  
  while [water-stand-count > 0] [
    ask one-of water-stands with [ id = -1 ] [ set id water-stand-count ]
    set water-stand-count (water-stand-count - 1)
  ]
  
  create-ordered-people player-count [
    jump 1.75
    set size 2.5
    set id invalid-id
    set pretzel-count starting-pretzels
    set thirsties ((random thirst-activation-threshold) + base-thirst)
    set hungries ((random hunger-activation-threshold) + base-hunger)
    set tinkles 0
    set money starting-money
    set ticks-hungry 0
    set ticks-thirsty 0
    set ticks-wanting-bathroom 0
    set occupied-toilet-id -1
    set bex-count 0
    set did-buy-pretzel-this-tick? false
    set is-drinking? false
    set is-dead? false
    set specialty-type -1
  ]
  
  handle-specialty-types
  
  while [not (empty? color-tuple-list)] [
    let head (first color-tuple-list)
    let tail (but-first color-tuple-list)
    ask one-of people with [ id = invalid-id ] [
      set id ((first head) + 1)
      set color (first (but-first head))
    ]
    set color-tuple-list tail
  ]
  
end

; For use by pretzels only
to initialize-pretzel
  set size 1.5
  let angle (random 360)
  let dist (((random 1100) / 100) + 6)
  set heading angle
  set owner-id -1
  jump dist
end

to handle-specialty-types
  
  let max-iters (length specialty-types)
  if (player-count < max-iters) [ set max-iters player-count ]
  
  let types (shuffle specialty-types)
  handle-specialty-types-helper types 0 max-iters
  
end

to handle-specialty-types-helper [types iters max-iters]
  if (iters < max-iters) [
    ask one-of people with [specialty-type = -1] [ set specialty-type (first types)]
    handle-specialty-types-helper (but-first types) (iters + 1) max-iters
  ]
end

; For use by anims only
to initialize-anim [creator]
  initialize-anim-base creator anim-float-rate
end

to initialize-rocket [creator]
  initialize-anim-base creator rocket-float-rate
end

to initialize-ghost [creator]
  initialize-anim-base creator ghost-float-rate
end

to initialize-anim-base [creator jump-dist]
  set j-dist jump-dist
  set ticks-alive 0
  set heading 0
  set size default-anim-size
  move-to creator
  let new-ycor (ycor + anim-placement-above)
  if (new-ycor < max-pycor) [ set ycor new-ycor ] 
end

to-report zip-with-index [xs]
  let indexes (n-values (length xs) [?])
  report zip indexes xs
end

to-report zip [xs ys]
  report (map [list ?1 ?2] xs ys)
end

to-report take [xs num]
  report take-helper xs num []
end

to-report take-helper [xs num acc]
  if-else num <= 0 or (empty? xs) [
    report reverse acc
  ] [
    report take-helper (but-first xs) (num - 1) (fput (first xs) acc)
  ]
end

; +-------------------------+
; |      Plotting code      |
; +-------------------------+
to plot-people-base [x plot-type is-border?]
  
  let my-turtle (one-of people with [id = (x + 1)])
  let tx (get-true-x x)
  
  ifelse (my-turtle = nobody) [ plotxy tx 0 ] [
    ifelse (is-border?) [ plot-switchboard tx plot-type my-turtle ] [
      let i tx
      repeat (get-true-repeats x) [
        plot-switchboard i plot-type my-turtle
        set i (i + .01)
      ]
    ]
  ]
  
end

to plot-switchboard [x plot-type my-turtle]
  let y (run-switchboard plot-type my-turtle)
  plotxy x y
end

to-report run-switchboard [plot-type my-turtle]
  report [runresult plot-type] of my-turtle
end

to plot-threshold [threshold]
  plotxy 0 threshold
end

to-report get-true-x [x]
  ifelse (x = 0) [report 0.02] [report x]
end

to-report get-true-repeats [x]
  ifelse x = 0 or x = player-count - 1 [report 97] [report 99]
end
@#$#@#$#@
GRAPHICS-WINDOW
339
10
906
598
16
16
16.9
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
3.0

BUTTON
339
598
533
690
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
532
598
716
690
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
716
631
906
690
Go n Times
repeat n [ go ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
716
598
906
631
n
n
1
100
1
1
1
times
HORIZONTAL

SLIDER
25
216
308
249
max-new-pretzels-per-tick
max-new-pretzels-per-tick
min-new-pretzels-per-tick
10
2
1
1
pretzels
HORIZONTAL

SLIDER
25
151
308
184
pretzel-selling-price
pretzel-selling-price
1
50
20
1
1
dollars
HORIZONTAL

SLIDER
25
10
308
43
hunger-rate
hunger-rate
0
15
2
0.5
1
hungries
HORIZONTAL

SLIDER
25
76
308
109
pretzel-hunger-reduction
pretzel-hunger-reduction
0
100
70
1
1
hungries
HORIZONTAL

SLIDER
25
588
308
621
ticks-hungry-before-death
ticks-hungry-before-death
1
100
30
1
1
ticks
HORIZONTAL

SLIDER
25
43
308
76
hunger-activation-threshold
hunger-activation-threshold
1
100
60
1
1
hungries
HORIZONTAL

SLIDER
25
293
308
326
thirst-activation-threshold
thirst-activation-threshold
1
100
80
1
1
thirsties
HORIZONTAL

SLIDER
25
654
308
687
distance-travelable-per-tick
distance-travelable-per-tick
.1
5
1.5
.1
1
pcords
HORIZONTAL

SLIDER
25
326
308
359
water-thirst-reduction
water-thirst-reduction
0
100
70
1
1
thirsties
HORIZONTAL

SLIDER
25
108
308
141
thirst-incurred-by-pretzels
thirst-incurred-by-pretzels
0
50
10
1
1
thirsties
HORIZONTAL

SLIDER
25
260
308
293
thirst-rate
thirst-rate
0
15
2
.5
1
thirsties
HORIZONTAL

SLIDER
24
436
308
469
tinkles-lost-per-tick-in-bathroom
tinkles-lost-per-tick-in-bathroom
0
100
10
1
1
tinkles
HORIZONTAL

SLIDER
25
621
308
654
ticks-before-bladder-explosion
ticks-before-bladder-explosion
1
100
40
1
1
ticks
HORIZONTAL

SLIDER
25
479
308
512
fine-for-bladder-explosion
fine-for-bladder-explosion
0
100
10
1
1
dollars
HORIZONTAL

SLIDER
926
79
1117
112
starting-money
starting-money
0
100
40
1
1
dollars
HORIZONTAL

SLIDER
926
112
1117
145
starting-pretzels
starting-pretzels
0
20
0
1
1
pretzels
HORIZONTAL

SLIDER
926
44
1117
77
base-hunger
base-hunger
0
100
100
1
1
hungries
HORIZONTAL

SLIDER
926
10
1117
43
base-thirst
base-thirst
0
100
10
1
1
thirsties
HORIZONTAL

SLIDER
25
555
308
588
ticks-thirsty-before-death
ticks-thirsty-before-death
1
100
30
1
1
ticks
HORIZONTAL

SLIDER
25
358
308
391
tinkles-incurred-by-water
tinkles-incurred-by-water
0
100
10
1
1
tinkles
HORIZONTAL

SLIDER
24
403
308
436
tinkle-activation-threshold
tinkle-activation-threshold
1
100
30
1
1
tinkles
HORIZONTAL

SLIDER
25
183
308
216
min-new-pretzels-per-tick
min-new-pretzels-per-tick
0
10
0
1
1
pretzels
HORIZONTAL

SWITCH
1131
12
1322
45
toilet-troll
toilet-troll
1
1
-1000

SWITCH
1131
45
1322
78
pretzel-protector
pretzel-protector
1
1
-1000

SWITCH
1131
78
1322
111
water-waster
water-waster
1
1
-1000

SWITCH
1131
111
1322
144
spoilers
spoilers
0
1
-1000

PLOT
926
168
1117
288
Hunger
NIL
NIL
0.0
5.0
0.0
100.0
true
false
"" "clear-plot"
PENS
"pen-1" 0.01 1 -8630108 true "" "plot-people-base 0 \"hungries\" false"
"pen-2" 0.01 1 -13840069 true "" "plot-people-base 1 \"hungries\" false"
"pen-3" 0.01 1 -2674135 true "" "plot-people-base 2 \"hungries\" false"
"pen-4" 0.01 1 -955883 true "" "plot-people-base 3 \"hungries\" false"
"pen-5" 0.01 1 -2064490 true "" "plot-people-base 4 \"hungries\" false"
"b-1" 0.98 1 -16777216 true "" "plot-people-base 0 \"hungries\" true"
"threshold" 5.0 1 -1184463 true "clear-plot" "plotxy 0 hunger-activation-threshold"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 1 \"hungries\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 2 \"hungries\" true"
"pen-9" 1.0 1 -16777216 true "" "plot-people-base 3 \"hungries\" true"
"pen-10" 0.98 1 -16777216 true "" "plot-people-base 4 \"hungries\" true"

PLOT
1131
168
1322
288
Thirst
NIL
NIL
0.0
5.0
0.0
100.0
true
false
"" "clear-plot"
PENS
"pen-0" 0.01 1 -8630108 true "" "plot-people-base 0 \"thirsties\" false"
"pen-1" 0.01 1 -13840069 true "" "plot-people-base 1 \"thirsties\" false"
"pen-2" 0.01 1 -2674135 true "" "plot-people-base 2 \"thirsties\" false"
"pen-3" 0.01 1 -955883 true "" "plot-people-base 3 \"thirsties\" false"
"pen-4" 0.01 1 -2064490 true "" "plot-people-base 4 \"thirsties\" false"
"pen-5" 5.0 1 -1184463 true "" "plotxy 0 thirst-activation-threshold"
"pen-6" 0.98 1 -16777216 true "" "plot-people-base 0 \"thirsties\" true"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 1 \"thirsties\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 2 \"thirsties\" true"
"pen-9" 1.0 1 -16777216 true "" "plot-people-base 3 \"thirsties\" true"
"pen-10" 0.98 1 -16777216 true "" "plot-people-base 4 \"thirsties\" true"

PLOT
1131
438
1322
558
Tinkles
NIL
NIL
0.0
5.0
0.0
100.0
true
false
"" "clear-plot"
PENS
"pen-0" 0.01 1 -8630108 true "" "plot-people-base 0 \"tinkles\" false"
"pen-1" 0.01 1 -13840069 true "" "plot-people-base 1 \"tinkles\" false"
"pen-2" 0.01 1 -2674135 true "" "plot-people-base 2 \"tinkles\" false"
"pen-3" 0.01 1 -955883 true "" "plot-people-base 3 \"tinkles\" false"
"pen-4" 0.01 1 -2064490 true "" "plot-people-base 4 \"tinkles\" false"
"pen-5" 5.0 1 -1184463 true "" "plotxy 0 tinkle-activation-threshold"
"pen-6" 0.98 1 -16777216 true "" "plot-people-base 0 \"tinkles\" true"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 1 \"tinkles\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 2 \"tinkles\" true"
"pen-9" 1.0 1 -16777216 true "" "plot-people-base 3 \"tinkles\" true"
"pen-10" 0.98 1 -16777216 true "" "plot-people-base 4 \"tinkles\" true"

PLOT
926
570
1117
690
Pretzels Held
NIL
NIL
0.0
5.0
0.0
30.0
true
false
"" "clear-plot"
PENS
"pen-0" 0.01 1 -8630108 true "" "plot-people-base 0 \"pretzel-count\" false"
"pen-1" 0.01 1 -13840069 true "" "plot-people-base 1 \"pretzel-count\" false"
"pen-2" 0.01 1 -2674135 true "" "plot-people-base 2 \"pretzel-count\" false"
"pen-3" 0.01 1 -955883 true "" "plot-people-base 3 \"pretzel-count\" false"
"pen-4" 0.01 1 -2064490 true "" "plot-people-base 4 \"pretzel-count\" false"
"pen-5" 0.98 1 -16777216 true "" "plot-people-base 0 \"pretzel-count\" true"
"pen-6" 1.0 1 -16777216 true "" "plot-people-base 1 \"pretzel-count\" true"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 2 \"pretzel-count\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 3 \"pretzel-count\" true"
"pen-9" 0.98 1 -16777216 true "" "plot-people-base 4 \"pretzel-count\" true"

PLOT
926
438
1117
558
Money
NIL
NIL
0.0
5.0
0.0
100.0
true
false
"" "clear-plot"
PENS
"pen-0" 0.01 1 -8630108 true "" "plot-people-base 0 \"money\" false"
"pen-1" 0.01 1 -13840069 true "" "plot-people-base 1 \"money\" false"
"pen-2" 0.01 1 -2674135 true "" "plot-people-base 2 \"money\" false"
"pen-3" 0.01 1 -955883 true "" "plot-people-base 3 \"money\" false"
"pen-4" 0.01 1 -2064490 true "" "plot-people-base 4 \"money\" false"
"pen-5" 0.98 1 -16777216 true "" "plot-people-base 0 \"money\" true"
"pen-6" 1.0 1 -16777216 true "" "plot-people-base 1 \"money\" true"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 2 \"money\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 3 \"money\" true"
"pen-9" 0.98 1 -16777216 true "" "plot-people-base 4 \"money\" true"

PLOT
1131
570
1322
690
Pretzels on the Board
NIL
NIL
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"pen-0" 1.0 0 -16777216 true "" "plot (count pretzels)"

PLOT
926
302
1117
422
Turns Hungry
NIL
NIL
0.0
5.0
0.0
100.0
true
false
"" "clear-plot"
PENS
"default" 0.01 1 -8630108 true "" "plot-people-base 0 \"ticks-hungry\" false"
"pen-1" 0.01 1 -13840069 true "" "plot-people-base 1 \"ticks-hungry\" false"
"pen-2" 0.01 1 -2674135 true "" "plot-people-base 2 \"ticks-hungry\" false"
"pen-3" 0.01 1 -955883 true "" "plot-people-base 3 \"ticks-hungry\" false"
"pen-4" 0.01 1 -2064490 true "" "plot-people-base 4 \"ticks-hungry\" false"
"pen-5" 0.98 1 -16777216 true "" "plot-people-base 0 \"ticks-hungry\" true"
"pen-6" 1.0 1 -16777216 true "" "plot-people-base 1 \"ticks-hungry\" true"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 2 \"ticks-hungry\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 3 \"ticks-hungry\" true"
"pen-9" 0.98 1 -16777216 true "" "plot-people-base 4 \"ticks-hungry\" true"
"pen-10" 5.0 1 -1184463 true "" "plot-threshold ticks-hungry-before-death"

PLOT
1130
303
1321
423
Turns Thirsty
NIL
NIL
0.0
5.0
0.0
100.0
true
false
"" "clear-plot"
PENS
"default" 0.01 1 -8630108 true "" "plot-people-base 0 \"ticks-thirsty\" false"
"pen-1" 0.01 1 -13840069 true "" "plot-people-base 1 \"ticks-thirsty\" false"
"pen-2" 0.01 1 -2674135 true "" "plot-people-base 2 \"ticks-thirsty\" false"
"pen-3" 0.01 1 -955883 true "" "plot-people-base 3 \"ticks-thirsty\" false"
"pen-4" 0.01 1 -2064490 true "" "plot-people-base 4 \"ticks-thirsty\" false"
"pen-5" 0.98 1 -16777216 true "" "plot-people-base 0 \"ticks-thirsty\" true"
"pen-6" 1.0 1 -16777216 true "" "plot-people-base 1 \"ticks-thirsty\" true"
"pen-7" 1.0 1 -16777216 true "" "plot-people-base 2 \"ticks-thirsty\" true"
"pen-8" 1.0 1 -16777216 true "" "plot-people-base 3 \"ticks-thirsty\" true"
"pen-9" 0.98 1 -16777216 true "" "plot-people-base 4 \"ticks-thirsty\" true"
"pen-10" 5.0 1 -1184463 true "" "plot-threshold ticks-thirsty-before-death"

SLIDER
25
512
308
545
bladder-explosion-threshold
bladder-explosion-threshold
0
100
3
1
1
explosions
HORIZONTAL

SLIDER
24
722
307
755
water-level-max
water-level-max
500
20000
500
500
1
NIL
HORIZONTAL

SLIDER
339
722
906
755
starting-water-level
starting-water-level
0
water-level-max
500
100
1
NIL
HORIZONTAL

SLIDER
926
722
1323
755
water-replenishment-rate
water-replenishment-rate
0
200
5
5
1
thirsties
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model simulates the lives of lunatics trapped in a hellish world.  It is my first (and only) NetLogo model, written in 2012 shortly after I started work at the CCL on the NetLogo Development team, and loosely inspired by my day-to-day goings-on at work.  

## HOW IT WORKS

To begin, there are 5 players (differently-colored person sprites) standing at the center of the game canvas.  As time elapses, the players' biological needs grow, based on values determined by the sliders.  Generally, hunger and thirst rise over time, eventually reaching thresholds at which the needs must be addressed, lest the player die within a certain number of ticks (ghost sprite, body replaced by a flower sprite).  A player wins the game when he/she is the last one left alive.

There are pretzels strewn about the canvas that can be used to reduce the accumulating hunger.  If a player encounters a pretzel on the floor while hungry, he/she will eat it directly (Pacman icon).  If a player encounters a pretzel on the floor while **not** hungry, he/she will hold onto it for possible later use (box icon).  If a player grows hungry and has surplus pretzels, he/she will eat it (open box icon).  If a player grows hungry and does not have any surplus pretzels, he/she will attempt to find a pretzel on the ground, or might approach a nearby player who has surplus pretzels and buy one (red dollar icon for buyer, green dollar icon for seller).

Eating pretzels, though, incurs thirst (which also accumulates over time).  The water fountain (blue/gray water drop sprite) at the left side of the canvas is the only place where thirst can be quenched.  The water fountain has a limited amount of water that replensishes over time.  When there is enough water present in the fountain to help in quenching a thirsty, nearby player's thirst, he/she will attempt to drink the water (water bottle icon), lowering thirst.  An unlimited number of players can drink from the fountain simulataneously.

Drinking water, though, incurs "tinkles"--a measure of the player's desire to urinate.  The toilet on the right side of the canvas (toilet sprite) is the only place where tinkles can be safely diminished.  However, only one player can use the toilet at a time.  If a near-to-the-toilet player desires to urinate, and the toilet is unoccupied, the player may ascend the throne and reduce his/her tinkles over time (rocket icon).

If, however, the player keeps an elevated count of tinkles for a certain number of ticks, he/she will uncontrollably reduce his/her tinkle count by having a bladder explosion (yellow water drop sprite).  Experiencing a bladder explosion forces a player to be fined (red dollar icon), since it is indecent to leave a mess of urine on the floor in a public place.

This public place, however, has a coyote problem, and coyotes have a tendency of marking their territory with their urine.  After a player experiences a certain number of bladder explosions, a territorial, alpha male robot coyote with a laser cannon strapped to its back will appear from off-screen, dashing to the opposite side of the screen, and shooting the offending player to death with a laser on its way through.

Under ideal settings, the players will find "freetime", where all of his/her needs are sated and ticks can be spent on anything of the player's choosing.

If `toilet-troll` is `true`, one role-free player will be assigned the role of "toilet troll", causing him/her to, during freetime, hog the toilet as much as possible, possibly forcing other players to have unnecessary bladder explosions.

If `pretzel-protector` is `true`, one role-free player will be assigned the role of "pretzel protector", causing him/her to, during freetime, gather pretzels unnecessarily, possibly forcing other players to starve or need to buy pretzels from the protector.

If `water-waster` is `true`, one role-free player will be assigned the role of "water waster", causing him/her to, during freetime, drink from the water fountain unnecessarily, possibly forcing other players to die of thirst (due to a depleted water supply), and almost certainly causing the water waster to experience numerous bladder explosions quite quickly.

## HOW TO USE IT

Click "Setup".  Then, click "Go".  I discourage you from turning up the speed slider much, because the most interesting part of the whole thing happens really quickly.

## THINGS TO NOTICE

ZAP!

## THINGS TO TRY

Play with all of the sliders.  Less intimidatingly, try turning on the personalities (by using the switches in the top-right of the interface).  The default settings for the model cause enabling "water waster" to have a profound impact on the game.

## EXTENDING THE MODEL

People sit on the toilet out in the open, without any sort of privacy.  Obviously, this is empiracally inaccurate and warrants improvement.

## NETLOGO FEATURES

  * Animated icons (`handle-anims`)
  * Solid-colored bar graphs (see both the code of the plot pens within the plots as well as the general boilerplate at the bottom of the "Code" tab (below the "Plotting Code" comment))
  * Lasers (`direct-lasers`)
  * `List[T].take(n: Int): List[T]` => `take`
  * `List[T].zipWithIndex: List[(Int, T)]` => `zip-with-index`

## RELATED MODELS

No one dares make a mode related to my own.

## CREDITS AND REFERENCES

Jason Bertsche IS AWESOME
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

bottle
false
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 10 10 280
Rectangle -16777216 true false 122 26 178 82
Rectangle -16777216 true false 107 51 192 72
Line -7500403 false 124 61 176 61
Circle -16777216 true false 137 191 78
Rectangle -16777216 true false 110 207 184 270
Circle -16777216 true false 86 192 76
Rectangle -16777216 true false 87 115 214 221
Circle -16777216 true false 87 62 126
Circle -13345367 true false 99 199 60
Rectangle -1 true false 135 38 165 61
Circle -13345367 true false 139 201 60
Rectangle -13345367 true false 125 228 178 258
Circle -7500403 true false 100 76 100
Rectangle -7500403 true false 135 62 165 86
Rectangle -7500403 true false 100 118 200 167
Rectangle -13345367 true false 99 129 200 239

bottle3
false
13
Circle -2064490 true true 106 -3 52
Circle -2064490 true true 142 -3 52
Circle -2064490 true true 147 208 92
Rectangle -2064490 true true 106 17 194 71
Circle -2064490 true true 61 37 176
Circle -2064490 true true 59 209 92
Rectangle -2064490 true true 116 266 188 300
Rectangle -2064490 true true 59 118 239 252
Rectangle -16777216 true false 132 25 168 70
Rectangle -16777216 true false 121 49 180 54
Line -7500403 false 124 51 176 51
Circle -16777216 true false 153 216 60
Rectangle -16777216 true false 114 220 184 276
Circle -16777216 true false 88 214 62
Rectangle -16777216 true false 87 122 213 245
Circle -16777216 true false 87 65 126
Circle -13345367 true false 90 213 60
Rectangle -1 true false 135 28 165 51
Circle -13345367 true false 150 213 60
Rectangle -13345367 true false 116 243 176 273
Circle -7500403 true false 90 67 120
Rectangle -7500403 true false 135 52 165 76
Rectangle -7500403 true false 90 127 210 161
Rectangle -13345367 true false 90 134 210 244
Rectangle -2064490 true true 120 0 181 16

coyote
false
13
Polygon -2064490 true true 227 75 230 58 249 44 248 68 237 73
Rectangle -16777216 true false 174 41 259 59
Rectangle -13840069 true false 178 44 255 55
Rectangle -16777216 true false 234 31 247 66
Rectangle -16777216 true false 211 31 224 66
Rectangle -16777216 true false 186 32 199 67
Rectangle -16777216 true false 116 36 181 63
Circle -16777216 true false 102 36 26
Rectangle -13345367 true false 116 39 178 60
Circle -16777216 true false 85 71 96
Circle -955883 true false 90 75 88
Polygon -2064490 true true 75 225 97 249 112 252 122 252 114 242 102 241 89 224 94 181 64 113 46 119 31 150 32 164 61 204 57 242 85 266 91 271 101 271 96 257 89 257 70 242
Polygon -2064490 true true 181 106 213 69 226 62 257 70 260 89 285 110 272 124 234 116 218 134 209 150 204 163 192 178 169 185 154 189 129 189 89 180 69 166 63 113 124 110 160 111 170 104
Polygon -6459832 true false 252 143 242 141
Polygon -6459832 true false 254 136 232 137
Line -16777216 false 75 224 89 179
Line -16777216 false 80 159 89 179
Polygon -6459832 true false 262 138 234 149
Polygon -2064490 true true 50 121 36 119 24 123 14 128 6 143 8 165 8 181 7 197 4 233 23 201 28 184 30 169 28 153 48 145
Polygon -2064490 true true 171 181 178 263 187 277 197 273 202 267 187 260 186 236 194 167
Polygon -7500403 true false 187 163 195 240 214 260 222 256 222 248 212 245 205 230 205 130
Line -16777216 false 89 181 112 185
Line -16777216 false 31 150 47 118
Line -16777216 false 236 112 246 119
Polygon -16777216 true false 278 119 282 116 274 113
Line -16777216 false 189 201 203 161
Line -16777216 false 90 262 94 272
Line -16777216 false 110 246 119 252
Line -16777216 false 190 266 194 274
Line -16777216 false 218 251 219 257
Line -16777216 false 246 67 234 64
Line -16777216 false 30 150 30 165
Circle -13345367 true false 105 39 20
Rectangle -2674135 true false 188 34 197 64
Rectangle -2674135 true false 214 34 222 63
Polygon -2064490 true true 216 73 219 56 229 42 237 66 226 71
Line -16777216 false 229 45 235 68
Polygon -16777216 true false 230 64 228 51 222 59 224 69
Rectangle -2674135 true false 237 34 245 63
Rectangle -16777216 true false 120 56 144 80
Rectangle -8630108 true false 124 58 140 77
Line -16777216 false 180 105 169 103
Line -16777216 false 86 110 126 109
Line -16777216 false 126 109 162 110
Line -16777216 false 161 110 168 103
Rectangle -7500403 true false 270 90 285 90
Rectangle -7500403 true false 235 87 259 102
Polygon -16777216 true false 235 90 250 91 255 99 248 98 244 92
Rectangle -7500403 true false 230 78 242 88
Polygon -7500403 true false 81 113 66 118 49 130 57 157 76 132 97 121 97 109
Polygon -7500403 true false 109 183 124 138 165 151 156 188 128 189
Polygon -7500403 true false 182 104 200 118 214 102 195 91
Polygon -7500403 true false 44 178 57 170 70 188 52 190
Rectangle -7500403 true false 178 220 185 259
Rectangle -7500403 true false 8 173 22 188

drop
false
0
Circle -7500403 true true 73 133 152
Polygon -7500403 true true 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true true 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

ghost
false
0
Polygon -7500403 true true 30 165 13 164 -2 149 0 135 -2 119 0 105 15 75 30 75 58 104 43 119 43 134 58 134 73 134 88 104 73 44 78 14 103 -1 193 -1 223 29 208 89 208 119 238 134 253 119 240 105 238 89 240 75 255 60 270 60 283 74 300 90 298 104 298 119 300 135 285 135 285 150 268 164 238 179 208 164 208 194 238 209 253 224 268 239 268 269 238 299 178 299 148 284 103 269 58 284 43 299 58 269 103 254 148 254 193 254 163 239 118 209 88 179 73 179 58 164
Line -16777216 false 189 253 215 253
Circle -16777216 true false 102 30 30
Polygon -16777216 true false 165 105 135 105 120 120 105 105 135 75 165 75 195 105 180 120
Circle -16777216 true false 160 30 30

gift
false
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 10 10 280
Polygon -1184463 true false 150 270 256 213 255 90 150 135
Polygon -1184463 true false 150 135 45 90 150 45 255 90
Polygon -1184463 true false 46 90 46 210 151 270 151 135
Line -16777216 false 150 270 150 135
Line -16777216 false 150 135 45 90
Line -16777216 false 150 135 255 90
Polygon -2674135 true false 77 224 77 105 105 118 106 244 77 229
Polygon -2674135 true false 194 246 192 120 220 107 223 208 223 232 209 238
Line -16777216 false 45 90 150 45
Line -16777216 false 255 90 150 45
Line -16777216 false 150 270 256 213
Line -16777216 false 150 271 45 210
Line -16777216 false 256 213 255 90
Line -16777216 false 45 210 45 90
Polygon -2674135 true false 80 104 185 61 212 73 112 117
Polygon -2674135 true false 182 118 89 74 117 62 216 105
Line -16777216 false 111 117 211 74
Line -16777216 false 119 62 148 74
Line -16777216 false 89 74 118 87
Line -16777216 false 184 61 79 104
Line -16777216 false 147 102 183 119
Line -16777216 false 181 88 217 104
Line -16777216 false 224 109 224 232
Line -16777216 false 197 121 197 245
Line -16777216 false 107 245 106 120
Line -16777216 false 77 104 74 227

green-dollar
false
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 11 11 278
Circle -16777216 true false 209 108 36
Circle -16777216 true false 57 108 36
Circle -16777216 true false 56 155 36
Circle -16777216 true false 208 155 36
Rectangle -16777216 true false 69 108 228 120
Rectangle -16777216 true false 56 123 69 174
Rectangle -16777216 true false 74 180 232 191
Rectangle -16777216 true false 231 121 245 172
Rectangle -10899396 true false 66 118 232 181
Polygon -1 true false 124 166 139 154 139 147 127 137 123 135 139 119 155 119 170 139 164 143 161 154 171 163 158 180 132 179
Circle -1 true false 194 145 16
Circle -1 true false 87 145 16

green-dollar3
false
0
Rectangle -13840069 true false 15 90 285 210
Rectangle -1 true false 30 105 270 195
Circle -13840069 true false 120 120 60
Circle -13840069 true false 120 135 60
Circle -13840069 true false 254 178 26
Circle -13840069 true false 248 98 26
Circle -13840069 true false 18 97 36
Circle -13840069 true false 21 178 26
Circle -13840069 true false 66 135 28
Circle -1 true false 72 141 16
Circle -13840069 true false 201 138 32
Circle -1 true false 209 146 16
Rectangle -16777216 true false 64 112 86 118
Rectangle -16777216 true false 90 112 124 118
Rectangle -16777216 true false 128 112 188 118
Rectangle -16777216 true false 191 112 237 118
Rectangle -1 true false 106 199 128 205
Rectangle -1 true false 90 96 209 98
Rectangle -13840069 true false 60 168 103 176
Rectangle -13840069 true false 199 127 230 133
Line -13840069 false 59 184 104 184
Line -13840069 false 241 189 196 189
Line -13840069 false 59 189 104 189
Line -16777216 false 116 124 71 124
Polygon -1 true false 127 179 142 167 142 160 130 150 126 148 142 132 158 132 173 152 167 156 164 167 174 176 161 193 135 192
Rectangle -1 true false 134 199 184 205

lazor
true
0
Rectangle -2674135 true false 135 15 165 285
Line -16777216 false 135 285 135 15
Line -16777216 false 135 285 165 285
Line -16777216 false 165 285 165 15
Line -16777216 false 135 15 165 15

opened-gift
false
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 10 9 280
Polygon -7500403 true false 149 135 44 90 149 45 254 90
Line -16777216 false 255 90 150 45
Line -16777216 false 150 271 45 210
Polygon -16777216 false false 45 89 29 75 125 35 150 45
Polygon -1184463 true false 44 87 32 76 125 38 145 45
Polygon -16777216 false false 150 45 171 34 270 82 255 90
Polygon -1184463 true false 156 46 171 37 265 82 253 88
Circle -6459832 true false 80 80 78
Circle -6459832 true false 144 81 78
Circle -16777216 true false 104 103 34
Circle -16777216 true false 165 101 34
Line -16777216 false 152 97 185 160
Line -16777216 false 134 111 152 141
Polygon -1184463 true false 46 91 46 211 151 271 151 136
Line -16777216 false 150 135 45 90
Polygon -2674135 true false 78 224 78 105 106 118 107 244 78 229
Line -16777216 false 150 270 150 135
Polygon -1184463 true false 155 268 255 213 253 94 155 133
Line -16777216 false 256 213 255 90
Polygon -2674135 true false 221 107 274 143 261 168 189 120
Line -16777216 false 150 135 255 90
Polygon -2674135 true false 194 246 192 120 220 107 223 208 223 232 209 238
Line -16777216 false 150 270 256 213
Line -16777216 false 45 210 45 90
Polygon -2674135 true false 80 107 35 150 53 171 99 127
Line -16777216 false 79 107 34 149
Line -16777216 false 52 170 34 150
Line -16777216 false 188 120 261 167
Line -16777216 false 274 142 260 167
Line -16777216 false 274 143 217 107
Line -16777216 false 53 170 106 121
Line -16777216 false 106 245 107 122
Line -16777216 false 78 229 78 149
Line -16777216 false 223 144 225 230
Line -16777216 false 194 246 192 129

opened-gift3
false
7
Polygon -7500403 true false 150 135 15 75 150 15 285 75
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
Polygon -1184463 true false 14 74 4 64 131 5 148 14
Polygon -1184463 true false 285 74 297 62 168 7 151 14
Circle -6459832 true false 144 65 82
Circle -16777216 true false 172 97 33
Circle -6459832 true false 77 67 82
Circle -16777216 true false 106 96 33
Line -16777216 false 151 83 189 144
Line -16777216 false 129 98 153 130
Polygon -1184463 true false 14 75 14 225 149 285 149 135
Polygon -2674135 true false 66 97 5 157 24 179 93 121 66 97
Polygon -2674135 true false 63 242 61 97 94 111 95 261 63 247
Polygon -1184463 true false 151 284 285 224 285 76 150 135
Polygon -2674135 true false 210 257 208 109 238 95 238 221 238 245 224 251
Polygon -2674135 true false 234 97 297 160 288 194 207 121 234 97

pacman
false
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 9 9 280
Circle -16777216 true false 49 49 202
Circle -1184463 true false 63 63 175
Circle -16777216 true false 152 86 30
Polygon -16777216 true false 233 92 151 152 232 208
Rectangle -16777216 true false 228 116 242 187
Polygon -2064490 true true 177 151 259 207 259 95

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

pretzel
false
0
Circle -6459832 true false 54 54 192
Polygon -16777216 true false 120 45 150 90 180 45
Polygon -16777216 true false 180 90 210 120 195 165 165 120 180 90
Polygon -16777216 true false 120 90 90 120 105 165 135 120 120 90
Polygon -16777216 true false 150 180 120 210 180 210
Polygon -6459832 true false 90 195 60 225 90 240 105 210
Line -16777216 false 75 210 135 120
Line -16777216 false 90 240 150 180
Polygon -6459832 true false 195 225 210 240 240 225 210 210
Line -16777216 false 210 240 180 210
Line -16777216 false 225 210 195 165
Line -16777216 false 150 180 135 120
Line -16777216 false 165 120 150 90
Rectangle -16777216 true false 150 195 165 180
Polygon -16777216 true false 180 210 135 120 150 180 180 210
Polygon -16777216 true false 120 210 150 165 150 180
Polygon -6459832 true false 150 165 150 150 135 120 150 165
Polygon -6459832 true false 150 90 120 165 150 165
Line -16777216 false 150 150 135 120
Polygon -16777216 true false 120 60 135 60 120 60 105 60 150 75 195 60
Rectangle -16777216 true false 105 45 195 60

pretzel-protector
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Circle -6459832 true false 120 120 58
Polygon -7500403 true true 125 128 145 132 150 139 154 132 171 127 147 115
Circle -16777216 true false 142 156 14
Circle -16777216 true false 157 139 14
Circle -16777216 true false 129 139 14
Line -16777216 false 140 141 165 173
Line -16777216 false 152 136 173 164
Line -16777216 false 140 150 126 166
Line -16777216 false 144 158 133 172

red-dollar
false
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 11 11 278
Circle -16777216 true false 209 108 36
Circle -16777216 true false 57 108 36
Circle -16777216 true false 56 155 36
Circle -16777216 true false 208 155 36
Rectangle -16777216 true false 69 108 228 120
Rectangle -16777216 true false 56 123 69 174
Rectangle -16777216 true false 74 180 232 191
Rectangle -16777216 true false 231 121 245 172
Rectangle -2674135 true false 66 118 232 181
Polygon -1 true false 124 166 139 154 139 147 127 137 123 135 139 119 155 119 170 139 164 143 161 154 171 163 158 180 132 179
Circle -1 true false 194 145 16
Circle -1 true false 87 145 16

red-dollar3
false
13
Rectangle -2064490 true true 274 112 299 188
Rectangle -2064490 true true 1 111 26 187
Circle -2064490 true true 233 80 64
Circle -2064490 true true 2 156 64
Circle -2064490 true true 2 80 64
Circle -2064490 true true 233 156 64
Rectangle -2064490 true true 29 79 262 222
Rectangle -16777216 true false 19 105 282 195
Rectangle -16777216 true false 30 195 270 207
Rectangle -16777216 true false 30 93 270 105
Circle -16777216 true false 246 94 36
Circle -16777216 true false 19 94 36
Circle -16777216 true false 19 170 36
Circle -16777216 true false 246 170 36
Rectangle -2674135 true false 30 105 270 195
Rectangle -1 true false 44 123 254 183
Circle -2674135 true false 35 172 18
Rectangle -2674135 true false 61 163 104 171
Circle -2674135 true false 67 127 28
Circle -1 true false 73 133 16
Circle -2674135 true false 33 107 26
Circle -2674135 true false 239 168 26
Circle -2674135 true false 240 106 26
Rectangle -2674135 true false 199 127 230 133
Circle -2674135 true false 198 140 32
Circle -1 true false 206 148 16
Circle -2674135 true false 120 128 60
Circle -2674135 true false 120 117 60
Polygon -1 true false 127 170 142 158 142 151 130 141 126 139 142 123 158 123 173 143 167 147 164 158 174 167 161 184 135 183

red-rocket
true
13
Circle -16777216 true false 0 0 300
Circle -2064490 true true 8 8 284
Polygon -16777216 true false 151 19 124 38 108 69 92 103 92 134 103 166 76 267 129 250 168 250 222 270 210 218 206 203 195 169 206 134 206 105 173 40
Polygon -2674135 true false 120 150 88 256 135 240 165 240 211 254 180 150
Polygon -1 true false 135 240 105 135 105 105 120 75 180 75 195 105 195 135 165 240
Polygon -2674135 true false 120 75 180 75 165 45 150 30 135 45
Line -2674135 false 105 105 135 120
Line -2674135 false 135 120 165 120
Line -2674135 false 165 120 195 105
Line -2674135 false 105 135 135 150
Line -2674135 false 135 150 165 150
Line -2674135 false 165 150 195 135
Rectangle -16777216 true false 136 248 165 269
Rectangle -2674135 true false 147 161 153 258

toilet
false
8
Rectangle -1 true false 180 15 195 30
Rectangle -1 true false 53 135 240 195
Rectangle -1 true false 180 30 240 135
Circle -1 true false 87 151 95
Circle -1 true false 134 165 62
Rectangle -6459832 true false 210 60 240 75
Rectangle -1 true false 195 195 240 255
Rectangle -1 true false 120 240 240 255
Rectangle -7500403 true false 240 180 300 210
Rectangle -16777216 false false 180 15 195 135
Polygon -1 true false 135 240 165 225 150 210

toilet-troll
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 87 120 192 90 282 105 297 135 297 150 222 165 297 195 297 210 282 180 192 195 87
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Polygon -16777216 true false 151 88 141 99 129 130 129 147 132 156 120 201 145 178 145 183 157 183 157 180 182 201 164 157 168 149 168 131 159 99
Polygon -2674135 true false 150 99 145 105 142 118 157 120 155 105
Polygon -1 true false 142 118 137 129 136 140 146 169 153 169 160 140 160 131 156 119
Polygon -2674135 true false 157 158 171 185 154 170
Polygon -2674135 true false 143 159 129 185 146 170
Line -2674135 false 138 141 158 141

water-waster
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Circle -16777216 true false 124 141 52
Polygon -16777216 true false 124 161 153 107 178 165
Circle -13345367 true false 134 149 33
Polygon -13345367 true false 136 158 152 125 166 159

water0
false
13
Circle -7500403 true false 73 133 152
Polygon -7500403 true false 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true false 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165

water100
false
13
Circle -13345367 true false 73 133 152
Polygon -13345367 true false 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -13345367 true false 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165

water25
false
13
Circle -7500403 true false 73 133 152
Polygon -7500403 true false 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true false 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165
Circle -13345367 true false 73 132 154
Polygon -7500403 true false 72 220 228 219 226 191 218 171 206 153 151 108 93 154 81 171 74 193

water50
false
13
Circle -7500403 true false 73 133 152
Polygon -7500403 true false 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true false 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165
Circle -13345367 true false 73 132 154
Polygon -7500403 true false 89 160 213 163 153 87

water75
false
13
Circle -7500403 true false 73 133 152
Polygon -7500403 true false 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true false 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165
Circle -13345367 true false 73 132 154
Polygon -13345367 true false 128 90 173 91 186 119 114 120
Polygon -13345367 true false 116 116 89 161 142 132 210 160 185 119

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
