extensions [ gis ]
globals [file-name
         mouse-clicked      
         mouse-double-click  
         clicked-turtle
         clicked-xcor
         clicked-ycor    
         scale
         times
         dumy_setting
         paths-dataset
         check-agent-num
         full-iso
         shape-list
         prog prog_total
        ]
breed [peds ped]
breed [vectors vector]
breed [arrows arrow]
breed [grids grid]
breed [spectrums spectrum]
breed [nodes node]
breed [walls wall]
breed [foots foot]
breed [pictures picture]
peds-own[iso-area 
         ped_self  
         cog_convex 
         occlude_memory 
         random_dist 
         random_angle
        ]
patches-own [agent-exposure 
             isovist 
             VE1 VE2 pVE access 
             iVE3 qVE3 iVA3 qVA3 
             q_exposure i_exposure iDVA qDVA dumy VE1_dumy t_exposure jam_level
             var var_t step di head_angle head_angle_r head_angle_l
             wall_field_dist wall_field_angle VfT 
             node-end
            ]

;;;;;;;;;;;;;;;;;;;;;shp file import;;;;;;;;;;;;;;;;;;;;;;

to shp-import
  set file-name user-file
  if file-name = false [stop]
  read-gis-datasets
  setup-world-envelope
  draw-world
  setup-paths-graph
end

to read-gis-datasets
  set paths-dataset  gis:load-dataset file-name
end

to setup-world-envelope
  let world (gis:envelope-of paths-dataset) ;; [ minimum-x maximum-x minimum-y maximum-y ]
  let zoom 1.05
  
    let x0 (item 0 world + item 1 world) / 2          let y0 (item 2 world + item 3 world) / 2
    let W0 zoom * (item 0 world - item 1 world) / 2   let H0 zoom * (item 2 world - item 3 world) / 2
    set world (list (x0 - W0) (x0 + W0) (y0 - H0) (y0 + H0))
  
  gis:set-world-envelope (world)
end

to setup-paths-graph
  set-default-shape nodes "circle"
  ask nodes [set size 0.1]
  foreach polylines-of paths-dataset 10 [
    (foreach butlast ? butfirst ? [ if ?1 != ?2 [ ;; skip nodes on top of each other due to rounding
      let n1 new-node-at first ?1 last ?1
      let n2 new-node-at first ?2 last ?2
      ask n2 [ask patch-here [set node-end 1]]
      ask n1 [face n2 while [[node-end] of patch-here != 1] [ask patch-here [set pcolor white] fd 0.001]]
      ask patches [set node-end 0]
    ]])
  ]
  ask nodes [die]
end

to-report new-node-at [x y] ; returns a node at x,y creating one if there isn't one there.
  let n nodes with [xcor = x and ycor = y]
  ifelse any? n [set n one-of n] [create-nodes 1 [setxy x y set size 2 set n self]]
  report n
end

to draw-world
  gis:set-drawing-color [255   0   0]    gis:draw paths-dataset 1
end

to-report polylines-of [dataset decimalplaces]
  let polylines gis:feature-list-of dataset                              ;; start with a features list
  set polylines map [first ?] map [gis:vertex-lists-of ?] polylines      ;; convert to virtex lists
  set polylines map [map [gis:location-of ?] ?] polylines                ;; convert to netlogo float coords.
  set polylines remove [] map [remove [] ?] polylines                    ;; remove empty poly-sets .. not visible
  set polylines map [map [map [precision ? decimalplaces] ?] ?] polylines        ;; round to decimalplaces
    ;; note: probably should break polylines with empty coord pairs in the middle of the polyline
  report polylines ;; Note: polylines with a few off-world points simply skip them.
end

to-report meters-per-patch ;; maybe should be in gis: extension?
  let world gis:world-envelope ; [ minimum-x maximum-x minimum-y maximum-y ]
  let x-meters-per-patch (item 1 world - item 0 world) / (max-pxcor - min-pxcor)
  let y-meters-per-patch (item 3 world - item 2 world) / (max-pycor - min-pycor)
  report mean list x-meters-per-patch y-meters-per-patch
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to setup
  cd ct
  ask patches with [ 92 < pcolor and pcolor < 97] [set pcolor blue]
  ask patches with [ 82 < pcolor and pcolor < 87] [set pcolor cyan]
  ask patches with [ 32 < pcolor and pcolor < 37] [set pcolor brown]
  ask patches with [ 42 < pcolor and pcolor < 47] [set pcolor yellow]
  ask patches with [ 52 < pcolor and pcolor < 57] [set pcolor green]
  set-initial
  ask patches with [count neighbors != 8] [set pcolor white]
  set mouse-clicked false
  set mouse-double-click false
  set clicked-turtle nobody
end

to set-initial
  ct
  reset-ticks
  clear-drawing
  clear-all-plots
  patch-color
  ask patches [set q_exposure 0 set i_exposure 0 set iDVA 0 set qDVA 0
               set step 0 set var 0 set var_t 0 set jam_level 0 set check-agent-num 0]
  set times 0
  set check-agent-num 0
  set prog 0
  set prog_total 0
end

to patch-color
  ask patches with [pcolor != blue and pcolor != white and pcolor != cyan and pcolor != brown and pcolor != yellow and pcolor != green] 
                   [set pcolor black]
end

to draw-env
if mouse-down?
 [if dwg-code = "Erase(Black)" [ask patch mouse-xcor mouse-ycor [set pcolor black]]
  if dwg-code = "Wall(white)" [ask patch mouse-xcor mouse-ycor [set pcolor white]]
  if dwg-code = "Exit(Cyan)" [ask patch mouse-xcor mouse-ycor [set pcolor cyan]]
  if dwg-code = "Attractor(Brown)" [ask patch mouse-xcor mouse-ycor [set pcolor brown]]
  if dwg-code = "Window(Blue)" [ask patch mouse-xcor mouse-ycor [set pcolor blue]]
  if dwg-code = "Entrance(Yellow)" [ask patch mouse-xcor mouse-ycor [set pcolor yellow]]
  if dwg-code = "Mark(Green)" [ask patch mouse-xcor mouse-ycor [set pcolor green]]
 ]
end

to set-ped
  set-initial
  ask n-of ped_num (patches with [pcolor = black]) [sprout-peds 1 [set shape "head" set size 1]]
end

to make-movie
  movie-cancel
  let path (word user-new-file ".mov")
  if not is-string? path [ stop ]  ;; stop if user canceled
  movie-start path

     if Movie_Type = "Navi-Movement" [grade while [check-agent-num != ped_num or any? peds] [target-walking movie-grab-view ]]
     if Movie_Type = "Navi_Natural_Mov" [grade while [check-agent-num != ped_num or any? peds] [Target_Gallery-Walking movie-grab-view ]]
     if Movie_Type = "Natural_Movement" [while [times < sim-time] [Gallery-walking movie-grab-view ]]
 
  ask patches with [pcolor = black] 
                   [set pcolor scale-color red q_exposure min [q_exposure] of patches max [q_exposure] of patches]
  movie-grab-view
  movie-close
  user-message (word "Exported movie to " path)
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Static Analysis;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to Static_Analysis
  if Static_Analysis_type = "View from Agent(s)" [get-view_from_target]
  if Static_Analysis_type = "Isovist Field" [get-isovist]
  if Static_Analysis_type = "VE I" [get-VE1]
  if Static_Analysis_type = "VE II" [get-VE2]
  if Static_Analysis_type = "VE III (iVE III)" [get-iVE3]
  if Static_Analysis_type = "Potential Field" [patch-color 
                                               grade
    ifelse any? patches with [var != 0][
    ask patches with [pcolor = black] 
    [set pcolor scale-color red var min [var] of patches max [var] of patches]
                                       ][user-message "No Result" stop]
                                              ]
  if Static_Analysis_type = "Wall Field" [get-wall_field]
end

to get-view_from_target
  cd
  patch-color
  set prog 0
  set prog_total 0
  if not any? turtles [user-message "No Agent(S)" stop]
  ask patches [set VfT 0 set agent-exposure 0 set dumy 0]
  set prog_total count peds
  set scale real-width / world-width

  ask peds [without-interruption
            [let angle 180
             while [abs angle <= 180]
                    [let dist 1
                     while [dist <= view_dist / scale]
                           [let p patch-right-and-ahead angle dist
                            ask p [ifelse pcolor != white 
                                   [if dumy = 0 [set agent-exposure 1 - (dist * scale / view_dist)  set dumy 1]]
                                   [set dist view_dist / scale]
                                  ]
                            set dist dist + 1
                           ]
                    set angle angle - atan 1 (view_dist / scale * 2)
                   ]
            ask patches with [dumy = 1] [set VfT VfT + agent-exposure]
            ask patches with [dumy = 1] [set agent-exposure 0 set dumy 0] ]
            set prog prog + 1
          ]
 patch-color
 ask patches with [pcolor = black] 
                  [set pcolor scale-color red VfT min [VfT] of patches max [VfT] of patches]  
end


to get-isovist 
  ct
  cd
  patch-color
  set prog 0
  set prog_total 0
  ask patches [set isovist 0 set agent-exposure 0 set dumy 0]
  ask patches with [pcolor != white and pcolor != blue]
                   [sprout-peds 1 [set shape "person" set color grey set heading 0]]
  set prog_total count peds
  set scale real-width / world-width

  ask peds [without-interruption
            [let angle 180
             while [abs angle <= 180]
                    [let dist 1
                     while [dist <= view_dist / scale]
                           [let p patch-right-and-ahead angle dist
                            ask p [ifelse pcolor != white 
                                   [if dumy = 0 [ set dumy 1]]
                                   [set dist view_dist / scale]
                                  ]
                            set dist dist + 1
                            ]
                    set angle angle - atan 1 (view_dist / scale * 2)
                   ]
     ask patches with [dumy = 1] [set isovist isovist + 1]
     ask patches with [dumy = 1] [ set dumy 0] ]
     set prog prog + 1
     die
     ]
  patch-color
  ask patches with [pcolor = black] 
                   [set pcolor scale-color red isovist min [isovist] of patches max [isovist] of patches]  
end


to get-VE1
  ct
  cd
  set prog 0
  set prog_total 0
  patch-color
  ask patches [set VE1 0 set agent-exposure 0 set access 0 set pVE 0 set dumy 0 set VE1_dumy 0]
  ask patches with [pcolor != white and pcolor != blue]
                   [sprout-peds 1 [set shape "person" set color grey]]
  set prog_total count peds
  let n 0
  while [n <= max [who] of peds] 
        [ask patches [set access 0] 

         set scale real-width / world-width

         ask ped n [without-interruption
                    [let angle 180
                     while [abs angle <= 180]
                            [let dist 1
                             while [dist <= view_dist / scale]
                                    [let q patch-right-and-ahead angle dist
                                     ask q [ifelse pcolor != white [if VE1_dumy = 0 [set VE1_dumy 1]]
                                                                   [set dist view_dist / scale]
                                           ] 
                                     set dist dist + 1
                                    ]
                            set angle angle - atan 1 (view_dist / scale * 2)
                           ]
                   ]
                  ]

          ask peds-on patches with [VE1_dumy = 1] 
           [without-interruption
              [face ped n
               let angle 15
               while [abs angle <= 15]
                      [let dist 1
                       while [dist <= view_dist / scale]
                               [let p patch-right-and-ahead angle dist
                                ask p [ifelse pcolor != white [if dumy = 0 [set agent-exposure 1 set dumy 1]]
                                                              [set dist view_dist / scale]
                                      ]
                                set dist dist + 1
                               ]
                      set angle angle - atan 1 (view_dist / scale * 2)
                     ]
             if [dumy] of ped n = 1 [ask patch-here [set access sum [agent-exposure] of patches with [dumy = 1]]]
             ask patches with [dumy = 1] [set agent-exposure 0 set dumy 0]
            ]
          ]
         ask patches with [VE1_dumy = 1] [set VE1_dumy 0]
         ask ped n [set pVE sum [access] of patches]
         set n n + 1
         set prog n
        ]
 ask peds [ask patch-here [set VE1 pVE]] 
 patch-color
 ask patches with [pcolor = black] 
                  [set pcolor scale-color red VE1 min [VE1] of patches max [VE1] of patches] 
 ask peds [die]
end


to get-VE2
  ct
  cd
  set prog 0
  set prog_total 0
  patch-color
  ask patches [set VE2 0 set agent-exposure 0 set dumy 0]
  ask patches with [pcolor != white and pcolor != blue]
    [ sprout-peds 1 [set shape "person" set color grey set heading 90]]
  set prog_total count peds 

  set scale real-width / world-width

  ask peds [without-interruption
            [let angle 180
             while [abs angle <= 180]
                   [let dist 1
                    while [dist <= view_dist / scale]
                          [let p patch-right-and-ahead angle dist
                           ask p [ifelse pcolor != white [if dumy = 0 [set agent-exposure 1 / dist set dumy 1]]
                                                         [set dist view_dist / scale]
                                 ]
                           set dist dist + 1
                          ]
                   set angle angle - atan 1 (view_dist / scale * 2)
                  ]
            ask patch-here [set VE2 sum [agent-exposure] of patches with [dumy = 1]]
            ask patches with [dumy = 1] [set agent-exposure 0 set dumy 0] ]
            set prog prog + 1
            die
            ]
 patch-color
 ask patches with [pcolor = black] 
                  [set pcolor scale-color red VE2 min [VE2] of patches max [VE2] of patches]  
end


to get-iVE3
  ct
  cd
  set prog 0
  set prog_total 0
  patch-color
  ask patches [set iVE3 0 set qVE3 0 set iVA3 0 set qVA3 0 set agent-exposure 0 set dumy 0]
  ask patches with [pcolor != white and pcolor != blue]
    [ sprout-peds 1 [set shape "person" set color grey set heading 90]]
  set prog_total count peds 
  set scale real-width / world-width

  ask peds [without-interruption
            [let angle 180
             while [abs angle <= 180]
                   [let dist 1
                    while [dist <= view_dist / scale]
                          [let p patch-right-and-ahead angle dist
                           ask p [ifelse pcolor != white 
                                  [if dumy = 0 [set agent-exposure 1 - (dist * scale / view_dist)  set dumy 1]]
                                  [set dist view_dist / scale]
                                 ]
                           set dist dist + 1
                          ]
                   set angle angle - atan 1 (view_dist / scale * 2)
                  ]
           let ia sum [agent-exposure] of patches with [dumy = 1]
           ask patches with [dumy = 1] [set iVE3 iVE3 + agent-exposure / ia]
           ask patches with [dumy = 1] [set qVE3 qVE3 + agent-exposure]
           ask patch-here [set iVA3 1 / ia]
           ask patch-here [set qVA3 ia]
           ask patches with [dumy = 1] [set agent-exposure 0 set dumy 0] ]
           set prog prog + 1
           die
           ]
 patch-color
 ask patches with [pcolor = black] 
                  [set pcolor scale-color red iVE3 min [iVE3] of patches max [iVE3] of patches]  
end


to get-wall_field
  ct
  cd
  set prog 0
  set prog_total 0
  patch-color
  ask patches [set agent-exposure 0 set access 0 set head_angle 0 set wall_field_dist 0 set wall_field_angle 0]
  ask patches with [pcolor != white and pcolor != blue]
    [ sprout-peds 1 [set shape "person" set color grey set heading 0]]
  set prog_total count peds 
  set scale real-width / world-width

  ask peds [without-interruption
            [let angle 0
             while [angle <= 180]
                    [let dist 1
                     while [dist <= view_dist / scale]
                            [let p patch-right-and-ahead angle dist
                             ask p [ifelse pcolor != blue and pcolor != white 
                                     [if dumy = 0 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                   set dumy 1 set head_angle angle ]]
                                     [set dist view_dist / scale]
                                   ]
                             set dist dist + 1
                           ]
                    set angle angle + atan 1 (view_dist / scale * 2)
                  ]
           set angle 0
           while [angle <= 180]
                  [let dist 1
                   while [dist <= view_dist / scale]
                          [let p patch-left-and-ahead angle dist
                           ask p [ifelse pcolor != blue and pcolor != white 
                                   [if dumy = 0 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                 set dumy 1 set head_angle (- 1) * angle ]]
                                   [ set dist view_dist / scale]
                                 ]
                           set dist dist + 1
                          ]
                   set angle angle + atan 1 (view_dist / scale * 2)
                 ]

           let ia count patches with [dumy = 1]
           ask patches with [dumy = 1] [set i_exposure i_exposure + agent-exposure / ia ]
           ask patches with [dumy = 1] [set q_exposure q_exposure + agent-exposure ]
           ask patches with [dumy = 1] [set t_exposure agent-exposure ]
           ask patches with [dumy = 1 and any? neighbors with [dumy != 1]] [set dumy 2]
           ask patches with [dumy != 0] [set di distance myself]
  
          let dum2 patches with [dumy = 2 and any? neighbors with [pcolor = white]]
          let dum2x sum [pxcor] of dum2 - [pxcor] of patch-here * count dum2
          let dum2y sum [pycor] of dum2 - [pycor] of patch-here * count dum2

          ask patch-here [set wall_field_dist sqrt (dum2x ^ 2 + dum2y ^ 2) / (world-width ^ 2)]
          ifelse dum2x = 0 and dum2y = 0 [ask patch-here [set wall_field_angle 0]]
                                         [ask patch-here [set wall_field_angle atan dum2x dum2y]]
          ask patch-here [sprout-arrows 1 [set shape "dot" set size 0.5 set color white 
                                          ifelse dum2x = 0 and dum2y = 0 [set heading 0]
                                                     [set heading wall_field_angle] pd fd wall_field_dist]]
          ask patches with [dumy != 0] [set agent-exposure 0 set di 0 set dumy 0 set head_angle 0]
         ]
        set prog prog + 1
        die
        ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Dynamic Analysis;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to step_dwg
  ifelse step_direction = true
  [pu
        let ped_heading heading
        let ped_x xcor
        let ped_y ycor
        ask patch-here [sprout-foots 1 [set shape "arrow1" setxy ped_x ped_y set color grey set heading ped_heading]]
  ]
  [pd]
end

  
;;;;;;;;;;;;;;;;;;;;;;;;;Target Walking(Floor Field);;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;Go to the target point;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to target-walking 
  if times > sim-time [stop]
  ifelse any? patches with [pcolor = yellow][entering 
                                             if check-agent-num = ped_num and not any? peds [user-message "No Agent!" stop]]
  [if not any? peds [user-message "No Agent!" stop]]
  if not any? patches with [pcolor = 85] [user-message "No Exits" stop]
  if all? patches [var = 0] [user-message "No Potential field, Do(Click) Potential Field!" stop]  
  if view_dist - view_min_dist < 0 [ user-message "Check View_Dist!" stop]
  if view_angle - view_min_angle < 0 [ user-message "Check View_Angle!" stop]
  check-target-walking
  tick
  ask peds [
            ifelse [pcolor] of patch-here = cyan  
              [ifelse times mod exit_rate = 0 [die][stop]]
              [ifelse any? neighbors with [not any? peds-on self and pcolor != white and pcolor != blue]
                     [face min-one-of neighbors with [not any? peds-on self and pcolor != white and pcolor != blue] [var] 
                      ifelse random 2 = 0 [lt random-float noise] [rt random-float noise]
                      while [[pcolor] of patch-ahead 0.5 = white or [pcolor] of patch-ahead 0.5 = blue] 
                             [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]]
                      ifelse not any? peds-on patch-ahead 1.5 [fd speed] 
                                                              [ask patch-here [set jam_level jam_level + 1] stop]
                     ]
                     [ask patch-here [set jam_level jam_level + 1] stop]
              step_dwg
              ]
           ]
  ask patches [set t_exposure 0]
  set times times + 1
end

to grade
  if not any? patches with [pcolor = 85][user-message "NO EXIT" stop]
  ask patches [set var 0 set var_t 0]
  ask patches with [pcolor = 85] [set var 1 set var_t 1]
  let var_t_t 2
  while [any? patches with [var_t != 0 and any? neighbors with [var = 0 and pcolor = black]]]
         [ask patches with [var_t = var_t_t - 1] 
           [ask neighbors [if var = 0 and pcolor != white and pcolor != blue 
                              [set var_t var_t_t 
                               let temp_grade min-one-of neighbors with [var_t = var_t_t - 1] [var] 
                               set var [var] of temp_grade + distance temp_grade]
                          ]
           ]
          set var_t_t var_t_t + 1
         ]
end

to check-target-walking
  patch-color
  set scale real-width / world-width
  ask patches [set dumy 0]
  ask peds [without-interruption
           [set ped_self 1
            if times mod 5 = 0 [set random_dist random (view_dist - view_min_dist) + view_min_dist
                                set random_angle random (view_angle - view_min_angle) + view_min_angle
                               ]
            let angle view_angle / 2
            set dumy_setting 1
            while [angle > 0]
                  [let dist 0
                   while [dist <= random_dist / scale]
                           [let p patch-right-and-ahead angle dist
                            ask p [if pcolor = blue [set dumy_setting 9]
                                   ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                     [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                               set dumy dumy_setting set head_angle_r angle ]
                                     ]
                                     [set dist view_dist / scale]
                                  ]
                            set dist dist + 1
                           ]
                   set angle angle - atan 1 (view_dist / scale * 2)
                   set dumy_setting 2
                 ]
  
            set angle view_angle / 2
            set dumy_setting 1
            while [angle > 0]
                  [let dist 0
                    while [dist <= random_dist / scale]
                            [let p patch-left-and-ahead angle dist
                             ask p [if pcolor = blue [set dumy_setting 9]
                                    ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                      [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                                set dumy dumy_setting set head_angle_l (- 1) * angle ]
                                      ]
                                      [set dist view_dist / scale]
                                   ] 
                            set dist dist + 1
                           ]
                  set angle angle - atan 1 (view_dist / scale * 2)
                  set dumy_setting 2
                 ]
  
            let ia count patches with [dumy = 1 or dumy = 9]
            ask patches with [dumy != 0] [set i_exposure i_exposure + agent-exposure / ia ] 
            ask patches with [dumy != 0] [set q_exposure q_exposure + agent-exposure ]
            ask patches with [dumy != 0] [set t_exposure t_exposure + agent-exposure ]
            ifelse ia != 0 [ask patch-here [set iDVA 1 / ia]][ask patch-here [set iDVA 1]]
            ask patch-here [set qDVA ia]
            set iso-area count patches with [dumy != 0]
            ask patches with [dumy != 0][set agent-exposure 0 set di 0 set dumy 0 
                                         set head_angle_r 0 set head_angle_l 0 ]
            ask peds [set ped_self 0]
          ]
          ]
  ask patches [if any? peds-on self [set step step + 1]]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Natural Movement;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to Gallery-Walking
  if times > sim-time [stop]
  if not any? peds [user-message "No Agent!" stop]
  if times > sim-time [stop]
  if view_dist - view_min_dist < 0 [ user-message "Check View_Dist!" stop]
  if view_angle - view_min_angle < 0 [ user-message "Check View_Angle!" stop]
  check-gallery-Walking
  tick
  ask patches [set t_exposure 0]
  set times times + 1
end

to check-Gallery-Walking
  patch-color
  set scale real-width / world-width
  ask patches [set dumy 0 set di 0]
  
  ask peds [without-interruption
           [set ped_self 1
            if times mod 5 = 0 [set random_dist random (view_dist - view_min_dist) + view_min_dist
                                set random_angle random (view_angle - view_min_angle) + view_min_angle
                               ]
           let angle random_angle / 2

           set dumy_setting 1
           while [angle > 0]
                 [let dist 0
                  while [dist <= random_dist / scale]
                        [let p patch-right-and-ahead angle dist
                         ask p [if pcolor = blue [set dumy_setting 9]
                                ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                          set dumy dumy_setting set head_angle_r angle ]]
                                [set dist view_dist / scale]
                               ]
                         set dist dist + 1
                       ]
                 set angle angle - atan 1 (view_dist / scale * 2)
                 set dumy_setting 2
               ]
  
          set angle view_angle / 2
          set dumy_setting 1
          while [angle > 0]
                [let dist 0
                 while [dist <= random_dist / scale]
                       [let p patch-left-and-ahead angle dist
                        ask p [if pcolor = blue [set dumy_setting 9]
                               ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                               [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                         set dumy dumy_setting set head_angle_l (- 1) * angle ]]
                               [set dist view_dist / scale]
                              ]
                        set dist dist + 1
                       ]
                set angle angle - atan 1 (view_dist / scale * 2)
                set dumy_setting 2
               ]
  
       let ia count patches with [dumy != 0]
       ask patches with [dumy != 0] [set i_exposure i_exposure + agent-exposure / ia ]
       ask patches with [dumy != 0] [set q_exposure q_exposure + agent-exposure ]

       ifelse ia != 0 [ask patch-here [set iDVA 1 / ia]][ask patch-here [set iDVA 1]]
       ask patch-here [set qDVA ia]
       ask patches with [dumy != 0] [set t_exposure t_exposure + agent-exposure ]

       ask patches with [(dumy = 2) and any? neighbors with [pcolor = white or pcolor = blue]] [set dumy 3]
       ask patches with [(dumy = 2) and distance myself > view_dist / 2 and any? neighbors with [any? peds-here]] [set dumy 3]
  
       ask patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = brown)] [set di distance myself]
  
       ifelse any? patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = brown)] 
              and  max [di] of patches with [(dumy != 0 and dumy != 9) 
              or (dumy != 0 and pcolor = brown)] != 0 
              [let cog-max-dist max [di] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = brown)]
               ask patches with [dumy != 0 and pcolor = brown] [set di cog-max-dist * attraction_factor]
               ask patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = brown)] 
                                 [set head_angle_r head_angle_r * (di / cog-max-dist) 
                                  set head_angle_l head_angle_l * (di / cog-max-dist)]
              ]
              [ask patches with [dumy != 0] [set head_angle_r 0 set head_angle_l 0]]
  
       let ia2_r count patches with [(dumy = 3 and head_angle_r != 0) or (dumy != 0 and pcolor = brown)]
       let ia2_l count patches with [(dumy = 3 and head_angle_l != 0) or (dumy != 0 and pcolor = brown)]
       let ha 0
       let ah 0
       ifelse any? patches with [dumy = 3 
                                 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]] 
                                 or any? patches with [dumy != 0 and pcolor = brown]
               [set cog_convex 0
                set ha sum [head_angle_r] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)] 
                     + sum [head_angle_l] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)]
                if ia2_r + ia2_l != 0 [set ah ha / (ia2_r + ia2_l)]
               ]
               [if cog_convex = 0 and any? patches with [dumy = 1] 
                  [ifelse occlude_memory >= 0 [set cog_convex 1][set cog_convex 2]]
                if cog_convex = 1 and ia2_r != 0 [set ah sum [head_angle_r] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)] 
                                                         / ia2_r * (2 * speed)]
                if cog_convex = 2 and ia2_l != 0 [set ah sum [head_angle_l] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)] 
                                                         / ia2_l * (2 * speed)]
               ]

        ifelse any? patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]]
                [let gate_patch one-of patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]]
                 set occlude_memory [head_angle_r] of gate_patch + [head_angle_l] of gate_patch]
                [if any? patches with [dumy = 1] [set occlude_memory [head_angle_r] of max-one-of patches with [dumy = 1] [distance myself] 
                                                                  +  [head_angle_l] of max-one-of patches with [dumy = 1] [distance myself]
                                                 ]
                ]
  
        ifelse count patches with [dumy != 0] <= 5 
          [ifelse any? patches with [dumy = 1] [face max-one-of patches with [dumy = 1] [distance myself]]
                                               [ifelse random 2 = 0 [lt 90] [rt 90]]]
          [set heading heading + ah] 

        set iso-area count patches with [dumy != 0]
        ask patches with [dumy != 0][set agent-exposure 0 set di 0 set dumy 0 set head_angle_r 0 set head_angle_l 0 ]
        ask peds [set ped_self 0]
       ]

        while [[pcolor] of patch-ahead 1 = white or [pcolor] of patch-ahead 1 = blue ] 
              [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]]
        ifelse not any? peds-on patch-ahead 1.5  [fd speed] [ask patch-here [set jam_level jam_level + 1] 
        while [any? peds-on patch-ahead 1.5] [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]]]
        ifelse random 2 = 1 [lt random-float noise] [rt random-float noise]
        if times mod 8 = 0 [set cog_convex 0]
        step_dwg
      ]
 
  ask patches [if any? peds-on self [set step step + 1]]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Natural Movement to Target;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to Target_Gallery-Walking
  if times > sim-time [stop]
  ifelse any? patches with [pcolor = yellow][entering 
                                             if check-agent-num = ped_num and not any? peds [user-message "No Agent!" stop]]
  [if not any? peds [user-message "No Agent!" stop]]
  if all? patches [var = 0] [user-message "No Potential field, Do(Click) Potential Field!" stop] 
  if view_dist - view_min_dist < 0 [ user-message "Check View_Dist!" stop]
  if view_angle - view_min_angle < 0 [ user-message "Check View_Angle!" stop]
  if times > sim-time [stop]
  check-Target_Gallery-Walking
  tick
  ask patches [set t_exposure 0]
  set times times + 1
end

to entering
  if check-agent-num != ped_num [if times mod enter_rate = 0 [ask one-of patches with [pcolor = yellow] 
                          [sprout-peds 1 [set shape "head" set size 1 set check-agent-num check-agent-num + 1]
                          ]]]                          
end  

to check-Target_Gallery-Walking
  patch-color
  set scale real-width / world-width
  ask patches [set dumy 0 set di 0]
  
  ask peds [without-interruption 
           [set ped_self 1
            if times mod 5 = 0 [set random_dist random (view_dist - view_min_dist) + view_min_dist
                                set random_angle random (view_angle - view_min_angle) + view_min_angle
                               ]
            let angle random_angle / 2
            set dumy_setting 1
            while [angle > 0]
                  [let dist 0
                   while [dist <= random_dist / scale]
                         [let p patch-right-and-ahead angle dist
                          ask p [if pcolor = blue [set dumy_setting 9]
                                 ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                   [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                             set dumy dumy_setting set head_angle_r angle ]]
                                   [set dist view_dist / scale]
                                ]
                          set dist dist + 1
                         ]
                 set angle angle - atan 1 (view_dist / scale * 2)
                 set dumy_setting 2
                ]
  
          set angle random_angle / 2
          set dumy_setting 1
          while [angle > 0]
                [let dist 0
                 while [dist <= random_dist / scale]
                       [let p patch-left-and-ahead angle dist
                        ask p [if pcolor = blue [set dumy_setting 9]
                               ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                 [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                           set dumy dumy_setting set head_angle_l (- 1) * angle ]]
                                 [set dist view_dist / scale]
                              ]
                        set dist dist + 1
                       ]
                set angle angle - atan 1 (view_dist / scale * 2)
                set dumy_setting 2
               ]
  
        let ia count patches with [dumy != 0]
        ask patches with [dumy != 0] [set i_exposure i_exposure + agent-exposure / ia ]
        ask patches with [dumy != 0] [set q_exposure q_exposure + agent-exposure ]
        ifelse ia != 0 [ask patch-here [set iDVA 1 / ia]][ask patch-here [set iDVA 1]]
        ask patch-here [set qDVA ia]
        ask patches with [dumy != 0] [set t_exposure t_exposure + agent-exposure ]
  
        ask patches with [(dumy = 2) and any? neighbors with [pcolor = white or pcolor = blue]] [set dumy 3]
             ifelse any? patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and dumy != 9 and pcolor = cyan)]
                                  and max [var] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)] 
                                    - min [var] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)] != 0 
                                 [let cog-max-var max [var] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)]
                                  let cog-min-var min [var] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)]
                                  ask patches with [dumy != 0 and pcolor = brown] [set var cog-min-var * attraction_factor]
                                  ask patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)] 
                                      [set head_angle_r head_angle_r * (1 - (var - cog-min-var) / (cog-max-var - cog-min-var))
                                       set head_angle_l head_angle_l * (1 - (var - cog-min-var) / (cog-max-var - cog-min-var))]
                                 ]
                                 [ask patches with [dumy != 0] [set head_angle_r 0 set head_angle_l 0]]
  
        let ia2_r count patches with [(dumy = 3 and head_angle_r != 0) or (dumy != 0 and pcolor = cyan)]
        let ia2_l count patches with [(dumy = 3 and head_angle_l != 0) or (dumy != 0 and pcolor = cyan)]
        let ha 0
        let ah 0  
        
        ifelse any? patches with [dumy != 0 and dumy != 9 and pcolor = cyan] 
            [face one-of patches with [dumy != 0 and dumy != 9 and pcolor = cyan]]
            [ifelse any? patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]] 
                                  or any? patches with [dumy != 0 and dumy != 9 and pcolor = cyan]
              [set cog_convex 0
               set ha sum [head_angle_r] of patches with [(dumy = 3) or (dumy != 0 and pcolor = cyan)] 
                    + sum [head_angle_l] of patches with [(dumy = 3) or (dumy != 0 and pcolor = cyan)]
               if ia2_r + ia2_l != 0 [set ah ha / (ia2_r + ia2_l)]
              ]
              [if cog_convex = 0 and any? patches with [dumy = 1] 
                  [ifelse occlude_memory >= 0 [set cog_convex 1][set cog_convex 2]]
               if cog_convex = 1 and ia2_r != 0 
                  [set ah sum [head_angle_r] of patches with [(dumy = 3) or (dumy != 0 and pcolor = cyan)] / ia2_r * (2 * speed)]
               if cog_convex = 2 and ia2_l != 0 
                  [set ah sum [head_angle_l] of patches with [(dumy = 3) or (dumy != 0 and pcolor = cyan)] / ia2_l * (2 * speed)]
              ]
            ]

       ifelse any? patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]]
              [let gate_patch one-of patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]]
               set occlude_memory [head_angle_r] of gate_patch + [head_angle_l] of gate_patch
              ]
              [if any? patches with [dumy = 1] [set occlude_memory [head_angle_r] of max-one-of patches with [dumy = 1] [distance myself] 
                                                                +  [head_angle_l] of max-one-of patches with [dumy = 1] [distance myself]]
              ]
              
  
      ifelse count patches with [dumy != 0] <= 5 and not any? patches with [dumy != 0 and pcolor = cyan] 
             [ifelse any? patches with [dumy = 1] [face max-one-of patches with [dumy = 1] [distance myself]]
                                                  [ifelse random 2 = 0 [lt 90] [rt 90]]
             ]
             [set heading heading + ah] 
            
 
      set iso-area count patches with [dumy != 0]
      ask patches with [dumy != 0][set agent-exposure 0 set di 0 set dumy 0 set head_angle_r 0 set head_angle_l 0 ]
      ask peds [set ped_self 0]
      ]

      while [[pcolor] of patch-ahead speed = white or [pcolor] of patch-ahead speed = blue ] 
            [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]]
      ifelse not any? peds-on patch-ahead 1.415 
            [if [pcolor] of patch-here = cyan [ifelse times mod exit_rate = 0 [die][stop]] fd speed] 
            [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]ask patch-here [set jam_level jam_level + 1]                  
            ]
      ifelse random 2 = 1 [lt random-float noise] [rt random-float noise]
      if times mod 8 = 0 [set cog_convex 0]
      step_dwg

      ]
 
   ask patches [if any? peds-on self [set step step + 1]]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Natural Movement by Memory;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to Gallery-Walking_Momory
  if not any? peds [user-message "No Agent!" stop]
  if times > sim-time [stop]
  if view_dist - view_min_dist < 0 [ user-message "Check View_Dist!" stop]
  if view_angle - view_min_angle < 0 [ user-message "Check View_Angle!" stop]
  check-gallery-Walking_Memory
  tick
  ask patches [set t_exposure 0]
  set times times + 1
end

to check-Gallery-Walking_Memory
  patch-color
  set scale real-width / world-width
  ask patches [set dumy 0 set di 0]
  
  ask peds [without-interruption
           [set ped_self 1
            if times mod 5 = 0 [set random_dist random (view_dist - view_min_dist) + view_min_dist
                                set random_angle random (view_angle - view_min_angle) + view_min_angle
                               ]
           let angle random_angle / 2
           set dumy_setting 1
           while [angle > 0]
                 [let dist 0
                  while [dist <= random_dist / scale]
                        [let p patch-right-and-ahead angle dist
                         ask p [if pcolor = blue [set dumy_setting 9]
                               ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                  [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                            set dumy dumy_setting set head_angle_r angle ]]
                                  [set dist view_dist / scale] 
                               ]
                         set dist dist + 1
                        ]
    
                 set angle angle - atan 1 (view_dist / scale * 2)
                 set dumy_setting 2
                ]
  
                 set angle view_angle / 2
                 set dumy_setting 1
                 while [angle > 0]
                       [let dist 0
                        while [dist <= random_dist / scale]
                              [let p patch-left-and-ahead angle dist
                               ask p [if pcolor = blue [set dumy_setting 9]
                                      ifelse pcolor != white and not any? peds-here with [ped_self != 1]
                                        [if dumy = 0 or dumy = 2 [set agent-exposure 1 - (distance myself * scale / view_dist) 
                                                                  set dumy dumy_setting set head_angle_l (- 1) * angle ]]
                                        [set dist view_dist / scale]
                                     ]
                               set dist dist + 1
                              ]
                       set angle angle - atan 1 (view_dist / scale * 2)
                       set dumy_setting 2
                      ]
  
                let ia count patches with [dumy != 0]

                ask patches with [dumy != 0] [set i_exposure i_exposure + agent-exposure / ia ]
                ask patches with [dumy != 0] [set q_exposure q_exposure + agent-exposure ]
                ifelse ia != 0 [ask patch-here [set iDVA 1 / ia]][ask patch-here [set iDVA 1]]
                ask patch-here [set qDVA ia]
                ask patches with [dumy != 0] [set t_exposure t_exposure + agent-exposure ]
  
                ask patches with [(dumy = 2) and any? neighbors with [pcolor = white or pcolor = blue]] [set dumy 3]
                ask patches with [(dumy = 2) and distance myself > view_dist / 2 and any? neighbors with [any? peds-here]] [set dumy 3]
  
                ask patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = brown)] [set di distance myself]
  
               ifelse any? patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)] 
                                         and max [q_exposure] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)]
                                           - min [q_exposure] of patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)] != 0 
                                        [let cog-max-q_exposure max [q_exposure] of patches with [(dumy != 0 and dumy != 9) 
                                                                     or (dumy != 0 and pcolor = brown)]
                                         let cog-min-q_exposure min [q_exposure] of patches with [(dumy != 0 and dumy != 9) 
                                                                     or (dumy != 0 and pcolor = brown)]
                                        ask patches with [dumy != 0 and pcolor = brown] 
                                                          [set q_exposure cog-min-q_exposure * attraction_factor]
                                         ask patches with [(dumy != 0 and dumy != 9) or (dumy != 0 and pcolor = cyan)]
                                                          [set head_angle_r head_angle_r * (1 - (q_exposure - cog-min-q_exposure) 
                                                                                           / (cog-max-q_exposure - cog-min-q_exposure)) 
                                         set head_angle_l head_angle_l * (1 - (q_exposure - cog-min-q_exposure) 
                                                                                           / (cog-max-q_exposure - cog-min-q_exposure))]
                                        ]
                                        [ask patches with [dumy != 0] [set head_angle_r 0 set head_angle_l 0]]
  
               let ia2_r count patches with [(dumy = 3 and head_angle_r != 0) or (dumy != 0 and pcolor = brown)]
               let ia2_l count patches with [(dumy = 3 and head_angle_l != 0) or (dumy != 0 and pcolor = brown)]
               let ha 0
               let ah 0
               ifelse any? patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]] 
                                         or any? patches with [dumy != 0 and pcolor = brown]
                                        [set cog_convex 0
                                         set ha sum [head_angle_r] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)] 
                                              + sum [head_angle_l] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)]
                                         if ia2_r + ia2_l != 0 [set ah ha / (ia2_r + ia2_l)]
                                        ]
                                        [if cog_convex = 0 and any? patches with [dumy = 1]
                                            [ifelse occlude_memory >= 0  [set cog_convex 1][set cog_convex 2]]
                                         if cog_convex = 1 and ia2_r != 0 
                                            [set ah sum [head_angle_r] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)] 
                                                    / ia2_r * (2 * speed)]
                                         if cog_convex = 2 and ia2_l != 0 
                                            [set ah sum [head_angle_l] of patches with [(dumy = 3) or (dumy != 0 and pcolor = brown)] 
                                                    / ia2_l * (2 * speed)]
                                        ]

              ifelse any? patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]]
                   [let gate_patch one-of patches with [dumy = 3 and any? neighbors4 with [pcolor = black and (dumy = 0 or dumy = 9)]]
                     set occlude_memory [head_angle_r] of gate_patch + [head_angle_l] of gate_patch
                   ]
                   [if any? patches with [dumy = 1] [set occlude_memory [head_angle_r] of max-one-of patches with [dumy = 1] [distance myself] 
                                                                     +  [head_angle_l] of max-one-of patches with [dumy = 1] [distance myself]]
                   ]
  
             ifelse count patches with [dumy != 0] <= 5 
                   [ifelse any? patches with [dumy = 1] [face max-one-of patches with [dumy = 1] [distance myself]]
                                                        [ifelse random 2 = 0 [lt 90] [rt 90]]]
                   [set heading heading + ah] 

             set iso-area count patches with [dumy != 0]
   
             ask patches with [dumy != 0][set agent-exposure 0 set di 0 set dumy 0 set head_angle_r 0 set head_angle_l 0 ]
             ask peds [set ped_self 0]
           ]

            while [[pcolor] of patch-ahead 1 = white or [pcolor] of patch-ahead 1 = blue ]
                  [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]]
           ifelse not any? peds-on patch-ahead 1.5  [fd speed] [ask patch-here [set jam_level jam_level + 1] 
           while [any? peds-on patch-ahead 1.5] [ifelse random 2 = 0 [lt random-float 30] [rt random-float 30]]]
           ifelse random 2 = 1 [lt random-float noise] [rt random-float noise]
           if times mod 8 = 0 [set cog_convex 0]
           step_dwg
          ]
   ask patches [if any? peds-on self [set step step + 1]]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Virture_Tester;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to set-testee
  set-initial
  convert-color
  if not any? patches with [pcolor = yellow] [user-message "No Entrance. Paint yellow at staring patch!" stop]
  ask one-of patches with [pcolor = yellow] [sprout-peds 1 [set shape "head" set heading testee_heading set color 19.9]]
  ask patches with [pcolor = white] [sprout-walls 1 [set shape "square" set size 1.1 set heading 0 set color 27]]
  ask patches with [pcolor = white] [set pcolor 0.01]
  ride ped 0
  set-pictures
end

to convert-color
  reset-perspective
  ask patches with [pcolor = white or pcolor = 0.01][set pcolor white]
  ask patches with [pcolor = 0.02 or pcolor = 19.8][set pcolor brown]
  patch-color
  ask turtles[show-turtle]
  ask walls [die]
end

to set-pictures
  set shape-list nobody
  set shape-list [ "number 1"]
  ask patches with [pcolor = brown] [sprout-pictures 1 [set shape one-of shapes set size 0.1] set pcolor 0.02]
  ask pictures [if any? neighbors4 with [pcolor = 0.01] [face one-of neighbors4 with [pcolor = 0.01] fd 0.4]]
end

to start
ifelse mouse-down?
[if timer > 0.1 
[if timer > 0.2 / speed [
ask ped 0 [facexy mouse-xcor mouse-ycor] test-walking reset-timer] ]
] [reset-timer]
end

to Test-Walking
  if times > sim-time [user-message (word "Your Test is over. Thank you!") ask ped 0 [die] stop]

  ask peds [
  ifelse [pcolor] of patch-ahead speed = 0.01 or [pcolor] of patch-ahead speed = blue [fd -1 * speed][fd speed] 
  ask peds-on patches [set step step + 1]
  ]
   ask patches with [pcolor = 0.02][set pcolor 19.8]
   ask patches with [pcolor != blue and pcolor != 0.01 and pcolor != 85 and pcolor != 35 and pcolor != green and pcolor != 19.8] [set pcolor 19.9]
   
  check-Test-Walking
  ask patches [set t_exposure 0]
  set times times + 1
end

to check-Test-Walking
  ask walls [show-turtle]
  ask pictures [show-turtle]

  set scale real-width / world-width
  ask patches [set dumy 0 set di 0]
 
  ask peds [without-interruption
  [let angle 0
  while [angle <= view_angle / 2]
  [let dist 1
   while [dist <= view_dist / scale]
      [let p patch-right-and-ahead angle dist
      ask p [ifelse pcolor != blue and pcolor != 0.01 [if dumy = 0 [set agent-exposure 1 - (distance myself * scale / view_dist) set dumy 1 ]]
            [ set dist view_dist / scale]
            ]
      set dist dist + 1
      ]
  set angle angle + atan 1 (view_dist / scale * 2)
  ]
  
  set angle 0
  while [angle <= view_angle / 2]
  [let dist 1
   while [dist <= view_dist / scale]
      [let p patch-left-and-ahead angle dist
      ask p [ifelse pcolor != blue and pcolor != 0.01 [if dumy = 0 [set agent-exposure 1 - (distance myself * scale / view_dist) set dumy 1 ]]
            [ set dist view_dist / scale]
            ]
      set dist dist + 1
      ]
  set angle angle + atan 1 (view_dist / scale * 2)
  ]
  
  let ia count patches with [dumy = 1]

  ask patches with [dumy = 1] [set i_exposure i_exposure + agent-exposure / ia ]
  ask patches with [dumy = 1] [set q_exposure q_exposure + agent-exposure ]
  ask patches with [dumy = 1] [set t_exposure agent-exposure ]

  set iso-area count patches with [dumy != 0]
    
  ask walls [if not any? neighbors4 with [dumy != 0] [hide-turtle]]
  ask pictures [if not any? neighbors4 with [dumy != 0] [hide-turtle]]

  ask patches with [pcolor != blue and pcolor != 0.01 and pcolor != 85 and pcolor != 35 and pcolor != green and pcolor != 19.8 and dumy = 0] [set pcolor black]
  ask patches with [dumy = 0 and pcolor = 19.8][set pcolor 0.02]
  
  ask patches with [dumy != 0] [set agent-exposure 0 set di 0 set dumy 0]
  ]
  step_dwg
  ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Analysis Display;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to show-spectrum
cd
patch-color
ask spectrums [die]
ask peds [die]
ask vectors [die]
ask arrows [die]
ask spectrums [die]
ask walls [die]
ask pictures [die]

if Analysis_Type = "Isovist"
   [ifelse any? patches with [Isovist != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red Isovist min [Isovist] of patches max [Isovist] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "VE I"
   [ifelse any? patches with [VE1 != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red VE1 min [VE1] of patches max [VE1] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "VE II"
   [ifelse any? patches with [VE2 != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red VE2 min [VE2] of patches max [VE2] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iVE III"
   [ifelse any? patches with [iVE3 != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red iVE3 min [iVE3] of patches max [iVE3] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qVE III"
   [ifelse any? patches with [qVE3 != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red qVE3 min [qVE3] of patches max [qVE3] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qVA III"
   [ifelse any? patches with [qVA3 != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red qVA3 min [qVA3] of patches max [qVA3] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iVA III"
   [ifelse any? patches with [iVA3 != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red iVA3 min [iVA3] of patches max [iVA3] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iDVE"
   [ifelse any? patches with [i_exposure != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red i_exposure min [i_exposure] of patches max [i_exposure] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qDVE"
   [ifelse any? patches with [q_exposure != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red q_exposure min [q_exposure] of patches max [q_exposure] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iDVA"
   [ifelse any? patches with [iDVA != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red iDVA min [iDVA] of patches max [iDVA] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qDVA"
   [ifelse any? patches with [qDVA != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red qDVA min [qDVA] of patches max [qDVA] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Steps"
   [ifelse any? patches with [Step != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red Step min [Step] of patches max [Step] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Wall_Field"
   [ifelse any? patches with [wall_field_dist != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red wall_field_dist min [wall_field_dist] of patches max [wall_field_dist] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "View from Agent(s)"
   [ifelse any? patches with [VfT != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red VfT min [VfT] of patches max [VfT] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Potential Field"
   [ifelse any? patches with [var != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red var min [var] of patches max [var] of patches]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Jam_Level"
   [ifelse any? patches with [jam_level != 0] 
   [ask patches with [pcolor = black] 
   [set pcolor scale-color red jam_level min [jam_level] of patches max [jam_level] of patches]]
   [user-message "No Results of Analysis"]]
end

to show-monochrome
cd
ask peds [die]
ask vectors [die]
ask arrows [die]
ask spectrums [die]
ask walls [die]
ask pictures [die]
ask spectrums [die]
patch-color

if Analysis_Type = "Isovist"
  [ifelse any? patches with [isovist != 0] 
    [cd ask patches with [pcolor != blue and isovist != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([isovist] of patch-here - min [isovist] of patches with [isovist != 0]) 
                            / (max [isovist] of patches with [(pcolor = black or pcolor = brown) and isovist != 0] 
                             - min [isovist] of patches with [(pcolor = black or pcolor = brown) and isovist != 0])
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "VE I"
  [ifelse any? patches with [VE1 != 0] 
    [cd ask patches with [pcolor != blue and VE1 != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([VE1] of patch-here - min [VE1] of patches with [VE1 != 0]) 
                            / (max [VE1] of patches with [(pcolor = black or pcolor = brown) and VE1 != 0] 
                             - min [VE1] of patches with [(pcolor = black or pcolor = brown) and VE1 != 0])
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "VE II"
  [ifelse any? patches with [VE2 != 0] 
    [ask patches with [pcolor != blue and VE2 != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([VE2] of patch-here - min [VE2] of patches with [VE2 != 0]) 
                            / (max [VE2] of patches with [(pcolor = black or pcolor = brown) and VE2 != 0] 
                             - min [VE2] of patches with [(pcolor = black or pcolor = brown) and VE2 != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iVE III"
  [ifelse any? patches with [iVE3 != 0] 
    [ask patches with [pcolor != blue and iVE3 != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([iVE3] of patch-here - min [iVE3] of patches with [iVE3 != 0]) 
                            / (max [iVE3] of patches with [(pcolor = black or pcolor = brown) and iVE3 != 0] 
                             - min [iVE3] of patches with [(pcolor = black or pcolor = brown) and iVE3 != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qVE III"
  [ifelse any? patches with [qVE3 != 0] 
    [ask patches with [pcolor != blue and qVE3 != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([qVE3] of patch-here - min [qVE3] of patches with [qVE3 != 0]) 
                            / (max [qVE3] of patches with [(pcolor = black or pcolor = brown) and qVE3 != 0] 
                             - min [qVE3] of patches with [(pcolor = black or pcolor = brown) and qVE3 != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iVA III"
  [ifelse any? patches with [iVA3 != 0] 
    [ask patches with [pcolor != blue and qVA3 != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([iVA3] of patch-here - min [iVA3] of patches with [iVA3 != 0]) 
                            / (max [iVA3] of patches with [(pcolor = black or pcolor = brown) and iVA3 != 0] 
                             - min [iVA3] of patches with [(pcolor = black or pcolor = brown) and iVA3 != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qVA III"
  [ifelse any? patches with [qVA3 != 0] 
    [ask patches with [pcolor != blue and qVA3 != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([qVA3] of patch-here - min [qVA3] of patches with [qVA3 != 0]) 
                            / (max [qVA3] of patches with [(pcolor = black or pcolor = brown) and qVA3 != 0] 
                             - min [qVA3] of patches with [(pcolor = black or pcolor = brown) and qVA3 != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iDVE"
  [ifelse any? patches with [i_exposure != 0]
    [cd ask patches with [pcolor != blue and i_exposure != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([i_exposure] of patch-here - min [i_exposure] of patches with [i_exposure != 0])
                                 / (max [i_exposure] of patches with [(pcolor = black or pcolor = brown) and i_exposure != 0] 
                                 - min [i_exposure] of patches with [(pcolor = black or pcolor = brown) and i_exposure != 0])
                                 * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qDVE"
  [ifelse any? patches with [q_exposure != 0] 
    [ask patches with [pcolor != blue and q_exposure != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([q_exposure] of patch-here - min [q_exposure] of patches with [q_exposure != 0])
                            / (max [q_exposure] of patches with [q_exposure != 0] 
                             - min [q_exposure] of patches with [q_exposure != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "iDVA"
  [ifelse any? patches with [iDVA != 0] 
    [cd ask patches with [pcolor != blue and iDVA != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([iDVA] of patch-here - min [iDVA] of patches with [iDVA != 0]) 
                            / (max [iDVA] of patches with [(pcolor = black or pcolor = brown) and iDVA != 0] 
                             - min [iDVA] of patches with [(pcolor = black or pcolor = brown) and iDVA != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "qDVA"
  [ifelse any? patches with [qDVA != 0] 
    [ask patches with [pcolor != blue or qDVA != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([qDVA] of patch-here - min [qDVA] of patches with [qDVA != 0]) 
                            / (max [qDVA] of patches with [(pcolor = black or pcolor = brown) and qDVA != 0] 
                             - min [qDVA] of patches with [(pcolor = black or pcolor = brown) and qDVA != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Steps"
  [ifelse any? patches with [Step != 0] 
    [cd ask patches with [pcolor != blue and step != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey
                         set size ([Step] of patch-here - min [Step] of patches with [step != 0])
                            / (max [Step] of patches with [(pcolor = black or pcolor = brown) and step != 0] 
                             - min [Step] of patches with [(pcolor = black or pcolor = brown) and step != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Wall_Field"
  [ifelse any? patches with [wall_field_dist != 0] 
    [ask patches with [pcolor != white or pcolor != blue]
    [sprout-arrows 1 [set shape "dot" set size 0.5 set color white set heading wall_field_angle pd fd wall_field_dist]]]
    [user-message "No Results of Analysis"]]
if Analysis_Type = "View from Agent(s)"
  [ifelse any? patches with [VfT != 0] 
    [ask patches with [pcolor != blue and VfT != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([VfT] of patch-here - min [VfT] of patches with [VfT != 0]) 
                            / (max [VfT] of patches with [(pcolor = black or pcolor = brown) and VfT != 0]
                             - min [VfT] of patches with [(pcolor = black or pcolor = brown) and VfT != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Potential Field"
  [ifelse any? patches with [var != 0] 
    [ask patches with [pcolor = black or pcolor = brown or pcolor = 85 and var != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([var] of patch-here - min [var] of patches with [var != 0]) 
                            / (max [var] of patches with [(pcolor = black or pcolor = brown) and var != 0] 
                             - min [var] of patches with [(pcolor = black or pcolor = brown) and var != 0]) 
                             * (1 - dot-size) + dot-size ]]]
   [user-message "No Results of Analysis"]]
if Analysis_Type = "Jam_Level"
  [ifelse any? patches with [jam_level != 0] 
    [ifelse (max [jam_level] of patches with [(pcolor = black or pcolor = brown) and jam_level != 0] 
                             - min [jam_level] of patches with [(pcolor = black or pcolor = brown) and jam_level != 0]) != 0                      
    [ask patches with [pcolor != blue and jam_level != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size ([jam_level] of patch-here - min [jam_level] of patches with [jam_level != 0]) 
                            / (max [jam_level] of patches with [(pcolor = black or pcolor = brown) and jam_level != 0] 
                             - min [jam_level] of patches with [(pcolor = black or pcolor = brown) and jam_level != 0]) 
                             * (1 - dot-size) + dot-size ]]]
    [ask patches with [pcolor != blue and jam_level != 0]
    [sprout-spectrums 1 [set shape "circle" set color grey 
                         set size 1]]]
    ]
  [user-message "No Results of Analysis"]]
end


  
@#$#@#$#@
GRAPHICS-WINDOW
875
6
1343
495
-1
-1
14.8
1
10
1
1
1
0
0
0
1
0
30
0
30
0
0
1
ticks
50.0

BUTTON
195
50
355
83
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
195
240
280
273
Edit-DWG
draw-env
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
465
50
520
83
Set
set-ped
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
375
130
520
163
view_dist
view_dist
5
200
30
1
1
m
HORIZONTAL

SLIDER
375
210
520
243
view_angle
view_angle
30
360
120
1
1
˚
HORIZONTAL

SLIDER
375
50
467
83
ped_num
ped_num
1
100
5
1
1
NIL
HORIZONTAL

BUTTON
15
85
175
118
Import Image
set file-name user-file\nifelse file-name = false [stop]\n[import-pcolors file-name\n\nask patches [if pcolor mod 10 > 9 [set pcolor white]]\nask patches with [ 92 < pcolor and pcolor < 97] [set pcolor blue]\nask patches with [ 82 < pcolor and pcolor < 87] [set pcolor cyan]\nask patches with [ 32 < pcolor and pcolor < 37] [set pcolor brown]\nask patches with [ 42 < pcolor and pcolor < 47] [set pcolor yellow]\npatch-color\n]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
280
240
355
273
Clear All
;; (for this model to work with NetLogo's new plotting features,\n  ;; __clear-all-and-reset-ticks should be replaced with clear-all at\n  ;; the beginning of your setup procedure and reset-ticks at the end\n  ;; of the procedure.)\n  __clear-all-and-reset-ticks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
95
50
175
83
Export File
export-world word user-input \"file name?\" \".csv\"
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
15
50
95
83
Import File
set file-name user-file\nifelse file-name = false [stop][import-world file-name]\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
195
130
355
163
real-width
real-width
0
1000
30
1
1
m
HORIZONTAL

BUTTON
540
310
690
343
Navigational Movement
Target-Walking
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
195
355
355
388
Move_ped
 if not mouse-clicked and mouse-down?\n      [ifelse timer <= .25\n         [set mouse-double-click true ]\n         [set mouse-double-click false]\n       reset-timer\n       set mouse-clicked true\n       if any? turtles-on patch round mouse-xcor round mouse-ycor\n         [set clicked-turtle one-of turtles-on patch round mouse-xcor round mouse-ycor]\n       ]\n\n  if is-agent? clicked-turtle and not mouse-double-click\n      [ask clicked-turtle [ setxy mouse-xcor mouse-ycor ]]\n    \n    \n  if mouse-clicked and not mouse-down?\n      [set mouse-clicked false\n       if is-agent? clicked-turtle\n       [ set clicked-turtle nobody]\n      ]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
540
35
690
53
■ Static Analysis
12
0.0
1

BUTTON
540
380
690
413
Natural Movement
gallery-Walking
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
195
35
350
61
■ Setting Environment
12
0.0
1

TEXTBOX
195
225
330
243
■ Edit Environment
12
0.0
1

TEXTBOX
195
95
345
113
■ Setting Real Distance
12
0.0
1

TEXTBOX
375
35
550
53
■ Agents Number
12
0.0
1

TEXTBOX
374
114
524
132
→ Visual Field
12
0.0
1

TEXTBOX
195
340
345
358
■ Move Ped's Position
12
0.0
1

TEXTBOX
195
390
340
430
Click Move_ped and drag agent to move. When finished, click again (release)!
10
0.0
1

CHOOSER
710
50
860
95
Analysis_Type
Analysis_Type
"View from Agent(s)" "Isovist" "VE I" "VE II" "iVA III" "qVA III" "iVE III" "qVE III" "Wall_Field" "Potential Field" "iDVE" "qDVE" "iDVA" "qDVA" "Steps" "Jam_Level"
1

BUTTON
710
95
785
128
Spectrum
Show-Spectrum
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
540
170
690
188
■ Dynamic Analysis
12
0.0
1

TEXTBOX
545
185
660
203
→ Simulation Time
12
0.0
1

TEXTBOX
545
280
685
311
To run Navi. Movement, \nFirst click [Potential Field]!
10
0.0
1

BUTTON
15
220
175
253
NIL
make-movie
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
15
160
120
186
■ Make a Movie
12
0.0
1

PLOT
15
255
175
375
Time-V.Access
time
qDVA
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"Access" 1.0 0 -2674135 true "" "if is-turtle? ped 0 [plot [iso-area] of ped 0]"

BUTTON
785
95
860
128
Mono
Show-Monochrome
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
750
185
805
218
grid-on
ask grids [die]\nask patches\n    [ sprout-grids 1 [set shape \"rectangle\" set heading 0 set size 1.1 set color grey]]\nask patches\n    [ sprout-grids 1 [set shape \"dot\" set heading 0 set size 0.3 set color black]]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
805
185
860
218
grid-off
ask grids [die]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
710
35
860
53
■ Display the Results
12
0.0
1

SLIDER
750
145
860
178
dot-size
dot-size
0
1
0.25
0.05
1
NIL
HORIZONTAL

SLIDER
195
460
355
493
attraction_factor
attraction_factor
0
10
3
1
1
NIL
HORIZONTAL

TEXTBOX
195
445
350
463
■ Level of Attractor
12
0.0
1

TEXTBOX
200
110
350
128
- Real hor. dist. in display
12
4.0
1

TEXTBOX
750
130
860
148
→ Mono. Dot Size 
12
0.0
1

TEXTBOX
185
35
200
490
I\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\n
12
0.0
1

TEXTBOX
365
35
380
490
I\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI
12
0.0
1

MONITOR
195
165
355
210
Cell Dist.(m)
real-width / max-pxcor
2
1
11

TEXTBOX
375
345
525
363
→ Walking Speed
12
0.0
1

SLIDER
375
360
520
393
speed
speed
0.1
1
0.5
.1
1
NIL
HORIZONTAL

SLIDER
375
305
520
338
noise
noise
0
90
15
5
1
NIL
HORIZONTAL

TEXTBOX
375
290
525
308
→ Noise
12
0.0
1

SLIDER
375
425
520
458
exit_rate
exit_rate
1
30
5
1
1
NIL
HORIZONTAL

TEXTBOX
530
35
545
490
I\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI
12
0.0
1

TEXTBOX
700
35
715
490
I\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI\nI
12
0.0
1

TEXTBOX
10
5
80
26
▼ File
18
0.0
1

TEXTBOX
190
5
340
25
▼ Environment
18
0.0
1

TEXTBOX
370
5
520
25
▼ Agents
18
0.0
1

TEXTBOX
535
5
685
30
▼ Analysis
18
0.0
1

TEXTBOX
705
5
79                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         